<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      french.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2025 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Afficher le code de chiffrement de l&apos;utilisateur',
    'email_body_new_user' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Un administrateur vous a créé un compte utilisateur sur Teampass. Lors de votre prochaine connexion, veuillez utiliser les identifiants suivants :<ul><li>Login: #login#</li><li>Mot de passe: #password#</li><li>Code de chiffrement : #code#</li></ul><br><br>Cordialement',
    'user_password' => 'Mot de passe utilisateur',
    'user_temporary_encryption_code' => 'Code de chiffrement utilisateur',
    'no_email_set' => 'Aucun email enregistré',
    'send_user_password_by_email' => 'Choisissez si le login utilisateur doit être envoyé par mail.<br> Si oui, cliquez sur le bouton Envoyer. <br><br>Sinon, cliquez sur le bouton Copier dans le presse papier pour l&apos;envoyer à l&apos;utilisateur par un autre moyen.<br>Cela devient votre responsabilité en tant qu&apos;administrateur de fournir le mot de passe de l&apos;utilisateur de façon sécurisée.',
    'admin_change_user_encryption_code_info' => 'Cette opération aura comme conséquence de réinitialiser le code de chiffrement pour cet utilisateur.',
    'send_by_email' => 'Envoyer par email',
    'filters' => 'Filtres',
    'show_user_password' => 'Afficher le mot de passe utilisateur',
    'open_website' => 'Accéder au site web',
    'mfa_for_roles' => 'L’authentification multifacteur est requise pour les utilisateurs dans les Rôles',
    'mfa_for_roles_tip' => 'Par défaut, une fois que l&apos;authentification multifacteurs est sélectionnée, cela est activé pour l&apos;ensemble des utilisateurs. Néanmoins, vous pouvez sélectionner les rôles pour lesquels vous souhaitez l&apos;activer.<br>Pas encore mis en place',
    'at_least_one_administrator_is_requested' => 'Au moins un administrateur est requis',
    'bad_code' => 'Mauvais code',
    'generating_keys' => 'Clés en cours de génération',
    'this_may_take_time' => 'Cela peut prendre quelques minutes',
    'disable_enable' => 'Désactiver/Activer',
    'user_disable_status' => 'Cochez la case pour désactiver ou laissez-la vide pour activer',
    'help_for_launching_items_encryption' => 'Il est maintenant nécessaire de générer les clés de la base de données pour votre compte. Merci de fournir votre code de chiffrement.',
    'managed_through_ad' => 'Géré via AD',
    'new_ldap_user_info' => 'Veuillez compléter la définition de l&apos;utilisateur',
    'email_body_user_added_from_ldap_encryption_code' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Vous avez maintenant un compte Teampass. Vous pouvez utiliser vos identifiants LDAP pour vous connecter.<br><br>A la première connexion, un code de chiffrement vous sera demandé, veuillez utiliser :<br><br><b>#enc_code#</b><br><br><br> Cordialement.',
    'settings_ldap_user_object_filter' => 'Filtre d&apos;objets utilisateur',
    'settings_ldap_user_object_filter_tip' => 'Le filtre à utiliser lors de la recherche d&apos;objets utilisateur. Si plusieurs filtres alors il est nécessaire de les séparer par une virgule (,). Exemple : (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Cette valeur est utilisée en plus de la base DN lors de la recherche et du chargement des utilisateurs. Si aucune valeur n&apos;est fournie, la recherche des sous-arbres commencera à partir de la base. Exemples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Identifiant DN utilisateur supplémentaire',
    'ldap_user_has_changed_his_password' => 'Votre mot de passe d&apos;authentification a été changé dans votre annuaire LDAP depuis votre dernière connexion à Teampass. Nous devons adapter votre clé de chiffrement. Veuillez fournir votre précédent mot de passe et l&apos;actuel.',
    'provide_your_previous_password' => 'Votre précédent mot de passe',
    'admin_change_user_password_info' => 'Cette opération réinitialisera le mot de passe actuel de l&apos;utilisateur sélectionné.',
    'sending_email_message' => 'Envoi de l&apos;email à l&apos;utilisateur, veuillez patienter',
    'change_your_password_info_message' => 'Merci de renseigner votre nouveau mot de passe d&apos;authentification et de le confirmer.',
    'user_has_to_change_password_info' => 'Le mot de passe utilisé actuellement a été généré. Il est préférable que vous le changiez, pour des raisons de sécurité.',
    'ready_to_go' => 'Prêt à l&apos;emploi',
    'passwords_not_the_same' => 'Les mots de passe fournis ne sont pas les mêmes',
    'inititialization' => 'Initialisation',
    'bad_password' => 'Mauvais mot de passe',
    'perform_checks' => 'Vérifications en cours',
    'email_body_temporary_encryption_code' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Des changements ont été effectués sur votre compte et nécessitent un nouveau chiffrement des éléments pour la sécurité des données. A votre prochaine connexion, veuillez utiliser le code suivant :<br><br><b>#enc_code#</b><br><br><br>Cordialement',
    'temporary_encryption_code' => 'Votre code de chiffrement temporaire',
    'renecyption_expected' => 'Il est maintenant nécessaire de régénérer vos clés en fonction de votre compte et privilèges.',
    'error_no_user_in_ad' => 'Utilisateur introuvable dans l&apos;AD !',
    'error_ad_user_expired' => 'Utilisateur expiré !',
    'error' => 'Erreur détectée',
    'hosts' => 'Hôtes',
    'settings_ldap_hosts_tip' => 'L&apos;option hôtes est un tableau d&apos;adresses IP ou de noms d&apos;hôtes situés sur votre réseau qui fournissent une base de données LDAP (séparés par une virgule). Vous pouvez insérer autant de serveurs que vous le souhaitez (un au minimum)',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'Le Distinguished Name (DN) à utiliser lors de l&apos;exécution des requêtes sur le serveur d&apos;annuaire. Exemples : o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Nom d&apos;utilisateur',
    'settings_ldap_username_tip' => 'Le Distinguished Name (DN) de l&apos;utilisateur que l&apos;application utilisera lors de la connexion au serveur d&apos;annuaire. Exemples: cn=administrator,cn=users,dc=ad,dc=example,dc=com',
    'settings_ldap_password_tip' => 'Le mot de passe de l&apos;utilisateur indiqué',
    'settings_ldap_port_tip' => 'L&apos;option de port est utilisée pour l&apos;authentification et la liaison avec votre serveur LDAP. Les ports par défaut sont déjà utilisés pour les connexions non SSL et SSL (389 et 636). N&apos;insérez un port que si votre serveur LDAP utilise un port unique.',
    'undefined' => 'Indéfini',
    'error_cannot_open_file' => 'Le fichier ne peut pas être ouvert',
    'provide_current_psk_and_click_launch' => 'Quand vous êtes prêt, cliquez sur le bouton Lancer',
    'start' => 'Commencer',
    'data_inconsistency' => 'Une donnée semble corrompue. Merci de recharger la page !',
    'one_time_code_expected' => 'Code à usage unique exigé',
    'data_are_missing' => 'Les données attendues sont manquantes',
    'one_time_code' => 'Code à usage unique',
    'provide_personal_one_time_code' => 'Veuillez fournir le code à usage unique que vous avez reçu par email',
    'change_authentification_type_to_ldap' => 'Changer le type d&apos;authentification en LDAP',
    'change_authentification_type_to_local' => 'Changer le type d&apos;authentification en base de données locale Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Le mot de passe utilisateur de l&apos;annuaire LDAP est utilisé pour l&apos;authentification',
    'local_user_password_is_used_for_authentication' => 'Le mot de passe utilisateur est utilisé pour l&apos;authentification',
    'provide_your_current_password' => 'Veuillez fournir votre mot de passe actuel',
    'current_password' => 'Mot de passe actuel',
    'password_is_not_correct' => 'Ce mot de passe n&apos;est pas correct',
    'ldap_password_change_warning' => 'Votre mot de passe de connexion a changé depuis la dernière connexion. Il est demandé de re-chiffrer toutes les clés à l&apos;aide de ce nouveau mot de passe. Pour cette opération, veuillez remplir le champ suivant avec votre ancien mot de passe ldap. L&apos;opération peut prendre plusieurs minutes.',
    'personal_items' => 'Eléments personnels',
    'logout_on_going' => 'Vous allez maintenant être déconnecté. Merci d&apos;utiliser votre nouveau mot de passe par la suite.',
    'fill_in_fields_and_hit_launch' => 'Merci de renseigner les champs requis et cliquer sur le bouton',
    'please_select_a_folder' => 'Veuillez sélectionner un dossier',
    'user_must_have_login_and_email' => 'L&apos;utilisateur doit avoir un login et un email',
    'user_has_this_role_in_teampass' => 'L&apos;utilisateur dispose de ce rôle',
    'select_role_to_create' => 'Sélectionner le rôle à créer',
    'adding_ldap_role_to_teampass' => 'Vous pouvez importer, dans Teampass, un rôle existant dans votre annuaire AD. Cela permettra d&apos;associer un utilisateur à ce rôle dans Teampass.',
    'add_user_to_role' => 'Ajouter ce rôle à cet utilisateur dans Teampass',
    'add_user_in_teampass' => 'Ajouter un utilisateur dans Teampass',
    'synchronized' => 'Synchronisé',
    'output' => 'Sortie',
    'remove_install_folder' => 'Le dossier d&apos;installation doit être supprimé',
    'list_users' => 'Liste des utilisateurs',
    'ldap_synchronization' => 'Synchronisation LDAP',
    'in_progress' => 'En cours',
    'clipboard_password_life_duration' => 'Délai, en secondes, avant l&apos;effacement du presse-papier',
    'clipboard_password_life_duration_tip' => 'Permet de définir un délai en secondes avant lequel le mot de passe  copié dans le presse-papier sera effacé. La valeur 0 désactive la fonctionnalité.',
    'clipboard_will_be_cleared' => 'Le mot de passe a été copié. Il sera bientôt supprimé...',
    'file_folder_not_accessible' => 'Le répertoire Files n&apos;est pas accessible',
    'error_missing_id' => 'Une erreur est survenue. Un ID est-il manquant... ?',
    'error_folder_not_allowed' => 'La sélection n&apos;est pas autorisée',
    'all_fields_mandatory' => 'Tous les champs sont nécessaires',
    'history_insert_entry' => 'Ajouter à l&apos;historique',
    'clear_form' => 'Vider le formulaire',
    'info_about_history_insertion' => 'Attention - cette fonctionnalité vous permet d&apos;insérer manuellement un événement dans l&apos;historique de l&apos;élément. Une fois l&apos;événement ajouté, il vous sera impossible de le supprimer. Notez également qu&apos;un ID de compte sera associé à cette insertion.',
    'select_all' => 'Tout sélectionner',
    'unselect_all' => 'Tout désélectionner',
    'no_data_to_display' => 'Aucune donnée à afficher ! Soit aucun répertoire n&apos;existe, soit vous n&apos;avez aucun accès.',
    'server' => 'Serveur',
    'data_refreshed' => 'Données rafraîchies',
    'loading_image' => 'Chargement de l&apos;image',
    'compare_with_another_role' => 'Comparer avec un autre rôle',
    'only_display_folders_to_depth' => 'Afficher les répertoires jusqu&apos;au niveau',
    'propagate_rights_to_descendants' => 'Propager les droits vers les descendants',
    'loading_data' => 'Chargement des données',
    'password_overview_delay' => 'Durée d&apos;affichage du mot de passe',
    'password_overview_delay_tip' => 'Permet de définir la durée d&apos;affichage en clair d&apos;un mot de passe à l&apos;utilisateur.',
    'select_date_showing_items_expiration' => 'Lister les objets expirés à compter du',
    'renewal_page_info' => 'Cette page permet d&apos;identifier les éléments expirés ou expirant prochainement.',
    'filename' => 'Nom de fichier',
    'exported_to_file' => 'Exporter dans le fichier',
    'operation_progress' => 'L&apos;opération est en cours',
    'exporting_items' => 'Exportation en cours',
    'select_folders_to_export' => 'Choisir les répertoires à exporter',
    'export_format_type' => 'Choisir le format d&apos;export',
    'export_items' => 'Export d&apos;objets',
    'loading_item' => 'Chargement de l&apos;objet',
    'otv_message' => 'Vous pouvez partager cet objet avec un invité. Cette vue permet à cet invité d’accéder à un certain nombre de champs de l&apos;objet sans avoir à s&apos;identifier. Merci de noter que le lien généré sera valide jusqu&apos;à expiration du 1er élément de configuration ci-dessous. Copier et partager le lien ci-dessous.',
    'no_sharekey_found' => 'Aucune clé de chiffrement trouvée pour ce fichier',
    'otv_link' => 'Lien à visualisation unique',
    'one_time_view' => 'Visualisation unique',
    'move_right_columns_separator' => 'Déplacer le séparateur de colonne sur la droite',
    'move_left_columns_separator' => 'Déplacer le séparateur de colonne sur la gauche',
    'form_presents_inconsistencies' => 'Le formulaire présente des incohérences. Merci de vérifier les champs en rouge.',
    'download' => 'Télécharger',
    'see' => 'Voir',
    'at_anyoneconmodify' => 'Tout le monde peut modifier',
    'disabled' => 'Désactivé',
    'enabled' => 'Activé',
    'confirmation_seems_wrong' => 'La confirmation semble erronée, veuillez corriger',
    'i_cannot_remember' => 'Je ne m&apos;en souviens pas',
    'i_cannot_remember_info' => 'Cette action est sans moyen de retour. Cela supprimera l&apos;ensemble des mots de passe présent dans les objets de votre répertoire personnel. Seuls les mots de passe seront supprimés, pas les objets.',
    'user_has_psk_info' => 'Nous avons identifié des objets personnels encodés avec une ancienne clé de salage. Cette étape consiste à les re-chiffrer avec votre nouvelle clé privée. Veuillez nous fournir votre clé de salage personnelle.',
    'files' => 'Fichiers',
    'logs' => 'Journaux',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Clés de chiffrement',
    'clearing_old_sharekeys' => 'Supprimer les anciennes clés partagées',
    'hit_launch_to_start' => 'Merci de cliquer le bouton pour exécuter',
    'password_changed' => 'Mot de passe à jour',
    'password_already_used' => 'Mot de passe déjà utilisé',
    'change_login_password' => 'Changer le mot de passe d&apos;authentification',
    'current_password_mandatory' => 'Le mot de passe actuel est requis',
    'objects_encryption_explanation' => 'Teampass a été mis à niveau vers une nouvelle version qui inclut un nouveau protocole de cryptage. Il attend de vous que vous re-chiffriez vos objets personnels. Pour cela, vous devez fournir votre clé de salage personnelle (PSK) actuelle. Une fois terminé, veuillez cliquer sur le bouton Lancer et attendre que le processus atteigne l&apos;étape finale. Cela peut prendre plusieurs minutes selon le nombre d&apos;objets.',
    'description_has_changed' => 'La description a changé',
    'number_of_folders_imported' => 'Nombre de répertoires importés',
    'number_of_items_imported' => 'Nombre d&apos;objets importés',
    'propagate' => 'Diffuser',
    'propagate_user_rights' => 'Propager les droits utilisateur',
    'register_new_yubiko_key' => 'Enregistrer une nouvelle clé Yubiko',
    'part_of_groups' => 'Appartient aux Rôles',
    'previous_value' => 'Valeur précédente',
    'no_previous_value' => 'Pas de valeur précédente',
    'no_data_selected' => 'Pas de donnée sélectionnée',
    'selected_items_to_be_imported' => 'Sélectionner les objets à importer',
    'cannot_open_file' => 'Le fichier ne peut pas être ouvert',
    'no_item_found' => 'Pas d&apos;élément trouvé',
    'reading_file' => 'Lecture du fichier en cours',
    'where_shall_items_be_created' => 'Destination des objets à créer',
    'target_folder' => 'Fichier cible',
    'select_file' => 'Choisissez le fichier',
    'data_type_for_import' => 'Commencez par choisir le type de source à importer',
    'get_tips_about_importation' => 'Quelques astuces relatives à l&apos;importation',
    'import_new_items' => 'Importer de nouveaux objets',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'pour',
    'request_access' => 'Demander un accès à l&apos;objet',
    'request_access_message' => 'Lorsque vous demandez l&apos;accès à un objet, un email est envoyé à l&apos;auteur. L&apos;auteur peut accepter ou refuser votre requête en vous ajoutant à la liste de restriction de l&apos;objet. Veuillez confirmer pour envoyer votre demande à l&apos;auteur.',
    'request_access_reason' => 'Fournissez la raison de votre demande',
    'error_provide_reason' => 'Merci de renseigner la raison de l&apos;accès à cet objet',
    'need_access' => 'Besoin de l&apos;accès ?',
    'item_with_restricted_access' => 'Elément avec accès restreint',
    'remaining_emails_to_send' => 'Nombre d&apos;emails restant à envoyer',
    'mfa_flash' => 'Flasher avec un smartphone',
    'import' => 'Importer',
    'export' => 'Exporter',
    'offline' => 'Hors ligne',
    'login_attempts_identified_since_last_connection' => 'Votre attention est requise. Au moins une tentative d&apos;identification depuis votre compte a été détectée depuis votre dernière connexion réussie. Veuillez vérifier et contacter votre administrateur local si vous n&apos;êtes pas l&apos;auteur de cette tentative d&apos;identification.',
    'last_login_attempts' => 'Dernières tentatives de connexion',
    'see_detail' => 'Voir le détail',
    'role_definition' => 'Définition du rôle',
    'not_yet_implemented' => 'Pas encore implémenté',
    '2factors_expected_for_admin' => 'L&apos;administrateur doit utiliser l&apos;authentification multifacteurs pour s&apos;identifier.',
    '2factors_expected_for_admin_tip' => 'Par défaut, un administrateur doit utiliser une méthode MFA pour se connecter. Si non activé, l&apos;administrateur n&apos;en aura pas besoin pour se connecter même si MFA est activé pour tout autre utilisateur.',
    'restore_done_now_logout' => 'La restauration de la base de données a été effectuée. Veuillez maintenant vous déconnecter pour rafraîchir les variables de session.',
    'backup_and_restore' => 'Sauvegarder et restaurer',
    'explanation_for_oneshot_backup' => 'explanation_for_oneshot_backup',
    'explanation_for_oneshot_restore' => 'explanation_for_oneshot_restore',
    'perform_backup' => 'Effectuer une sauvegarde',
    'perform_restore' => 'Effectuer une restauration',
    'backup_select' => 'Fichier de sauvegarde',
    'choose_file' => 'Choisir un fichier',
    'on_the_fly' => 'À la volée',
    'scheduled' => 'Programmé',
    'caution_on_field_encryption_change' => 'Attention - Sachez que la modification du type de cryptage nécessitera d&apos;analyser toutes les données existantes afin de modifier le cryptage dans la base de données.',
    'caution_while_deleting_field' => 'Attention - la suppression de ce champ entraînera la suppression des données liées dans les objets',
    'error_could_not_update_the_field' => 'Une erreur est survenue lors de la mise à jour du champ. Merci de recharger la page et de ré-essayer.',
    'caution_while_deleting_category' => 'Attention, en supprimant ce répertoire, tous les objets et sous-répertoires seront également effacés.',
    'your_attention_please' => 'Votre attention s&apos;il vous plaît',
    'all_fields_are_required' => 'Tous les champs sont requis',
    'position' => 'Position',
    'before' => 'Avant',
    'top' => 'Haut',
    'bottom' => 'Bas',
    'field' => 'Champ',
    'configuration' => 'Paramétrage',
    'definition' => 'Définition',
    'number_of_modified_attachments' => 'Nombre de pièces jointes modifiées',
    'files_not_encrypted' => 'Actuellement, les fichiers ne sont pas chiffrés. Pour des raisons de sécurité, vous devriez les chiffrer.',
    'files_already_encrypted' => 'Les fichiers sont déjà chiffrés. Vous ne devriez pas changer cette option, pour des raisons de sécurité.',
    'action_to_be_performed' => 'Action à réaliser',
    'last_execution' => 'Dernière exécution',
    'never_performed' => 'Jamais réalisé',
    'launch' => 'Lancer',
    'set_of_actions' => 'Actions possibles',
    'uploads' => 'Téléchargements',
    'uploads_configuration' => 'Paramètres de téléversement',
    'email_configuration' => 'Configuration de la messagerie',
    'email_configuration_test' => 'Tester la configuration de la messagerie',
    'send_a_test_email' => 'Envoyer un email de test',
    'manage_emails_not_sent' => 'Gérer les messages non envoyés',
    'email_send_backlog' => '#nb_emails# non envoyé·s',
    'send_waiting_emails' => 'Envoyer les emails en attente',
    'ip' => 'IP',
    'no_data_defined' => 'Aucune donnée n&apos;a été définie.',
    'adding_new_api_ip' => 'Ajout d&apos;une nouvelle adresse IP à la liste blanche.',
    'adding_new_api_key' => 'Ajout d&apos;une nouvelle clé d&apos;API',
    'api_configuration' => 'Paramètres de l&apos;API',
    'mfa_configuration' => 'Configuration de l&apos;authentification multifacteurs',
    'yubico_authentication_tip' => 'Veuillez visiter www.yobico.com for plus de détails.',
    'complexity_level_not_reached' => 'Niveau de complexité requise non atteint',
    'expected_complexity_level' => 'Niveau de complexité requis',
    'your_attention_is_required' => 'Merci de votre attention',
    'favorite' => 'Favori',
    'unfavorite' => 'Retirer favori',
    'you_need_to_select_at_least_one_folder' => 'Vous devez sélectionner au moins un répertoire',
    'no_value_defined_please_fix' => 'Aucune valeur définie ! Vous devriez le faire.',
    'apply' => 'Appliquer',
    'from' => 'De',
    'please_confirm_by_clicking_checkbox' => 'Merci de confirmer en cliquant la case à cocher',
    'date_range' => 'Période',
    'purge' => 'Purger',
    'belong_of_deleted_folder' => 'Appartient à un répertoire supprimé',
    'highlight_selected' => 'Mettre en évidence la sélection',
    'number_of_selected_objects' => 'Nombre d&apos;objets sélectionnés',
    'confirm_selection_restore' => 'Merci de confirmer la restauration des objets sélectionnés.',
    'confirm_selection_delete' => 'Merci de confirmer la suppression des objets sélectionnés.',
    'refreshing' => 'Rafraichissement',
    'empty_list' => 'Liste vide',
    'deleted_folders' => 'Répertoires supprimés',
    'deleted_items' => 'Objets supprimés',
    'recycled_bin' => 'Corbeille',
    'database' => 'Base de données',
    'renewal' => 'Renouvellement',
    'renewal_delay' => 'Délais avant renouvellement',
    'please_confirm_deletion' => 'Merci de confirmer la suppression',
    'caution' => 'Attention',
    'role_not_exist' => 'Ce rôle n&apos;existe pas !',
    'role_can_edit_any_visible_item' => 'Ce rôle peut éditer n&apos;importe quel objet visible',
    'role_can_edit_any_visible_item_tip' => 'Le réglage normal consiste à laisser cette case décochée. En effet, lorsqu&apos;elle est cochée, elle permet à un utilisateur faisant partie de ce rôle de modifier tout élément que l&apos;utilisateur peut ouvrir, ce qui conduit à un statut non sécurisé. Elle ne doit être cochée que pour une période de temps et un besoin spécifique.',
    'edit_allowed' => 'Modification autorisée',
    'delete_allowed' => 'Suppression autorisée',
    'add_allowed' => 'Ajout autorisé',
    'edit_not_allowed' => 'Modification non autorisée',
    'delete_not_allowed' => 'Suppression non autorisée',
    'select_a_role' => 'Sélectionner un rôle',
    'access_rights_for_user' => 'Droits d&apos;accès pour l&apos;utilisateur',
    'logs_for_user' => 'Journaux pour l&apos;utilisateur',
    'please_confirm' => 'Veuillez confirmer',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'En cochant cette case, vous confirmez la suppression de cet utilisateur.',
    'fields_with_mandatory_information_are_missing' => 'Certains champs obligatoires ne sont pas renseignés',
    'enable_personal_folder_for_this_user' => 'Activer la fonctionnalité "dossier personnel" pour cet utilisateur.',
    'special' => 'Spéciale',
    'administrator' => 'Administrateur',
    'super_manager' => 'Gestionnaire Teampass',
    'manager' => 'Gestionnaire',
    'read_only' => 'Lecture seule',
    'privileges' => 'Privilèges',
    'roles' => 'Rôles',
    'user_definition' => 'Définition de l&apos;utilisateur',
    'no_selection_done' => 'Aucune sélection',
    'tick_confirmation_box' => 'Merci de cocher la case pour confirmer',
    'next_list_to_be_deleted' => 'Cette liste sera supprimée',
    'delete_folders' => 'Supprimer des répertoires',
    'submit' => 'Soumettre',
    'label' => 'Intitulé',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Complexité minimale du mot de passe',
    'access_right_for_roles' => 'Droits d&apos;accès pour les rôles',
    'create_without_password_minimal_complexity_target' => 'Autoriser la création de nouveaux éléments sans complexité minimale de mot de passe',
    'edit_without_password_minimal_complexity_target' => 'Autoriser l&apos;édition d&apos;éléments sans complexité minimale de mot de passe',
    'add_new_folder' => 'Ajouter un répertoire',
    'new' => 'Nouveau',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Authentification multifacteurs',
    'google_2fa' => 'Vérification Google en 2 étapes',
    'duo_security' => 'Sécurité duo',
    'yubico' => 'Authentificateur Yubico',
    'website_canal' => 'Cliquer pour accéder à Teampass.net',
    '2fa_credential_not_correct' => 'L&apos;identifiant 2FA n&apos;est pas correct',
    'no_change_performed' => 'Aucun changement réalisé',
    'password_strength' => 'Complexité',
    'new_password_required' => 'Un nouveau mot de passe est requis',
    'limited_search' => 'Recherche limitée',
    'empty_psk' => 'Clé de salage manquante',
    'currently_no_favorites' => 'Vous n&apos;avez aucun favori',
    'favorites' => 'Favoris',
    'confirm_item_move' => 'Déplacement ... merci de confirmer ?',
    'copy_to_clipboard' => 'Copié dans le presse-papier',
    'please_wait_while_loading' => 'Merci de patienter le temps du chargement des données',
    'defect_report' => 'Rapport de défaut',
    'actions' => 'Actions',
    'no_user' => 'Mauvais utilisateur',
    'generate_api_token' => 'Générer un nouveau jeton d&apos;API',
    'upload_feature' => 'Téléversement',
    'profile' => 'Profil',
    'language' => 'Langue',
    'upload_new_avatar' => 'Sélectionner un avatar (.PNG)',
    'settings' => 'Paramètres',
    'created_items' => 'Objets créés',
    'modification_performed' => 'Modifications réalisées',
    'items_opened' => 'Objets consultés',
    'passwords_seen' => 'Mots de passe consultés',
    'nothing_to_save' => 'Rien à sauvegarder',
    'notification_engaged' => 'Vous serez notifier sur modification',
    'notification_not_engaged' => 'Vous ne serez pas notifier sur modification',
    'viewed_number' => 'Nombre de vues',
    'automatic_deletion_engaged' => 'Suppression automatique',
    'auto_update_enabled' => 'Modification automatique du mot de passe utilisateur activée. Prochain changement prévu',
    'copy_folder' => 'Copier le dossier',
    'select_source_folder' => 'Sélectionner le répertoire à copier',
    'select_destination_folder' => 'Sélectionner le répertoire de destination',
    'delete_folder' => 'Supprimer',
    'select_folder_to_delete' => 'Sélectionner le répertoire à supprimer',
    'folder_delete_confirm' => 'Le répertoire sélectionné ainsi que tous les objets seront supprimés. Merci de confirmer en cochant la case.',
    'json_error_format' => 'Format JSON corrompu',
    'password_cannot_be_empty' => 'Un mot de passe doit être saisi',
    'password_too_long' => 'Le mot de passe est trop long',
    'error_no_action_identified' => 'Aucune action identifiée',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Sauvegardes',
    'api' => 'API',
    'add_folder' => 'Ajouter un nouveau répertoire',
    'select_folder_parent' => 'Sélectionner le répertoire parent',
    'add' => 'Ajouter',
    'key_is_not_correct' => 'La clé de session n&apos;est pas conforme',
    'suggestion_information' => 'Suggérer un changement ? Merci de renseigner le formulaire et valider pour informer l&apos;auteur.',
    'email_address' => 'Email',
    'enter_email' => 'Saisir l&apos;email',
    'notification' => 'Notification',
    'notify_on_change' => 'Me notifier en cas de changement',
    'notification_message' => 'Vous pouvez utiliser cette option pour recevoir des notifications lors de changements réalisés sur cet objet.',
    'share_item' => 'Partager',
    'share_item_message' => 'Vous pouvez partager cet object. Pour cela, indiquer un email et cliquer le bouton.',
    'delete_item_message' => 'Vous avez décider de supprimer cet objet. Merci de confirmer votre choix.',
    'warning' => 'Attention',
    'information' => 'Information',
    'perform' => 'Réaliser',
    'delete_item' => 'Supprimer',
    'copy_item' => 'Copier',
    'new_item' => 'Nouveau',
    'error_not_allowed_to_edit_item' => 'Vous n&apos;êtes pas autoriser à éditer cet objet',
    'error_not_allowed_to_access_this_folder' => 'Vous n&apos;êtes pas autoriser à accéder à ce répertoire',
    'error_personal_saltkey_is_not_set' => 'Votre clé de salage personnelle n&apos;est pas fournie.',
    'provide_your_personal_saltkey' => 'Merci de fournir votre clé de salage personnelle',
    'no_fields' => 'Aucun champ pour cet objet',
    'uploaded' => 'Téléversé',
    'changes_ongoing' => 'Certains changements n&apos;ont pas été sauvegardé. Confirmez-vous la fermeture ?',
    'no_file_to_upload' => 'Aucun fichier à téléverser',
    'add_files_and_click_start' => 'Sélectionner des fichiers et cliquer le bouton.',
    'select_files' => 'Sélectionner des fichiers',
    'attached_files' => 'Fichiers attachés',
    'visible_by' => 'Visible par',
    'anounce_item_by_email' => 'Informer des utilisateurs',
    'select_users_if_needed' => 'Sélectionner les utilisateurs à informer',
    'allow_item_to_be_deleted' => 'Autoriser la suppression de cet objet au critère',
    'item_deleted_after_being_viewed_x_times' => 'Après avec été vue X fois',
    'item_deleted_after_date' => 'Après une date prédéfinie',
    'password' => 'Mot de passe',
    'save' => 'Sauvegarder',
    'folder' => 'Dossier',
    'main' => 'Principal',
    'fields' => 'Champs',
    'details' => 'Détails',
    'no_special_restriction' => 'Sans restriction',
    'generate_otv_link' => 'Gérérer un lien de visualisation unique',
    'no_custom_fields' => 'Pas de champs personnalisés',
    'no_attachment' => 'Pas de pièce jointe',
    'logout_confirm' => 'Se déconnecter ? Veuillez confirmer.',
    'saved' => 'Sauvegardé',
    'attachments' => 'Fichiers joints',
    'success' => 'Succès',
    'server_answer_error' => 'Une erreur est survenue. La réponse du serveur ne peut pas être interprétée !',
    'server_returned_data' => 'Données retournées',
    'version_alone' => 'version',
    'statistics' => 'Statistiques',
    'options' => 'Options',
    'users' => 'Utilisateurs',
    'folders' => 'Dossiers',
    'find_message' => 'objets trouvés',
    'auto_update_server_password_info' => 'En cliquant sur le bouton COMMENCER, les différentes actions seront réalisées :<ul><li>Une connexion SSH sera ouverte avec le serveur Linux en utilisant les identifiants et l&apos;URL fournis,</li><li>Le mot de passe de l&apos;utilisateur sera changé,</li><li>Le nouveau mot de passe sera sauvegardé dans Teampass,</li><li>La connexion SSH sera fermée.</li></ul><br><b>Merci de vous assurer que l&apos;utilisateur dispose des privilèges Root sur le serveur avant de commencer (sinon vous disposez de champs supplémentaires pour saisir les identifiants d&apos;un compte root).',
    'share' => 'Partager',
    'notify' => 'Notifier',
    'error_no_selected_folder' => 'Vous devez sélectionner un dossier',
    'email_subject_item_updated' => 'Mot de passe mis à jour',
    'email_body_item_updated' => 'Bonjour,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Vous avez demandé à être informé des modifications apportées à l&apos;élément `#item_label#` dans le dossier `#folder_name#`.<br ><br>L&apos;utilisateur <b>#name# #lastname#</b> a effectué au moins une modification.<br><br>Vous pouvez le voir en cliquant sur le lien suivant <a href=&apos;#url#/index.php?page=items&group=#item_category#&id=#item_id#&apos;>ICI</a>.<br><br>Cordialement',
    'import_kp_finished' => 'L&apos;importation depuis KeePass est maintenant terminée ! Par défaut, le niveau de complexité des nouveaux dossiers a été défini à &apos;Moyen&apos;. Vous devriez peut-être le changer en fonction de vos besoins.',
    'password_is_empty' => 'L&apos;élément n&apos;a pas de mot de passe',
    'bug_report_to_github' => 'Complétez le contenu du rapport, copiez le contenu dans le presse-papier et collez-le dans un nouveau rapport dans Github.',
    'open_bug_report_in_github' => 'Ouvrir un ticket sur Github',
    'bugs_page' => 'Pour tout problème, merci de créer un ticket.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Permettre la modification par n&apos;importe qui ayant le même rôle que les éléments importés.',
    'import_csv_anyone_can_modify_txt' => 'Permettre la modification par n&apos;importe qui des éléments importés.',
    'settings_upload_imageresize_options' => 'Les Images doivent-elles être redimensionnées ?',
    'user_not_exists' => 'Cet utilisateur n&apos;existe pas !',
    'auto_create_folder_role' => 'Créer un nouveau dossier et un rôle pour',
    'start_upload' => 'Lancer le chargement des nouveaux fichier',
    'error_upload_runtime_not_found' => 'Téléversement : aucun environnement d&apos;exécution trouvé.',
    'user_profile_api_key' => 'Votre clé API',
    'index_change_pw' => 'Changer votre mot de passe',
    'admin_2factors_authentication_setting' => 'Activer l&apos;authentification Google en deux étapes',
    'admin_2factors_authentication_setting_tip' => 'L&apos;authentification Google en deux étapes permet d&apos;accroître la sécurité de connexion des Utilisateurs. Dès qu&apos;un utilisateur veut se connecter, un code à usage unique est généré. Ce code doit être scanné et fourni par l&apos;utilisateur en plus de son mot de passe traditionnel.<br />ATTENTION : Cette fonctionnalité nécessite une connexion permanente à Internet ainsi qu&apos;un smartphone',
    'admin_ga_website_name' => 'Nom affiché pour Teampass  dans Google Authenticator',
    'admin_ga_website_name_tip' => 'Ce nom sera affiché pour le code d&apos;identification dans l&apos;application Google Authenticator',
    'api_whitelist_ips' => 'Liste blanche des IP d&apos;API',
    'api_whitelist_ips_tip' => 'Si aucune adresse IP de client API n&apos;est explicitement répertoriée ici, alors n&apos;importe quelle adresse IP est autorisée.',
    'email_share_item_subject' => '[TeamPass] Un élément a été partagé avec vous',
    'email_share_item_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br><u>#tp_user#</u> a partagé l&apos;élément <b>#tp_item#</b> avec vous.<br>Cliquez le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br>Cordialement.',
    'index_maintenance_mode_admin' => 'Mode Maintenance activé. Les Utilisateurs ne peuvent pas se connecter à TeamPass.',
    '2fa_authentication_selector' => 'Authentification double',
    'upload_empty_file' => 'Téléverser des fichiers vides',
    'upload_any_extension_file' => 'Téléverser tout type d&apos;extension de fichier',
    'upload_any_extension_file_tip' => 'Quand activé, cette option permet aux utilisateurs d&apos;attacher tout type de fichier aux objets.',
    'log_in' => 'Connexion',
    'create_item_based_upon_template' => 'Activer le Modèle par Objet',
    'create_item_based_upon_template_tip' => 'Quand activée, cette fonction permet à l&apos;auteur de choisir un modèle réalisé à partir des Champs Spéciaux. A noter que cela ne fonctionnera que si l&apos;option Champs Spéciaux est activée.',
    'main_template' => 'Utiliser comme Modèle',
    'is_mandatory' => 'Est obligatoire',
    'error_field_is_mandatory' => 'Au moins un champ spécial est obligatoire.',
    'restrict_visibility_to' => 'Uniquement visible par',
    'every_roles' => 'Tous les rôles',
    'masked_text' => 'Texte masqué',
    'textarea' => 'Zone de texte',
    'admin_yubico_authentication_setting' => 'Activer la double identification avec Yubico',
    'yubico_user_id' => 'ID client',
    'yubico_user_key' => 'CLE secrète',
    'yubico_bad_code' => 'Mauvaises informations Yubico',
    'press_your_yubico_key' => 'Toucher la clé Yubico',
    'human_resources' => 'Super gestionnaire',
    'settings_secure_display_image' => 'Activer la sécurisation de prévisualisation des images',
    'settings_secure_display_image_tip' => 'Sécuriser la prévisualisation des images permet de réaliser la lecture de l&apos;image via le moteur de PHP quand un utilisateur demande un affichage d&apos;une image. Avantage: permet de sauvegarder les pièces jointes hors du domaine dans un dossier serveur inaccessible. Inconvéniant : l&apos;affichage de l&apos;image est légèrement ralentie.',
    'user_ga_code' => 'Envoyer le code Google Authenticator à l&apos;utilisateur par email',
    'error_no_email' => 'Cet utilisateur n&apos;a pas de courriel de défini !',
    'error_no_user' => 'Aucun utilisateur trouvé !',
    'email_ga_subject' => 'Votre code Google Authenticator pour Teampass',
    'email_ga_text' => 'Bonjour,<br><br>Cet email a été généré depuis votre gestionnaire de mots de passe Teampass.<br><br>Votre administrateur vous demande d&apos;utiliser une double authentification pour vous connecter à Teampass.<br>Lors de votre première connexion à Teampass, merci de bien vouloir recopier le code suivant dans le champ "Code d&apos;identification" : <br><br>----------------------<br>#2FACode#<br>----------------------<br><br>Vous aurez ensuite la possibilité de paramètrer votre application Google Authenticator pour obtenir vos codes temporaire d&apos;identification.<br /><br />Salutations',
    'settings_attachments_encryption' => 'Activer le chiffrement des fichiers joints aux Éléments',
    'settings_attachments_encryption_tip' => 'CETTE OPTION PEUT CORROMPRE LES FICHIERS JOINTS EXISTANTS. Merci de lire la suite avec attention. Si activée, cette option chiffrera les fichiers joints aux Éléments sur le serveur. L&apos;algorithme de chiffrement utilise le sel défini pour Teampass. Cela requiert également un peu de ressource supplémentaire de la part du serveur. ATTENTION : en cas de changement de stratégie, il est nécessaire de faire tourner le script permettant d&apos;adapter les fichiers joints existants. Pour cela, voir l&apos;onglet "Actions spécifiques".',
    'admin_action_attachments_cryption' => 'Déchiffrer ou chiffrer les fichiers joints aux Éléments',
    'admin_action_attachments_cryption_tip' => 'ATTENTION : cette opération ne DOIT être faite UNIQUEMENT après avoir modifié l&apos;option associée dans la page Paramètres. Merci de réaliser une sauvegarde du dossier &apos;upload&apos; avant de procéder.',
    'encrypt' => 'Chiffrer',
    'decrypt' => 'Déchiffrer',
    'ga_identification_code' => 'Code d&apos;identification',
    'ga_enter_credentials' => 'Merci de saisir vos identifiants de connexion',
    'ga_bad_code' => 'Le code Google Authenticator est faux',
    'settings_get_tp_info' => 'Charger automatiquement des informations à propos de Teampass',
    'settings_get_tp_info_tip' => 'Cette option chargera dans la page d&apos;administration des informations concernant les versions et librairies utilisées.',
    'settings_offline_mode' => 'Activer le mode Hors-Ligne',
    'settings_offline_mode_tip' => 'Le mode Hors-Ligne permet d&apos;exporter les Éléments dans un fichier HTML qui peut être lu avec un simple navigateur Internet. Les éléments sont chiffrés avec la clé saisie par l&apos;Utilisateur.',
    'offline_mode_key_level' => 'Niveau de chiffrement minimum de la clé du mode Hors-Ligne',
    'categories' => 'Catégories',
    'no_category_defined' => 'Aucune Catégorie n&apos;existe',
    'confirm_deletion' => 'Confirmer la suppression ?',
    'settings_item_extra_fields' => 'Permettre l&apos;ajout des champs complémentaires (par Catégories) à la définition des Éléments',
    'settings_item_extra_fields_tip' => 'Cette fonction permet d&apos;ajouter des champs personnalisés aux Éléments. Ces champs sont créés par un Administrateur et organisés en Catégories. Les données sauvegardées sont chiffrées. Attention, cette fonction consomme plus de requêtes SQL (environ 5 par champ lors de la mise à jour d&apos;un Élément) et peut surcharger votre serveur. Cela dépend de votre serveur.',
    'settings_ldap_type' => 'Type de serveur LDAP',
    'server_time' => 'Horaire serveur',
    'settings_tree_counters' => 'Montrer des compteurs dans l&apos;arborescence',
    'settings_tree_counters_tip' => 'Cette option affiche pour chaque dossier 3 compteurs : le nombre d&apos;éléments dans le dossier; le nombre d&apos;éléments dans l&apos;ensemble des sous-dossiers; le nombre de sous-dossiers.',
    'admin_action_check_pf' => 'Actualiser les Dossiers Personnels des utilisateurs (les créer s&apos;ils n&apos;existent pas)',
    'enable_personal_folder_feature_tip' => 'Une fois activé, il est nécessaire de lancer manuellement le script de mise à jour des dossiers personnels pour les utilisateurs existants. Cela ne créera les dossiers personnels que pour les utilisateurs n&apos;en n&apos;ayant pas à ce jour. Le script &apos;".$txt[&apos;admin_action_check_pf&apos;]."&apos; est accessible dans l&apos;onglet &apos;".$txt[&apos;admin_actions_title&apos;]."&apos;.',
    'administrators_only' => 'Administrateurs uniquement',
    'managers_of' => 'Managers du Role',
    'managed_by' => 'Administré par',
    'settings_enable_sts' => 'Renforcer la sécurité relative à HTTPS -- Attention : bien lire l&apos;info-bulle',
    'settings_enable_sts_tip' => 'Cette option force le protocole HTTPS STS. STS permet de déjouer les attaques &apos;Man-in-the-Middle&apos;. Il est IMPÉRATIF de disposer d&apos;un certificat SSL valide pour pouvoir l&apos;utiliser. Ne pas activer l&apos;option avec un certificat auto-signé ! Vous devez vous assurer d&apos;avoir activé l&apos;option &apos;SSLOptions +ExportCertData&apos; SSL dans la configuration d&apos;Apache.',
    'settings_anyone_can_modify_bydefault' => 'Activer l&apos;option &apos;<b><i>Tout le monde peut modifier</b></i>&apos; par défaut',
    'to' => 'à',
    'settings_upload_maxfilesize_tip' => 'Taille maximum autorisée. Cette taille doit être cohérente avec les paramètrages du serveur.',
    'settings_upload_docext_tip' => 'Les types de Documents. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_imagesext_tip' => 'Les types d&apos;Images. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_pkgext_tip' => 'Les types de Compression. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_otherext_tip' => 'Les autres types. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_imageresize_options_tip' => 'Quand activée, cette option permet de redimensionner les Images au format indiqué ci-dessous.',
    'settings_upload_maxfilesize' => 'Taille maximum par fichier (en Mo)',
    'settings_upload_docext' => 'Extensions de Documents autorisées',
    'settings_upload_imagesext' => 'Extensions de Images autorisées',
    'settings_upload_pkgext' => 'Extensions de fichiers de Compression autorisées',
    'settings_upload_otherext' => 'Autres extensions autorisées',
    'settings_upload_imageresize_options_w' => 'Redimensionnement des Images en Largeur (en pixels)',
    'settings_upload_imageresize_options_h' => 'Redimensionnement des Images en Hauteur (en pixels)',
    'settings_upload_imageresize_options_q' => 'Qualité de l&apos;Image redimensionnée',
    'settings_importing' => 'Permettre d&apos;importer des données depuis des fichiers CVS/KeyPass',
    'admin_proxy_ip' => 'Adresse IP du proxy',
    'admin_proxy_ip_tip' => 'Si votre connexion intenet passe par un proxy, indiquer ici son IP. Sinon, laisser vide.',
    'admin_proxy_port' => 'Port du proxy',
    'admin_proxy_port_tip' => 'Si vous avez indiqué une IP pour le proxy, indiquez ici son port. En général 8080. Sinon, laisser vide.',
    'settings_ldap_elusers' => 'Utilisateurs locaux de TeamPass uniquement',
    'settings_ldap_elusers_tip' => 'Cette fonction autorise les utilisateurs de la base de données de s&apos;identifier via LDAP. Désactiver ceci si vous voulez utiliser un annuaire LDAP.',
    'db_items_edited' => 'Éléments actuellement en cours d&apos;édition',
    'item_edition_start_hour' => 'Édition démarrée depuis',
    'settings_delay_for_item_edition' => 'Après quelle durée, en minutes, l&apos;édition d&apos;un Élément est-elle considérée comme échouée',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Lorsqu&apos;un Élément est édité, ce dernier est verrouillé de façon à interdire toute autre édition parallèle.<br />Cette option permet de supprimer ce verrou automatiquement dès lors qu&apos;une durée en minute est écoulé. La valeur 0 indique que le verrou ne sera jamais supprimé automatiquement.</span>',
    'db_users_logged' => 'Utilisateurs actuellement connectés',
    'action' => 'Action',
    'login_time' => 'Connecté depuis',
    'lastname' => 'Nom',
    'user_login' => 'Identifiant',
    'role' => 'Rôle',
    'error_role_exist' => 'Ce Rôle existe déjà !',
    'error_no_edition_possible_locked' => 'Édition impossible. Cet élément est verrouillé par le gestionnaire de tâches',
    'select' => 'Parcourir…',
    'items' => 'Éléments',
    'enable_personal_saltkey_cookie' => 'La clé personnelle de salage est sauvegardée dans un cookie',
    'personal_saltkey_cookie_duration' => 'Durée avant expiration du cookie de la clé personelle de salage',
    'admin_email_smtp_server' => 'Serveur SMTP',
    'admin_email_auth' => 'Le serveur SMTP requiert une authentification',
    'admin_email_auth_username' => 'Identifiant',
    'admin_email_auth_pwd' => 'Mot de passe',
    'admin_email_port' => 'Port du serveur',
    'admin_email_from' => 'E-mail de l&apos;expéditeur',
    'admin_email_from_name' => 'Nom de l&apos;expéditeur',
    'admin_email_test_configuration_tip' => 'Ce test va envoyer un e-mail à l&apos;adresse indiquée. Si vous ne le recevez pas, merci de vérifier le paramétrage.',
    'admin_email_test_subject' => '[TeamPass] E-mail de test',
    'admin_email_test_body' => 'Bonjour,<br /><br />E-mail envoyé avec succès.<br / ><br />Salutations',
    'admin_email_result_ok' => 'E-mail envoyé à #email# ... vérifiez votre boite de réception',
    'email_bodyalt_item_updated' => 'Le mot de passe de #item_label# a été mis à jour.',
    'admin_email_send_backlog_tip' => 'Ce script permet de forcer l&apos;envoi des e-mails dans la file d&apos;attente de la base de données.<br /> Cela peut prendre plusieurs minutes en fonction du nombre d&apos;e-mails à envoyer.',
    'please_wait' => 'Merci de patienter',
    'admin_path_to_files_folder' => 'Chemin du dossier Fichiers (chemin complet)',
    'admin_path_to_files_folder_tip' => 'Le dossier Fichiers est utilisé pour sauvegarder tous les fichiers générés par TeamPass ainsi que certains fichiers envoyés.<br />IMPORTANT : pour des raisons de sécurité, ce dossier ne devrait pas être dans le dossier WWW de votre serveur. Il devrait être mis dans un endroit protégé avec une règle de redirection.<br />IMPORTANT 2 : Il serait bien de rajouter une tâche périodique pour supprimer son contenu.',
    'admin_path_to_upload_folder_tip' => 'Le dossier d&apos;Envoi contient tous les fichiers attachés à vos Éléments.<br />IMPORTANT : Pour des raisons de sécurité, ce dossier ne devrait pas être dans le dossier WWW de votre serveur. Il devrait être mis dans un endroit protégé avec une règle de redirection.<br />IMPORTANT 2 : Ce dossier ne doit absolument pas être nettoyé ! Ces fichiers sont associés à vos Éléments.',
    'pdf_password_warning' => 'Vous devez fournir une clé de chiffrement',
    'admin_pwd_maximum_length' => 'Longueur maximale des mots de passe',
    'admin_pwd_maximum_length_tip' => 'La valeur par défaut est fixée à 40 caractères. Il est important de savoir qu&apos;une taille plus grande aura un impact sur les performances de l&apos;outil. En effet plus la longueur du mot de passe est grande et plus il faut de temps au serveur pour chiffrer, déchiffrer et afficher les éléments',
    'settings_insert_manual_entry_item_history' => 'Permettre l&apos;insertion manuelle dans l&apos;Historique',
    'settings_insert_manual_entry_item_history_tip' => 'Il peut être parfois utile de saisir une entrée dans l&apos;historique d&apos;un Élément. En activant cette fonction, cela devient possible.',
    'admin_path_to_upload_folder' => 'Chemin du dossier d&apos;Envoi',
    'admin_setting_enable_delete_after_consultation' => 'L&apos;élément consulté peut être automatiquement supprimé',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Quand activée, cette option permet à l&apos;auteur de l&apos;élément de décider si ce dernier devra être automatiquement supprimé après avoir été consulté X fois.</span>',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Notifier par email lorsque l&apos;élément est consulté',
    'share_sent_ok' => 'E-mail envoyé',
    'see_item_title' => 'Détails de l&apos;élément',
    'email_on_open_notification_subject' => '[TeamPass] Notification suite à la consultation d&apos;un élément',
    'email_on_open_notification_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>#tp_user# a consulté l&apos;élément &apos;#tp_item#&apos;.<br>Cliquez sur le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br>Cordialement.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Votre nouveau compte',
    'email_new_user_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>Un Administrateur vous a créé un compte pour TeamPass.<br>Vos identifiants de connexion sont les suivants :<br>- Identifiant : #tp_login#<br>- Mot de passe : #tp_pw#<br><br> Cliquez sur le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br> Cordialement',
    'error_empty_data' => 'Aucune donnée à traiter !',
    'error_not_allowed_to' => 'Vous n&apos;etes pas autorisé à faire cela !',
    'request_access_ot_item' => 'Demander un accès au créateur',
    'email_request_access_subject' => '[TeamPass] Demande d&apos;accès à un élément',
    'email_request_access_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>L&apos;utilisateur #tp_user# a demandé un accès à &apos;#tp_item#&apos;.<br>Cette demande est accompagnée du justificatif suivant:<br><br><i>"#tp_reason#"</i><br><br>Merci de revoir et confirmer ou pas l&apos;accès.<br><br>Cordialement.',
    'admin_action_change_salt_key' => 'Changer la clé de salage principale',
    'nb_items_by_query' => 'Nombre d&apos;éléments à afficher par requête',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Plus d&apos;éléments signifie plus de temps pour les afficher.<br>Sélectionner &apos;auto&apos; pour laisser l&apos;outil choisir le nombre d&apos;éléments à afficher en fonction de la taille de l&apos;écran.<br>Sélectionner &apos;max&apos; pour forcer l&apos;affichage de la liste complète en une seule fois.<br>Sélectionner un nombre fixe d&apos;éléments à afficher à chaque nouvelle requête.</span>',
    'open_url_link' => 'Ouvrir dans une nouvelle page',
    'error_pw_too_long' => 'Mot de passe trop long ! Maximum 40 caractères.',
    'at_restriction' => 'Restriction',
    'pw_encryption_error' => 'Erreur de déchiffrement du mot de passe !',
    'enable_send_email_on_user_login' => 'Envoyer un email aux Administrateurs lorsqu&apos;un utilisateur se connecte',
    'email_subject_on_user_login' => '[TeamPass] Un utilisateur s&apos;est connecté',
    'email_body_on_user_login' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>L&apos;utilisateur #tp_user# s&apos;est connecté à TeamPass le #tp_date# à #tp_time#.<br><br>Cordialement.',
    'account_is_locked' => 'Ce compte est bloqué',
    'activity' => 'Activité',
    'add_role_tip' => 'Ajouter un rôle',
    'admin' => 'Administration',
    'admin_action_db_backup' => 'Réaliser une sauvegarde de la base de donnée',
    'admin_action_db_clean_items' => 'Retirer tous les éléments orphelins de la base de donnée',
    'admin_action_db_clean_items_tip' => 'Cela ne fera que supprimer tous les éléments qui sont associés à un dossier ayant été supprimé. Pensez à faire une sauvegarde avant',
    'admin_action_db_optimize' => 'Optimiser la base de donnée',
    'admin_action_db_restore' => 'Restaurer la base de donnée',
    'admin_action_purge_old_files' => 'Purger les vieux fichier',
    'admin_action_purge_old_files_tip' => 'Cela va supprimer les fichiers temporaires de plus de 7 jours',
    'admin_action_reload_cache_table' => 'Reconstruire la table Cache',
    'admin_action_reload_cache_table_tip' => 'Cela permet de reconstruire entièrement la table Cache. Cette action peut-être réalisée de temps en temps',
    'admin_help' => 'Aide',
    'admin_ldap_configuration' => 'Configuration LDAP',
    'admin_main' => 'Informations',
    'admin_misc_cpassman_dir' => 'Chemin d&apos;accès à TeamPass',
    'admin_misc_cpassman_url' => 'URL complète de TeamPass',
    'admin_misc_custom_login_text' => 'Texte personnel sur l&apos;écran de connexion',
    'admin_misc_custom_logo' => 'URL complète vers un logo personnel',
    'admin_misc_favicon' => 'URL du fichier favicon',
    'admin_settings' => 'Paramètres',
    'admin_settings_title' => 'Paramètres',
    'admin_setting_activate_expiration' => 'Activer l&apos;expiration des éléments',
    'admin_setting_activate_expiration_tip' => 'Quand activée, cette option permet de ne pas afficher les éléments expirés.',
    'admin_views' => 'Vues',
    'alert_message_done' => 'Fait !',
    'all' => 'tous',
    'anyone_can_modify' => 'Cet élément peut être modifié par tout utilisateur',
    'at' => 'à',
    'at_category' => 'Dossier',
    'at_copy' => 'Copie faite',
    'at_delete' => 'Suppression',
    'at_description' => 'Description.',
    'at_label' => 'Label',
    'at_login' => 'Login',
    'at_moved' => 'Déplacé',
    'at_personnel' => 'Personnel',
    'at_restored' => 'Restauré',
    'at_shown' => 'Vu',
    'at_url' => 'URL',
    'author' => 'Auteur',
    'authorized_groups' => 'Dossiers autorisés',
    'auth_creation_without_complexity' => 'Autoriser la création d&apos;un élément sans que le niveau de complexité ne soit atteint',
    'auth_modification_without_complexity' => 'Autoriser la modification d&apos;un élément sans que le niveau de complexité ne soit atteint',
    'cancel' => 'Annuler',
    'can_create_root_folder' => 'Peut créer un dossier à la racine',
    'changelog' => 'Évolutions',
    'close' => 'Fermer',
    'complexity' => 'Complexité',
    'complex_asked' => 'Complexité requise',
    'complex_level0' => 'Très faible',
    'complex_level1' => 'Faible',
    'complex_level2' => 'Moyen',
    'complex_level3' => 'Fort',
    'complex_level4' => 'Très fort',
    'complex_level5' => 'Sûr',
    'complex_level6' => 'Très sûr',
    'confirm' => 'Confirmation',
    'confirm_del_from_fav' => 'Merci de confirmer la suppression.',
    'connections' => 'Connexions',
    'copy' => 'Copier',
    'copy_to_clipboard_small_icons' => 'Activer les icônes de copie dans le presse-papier',
    'copy_to_clipboard_small_icons_tip' => '<span style="font-size:11px;max-width:300px;">Cela peut permettre de limiter l&apos;utilisation de la mémoire de l&apos;ordinateur.<br />En effet, le presse-papier n&apos;est pas utilisé pour charger les informations des éléments. Dans ce cas, aucune copie rapide n&apos;est possible.</span>',
    'date' => 'Date',
    'date_format' => 'Format de la date',
    'delete' => 'Supprimer',
    'deletion' => 'Suppressions',
    'del_button' => 'Supprimer',
    'description' => 'Description',
    'disconnect' => 'Déconnexion',
    'done' => 'Fait',
    'duplicate_folder' => 'Les dossiers peuvent avoir des noms identiques',
    'duplicate_item' => 'Autoriser plusieurs éléments avec le même nom.',
    'email' => 'E-mail',
    'email_subject' => 'Création d&apos;un nouveau mot de passe',
    'enable_favourites' => 'Autoriser les utilisateurs à utiliser les Favoris',
    'enable_personal_folder' => 'Activer le Dossier Personnel',
    'enable_personal_folder_feature' => 'Activer la fonctionnalité de Dossier Personnel',
    'enable_user_can_create_folders' => 'Les utilisateurs peuvent gérer les sous-dossiers auxquels ils ont accès.',
    'encrypt_key' => 'Clé de chiffrement',
    'errors' => 'Erreurs',
    'error_group_exist' => 'Ce dossier existe déjà !',
    'error_html_codes' => 'Du texte contient du code html. Ceci n&apos;est pas une bonne idée !',
    'error_item_exists' => 'Cet élément existe déjà !',
    'error_label' => 'Un intitulé est obligatoire !',
    'error_must_enter_all_fields' => 'Vous devez saisir chaque champs !',
    'error_pw' => 'Un mot de passe est obligatoire !',
    'error_tags' => 'Aucune ponctuation n&apos;est autorisée ! Seulement des espaces.',
    'error_user_exists' => 'L&apos;utilisateur existe déjà !',
    'expiration_date' => 'Date d&apos;expiration',
    'find' => 'Rechercher',
    'forbidden_groups' => 'Dossiers interdits',
    'forgot_my_pw_email_sent' => 'E-mail envoyé',
    'functions' => 'Rôles',
    'gestionnaire' => 'Gestionnaire',
    'god' => 'Administrateur',
    'group' => 'Dossier',
    'group_parent' => 'Dossier parent',
    'group_pw_duration' => 'Période de renouvellement',
    'group_pw_duration_tip' => 'En mois. 0 pour désactiver.',
    'history' => 'Historique',
    'home_personal_saltkey' => 'Votre clé personnelle de salage',
    'home_personal_saltkey_label' => 'Saisir votre clé personnelle de salage',
    'import_error_no_read_possible' => 'Impossible de lire le fichier !',
    'import_error_no_read_possible_kp' => 'Lecture du fichier impossible ! Il ne semble pas etre généré par KeePass.',
    'import_keepass_to_folder' => 'Choisir le dossier de destination',
    'index_add_one_hour' => 'Ajouter une heure',
    'index_change_pw_confirmation' => 'Confirmation',
    'index_expiration_in' => 'expiration de la session dans',
    'index_get_identified' => 'Merci de vous identifier',
    'index_last_pw_change' => 'Mot de passe changé la dernière fois le',
    'index_last_seen' => 'Dernière connexion, le',
    'index_login' => 'Compte',
    'index_new_pw' => 'Nouveau mot de passe',
    'index_password' => 'Mot de passe',
    'index_pw_error_identical' => 'Les mots de passe doivent être identiques !',
    'index_pw_level_txt' => 'Complexité',
    'index_session_duration' => 'Durée de la session',
    'info' => 'Informations',
    'item_menu_copy_login' => 'Copier l&apos;identifiant',
    'item_menu_copy_pw' => 'Copier le mot de passe',
    'item_menu_del_from_fav' => 'Supprimer des Favoris',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de connaissance',
    'last_items_title' => 'Derniers éléments vus',
    'ldap_extension_not_loaded' => 'L&apos;extension LDAP n&apos;est pas activée sur le serveur.',
    'level' => 'Niveau',
    'login' => 'Identifiant',
    'mask_pw' => 'Afficher/Masquer le mot de passe',
    'max_last_items' => 'Nombre maximum d&apos;éléments dernièrement vus (par défaut 10)',
    'minutes' => 'minutes',
    'name' => 'Nom',
    'nb_false_login_attempts' => 'Nombre de tentatives de connexion erronées avant blocage (0 pour désactiver)',
    'nb_folders' => 'Nombre de dossiers',
    'nb_items' => 'Nombre d&apos;éléments',
    'new_label' => 'Nouvel intitulé',
    'no' => 'Non',
    'none' => 'Aucun',
    'none_selected_text' => 'Aucun',
    'not_allowed_to_see_pw' => 'Vous n&apos;avez pas le droit de consulter ce mot de passe',
    'not_allowed_to_see_pw_is_expired' => 'Cet élément a expiré !',
    'not_defined' => 'Non défini',
    'number_of_used_pw' => 'Nombre de mots de passe différents saisis avant de pouvoir en réutiliser un',
    'pages' => 'Pages',
    'pdf_download' => 'Télécharger le fichier',
    'personal_salt_key' => 'Votre clé personnel',
    'pw' => 'Mots de passe',
    'pw_generate' => 'Générer',
    'pw_is_expired_-_update_it' => 'Cet élément a expiré ! Vous devez changer son mot de passe.',
    'pw_life_duration' => 'Durée en jours avant expiration d&apos;un mot de passe utilisateur (0 pour désactiver)',
    'readme_open' => 'Ouvrir le fichier ReadMe complet',
    'read_only_account' => 'Lecture Seule',
    'restore' => 'Restaurer',
    'restricted_to' => 'Restreint à',
    'restricted_to_roles' => 'Autoriser la restriction des éléments aux Utilisateurs et aux Rôles',
    'root' => 'Racine',
    'secure' => 'Sécurisé',
    'see_logs' => 'Voir les journaux',
    'settings_anyone_can_modify' => 'Activer l&apos;option permettant que chaque élément soit modifiable',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">Quand activé, cela rajoutera une option dans la fiche de création et édition de l&apos;élément qui permettra à l&apos;auteur d&apos;autoriser la modification de l&apos;élément par tout utilisateur.</span>',
    'settings_default_language' => 'Définir la langue par défaut',
    'settings_kb' => 'Activer la Base de Connaissance (béta)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Quand activé, cela ajoutera la possibilité de créer votre propre Base de Connaissance au travers d&apos;une page dédiée.</span>',
    'settings_ldap_domain' => 'Suffixe LDAP de votre domaine',
    'settings_ldap_domain_controler' => 'Tableau des contrôleurs de votre domaine LDAP',
    'settings_ldap_domain_controler_tip' => '<span style="font-size:11px;max-width:300px;">Vous pouvez spécifier plusieurs contrôleurs si vous désirez que la classe balance les requetes LDAP sur plusieurs serveurs.<br />Attention, vous devez délimiter les domaines par une virgule ( , )!<br />Par exemple : domaine_1,domaine_2,domaine_3</span>',
    'settings_ldap_domain_dn' => 'Base dn de votre domaine LDAP',
    'settings_ldap_mode' => 'Activer l&apos;identification LDAP des utilisateurs',
    'settings_ldap_mode_tip' => 'A activer seulement si vous avez un serveur LDAP et si vous voulez que les utilisateurs TeamPass s&apos;authentifient par celui-ci.',
    'settings_ldap_ssl' => 'Connexion SSL de votre LDAP (LDAPS)',
    'settings_ldap_tls' => 'Connexion TLS de votre LDAP',
    'settings_log_accessed' => 'Activer la journalisation des accès aux éléments',
    'settings_log_connections' => 'Activer la sauvegarde en base de données des connexions utilisateurs',
    'settings_maintenance_mode' => 'Passer TeamPass en mode Maintenance',
    'settings_manager_edit' => 'Les Gestionnaires peuvent éditer et supprimer les éléments auxquels ils ont accès.',
    'settings_printing' => 'Autoriser l&apos;impression PDF des éléments',
    'settings_printing_tip' => 'Quand activé, un bouton sera rajouté sur la page d&apos;accueil permettant à l&apos;utilisateur d&apos;imprimer un listing PDF des éléments auxquels il a accès. Attention, cette liste laisse apparaître les mots de passe sans chiffrement.',
    'settings_restricted_to' => 'Restreindre l&apos;accès aux Eléments',
    'settings_show_description' => 'Afficher la Description dans la liste des éléments',
    'size' => 'Taille',
    'tags' => 'Mots clé',
    'timezone_selection' => 'Choix du fuseau horaire',
    'time_format' => 'Format de l&apos;heure',
    'url' => 'URL',
    'user' => 'Utilisateur',
    'users_online' => 'utilisateur(s) en ligne',
    'user_alarm_no_function' => 'Cet utilisateur n&apos;a aucune Rôle associée !',
    'yes' => 'Oui',
    'one_time_view_item_url_box' => 'Partager l&apos;URL de Vue Unique avec une personne de confiance<br><br>#URL#<br><br>Ce lien ne sera visible qu&apos;une seule fois jusqu&apos;au #DAY#',
    'settings_api' => 'Autoriser l&apos;accès aux éléments de Teampass via l&apos;API',
    'settings_api_tip' => 'L&apos;accès via API permet d&apos;accéder aux éléments depuis une tierce application au format JSON.',
    'settings_api_keys_list' => 'Liste des clés',
    'settings_api_keys_list_tip' => 'Ce sont les clés d&apos;accès autorisées. Sans une clé valide, l&apos;accès n&apos;est pas possible. Vous devez partager ces clés avec précaution.',
    'settings_api_key' => 'Clé',
    'settings_api_add_ip' => 'Ajouter une nouvelle IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Tout nouveau sous-dossier hérite des droits du dossier parent',
    'subfolder_rights_as_parent_tip' => 'Si cette option est activée, chaque nouveau sous-dossier hérite des rôles et des autorisations du dossier parent. Sinon, les autorisations du dossier sont attribuées en fonction du rôle de l&apos;utilisateur qui les créé.',
    'show_only_accessible_folders_tip' => 'Par défaut, un utilisateur voit l&apos;arbre des dossiers dans son ensemble ce qui inclut les répertoires auxquels il n&apos;a pas accès. Il est possible de simplifier cette vue en supprimant ces dossiers auxquels il n&apos;a pas accès de l&apos;affichage de l&apos;arbre.',
    'show_only_accessible_folders' => 'Rendre l&apos;affichage de l’arbre des dossiers plus lisible.',
    'comment' => 'Commentaire',
    'suggestion_menu' => 'Suggestions',
    'settings_suggestion' => 'Autoriser le système de Suggestion pour les utilisateurs en lecture seule',
    'settings_suggestion_tip' => 'Le système de Suggestions permet aux utilisateurs en lecture seule de pouvoir proposer de nouveaux Élément ou d&apos;en demander la modification. Les Suggestions sont validées par les Administrateurs et les Gestionnaires.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'DN LDAP',
    'settings_ldap_bind_passwd' => 'Mot de Passe LDAP',
    'settings_ldap_search_base' => 'Base de Recherche LDAP',
    'settings_ldap_bind_dn_tip' => 'Un identifiant qui attache et recherche les utilisateurs de l&apos;arbre',
    'settings_ldap_bind_passwd_tip' => 'Mot de passe pour l&apos;identifiant qui attache et recherche les utilisateurs de l&apos;arbre',
    'settings_ldap_search_base_tip' => 'Recherche le root dn pour les recherches dans l&apos;arbre',
    'admin_email_server_url' => 'URL serveur pour les liens dans les emails',
    'enable_email_notification_on_user_pw_change' => 'Envoyer un e-mail à l&apos;utilisateur une fois que son mot de passe est changé',
    'settings_otv_expiration_period' => 'Délai avant l&apos;expiration d&apos;un élément partagé à vue unique',
    'write' => 'Ecriture',
    'read' => 'Lecture',
    'no_access' => 'Aucun accès',
    'right_types_label' => 'Sélectionner le type d&apos;accès à ce dossier pour le groupe d&apos;utilisateurs sélectionné',
    'duplicate_item_in_folder' => 'Autoriser les doublons dans un même dossier',
    'settings_roles_allowed_to_print' => 'Définir le rôle autorisé à imprimer les éléments',
    'settings_roles_allowed_to_print_tip' => 'Les rôles sélectionnés seront autorisés à imprimer les Éléments.',
    'admin_email_security' => 'Sécurité SMTP',
    'alert_page_will_reload' => 'La page va maintenant être rechargée',
    'file_protection_password' => 'Définir le mot de passe du fichier',
    'expand' => 'Étendre ',
    'collapse' => 'Réduire',
    'settings_ldap_user_attribute' => 'Attribut dans lequel rechercher l&apos;utilisateur',
    'settings_ldap_user_attribute_tip' => 'Attribut LDAP dans lequel rechercher l&apos;utilisateur.<br>Exemples: Pour openLDAP: cn ; uid. Pour Active Directory : samaccountname.',
    'log_user_initial_pwd_changed' => 'Mot de passe initial défini',
    'log_user_email_changed' => 'Email de l&apos;utilisateur changé par ',
    'log_user_created' => 'Compte utilisateur créé',
    'log_user_locked' => 'L&apos;utilisateur a été bloqué',
    'log_user_unlocked' => 'L&apos;utilisateur a été débloqué',
    'log_user_pwd_changed' => 'Mot de passe de l&apos;utilisateur a été changé',
    'settings_default_session_expiration_time' => 'Délais par défaut pour l&apos;expiration d&apos;une session utilisateur',
    'settings_duo' => 'Activer DUO Security pour l&apos;authentification utilisateur à 2 facteurs',
    'settings_duo_tip' => 'L&apos;authentification utilisateur à deux facteurs peut être assurée par DUOSecurity.com. Cette bibliothèque guarantie un niveau de sécurité élevé pour l&apos;authentification utilisateur. ',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Ces identifiants sont issues de l&apos;application web dédiée depuis la page d&apos;administration DUOSecurity dans le cadre de l&apos;utilisation de Teampass.<br/>En validant, vous acceptez la sauvegarde de ceux-ci au sein du fichier sk.php',
    'admin_duo_intro' => 'Remplir le champs suivant avec les informations escomptés',
    'edit' => 'Editer',
    'user_info_locked' => 'L&apos;utilisateur est VERROUILLER',
    'user_info_unlock_question' => 'Déverrouiller le compte ? ',
    'user_info_lock_question' => 'Verrouiller le compte ?',
    'user_info_delete_question' => 'Supprimer le compte ?',
    'user_info_active' => 'L&apos;utilisateur est actuellement ACTIVÉ.',
    'refresh' => 'Rafraîchir',
    'loading' => 'En chargement',
    'searching' => 'Recherche en cours ...',
    'list_items_with_tag' => 'Liste des éléments avec le mot clé',
    'no_item_to_display' => 'Aucun élément à afficher',
    'opening_folder' => 'Lecture du dossier ...',
    'suggestion_notify_subject' => '[Teampass] Une nouvelle suggestion a été faite.',
    'suggestion_notify_body' => 'Bonjour,<br><br>Une nouvelle suggestion a été faite. Vous devez la valider avant qu&apos;elle ne puisse servir à d&apos;autres utilisateurs.<br>Ses informations :<br>- Titre: #tp_label#<br>- Dossier: #tp_folder#<br>- Utilisateur: #tp_user#<br><br>Veuillez noter que cet e-mail a été envoyé à tous les administrateurs.<br><br>Cordialement.',
    'error_unknown' => 'Une erreur inatendue est arrivée !',
    'no_edit' => 'Écrire mais sans éditer',
    'role_cannot_edit_item' => 'Ne peut pas éditer des éléments',
    'no_delete' => 'Écrire mais sans effacer',
    'role_cannot_delete_item' => 'Ne peut pas effacer des éléments',
    'my_profile' => 'Mon Profil',
    'starting' => 'Initialisation ...',
    'total_number_of_items' => 'Nombre total d&apos;éléments',
    'finalizing' => 'Finalisation',
    'treating_items' => 'Eléments traités',
    'number_of_items_treated' => 'Nombre d&apos;éléments traités',
    'error_sent_back' => 'L&apos;erreur suivante est apparue',
    'full' => 'Complet',
    'sequential' => 'Séquentiel',
    'tree_load_strategy' => 'Stratégie de chargement de l&apos;arborescence',
    'syslog_enable' => 'Activer Syslog',
    'syslog_host' => 'Serveur Syslog',
    'syslog_port' => 'Port Syslog',
    'error_bad_credentials' => 'Informations de connexion erronées',
    'settings_ldap_usergroup' => 'Groupe LDAP dans lequel faire la recherche',
    'settings_ldap_usergroup_tip' => 'Groupe LDAP dans lequel les utilisateurs doivent être membre pour pouvoir se connecter. Exemple : cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Activer le changement automatique du mot de passe du compte du serveur (en utilisant une connexion SSH)',
    'update_server_password' => 'Mettre à jour le mot de passe du serveur',
    'ssh_pwd' => 'Mot de passe SSH',
    'ssh_user' => 'Identifiant SSH',
    'ssh_password_frequency_change_info' => 'Vous désirez peut-etre que le changement se fasse de façon automatique à une fréquence définie. Pour cela, il est nécessaire de définir la fréquence à laquelle le mot de passe de l&apos;utilisateur du serveur devra être changé (mettre à 0 pour désactiver la tache).<br>Merci de noter que cela ne fonctionnera que si votre administrateur a activé la tâche dans le crontab du serveur.',
    'ssh_password_frequency_change' => 'Fréquence de changement du mot de passe (en mois)',
    'ssh_scheduled_change' => 'Planifier un changement',
    'ssh_one_shot_change' => 'Changement direct',
    'server_password_change_enable_tip' => 'Cette option permet aux utilisateurs de réaliser automatiquement le changement de mot de passe d&apos;un utilisateur sur le serveur localisé à l&apos;URL indiquée, en utilisant une connexion SSH.<br>Notez que le changement automatique à la fréquence indiquée n&apos;est possible que si le fichier <i>/files/script.ssh.php</i> est ajouté au crontab de ce serveur. La recommandation serait que celui-ci s’exécute une fois par jour.',
    'settings_ldap_object_class' => 'Recherche de la Classe',
    'settings_ldap_object_class_tip' => 'Rechercher dans la CLasse LDAP, par exemple, une Personne ou un posixAccount',
    'rebuild_config_file' => 'Reconstruire le ficher de configuration',
    'rebuild_config_file_tip' => 'Le fichier de Configuration est situé dans le répertoire  ./includes/config/tp.config.php. Il contient toutes les variables de configuration comme définies dans les pages de Configuration de Teampass. La reconstruction de ce fichier peut être réalisé à tout moment.',
    'error_folder_complexity_lower_than_top_folder' => 'Il est nécessaire de définir un niveau de complexité de mot de passe au moins égale à celui du répertoire parent.',
    'new_item_email_body' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>Une nouvelle entrée &apos;#label&apos; a été créée dans TeamPass.<br />Vous pouvez la consulter en cliquant sur ce <a href="#link#">LIEN</a>.<br/><br />Cordialement.',
    'failed_logins' => 'Connexions échouées',
    'error_only_numbers_in_folder_name' => 'Le nom d&apos;un répertoire ne peut pas être seulement un nombre. Veuillez entrer un nom contenant des lettres.',
    'encrypted_data' => 'Les données sont cryptées dans la base de données',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'Identifiant de votre carte AGSES',
    'ga_flash_qr_and_login' => 'Flasher ce code depuis votre smartphone, saisissez le code d&apos;identification et cliquer le bouton "Entrer".',
    'i_need_to_generate_new_ga_code' => 'J&apos;ai besoin d&apos;un nouveau flash code. Merci de m&apos;envoyer un nouveau code temporaire par email.',
    'settings_manager_move_item' => 'Les Gestionnaires peuvent déplacer tout objet qu&apos;ils peuvent accéder',
    'user_folders_rights' => 'Dossiers visibles',
    'create_item_without_password' => 'Permettre de créer une entrée sans renseigner un mot de passe',
    'share_rights_info' => 'Cette fenêtre de dialogue permet de partager les permissions d&apos;un utilisateur avec une sélection d&apos;utilisateurs.<br>Prenez note que les permissions des utilisateurs sélectionnés seront remises à zéro et remplacées par exactement les mêmes permissions que l&apos;utilisateur source.',
    'share_rights_source' => 'Utilisateur source',
    'share_rights_destination' => 'Utilisateurs de destination',
    'ga_reset_by_user' => 'L&apos;utilisateur peut ré-initialiser son code.',
    'ga_reset_by_user_tip' => 'Si activé, l&apos;utilisateur aura la possibilité de ré-initialiser son code authentification en utilisant un lien présent sur la page d&apos;accueil. Cela peut être pratique si ce dernier change de smartphone. Si désactivé, l&apos;utilisateur devra faire sa demande à son administrateur.',
    'enable_massive_move_delete' => 'Autoriser les opérations massives de suppression et de déplacement.',
    'enable_massive_move_delete_tip' => 'Si activité, cette option permet à un utilisateur de réaliser des opérations de déplacement et de suppression massive sur plusieurs objets. Celles-ci ne seront possible en fonction des droits associés aux objets.',
    'mass_operation' => 'Opération sur',
    'move_items' => 'Déplacer les objets sélectionnés',
    'delete_items' => 'Supprimer les objets sélectionnés',
    'you_decided_to_move_items' => 'Vous avez décidé de déplacer les objets',
    'you_decided_to_delete_items' => 'Vous avez décidé de supprimer les objets',
    'suggest_password_change' => 'Suggérer une évolution concernant l&apos;objet',
    'otv_is_enabled' => 'L&apos;utilisateur peut proposer des liens à usage unique pour des objets',
    'error_source_and_destination_are_equal' => 'Les 2 répertoires ne peuvent être identiques',
    'sending_anonymous_statistics' => 'Envoyer des statistiques anonymes',
    'favourites_option_enabled' => 'Option `Favoris` activée',
    'personalfolders_option_enabled' => 'Option `Répertoires Personels` activée',
    'country_statistics' => 'Mapmonde',
    'country' => 'Pays',
    'users_statistics' => 'Nombre moyen d&apos;utilisateurs',
    'items_all' => 'Tous les Objets',
    'folders_all' => 'Tous les Répertoires',
    'items_shared' => 'Tous les Objets publics',
    'folders_shared' => 'Tous les Répertoires publics',
    'items_statistics' => 'Nombre moyen d&apos;Objets',
    'folders_statistics' => 'Nombre moyen de Répertoires',
    'administrators_number' => 'Nombre d&apos;Administrateurs',
    'administrators_number_statistics' => 'Nombre moyen d&apos;Administrateurs',
    'managers_number' => 'Nombre de Gestionnaires',
    'managers_number_statistics' => 'Nombre moyen de Gestionnaires',
    'readonly_number_statistics' => 'Nombre moyen d&apos;utilisateurs en Lecture-Seule',
    'readonly_number' => 'Nombre d&apos;utilisateurs en Lecture-Seule',
    'mysql_version' => 'Version MySQL',
    'php_version' => 'Version PHP',
    'teampass_version' => 'Version Teampass',
    'languages_used' => 'Langues utilisées',
    'languages_statistics' => 'Langues les plus utilisées',
    'kb_option_enabled' => 'Option `Base de Connaissance` activée',
    'suggestion_option_enabled' => 'Option `Suggestions` activée ',
    'customfields_option_enabled' => 'Option `Champs Personnalisés` activée ',
    'api_option_enabled' => 'Option `API` activée ',
    '2fa_option_enabled' => 'Option `Identification à 2 Facteurs` activée ',
    'agses_option_enabled' => 'Option `AGSES` activée ',
    'duo_option_enabled' => 'Option `DUO Security` activée ',
    'ldap_option_enabled' => 'Option `LDAP` activée ',
    'syslog_option_enabled' => 'Option `SYSLOG` activée ',
    'stricthttps_option_enabled' => 'Option `HTTPS strict` activée ',
    'characteristic' => 'Donnée',
    'current_value' => 'Valeur actuelle',
    'communication_means' => 'Moyens de Communication',
    'consider_a_donation' => 'Merci de considérer une donnation',
    'more_information' => 'Plus d&apos;information',
    'feature_request_canal' => 'Pour toute Question ou Demande, merci d&apos;utiliser',
    'bug_canal' => 'Pour tout Bug, merci d&apos;utiliser',
    'documentation_canal' => 'Documentation',
    'sending_anonymous_statistics_details' => 'Des statistiques relatives à l&apos;utilisation de Teampass sont nécessaires pour connaitre les contexts d&apos;utilisation de l&apos;outil par le développeur. Elles permettent d&apos;évaluer comment Teampass est utilisé et par conséquent orienter l&apos;implémentation des nouvelles fonctionnalités. Les données envoyées sont uniquement utilisées en interne and ne seront absolument pas distribuées ou vendues à un tiers.',
    'item_has_change_proposal' => 'Une proposition d&apos;évolution est disponible pour cet objet',
    'check_data_after_reencryption' => 'Merci d&apos;effectuer une vérification de vos données. Une table de sauvegarde <b>Backup</b> a été créée durant l&apos;opération de ré-encryptage.',
    'revert' => 'Restaurer les données ?',
    'revert_the_database' => 'Vous avez décidé de restaurer les anciennes données. Merci de confirmer.',
    'bad_psk' => 'Cette clé de salage personnelle n&apos;est pas correcte !',
    'ldap_test_config' => 'Tester cette configuration',
    'ldap_test_username' => 'Nom d&apos;utilisateur',
    'ldap_test_username_pwd' => 'Mot de passe utilisateur',
    'feature_support_canal' => 'Pour obtenir du soutien et de l&apos;aide, SVP utilisez',
    'category' => 'Catégorie',
    'text' => 'Texte',
    'type' => 'Type',
    'data_is_masked' => 'Données cachées',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP groupe autorisé',
    'settings_ldap_allowed_usergroup_tip' => 'Indiquer le nom du groupe autorisé à se connecter à Teampass. Laisser vide si aucune restriction n&apos;est requise.',
    'error_security_level_not_reached' => 'Niveau de sécurité non atteint !',
    'personal_saltkey_security_level' => 'Niveau minimum de sécurité de la clé personnelle de salage',
    'settings_disable_forgot_password_link' => 'Cacher le lien de récupération de mot de passe',
    'newly_created_user_is_administrated_by' => 'Les nouveaux utilisateurs sont administrés par',
    'settings_ldap_and_local_authentication' => 'Utilisateurs locaux et LDAP',
    'settings_ldap_and_local_authentication_tip' => 'En activant cette option, l&apos;dentification sera acceptée pour les utilisateurs locaux et dans un annuaire LDAP.',
    'enable_http_request_login' => 'Authentification automatique via l&apos;en-tête http',
    'duration_login_attempt' => 'Nombre de secondes avant authentification automatique',
    'newly_created_user_role' => 'Rôle de l&apos;utilisateur créé',
    'email_debug_level' => 'Sélectionnez un niveau de débogage',
    'email_debug_client' => 'Commandes du client',
    'email_debug_server' => 'Commandes du client et réponses du serveur',
    'email_debug_connection' => 'Commandes du client, réponse du serveur et statut de la connexion',
    'email_debug_low_level' => 'Sortie de bas niveau, tous les messages',
    'email_debug_level_usage' => 'Cette option ne devrait pas être activée. Elle est uniquement utilisée durant le débogage, à des fins de tests. Lorsque activée, cette option permet d&apos;obtenir la sortie des commandes du client.',
    'email_body_temporary_login_password' => 'Bonjour,<br><br>Ceci est un email généré par Teampass passwords manager.<br><br>Un administrateur a changé votre mot de passe de connexion. Vous devrez donc utiliser le code suivant lors de votre prochaine connexion à Teampass.<br><br><b>#enc_code#</b><br><br><br>À bientot sur Teampass',
    'your_new_password' => 'Votre nouveau mot de passe',
    'user_specific_right' => 'Droit spécifique à l&apos;utilisateur',
    'icon' => 'Icone',
    'icon_on_selection' => 'Icone sur sélection',
    'fontawesome_icon_tip' => 'Sélectionner un code d&apos;icône de la librarie Font Awesome sélectionné dans Free et Solid. Laisser vide pour utiliser les icônes par défaut.',
    'settings_api_token_duration' => 'Délai d&apos;expiration du jeton JWT (en secondes)',
    'settings_api_token_duration_tip' => 'Délai pendant lequel le jeton JWT généré est valide. Passé ce délai, il est demandé de poster une demande d&apos;autorisation à l&apos;API.',
    'show_encryption_code_to_admin' => 'Il s&apos;agit du code crypté dont l&apos;utilisateur aura besoin lors de cette connexion. Vous avez demandé à le voir, veuillez le copier et le partager de manière sécurisée. Le code est',
    'previous_password' => 'Précédent mot de passe utilisé pour vous identifier dans Teampass',
    'generate_new_otp' => 'Générer un nouveau code de cryptage temporaire',
    'generate_new_otp_informations' => 'Cette opération consiste à générer à partir de zéro toutes les clés pour l&apos;utilisateur sélectionné. En conséquence, l&apos;utilisateur devra fournir le nouvel OTP généré lors de sa prochaine connexion.',
    'html' => 'html',
    'execution_time' => 'Durée d&apos;exécution',
    'maximum_number_of_items_to_treat' => 'Nombre maximum d&apos;objets traités sur un cycle',
    'maximum_number_of_items_to_treat_tip' => 'De façon à s&apos;affranchir d&apos;un possible timeout lors de l&apos;exécution du script, il est possible de définir un temps d&apos;exécution différent.',
    'maximum_time_script_allowed_to_run' => 'Temps d&apos;exécution en secondes autorisé pour le script',
    'maximum_time_script_allowed_to_run_tip' => 'Par défaut, un script php ne peut pas s&apos;exécuter sur une durée supérieure à celle définie via le paramètre max_execution_time. Ici nous pouvons définir une durée différente permettant au script de s&apos;exécuter complètement.',
    'refresh_data_every_on_screen' => 'Temps de rafraichissement de l&apos;écran (en secondes)',
    'refresh_data_every_on_screen_tip' => 'Cela permet de rafraîchir la liste des taches à la fréquence indiquée.',
    'refreshed' => 'Rafraichi',
    'process_details' => 'Détails',
    'created_at' => 'Crée à',
    'updated_at' => 'Mis à jour à',
    'finished_at' => 'Terminé à',
    'tasks_manager' => 'Gestionnaire de tâches',
    'tasks' => 'Tâches',
    'task_in_progress_user_not_active' => 'Tache en cours - Utilisateur non activé',
    'enable_tasks_manager' => 'Activer le gestionnaire de tâches via cron',
    'enable_tasks_manager_tip' => 'Cette option doit être activée si vous remarquez que certaines tâches prennent beaucoup de temps. Cela permet d&apos;activer la gestion de ces tâches à l&apos;aide d&apos;un job en arrière-plan effectué par le gestionnaire cron du serveur. Voir la documentation pour plus de détails.',
    'sync_new_ldap_password' => 'Synchroniser les nouveaux mots de passe',
    'error_new_ldap_password_detected' => 'Teampass détecte un changement de mot de passe. Il est nécessaire de réencrypter votre clé principale.',
    'settings_ldap_tls_certifacte_check' => 'Vérification du certificat LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Indique la stratégie de vérification du certificat. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Plus informations</a>.',
    'user_keys_management' => 'Gestion des clés utilisateurs',
    'sending_emails' => 'Envoi d&apos;emails',
    'tasks_information' => 'Les taches dépendent du cron. Il est donc nécessaire de définir dans le crontab d&apos;un job permettant d&apos;exécuter le scheduler de Teampass chaque minute.<br>La commande à saisir est :<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note : Adapter le chemain vers le binaire php.',
    'bad_duo_mfa' => 'Code DUO eronné',
    'creation_date' => 'Date de création',
    'never' => 'Jamais',
    'loading_main_page' => 'La page se charge ...',
    'link' => 'Lien',
    'error_not_allowed_to_authenticate' => 'Vous n’êtes pas autorisé à vous authentifier',
    'enable_tasks_log' => 'Activer le log des taches du cron',
    'enable_tasks_log_tip' => 'Permet d&apos;enregistrer l&apos;exécution des taches du cron dans la table <i>processes_log</i>.  Cela peut être utile pour vérifier que les taches tournent correctement.',
    'items_and_folders_statistics' => 'Statistiques relatives aux objets et répertoires',
    'item_copying' => 'Copie de l&apos;objet en cours',
    'upgrade_requested' => 'La base de données n&apos;est pas à jour.',
    'upgrade_requested_more' => 'Des inconsistances ont été détectées entre les fichiers et la base de données. Votre administrateur doit impérativement réaliser une mise à jour avant de continuer.',
    'settings_ldap_group_object_filter' => 'Filtre des groupes LDAP',
    'settings_ldap_group_object_filter_tip' => 'Filtre LDAP permettant de rechercher des objets de type Groupe. Exemple : (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'Rôles des utilisateurs AD ajustés en fonction de leurs groupes AD',
    'settings_ad_users_with_ad_groups_tip' => 'Permet d&apos;ajuster les rôles des utilisateurs AD avec ceux de leurs groupes AD. Ces rôles seront ajoutés à ceux définis dans leur profile.',
    'settings_ad_user_auto_creation' => 'Utilisateur AD automatiquement créé',
    'settings_ad_user_auto_creation_tip' => 'Permet à un utilisateur AD d&apos;être automatiquement crée lors de leur 1ère connexion à Teampass. A noter que si l&apos;option "Rôles des utilisateurs AD ajustés en fonction de leurs groupes AD" est activée alors il aura les rôles associés à ses groupes AD.',
    'settings_ldap_guid_attibute' => 'Attribut du GUID LDAP',
    'settings_ldap_guid_attibute_tip' => 'Attribut LDAP à utiliser pour identifier le GUID d&apos;un objet de l&apos;AD. Par exemple, objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'Groupe AD',
    'mapped_with_role' => 'Lié au rôle',
    'ad_groupe_and_roles_mapping' => 'Liaison entre les groupes AD et les rôles',
    'select_adgroup_mapping' => 'Sélectionner le rôle à lier avec le groupe AD courant',
    'enable_backlog_mail' => 'Activer l&apos;envoi des emails en attente',
    'provide_label' => 'Saisir un intitulé',
    'uploading' => 'Téléversement ...',
    'keys_encryption_not_ready' => 'Les clés de cryptage de vos objets sont actuellement en cours. Merci de patienter quelques minutes.',
    'account_not_ready' => 'Compte en construction',
    'add_new_job' => 'Ajouter un nouveau job',
    'tasks_cron_not_running' => 'Cron job non trouvé. Merci d&apos;éditer le crontab avec l&apos;utilisateur du serveur (typiquement www-data) avec la commande <code>crontab -u www-data -e</code>.<br>Sinon appuyer le bouton ci-dessous.',
    'tasks_cron_running' => 'Cron job trouvé',
    'currently_using_version' => 'Version actuellement chargée',
    'git_commit_value' => 'Version du commit de Git',
    'generate_new_keys' => 'Générer de nouvelles clés',
    'generate_new_keys_info' => 'En poursuivant, de nouvelles clés pour les objets vont être générées. Cela devrait être effectué uniquement si les mots de passe ne s&apos;affichent plus.',
    'generate_new_keys_end' => 'L&apos;opération est en cours en arrière plan et peut prendre plusieurs minutes. Vous pouvez maintenant fermer cette fenêtre.',
    'confirm_password' => 'Merci de confirmer votre mot de passe',
    'no_code_is_requested' => 'Code non requis.',
    'user_encryption_ongoing' => 'Le cryptage des clés est en cours. Merci de patientez pour exécuter cette action.',
    'teampass_information' => 'Informations Teampass',
    'show_password' => 'Montrer le mot de passe',
    'new_user_info_by_mail' => 'Le nouvel utilisateur recevra un email avec ses identifiants',
    'login_credentials' => 'Identifiants de connexion',
    'email_body_user_config_1' => 'Bonjour #lastname#,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Les informations d&apos;identification suivantes sont attendues la prochaine fois que vous utiliserez Teampass :<ul><li>Utilisateur: #login#</li ><li>Mot de passe : #password#</li><li>Code de cryptage : #code#</li></ul><br><br>Cordialement',
    'email_body_user_config_3' => 'Bonjour #lastname#,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Le mot de passe suivant est attendu la prochaine fois que vous utiliserez Teampass :<br><br><b>#password#</b><br><br>Cordialement',
    'email_body_user_config_4' => 'Bonjour #lastname#,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Votre compte Teampass est entièrement prêt.<br><br>Cordialement',
    'email_body_user_config_5' => 'Bonjour #lastname#,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Le code suivant est attendu la prochaine fois que vous utiliserez Teampass :<br><br><b>#code#</b><br><br><br>Cordialement',
    'email_body_user_config_6' => 'Bonjour #lastname#,<br><br>Ceci est un e-mail généré par le gestionnaire de mots de passe Teampass.<br><br>Les informations d&apos;identification suivantes sont attendues la prochaine fois que vous utiliserez Teampass :<ul><li>Utilisateur: #login#</li ><li>Mot de passe : #password#</li></ul><br><br><br>Cordialement',
    'error_data_not_valid' => 'Donnée non valide',
    'mfa_enabled' => 'AMF activée',
    'mfa_disabled_for_user' => 'AMF désactivée pour l&apos;utilisateur',
    'users_personal_folder' => 'Répertoire personnel des utilisateurs',
    'maintenance_operations' => 'Opérations de maintenance',
    'maintenance_operations_tip' => 'Opérations de maintenance sur la base de données sélectionnées.',
    'purge_temporary_files' => 'Purger les fichiers temporaires',
    'task_scheduling' => 'Planification des tâches',
    'parameter' => 'Paramètre',
    'frequency' => 'Fréquence',
    'in_minutes' => 'en minutes',
    'hourly' => 'Toutes les heures',
    'daily' => 'Tous les jours',
    'clean_orphan_objects' => 'Nettoyer les objets orphelins',
    'run_once' => 'Exécuter une fois',
    'run_weekday' => 'Exécuter un jour de semaine',
    'monday' => 'Lundi',
    'tuesday' => 'Mardi',
    'wednesday' => 'Mercredi',
    'thursday' => 'Jeudi',
    'friday' => 'Vendredi',
    'saturday' => 'Samedi',
    'sunday' => 'Dimanche',
    'monthly' => 'Mensuellement',
    'day_of_month' => 'Jour du mois',
    'day' => 'Jour',
    'reset' => 'Réinitialiser',
    'error_while_creating_file' => 'Création du fichier impossible',
    'new_keys_generated' => 'Nouvelles clés générées',
    'user_creation' => 'Utilisateur créé',
    'user_deletion' => 'Utilisateur supprimé',
    'maximum_session_expiration_time' => 'Délai d&apos;expiration maximal de la session',
    'maximum_session_expiration_time_tip' => 'Durée d&apos;extension maximum en minutes d&apos;une session utilisateur',
    'index_session_duration_too_long' => 'Durée de session trop grande',
    'extend_session_duration_by' => 'Augmenter la session de',
    'settings_ldap_user_dn_attribute' => 'User Distinguised Name',
    'settings_ldap_user_dn_attribute_tip' => 'The attribute label for the user Distinguished Name (DN) in the AD.<br>Example: For openLDAP: dn. For Active Directory:  distinguishedname.',
    'open_tasks_settings' => 'Ouvrir les paramètres des tâches',
    'maximum' => 'maximum',
    'updated' => 'Mis à jour',
    'number_of_days' => 'Nombre de jours',
    'number_of_times' => 'Nombre de visualisations',
    'sharekey_not_ready' => 'Clé de partage non générée ... toutes les données de l&apos;objet ne sont pas prêtes ... Merci de patienter',
    'item_action_not_yet_possible' => 'Cette action n&apos;est pas disponible pour le moment sur cet objet',
    'open' => 'Ouvert',
    'reload_user_cache_table' => 'Recharger la table de cache de l&apos;utilisateur',
    'send_email_to_user' => 'Envoi d&apos;email à l&apos;utilisateur',
    'items_management' => 'Opérations relatives aux objets',
    'previously_used_passwords' => 'Mots de passe précédemment utilisés',
    'next_passwords_were_valid_until_date' => 'Ces mots de passe ont été valides jusqu&apos;à la date indiquée',
    'feature_disabled_by_administrator' => 'Fonctionnalité désactivée par l&apos;administrateur',
    'shared_globaly' => 'Partagé globalement',
    'settings_otv_subdomain' => 'Sous domaine des liens à visualisation unique',
    'settings_otv_subdomain_tip' => 'Dedicated subdomain for onetime links. Considere your main Teampass URL as isolated from internet, this subdomain could be reachable by everyone to share this item with someone outside your organisation. From security perspective it is a lot safer with such mechanics. Note: This would requite to have a DNS entry for this subdomain pointing to your Teampass server.',
    'existing_valid_otv_links' => 'Liens à visualisation valides',
    'started' => 'Lancé',
    'recovery_keys_not_downloaded' => 'Clés de récupération non téléchargées',
    'no_recovery_keys' => 'Je ne dispose pas des clés de récupération. Cette opération effacera tous les mots de passe des mes objets personnels.',
    'provide_recovery_keys' => 'Fournir vos clés de récupération',
    'public_key' => 'Clé publique',
    'private_key' => 'Clé privée',
    'download_recovery_keys' => 'Télécharger vos clés de récupération',
    'download_recovery_keys_confirmation' => 'Vous êtes sur le point de télécharger vos clés de récupération. Merci de les sauvegarder dans un endroit sûr.',
    'recovery_keys_download_date' => 'Date de téléchargement des clés de récupération',
    'keys_not_recovered' => 'Clés publique et privée non sauvegardées',
    'keys_not_recovered_explanation' => 'De façon à vous prévenir de la perte des mots de passe de vos objets personnels, vous devriez sauvegarder vos clés de récuparation.',
    'get_your_recovery_keys' => 'Télécharger vos clés de récupération',
    'keys_management' => 'Gestion des clés',
    'please_confirm_task_to_be_run' => 'Merci de confirmer l&apos;exécution de la tache',
    'user_keys_downloaded' => 'Clés utilisateur téléchargées',
    'mfa_code_send_by_email' => 'Code MFA envoyé par email',
    'otp' => 'OTP',
    'otp_code' => 'Code OTP',
    'enabled_otp_for_item' => 'Activer le code OTP',
    'at_otp_status' => 'Status de l&apos;OTP',
    'phone_number' => 'Numéro de téléphone associé (optionel)',
    'otp_secret' => 'Clé secrète de l&apos;OTP',
    'settings_ldap_group_objectclasses_attibute' => 'Attributs ObjectClassses pour les Groupes',
    'settings_ldap_group_objectclasses_attibute_tip' => 'The objectClasses to use when searching for groups. Several objectClasses are separated by a comma (,). Example: groupOfNames,group or top,posixGroup',
    'display_warning_icons' => 'Afficher les icones d&apos;attention',
    'password_length_by_default' => 'Longueur du mot de passe par défaut',
    'progress' => 'Avancement',
    'tasks_log_retention_delay_in_days' => 'Durée de rétention (en jours) des logs d&apos;exécution des tâches',
    'tasks_log_table_size' => 'Taille de la table des logs',
    'error_otp_secret' => 'Impossible de décoder, merci de vérifier le code secret saisi.',
    'users_api_access_info' => 'Les utilisateurs peuvent utiliser l&apos;API avec les mêmes droits que dans Teampass.',
    'error_folder_not_allowed_for_this_user' => 'Répertoire non accessible pour cet utilisateur',
    'allowed_to_create' => 'Autorisé à créer',
    'allowed_to_read' => 'Autorisé à lire',
    'allowed_to_update' => 'Autorisé à mettre à jour',
    'allowed_to_delete' => 'Allowed to supprimer',
    'folder_created' => 'Répertoire créé',
    'login_with_sso' => 'Se connecter en SSO',
    'server_connected_to_internet' => 'Serveur connecté à internet',
    'server_not_connected_to_internet' => 'Serveur non connecté à internet',
    'server_not_connected_to_internet_tip' => 'Cela peut engendré des disfonctionnements de certaines fonctionnalités du MFA par exemple.',
    'tools' => 'Outils',
    'user_config_not_compliant' => 'User configuration is not compliant',
    'fix_personal_items_empty' => 'Fix personal items are empty',
    'fix_personal_items_empty_tip' => 'This tool permits to fix the issue where personal items are empty after a Teampass upgrade. It requires to have restored a copy of table teampass_items from Teampass version 2. The table needs to be named teampass_items_v2.',
    'table_not_exists' => 'Expected table does not exist. Please restore it from a backup.',
    'tools_usage_warning' => 'Using tools can have a direct impact on the database. Please be careful. Always perform a dump before and define a maintenance period.',
    'select_user' => 'Select user',
    'show_item_data' => 'Afficher les détails de l&apos;objet dans la liste',
    'show_item_data_tip' => 'Permet d&apos;afficher des informations supplémentaires dans la liste des éléments (nom d&apos;utilisateur, e-mail et URL). Cela peut être utile pour avoir un aperçu rapide du contenu de l&apos;élément.',
    'items_page_split_view_mode' => 'Afficher les objets à droite de la liste au lieu de plein écran',
    'replace_tenant_id' => 'Adapter l&apos;url tout en laissant {tenant-id}. Il sera remplacer lors de l&apos;appel.',
    'user_not_allowed_to_auth_to_teampass_app' => 'Vous n&apos;êtes pas autoriser à vous authentifier à l&apos;application Teampass',
    'user_is_not_auth_with_oauth2' => 'Vous ne pouvez pas vous authentifier avec un compte Entra/Azure AD',
    'highlight_favorites' => 'Mettre en évidence les favoris',
    'highlight_favorites_tip' => '',
    'limited_search_default' => 'Recherche limitée par défaut',
    'limited_search_default_tip' => '',
    'highlight_selected_tip' => '',
    'encryptClientServer' => 'Crypter les échanges serveur-client',
    'encryptClientServer_tip' => 'Cette option n&apos;est pas des plus pertinente et peut être désactivée.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL de récupération des détails utilisateurs',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'Utiliser pour récupérer des informations complémentaires après authentification.',
    'duo_redirect_uri' => 'Redirection vers DUO',
    'number_users_build_cache_tree' => 'Nombre d&apos;utilisateurs traités par build_cache_tree.',
    'number_users_build_cache_tree_tip' => 'Nombre d&apos;utilisateurs traités par build_cache_tree à chaque lancement du scheduler.',
    'user_password_expired' => 'Ton mot de passe est expiré. Merci de le changer.',
    'user_password_policy_tip' => 'Le nouveau mot de passe doit :<br/> - Etre différent du précédent<br/> - Contenir au moins 10 caractères<br/> - Contenir au moins une lettre en majuscule et une en minuscule<br/> - Contenir au moins un chiffre ou caractère spécial<br/> - Ne pas contenir votre nom/prénom/identifiant/mail.
',
    'bruteforce_unlock_at' => 'Déblocage du compte (anti bruteforce) : ',
    'bruteforce_reset_account' => 'Réinitialiser l&apos;anti bruteforce de l&apos;utilisateur',
    'bruteforce_reset_mail_subject' => 'TEAMPASS - Votre compte est désactivé',
    'bruteforce_reset_mail_body' => 'Bonjour #name#,<br/><br/>Votre compte teampass a été verouillé en raison d&apos;un grand nombre d&apos;échecs d&apos;authentification.<br/><br/>Vous pouvez le débloquer en cliquant sur ce lien <a href="#reset_url#" target="_blank">#reset_url#</a><br/><br/>Déblocage automatique : #unlock_at#',
    'disable_user_edit_profile' => 'Les utilisateurs ne peuvent plus éditer leur profil',
    'disable_user_edit_language' => 'Les utilisateurs ne peuvent plus changer de langue',
    'disable_user_edit_timezone' => 'Les utilisateurs ne peuvent plus changer de fuseau horaire',
    'disable_user_edit_tree_load_strategy' => 'Les utilisateurs ne peuvent plus changer de stratégie de chargement',
    'bruteforce_wait' => 'Trop de tentatives échouées, votre compte est bloqué jusqu&apos;à : ',
    'disable_drag_drop' => 'Désactiver le glisser-déposer d&apos;objets',
    'clipboard_cleared' => 'Presse-papier nettoyé',
    'error_data_not_consistent' => 'Données non consistantes',
    'error_permission_denied' => 'Permission refusée',
    'error_invalid_action' => 'Action invalide',
    'error_fetching_password' => 'Impossible de récupérer le mot de passe',
    'unable_to_clear_clipboard' => 'Impossible de vider le presse-papier manuellement',
    'clipboard_unsafe' => 'Le presse-papier n&apos;a pas pu être vidé automatiquement, c&apos;est une faille de sécurité !',
    'clipboard_clear_now' => 'Le vider maintenant !',
    'clipboard_clearing_failed' => 'Le vidage du presse-papier à échoué',
    'clipboard_error' => 'Erreur du presse-papier',

);
