<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      greek.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2024 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your LDAP credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Several filters are separated by a comma (,). Example: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your LDAP since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Default non secure LDAP port: 389, default secure LDAP port: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Select all',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid until one of following settings is reached. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Logs',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'Details',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn&apos;t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Please confirm',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Roles',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Label',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Click to open Teampass website',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Select profile image file',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Copy folder',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Χρήστες',
    'folders' => 'Folders',
    'find_message' => 'objects found',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'share' => 'Share this item',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'You must select a folder',
    'email_subject_item_updated' => 'Password has been updated',
    'email_body_item_updated' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Password for &apos;#item_label#&apos; has been updated.<br /><br />You can check it <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">HERE</a><br /><br />Cheers',
    'import_kp_finished' => 'Import from KeePass is now finished ! The required password strength for new folders has been set to Medium. You may wish to modify the password strength requirement.',
    'password_is_empty' => 'Item has no password',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bugs_page' => 'If you discover a bug, please report it.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Set <i>anyone in the same role can modify</i> right on all imported items.',
    'import_csv_anyone_can_modify_txt' => 'Set "anyone can modify" right on all imported items.',
    'settings_upload_imageresize_options' => 'Resize uploaded images',
    'user_not_exists' => 'This user does not exist!',
    'auto_create_folder_role' => 'Create folder and role for ',
    'start_upload' => 'Start file upload',
    'error_upload_runtime_not_found' => 'Upload feature: No runtime found.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Change my password',
    'admin_2factors_authentication_setting' => 'Ενεργοποίηση Google 2-Factor authentication',
    'admin_2factors_authentication_setting_tip' => 'Google two-factor authentication enhances logon security. When logging in, a QR code is displayed, which must be scanned into the user&apos;s Google Authentication app to receive a one-time password. Requires all users to have Google authentication app on an Internet-connected mobile device.',
    'admin_ga_website_name' => 'Name displayed in Google Authenticator for Teampass',
    'admin_ga_website_name_tip' => 'This name is used for the identification code account in Google Authenticator.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => 'A password item was shared with you',
    'email_share_item_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has shared with you the password item #tp_item# <a href="#tp_link#">Click this link</a> to access the item.',
    'index_maintenance_mode_admin' => 'Maintenance mode is activated. Users currently can not log in.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Αποστολή GoogleAuthenticator στο χρήστη με ηλεκτρονικό μήνυμα',
    'error_no_email' => 'Αυτός ο χρήστης δεν έχει ορίσει διεύθυνση ηλεκτρονικού ταχυδρομίου!',
    'error_no_user' => 'Ο χρήστης δεν βρέθηκε!',
    'email_ga_subject' => 'Your Google Authenticator one-time code for TeamPass',
    'email_ga_text' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your administrator is expecting you to use TwoFactor authentication to get connected to Teampass.<br>For your first connection to Teampass with TwoFactor, please use the code you will find below in the "Identication code" field:<br><br>----------------------<br>#2FACode#<br>----------------------<br><br>You will then have the opportunity to set up your one-time credentials for Teampass password manager.<br><br>Greetings',
    'settings_attachments_encryption' => 'Ενεργοποίηση κρυπτογράφισης συνημμένων αρχείων',
    'settings_attachments_encryption_tip' => 'If enabled, items attachments are encrypted on the server with the system salt key. Encryption requires more server resources. -- Warning! -- Changing this option could break existing file attachments! After changing this setting, you must run the task to encrypt or decrypt existing file attachments.',
    'admin_action_attachments_cryption' => 'Κρυπτογράφηση ή Αποκρυπτογράφηση συνημμένων αρχείων',
    'admin_action_attachments_cryption_tip' => 'Warning: Only encrypt or decrypt files after changing attachment encryption settings to match. Select whether to encrypt or decrypt, then press start. Make a backup of the upload folder before running this function.',
    'encrypt' => 'Κρυπτογράφηση',
    'decrypt' => 'Αποκρυπτογράφηση',
    'ga_identification_code' => 'Κωδικός αναγνώρισης',
    'ga_enter_credentials' => 'Χρειάζεται να εισάγετε τα στοιχεία εισόδου',
    'ga_bad_code' => 'Ο κωδικός Google Authenticator είναι λανθασμενος',
    'settings_get_tp_info' => 'Αυτόματη φόρτωση πληροφοριών για το Teampass',
    'settings_get_tp_info_tip' => 'When enabled, information such as current software versions, bug fixes, and release news is displayed on the administrator info page from remote servers.',
    'settings_offline_mode' => 'Ενεργοποίηση λειτουργίας εκτός-σύνδεσης',
    'settings_offline_mode_tip' => 'Offline mode creates a standalone HTML web page that can be downloaded to a computer. The items in the offline page are encrypted with a user-specified password when created.',
    'offline_mode_key_level' => 'Offline minimum encryption security',
    'categories' => 'Κατηγορίες',
    'no_category_defined' => 'Δεν έχει οριστεί κατηγορία ακομα',
    'confirm_deletion' => 'Πρόκειται να διαγράψετε... είστε σίγουρος?',
    'settings_item_extra_fields' => 'Custom item fields enabled',
    'settings_item_extra_fields_tip' => 'Enables another tab when creating password items, which contains custom fields for other types of data. An administrator must first create categories and the custom field labels to be displayed in those categories. This feature consumes more server resources.',
    'settings_ldap_type' => 'LDAP server type',
    'server_time' => 'Χρόνος εξυπηρετητή',
    'settings_tree_counters' => 'Show more counters in folder tree',
    'settings_tree_counters_tip' => 'Enabling shows three numbers next to each folder: number of items in base folder; number of items including subfolders; number of subfolders. Enabling this feature may slow loading of the folder tree pane.',
    'admin_action_check_pf' => 'Create personal folders for all users without one',
    'enable_personal_folder_feature_tip' => 'Personal folders are a private location for individual user passwords. Password items are encrypted by a user&apos;s salt key (more secure) or by their password (easier). Enabling this feature does not create the actual folders for existing users - you must also run the create personal folders task.',
    'administrators_only' => 'Administrators only',
    'managers_of' => 'Managers of role',
    'managed_by' => 'Managed by',
    'settings_enable_sts' => 'HTTPS Strict Transport Security (HSTS) <strong>Warning</strong>: read tooltip!',
    'settings_enable_sts_tip' => 'Warning! This will enforce the HTTPS strict transport security (STS) policy. STS helps prevent man-in-the-middle attacks. You must have a SSL certificate issued from a certificate authority (CA) installed before enabling this option!  A self-signed certificate will not work! Any future web connections will require HTTPS. You must have &apos;SSLOptions +ExportCertData&apos; in the Apache SSL configuration.',
    'settings_anyone_can_modify_bydefault' => '<i>Anyone can modify</i> option selected by default',
    'to' => 'to',
    'settings_upload_maxfilesize_tip' => 'Maximum file size allowed when uploading an attachment or other file (in megabytes, default setting 10 MB). You also may need to change your php.ini settings upload_max_filesize and post_max_size, the default is often just 2 MB.',
    'settings_upload_docext_tip' => 'List the file extensions for text and word processor files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_imagesext_tip' => 'List the file extensions for image files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_pkgext_tip' => 'List the file extensions for compressed archive files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_otherext_tip' => 'List any other file extensions you will permit to be uploaded as attachments. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_imageresize_options_tip' => 'Resize large uploaded pictures (set maximum dimensions in pixels). Images larger than 1000 pixels wide may not display well in the web browser.',
    'settings_upload_maxfilesize' => 'Maximum attachment size',
    'settings_upload_docext' => 'Document extensions allowed',
    'settings_upload_imagesext' => 'Image extensions allowed',
    'settings_upload_pkgext' => 'Archive extensions allowed',
    'settings_upload_otherext' => 'Other extensions allowed',
    'settings_upload_imageresize_options_w' => 'Maximum image width',
    'settings_upload_imageresize_options_h' => 'Maximum image height',
    'settings_upload_imageresize_options_q' => 'JPEG image quality',
    'settings_importing' => 'Import from KeePass or CSV files enabled',
    'admin_proxy_ip' => 'Proxy server IP address',
    'admin_proxy_ip_tip' => 'If you require a proxy server to connect to the Internet, set the IP address here. Otherwise, leave blank.',
    'admin_proxy_port' => 'Proxy server port',
    'admin_proxy_port_tip' => 'If you require a proxy server to connect to the Internet, set the port number here.',
    'settings_ldap_elusers' => 'Teampass local users only',
    'settings_ldap_elusers_tip' => 'This feature allows users in the database to authenticate via LDAP. Disable this if you want to browse any LDAP directory.',
    'db_items_edited' => 'Item currently being edited',
    'item_edition_start_hour' => 'Editing started',
    'settings_delay_for_item_edition' => 'Exclusive editing lock expires after XX minutes',
    'settings_delay_for_item_edition_tip' => 'When editing an item, the item is locked so that no other user can modify it. This setting deletes the lock token after a certain number of minutes. If the value is set to 0, an item will never be automatically unlocked after someone has started editing.',
    'db_users_logged' => 'Συνδεμένοι χρήστες',
    'action' => 'Ενέργεια',
    'login_time' => 'Logged since',
    'lastname' => 'Επώνυμο',
    'user_login' => 'Σύνδεση',
    'role' => 'Ρόλος',
    'error_role_exist' => 'Αυτός ο ρόλος υπάρχει ηδη',
    'error_no_edition_possible_locked' => 'Editing disabled - item locked by another user',
    'select' => 'επιλογή',
    'items' => 'Αντικείμενα',
    'enable_personal_saltkey_cookie' => 'Store personal salt key in a browser cookie',
    'personal_saltkey_cookie_duration' => 'User salt keys expire after XX days',
    'admin_email_smtp_server' => 'SMTP server address',
    'admin_email_auth' => 'Server requires authentication',
    'admin_email_auth_username' => 'Mail server username',
    'admin_email_auth_pwd' => 'Mail server password',
    'admin_email_port' => 'SMTP server port',
    'admin_email_from' => 'From: Email address',
    'admin_email_from_name' => 'From: Display name',
    'admin_email_test_configuration_tip' => 'Send a test email to the logged-in user. You must first set your email address by clicking the user profile icon.',
    'admin_email_test_subject' => 'Test email from administrator',
    'admin_email_test_body' => 'This is a test email sent to verify email server configuration. If you are reading this, congratulations!',
    'admin_email_result_ok' => 'Email sent to #email# ... check your inbox.',
    'email_bodyalt_item_updated' => 'Password for #item_label# has been updated.',
    'admin_email_send_backlog_tip' => 'Re-send any queued backlog of outgoing emails waiting in the database.',
    'please_wait' => 'Please wait',
    'admin_path_to_files_folder' => 'Files folder (full path)',
    'admin_path_to_files_folder_tip' => 'The files folder is used to store both system files and some uploaded files. For highest security, it should not be located in your site&apos;s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'admin_path_to_upload_folder_tip' => 'File attachments are stored in the upload folder with randomized names.  Contents of this folder should never be manually deleted. For highest security, it should not be located in your site&apos;s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'pdf_password_warning' => 'You must provide an encryption key!',
    'admin_pwd_maximum_length' => 'Maximum password length',
    'admin_pwd_maximum_length_tip' => 'The default maximum password length is 40 characters. Increasing the size of allowed passwords will take more time when encrypting, decrypting, and displaying passwords.',
    'settings_insert_manual_entry_item_history' => 'Manual insertions in item history log allowed',
    'settings_insert_manual_entry_item_history_tip' => 'You would normally want to leave this off. When enabled, the history of a password item can be edited or altered.',
    'admin_path_to_upload_folder' => 'Διαδρομή φακέλου Μεταφορτώσεων',
    'admin_setting_enable_delete_after_consultation' => 'Passwords may expire after limited views',
    'admin_setting_enable_delete_after_consultation_tip' => 'When enabled, item creators can decide whether a password item will be automatically deleted after a limited number of views.',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Email administrators when password item is viewed',
    'share_sent_ok' => 'Email has been sent',
    'see_item_title' => 'Item details',
    'email_on_open_notification_subject' => 'Notification on password item view',
    'email_on_open_notification_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has opened and viewed the password item &apos;#tp_item#&apos;. <a href="#tp_link#">Click this link</a> to access the item.',
    'pdf' => 'PDF',
    'email_subject_new_user' => 'Password management account created for you',
    'email_new_user_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created an account for you on the password manager. Secure passwords for your organization are just a click away! <br><br>Use these credentials for your first login:<br>- Login: #tp_login#<br>- Password: #tp_pw#<br><br><a href="#tp_link#">Click this link</a> to log in and reset your password.',
    'error_empty_data' => 'No data to proceed!',
    'error_not_allowed_to' => 'You are not allowed to do that!',
    'request_access_ot_item' => 'Request access to modify',
    'email_request_access_subject' => 'You have a request to enable access to your password item',
    'email_request_access_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>User #tp_user# has requested access to password item "#tp_item#".<br><br>The request comes with the next justification:<br><i>"#tp_reason#"</i><br><br>Please review this request  and confirm that you will authorize access.<br><br>Greetings.',
    'admin_action_change_salt_key' => 'Change the main salt key used for encryption',
    'nb_items_by_query' => 'Number of items to retrieve per query',
    'nb_items_by_query_tip' => 'Input the number of items to retrieve per server request. Multiple smaller requests may perform better than fewer, larger requests. Other options: &apos;auto&apos; - tuned to user display window size. &apos;max&apos; - to load all at once.',
    'open_url_link' => 'Open in a new window',
    'error_pw_too_long' => 'Password longer than system maximum (default 40 characters).',
    'at_restriction' => 'Restriction',
    'pw_encryption_error' => 'Error encrypting password!',
    'enable_send_email_on_user_login' => 'Email administrators upon any user login',
    'email_subject_on_user_login' => 'Info: user login to password manager',
    'email_body_on_user_login' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>User #tp_user# logged in to the password manager on #tp_date# at #tp_time#. <br><br>This is a normal message when option <i>Email administrators upon any user login</i> is set.',
    'account_is_locked' => 'This account is locked',
    'activity' => 'Activity',
    'add_role_tip' => 'Add New Role',
    'admin' => 'Administration',
    'admin_action_db_backup' => 'Backup the database',
    'admin_action_db_clean_items' => 'Remove orphan items from database',
    'admin_action_db_clean_items_tip' => 'Removes any items or other entries left behind after a folder is deleted. Please backup before performing this task.',
    'admin_action_db_optimize' => 'Optimize the database',
    'admin_action_db_restore' => 'Restore the database',
    'admin_action_purge_old_files' => 'Clean up temporary files',
    'admin_action_purge_old_files_tip' => 'Deletes all temporary files older than 7 days.',
    'admin_action_reload_cache_table' => 'Reload cache table',
    'admin_action_reload_cache_table_tip' => 'Recreates the item cache. May correct problems in displaying or saving password items.',
    'admin_help' => 'Help',
    'admin_ldap_configuration' => 'LDAP configuration',
    'admin_main' => 'Information',
    'admin_misc_cpassman_dir' => 'TeamPass location (full path)',
    'admin_misc_cpassman_url' => 'TeamPass location (URL)',
    'admin_misc_custom_login_text' => 'Custom login message',
    'admin_misc_custom_logo' => 'Custom login logo (URL)',
    'admin_misc_favicon' => 'Favicon (full URL)',
    'admin_settings' => 'Settings',
    'admin_settings_title' => 'Settings',
    'admin_setting_activate_expiration' => 'Enable password expiration',
    'admin_setting_activate_expiration_tip' => 'When enabled, password items will not be shown after they have expired. Set the password expiration time in days elsewhere before enabling this feature.',
    'admin_views' => 'Utilities',
    'alert_message_done' => 'Done!',
    'all' => 'all',
    'anyone_can_modify' => 'Allow this item to be modified by anyone that can access it',
    'at' => 'at',
    'at_category' => 'Folder',
    'at_copy' => 'Copy done',
    'at_delete' => 'Deletion',
    'at_description' => 'Description',
    'at_label' => 'Label',
    'at_login' => 'Login',
    'at_moved' => 'Moved',
    'at_personnel' => 'Personal',
    'at_restored' => 'Restored',
    'at_shown' => 'Accessed',
    'at_url' => 'URL',
    'author' => 'Author',
    'authorized_groups' => 'Allowed Folders',
    'auth_creation_without_complexity' => 'Allow item creation without required password strength',
    'auth_modification_without_complexity' => 'Allow item modification without required password strength',
    'cancel' => 'Cancel',
    'can_create_root_folder' => 'Can create a folder at root level',
    'changelog' => 'Recent software updates',
    'close' => 'Close',
    'complexity' => 'Minimum Password Strength',
    'complex_asked' => 'Required Password Strength',
    'complex_level0' => 'Very weak',
    'complex_level1' => 'Weak',
    'complex_level2' => 'Medium',
    'complex_level3' => 'Strong',
    'complex_level4' => 'Very strong',
    'complex_level5' => 'Heavy',
    'complex_level6' => 'Very heavy',
    'confirm' => 'Confirm',
    'confirm_del_from_fav' => 'Please confirm deletion from favorites',
    'connections' => 'connections',
    'copy' => 'Copy',
    'copy_to_clipboard_small_icons' => 'Enable <i>copy password</i> icon on item list',
    'copy_to_clipboard_small_icons_tip' => 'Adds a small icon to the password item listing on the top panel which copies the password to the clipboard. A password can be copied without needing to select and load the whole item contents.',
    'date' => 'Date',
    'date_format' => 'Date format',
    'delete' => 'Delete',
    'deletion' => 'Deletions',
    'del_button' => 'Delete',
    'description' => 'Description',
    'disconnect' => 'Logout',
    'done' => 'Done',
    'duplicate_folder' => 'Folders may have duplicate names',
    'duplicate_item' => 'Items may have duplicate name',
    'email' => 'Email',
    'email_subject' => 'New password item created in password manager',
    'enable_favourites' => 'Favorites bookmark feature enabled',
    'enable_personal_folder' => 'Personal folders with private password storage',
    'enable_personal_folder_feature' => 'Personal folders with private password storage',
    'enable_user_can_create_folders' => 'Sub-folders managed by anyone who can manage parent',
    'encrypt_key' => 'Encryption key',
    'errors' => 'errors',
    'error_group_exist' => 'This folder already exists!',
    'error_html_codes' => 'Some text contains HTML codes! This is not allowed.',
    'error_item_exists' => 'This item already exists!',
    'error_label' => 'A label is mandatory!',
    'error_must_enter_all_fields' => 'You must fill in each field!',
    'error_pw' => 'A password on the password tab is required.',
    'error_tags' => 'Only spaces are allowed in tags',
    'error_user_exists' => 'User already exists',
    'expiration_date' => 'Expiration date',
    'find' => 'Search',
    'forbidden_groups' => 'Denied Folders',
    'forgot_my_pw_email_sent' => 'Email has been sent',
    'functions' => 'Roles',
    'gestionnaire' => 'Manager',
    'god' => 'Administrator',
    'group' => 'Folder',
    'group_parent' => 'Parent Folder',
    'group_pw_duration' => 'Renewal period',
    'group_pw_duration_tip' => 'In months. Use 0 to disable.',
    'history' => 'History',
    'home_personal_saltkey' => 'Your personal salt key',
    'home_personal_saltkey_label' => 'Enter your personal salt key',
    'import_error_no_read_possible' => 'Can&apos;t read the file!',
    'import_error_no_read_possible_kp' => 'Can&apos;t read the file! It must be a KeePass file.',
    'import_keepass_to_folder' => 'Select the destination folder',
    'index_add_one_hour' => 'Extend session 1 hour',
    'index_change_pw_confirmation' => 'Confirm',
    'index_expiration_in' => 'session expiration in',
    'index_get_identified' => 'Please identify yourself',
    'index_last_pw_change' => 'Password changed',
    'index_last_seen' => 'Last connection ',
    'index_login' => 'Account',
    'index_new_pw' => 'New password',
    'index_password' => 'Password',
    'index_pw_error_identical' => 'The passwords have to be identical!',
    'index_pw_level_txt' => 'Password Strength',
    'index_session_duration' => 'Session duration',
    'info' => 'Information',
    'item_menu_copy_login' => 'Copy login',
    'item_menu_copy_pw' => 'Copy password',
    'item_menu_del_from_fav' => 'Delete from favorites',
    'kbs' => 'KBs',
    'kb_menu' => 'Knowledge Base',
    'last_items_title' => 'Last items seen',
    'ldap_extension_not_loaded' => 'The LDAP PHP extension is not loaded on the server.',
    'level' => 'Level',
    'login' => 'Login',
    'mask_pw' => 'Mask/display password',
    'max_last_items' => 'Recently viewed password item list size (default is 10)',
    'minutes' => 'minutes',
    'name' => 'Name',
    'nb_false_login_attempts' => 'Maximum login attempts before account lockout (0 to disable lockout)',
    'nb_folders' => 'Number of Folders',
    'nb_items' => 'Number of Items',
    'new_label' => 'New label',
    'no' => 'No',
    'none' => 'None',
    'none_selected_text' => 'None selected',
    'not_allowed_to_see_pw' => 'Access to password item denied!',
    'not_allowed_to_see_pw_is_expired' => 'This item has expired!',
    'not_defined' => 'Not defined',
    'number_of_used_pw' => 'Number of old passwords remembered to prevent reuse (0 to disable)',
    'pages' => 'Pages',
    'pdf_download' => 'Download file',
    'personal_salt_key' => 'Your personal salt key',
    'pw' => 'Password',
    'pw_generate' => 'Generate',
    'pw_is_expired_-_update_it' => 'This item has expired! You need to change its password.',
    'pw_life_duration' => 'Logon passwords expire after xx days (0 to disable)',
    'readme_open' => 'Open full readme file',
    'read_only_account' => 'Read Only',
    'restore' => 'Restore',
    'restricted_to' => 'Restricted to',
    'restricted_to_roles' => 'Allow restricting items to users and roles',
    'root' => 'Root',
    'secure' => 'Secure',
    'see_logs' => 'See Logs',
    'settings_anyone_can_modify' => '<i>Anyone can modify</i> feature enabled',
    'settings_anyone_can_modify_tip' => 'This adds a checkbox during new password item creation that can set the item to be modifiable by anyone.',
    'settings_default_language' => 'Default user interface language',
    'settings_kb' => 'Knowledge base feature',
    'settings_kb_tip' => 'Adds a menu item to access the knowledge base feature. The knowledge base is a searchable FAQ, allowing you create help and notes, and attach them to password items.',
    'settings_ldap_domain' => 'LDAP account suffix for your domain',
    'settings_ldap_domain_controler' => 'LDAP domain controller(s)',
    'settings_ldap_domain_controler_tip' => 'Specify domain controller providing the directory services. To balance queries among multiple servers, input a comma-delimited list of each server name. Example: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'LDAP base DN for your domain',
    'settings_ldap_mode' => 'Enable users authentication through LDAP server',
    'settings_ldap_mode_tip' => 'Enable if you wish to authenticate user logins with an LDAP directory server instead of using the internal user database.',
    'settings_ldap_ssl' => 'Use LDAP through SSL (LDAPS)',
    'settings_ldap_tls' => 'Use LDAP through TLS',
    'settings_log_accessed' => 'Log password item views by users',
    'settings_log_connections' => 'Log all user account logins',
    'settings_maintenance_mode' => 'Enable maintenance mode (disable user login)',
    'settings_manager_edit' => 'Managers may edit or delete any items they can view',
    'settings_printing' => 'Export to PDF or CSV enabled',
    'settings_printing_tip' => 'Adds an export option to the item tree menu, allowing export of entire folders to PDF or CSV. CSV passwords will be exported unencrypted, while PDF files can be password-protected.',
    'settings_restricted_to' => 'Enable <i>restricted-to</i> function on items',
    'settings_show_description' => 'Show item description field in item listings',
    'size' => 'Size',
    'tags' => 'Tags',
    'timezone_selection' => 'Time zone',
    'time_format' => 'Time format',
    'url' => 'URL',
    'user' => 'Χρήστης',
    'users_online' => 'users online',
    'user_alarm_no_function' => 'This user has no roles assigned!',
    'yes' => 'Ναι',
    'one_time_view_item_url_box' => 'Share a one-time-view URL with a person you trust to see the password <br><br>#URL#<br><br>This link will only be visible one time, and expires #DAY#',
    'settings_api' => 'Ενεργοποίηση πρόσβασης στα αντικείμενα του Teampass μέσω του API',
    'settings_api_tip' => 'The Application Programming Interface allows software developers to access password items in JSON format over the network.',
    'settings_api_keys_list' => 'Λίστα κλειδιών',
    'settings_api_keys_list_tip' => 'Keys to access API. Third-party software must use a random key created here to access the JSON interface.',
    'settings_api_key' => 'Κλειδί',
    'settings_api_add_ip' => 'Προσθήκη νέας διεύθυνσης IP',
    'settings_api_ip' => 'Διεύθυνση IP',
    'subfolder_rights_as_parent' => 'New sub-folders inherit permissions from parent folder',
    'subfolder_rights_as_parent_tip' => 'If enabled, each new sub-folder inherits the roles and permissions of the parent folder. Otherwise, the folder permission is assigned based on the role of the user who creates them.',
    'show_only_accessible_folders_tip' => 'By default, users see the complete tree of password item folders, even if some folders are inaccessible to the user. You may remove inaccessible folders from the view to simplify browsing.',
    'show_only_accessible_folders' => 'Hide inaccessible password folders',
    'comment' => 'Σχόλιο',
    'suggestion_menu' => 'Προτάσεις',
    'settings_suggestion' => 'Password suggestion feature enabled',
    'settings_suggestion_tip' => 'The suggestion feature adds a new menu and page, allowing users to create suggestions for new password items. This is useful when only managers are allowed to create password items.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'LDAP bind password',
    'settings_ldap_search_base' => 'LDAP search base',
    'settings_ldap_bind_dn_tip' => 'Enter a bind DN which can access users and search in the tree. A bind DN is a credential that authenticates your access to the directory.',
    'settings_ldap_bind_passwd_tip' => 'Password for the bind DN specified above.',
    'settings_ldap_search_base_tip' => 'Root DN location for searches on the tree',
    'admin_email_server_url' => 'Customize URL for links',
    'enable_email_notification_on_user_pw_change' => 'Email user when user password is changed',
    'settings_otv_expiration_period' => 'One-time-view (OTV) links expire after XX days',
    'write' => 'Write',
    'read' => 'Read',
    'no_access' => 'No Access',
    'right_types_label' => 'Select the type of access on this folder for the selected group of users',
    'duplicate_item_in_folder' => 'Items in same folder may have similar names',
    'settings_roles_allowed_to_print' => 'Export allowed by these roles (multi-select)',
    'settings_roles_allowed_to_print_tip' => 'Select multiple roles by holding CTRL while selecting. Members of these roles will be able to export folders to CSV or PDF if export is also enabled globally.',
    'admin_email_security' => 'SMTP security type',
    'alert_page_will_reload' => 'The page will now be reloaded',
    'file_protection_password' => 'Define file password',
    'expand' => 'Expand',
    'collapse' => 'Collapse',
    'settings_ldap_user_attribute' => 'User attribute to search',
    'settings_ldap_user_attribute_tip' => 'LDAP attribute to search within for username',
    'log_user_initial_pwd_changed' => 'Initial password defined',
    'log_user_email_changed' => 'User email changed to ',
    'log_user_created' => 'User account created',
    'log_user_locked' => 'User has been locked',
    'log_user_unlocked' => 'User has been unlocked',
    'log_user_pwd_changed' => 'User password has been changed',
    'settings_default_session_expiration_time' => 'Default session expiration time',
    'settings_duo' => 'Enable DUO Security two-factor authentication',
    'settings_duo_tip' => 'Duo Security cloud-based two-factor authentication from duo.com. One-time use login passcodes via SMS, voice call, or mobile app. An account with Duo is required to use this feature. Two-factor login via Duo will be required for all non-admin users when activated.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Credentials from the Duo Security administration page for your account must be input here. Settings will be stored in the sk.php file only after pressing the save button.',
    'admin_duo_intro' => 'Input or generate Duo Security secret',
    'edit' => 'Edit',
    'user_info_locked' => 'User is currently locked.',
    'user_info_unlock_question' => 'Unlock account?',
    'user_info_lock_question' => 'Lock account?',
    'user_info_delete_question' => 'Delete account?',
    'user_info_active' => 'User is currently enabled.',
    'refresh' => 'Ανανέωση',
    'loading' => 'Loading',
    'searching' => 'Searching ...',
    'list_items_with_tag' => 'List items with this tag',
    'no_item_to_display' => 'No items to display',
    'opening_folder' => 'Reading folder ...',
    'suggestion_notify_subject' => 'A new password item suggestion was submitted',
    'suggestion_notify_body' => 'A user has submitted a password item suggestion to the password manager. You need to accept the submission before it can be used by other users.<br>Info:<br>- Label: #tp_label#<br>- Folder: #tp_folder#<br>- User: #tp_user#<br><br>This email has been sent to all managers.',
    'error_unknown' => 'An unexpected error occurred!',
    'no_edit' => 'Write but no edit',
    'role_cannot_edit_item' => 'Cannot edit items',
    'no_delete' => 'Write but no delete',
    'role_cannot_delete_item' => 'Η διαγραφή των αρχείων δεν είναι εφικτή',
    'my_profile' => 'Το προφίλ μου',
    'starting' => 'Starting...',
    'total_number_of_items' => 'Συνολικός αριθμός αντικειμένων',
    'finalizing' => 'Finalizing',
    'treating_items' => 'Processing items',
    'number_of_items_treated' => 'Number of items processed',
    'error_sent_back' => 'Next error occured',
    'full' => 'Full',
    'sequential' => 'Sequential',
    'tree_load_strategy' => 'Tree load strategy',
    'syslog_enable' => 'Log errors to <i>syslog</i> server',
    'syslog_host' => 'Syslog server name or IP address',
    'syslog_port' => 'Syslog port (default 514)',
    'error_bad_credentials' => 'Login credentials do not correspond!',
    'settings_ldap_usergroup' => 'LDAP group to search',
    'settings_ldap_usergroup_tip' => 'Enter the LDAP group in the directory where allowed user logins are stored. Example: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Enable changing password on distant server (using ssh connection)',
    'update_server_password' => 'Update server password',
    'ssh_pwd' => 'SSH password',
    'ssh_user' => 'SSH user',
    'ssh_password_frequency_change_info' => 'Select the interval between automatic server password updates (selecting 0 will disable automatic password changing).<br />Automatic password updates will only be performed if the system administrator has also configured the scheduled password update feature cron job.',
    'ssh_password_frequency_change' => 'Password change frequency (in months)',
    'ssh_scheduled_change' => 'Scheduled change',
    'ssh_one_shot_change' => 'One-time change',
    'server_password_change_enable_tip' => 'This setting adds an option in the password item to automatically change the user password on a server address listed in the url. This requires the remote UNIX server to allow username and password login via SSH. Automatic scheduled password changes can be performed after adding <i>/files/script.ssh.php</i> to crontab to run once a day on the password manager webserver.',
    'settings_ldap_object_class' => 'Class to search',
    'settings_ldap_object_class_tip' => 'LDAP class to search, such as user account or POSIX account',
    'rebuild_config_file' => 'Rebuild the configuration file',
    'rebuild_config_file_tip' => 'The configuration file contains system variables, and is used when these settings are needed before the database connection has been established. Rebuilding the configuration file saves the database values to the file, and can be done any time. The default location is ./includes/config/tp.config.php, but the file should be located outside the www directory for security.',
    'error_folder_complexity_lower_than_top_folder' => 'Subfolders must have password strength set the same or higher than parent folder',
    'new_item_email_body' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>New item &apos;#label&apos; has been created in Teampass.<br />You may access it clicking on this <a href="#link#">LINK</a>.<br/><br />Greetings.',
    'failed_logins' => 'Failed Logins',
    'error_only_numbers_in_folder_name' => 'Folder label can not be just a number. Please give your folder a name which includes letters.',
    'encrypted_data' => 'Data is encrypted in database',
    'settings_ldap_port' => 'LDAP port',
    'user_profile_agses_card_id' => 'Your Agses card id',
    'ga_flash_qr_and_login' => 'Flash this QR code with your mobile device, enter the 2Factor Authentication code and click `Enter` button.',
    'i_need_to_generate_new_ga_code' => 'I need a new QR code. Please send me by email a temporary Identication Code.',
    'settings_manager_move_item' => 'Managers can move any items they can view',
    'user_folders_rights' => 'Visible folders',
    'create_item_without_password' => 'Allow item to be created without any password defined',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Source user',
    'share_rights_destination' => 'Destination users',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Move selected Items',
    'delete_items' => 'Delete selected Items',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'suggest_password_change' => 'Suggest a password change',
    'otv_is_enabled' => 'User can propose One-Time-View links',
    'error_source_and_destination_are_equal' => 'Source and Destination cannot be the same!',
    'sending_anonymous_statistics' => 'Sending anonymous statistics',
    'favourites_option_enabled' => 'Favourites option enabled',
    'personalfolders_option_enabled' => 'Personal Folders option enabled',
    'country_statistics' => 'Worldmap usage',
    'country' => 'Country',
    'users_statistics' => 'Average number of users by instance',
    'items_all' => 'All items',
    'folders_all' => 'All folders',
    'items_shared' => 'All shared items (not including personal ones)',
    'folders_shared' => 'All shared folders (not including personal ones)',
    'items_statistics' => 'Average number of items by instance',
    'folders_statistics' => 'Average number of folders by instance',
    'administrators_number' => 'Number of Administrator users',
    'administrators_number_statistics' => 'Average number of Administrators by instance',
    'managers_number' => 'Number of Manager users',
    'managers_number_statistics' => 'Average number of Managers by instance',
    'readonly_number_statistics' => 'Average number of Read-Only users by instance',
    'readonly_number' => 'Number of Read-Only users',
    'mysql_version' => 'MySQL version',
    'php_version' => 'PHP version',
    'teampass_version' => 'Teampass version',
    'languages_used' => 'Languages used',
    'languages_statistics' => 'Most used language',
    'kb_option_enabled' => 'Knowledge Base option enabled',
    'suggestion_option_enabled' => 'Suggestion option enabled',
    'customfields_option_enabled' => 'Custom fields option enabled',
    'api_option_enabled' => 'API option enabled',
    '2fa_option_enabled' => '2FAoption enabled',
    'agses_option_enabled' => 'AGSES option enabled',
    'duo_option_enabled' => 'DUO Security option enabled',
    'ldap_option_enabled' => 'LDAP option enabled',
    'syslog_option_enabled' => 'SYSLOG option enabled',
    'stricthttps_option_enabled' => 'Strict HTTPS option enabled',
    'characteristic' => 'Characteristic',
    'current_value' => 'Current value',
    'communication_means' => 'Communication means',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'More information',
    'feature_request_canal' => 'For Feature Requests, please use',
    'bug_canal' => 'For Bugs, please use',
    'documentation_canal' => 'Complete documentation at',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'This Item has a change proposal',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revert?',
    'revert_the_database' => 'You have decided to revert the database. Please confirm?',
    'bad_psk' => 'This personal Saltkey is not correct!',
    'ldap_test_config' => 'Test current configuration',
    'ldap_test_username' => 'Username to use for testing purpose',
    'ldap_test_username_pwd' => 'Username password',
    'feature_support_canal' => 'For Support and Help, please use',
    'category' => 'Category',
    'text' => 'Text',
    'type' => 'Type',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Loading main page ...',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',
    'generate_new_keys' => 'Generate new keys',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown.',
    'generate_new_keys_end' => 'Process is on going in background and could take several minutes. You can now close this window.',
    'confirm_password' => 'We need you to confirm your password',
    'no_code_is_requested' => 'No code is requested.',
    'user_encryption_ongoing' => 'Account is currently being encrypting. Your request cannot continue. Please wait until this is finished.',
    'teampass_information' => 'Teampass information',
    'show_password' => 'Show password',
    'new_user_info_by_mail' => 'New user will receive an email with his credentials',
    'login_credentials' => 'Login credentials',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following password is expected next time using Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your Teampass account is fully ready.<br><br>Cheers',
    'email_body_user_config_5' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following code is expected next time using Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Data is not valid',
    'mfa_enabled' => 'MFA enabled',
    'mfa_disabled_for_user' => 'MFA disabled for user',
    'users_personal_folder' => 'Users personal folder',
    'maintenance_operations' => 'Maintenance operations',
    'maintenance_operations_tip' => 'Selected maintenance operations on Teampass database.',
    'purge_temporary_files' => 'Purge temporary files',
    'task_scheduling' => 'Task scheduling',
    'parameter' => 'Parameter',
    'frequency' => 'Frequency',
    'in_minutes' => 'in minutes',
    'hourly' => 'Hourly',
    'daily' => 'Daily',
    'clean_orphan_objects' => 'Clean orphan objects',
    'run_once' => 'Run once',
    'run_weekday' => 'Run on weekday',
    'monday' => 'Monday',
    'tuesday' => 'Tuesday',
    'wednesday' => 'Wednesday',
    'thursday' => 'Thursday',
    'friday' => 'Friday',
    'saturday' => 'Saturday',
    'sunday' => 'Sunday',
    'monthly' => 'Monthly',
    'day_of_month' => 'Day of month',
    'day' => 'Day',
    'reset' => 'Reset',
    'error_while_creating_file' => 'Error while creating file',
    'new_keys_generated' => 'New keys generated',
    'user_creation' => 'User creation',
    'user_deletion' => 'User deletion',
    'maximum_session_expiration_time' => 'Maximum session expiration time',
    'maximum_session_expiration_time_tip' => 'Maximum time in minutes a session can be extended by a user',
    'index_session_duration_too_long' => 'Session duration is too long',
    'extend_session_duration_by' => 'Extend session duration by',
    'settings_ldap_user_dn_attribute' => 'User Distinguished Name',
    'settings_ldap_user_dn_attribute_tip' => 'The attribute label for the user Distinguished Name (DN) in the AD.<br>Example: For openLDAP: dn. For Active Directory:  distinguishedname.',
    'open_tasks_settings' => 'Open tasks settings',
    'maximum' => 'maximum',
    'updated' => 'Updated',
    'number_of_days' => 'Number of days',
    'number_of_times' => 'Number of times',
    'sharekey_not_ready' => 'Sharekey not yet generated ... all item data may not be ready ... please try later',
    'item_action_not_yet_possible' => 'Action not yet possible on this item',
    'open' => 'Open',
    'reload_user_cache_table' => 'Reload user cache table',
    'send_email_to_user' => 'Send email to user',
    'items_management' => 'Items operations',
    'previously_used_passwords' => 'Previously used passwords',
    'next_passwords_were_valid_until_date' => 'Next passwords were valid until date',
    'feature_disabled_by_administrator' => 'Feature disabled by administrator',
    'shared_globaly' => 'Shared globaly',
    'settings_otv_subdomain' => 'OTV subdomain name',
    'settings_otv_subdomain_tip' => 'Dedicated subdomain for onetime links. Considere your main Teampass URL as isolated from internet, this subdomain could be reachable by everyone to share this item with someone outside your organisation. From security perspective it is a lot safer with such mechanics. Note: This would requite to have a DNS entry for this subdomain pointing to your Teampass server.',
    'existing_valid_otv_links' => 'OTV valid links',
    'started' => 'Started',
    'recovery_keys_not_downloaded' => 'Recovery keys not downloaded',
    'no_recovery_keys' => 'I do not have recovery keys. This will clear all passwords from my personal items.',
    'provide_recovery_keys' => 'Provide your recovery keys',
    'public_key' => 'Public key',
    'private_key' => 'Private key',
    'download_recovery_keys' => 'Download your recovery keys',
    'download_recovery_keys_confirmation' => 'You are about to download your recovery keys. Please store them in a safe place as they should be mandatory in case of disaster.',
    'recovery_keys_download_date' => 'Recovery keys download date',
    'keys_not_recovered' => 'Public and Private keys not stored',
    'keys_not_recovered_explanation' => 'In order to prevent against any passwords lost, you should store safely your personal Teampass keys',
    'get_your_recovery_keys' => 'Get your recovery keys',
    'keys_management' => 'Keys management',
    'please_confirm_task_to_be_run' => 'Please confirm the task to be performed',
    'user_keys_downloaded' => 'User keys downloaded',
    'mfa_code_send_by_email' => 'MFA code sent by email',
    'otp' => 'OTP',
    'otp_code' => 'OTP code',
    'enabled_otp_for_item' => 'Enable OTP code',
    'at_otp_status' => 'OTP status',
    'phone_number' => 'Related phone number (optional)',
    'otp_secret' => 'OTP secret key',
    'settings_ldap_group_objectclasses_attibute' => 'AD Group ObjectClasses attribute',
    'settings_ldap_group_objectclasses_attibute_tip' => 'The objectClasses to use when searching for groups. Several objectClasses are separated by a comma (,). Example: groupOfNames,group or top,posixGroup',
    'display_warning_icons' => 'Display warning icons',
    'password_length_by_default' => 'By default password length',
    'progress' => 'Progress',
    'tasks_log_retention_delay_in_days' => 'Tasks log retention delay (in days)',
    'tasks_log_table_size' => 'Tasks log table size',
    'error_otp_secret' => 'Enable to decode the OTP secret, is the secret correct?',
    'users_api_access_info' => 'Users can access the API with same access rights as in Teampass.',
    'error_folder_not_allowed_for_this_user' => 'Folder is not allowed for this user',
    'allowed_to_create' => 'Allowed to create',
    'allowed_to_read' => 'Allowed to read',
    'allowed_to_update' => 'Allowed to update',
    'allowed_to_delete' => 'Allowed to delete',
    'folder_created' => 'Folder created',
    'login_with_sso' => 'Login with SSO',
    'server_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet_tip' => 'This could lead to several functionnalities not working properly. Especially MFA',
    'tools' => 'Tools',
    'user_config_not_compliant' => 'User configuration is not compliant',
    'fix_personal_items_empty' => 'Fix personal items are empty',
    'fix_personal_items_empty_tip' => 'This tool permits to fix the issue where personal items are empty after a Teampass upgrade. It requires to have restored a copy of table teampass_items from Teampass version 2. The table needs to be named teampass_items_v2.',
    'table_not_exists' => 'Expected table does not exist. Please restore it from a backup.',
    'tools_usage_warning' => 'Using tools can have a direct impact on the database. Please be careful. Always perform a dump before and define a maintenance period.',
    'select_user' => 'Select user',
    'show_item_data' => 'Show item data in items list',
    'show_item_data_tip' => 'Permits to display extra information in the items list (username, email and url). This could be useful to have a quick view of the item content.',
    'items_page_split_view_mode' => 'Show item details in page split view mode',
    'replace_tenant_id' => 'Adapt the URL but keep {tenant-id} as is. It will be replaced live by the tenant ID.',
    'user_not_allowed_to_auth_to_teampass_app' => 'User is not allowed to authenticate with Teampass application',
    'user_is_not_auth_with_oauth2' => 'User should not authenticate with Entra/Azure AD',
    'highlight_favorites' => 'Highlight favorites',
    'highlight_favorites_tip' => '',
    'limited_search_default' => 'Limited search selected by default',
    'limited_search_default_tip' => '',
    'highlight_selected_tip' => '',
    'encryptClientServer' => 'Encrypt client-server exchanges',
    'encryptClientServer_tip' => 'When enabled, the client encrypts the data before sending it to the server. The server only stores encrypted data. It can be disabled.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL to get user details',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL to get user details. It is used to get user details after authentication.',
    'duo_redirect_uri' => 'Redirecting to Duo Prompt',
    'number_users_build_cache_tree' => '',
    'number_users_build_cache_tree_tip' => 'Number of users processed for build_cache_tree task at each run of the scheduler.',
    'user_password_expired' => 'Your password has expired. Please change it.',
    'user_password_policy_tip' => 'Th
e new password must:<br/> - Be different from the previous one<br/> - Contain at least 10 characters<br/> - Contain at least one uppercase letter and one lowercase letter<br/> - Contain at least one number or special character<br/> - Not contain your name, first name, username, or email.',
    'bruteforce_unlock_at' => 'Account unlocked at (anti bruteforce): ',
    'bruteforce_reset_account' => 'Reset anti bruteforce of user',
    'bruteforce_reset_mail_subject' => 'TEAMPASS - Your account is disabled',
    'bruteforce_reset_mail_body' => 'Hello #name#,<br/><br/>Your teampass account has been locked due to a large number of authentication failures.<br/><br/>You can unblock it by clicking on this link <a href="#reset_url#" target="_blank">#reset_url#</a><br/><br/>Automatic unlock: #unlock_at#',
    'disable_user_edit_profile' => 'Users can no longer edit their profile',
    'disable_user_edit_language' => 'Users can no longer change language',
    'disable_user_edit_timezone' => 'Users can no longer change time zones',
    'disable_user_edit_tree_load_strategy' => 'Users can no longer change tree loading strategy',
    'bruteforce_wait' => 'Too many failed attempts, your account is blocked until: ',
    'disable_drag_drop' => 'Disable item drag and drop',

);
