<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      german.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2024 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Benutzer-Verschlüsselungscode anzeigen',
    'email_body_new_user' => 'Hallo,<br><br>dies ist eine generierte E-Mail von Teampass Password Manager.<br><br> Ein Administrator hat für Sie ein Benutzerkonto auf Teampass erstellt. Wenn Sie sich das nächste Mal mit Teampass verbinden, verwenden Sie bitte die folgenden Anmeldedaten: <ul><li>login: #login#</li><li>Kennwort: #password#</li><li>Verschlüsselungscode: #code#</li></ul><br><br><br>Grüße',
    'user_password' => 'Benutzerpasswort',
    'user_temporary_encryption_code' => 'Benutzer-Verschlüsselungscode',
    'no_email_set' => 'Es wurde keine E-Mail-Adresse registriert',
    'send_user_password_by_email' => 'Entscheiden Sie, ob das Benutzer-Login-Passwort per E-Mail gesendet werden soll.<br>Wenn ja, dann drücken Sie die Schaltfläche Senden.<br><br>Stattdessen Verwenden Sie die Schaltfläche In Zwischenablage kopieren, um es auf andere Weise an den Benutzer zu senden.<br>Es liegt in Ihrer Verantwortung als Administrator, dem Benutzer das Passwort auf sichere Weise zur Verfügung zu stellen.',
    'admin_change_user_encryption_code_info' => 'Dieser Vorgang setzt den Verschlüsselungscode für diesen Benutzer zurück.',
    'send_by_email' => 'Via E-Mail senden',
    'filters' => 'Filter',
    'show_user_password' => 'Benutzerpasswort anzeigen',
    'open_website' => 'Webseite öffnen',
    'mfa_for_roles' => 'MFA wird für Benutzer in Rollen gefordert',
    'mfa_for_roles_tip' => 'Sobald eine MFA-Methode ausgewählt ist, ist sie standardmäßig für alle Benutzer aktiviert. Sie können jedoch die Rollen auswählen, für die dies erwartet wird.<br>NOCH NICHT IMPLEMENTIERT',
    'at_least_one_administrator_is_requested' => 'Mindestens ein Administrator ist erforderlich',
    'bad_code' => 'Fehlerhafter Code',
    'generating_keys' => 'Schlüssel generieren',
    'this_may_take_time' => 'Das kann einige Minuten dauern',
    'disable_enable' => 'Deaktivieren / Aktivieren',
    'user_disable_status' => 'Aktivieren Sie das Kontrollkästchen, um es zu deaktivieren, oder lassen Sie es leer, um es zu aktivieren.',
    'help_for_launching_items_encryption' => 'Wir müssen die Schlüsseldatenbank für Ihr Konto generieren. Bitte geben Sie Ihren Verschlüsselungscode an.',
    'managed_through_ad' => 'Durch Active Directory verwaltet',
    'new_ldap_user_info' => 'Bitte vervollständigen sie den Benutzer',
    'email_body_user_added_from_ldap_encryption_code' => 'Hallo, <br><br> Dies ist eine generierte E-Mail von Teampass Passwort Manager. <br><br>Sie haben jetzt ein Konto bei Teampass. Sie können sich mit Ihren AD-Anmeldedaten anmelden. <br><br>Wenn Sie sich zum ersten Mal anmelden, werden Sie aufgefordert, einen Verschlüsselungscode einzugeben, bitte verwenden Sie ihn: <br><br><b>#enc_code#</b><br><br><br> Herzliche Grüße',
    'settings_ldap_user_object_filter' => 'Benutzer Object Filter',
    'settings_ldap_user_object_filter_tip' => 'Der Filter wird genutzt, um nach Benutzerobjekte zu filtern. Zum Beispiel: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Der Wert wird benutzt, um die base DN zu ergänzen zum suchen und laden der Benutzer. Wenn keine Eingabe vorhanden ist, startet die Suche von der base DN. Zum Beispiel: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Erweiterete Benutzer DN',
    'ldap_user_has_changed_his_password' => 'Ihr Authentifizierungspasswort wurde in Ihrem LDAP geändert, seit Sie sich das letzte Mal in Teampass angemeldet haben. Wir müssen Ihren Verschlüsselungscode anpassen. Bitte geben Sie Ihr vorheriges und das aktuelle Passwort an.',
    'provide_your_previous_password' => 'Vorheriges Passwort',
    'admin_change_user_password_info' => 'Diese Handlung wird Passwort des ausgewählten Benutzers zurücksetzen.',
    'sending_email_message' => 'E-Mail wird an Benutzer gesendet, bitte warten',
    'change_your_password_info_message' => 'Bitte gib das neue Passwort ein und bestätige es.',
    'user_has_to_change_password_info' => 'Das Passwort wurde zurückgesetzt und muss aus Sicherheitsgründen geändert werden.',
    'ready_to_go' => 'Fertig für die Nutzung',
    'passwords_not_the_same' => 'Passwörter stimmen nicht überein',
    'inititialization' => 'Initialization',
    'bad_password' => 'Schlechtes Passwort',
    'perform_checks' => 'Führe Überprüfungen durch',
    'email_body_temporary_encryption_code' => 'Hallo, <br><br>Dies ist eine generierte E-Mail von Teampass Passwort Manager.<br><br>Einige Änderungen wurden mit deinem Account durchgeführt, welche eine neu Verschlüsselung der Einträge benötigt für die Datensicherheit. Beim nächsten Login zu Teampass, bitte nutze diesen code:<br><br><b>#enc_code#</b><br><br><br>Herzliche Grüße',
    'temporary_encryption_code' => 'Dein temporärer Verschlüsselungscode',
    'renecyption_expected' => 'Wir müssen Ihre Passwörter neu verschlüsseln, um sie an die Ihrem Konto und Ihren Rechten entsprechenden Privilegien anzupassen.',
    'error_no_user_in_ad' => 'Benutzer im AD nicht gefunden',
    'error_ad_user_expired' => 'Benutzerkonto ist abgelaufen!',
    'error' => 'Fehler abgefangen',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'Die Hostoption ist ein Array aus IP Adressen oder Hostnames, welche sich in dem Netzwerk befinden und LDAP Directory konfiguriert sind (Komma getrennt). Du kannst so viele Server hinzufügen wie du willst, aber es wird mindestens einer benötigt.',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'Die Root DN, welche benutzt werden soll für die Suchanfragen zu dem Directory Server. Zum Beispiel: : o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Benutzername',
    'settings_ldap_username_tip' => 'Die DN von dem Benutzer, welche die Anwendung werden soll, wenn es sich mit dem AD-Server verbinden will. Zum Beispiel: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'Das Passwort von dem oben spezifizierten Benutzer.',
    'settings_ldap_port_tip' => 'Standard unverschlüsselter LDAP Port: 389, Standard verschlüsselter LDAP Port: 636',
    'undefined' => 'Undefiniert',
    'error_cannot_open_file' => 'Datei kann nicht geöffnet werden',
    'provide_current_psk_and_click_launch' => 'Wenn fertig, klicke auf Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Dateninkonsistenz festgestellt. Bitte Seite neu laden!',
    'one_time_code_expected' => 'Einmal-Passwort erwartet',
    'data_are_missing' => 'Erwartete Datensätze fehlen',
    'one_time_code' => 'Einmal-Passwort',
    'provide_personal_one_time_code' => 'Bitte tragen Sie das Einmal-Passwort ein, welches Sie per E-Mail erhalten haben',
    'change_authentification_type_to_ldap' => 'Ändert den Authentifizierungstyp zu LDAP',
    'change_authentification_type_to_local' => 'Ändert den Authentifizierungstyp zu der lokalen Datenbank von Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Benutzerpasswort in LDAP wird zur Authentifizierung verwendet',
    'local_user_password_is_used_for_authentication' => 'Das Benutzerpasswort in Teampass wird zur Authentifizierung verwendet',
    'provide_your_current_password' => 'Geben Sie Ihr aktuelles Passwort ein',
    'current_password' => 'Aktuelles Passwort',
    'password_is_not_correct' => 'Das Passwort ist falsch',
    'ldap_password_change_warning' => 'Ihr Login-Passwort hat sich seit der letzten Verbindung geändert. Sie werden gebeten, alle Schlüssel mit diesem neuen Passwort neu zu verschlüsseln. Für diesen Vorgang geben Sie bitte im nächsten Feld Ihr bisheriges ldap-Passwort ein. Dieser Vorgang kann einige Minuten dauern.',
    'personal_items' => 'Persönliche Einträge',
    'logout_on_going' => 'Sie werden nun abgemeldet. Bitte benutzen Sie ab sofort Ihr neues Passwort.',
    'fill_in_fields_and_hit_launch' => 'Geben Sie die erwarteten Daten ein und klicken Sie auf Start',
    'please_select_a_folder' => 'Bitte wähle einen Ordner aus',
    'user_must_have_login_and_email' => 'Benutzer muss ein Login und eine E-Mail haben',
    'user_has_this_role_in_teampass' => 'Benutzer hat diese Rolle in Teampass',
    'select_role_to_create' => 'Wähle die zu erstellende Rolle aus',
    'adding_ldap_role_to_teampass' => 'Sie können sich entscheiden, eine Rolle in Teampass zu erstellen, die aus Ihrem Active Directory stammt. Dies wird es ermöglichen, den Benutzer mit dieser Rolle in Teampass zu verbinden.',
    'add_user_to_role' => 'Fügen Sie diese Rolle dem Benutzer in Teampass hinzu',
    'add_user_in_teampass' => 'Benutzer in Teampass hinzufügen',
    'synchronized' => 'Synchronisiert',
    'output' => 'Ausgabe',
    'remove_install_folder' => 'Installations-Ordner muss entfernt werden',
    'list_users' => 'Benutzer auflisten',
    'ldap_synchronization' => 'LDAP Synchronization',
    'in_progress' => 'In Bearbeitung',
    'clipboard_password_life_duration' => 'Zeit bis der Zwischenspeicher gelöscht wird (in Sekunden)',
    'clipboard_password_life_duration_tip' => 'Ermöglicht die Definition einer Verzögerung in Sekunden, bevor das in der Zwischenablage kopierte Kennwort aus der Zwischenablage des Browsers gelöscht wird. Zum Deaktivieren auf 0 setzen.',
    'clipboard_will_be_cleared' => 'Das Passwort ist jetzt in der Zwischenablage. Es wird bald wieder gelöscht...',
    'file_folder_not_accessible' => 'Auf den Dateiordner kann nicht zugegriffen werden',
    'error_missing_id' => 'Es ist ein Fehler aufgetreten. Fehlende ID ... ?',
    'error_folder_not_allowed' => 'Ausgewählter Ordner ist nicht erlaubt',
    'all_fields_mandatory' => 'Alle Felder sind Pflicht',
    'history_insert_entry' => 'Ins Log hinzufügen',
    'clear_form' => 'Formular leeren',
    'info_about_history_insertion' => 'Achtung - Mit dieser Funktion können Sie manuell ein Ereignis in das Log einfügen. Einmal hinzugefügt, ist es nicht mehr möglich, es zu entfernen. Beachten Sie auch, dass Ihre Kontonummer mit diesem neuen Eintrag verknüpft wird.',
    'select_all' => 'Alle auswählen',
    'unselect_all' => 'Alles abwählen',
    'no_data_to_display' => 'Keine Daten anzuzeigen! Entweder gibt es noch keinen Ordner, oder Sie haben Zugriff auf keinen Ordner.',
    'server' => 'Server',
    'data_refreshed' => 'Daten aktualisiert',
    'loading_image' => 'Bild wird geladen',
    'compare_with_another_role' => 'Vergleich mit einer anderen Rollen',
    'only_display_folders_to_depth' => 'Ordner nur bis zur Tiefe anzeigen',
    'propagate_rights_to_descendants' => 'Rechte vererben',
    'loading_data' => 'Daten werden geladen',
    'password_overview_delay' => 'Verzögerung für die Passwortübersicht',
    'password_overview_delay_tip' => 'Mit dieser Einstellung kann die Anzahl der Sekunden festgelegt werden, die dem Benutzer das sichtbare Passwort angezeigt wird.',
    'select_date_showing_items_expiration' => 'Auflistung der abgelaufenen Einträge am',
    'renewal_page_info' => 'Auf dieser Seite können Sie die aktuell abgelaufenen oder in der nächsten Zeit ablaufenden Einträge identifizieren.',
    'filename' => 'Dateiname',
    'exported_to_file' => 'In Datei exportieren',
    'operation_progress' => 'Vorgang wird bearbeitet',
    'exporting_items' => 'Einträge werden exportiert',
    'select_folders_to_export' => 'Ordner für den Export auswählen',
    'export_format_type' => 'Wähle das Format des Exports',
    'export_items' => 'Exportiere Einträge',
    'loading_item' => 'Eintrag wird geladen',
    'otv_message' => 'Sie können dieses Element mit jemandem teilen, der kein Teampass-Konto hat. Die einmalige Ansicht erlaubt es Ihrem Gast, nur einmal auf grundlegende Felder dieses Artikels zuzugreifen, ohne in Teampass authentifiziert zu sein. Bitte beachten Sie, dass dieser Link für einen Zeitraum von ##otv_expiration_period## Tagen gültig ist. Kopieren Sie den unten stehenden Link und teilen Sie ihn.',
    'no_sharekey_found' => 'Es wurde kein Schlüssel für diese Datei und Ihr Benutzer gefunden',
    'otv_link' => 'Link für Einmal-Ansicht',
    'one_time_view' => 'Einmal-Ansicht',
    'move_right_columns_separator' => 'Spaltentrenner nach rechts verschieben',
    'move_left_columns_separator' => 'Spaltentrenner nach links verschieben',
    'form_presents_inconsistencies' => 'Das Formular weist einige Ungereimtheiten auf. Bitte überprüfen Sie die rot umrandeten Felder.',
    'download' => 'Herunterladen',
    'see' => 'Anzeigen',
    'at_anyoneconmodify' => 'Jeder kann es Bearbeiten',
    'disabled' => 'Deaktiviert',
    'enabled' => 'Aktiviert',
    'confirmation_seems_wrong' => 'Bestätigung scheint falsch zu sein, bitte korrigieren',
    'i_cannot_remember' => 'Ich kann mich nicht errinnern',
    'i_cannot_remember_info' => 'Diese Aktion kann nicht rückgängig gemacht werden. Sie löscht die in Ihren persönlichen Einträgen gespeicherten Passwörter. Die Einträge werden nicht gelöscht, sondern nur ihre Passwörter. Wenn Sie sich nicht an Ihren persönlichen Saltkey erinnern können, ist dies die einzige Möglichkeit.',
    'user_has_psk_info' => 'Wir haben festgestellt, dass Sie einige persönliche Einträge mit einem alten persönlichen Saltkey verschlüsselt haben. Dieser Schritt zielt darauf ab, sie mit Ihrem neuen privaten Schlüssel neu zu verschlüsseln. Bitte teilen Sie uns Ihren persönlichen Saltkey mit.',
    'files' => 'Dateien',
    'logs' => 'Protokoll',
    'suggestions' => 'Vorschläge',
    'encryption_keys' => 'Verschlüsselungsschlüssel',
    'clearing_old_sharekeys' => 'Löscht alte geteilte Schlüssel',
    'hit_launch_to_start' => 'Bitte klicken Sie zum Starten auf die Schaltfläche Start',
    'password_changed' => 'Passwort aktualisiert',
    'password_already_used' => 'Passwort wird bereits verwendet',
    'change_login_password' => 'Ändere das Loginpasswort',
    'current_password_mandatory' => 'Das Aktuelle Passwort ist obligatorisch',
    'objects_encryption_explanation' => 'Teampass ist auf eine neue Version aktualisiert worden, die ein neues Verschlüsselungsprotokoll enthält. Es erwartet von Ihnen, dass Sie Ihre persönlichen Gegenstände erneut verschlüsseln. Hierfür müssen Sie Ihren aktuellen Personal Salt Key (PSK) angeben. Klicken Sie anschließend auf die Schaltfläche Starten und warten Sie, bis der Prozess den letzten Schritt erreicht hat. Dies kann je nach Anzahl der Objekte einige Minuten dauern.',
    'description_has_changed' => 'Die Beschreibung wurde geändert',
    'number_of_folders_imported' => 'Anzahl der importierten Ordner',
    'number_of_items_imported' => 'Anzahl der importierten Einträge',
    'propagate' => 'Vererbung',
    'propagate_user_rights' => 'Vererbung von Nutzerberechtigungen',
    'register_new_yubiko_key' => 'Neuen YubiKey registrieren',
    'part_of_groups' => 'Mitglied von den Gruppen',
    'previous_value' => 'Vorheriger Wert',
    'no_previous_value' => 'Kein vorheriger Wert',
    'no_data_selected' => 'Keine Daten ausgewählt',
    'selected_items_to_be_imported' => 'Einträge zum Importieren auswählen',
    'cannot_open_file' => 'Datei kann nicht geöffnet werden',
    'no_item_found' => 'Kein Eintrag gefunden',
    'reading_file' => 'Lese die Datei',
    'where_shall_items_be_created' => 'Wo sollen die Posten erstellt werden?',
    'target_folder' => 'Zielordner',
    'select_file' => 'Wähle Datei',
    'data_type_for_import' => 'Wählen Sie zunächst den Quelltyp der zu importierenden Daten aus',
    'get_tips_about_importation' => 'Weitere Informationen übers Importieren',
    'import_new_items' => 'Einträge importieren',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'für',
    'request_access' => 'Anfrage für Zugriff auf Eintrag',
    'request_access_message' => 'Für den Zugriff auf einen Eintrag wird eine E-Mail an den Autor gesendet. Dieser kann die Anfrage annehmen oder ablehnen. Bitte bestätigen Sie, dass die Anfrage jetzt via E-Mail an den Autor gesendet werden soll.',
    'request_access_reason' => 'Bitte geben Sie den Grund für die Anfrage an',
    'error_provide_reason' => 'Bitte geben Sie den Grund an, warum Sie auf diesen Artikel zugreifen möchten',
    'need_access' => 'Zugriff benötigt?',
    'item_with_restricted_access' => 'Eintrag mit eingeschränktem Zugang',
    'remaining_emails_to_send' => 'Verbleibende E-Mails zum Senden',
    'mfa_flash' => 'Flash mit Ihrem mobilen Gerät',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Ihre Aufmerksamkeit ist erforderlich. Mindestens ein Anmeldeversuch mit Ihrem Konto wurde seit der letzten erfolgreichen Verbindung festgestellt. Bitte überprüfen Sie dies und melden Sie sich bei Ihrem lokalen Administrator, wenn Sie es nicht waren.',
    'last_login_attempts' => 'Letzte Login-Versuche',
    'see_detail' => 'Details einblenden',
    'role_definition' => 'Rollen Erstellung',
    'not_yet_implemented' => 'Noch nicht implementiert',
    '2factors_expected_for_admin' => 'Administrator benötigt MFA zur Anmeldung',
    '2factors_expected_for_admin_tip' => 'Standardmäßig muss ein Administrator eine MFA-Methode verwenden, um angemeldet zu werden. Wenn sie nicht aktiviert ist, benötigt der Administrator sie nicht, um sich anzumelden, selbst wenn MFA für einen anderen Benutzer aktiviert ist.',
    'restore_done_now_logout' => 'Die Wiederherstellung der Datenbank ist abgeschlossen. Sie müssen nun die Verbindung trennen, um die Sitzungsvariablen zu aktualisieren.',
    'backup_and_restore' => 'Sichern und Wiederherstellen',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Sicherung durchführen',
    'perform_restore' => 'Wiederherstellung durchführen',
    'backup_select' => 'Backup Datei',
    'choose_file' => 'Wähle Datei',
    'on_the_fly' => 'Jetzt',
    'scheduled' => 'Geplant',
    'caution_on_field_encryption_change' => 'Achtung - Beachten Sie, dass bei einer Änderung des Verschlüsselungstyps alle vorhandenen Daten analysiert werden müssen, um die Verschlüsselung in der Datenbank zu ändern.',
    'caution_while_deleting_field' => 'Achtung - Beim Löschen dieses Feldes werden die zugehörigen Daten in allen Einträgen gelöscht',
    'error_could_not_update_the_field' => 'Fehler - Das Feld konnte nicht aktualisiert werden. Bitte versuchen Sie es erneut, nachdem Sie die Seite neu geladen haben.',
    'caution_while_deleting_category' => 'Achtung - Beim Löschen dieses Ordners werden alle zugehörigen Felder und auch alle feldbezogenen Daten gelöscht.',
    'your_attention_please' => 'Deine Aufmerksamkeit bitte',
    'all_fields_are_required' => 'Alle Felder werden benötigt',
    'position' => 'Position',
    'before' => 'Vorher',
    'top' => 'Oben',
    'bottom' => 'Unten',
    'field' => 'Feld',
    'configuration' => 'Einstellung',
    'definition' => 'Definition',
    'number_of_modified_attachments' => 'Anzahl der geänderten Anhänge',
    'files_not_encrypted' => 'Die Dateien sind derzeit nicht verschlüsselt. Sie sollten diese Änderung aus Sicherheitsgründen vornehmen.',
    'files_already_encrypted' => 'Die Dateien sind bereits verschlüsselt. Sie sollten dies aus Sicherheitsgründen nicht ändern.',
    'action_to_be_performed' => 'Auszuführende Aktion',
    'last_execution' => 'Letzte Ausführung',
    'never_performed' => 'Nie ausgeführt',
    'launch' => 'Start',
    'set_of_actions' => 'Liste von Aktionen',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Mailkonfiguration',
    'email_configuration_test' => 'E-Mail-Konfiguration testen',
    'send_a_test_email' => 'Test-E-Mail senden',
    'manage_emails_not_sent' => 'Verwalte nicht gesendete E-Mails',
    'email_send_backlog' => '#nb_emails# nicht gesendete E-Mails',
    'send_waiting_emails' => 'Sende wartende E-Mails',
    'ip' => 'IP',
    'no_data_defined' => 'Keine Daten vorhanden',
    'adding_new_api_ip' => 'IP-Adresse zur Whitelist hinzufügen',
    'adding_new_api_key' => 'API-Key hinzufügen',
    'api_configuration' => 'API Einstellungen',
    'mfa_configuration' => 'MFA Einstellungen',
    'yubico_authentication_tip' => 'Bitte besuche www.yubico.com für mehr Einzelheiten',
    'complexity_level_not_reached' => 'Komplexitätsgrad wird nicht erreicht',
    'expected_complexity_level' => 'Erwartetes Komplexitätsniveau',
    'your_attention_is_required' => 'Deine Aufmerksamkeit wird benötigt',
    'favorite' => 'Zu Favoriten hinzufügen',
    'unfavorite' => 'Aus Favoriten entfernen',
    'you_need_to_select_at_least_one_folder' => 'Sie müssen mindestens einen Ordner auswählen',
    'no_value_defined_please_fix' => 'Kein Wert definiert! Bitte fixen.',
    'apply' => 'Anwenden',
    'from' => 'Von',
    'please_confirm_by_clicking_checkbox' => 'Bitte durch markieren der Checkbox bestätigen',
    'date_range' => 'Datenbereich',
    'purge' => 'Bereinigung',
    'belong_of_deleted_folder' => 'Gehört zu einem gelöschten Ordner',
    'highlight_selected' => 'Ausgewählte hervorheben',
    'number_of_selected_objects' => 'Anzahl ausgewählter Objekte',
    'confirm_selection_restore' => 'Bitte bestätigen Sie das Wiederhertellen der ausgewählten Einträge.',
    'confirm_selection_delete' => 'Bitte bestätigen Sie das Löschen der ausgewählten Einträge.',
    'refreshing' => 'Aktualisiere',
    'empty_list' => 'Leere Liste',
    'deleted_folders' => 'Gelöschte Ordner',
    'deleted_items' => 'Gelöschte Einträge',
    'recycled_bin' => 'Papierkorb',
    'database' => 'Datenbank',
    'renewal' => 'Abgelaufene Einträge',
    'renewal_delay' => 'Verzögerung, bis das Passwort erneuert werden muss',
    'please_confirm_deletion' => 'Bitte bestätigen Sie die Löschung',
    'caution' => 'Achtung',
    'role_not_exist' => 'Diese Rolle existiert nicht!',
    'role_can_edit_any_visible_item' => 'Rolle kann jeden sichtbaren Eintrag bearbeiten',
    'role_can_edit_any_visible_item_tip' => 'In der Regel ist dieses Kontrollkästchen nicht markiert. Wenn es aktiviert ist, kann ein Benutzer mit dieser Rolle jedes Element bearbeiten, das er öffnen kann, was zu einem unsicheren Status führt. Es sollte nur für einen bestimmten Zeitraum und bei Bedarf aktiviert werden.',
    'edit_allowed' => 'Änderungen erlaubt',
    'delete_allowed' => 'Löschen erlaubt',
    'add_allowed' => 'Hinzufügen erlaubt',
    'edit_not_allowed' => 'Ändern nicht erlaubt',
    'delete_not_allowed' => 'Löschen nicht erlaubt',
    'select_a_role' => 'Rolle auswählen',
    'access_rights_for_user' => 'Zugriffsberechtigungen für Benutzer',
    'logs_for_user' => 'Logs für Benutzer',
    'please_confirm' => 'Bitte bestätigen',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Mit dem Markieren der Checkbox wird die Löschung des Benutzers bestätigt.',
    'fields_with_mandatory_information_are_missing' => 'Felder mit benötigten Informationen fehlen',
    'enable_personal_folder_for_this_user' => 'Erlaube das Persönlicherordner Feature für diesen Nutzer',
    'special' => 'Spezial',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass Manager',
    'manager' => 'Manager',
    'read_only' => 'Lese Berechtigung',
    'privileges' => 'Berechtigungen',
    'roles' => 'Rollen',
    'user_definition' => 'Benutzerdefinition',
    'no_selection_done' => 'Keine Auswahl getroffen',
    'tick_confirmation_box' => 'Bitte aktivieren Sie das Kontrollkästchen zur Bestätigung',
    'next_list_to_be_deleted' => 'Die nächste Liste wird gelöscht',
    'delete_folders' => 'Lösche Ordner',
    'submit' => 'Abschicken',
    'label' => 'Bezeichnung',
    'parent' => 'Übergeordenter Ordner',
    'password_minimal_complexity_target' => 'Minimale Passwort Zielstärke',
    'access_right_for_roles' => 'Berechtigungen für die Rollen',
    'create_without_password_minimal_complexity_target' => 'Erlauben Sie die Erstellung eines neuen Eintrags ohne Mindestkomplexität des Passworts',
    'edit_without_password_minimal_complexity_target' => 'Erlaubt das Bearbeiten von Einträgen ohne Mindestkomplexität des Passworts',
    'add_new_folder' => 'Neuer Ordner',
    'new' => 'Neu',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multifaktorenauthentifizierung',
    'google_2fa' => 'Google 2-Schritt Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Teampass-Website öffnen',
    '2fa_credential_not_correct' => '2FA-Anmeldeinformationen sind nicht korrekt',
    'no_change_performed' => 'Es wurde keine Änderung vorgenommen.',
    'password_strength' => 'Passwortstärke',
    'new_password_required' => 'Ein neues Passwort wird benötigt.',
    'limited_search' => 'Limitierte Suche',
    'empty_psk' => 'Saltkey fehlt',
    'currently_no_favorites' => 'Sie haben momentan keine Favoriten',
    'favorites' => 'Favoriten',
    'confirm_item_move' => 'Sie haben "Verschieben" ausgewählt... sind Sie sicher?',
    'copy_to_clipboard' => 'In Zwischenablage kopiert',
    'please_wait_while_loading' => 'Bitte warten Sie, während die Daten geladen werden',
    'defect_report' => 'Bug melden',
    'actions' => 'Aktionen',
    'no_user' => 'Falscher Benutzer',
    'generate_api_token' => 'Neuer generierter API Token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profil',
    'language' => 'Sprache',
    'upload_new_avatar' => 'PNG-Datei für Avatar auswählen',
    'settings' => 'Einstellungen',
    'created_items' => 'Erstellte Einträge',
    'modification_performed' => 'Änderungen druchgeführt',
    'items_opened' => 'Geöffnete Einträge',
    'passwords_seen' => 'Gesehene Passwörter',
    'nothing_to_save' => 'Nichts zu speichern',
    'notification_engaged' => 'Sie erhalten Benachrichtigungen über Eintragsänderungen',
    'notification_not_engaged' => 'Sie erhalten keine Benachrichtigungen über Eintragsänderungen',
    'viewed_number' => 'Anzahl der Ansichten',
    'automatic_deletion_engaged' => 'Automatisches Löschen',
    'auto_update_enabled' => 'Automatische Änderung des Benutzerpassworts aktiviert. Nächste Änderung geplant',
    'copy_folder' => 'Ordner kopieren',
    'select_source_folder' => 'Wähle Ordner aus zum Kopieren',
    'select_destination_folder' => 'Wähle Zielordner aus',
    'delete_folder' => 'Ordner löschen',
    'select_folder_to_delete' => 'Wähle Ordner zum Löschen',
    'folder_delete_confirm' => 'Der gelöschte Ordner und seine Elemente werden gelöscht. Bitte aktivieren Sie das Kontrollkästchen, um diese Löschung zu bestätigen.',
    'json_error_format' => 'Schlechtes JSON format',
    'password_cannot_be_empty' => 'Passwort darf nicht leer sein',
    'password_too_long' => 'Passwort ist zu lang',
    'error_no_action_identified' => 'Es wurden keine Maßnahmen ermittelt.',
    'ldap' => 'LDAP',
    'emails' => 'E-Mails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Neuer Ordner hinzufügen',
    'select_folder_parent' => 'Wähle übergeordneten Ordner aus',
    'add' => 'Hinzufügen',
    'key_is_not_correct' => 'Bereitgestellter Sitzungsschlüssel ist nicht korrekt',
    'suggestion_information' => 'Sie können dem Ersteller Änderungen an diesem Eintrags vorschlagen. Verwenden Sie das obige Formular, um Ihre Änderungsvorschläge zu machen und klicken Sie auf Durchführen, um den Autor zu informieren.',
    'email_address' => 'E-Mail-Adresse',
    'enter_email' => 'E-Mail eingeben',
    'notification' => 'Benachrichtigung',
    'notify_on_change' => 'Benachrichtige mich bei Änderungen',
    'notification_message' => 'Mit dieser Einstellung können Sie festlegen, ob Sie über Änderungen an diesem Element benachrichtigt werden möchten oder nicht.',
    'share_item' => 'Eintrag teilen',
    'share_item_message' => 'Sie können diesen Artikel mit jemandem teilen. Bitte geben Sie eine gültige E-Mail-Adresse an und klicken Sie auf <b>Durchführen</b>.',
    'delete_item_message' => 'Sie haben beschlossen, das ausgewählte Element zu löschen. Sie müssen Ihre Wahl bestätigen, indem Sie auf Durchführen klicken.',
    'warning' => 'Warnung',
    'information' => 'Information',
    'perform' => 'Durchführen',
    'delete_item' => 'Lösche Eintrag',
    'copy_item' => 'Kopiere Eintrag',
    'new_item' => 'Neuer Eintrag',
    'error_not_allowed_to_edit_item' => 'Du bist nicht berechtigt diesen Eintrag zu bearbeiten',
    'error_not_allowed_to_access_this_folder' => 'Du bist nicht berechtigt auf diesen Eintrag zuzugreifen',
    'error_personal_saltkey_is_not_set' => 'Ihr persönlicher Saltkey wird nicht bereitgestellt.',
    'provide_your_personal_saltkey' => 'Bitte geben Sie Ihren persönlichen Salzschlüssel an',
    'no_fields' => 'Kein Feld bezieht sich auf diesen Eintrag.',
    'uploaded' => 'Hochgeladen',
    'changes_ongoing' => 'Einige Änderungen wurden nicht gespeichert. Bestätigen Sie das Beenden ohne zu speichern?',
    'no_file_to_upload' => 'Keine Datei zum Hochladen',
    'add_files_and_click_start' => 'Fügen Sie Dateien zur Upload-Warteschlange hinzu und klicken Sie auf die Schaltfläche Start.',
    'select_files' => 'Wähle Dateien aus',
    'attached_files' => 'Angehängte Dateien',
    'visible_by' => 'Sichtbar für',
    'anounce_item_by_email' => 'Benachrichtige die Benutzer über diesen Eintrag per Mail',
    'select_users_if_needed' => 'Wähle Nutzer aus falls gewünscht',
    'allow_item_to_be_deleted' => 'Zulassen, dass diesen Eintrag bei der nächsten Bedingung gelöscht wird',
    'item_deleted_after_being_viewed_x_times' => 'Eintrag wird nach X Aufrufen gelöscht',
    'item_deleted_after_date' => 'Eintrag wird nach dem festgelegten Datum gelöscht',
    'password' => 'Passwort',
    'save' => 'Speichern',
    'folder' => 'Ordner',
    'main' => 'Hauptseite',
    'fields' => 'Felder',
    'details' => 'Details',
    'no_special_restriction' => 'Keine besondere Einschränkung',
    'generate_otv_link' => 'One-Time-View-Link generieren',
    'no_custom_fields' => 'Keine benutzerdefinierte Felder',
    'no_attachment' => 'Kein Anhang',
    'logout_confirm' => 'Abmelden? Bitte bestätigen.',
    'saved' => 'Gespeichert',
    'attachments' => 'Anhang',
    'success' => 'Erfolgreich',
    'server_answer_error' => 'Fehler geworfen. Antwort vom Server kann nicht geparst werden.',
    'server_returned_data' => 'Zurückgegebene Daten',
    'version_alone' => 'Version',
    'statistics' => 'Statistik',
    'options' => 'Optionen',
    'users' => 'Benutzer',
    'folders' => 'Ordner',
    'find_message' => 'Objekte gefunden ',
    'auto_update_server_password_info' => 'Der Klick auf den START-Knopf wird folgende Schritte automatisch ausführen:<ul><li>Verbinden mit dem Linuxserver per SSH mittels der Anmeldedaten und des `URL`-Feldes</li><li>Ändern des Benutzer-Passwortes auf dem Linuxserver</li><li>Sichern des Passwortes in Teampass</li><li>Schließen der SSH-Verbindung</li></ul><br /><b>Bitte stellen Sie vor dem Start sicher, dass der Benutzer auf dem Linuxserver root-Rechte hat (falls nicht, kennzeichnen Sie den root-Benutzer und -Passwort).</b>',
    'share' => 'Dieses Element teilen',
    'notify' => 'Benachritigen',
    'error_no_selected_folder' => 'Sie müssen ein Verzeichnis auswählen',
    'email_subject_item_updated' => 'Passwort wurde geändert.',
    'email_body_item_updated' => 'Hallo,<br/>das Passwort für &apos;#item_label#&apos; wurde geändert.<br /><br />Sie können es <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">hier</a> einsehen<br /><br /><br /><br />Gruß',
    'import_kp_finished' => 'Der Import der KeePass-Daten ist nun abgeschlossen! Standardmäßig wird die erforderliche Passwortkomplexität für neue Ordner auf `Mittel´ eingestellt. Bei Bedarf bitte ändern.',
    'password_is_empty' => 'Element hat kein Passwort',
    'bug_report_to_github' => 'Füllen Sie den Berichts aus, kopieren ihn in die Zwischenablage und fügen ihn dann in die Github New Issue Page ein.',
    'open_bug_report_in_github' => 'Neue Meldung auf Github eröffnen',
    'bugs_page' => 'Wenn Sie einen Fehler entdecken, melden Sie ihn bitte.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Benutzerrecht "Änderbar durch alle derselben Rolle" für alle importierten Elemente setzen',
    'import_csv_anyone_can_modify_txt' => 'Benutzerrecht "Änderbar durch alle" für alle importierten Elemente setzen',
    'settings_upload_imageresize_options' => 'Sollte die Größe der Bilder verändert werden?',
    'user_not_exists' => 'Dieser Benutzer existiert nicht!',
    'auto_create_folder_role' => 'Ordner und Rolle erstellen für',
    'start_upload' => 'Beginne die Dateien hochzuladen',
    'error_upload_runtime_not_found' => 'Funktion zum Hochladen: keine Laufzeit gefunden.',
    'user_profile_api_key' => 'Dein API key',
    'index_change_pw' => 'Ändern Sie Ihr Passwort',
    'admin_2factors_authentication_setting' => '2-Faktor-Authentifizierung von Google aktivieren',
    'admin_2factors_authentication_setting_tip' => 'Die 2-Faktor-Authentifizierung von Google erlaubt es eine zusätzliche Sicherheitsschicht für die Benutzerauthentifizierung einzuführen. Möchte sich ein Benutzer im Teampass anmelden, wird ein QR-Code generiert. Dieser QR-Code muss anschließend vom Benutzer eingelesen werden, um ein Einmalpasswort zu erhalten. Vorsicht: hierfür wird  eine Internetverbindung und ein Lesegerät (z.B. ein Smartphone) benötigt.',
    'admin_ga_website_name' => 'Angezeigter Name in Google Authenticator für Teampass',
    'admin_ga_website_name_tip' => 'Dieser Name wird für das Identifizierungscode-Konto in Google Authenticator benutzt.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'Wenn hier keine API-Client-IP-Adressen explizit aufgeführt sind, ist jede IP-Adresse zulässig.',
    'email_share_item_subject' => 'Ein Element wurde Ihnen mitgeteilt',
    'email_share_item_mail' => 'Hallo, #tp_user# teilt mit Ihnen das Passwort für #tp_item#. Zum Öffnen klicken Sie bitte auf diesen <br><br><a href="#tp_link#">Link</a>. <br><br><br>Herzliche Grüße',
    'index_maintenance_mode_admin' => 'Der Wartungsmodus wurde aktiviert. Benutzer können z. Zt. nicht auf Teampass zugreifen.',
    '2fa_authentication_selector' => 'Wähle eine 2 Faktorauthentifizierung aus',
    'upload_empty_file' => 'Leere Datei hochladen',
    'upload_any_extension_file' => 'Jedes Dateiformat hochladen',
    'upload_any_extension_file_tip' => 'Wenn diese Option aktiviert ist, können Nutzer jede Art von Dateien hochladen.',
    'log_in' => 'Anmelden',
    'create_item_based_upon_template' => 'Verwendung der Vorlage für Item',
    'create_item_based_upon_template_tip' => 'Wenn diese Funktion aktiviert ist, kann der Autor eine Vorlage auswählen, die aus benutzerdefinierten Feldern besteht. Beachten Sie, dass für diese Funktion auch benutzerdefinierte Felder aktiviert sein müssen.',
    'main_template' => 'Benutze eine Vorlage',
    'is_mandatory' => 'Ist verpflichtend',
    'error_field_is_mandatory' => 'Mindestens ein Pflichtfeld ist leer',
    'restrict_visibility_to' => 'Eingeschränkte Sichtbarkeit für',
    'every_roles' => 'Jede Rolle',
    'masked_text' => 'Maskierter Text',
    'textarea' => 'Textfeld',
    'admin_yubico_authentication_setting' => 'Aktiviere Yubico Authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Falsche Yubico Informationen',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Teampassmanager',
    'settings_secure_display_image' => 'Aktivieren von sichers Anzeigen der Bilder',
    'settings_secure_display_image_tip' => 'Die sichere Bildanzeige ermöglicht es, das Bild über PHP zu lesen, wenn ein Benutzer eine Vorschau eines an einen Artikel angehängten Bildes anschaut. Pro: Der Anhang wird außerhalb des Website-Ordners gespeichert und ist für einen Hacker nicht zugänglich. Nachteil: Es ist etwas langsamer als die Vorschau direkt von einer URL.',
    'user_ga_code' => 'Google-Authenticator per E-Mail an Benutzer senden',
    'error_no_email' => 'Für diesen Nutzer wurde keine E-Mail-Adresse festgelegt.',
    'error_no_user' => 'Benutzer nicht gefunden!',
    'email_ga_subject' => 'Ihr Google Authenticator Flashcode für Teampass',
    'email_ga_text' => 'Hallo,<br><br>dies ist eine automatisch generierte E-Mail vom Teampass Passwort Manager.<br><br>Der Administrator möchte, dass Sie die Zwei-Wege-Authentifizierung verwenden, um eine sichere Verbindung zu Teampass herzustellen. Für Ihre erste Verbindung zu Teampass verwenden Sie bitte den Code, den Sie weiter unten im Feld "Identication code" finden: <br><br>--------------------------------------<br>#2FACode#<br>--------------------------------------<br><br> Sie haben dann die Möglichkeit, Ihre einmaligen Zugangsdaten für den Teampass-Passwortmanager einzurichten.<br><br>Grüße',
    'settings_attachments_encryption' => 'Verschlüsselung von Dateianhängen erlauben',
    'settings_attachments_encryption_tip' => 'Diese Option könnte vorhandene Anhänge Beschädigen - Ist diese Option aktiviert werden Elementanhänge auf dem Server verschlüsselt gespeichert. Die Verschlüsselung benutzt den in Teampass vorgegebenen SALT-Schlüssel. Die Verschlüsselung erfordert mehr Server-Ressourcen. <i>Vorsicht</i>: sobald Sie das Verfahren geändert haben, müssen Sie ein Skript ausführen, um bestehende Anhänge anzupassen. Siehe Registerreiter "Spezielle Aktionen".',
    'admin_action_attachments_cryption' => 'Elementanhänge verschlüsseln oder entschlüsseln',
    'admin_action_attachments_cryption_tip' => 'Vorsicht: dieser Vorgang ist Ausschließlich nach Änderung der entsprechenden Option in den Teampass-Einstellungen durchzuführen. Bitte legen Sie zur Sicherheit vor jeglicher Aktion eine Kopie des Ordners "upload" an...',
    'encrypt' => 'Verschlüsseln',
    'decrypt' => 'Entschlüsseln',
    'ga_identification_code' => 'Identifizierungscode',
    'ga_enter_credentials' => 'Bitte die Zugangsdaten eingeben.',
    'ga_bad_code' => 'Der Google Authenticator Code ist falsch.',
    'settings_get_tp_info' => 'Informationen über Teampass automatisch laden',
    'settings_get_tp_info_tip' => 'Durch diese Option werden Informationen (wie z.B. Versions-Nr. und benutzte Bibliotheken) vom Teampass-Server auf der Infoseite angezeigt.',
    'settings_offline_mode' => 'Offline-Modus aktivieren',
    'settings_offline_mode_tip' => 'Der Offline-Modus erlaubt es Elemente in eine HTML-Datei zu exportieren. Die Elemente in dieser Datei werden mit einem durch den Benutzer vorgegebenen Schlüssel verschlüsselt.',
    'offline_mode_key_level' => 'Minimale Schlüsselstärke für den Offline-Modus.',
    'categories' => 'Benutzerdefinierte Felder',
    'no_category_defined' => 'Noch keine Kategorie erstellt',
    'confirm_deletion' => 'Sind Sie sicher?',
    'settings_item_extra_fields' => 'Erweitern von Elementen um zusätzliche Felder (nach Kategorien) erlauben',
    'settings_item_extra_fields_tip' => 'Diese Option erlaubt die Definition von Elementen um zusätzliche Felder zu erweitern. Diese Felder kann der Adminstrator definieren und nach Kategorien ordnen. Sämtliche Daten sind verschlüsselt. Bitte bedenken Sie, dass diese Option mehr SQL-Anfragen (ca. 5 mehr pro Feld beim Elementupdate) erfordert und die Aktionen mehr Rechenzeit erfordern können (dies ist systemabhängig).',
    'settings_ldap_type' => 'Art des LDAP-Server',
    'server_time' => 'Serverzeit',
    'settings_tree_counters' => 'Mehr Zähler im Verzeichnisbaum anzeigen',
    'settings_tree_counters_tip' => 'Dies wird für jedes Verzeichnis 3 Zähler anzeigen: Anzahl von Elementen im Verzeichnis, Anzahl von Elementen in allen Unterverzeichnissen, Anzahl von Unterverzeichnissen. Diese Option erfordert mehr SQL-Anfragen und die Darstellung des Verzeichnisbaums kann verzögert werden.',
    'admin_action_check_pf' => 'Persönliche Ordner für alle Benutzer aktualisieren (Ordner werden erstellt, wenn sie nicht existieren)',
    'enable_personal_folder_feature_tip' => 'Persönliche Ordner sind ein privater Speicherort für individuelle Benutzerpasswörter. Kennwortelemente werden durch den Salt Key eines Benutzers (sicherer) oder durch sein Kennwort (einfacher) verschlüsselt. Wenn Sie diese Funktion aktivieren, werden die eigentlichen Ordner für vorhandene Benutzer nicht erstellt - Sie müssen auch die Aufgabe <b>Persönliche Ordner erstellen</b> ausführen.',
    'administrators_only' => 'Nur für Administratoren',
    'managers_of' => 'Manager der Rolle',
    'managed_by' => 'Verwaltet von',
    'settings_enable_sts' => 'HTTPS Strict Transport Security erzwingen - <strong>Vorsicht</strong>: bitte lesen Sie den ToolTip.',
    'settings_enable_sts_tip' => 'Dies erzwingt HTTPS STS. STS hilft <b>Man-in-the-Middle</b>-Angriffe auf SSL abwehren. Um diese Option zu nutzen, MÜSSEN Sie ein gültiges CA-signiertes SSL-Zertifikat besitzen. Falls Sie lediglich ein selbst-signiertes Zertifikat besitzen und diese Option aktivieren, können Sie die Sicherheit von Teampass gefährden! Die Apache-Konfiguration muss <b>SSL-Options + ExportCertData</b> beinhalten.',
    'settings_anyone_can_modify_bydefault' => 'Die Option <i>Jeder kann bearbeiten</i> ist standardmäßig aktiviert',
    'to' => 'bis',
    'settings_upload_maxfilesize_tip' => 'Maximal erlaubte Dateigröße. Sie sollte mit den Einstellungen Ihres Servers konsistent sein.',
    'settings_upload_docext_tip' => 'Typen von Dokumenten die als Anhang hochgeladen werden dürfen. Bitte geben Sie die erlaubten Namenserweiterungen, getrennt durch Kommata (,) ein.',
    'settings_upload_imagesext_tip' => 'Typen von Bildern die als Anhang hochgeladen werden dürfen. Bitte geben Sie die erlaubten Namenserweiterungen, getrennt durch Kommata (,) ein.',
    'settings_upload_pkgext_tip' => 'Typen von Archivdateien die als Anhang hochgeladen werden dürfen. Bitte geben Sie die erlaubten Namenserweiterungen, getrennt durch Kommata (,) ein.',
    'settings_upload_otherext_tip' => 'Andere Dateitypen die als Anhang hochgeladen werden dürfen. Bitte geben Sie die erlaubten Namenserweiterungen, getrennt durch Kommata (,) ein.',
    'settings_upload_imageresize_options_tip' => 'Wenn aktiviert, verändert diese Option die Größe der Bilder auf das angegebene Format (in Pixeln). Bilder über 1000 Pixel werden im Browser möglicherweise nicht richtig angezeigt.',
    'settings_upload_maxfilesize' => 'Maximale Dateigröße (in Mb)',
    'settings_upload_docext' => 'Erlaubte Dateiendungen für Dokumente.',
    'settings_upload_imagesext' => 'Erlaubte Dateiendungen für Bilder.',
    'settings_upload_pkgext' => 'Erlaubte Dateiendungen für Packages.',
    'settings_upload_otherext' => 'Andere erlaubte Dateiendungen.',
    'settings_upload_imageresize_options_w' => 'Neue Bildbreite (in Pixeln)',
    'settings_upload_imageresize_options_h' => 'Neue Bildhöhe (in Pixeln)',
    'settings_upload_imageresize_options_q' => 'Neue Bildqualität',
    'settings_importing' => 'Import von Daten aus CVS-/Keypass-Dateien erlauben',
    'admin_proxy_ip' => 'IP-Adresse des Proxy-Servers',
    'admin_proxy_ip_tip' => 'Falls Ihre Internet-Verbindung durch einen Proxy-Server geleitet wird, geben Sie hier die IP-Nr. des Proxy-Servers ein. Andernfalls lassen Sie das Feld einfach leer. ',
    'admin_proxy_port' => 'Port-Nr. des Proxy-Servers',
    'admin_proxy_port_tip' => 'Falls Ihre Internet-Verbindung durch einen Proxy-Server geleitet wird, geben Sie hier die Port-Nr. des Proxy-Servers ein.',
    'settings_ldap_elusers' => 'Nur für lokale Benutzer von Teampass',
    'settings_ldap_elusers_tip' => 'Diese Option ermöglicht es den Benutzern, sich über das LDAP zu authentifizieren. Deaktivieren Sie dies, wenn Sie ein LDAP-Verzeichnis durchgehen wollen.',
    'db_items_edited' => 'Element ist momentan in Bearbeitung',
    'item_edition_start_hour' => 'In Bearbeitung seit',
    'settings_delay_for_item_edition' => 'Zeit (in Minuten) bis die Editiersperre abläuft',
    'settings_delay_for_item_edition_tip' => 'Wird ein Element bearbeitet, ist dieses mittels eines Tokens gesperrt, so dass es nicht anderweitig parallel verändert werden kann. Diese Einstellung erlaubt die Löschung des Tokens und das Entsperren des Elements nach einer gewißen Zeit. Ist der Wert auf 0 gesetzt, wird der Token nie gelöscht.',
    'db_users_logged' => 'Momentan protokollierte Benutzer',
    'action' => 'Aktion',
    'login_time' => 'Protokolliert seit',
    'lastname' => 'Nachname',
    'user_login' => 'Anmeldung',
    'role' => 'Rolle',
    'error_role_exist' => 'Diese Rolle existiert bereits!',
    'error_no_edition_possible_locked' => 'Editieren nicht möglich! Das Element wird gerade bearbeitet!',
    'select' => 'Auswählen',
    'items' => 'Einträge',
    'enable_personal_saltkey_cookie' => 'Speicherung des persönlichen SALT-Schlüssels in Cookie erlauben',
    'personal_saltkey_cookie_duration' => 'Gültigkeitsdauer des persönlichen SALT-Schlüssels Cookies',
    'admin_email_smtp_server' => 'Server SMTP',
    'admin_email_auth' => 'Server SMTP verlangt Authentifizierung',
    'admin_email_auth_username' => 'Benutzername zur Authentifizierung',
    'admin_email_auth_pwd' => 'Passwort zur Authentifizierung',
    'admin_email_port' => 'Server-Port',
    'admin_email_from' => 'Email-Adresse des Absenders',
    'admin_email_from_name' => 'Name des Absenders',
    'admin_email_test_configuration_tip' => 'Dieser Test sendet eine E-Mail an die hinterlegte Adresse. Sollten Sie sie nicht empfangen, prüfen Sie bitte Ihre Zugangsdaten.',
    'admin_email_test_subject' => 'Test Email des Administrators',
    'admin_email_test_body' => 'Dies ist eine Testemail um die Email Server Konfigurationen zu verifizieren. Wenn Sie das hier lesen könne, Gratulation.',
    'admin_email_result_ok' => 'Email wurde an #email# versandt... Schauen Sie in Ihrer Posteingang nach.',
    'email_bodyalt_item_updated' => 'Passwort für #item_label# wurde geändert.',
    'admin_email_send_backlog_tip' => 'Dieses Script erzwingt das Versenden der Emails aus der Datenbank. Dies kann - je nach Anzahl der Emails - einige Zeit in Anspruch nehmen.',
    'please_wait' => 'Bitte warten!',
    'admin_path_to_files_folder' => 'Pfad zum Ordner "files"',
    'admin_path_to_files_folder_tip' => 'Der Ordner "files" wird zum Speichern aller von Teampass erzeugten, sowie einiger upgeloadeten, Dateien genutzt. WICHTIG: Dieser Ordner sollte aus Sicherheitsgründen nicht im WWW-Rootverzeichnis Ihrer Website liegen. Er sollte in einem geschützten Bereich platziert und mit entsprechender Umleitungsregel in der Serverkonfiguration versehen sein. WICHTIG 2: Es ist sinnvoll einen CRONJOB zur periodischen Bereinigung dieses Ordners aufzusetzen.',
    'admin_path_to_upload_folder_tip' => 'Dateianhänge werden im Ordner "upload" mit zufälligen Namen gespeichert.  Der Inhalt dieses Ordners sollte niemals manuell gelöscht werden. Für größtmögliche Sicherheit sollte er nicht im WWW-Ordner Ihrer Website liegen, sondern außerhalb Ihres Website-Verzeichnisses erstellt und über eine Umleitungsregel aufgerufen werden.',
    'pdf_password_warning' => 'Sie müssen einen Verschlüsselungscode eingeben!',
    'admin_pwd_maximum_length' => 'Maximale Länge der Passwörter',
    'admin_pwd_maximum_length_tip' => 'Die Standardlänge der Passwörter beträgt 40 Zeichen. Bitte bedenken Sie, dass das Einstellen einer größeren Länge sich auf die Systemleistung auswirkt. Je länger das Passwort, desto länger braucht der Server zum Ver-/Entschlüsseln und Darstellen der Passwörter.',
    'settings_insert_manual_entry_item_history' => 'Manuelles Hinzufügen von Einträgen in das Logbuch der Elemente erlauben',
    'settings_insert_manual_entry_item_history_tip' => 'Möglicherweise brauchen Sie einen Eintrag in das Elementprotokoll manuell einzufügen. Durch Aktivieren dieser Option ist dies möglich.',
    'admin_path_to_upload_folder' => 'Pfad zum Upload-Verzeichnis',
    'admin_setting_enable_delete_after_consultation' => 'Das Element kann automatisch gelöscht werden.',
    'admin_setting_enable_delete_after_consultation_tip' => 'Wenn aktiviert, kann der Autor des Elements das automatische Löschen dieses Elements nach X-fachem Ansehen erzwingen.',
    'at_email' => 'Email',
    'enable_email_notification_on_item_shown' => 'Benachrichtigung per Email versenden, wenn das Element angesehen wird',
    'share_sent_ok' => 'Die Email wurde versandt.',
    'see_item_title' => 'Details des Elements',
    'email_on_open_notification_subject' => 'Benachrichtigung über das Ansehen eines Elements',
    'email_on_open_notification_mail' => 'Hallo, <br><br>#tp_user# hat soeben das Element &apos;#tp_item# <br> geöffnet und angesehen. Zum Öffnen klicken Sie, bitte, <href="#tp_link#">LINK</a><br><br>',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[Teampass] Ihr neues Benutzerkonto',
    'email_new_user_mail' => 'Hallo,<br><br>Der Administrator hat Ihr Benutzerkonto für Teampass eingerichtet <br><br>Sie können sich mit folgenden Benutzerdaten anmelden:<br>- Benutzername: #tp_login#<br>- Passwort: #tp_pw#<br><br>Zur Anmeldung klicken Sie, bitte, auf <a href="#tp_link#">LINK</a> .<br><br>Auf Wiedersehen.',
    'error_empty_data' => 'Keine Daten zum Bearbeiten!',
    'error_not_allowed_to' => 'Hierzu sind Sie nicht autorisiert!',
    'request_access_ot_item' => 'Zugang zum Ändern beantragen',
    'email_request_access_subject' => 'Zugriff auf Element anfordern.',
    'email_request_access_mail' => 'Hallo #tp_item_author#,<br><br>Benutzer #tp_user# hat Zugriff auf Element &apos;#tp_item#&apos; angefordert.<br><br>Bitte überprüfen Sie die Berechtigungen dieses Benutzers, bevor Sie die Zugriffsbeschränkungen dieses Elements lockern.<br><br>Grüße',
    'admin_action_change_salt_key' => 'Änderung des SALT-Schlüssels',
    'nb_items_by_query' => 'Anzahl Elemente, die bei jedem Suchlauf ausgegeben werden.',
    'nb_items_by_query_tip' => 'Auflistung vieler Elemente benötigt mehr Zeit.<br />Bei Einstellung &apos;auto&apos; passt das Programm die Anzahl entsprechend der Bildschirmgröße des Benutzers an.<br />Bei Einstellung &apos;max&apos; wird immer die gesamte Liste dargestellt.<br />Geben Sie die gewünschte Anzahl Elemente ein, die bei jedem Suchlauf darzustellen ist.',
    'open_url_link' => 'In neuem Fenster öffnen',
    'error_pw_too_long' => 'Passwort ist zu lang! Maximal erlaubt sind 40 Zeichen.',
    'at_restriction' => 'Beschränkung',
    'pw_encryption_error' => 'Fehler beim Verschlüsseln des Passworts!',
    'enable_send_email_on_user_login' => 'Beim Anmelden von Benutzern eine E-Mail an Administratoren versenden',
    'email_subject_on_user_login' => 'Ein Benutzer hat sich angemeldet',
    'email_body_on_user_login' => 'Hllo,<br><br>Benutzer #tp_user# hat sich am #tp_date# um #tp_time# in Teampass angemeldet.<br><br>Diese Meldung wurde angezeigt, da die Option "Beim Anmelden von Benutzern eine E-Mail an Administratoren versenden" in den Einstellungen aktiviert ist.',
    'account_is_locked' => 'Dieses Konto wurde gesperrt',
    'activity' => 'Aktivität',
    'add_role_tip' => 'Neue Rolle hinzufügen',
    'admin' => 'Administration',
    'admin_action_db_backup' => 'Backup der Datenbank erstellen',
    'admin_action_db_clean_items' => 'Verwaiste Elemente aus der Datenbank entfernen',
    'admin_action_db_clean_items_tip' => 'Dadurch werden nur Elemente und Protokolle aus der Datenbank gelöscht, die nicht entfernt wurden, nachdem der zugehörige Ordner gelöscht wurde. Es ist empfehlenswert vorher ein Backup zu erstellen.',
    'admin_action_db_optimize' => 'Datenbank optimieren',
    'admin_action_db_restore' => 'Datenbank wiederherstellen',
    'admin_action_purge_old_files' => 'Alte Dateien bereinigen',
    'admin_action_purge_old_files_tip' => 'Dadurch werden alle temporären Dateien gelöscht, die älter als 7 Tage sind.',
    'admin_action_reload_cache_table' => 'Tabellencache einlesen',
    'admin_action_reload_cache_table_tip' => 'Hiermit kann man den Tabellencache wieder einlesen. In manchen Situationen kann dies nützlich sein.',
    'admin_help' => 'Hilfe',
    'admin_ldap_configuration' => 'LDAP Konfiguration',
    'admin_main' => 'Informationen',
    'admin_misc_cpassman_dir' => 'Vollständiger Pfad zu Teampass',
    'admin_misc_cpassman_url' => 'Vollständige URL zu Teampass',
    'admin_misc_custom_login_text' => 'Eigener Anmeldetext',
    'admin_misc_custom_logo' => 'Vollständiger URL-Pfad zum eigenen Anmeldelogo',
    'admin_misc_favicon' => 'Vollständiger Pfad zur favicon-Datei',
    'admin_settings' => 'Einstellungen',
    'admin_settings_title' => 'Teampass Einstellungen',
    'admin_setting_activate_expiration' => 'Ablauf von Passwörtern aktivieren',
    'admin_setting_activate_expiration_tip' => 'Wenn aktiviert, werden abgelaufene Passwörtern den Benutzern nicht mehr angezeigt.',
    'admin_views' => 'Protokolle',
    'alert_message_done' => 'Fertig!',
    'all' => 'Alle',
    'anyone_can_modify' => 'Bearbeitung des Elements durch jeden Benutzer mit Zugriff auf dieses Element zulassen',
    'at' => 'um',
    'at_category' => 'Ordner',
    'at_copy' => 'Kopie erledigt',
    'at_delete' => 'gelöscht',
    'at_description' => 'Beschreibung.',
    'at_label' => 'Bezeichnung',
    'at_login' => 'Benutzerkonto',
    'at_moved' => 'verschoben',
    'at_personnel' => 'Beteiligte',
    'at_restored' => 'wiederhergestellt',
    'at_shown' => 'Zugegriffen',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Sichtbare Ordner',
    'auth_creation_without_complexity' => 'Erstellung von Passwörtern ungeachtet der eingestellten Passwortkomplexität zulassen',
    'auth_modification_without_complexity' => 'Bearbeitung von Elemente ungeachtet der eingestellten Passwortskomplexität zulassen',
    'cancel' => 'Abbrechen',
    'can_create_root_folder' => 'Kann Ordner in der root-Ebene erstellen',
    'changelog' => 'Versionsänderungen',
    'close' => 'Schließen',
    'complexity' => 'Passwortkomplexität',
    'complex_asked' => 'Komplexität',
    'complex_level0' => 'sehr schwach',
    'complex_level1' => 'schwach',
    'complex_level2' => 'gut',
    'complex_level3' => 'besser',
    'complex_level4' => 'sehr gut',
    'complex_level5' => 'Ausgezeichnet',
    'complex_level6' => 'p3rf3kt! / Excellent',
    'confirm' => 'Bestätigen',
    'confirm_del_from_fav' => 'Bitte bestätigen Sie die Löschung des Favoriten',
    'connections' => 'Verbindungen',
    'copy' => 'Kopieren',
    'copy_to_clipboard_small_icons' => 'Symbol zum <i>Kopieren</i> in Eintragsliste aktivieren',
    'copy_to_clipboard_small_icons_tip' => 'Fügt ein Symbol hinzu, um Passwörter direkt aus der Elementliste in die Zwischenablage zu kopieren. Das Passwort kann kopiert werden, ohne den gesamten Inhalt eines Eintrags zu laden.',
    'date' => 'Datum',
    'date_format' => 'Datumsformat',
    'delete' => 'Löschen',
    'deletion' => 'Gelöschte Elemente',
    'del_button' => 'Löschen',
    'description' => 'Beschreibung',
    'disconnect' => 'Abmelden',
    'done' => 'Fertig',
    'duplicate_folder' => 'Mehrere Ordner mit dem selben Namen erlauben.',
    'duplicate_item' => 'Mehrere Elemente mit dem selben Namen erlauben.',
    'email' => 'Email',
    'email_subject' => 'Ein neues Element wird in der Passwortverwaltung erstellt',
    'enable_favourites' => 'Benutzern erlauben Favoriten anzulegen',
    'enable_personal_folder' => 'Persönlichen Ordner aktivieren',
    'enable_personal_folder_feature' => 'Aktiviere die Funktion Persönliche Ordner',
    'enable_user_can_create_folders' => 'Benutzer dürfen in erlaubten übergeordneten Verzeichnissen Unterverzeichnisse verwalten',
    'encrypt_key' => 'Verschlüsselungspasswort',
    'errors' => 'Fehler',
    'error_group_exist' => 'Dieser Ordner existiert bereits!',
    'error_html_codes' => 'Ein Teil des Textes enthält HTML Code! Dies ist nicht erlaubt.',
    'error_item_exists' => 'Dieses Element existiert bereits!',
    'error_label' => 'Eine Bezeichnung ist erforderlich!',
    'error_must_enter_all_fields' => 'Alle Felder müssen angegeben werden!',
    'error_pw' => 'Ein Passwort ist erforderlich!',
    'error_tags' => 'Keine Interpunktionszeichen (außer Leerzeichen) in TAGS erlaubt!',
    'error_user_exists' => 'Benutzer existiert bereits',
    'expiration_date' => 'Ablaufdatum',
    'find' => 'Suche',
    'forbidden_groups' => 'Unsichtbare Ordner',
    'forgot_my_pw_email_sent' => 'Email wurde verschickt',
    'functions' => 'Rollen',
    'gestionnaire' => 'Manager',
    'god' => 'Administrator',
    'group' => 'Ordner',
    'group_parent' => 'Unterordner von',
    'group_pw_duration' => 'Erneuerungsintervall',
    'group_pw_duration_tip' => 'in Monaten (0 = deaktiviert)',
    'history' => 'Verlauf',
    'home_personal_saltkey' => 'Ihr persönlicher Salt-Schlüssel',
    'home_personal_saltkey_label' => 'Geben Sie Ihren persönlichen SALT Schlüssel ein',
    'import_error_no_read_possible' => 'Die Datei kann nicht gelesen werden!',
    'import_error_no_read_possible_kp' => 'Die Datei kann nicht gelesen werden. Es muss eine KeePass-Datei sein.',
    'import_keepass_to_folder' => 'Wählen Sie den Zieordner',
    'index_add_one_hour' => 'Sitzung verlängern',
    'index_change_pw_confirmation' => 'Passwort wiederholen',
    'index_expiration_in' => 'Ihre Sitzung läuft ab in',
    'index_get_identified' => 'Bitte identifizieren Sie sich',
    'index_last_pw_change' => 'Ihr Passwort wurde zuletzt geändert am',
    'index_last_seen' => 'Sie waren zuletzt angemeldet am',
    'index_login' => 'Benutzername',
    'index_new_pw' => 'Neues Passwort',
    'index_password' => 'Passwort',
    'index_pw_error_identical' => 'Die Passwörter müssen identisch sein',
    'index_pw_level_txt' => 'Passwortkomplexität',
    'index_session_duration' => 'Sitzungsdauer',
    'info' => 'Informationen',
    'item_menu_copy_login' => 'Benutzernamen kopieren',
    'item_menu_copy_pw' => 'Passwort kopieren',
    'item_menu_del_from_fav' => 'Aus Favoriten entfernen',
    'kbs' => 'KBs',
    'kb_menu' => 'Wissensdatenbank',
    'last_items_title' => 'Zuletzt betrachtete Elemente',
    'ldap_extension_not_loaded' => 'Die LDAP-Erweiterung ist auf dem Server nicht aktiviert',
    'level' => 'Stufe',
    'login' => 'Benutzername',
    'mask_pw' => 'Passwort einblenden/ausblenden',
    'max_last_items' => 'Maximale Anzahl zuletzt betrachteter Elemente für Benutzer (Standard ist 10)',
    'minutes' => 'Minuten',
    'name' => 'Name',
    'nb_false_login_attempts' => 'Anzahl missglückter Anmeldeversuche bevor ein Benutzerkonto gesperrt wird (0 = deaktiviert)',
    'nb_folders' => 'Anzahl Ordner',
    'nb_items' => 'Anzahl Elemente',
    'new_label' => 'Neue Bezeichnung',
    'no' => 'Nein',
    'none' => 'Nichts',
    'none_selected_text' => 'Nichts ausgewählt',
    'not_allowed_to_see_pw' => 'Sie dürfen dieses Element nicht betrachten!',
    'not_allowed_to_see_pw_is_expired' => 'Dieses Element ist abgelaufen!',
    'not_defined' => 'Nicht definiert',
    'number_of_used_pw' => 'Anzahl erforderlicher Passwortänderungen vor Wiederbenutzung eines alten Passworts',
    'pages' => 'Seiten',
    'pdf_download' => 'Datei herunterladen',
    'personal_salt_key' => 'Ihr persönlicher SALT Schlüssel',
    'pw' => 'Passwort',
    'pw_generate' => 'Generieren',
    'pw_is_expired_-_update_it' => 'Dieses Element ist abgelaufen! Sie müssen das Passwort des Elements ändern.',
    'pw_life_duration' => 'Gültigkeitsdauer von Benutzerpasswörtern in Tagen (0 = deaktiviert)',
    'readme_open' => 'Gesamte Liesmich-Datei öffnen',
    'read_only_account' => 'Nur lesbar',
    'restore' => 'Wiederherstellen',
    'restricted_to' => 'Sichtbar für',
    'restricted_to_roles' => 'Einschränkung von Elementen auf Benutzer und Rollen erlauben',
    'root' => 'Root',
    'secure' => 'Sicher',
    'see_logs' => 'Logs ansehen',
    'settings_anyone_can_modify' => 'Bearbeitung jedes Elements durch alle Benutzer als Option aktivieren',
    'settings_anyone_can_modify_tip' => 'Durch Aktivierung dieser Option wird dem Elementenformular ein Auswahlfeld hinzugefügt, das dem Ersteller erlaubt, jedem anderen Benutzer die Bearbeitung des Elements zu erlauben.',
    'settings_default_language' => 'Standardsprache definieren',
    'settings_kb' => 'Wissensdatenbank aktivieren (beta)',
    'settings_kb_tip' => 'Durch Aktivierung dieser Option wird eine zusätzliche Seite hinzugefügt, auf der Sie Ihre Wissensdatenbank aufbauen können.',
    'settings_ldap_domain' => 'LDAP Suffix Ihrer Domäne',
    'settings_ldap_domain_controler' => 'LDAP Serverliste',
    'settings_ldap_domain_controler_tip' => 'Geben Sie mehrere Server an, falls Sie die Verteilung der LDAP-Anfragen auf mehrere Server wünschen. Sie müssen die Domänennamen durch Kommazeichen trennen ( , ). Bsp.: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'LDAP Base DN Ihrer Domäne',
    'settings_ldap_mode' => 'Benutzerauthentifizierung über LDAP server erlauben',
    'settings_ldap_mode_tip' => 'Erlauben Sie dies nur, wenn Sie über einen LDAP-Server verfügen und diesen für die Authentifizierung von Teampass-Benutzern verwenden möchten.',
    'settings_ldap_ssl' => 'LDAP über SSL aktivieren (LDAPS)',
    'settings_ldap_tls' => 'LDAP über TLS aktivieren',
    'settings_log_accessed' => 'Protokollierung von zugegriffenen Einträgen aktivieren',
    'settings_log_connections' => 'Protokollieren aller Benutzerverbindungen in der Datenbank aktivieren.',
    'settings_maintenance_mode' => 'Teampass in den Wartungsmodus versetzen',
    'settings_manager_edit' => 'Manager können die für sie sichtbaren Elemente bearbeiten und löschen',
    'settings_printing' => 'Export der Elemente in PDF-Datei erlauben',
    'settings_printing_tip' => 'Wenn diese Option aktiviert ist, können Benutzer Elemente in eine PDF-Datei exportieren. Bitte beachten Sie, dass die Passwörter in dieser Datei unverschlüsselt sind.',
    'settings_restricted_to' => 'Funktionalität <b>Begrenzt auf</b> bei Elementen erlauben',
    'settings_show_description' => 'Beschreibung in Elementliste anzeigen',
    'size' => 'Länge',
    'tags' => 'Tags',
    'timezone_selection' => 'Auswahl der Zeitzone',
    'time_format' => 'Zeitformat',
    'url' => 'URL',
    'user' => 'Benutzer',
    'users_online' => 'Benutzer angemeldet',
    'user_alarm_no_function' => 'Diesem Benutzer wurde keine Rolle zugeordnet!',
    'yes' => 'Ja',
    'one_time_view_item_url_box' => 'Teilen Sie diese Einmal-URL mit einer vertrauenswürdigen Person <br><br>#URL#<br><br>Bedenken Sie, dass dieser Link nur bis #DAY# einsehbar ist.',
    'settings_api' => 'Zugriff auf Teampass-Elemente via API erlauben',
    'settings_api_tip' => 'API erlaubt Fremdanwendungen Zugriff auf Elemente im JSON-Format',
    'settings_api_keys_list' => 'Liste von Schlüsseln',
    'settings_api_keys_list_tip' => 'Mit diesen Schlüssel darf auf Teampass zugegriffen werden. Ohne gültigen Schlüssel ist kein Zugriff möglich. Gehen Sie mit diesen Schlüsseln sorgfältig um!',
    'settings_api_key' => 'Schlüssel',
    'settings_api_add_ip' => 'Füge neue IP hinzu',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Neue Unterordner vererben Zugriffsrechte von Überordnern.',
    'subfolder_rights_as_parent_tip' => 'Ist diese Option deaktiviert, erbt jeder neue Unterordner die Zugriffsrechte gemäß dessen Ersteller-Rolle. Ist diese Option aktiviert, erbt jeder neue Unterordner die Zugriffsrechte des Überordners.',
    'show_only_accessible_folders_tip' => 'Standardmäßig sieht der Benutzer den kompletten Verzeichnisbaum, selbst wenn er keine Zugriffsrechte auf dessen Ordner besitzt. Hiermit können Sie die Ansicht vereinfachen, indem Sie die unzugänglichen Ordner im Verzeichnisbaum ausblenden.',
    'show_only_accessible_folders' => 'Verzeichnisbaum-Ansicht durch Ausblenden unzugänglicher Ordner vereinfachen',
    'comment' => 'Kommentar',
    'suggestion_menu' => 'Vorschläge',
    'settings_suggestion' => 'Elementvorschläge für Benutzer mit Leserechten (Read-Only) erlauben',
    'settings_suggestion_tip' => 'Dies erlaubt Benutzern mit Leserechten (Read-Only) neue Elemente oder Elementanpassungen vorzuschlagen. Diese Vorschläge werden vom Administrator oder Manager geprüft.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP Bind DN',
    'settings_ldap_bind_passwd' => 'Passwort für LDAP Bind',
    'settings_ldap_search_base' => 'Basis für LDAP-Suche',
    'settings_ldap_bind_dn_tip' => 'Bind-DN für das Einbinden und die Suche nach Benutzern im Verzeichnisbaum',
    'settings_ldap_bind_passwd_tip' => 'Passwort zu Bind-DN für das Einbinden und die Suche nach Benutzern im Verzeichnisbaum',
    'settings_ldap_search_base_tip' => 'Wurzel-DN für Suchvorgänge im Verzeichnisbaum suchen',
    'admin_email_server_url' => 'Server Adresse (URL) für Verknüpfungen in E-Mails',
    'enable_email_notification_on_user_pw_change' => 'Email-Nachricht an Benutzer versenden, wenn sein Passwort verändert wurde.',
    'settings_otv_expiration_period' => 'Zeit nach welcher One Time View (OTV) - Items ablaufen (in Tagen)',
    'write' => 'Schreiben',
    'read' => 'Lesen',
    'no_access' => 'Kein Zugriff',
    'right_types_label' => 'Legen Sie den Zugriffstyp des Ordners für bestimmte Benutzerrollen fest',
    'duplicate_item_in_folder' => 'Elemente mit identischem Namen im allgemeinen Ordner zulassen.',
    'settings_roles_allowed_to_print' => 'Rollen definieren, die Elemente in Datei schreiben dürfen',
    'settings_roles_allowed_to_print_tip' => 'Ausgewählte Benutzerrollen werden Elemente in Datei schreiben dürfen',
    'admin_email_security' => 'SMTP-Sicherheit',
    'alert_page_will_reload' => 'Seite wird neu jetzt geladen',
    'file_protection_password' => 'Passwort für Datei setzen',
    'expand' => 'Aufklappen',
    'collapse' => 'Zusammenklappen',
    'settings_ldap_user_attribute' => 'Benutzerattribut durchsuchen',
    'settings_ldap_user_attribute_tip' => 'LDAP-Attribut für den Benutzernamen.<br>Beispiel: Für openLDAP: cn ; uid. Für Active Directory:  samaccountname.',
    'log_user_initial_pwd_changed' => 'Initiales Passwort wurde gesetzt',
    'log_user_email_changed' => 'Benutzer E-Mail geändert in',
    'log_user_created' => 'Benutzer Account wurde erstellt',
    'log_user_locked' => 'Benutzer wurde gesperrt',
    'log_user_unlocked' => 'Benutzer wurde entsperrt',
    'log_user_pwd_changed' => 'Benutzer Passwort wurde geändert',
    'settings_default_session_expiration_time' => 'Standard Gültigkeitsdauer der Session',
    'settings_duo' => 'DUOSecurity als 2-Faktor Authentifizierung aktivieren',
    'settings_duo_tip' => 'Benutzer 2-Faktor Authentifizierung kann mithilfe von DUOSecurity.com realisiert werden. Diese Bibliothek garantiert einen hohen Sicherheitsstandard in Bezug auf Benutzerauthentifizierung.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Diese Anmeldedaten wurden von der Webapplikation bereitgestellt, die Sie für Teampass von der DUOSecurity Administrationsseite erstellt haben.<br />Durch Klicken auf die Speichern Schaltfläche werden sie in die sk.php Datei gesichert.',
    'admin_duo_intro' => 'Füllen Sie die nächsten Felder mit den erwarteten Daten aus',
    'edit' => 'Bearbeiten',
    'user_info_locked' => 'Benutzer ist aktuell GESPERRT.',
    'user_info_unlock_question' => 'Account entsperren?',
    'user_info_lock_question' => 'Account sperren?',
    'user_info_delete_question' => 'Account löschen?',
    'user_info_active' => 'Benutzer ist aktuell AKTIVIERT.',
    'refresh' => 'Aktualisieren',
    'loading' => 'Laden',
    'searching' => 'Suche...',
    'list_items_with_tag' => 'Elemente mit diesem Schlüsselwort anzeigen',
    'no_item_to_display' => 'Keine Elemente anzuzeigen',
    'opening_folder' => 'Verzeichnis wird gelesen...',
    'suggestion_notify_subject' => '[Teampass] Ein neuer Vorschlag wurde unterbreitet.',
    'suggestion_notify_body' => 'Hallo,<br><br>Ein neuer Vorschlag wurde unterbreitet. Sie müssen diesen validieren, bevor er von anderen Anwendern benutzt werden kann.<br>Einige Informationen dazu:<br>- Bezeichnung: #tp_label#<br>- Verzeichnis: #tp_folder#<br>- Benutzer: #tp_user#<br><br>Beachten Sie bitte, dass diese E-Mail an alle Manager verschickt wurde.<br><br>Freundliche Grüße.',
    'error_unknown' => 'Ein unerwarteter Fehler ist aufgetreten.',
    'no_edit' => 'Ohne Änderung gespeichert',
    'role_cannot_edit_item' => 'Elemente können nicht bearbeitet werden',
    'no_delete' => 'Ohne Löschung gespeichert',
    'role_cannot_delete_item' => 'Elemente können nicht gelöscht werden',
    'my_profile' => 'Mein Profil',
    'starting' => 'Starte...',
    'total_number_of_items' => 'Gesamtanzahl an Objekten',
    'finalizing' => 'Finalisierung',
    'treating_items' => 'Betroffene Objekte',
    'number_of_items_treated' => 'Anzahl der betroffenen Objekte',
    'error_sent_back' => 'Nächster Fehler aufgetreten',
    'full' => 'Vollständig',
    'sequential' => 'Teilweise',
    'tree_load_strategy' => 'Baum Tiefegrad',
    'syslog_enable' => 'Aktiviere loggen mit Systemlock',
    'syslog_host' => 'Systemlog-Server',
    'syslog_port' => 'Systemlog Port',
    'error_bad_credentials' => 'Login-Daten sind nicht korrekt!',
    'settings_ldap_usergroup' => 'zu durchsuchende in LDAP-Gruppe',
    'settings_ldap_usergroup_tip' => 'LDAP-Gruppe, zu der ein Teilnehmer gehören muss, um sich anmelden zu können. Beispiel: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Ändern des Server-Benutzer-Passwortes erlauben (per ssh-Verbindung)',
    'update_server_password' => 'Server-Passwort erneuern',
    'ssh_pwd' => 'SSH-Passwort',
    'ssh_user' => 'SSH-Benutzer',
    'ssh_password_frequency_change_info' => 'Sie können die Änderung automatisch regelmäßig ausführen lassen. Dafür müssen sie die Frequenz wählen in der die Passworte der Server-Benutzer geändert werden (0 deaktiviert die Funktion).<br />Beachten sie, dass dies nur funktioniert, falls der Administrator den Cron-Task auf dem Server aktiviert hat.',
    'ssh_password_frequency_change' => 'Passwort-Änderungs-Frequenz (in Monaten)',
    'ssh_scheduled_change' => 'Regelmäßige Änderung',
    'ssh_one_shot_change' => 'Einmalige Änderung',
    'server_password_change_enable_tip' => 'Diese Option erlaubt die automatische, regelmäßige Änderung der Benutzer-Passworte des Servers im `URL`-Feld unter Verwendung einer SSH-Verbindung.<br />Beachten Sie, dass für diese regelmäßige Änderung die Datei <i>/files/script.ssh.php</i> in der crontab dieses Servers eingetragen ist. Sie sollte einmal täglich laufen.',
    'error_bad_credentials_more_than_3_times' => 'Login-Daten sind nicht korrekt! !<br>Warten Sie 10 Sekunden bevor Sie diese neu eingeben können.',
    'settings_ldap_object_class' => 'Klasse für die Suche',
    'settings_ldap_object_class_tip' => 'LDAP Klasse für die Suche, wie zum Beispiel ein User Account oder POSIX Account',
    'rebuild_config_file' => 'Konfigurationsdatei neu aufbauen',
    'rebuild_config_file_tip' => 'Das Konfigurationsfile liegt im Ordner ./includes/config/tp.config.php. Es enthält die Konfigurationsvariablen welche in den Einstellungen definiert sind. Das Konfigurationsfile kann immer neu generiert werden.',
    'error_folder_complexity_lower_than_top_folder' => 'Unterordner müssen eine sichereres oder ähnliches Passwort haben als ihr übergeordneter Ordner',
    'new_item_email_body' => 'Hallo, <br/><br/>Neuer Eintrag &apos;#label&apos; wurde in Teampass erstellt. </br>Sie haben vielleicht Zugang zu diesem Eintrag wenn du auf diesen Link klickst<a href="#link#">LINK</a>.<br/><br />Grüße. ',
    'failed_logins' => 'Fehlgeschlagene Logins',
    'error_only_numbers_in_folder_name' => 'Ein Ordner darf nicht nur durch eine Nummer benannt werden. Bitte geben Sie dem Ordner einen Namen, der Buchstaben beinhaltet. ',
    'encrypted_data' => 'Daten sind in Datenbank verschlüsselt',
    'settings_ldap_port' => 'LDAP Port',
    'user_profile_agses_card_id' => 'Ihre Agses Card ID',
    'ga_flash_qr_and_login' => 'Fotografieren Sie diesen QR mit Ihrem Mobiltelefon ab, geben die 2-Faktor Authentifizierung ein und betätigen die Eingabetaste.',
    'i_need_to_generate_new_ga_code' => 'Ich benötige einen neuen QR Code. Bitte sende mir einen temporären Identifizierungscode per E-Mail.',
    'settings_manager_move_item' => 'Manager können beliebige Objekte verschieben, die sie sehen',
    'user_folders_rights' => 'Sichtbare Ordner',
    'create_item_without_password' => 'Anlegen eines Objekts ohne definiertes Passwort erlauben',
    'share_rights_info' => 'Dieser Dialog erlaubt es die Rechte eines Benutzers mit anderen Benutzern zu Teilen.<br>Beachten Sie, dass die Rechte des selektierten Benutzers zurückgesetzt werden und mit exakt den gleichen Rechten wie die des  ursprünglichen Benutzers überschrieben werden.',
    'share_rights_source' => 'Ursprünglicher Benutzer',
    'share_rights_destination' => 'Ziel Benutzer',
    'ga_reset_by_user' => 'Benutzer kann seinen 2FA-Token zurücksetzen',
    'ga_reset_by_user_tip' => 'Wenn diese Option gewählt ist, hat der Benutzer die Möglichkeit, seinen Code für die 2FA zurück zu setzen. Das kann z.B. nützlich sein, falls er sein Mobilgerät getauscht hat. Anderenfalls, muss der Benutzern den Adminstrator um einen neuen Code bitten.',
    'enable_massive_move_delete' => 'Benutzer erlauben, umfangreiche Verschieben- und Löschen-Operationen durchzuführen',
    'enable_massive_move_delete_tip' => 'Diese Option erlaubt es dem Benutzer, massive Verschiebe- und Lösch-Operationen auf einmal auszuführen. Das kann er nur für Einträge ausführen, für die er die notwendigen Rechte hat.',
    'mass_operation' => 'Massenänderungen an Elementen',
    'move_items' => 'Verschiebe ausgewählte Elemente',
    'delete_items' => 'Ausgewählte Elemente löschen',
    'you_decided_to_move_items' => 'Sie haben sich entschieden, Einträge zu verschieben',
    'you_decided_to_delete_items' => 'Sie haben sich entschieden, Einträge zu löschen',
    'suggest_password_change' => 'Passwort-Änderung vorschlagen',
    'otv_is_enabled' => 'Benutzer kann Einmal-Ansicht-Links vorschlagen',
    'error_source_and_destination_are_equal' => 'Quell- und Ziel-Ordner können nicht identisch sein!',
    'sending_anonymous_statistics' => 'Anonyme Statistiken senden',
    'favourites_option_enabled' => 'Favouriten aktiviert',
    'personalfolders_option_enabled' => 'Persönliche Ordner aktiviert',
    'country_statistics' => 'Länderverteilung',
    'country' => 'Land',
    'users_statistics' => 'Durchschnittliche Anzahl von Benutzern per Instanz',
    'items_all' => 'Alle Elemente',
    'folders_all' => 'Alle Ordner',
    'items_shared' => 'Alle geteilten Daten (ohne persönliche Einträge)',
    'folders_shared' => 'Alle geteilten Ordner (ohne persönliche Ordner)',
    'items_statistics' => 'Durchschnittliche Anzahl von Einträgen per Instanz',
    'folders_statistics' => 'Durchschnittliche Anzahl von Ordnern per Instanz',
    'administrators_number' => 'Anzahl Administratoren',
    'administrators_number_statistics' => 'Durchschnittliche Anzahl von Administratoren per Instanz',
    'managers_number' => 'Anzahl Manager',
    'managers_number_statistics' => 'Durchschnittliche Anzahl von Managern per Instanz',
    'readonly_number_statistics' => 'Durchschnittliche Anzahl von Nur-Lese-Benutzern per Instanz',
    'readonly_number' => 'Anzahl von Nur-Lese-Benutzern',
    'mysql_version' => 'MySQL-Version',
    'php_version' => 'PHP-Version',
    'teampass_version' => 'Teampass-Version',
    'languages_used' => 'Ausgewählte Sprache',
    'languages_statistics' => 'Meistgenutzte Sprache',
    'kb_option_enabled' => 'Wissensdatenbank aktiviert',
    'suggestion_option_enabled' => 'Vorschlagsoption aktiviert',
    'customfields_option_enabled' => 'Benutzerdefinierte Felder aktiviert',
    'api_option_enabled' => 'API aktiviert',
    '2fa_option_enabled' => '2FA aktiviert',
    'agses_option_enabled' => 'AGSES aktiviert',
    'duo_option_enabled' => 'DUO Security aktiviert',
    'ldap_option_enabled' => 'LDAP aktiviert',
    'syslog_option_enabled' => 'SYSLOG aktiviert',
    'stricthttps_option_enabled' => 'Strict HTTPS aktiviert',
    'characteristic' => 'Characteristik',
    'current_value' => 'Aktueller Wert',
    'communication_means' => 'Kommunikationsmittel',
    'consider_a_donation' => 'Bitte erwägen Sie eine Spende',
    'more_information' => 'Mehr Informationen',
    'feature_request_canal' => 'Für Funktionsanfragen verwenden Sie bitte',
    'bug_canal' => 'Für Fehler verwenden Sie bitte',
    'documentation_canal' => 'Dokumentation',
    'sending_anonymous_statistics_details' => 'Statistiken werden benötigt, um Teampass zu verbessern, indem wir die Benutzerverteilung und die Nutzung kennen. Die Daten, die Sie zur Verfügung stellen, werden nur intern verwendet und werden sicher nicht an Dritte weitergegeben oder verkauft.',
    'item_has_change_proposal' => 'Dieses Element hat einen Änderungsvorschlag',
    'check_data_after_reencryption' => 'Bitte überprüfen Sie die Daten. Zur Rückgängigmachung wurde eine neue Tabelle <b>Backup</ b> erstellt.',
    'revert' => 'Zurücksetzen?',
    'revert_the_database' => 'Sie haben beschlossen, die Datenbank wiederherzustellen. Bitte bestätigen!',
    'bad_psk' => 'Der persönliche Salt-Key ist nicht korrekt!',
    'ldap_test_config' => 'Aktuelle Einstellung prüfen',
    'ldap_test_username' => 'Benutzername für Testzwecke',
    'ldap_test_username_pwd' => 'Benutzername Passwort',
    'feature_support_canal' => 'Für Hilfe und Unterstützung verwenden Sie bitte',
    'category' => 'Kategorie',
    'text' => 'Text',
    'type' => 'Typ',
    'data_is_masked' => 'Daten sind versteckt',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP - erlaubte Benutzergruppe',
    'settings_ldap_allowed_usergroup_tip' => 'Geben Sie die Gruppe an, die sich mit Teampass verbinden darf. Lassen Sie es leer, wird es keine Einschränkung bezüglich der Gruppenzugehörigkeit geben.',
    'error_security_level_not_reached' => 'Erwartetes Sicherheitsniveau nicht erreicht!',
    'personal_saltkey_security_level' => 'Minimale persönliche Saltkey-Sicherheitsstufe',
    'settings_disable_forgot_password_link' => 'Den <b>Passwort vergessen</b> Link auf der Startseite ausblenden',
    'newly_created_user_is_administrated_by' => 'Neu angelegte Benutzer werden verwaltet von',
    'settings_ldap_and_local_authentication' => 'Lokale und LDAP Benutzer',
    'settings_ldap_and_local_authentication_tip' => 'Aktiviere diese Option, um Benutzer Anmeldungen aus dem LDAP und Teampass Datenbank zu erlauben.',
    'enable_http_request_login' => 'Automatischesanmelden nutzt den HTTP Header mit Anmeldeinformationen',
    'duration_login_attempt' => 'Sekunden bis zur automatischen Anmeldung',
    'newly_created_user_role' => 'Neu angelegte Benutzer erhalten die Rolle',
    'email_debug_level' => 'Wähle ein Debug Level',
    'email_debug_client' => 'Client Befehle',
    'email_debug_server' => 'Client-Befehle und Server-Antworten',
    'email_debug_connection' => 'Client-Befehle, Server-Antworten und Verbindungsstatus',
    'email_debug_low_level' => 'Low-level Datenausgabe, alle Nachrichten',
    'email_debug_level_usage' => 'Diese Einstellung sollte auf Keine gesetzt werden. Sie ist nur für das Debuggen von E-Mails zu Testzwecken gedacht. Wenn sie aktiviert ist, kann eine Ausgabe der E-Mail-Befehle angezeigt werden.',
    'email_body_temporary_login_password' => 'Hallo,<br><br>Dies ist eine E-Mail, die von Teampass Passwörter Manager generiert wurde.<br><br>Ein Administrator hat Ihr Login-Passwort für Teampass geändert. Wenn Sie sich das nächste Mal mit Teampass verbinden, verwenden Sie bitte das nächste:<br><br><b>#enc_code#</b><br><br><br>Herzliche Grüße',
    'your_new_password' => 'Dein neues Passwort',
    'user_specific_right' => 'Benutzerspezifische Rechte',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon bei Auswahl',
    'fontawesome_icon_tip' => 'Sie können einen Font Awesome-Symbolcode angeben, der unter Freie und Solid-Symbole ausgewählt wurde. Für das Standardsymbol leer lassen.',
    'settings_api_token_duration' => 'Verzögerung des Ablaufs des JWT-Tokens (in Sekunden)',
    'settings_api_token_duration_tip' => 'Verzögerung, während der das generierte JWT-Token gültig ist. Nach dieser Verzögerung wird eine Autorisierungsanfrage an die API gestellt.',
    'show_encryption_code_to_admin' => 'Dies ist der verschlüsselte Code, den der Benutzer bei dieser Anmeldung benötigt. Sie haben darum gebeten, ihn zu sehen. Bitte kopieren Sie ihn und geben Sie ihn auf sichere Weise weiter. Der Code lautet',
    'previous_password' => 'Vorheriges Passwort genutzt, um sich Anzumelden',
    'generate_new_otp' => 'OTP neu erzeugen',
    'generate_new_otp_informations' => 'Dieser Vorgang besteht darin, alle Schlüssel für den ausgewählten Benutzer neu zu generieren. Infolgedessen muss der Benutzer bei der nächsten Anmeldung den generierte OTP neueingeben.',
    'html' => 'html',
    'execution_time' => 'Ausführungszeit',
    'maximum_number_of_items_to_treat' => 'Maximale Anzahl der in einem Zyklus zu behandelnden Artikel',
    'maximum_number_of_items_to_treat_tip' => 'Um die Beendigung des Skripts ohne Timeout zu gewährleisten, kann ein persönlicher Wert definiert werden.',
    'maximum_time_script_allowed_to_run' => 'Dauer in Sekunden, die das Skript im Hintergrund laufen darf',
    'maximum_time_script_allowed_to_run_tip' => 'Standardmäßig kann das PHP-Skript nicht länger laufen als die durch den Parameter max_execution_time in der Datei php.ini festgelegte Dauer. Ziel ist es hier, einen höheren Wert zu definieren, um sicherzustellen, dass das Skript vollständig ausgeführt wird.',
    'refresh_data_every_on_screen' => 'Bildschirmneuladezeit (in Sekunden)',
    'refresh_data_every_on_screen_tip' => 'Wenn Sie die Aufgabenansicht durchsuchen, können Sie die Liste aktualisieren lassen.',
    'refreshed' => 'Neugeladen',
    'process_details' => 'Prozessdetails',
    'created_at' => 'Erstellt am',
    'updated_at' => 'Geändert am',
    'finished_at' => 'Beendet am',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Aufgaben',
    'task_in_progress_user_not_active' => 'Aufgaben werden bearbeitet - Benutzer nicht aktiv',
    'enable_tasks_manager' => 'Aktiviere Hintergrundaufgaben per Cronmanager',
    'enable_tasks_manager_tip' => 'Diese Option sollte aktiviert werden, wenn Sie feststellen, dass einige Aufgaben viel Zeit in Anspruch nehmen. Sie ermöglicht es, diese Aufgaben über einen Hintergrundjob zu erledigen, der vom Server-Cron-Manager ausgeführt wird. Siehe Dokumentation für weitere Details.',
    'sync_new_ldap_password' => 'Synchronisiere neues Passwort',
    'error_new_ldap_password_detected' => 'Es scheint, dass sich Ihr Passwort geändert hat und Teampass muss das Passwort, um Ihren privaten Hauptschlüssel neu zu verschlüsseln.',
    'settings_ldap_tls_certifacte_check' => 'Zertifikatenüberprüfung für LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Spezifiziere die Zertifikatsüberprüfungsmethode. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'Benutzerschlüsselverwaltung',
    'sending_emails' => 'Sende E-Mails',
    'tasks_information' => 'Die Aufgabe beruht auf einem speziellen Cron-Job. Dazu müssen Sie einen neuen Eintrag in Ihre crontab einfügen, damit der Teampass-Scheduler jede Minute ausgeführt wird.<br>Nächster Eintrag, welcher hinzugefügt wird:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Hinweis: Bitte passen Sie den Pfad zu php bin an (in den meisten Fällen kann er durch <code>php</code> ersetzt werden).',
    'bad_duo_mfa' => 'Schlechter DUO code',
    'creation_date' => 'Erstellungsdatum',
    'never' => 'Nie',
    'loading_main_page' => 'Lade Hauptseite ...',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'Dir ist es nicht erlaubt sich anzumelden',
    'enable_tasks_log' => 'Aktiviere Cron Job log',
    'enable_tasks_log_tip' => 'Ermöglicht die Protokollierung aller vom Cron-Job ausgeführten Aufgaben in der Tabelle <i>processes_log</i>. Könnte für die Überprüfung von Ereignissen nützlich sein.',
    'items_and_folders_statistics' => 'Einträge und Ordner Statistik',
    'item_copying' => 'Eintrag wird kopiert',
    'upgrade_requested' => 'Teampass Datenbank ist nicht aktuell',
    'upgrade_requested_more' => 'Es wurden einige Inkonsistenzen zwischen Dateien und Konfiguration festgestellt. Ihr Administrator sollte den Upgrade-Prozess durchführen, bevor Sie fortfahren.',
    'settings_ldap_group_object_filter' => 'LDAP Gruppenobjektfilter',
    'settings_ldap_group_object_filter_tip' => 'LDAP-Filter, der zum Auffinden des Gruppenobjekts verwendet werden soll. Zum Beispiel: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD Benutzerrollen die ihren AD Gruppen zugeordnet sind',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID Attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP-Attribut zur Identifizierung der GUID eines Objekts. Zum Beispiel: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD Gruppe',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD Gruppen und Rollen Zuordnung ',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Bezeichung angeben',
    'uploading' => 'Wird hochgeladen...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Benutzerkonto im Aufbau',
    'add_new_job' => 'Neuen Auftrag hinzufügen',
    'tasks_cron_not_running' => 'Cron-Job ist nicht aktiv. Bitte fügen Sie den Befehl <code>crontab -u www-data -e</code> im Crontab des Server-User (normalerweise www-data) hinzu.<br>Oder drücken sie den Button um die Erstellung automatisch zu versuchen.',
    'tasks_cron_running' => 'Zeitgesteuerter Auftrag ist korrekt gesetzt',
    'currently_using_version' => 'Aktuell geladene Version',
    'git_commit_value' => 'Wert des Git Commit',
    'generate_new_keys' => 'Neue Schlüssel generieren',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown.',
    'generate_new_keys_end' => 'Der Vorgang läuft im Hintergrund und kann mehrere Minuten dauern. Sie können dieses Fenster schließen.',
    'confirm_password' => 'Bitte das Passwort bestätigen',
    'no_code_is_requested' => 'No code is requested.',
    'user_encryption_ongoing' => 'Account is currently being encrypting. Your request cannot continue. Please wait until this is finished.',
    'teampass_information' => 'Informationen über Teampass',
    'show_password' => 'Zeige Passwort',
    'new_user_info_by_mail' => 'Neue Benutzer bekommen eine E-Mail mit ihren Anmeldedaten',
    'login_credentials' => 'Anmeldedaten',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>Dies ist eine generierte E-Mail des Teampass Passwords Manager.<br><br>Diese Zugangsdaten werden bei der nächsten Nutzung von Teampass erwartet:<ul><li>Benutzer: #login#</li><li>Passwort: #password#</li><li>Verschlüsselungscode: #code#</li></ul><br><br><br>Grüße',
    'email_body_user_config_3' => 'Hallo #lastname#,<br><br>Dies ist eine generierte E-Mail des Teampass Passwords Manager.<br><br>Dieses Passwort wird bei der nächsten Nutzung von Teampass erwartet:<br><br><b>#password#</b><br><br><br>Grüße',
    'email_body_user_config_4' => 'Hallo #lastname#,<br><br>Dies ist eine generierte E-Mail des Teampass Passwords Manager.<br><br>Ihr Teampass Account ist jetzt bereit.<br><br>Grüße',
    'email_body_user_config_5' => 'Hallo #lastname#,<br><br>Dies ist eine generierte E-Mail des Teampass Passwords Manager.<br><br>Dieser Verschlüsselungscode wird bei der nächsten Nutzung von Teampass erwartet:<br><br><b>#code#</b><br><br><br>Grüße',
    'email_body_user_config_6' => 'Hallo #lastname#,<br><br>Dies ist eine generierte E-Mail des Teampass Passwords Manager.<br><br>Diese Zugangsdaten werden bei der nächsten Nutzung von Teampass erwartet:<ul><li>Benutzer: #login#</li><li>Passwort: #password#</li></ul><br><br><br>Grüße',
    'error_data_not_valid' => 'Daten sind nicht valide',
    'mfa_enabled' => 'MFA aktiviert',
    'mfa_disabled_for_user' => 'MFA deaktiviert für Benutzer',
    'users_personal_folder' => 'Persönlicher Benutzer-Ordner',
    'maintenance_operations' => 'Wartungsarbeiten',
    'maintenance_operations_tip' => 'Selected maintenance operations on Teampass database.',
    'purge_temporary_files' => 'Temporäre Dateien entfernen',
    'task_scheduling' => 'Auftragsplanung',
    'parameter' => 'Parameter',
    'frequency' => 'Frequenz',
    'in_minutes' => 'in Minuten',
    'hourly' => 'Stündlich',
    'daily' => 'Täglich',
    'clean_orphan_objects' => 'Verwaiste Objekte säubern',
    'run_once' => 'Ein Mal ausführen',
    'run_weekday' => 'An Wochentagen ausführen',
    'monday' => 'Montag',
    'tuesday' => 'Dienstag',
    'wednesday' => 'Mittwoch',
    'thursday' => 'Donnerstag',
    'friday' => 'Freitag',
    'saturday' => 'Samstag',
    'sunday' => 'Sonntag',
    'monthly' => 'Monatlich',
    'day_of_month' => 'Tag des Monats',
    'day' => 'Tag',
    'reset' => 'Zurücksetzen',
    'error_while_creating_file' => 'Fehler beim Erstellen der Datei',
    'new_keys_generated' => 'Neue Schlüssel wurden generiert',
    'user_creation' => 'Benutzer-Erstellung',
    'user_deletion' => 'Benutzer-Löschung',
    'maximum_session_expiration_time' => 'Maximale Sitzungsdauer',
    'maximum_session_expiration_time_tip' => 'Maximale Zeit in Minuten, um die eine Sitzung verlängert werden kann',
    'index_session_duration_too_long' => 'Die Dauer der Sitzung ist zu lang',
    'extend_session_duration_by' => 'Sitzung verlängern um',
    'settings_ldap_user_dn_attribute' => 'Benutzer Distinguished Name',
    'settings_ldap_user_dn_attribute_tip' => 'LDAP-Attribut für Distinguished Name (DN).<br>Beispiel: Für openLDAP: dn. Für Active Directory:  distinguishedname.',
    'open_tasks_settings' => 'Aufgaben Einstellungen',
    'maximum' => 'Maximum',
    'updated' => 'Aktualisiert',
    'number_of_days' => 'Anzahl Tage',
    'number_of_times' => 'Anzahl Wiederholungen',
    'sharekey_not_ready' => 'Sharekey not yet generated ... all item data may not be ready ... please try later',
    'item_action_not_yet_possible' => 'Action not yet possible on this item',
    'open' => 'Öffnen',
    'reload_user_cache_table' => 'Cache-Tabelle des Benutzers neu laden',
    'send_email_to_user' => 'E-Mail an Benutzer senden',
    'items_management' => 'Änderungen an Einträgen',
    'previously_used_passwords' => 'Vorher genutzte Passwörter',
    'next_passwords_were_valid_until_date' => 'Next passwords were valid until date',
    'feature_disabled_by_administrator' => 'Funktion durch Administrator deaktiviert',
    'shared_globaly' => 'Global freigegeben',
    'settings_otv_subdomain' => 'OTV subdomain name',
    'settings_otv_subdomain_tip' => 'Dedicated subdomain for onetime links. Considere your main Teampass URL as isolated from internet, this subdomain could be reachable by everyone to share this item with someone outside your organisation. From security perspective it is a lot safer with such mechanics. Note: This would requite to have a DNS entry for this subdomain pointing to your Teampass server.',
    'existing_valid_otv_links' => 'OTV valid links',
    'started' => 'Started',
    'recovery_keys_not_downloaded' => 'Recovery-Schlüssel wurden nicht heruntergeladen',
    'no_recovery_keys' => 'Ich habe keine Recovery-Schlüssel. Dies löscht alle Passwörter aus meinen persönlichen Einträgen.',
    'provide_recovery_keys' => 'Recovery-Schlüssel angeben',
    'public_key' => 'Öffentlicher Schlüssel',
    'private_key' => 'Privater Schlüssel',
    'download_recovery_keys' => 'Recovery-Schlüssel herunterladen',
    'download_recovery_keys_confirmation' => 'Hier können Sie Ihre Recovery-Schlüssel herunterladen. Bitte speichern Sie diese an einem sichern Ort, denn bei einer Wiederherstellung werden Sie zwingend benötigt.',
    'recovery_keys_download_date' => 'Recovery-Schlüssel wurden heruntergeladen am',
    'keys_not_recovered' => 'Öffentliche und private Keys werden nicht gespeichert',
    'keys_not_recovered_explanation' => 'Um den Verlust von Kennwörtern zu verhindern, sollten Sie Ihre persönlichen Teampass-Keys sicher abspeichern',
    'get_your_recovery_keys' => 'Recovery-Schlüssel herunterladen',
    'keys_management' => 'Keys management',
    'please_confirm_task_to_be_run' => 'Bitte bestätigen Sie diesen Vorgang',
    'user_keys_downloaded' => 'User keys downloaded',
    'mfa_code_send_by_email' => 'MFA Code wurde per E-Mail versandt',
    'otp' => 'OTP',
    'otp_code' => 'OTP Code',
    'enabled_otp_for_item' => 'OTP aktivieren',
    'at_otp_status' => 'OTP Status',
    'phone_number' => 'Zugeordnete Telefonnummer (optional)',
    'otp_secret' => 'OTP Secret',
    'settings_ldap_group_objectclasses_attibute' => 'objectClasses der Gruppen in LDAP',
    'settings_ldap_group_objectclasses_attibute_tip' => 'Die objectClasses in denen nach Gruppen gesucht wird. Mehrere objectClasses werden mit Komma(,) getrennt. Beispiel: groupOfNames,group oder top,posixGroup',
    'display_warning_icons' => 'Warn-Symbole anzeigen',
    'password_length_by_default' => 'Standard-Passwortlänge',
    'progress' => 'Fortschritt',
    'tasks_log_retention_delay_in_days' => 'Aufbewahrung von Aufgaben-Log (in Tagen)',
    'tasks_log_table_size' => 'Größe der Aufgaben-Log-Tabelle',
    'error_otp_secret' => 'Konnte OTP Secret nicht verarbeiten, ist es korrekt?',
    'users_api_access_info' => 'Benutzer können auf die API mit den selben Berechtigungen wie in Teampass zugreifen',
    'error_folder_not_allowed_for_this_user' => 'Zugriff auf diesen Ordner ist für den Benutzer nicht erlaubt',
    'allowed_to_create' => 'Allowed to create',
    'allowed_to_read' => 'Allowed to read',
    'allowed_to_update' => 'Allowed to update',
    'allowed_to_delete' => 'Allowed to delete',
    'folder_created' => 'Ordner erstellt',
    'login_with_sso' => 'Login with SSO',
    'server_connected_to_internet' => 'Server ist mit dem Internet verbunden',
    'server_not_connected_to_internet' => 'Server ist nicht mit dem Internet verbunden',
    'server_not_connected_to_internet_tip' => 'Dies kann einige Funktionen beeinträchtigen. Insbesondere MFA',
    'tools' => 'Tools',
    'user_config_not_compliant' => 'User configuration is not compliant',
    'fix_personal_items_empty' => 'Fix personal items are empty',
    'fix_personal_items_empty_tip' => 'This tool permits to fix the issue where personal items are empty after a Teampass upgrade. It requires to have restored a copy of table teampass_items from Teampass version 2. The table needs to be named teampass_items_v2.',
    'table_not_exists' => 'Expected table does not exist. Please restore it from a backup.',
    'tools_usage_warning' => 'Using tools can have a direct impact on the database. Please be careful. Always perform a dump before and define a maintenance period.',
    'select_user' => 'Benutzer wählen',
    'show_item_data' => 'Daten in Eintragsliste anzeigen',
    'show_item_data_tip' => 'Zeigt zusätzliche Informationen in der Eintragsliste an (Benutzername, E-Mail, URL). Dies erlaubt einen schnellen Überblick über den Inhalt der Einträge.',
    'items_page_split_view_mode' => 'Show item details in page split view mode',
    'replace_tenant_id' => 'Adapt the URL but keep {tenant-id} as is. It will be replaced live by the tenant ID.',
    'user_exists_but_not_oauth2' => 'User has to authenticate using Entra/Azure AD',
    'user_not_allowed_to_auth_to_teampass_app' => 'User is not allowed to authenticate with Teampass application',
    'user_is_not_auth_with_oauth2' => 'User should not authenticate with Entra/Azure AD',
    'highlight_favorites' => 'Highlight favorites',
    'highlight_favorites_tip' => '',
    'limited_search_default' => 'Limited search selected by default',
    'limited_search_default_tip' => '',
    'highlight_selected_tip' => '',
    'encryptClientServer' => 'Encrypt client-server exchanges',
    'encryptClientServer_tip' => 'When enabled, the client encrypts the data before sending it to the server. The server only stores encrypted data. It can be disabled.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL to get user details',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL to get user details. It is used to get user details after authentication.',
    'duo_redirect_uri' => 'Redirecting to Duo Prompt',
    'number_users_build_cache_tree' => '',
    'number_users_build_cache_tree_tip' => 'Number of users processed for build_cache_tree task at each run of the scheduler.',

);
