<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @file      romanian.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your LDAP credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Several filters are separated by a comma (,). Example: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your LDAP since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Default non secure LDAP port: 389, default secure LDAP port: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Selectare toate',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid until one of following settings is reached. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Loguri',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'Detalii',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn&apos;t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Va rugam confirmati',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Roluri',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Eticheta',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Click pentru a deschide pagina de web Teampass',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Selecteaza fisier PNG folosit ca avatar',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Copiere director',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Utilizatori',
    'folders' => 'Directoare',
    'find_message' => 'obiecte gasite',
    'auto_update_server_password_info' => 'Apasarea butonului START activeaza urmatoarele:<ul><li>Se conecteaza prin SSH la serverul folosind credentialele si campul `URL`,</li><li>Schimba parola utilizatorului pe server</il><li>Salveaza noua parola in Teampass</li><li>Inchide conexiunea SSH</li></ul><br/><b>Utilizatorul trebuie sa aiba privilegii de root pe server (daca nu, indica utilizator si parola de root) inainte de executare.</b>',
    'share' => 'Share-uieste item-ul',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'Trebuie selectat un Director',
    'email_subject_item_updated' => 'Parola a fost actualizata',
    'email_body_item_updated' => 'Buna ziua,<br><br>Parola pentru &apos;#item_label#&apos; a fost actualizata.<br /><br />Aceasta poate fi verificata <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">aici</a><br /><br />O zi buna!',
    'import_kp_finished' => 'Importul din KeePass a fost finalizat! Complexitatea parolelor pentru noul director a fost setatat la Medium. Puteti schimba cerintele de dificultate a parolei.',
    'password_is_empty' => 'Elementul nu are parola definit',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Deschidere raport incident in Github',
    'bugs_page' => 'Daca identificati un bug, va rugam raportati-l',
    'import_csv_anyone_can_modify_in_role_txt' => 'Any user part of your Groups could edit all imported items.',
    'import_csv_anyone_can_modify_txt' => 'Any user could edit all imported items.',
    'settings_upload_imageresize_options' => 'Redimensionati imaginile incarcate',
    'user_not_exists' => 'Utilizator inexistent!',
    'auto_create_folder_role' => 'Creare director si rol pentru ␣',
    'start_upload' => 'Incepe incarcarea fisierelor',
    'error_upload_runtime_not_found' => 'Upload feature: No runtime found.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Schimbare parola',
    'admin_2factors_authentication_setting' => 'Activeaza autentificarea Google in doi pasi',
    'admin_2factors_authentication_setting_tip' => 'Autentificarea Google two-factor imbunatateste securitatea procesului de autentificare. Cand va logati, un cod QR este afisat, iar acesta va trebui scanat in aplicatia de Google Authetication a utilizatorului, pentru a primi o parola valabila o singura data. Pentru a folosi aceasta optiune, este obligatoriu ca toti utilizatorii sa aiba aplicatia de Google Authentication instalata pe un dispozitiv conectat la Internet',
    'admin_ga_website_name' => 'Denumirea din Google Authenticator pentru Teampass',
    'admin_ga_website_name_tip' => 'Acest nu este folosit pentru codul de indentificare in Google Authenticator',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] Un Item a fost share-uit cu tine',
    'email_share_item_mail' => 'Buna ziua, #tp_user# ti-a partajat parola #tp_item# <a href="#tp_link#">Apasati aici </a> pentru a o accesa.',
    'index_maintenance_mode_admin' => 'Modul mentenanta a fost activat. Momentan, utilizatorii nu se pot conecta',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Trimite cod Google Authenticator catre user prin email',
    'error_no_email' => 'Utilizatorul nu are configurata adresa de email!',
    'error_no_user' => 'Utilizator inexistent!',
    'email_ga_subject' => 'Codul Google Authenticator pentru Teampass',
    'email_ga_text' => 'Salut,<br><br>Acest email a fost generat de Teampass. Administratorul tau se asteapta sa folosesti autentificare prin doi factori (2FA).<br>Prima conectare la Teampass folosind 2FA va folosi codul de identificare gasit mai jos, in campul "Cod de identificare":<br><br>----------------------<br>#Cod 2FA#<br>----------------------<br><br>Apoi vei avea posibilitatea de a configura conectarea prin doi factori in Teampass.<br><br>Toate bune',
    'settings_attachments_encryption' => 'Cripteaza atasamentele din itemi',
    'settings_attachments_encryption_tip' => 'Daca optiunea e activata, atasamentele itemilor sunt criptate pe server folosind cheia salt de sistem. Criptarea foloseste resurse suplimentare pe server. -- ATENTIE! -- Schimbarea starii acestei optiuni poate corupe atasamentele existente! Dupa schimbarea setarii trebuie rulate task-urile de criptare sau decriptare a atasamentelor curente.',
    'admin_action_attachments_cryption' => 'Cripteaza sau decripteaza atasamentele din itemi',
    'admin_action_attachments_cryption_tip' => 'Atentie: Criptati sau decriptati fisiere doar in sincron cu "Cripteaza atasamentele din itemi". Alege sa criptezi sau sa decriptezi si apasa pe buton Pornire. Creaza un backup al directorului de upload inainte de executarea functiei.',
    'encrypt' => 'Cripteaza',
    'decrypt' => 'Decripteaza',
    'ga_identification_code' => 'Cod de identificare',
    'ga_enter_credentials' => 'Trebuie sa introduci credentialele',
    'ga_bad_code' => 'Codul Google Authenticator e gresit',
    'settings_get_tp_info' => 'Incarca automat informatii despre Teampass',
    'settings_get_tp_info_tip' => 'Optiunea permite incarcarea informatiilor referitoare la versiunea de Teampass sau librariile folosite de acesta, in pagina de administrare.',
    'settings_offline_mode' => 'Activeaza modul off-line',
    'settings_offline_mode_tip' => 'Modul off-line creaza un fisier HTML de sine statator ce poate fi descarcat local. Itemii din acest fisier sunt criptati cu o parola furnizata de utilizator in momentul crearii.',
    'offline_mode_key_level' => 'Complexitate minima a cheii de criptare',
    'categories' => 'Campuri particularizate',
    'no_category_defined' => 'Nici o categorie nu a fost definita inca.',
    'confirm_deletion' => 'Ai selctat stergere ... esti sigur?',
    'settings_item_extra_fields' => 'Activeaza campuri particularizate pentru itemi',
    'settings_item_extra_fields_tip' => 'Activeaza tab suplimentar celor afisate la adaugarea unui item nou ce contine campuri particularizate pentru alte tipuri de date. Un administrator trebuie sa creeze categorii si etichete afisate in dreptul acelor categorii. Aceasta facilitate consuma resurse suplimentare pe server.',
    'settings_ldap_type' => 'Tipul serverului LDAP',
    'server_time' => 'Timpul pe server',
    'settings_tree_counters' => 'Arata mai multe indexuri in structura de directoare',
    'settings_tree_counters_tip' => 'Activand, vor fi afisate trei numere in dreptul fiecarui director: numarul de elemente din directorul de baza; numarul de elemente, inclusiv subdirectoarele; numarul de subdirectoare. Activarea acestei optiuni poate incetini incarcarea panoului de directoare',
    'admin_action_check_pf' => 'Creare director personal pentru toti utilizatorii ce nu au unul deja',
    'enable_personal_folder_feature_tip' => 'Directoarele personale sunt locatii private disponibile fiecarui utilizator in parte. Parolele sunt criptate folosind cheia salt a utilizatorului (mai sigur) sau parola acestuia (mai usor). Activarea facilitatii nu creaza efectiv si directoarele pentru utilizatorii existenti - trebuie rulat si taskul de creare director personal',
    'administrators_only' => 'Doar pentru administratori',
    'managers_of' => 'Manageri ai rolului',
    'managed_by' => 'Administrat de',
    'settings_enable_sts' => 'HTTPS Strict Transport Security. <strong>Atentie</strong>: citeste informatiile suplimentare!',
    'settings_enable_sts_tip' => 'Atentie! Aceasta va forta politica de  HTTPS strict transport security (STS). STS previne atacurile de tip man-in-the-middle. Este necesara instalarea un certificat SSL emis de o autoritate de certificare (CA), inainte de activarea acestei optiuni! Un certificat self-signed nu va functiona! Toate conexiunile web for necesita HTTPS. Optiunea &apos;SSLOptions +ExportCertData&apos; trebuie sa fie configurata in sectiunea Apache SSL',
    'settings_anyone_can_modify_bydefault' => 'Optiunea <i>Oricine poate modifica</i> selectata implicit',
    'to' => 'la',
    'settings_upload_maxfilesize_tip' => 'Dimensiunea maxima a unui fisier. Ar trebui sa coincida cu valoarea configurata pe server.',
    'settings_upload_docext_tip' => 'Afisati extensiile de fisiere pentru fisierele de procesare de text si de cuvinte pe care le permiteti ca atasamente. Indicati extensiile de fisiere permise separate cu o virgulă (,)',
    'settings_upload_imagesext_tip' => 'Afisati extensiile de fisiere pentru fiserele imagine pe care le permiteti ca atasamente .Indicati extensiile de fisiere permise separate cu o virgula (,)',
    'settings_upload_pkgext_tip' => 'Afisati extensiile de fisiere pentru fiserele arhiva pe care le permiteti ca atasamente .Indicati extensiile de fisiere permise separate cu o virgula (,)',
    'settings_upload_otherext_tip' => 'Afisati extensiile de fisiere pentru alte tipuri de fisiere pe care le permiteti ca atasamente. Indicati extensiile de fisiere permise separate cu o virgula (,)',
    'settings_upload_imageresize_options_tip' => 'Redimensionati imaginile mari (fixati dimensiunile maxime in pixeli). Imaginile mai late de 1000 pixeli ar putea fi afisate eronat in browser',
    'settings_upload_maxfilesize' => 'Dimensiunea maxima a fisierului (in MB)',
    'settings_upload_docext' => 'Extensiile de documente permise',
    'settings_upload_imagesext' => 'Extensii permise pentru imagini',
    'settings_upload_pkgext' => 'Extensiile de arhive permise',
    'settings_upload_otherext' => 'Alte extensii permise',
    'settings_upload_imageresize_options_w' => 'Latimea maxima a imaginii',
    'settings_upload_imageresize_options_h' => 'Inaltimea maxima a imaginii',
    'settings_upload_imageresize_options_q' => 'Calitatea imaginii JPEG',
    'settings_importing' => 'Porneste suportul pentru import date din fisiere CVS/KeyPass',
    'admin_proxy_ip' => 'IP-ul proxy-ului folosit',
    'admin_proxy_ip_tip' => 'Daca va conectati la Internet printr-un proxy, specificati IP-ul aici. Lasa-ti necompletat in caz contrar.',
    'admin_proxy_port' => 'Portul proxy-ului folosit',
    'admin_proxy_port_tip' => 'Daca va conectati la Internet printr-un proxy, specificati portul aici. ',
    'settings_ldap_elusers' => 'Doar useri locali de Teampass',
    'settings_ldap_elusers_tip' => 'Aceasta optiune permite utilizatorilor din baza de date sa se autentifice in LDAP. Dezactivati aceasta optiune pentru a permite orice cautarea in orice director LDAP',
    'db_items_edited' => 'Itemi in editare',
    'item_edition_start_hour' => 'Editare inceputa de',
    'settings_delay_for_item_edition' => 'Dupa cat timp e considerata esuata editarea unui Item (in minute)',
    'settings_delay_for_item_edition_tip' => 'Cand este editat, un element este blocat, astfel incat nici un alt utilizator nu il poate modifica. Aceasta optiune sterge cheia de blocare dupa un numar de minute. Daca valoarea este 0, un element nu va fi niciodata deblocat automat dupa ce s-a inceput editarea sa',
    'db_users_logged' => 'Useri conectati',
    'action' => 'Actiune',
    'login_time' => 'Conectat de',
    'lastname' => 'Nume',
    'user_login' => 'Conectare',
    'role' => 'Rol',
    'error_role_exist' => 'Acest rol exista deja!',
    'error_no_edition_possible_locked' => 'Editare imposibila. Itemul e in curs de editare!',
    'select' => 'selecteaza',
    'items' => 'Itemi',
    'enable_personal_saltkey_cookie' => 'Permite stocarea cheii SALT intr-un cookie',
    'personal_saltkey_cookie_duration' => 'Cheia de salt a utilizatorului expira dupa XX zile',
    'admin_email_smtp_server' => 'Server SMTP',
    'admin_email_auth' => 'Serverul SMTP necesita autentificare',
    'admin_email_auth_username' => 'Numele de utilizator folosit pentru serverul de email',
    'admin_email_auth_pwd' => 'Parola de utilizator folosita pentru serverul de email',
    'admin_email_port' => 'Port',
    'admin_email_from' => 'Emailul emitatorului (De la adresa de email)',
    'admin_email_from_name' => 'Numele emitatorului (De la Nume)',
    'admin_email_test_configuration_tip' => 'Testul implica trimiterea unui email la adresa indicata. Daca nu il primiti, verificati credentialele.',
    'admin_email_test_subject' => '[TeamPass] Email de test',
    'admin_email_test_body' => 'Buna,<br><br>Emailul a fost trimis cu succes.<br><br>Toate bune.',
    'admin_email_result_ok' => 'Emailul a fost trimis la #email# ... verifica-ti inbox-ul.',
    'email_bodyalt_item_updated' => 'Parola itemului #item_label# a fost actualizata.',
    'admin_email_send_backlog_tip' => 'Retrimite toate emailurile care asteapta din baza de date',
    'please_wait' => 'Va rugam, asteptati',
    'admin_path_to_files_folder' => 'Directorul de fisiere (cale absoluta)',
    'admin_path_to_files_folder_tip' => 'Directorul de fisiere este folosit pentru stocarea fisierelor de sistem, dar si pentru unele fisiere incarcate. Pentru o maxima securitate, acesta nu ar trebui plasat in directorul www al site-ului - Ar trebui creat intr-un director in afara directorului de site si accesat printr-o regula de rewrite sau redirectare.</span>',
    'admin_path_to_upload_folder_tip' => 'Atasamentele sunt stocate in dirrectorul de incarcare cu nume aleator. Continutul acestui director nu trebuie sters manual niciodata. Pentru o maxima securitaxima securitate, acesta nu ar trebui plasat in directorul www al site-ului - Ar trebui creat intr-un director in afara directorului de site si accesat printr-o regula de rewrite sau redirectare.</span>',
    'pdf_password_warning' => 'Trebuie sa furnizati o cheie de criptare!',
    'admin_pwd_maximum_length' => 'Lungimea maxima pentru parole',
    'admin_pwd_maximum_length_tip' => 'Lungimea implicita a parolelor e setata la 40 caractere. E important de retinut ca setarea unei valori mari impacteaza performanta. Cu cat e mai lunga parola, cu atat e necesar mai mult timp pentru criptarea, decriptarea sau afisarea parolelor.',
    'settings_insert_manual_entry_item_history' => 'Permite inserarea manuala a intrarilor in log-ul de istoric al Itemilor.',
    'settings_insert_manual_entry_item_history_tip' => 'In mod normal aceasta optiune trebuie lasata goala. Cand este activata, istoricul unui element poate fi editat sau alterat.',
    'admin_path_to_upload_folder' => 'Calea catre directorul Upload',
    'admin_setting_enable_delete_after_consultation' => 'Itemii vizualizati pot fi stersi automat',
    'admin_setting_enable_delete_after_consultation_tip' => 'Cand este activata, aceasta optiune permite celui care a creat un element sa decida ca acesta sa fie sters dupa un anumit numar de vizualizari',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Trimite notificare pe email cand Item-ul e afisat',
    'share_sent_ok' => 'Emailul a fost trimis',
    'see_item_title' => 'Detalii Item',
    'email_on_open_notification_subject' => 'Notificare la vizualizarea parolei',
    'email_on_open_notification_mail' => 'Buna ziua, #tp_user# a accesat si a vizualizat parola #tp_item# <a href="#tp_link#">Apasati aici </a> pentru a o accesa.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Contul a fost creat',
    'email_new_user_mail' => 'Buna,<br><br>Un administrator ti-a creat contul de Teampass.<br>Poti folosi credentialele de mai jos pentru a intra in cont:<br>- Utilizator: #tp_login#<br>- Parola:#tp_pw#<br><br>Apasa pe <a href="#tp_link#">LINK</a>pentru acces.<br><br>Numai bine.',
    'error_empty_data' => 'Lipsa informatii!',
    'error_not_allowed_to' => 'Actiunea nu iti e permisa!',
    'request_access_ot_item' => 'Cere acces catre autor',
    'email_request_access_subject' => '[TeamPass] Cerere de acces catre item',
    'email_request_access_mail' => 'Buna, #tp_item_author#,<br><br>Utilizatorul #tp_user# a cerut acces la &apos;#tp_item#&apos;.<br><br>Revizuieste cererea si confirma autorizarea accesului in Teampass.',
    'admin_action_change_salt_key' => 'Modifica cheia SALT principala',
    'nb_items_by_query' => 'Numarul de itemi returnati la fiecare cautare',
    'nb_items_by_query_tip' => 'Specificati numarul de elemente care vor fi primite la fiecare cerere catre server. Cereri multiple de dimensiuni reduse pot determina o performanta imbunatatita decat mai putine cereri de dimensiuni mai mari',
    'open_url_link' => 'Deschide intr-o pagina noua',
    'error_pw_too_long' => 'Parola e prea lunga! Sunt permise maximum 40 caractere.',
    'at_restriction' => 'Restrictie',
    'pw_encryption_error' => 'Eroare la criptarea parolei!',
    'enable_send_email_on_user_login' => 'Trimite email catre Administratori la log in-ul utilizatorului',
    'email_subject_on_user_login' => 'Informare: Utilizator conectat la Teampass',
    'email_body_on_user_login' => 'Utilizatorul #tp_user# s-a logat in Teampass pe #tp_date# la #tp_time#. ',
    'account_is_locked' => 'Acest cont este blocat',
    'activity' => 'Activitate',
    'add_role_tip' => 'Adauga rol nou',
    'admin' => 'Administrare',
    'admin_action_db_backup' => 'Creaza backup al bazei de date',
    'admin_action_db_clean_items' => 'Sterge itemi orfani din baza de date',
    'admin_action_db_clean_items_tip' => 'Inlatura orice element sau alte inregistrari ramase dupa ce un director a fost sters. Va rugam sa efectuati un backup inainte de rularea acestei optiuni.',
    'admin_action_db_optimize' => 'Optimizeaza baza de date',
    'admin_action_db_restore' => 'Restaureaza baza de date',
    'admin_action_purge_old_files' => 'Sterge fisiere vechi',
    'admin_action_purge_old_files_tip' => 'Toate fisierele temporare mai vechi de 7 zile vor fi sterse.',
    'admin_action_reload_cache_table' => 'Reincarca tabela de cache',
    'admin_action_reload_cache_table_tip' => 'Recreaza cache-ul elementului. Poate corecta probleme de afisare sau de salvare a parolelor',
    'admin_help' => 'Ajutor',
    'admin_ldap_configuration' => 'Configurare LDAP',
    'admin_main' => 'Informatii',
    'admin_misc_cpassman_dir' => 'Calea completa catre TeamPass',
    'admin_misc_cpassman_url' => 'URL complet catre TeamPass',
    'admin_misc_custom_login_text' => 'Text personalizat pentru login',
    'admin_misc_custom_logo' => 'URL complet catre Logo-ul personalizat',
    'admin_misc_favicon' => 'URL complet catre fisierul favicon',
    'admin_settings' => 'Setari',
    'admin_settings_title' => 'Setari TeamPass',
    'admin_setting_activate_expiration' => 'Activeaza expirarea parolelor',
    'admin_setting_activate_expiration_tip' => 'Cand este activata, aceasta optiune permite ca parolele sa nu fie afisate dupa ce au expirat. Configurati perioada de expirare a parolei in zile, in alta locatie, inainte de activa aceasta optiune',
    'admin_views' => 'Utilitare',
    'alert_message_done' => 'Gata!',
    'all' => 'toate',
    'anyone_can_modify' => 'Permiteti modificarea acestui element de catre oricine',
    'at' => 'la',
    'at_category' => 'Director',
    'at_copy' => 'Copiere terminata',
    'at_delete' => 'Stergere',
    'at_description' => 'Descriere',
    'at_label' => 'Eticheta',
    'at_login' => 'Login',
    'at_moved' => 'Mutat',
    'at_personnel' => 'Personal',
    'at_restored' => 'Restaurat',
    'at_shown' => 'Accesat',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Directoare permise',
    'auth_creation_without_complexity' => 'Permiteti crearea de elemente care nu corespund politicii de securitate a parolei',
    'auth_modification_without_complexity' => 'Permiteti modificari de elemente care nu corespund politicii de securitate a parolei',
    'cancel' => 'Anulare',
    'can_create_root_folder' => 'Poate crea un director la nivelul root',
    'changelog' => 'Actualizari recente',
    'close' => 'Inchide',
    'complexity' => 'Complexitatea minimia a parolei',
    'complex_asked' => 'Complexitatea necesare a parolei',
    'complex_level0' => 'Foarte slaba',
    'complex_level1' => 'Slaba',
    'complex_level2' => 'Medie',
    'complex_level3' => 'Puternica',
    'complex_level4' => 'Foarte puternica',
    'complex_level5' => 'Dificila',
    'complex_level6' => 'Foarte dificila',
    'confirm' => 'Confirmare',
    'confirm_del_from_fav' => 'Va rugam confirmati stergerea din favorite',
    'connections' => 'conexiuni',
    'copy' => 'Copiere',
    'copy_to_clipboard_small_icons' => 'Activare icoan in lista de elemente pentru <i>copy password</i> ',
    'copy_to_clipboard_small_icons_tip' => 'Adauga o icoana elementului de parola afisat in panoul de sus care va copia parola in clipboard. Parola poate fi copiata fara a fi necesara selectarea si incarcare intregului continut al elementului',
    'date' => 'Data',
    'date_format' => 'Format data',
    'delete' => 'Stergere',
    'deletion' => 'Stergeri',
    'del_button' => 'Sterge',
    'description' => 'Descriere',
    'disconnect' => 'Deconectare',
    'done' => 'Terminat',
    'duplicate_folder' => 'Directoarele pot avea nume duplicate',
    'duplicate_item' => 'Elementele pot avea nume duplicate',
    'email' => 'Email',
    'email_subject' => 'Un nou element a fost creat in managerul de parole',
    'enable_favourites' => 'Optiunea de marcaje favorite a fost activata.',
    'enable_personal_folder' => 'Directoare personale cu stocare de parole private',
    'enable_personal_folder_feature' => 'Directoare personale cu stocare de parole private',
    'enable_user_can_create_folders' => 'Sub-directoare gestionate de catre oricine care poate gestiona directorul parinte',
    'encrypt_key' => 'Cheie de criptare',
    'errors' => 'erori',
    'error_group_exist' => 'Director existent!',
    'error_html_codes' => 'Unele cuvinte contin cod HTML! Acest lucru este interzis.',
    'error_item_exists' => 'Acest element exista deja!',
    'error_label' => 'Eticheta este necesara!',
    'error_must_enter_all_fields' => 'Trebuie sa completati toate campurile!',
    'error_pw' => 'Este necesara o parola in fereastra de parole.',
    'error_tags' => 'Doar spatiile sunt permise in etichete',
    'error_user_exists' => 'Utilizator deja existent',
    'expiration_date' => 'Data de expirare',
    'find' => 'Cautare',
    'forbidden_groups' => 'Directoare interzise',
    'forgot_my_pw_email_sent' => 'Email trimis',
    'functions' => 'Roluri',
    'gestionnaire' => 'Manager',
    'god' => 'Administrator',
    'group' => 'Director',
    'group_parent' => 'Director parinte',
    'group_pw_duration' => 'Termen de reinnoire',
    'group_pw_duration_tip' => 'In luni. Utilizati 0 pentru a dezactiva',
    'history' => 'Istoric',
    'home_personal_saltkey' => 'Cheia dumneavoastra de salt',
    'home_personal_saltkey_label' => 'Introduceti cheia dumneavoastra de salt',
    'import_error_no_read_possible' => 'Fisierul nu poate fi citit!',
    'import_error_no_read_possible_kp' => 'Fisierul nu poate fi citit! Posibil ca acesta este un fisier de tip KeePass',
    'import_keepass_to_folder' => 'Selectare director destinatie',
    'index_add_one_hour' => 'Extinde sesiunea cu o ora',
    'index_change_pw_confirmation' => 'Confirmare',
    'index_expiration_in' => 'sessiunea expira in',
    'index_get_identified' => 'Va rugam sa va identificati',
    'index_last_pw_change' => 'Parola schimbata',
    'index_last_seen' => 'Ultima conectare',
    'index_login' => 'Cont',
    'index_new_pw' => 'Parola noua',
    'index_password' => 'Parola',
    'index_pw_error_identical' => 'Parolele trebuie sa corespunda!',
    'index_pw_level_txt' => 'Complexitate parola',
    'index_session_duration' => 'Durata sesiune',
    'info' => 'Informatii',
    'item_menu_copy_login' => 'Copiere login',
    'item_menu_copy_pw' => 'Copiere parola',
    'item_menu_del_from_fav' => 'Stergere din favorite',
    'kbs' => 'KB',
    'kb_menu' => 'Documentatie',
    'last_items_title' => 'Ultimele elemente vizualizate',
    'ldap_extension_not_loaded' => 'Extensia LDAP PHP nu este incarcata pe server',
    'level' => 'Nivel',
    'login' => 'Conectare',
    'mask_pw' => 'Ascunde/afiseaza parola',
    'max_last_items' => 'Dimensiunea listei de elemente recent vizualizate (valoare implicita este 10)',
    'minutes' => 'minute',
    'name' => 'Nume',
    'nb_false_login_attempts' => 'Numarul maxim de incercari de autentificare esuate inainte de blocarea contului (0 pentru a dezactiva blocarea)',
    'nb_folders' => 'Numarul de Directoare',
    'nb_items' => 'Numarul de elemente',
    'new_label' => 'Eticheta noua',
    'no' => 'Nu',
    'none' => 'Nimic',
    'none_selected_text' => 'Nimic selectat',
    'not_allowed_to_see_pw' => 'Accesul interzis la parola!',
    'not_allowed_to_see_pw_is_expired' => 'Acest element a expirat!',
    'not_defined' => 'Nedefinit',
    'number_of_used_pw' => 'Numarul de parole retinute pentru a preveni reutilizare (0 pentru a dezactiva)',
    'pages' => 'Pagini',
    'pdf_download' => 'Descarcare fisier',
    'personal_salt_key' => 'Cheia dumneavoastra de salt',
    'pw' => 'Parola',
    'pw_generate' => 'Genereaza',
    'pw_is_expired_-_update_it' => 'Acest element a expirat! Trebuie sa schimbati parola sa.',
    'pw_life_duration' => 'Parolele de acces expira dupa xx zile (0 pentru dezactivare)',
    'readme_open' => 'Deschidere fisier readme',
    'read_only_account' => 'Doar citire',
    'restore' => 'Restaureaza',
    'restricted_to' => 'Restrictionat la',
    'restricted_to_roles' => 'Permite restrictionare itemi utilizatorilor si rolurilor',
    'root' => 'Radacina',
    'secure' => 'Securizat',
    'see_logs' => 'Vezi log-urile',
    'settings_anyone_can_modify' => '<i>Oricine poate modifica</i>',
    'settings_anyone_can_modify_tip' => 'Setarea adauga un buton radio in meniul de creare item nou ce permite modificarea parolei de catre oricine.',
    'settings_default_language' => 'Defineste limba implicita',
    'settings_kb' => 'Activeaza Knowledge Base-ul (beta)',
    'settings_kb_tip' => 'Adds a menu item to access the knowledge base feature. The knowledge base is a searchable FAQ, allowing you create help and notes, and attach them to password items.',
    'settings_ldap_domain' => 'Sufixul LDAP al domeniului dumneavoastra',
    'settings_ldap_domain_controler' => 'Controler de domeniu LDAP',
    'settings_ldap_domain_controler_tip' => 'Specifica controlerul de domeniu. Pentru balansarea interogarilor catre mai multe servere, adauga servere separate prin virgula. Exemplu: domeniu_1,domeniu_2,domeniu_3',
    'settings_ldap_domain_dn' => 'LDAP base DN for your domain',
    'settings_ldap_mode' => 'Activeaza autentificarea utilizatorilor prin LDAP',
    'settings_ldap_mode_tip' => 'Activeaza doar daca ai un server LDAP si vrei sa autentifici userii TeamPass prin el.',
    'settings_ldap_ssl' => 'Foloseste LDAP prin SSL (LDAPS)',
    'settings_ldap_tls' => 'Foloseste LDAP prin TLS',
    'settings_log_accessed' => 'Activeaza log-area accesului la itemi',
    'settings_log_connections' => 'Activeaza log-area tuturor conexiunilor utilizatorilor la baza de date.',
    'settings_maintenance_mode' => 'Trece TeamPass in modul de mentenanta.',
    'settings_manager_edit' => 'Manager-ii pot edita si sterge itemii pe care ii pot vedea',
    'settings_printing' => 'Permite tiparirea itemilor in fisier PDF',
    'settings_printing_tip' => 'Adds an export option to the item tree menu, allowing export of entire folders to PDF or CSV. CSV passwords will be exported unencrypted, while PDF files can be password-protected.',
    'settings_restricted_to' => 'Activeaza functia <i>restricted-to</i> pe elemente',
    'settings_show_description' => 'Afisare descriere element in lista de elemente',
    'size' => 'Dimensiune',
    'tags' => 'Tag-uri',
    'timezone_selection' => 'Selectare fus orar',
    'time_format' => 'Format data',
    'url' => 'URL',
    'user' => 'Utilizator',
    'users_online' => 'utilizatori conectati',
    'user_alarm_no_function' => 'Utilizatorul nu are asociat Rol!',
    'yes' => 'Da',
    'one_time_view_item_url_box' => 'Share a one-time-view URL with a person you trust to see the password <br><br>#URL#<br><br>This link will only be visible one time, and expires #DAY#',
    'settings_api' => 'Permite accesul la itemii din Teampass prin API',
    'settings_api_tip' => 'Accesul prin API permite accesul la itemi dintr-o aplicatie 3rd-party in format JSON.',
    'settings_api_keys_list' => 'Lista cheilor API',
    'settings_api_keys_list_tip' => 'Aceste chei API au accesul permis la Teampass. Fara o cheie valida, accesul nu e permis. Aveti grija cu cine impartasiti cheile!',
    'settings_api_key' => 'Cheie',
    'settings_api_add_ip' => 'Adauga un IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Noile subdirectoare pastreaza permisiunile directorului parinte',
    'subfolder_rights_as_parent_tip' => 'Daca este activata aceasta optiune, noile subdirectoare pastreaza permisiunile directorului parinte. In caz contrar, permisiunile sunt definite pe baza rolului utilizatorului care le-a creat.',
    'show_only_accessible_folders_tip' => 'Implicit utilizatorii vad structura completa de directoare de elemente parola, chiar daca utilizatorul nu are acces la unele dintre aceste. Pentru a simplifica navigarea, puteti elimina directoarele interzise din afisare.',
    'show_only_accessible_folders' => 'Ascundere directoare de parole inaccesibile',
    'comment' => 'Comentariu',
    'suggestion_menu' => 'Sugestii',
    'settings_suggestion' => 'Optiunea sugestie de parola activata',
    'settings_suggestion_tip' => 'Optiunea de sugestii adauga un meniu si o pagina noua, permitand utilizatorilor sa adauge sugestii pentru noile parole. Aceasta optiune este utila atuci cand doar managerii au permisiunea de a crea parole.',
    'imported_via_api' => 'API!',
    'settings_ldap_bind_dn' => 'DN-ul de utilizare la LDAP',
    'settings_ldap_bind_passwd' => 'Parola de conectare la LDAP',
    'settings_ldap_search_base' => 'Baza de cautare LDAP',
    'settings_ldap_bind_dn_tip' => 'Enter a bind DN which can access users and search in the tree. A bind DN is a credential that authenticates your access to the directory.',
    'settings_ldap_bind_passwd_tip' => 'Parola pentru DN-ul specificat mai sus.',
    'settings_ldap_search_base_tip' => 'DN-ul radacina pentru cautari in arbore',
    'admin_email_server_url' => 'URL-ul serverului din link-urile din emailuri',
    'enable_email_notification_on_user_pw_change' => 'Trimite un email catre user daca i s-a schimbat parola.',
    'settings_otv_expiration_period' => 'Linkurile One-time-view (OTV) expira dupa XX zile',
    'write' => 'Scriere',
    'read' => 'Citire',
    'no_access' => 'Fara acces',
    'right_types_label' => 'Selectati tipul de acces la acest director pentru grupul de utilizatori selectat',
    'duplicate_item_in_folder' => 'Permite itemi cu aceeasi eticheta in acelasi director',
    'settings_roles_allowed_to_print' => 'Defineste rolurile ce pot tipari itemii',
    'settings_roles_allowed_to_print_tip' => 'Rolurile selectate vor putea tipari itemii intr-un fisier',
    'admin_email_security' => 'Securitate SMTP',
    'alert_page_will_reload' => 'Pagina va fi reincarcata',
    'file_protection_password' => 'Definire parola fisier',
    'expand' => 'Extinde',
    'collapse' => 'Restrange',
    'settings_ldap_user_attribute' => 'Atributele utilizatorului de cautat',
    'settings_ldap_user_attribute_tip' => 'LDAP attribute to search within for username',
    'log_user_initial_pwd_changed' => 'Parola initiala',
    'log_user_email_changed' => 'Emailul utilizatorului a fost schimbat in ␣',
    'log_user_created' => 'Contul de utilizator a fost creat',
    'log_user_locked' => 'Utilizatorul a fost blocat',
    'log_user_unlocked' => 'Utilizatorul a fost deblocat',
    'log_user_pwd_changed' => 'Parola a fost schimbata',
    'settings_default_session_expiration_time' => 'Perioada implicita de expirare a sesiunii',
    'settings_duo' => 'Activare autetificare DUO security 2F',
    'settings_duo_tip' => 'Duo Security cloud-based two-factor authentication from duo.com. One-time use login passcodes via SMS, voice call, or mobile app. An account with Duo is required to use this feature. Two-factor login via Duo will be required for all non-admin users when activated.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Credentials from the Duo Security administration page for your account must be input here. Settings will be stored in the sk.php file only after pressing the save button.',
    'admin_duo_intro' => 'Input or generate Duo Security secret',
    'edit' => 'Editare',
    'user_info_locked' => 'Contul este BLOCAT.',
    'user_info_unlock_question' => 'Deblocare cont?',
    'user_info_lock_question' => 'Blocare cont?',
    'user_info_delete_question' => 'Stergere cont?',
    'user_info_active' => 'Contul este ACTIV.',
    'refresh' => 'Actualizeaza',
    'loading' => 'Incarcare',
    'searching' => 'Caut ...',
    'list_items_with_tag' => 'Listeaza itemii cu acest tag',
    'no_item_to_display' => 'Nu sunt itemi de afisat',
    'opening_folder' => 'Citire director ...',
    'suggestion_notify_subject' => 'O noua sugestie de parola a fost transmisa',
    'suggestion_notify_body' => 'A user has submitted a password item suggestion to the password manager. You need to accept the submission before it can be used by other users.<br>Info:<br>- Label: #tp_label#<br>- Folder: #tp_folder#<br>- User: #tp_user#<br><br>This email has been sent to all managers.',
    'error_unknown' => 'S-a produs o eroare neasteptata!',
    'no_edit' => 'Scriere fara editare',
    'role_cannot_edit_item' => 'Nu pot fi editate elemente',
    'no_delete' => 'Scriere fara stergere',
    'role_cannot_delete_item' => 'I',
    'my_profile' => 'Profilul meu',
    'starting' => 'Incepere',
    'total_number_of_items' => 'Numarul total de elemente',
    'finalizing' => 'Finalizare',
    'treating_items' => 'Procesare elemente',
    'number_of_items_treated' => 'Numarul de elemente procesate',
    'error_sent_back' => 'A aparut eroarea',
    'full' => 'Plin',
    'sequential' => 'Secvential',
    'tree_load_strategy' => 'Tree load strategy',
    'syslog_enable' => 'Logurile vor fi trimise catre serverul de <i>syslog</>',
    'syslog_host' => 'Numele sau adresa serverului de syslog',
    'syslog_port' => 'Port syslog (implicit 514)',
    'error_bad_credentials' => 'Credentialele nu corespund',
    'settings_ldap_usergroup' => 'LDAP group to search',
    'settings_ldap_usergroup_tip' => 'Grup LDAP din care un membru trebuie sa faca parte pentru autentificare. Exemplu: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Activeaza schimbare parola pe server remote (prin SSH)',
    'update_server_password' => 'Actualizeaza parola de pe server',
    'ssh_pwd' => 'Parola SSH',
    'ssh_user' => 'User SSH',
    'ssh_password_frequency_change_info' => 'Select the interval between automatic server password updates (selecting 0 will disable automatic password changing).<br />Automatic password updates will only be performed if the system administrator has also configured the scheduled password update feature cron job.',
    'ssh_password_frequency_change' => 'Password change frequency (in months)',
    'ssh_scheduled_change' => 'Modificare programata',
    'ssh_one_shot_change' => 'One-time change',
    'server_password_change_enable_tip' => 'This setting adds an option in the password item to automatically change the user password on a server address listed in the url. This requires the remote UNIX server to allow username and password login via SSH. Automatic scheduled password changes can be performed after adding <i>/files/script.ssh.php</i> to crontab to run once a day on the password manager webserver.',
    'error_bad_credentials_more_than_3_times' => 'Credentialele de acces nu corespund!<br>Va rog asteptati 10 secunde inainte de o noua incercare',
    'settings_ldap_object_class' => 'Class to search',
    'settings_ldap_object_class_tip' => 'LDAP class to search, such as user account or POSIX account',
    'rebuild_config_file' => 'Rebuild the configuration file',
    'rebuild_config_file_tip' => 'The configuration file contains system variables, and is used when these settings are needed before the database connection has been established. Rebuilding the configuration file saves the database values to the file, and can be done any time. The default location is ./includes/config/tp.config.php, but the file should be located outside the www directory for security.',
    'error_folder_complexity_lower_than_top_folder' => 'Subfolders must have password strength set the same or higher than parent folder',
    'new_item_email_body' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>New item &apos;#label&apos; has been created in Teampass.<br />You may access it clicking on this <a href="#link#">LINK</a>.<br/><br />Greetings.',
    'failed_logins' => 'Autentificari esuate',
    'error_only_numbers_in_folder_name' => 'Folder label can not be just a number. Please give your folder a name which includes letters.',
    'encrypted_data' => 'Datele sunt criptate in baza de date',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'Your Agses card id',
    'ga_flash_qr_and_login' => 'Flash this QR code with your mobile device, enter the 2Factor Authentication code and click `Enter` button.',
    'i_need_to_generate_new_ga_code' => 'I need a new QR code. Please send me by email a temporary Identication Code.',
    'settings_manager_move_item' => 'Managers can move any items they can view',
    'user_folders_rights' => 'Directoare vizibile',
    'create_item_without_password' => 'Permite crearea de elemente fara o parola definita',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Utilizator sursa',
    'share_rights_destination' => 'Utilizator destinatie',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Mutare elemente selectate',
    'delete_items' => 'Stergere elemente selectate',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'suggest_password_change' => 'Sugerati o schimbare de parola',
    'otv_is_enabled' => 'Utilizatorul poate propune linkuri One-Time-View',
    'error_source_and_destination_are_equal' => 'Sursa si Destinatia nu pot fi aceeasi!',
    'sending_anonymous_statistics' => 'Trimitere statistici anonime',
    'favourites_option_enabled' => 'Optiunea favorite activata',
    'personalfolders_option_enabled' => 'Optiunea Director personal activata',
    'country_statistics' => 'Statistici utilizare per tara',
    'country' => 'Tara',
    'users_statistics' => 'Numarul mediu de utilizatori per instanta',
    'items_all' => 'Toate elementele',
    'folders_all' => 'Toate directoarele',
    'items_shared' => 'Toate elementele partajate (exclude pe cele personale)',
    'folders_shared' => 'Toate directoarele partajate (exclude pe cele personale)',
    'items_statistics' => 'Numarul mediu de elemente per instanta',
    'folders_statistics' => 'Numarul mediu de directoare per instanta',
    'administrators_number' => 'Numarul de utilizatori Administrator',
    'administrators_number_statistics' => 'Numarul mediu de Administratori per instanta',
    'managers_number' => 'Numarul de utilizatori Manager',
    'managers_number_statistics' => 'Numarul mediu de Manageri per instanta',
    'readonly_number_statistics' => 'Numarul mediu de utilizatori Read-Only per instanta',
    'readonly_number' => 'Numarul utilizatorilor Read-Only',
    'mysql_version' => 'Versiune MySQL',
    'php_version' => 'Versiune PHP',
    'teampass_version' => 'Versiune Teampass',
    'languages_used' => 'Limbi utilizate',
    'languages_statistics' => 'Cele mai utilizate limbi',
    'kb_option_enabled' => 'Activare facilitate KB (Knowledge Base)',
    'suggestion_option_enabled' => 'Activare sugestii',
    'customfields_option_enabled' => 'Campurile personalizate activate',
    'api_option_enabled' => 'Optiunea API activata',
    '2fa_option_enabled' => 'Optiunea 2FA activata',
    'agses_option_enabled' => 'Optiunea AGES activata',
    'duo_option_enabled' => 'Optiunea DUO Security activata',
    'ldap_option_enabled' => 'Optiunea LDAP activata',
    'syslog_option_enabled' => 'Optiunea Syslog activata',
    'stricthttps_option_enabled' => 'Optiunea Strict HTTPS activata',
    'characteristic' => 'Caracteristica',
    'current_value' => 'Valoare curenta',
    'communication_means' => 'Mod de comunicare',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'Mai multe informatii',
    'feature_request_canal' => 'Pentru cereri de facilitati noi, va rugam utilizati',
    'bug_canal' => 'Pentru erori, va rugam folositi',
    'documentation_canal' => 'Documentatia',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'Acest element are o propunere de schimbare',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revenire?',
    'revert_the_database' => 'Ai ales revenirea la versiunea anterioara a bazei. Poti confirma?',
    'bad_psk' => 'Aceasta cheie salt personala nu e corecta!',
    'ldap_test_config' => 'Testeaza configuratia curenta',
    'ldap_test_username' => 'Utilizator folosit pentru test',
    'ldap_test_username_pwd' => 'Parola utilizatorului',
    'feature_support_canal' => 'Pentru ajutor & suport, te rog foloseste',
    'category' => 'Categorie',
    'text' => 'Text',
    'type' => 'Tip',
    'data_is_masked' => 'Datele sunt Ascunse',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Nivelul de securitate cerut nu a fost atins!',
    'personal_saltkey_security_level' => 'Nivelul minim de securitate al cheii de salt personale',
    'settings_disable_forgot_password_link' => 'Ascundere link de parola uitata de pe pagina de start',
    'newly_created_user_is_administrated_by' => 'Noul user este administrat de',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',
    'generate_new_keys' => 'Generate new keys',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown.',
    'generate_new_keys_end' => 'Process is on going in background and could take several minutes. You can now close this window.',
    'confirm_password' => 'We need you to confirm your password',
    'no_code_is_requested' => 'No code is requested.',
    'user_encryption_ongoing' => 'Account is currently being encrypting. Your request cannot continue. Please wait until this is finished.',
    'teampass_information' => 'Teampass information',
    'show_password' => 'Show password',
    'new_user_info_by_mail' => 'New user will receive an email with his credentials',
    'login_credentials' => 'Login credentials',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following password is expected next time using Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your Teampass account is fully ready.<br><br>Cheers',
    'email_body_user_config_5' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following code is expected next time using Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Data is not valid',
    'mfa_enabled' => 'MFA enabled',
    'mfa_disabled_for_user' => 'MFA disabled for user',
    'users_personal_folder' => 'Users personal folder',
    'maintenance_operations' => 'Maintenance operations',
    'maintenance_operations_tip' => 'Selected maintenance operations on Teampass database.',
    'purge_temporary_files' => 'Purge temporary files',
    'task_scheduling' => 'Task scheduling',
    'parameter' => 'Parameter',
    'frequency' => 'Frequency',
    'in_minutes' => 'in minutes',
    'hourly' => 'Hourly',
    'daily' => 'Daily',
    'clean_orphan_objects' => 'Clean orphan objects',
    'run_once' => 'Run once',
    'run_weekday' => 'Run on weekday',
    'monday' => 'Monday',
    'tuesday' => 'Tuesday',
    'wednesday' => 'Wednesday',
    'thursday' => 'Thursday',
    'friday' => 'Friday',
    'saturday' => 'Saturday',
    'sunday' => 'Sunday',
    'monthly' => 'Monthly',
    'day_of_month' => 'Day of month',
    'day' => 'Day',
    'reset' => 'Reset',
    'error_while_creating_file' => 'Error while creating file',
    'new_keys_generated' => 'New keys generated',
    'user_creation' => 'User creation',
    'user_deletion' => 'User deletion',
    'maximum_session_expiration_time' => 'Maximum session expiration time',
    'maximum_session_expiration_time_tip' => 'Maximum time in minutes a session can be extended by a user',
    'index_session_duration_too_long' => 'Session duration is too long',
    'extend_session_duration_by' => 'Extend session duration by',
    'settings_ldap_user_dn_attribute' => 'User Distinguished Name',
    'settings_ldap_user_dn_attribute_tip' => 'The attribute label for the user Distinguished Name (DN) in the AD.<br>Example: For openLDAP: dn. For Active Directory:  distinguishedname.',
    'open_tasks_settings' => 'Open tasks settings',
    'maximum' => 'maximum',
    'updated' => 'Updated',
    'number_of_days' => 'Number of days',
    'number_of_times' => 'Number of times',
    'sharekey_not_ready' => 'Sharekey not yet generated ... all item data may not be ready ... please try later',
    'item_action_not_yet_possible' => 'Action not yet possible on this item',
    'open' => 'Open',
    'reload_user_cache_table' => 'Reload user cache table',
    'send_email_to_user' => 'Send email to user',
    'items_management' => 'Items operations',
    'previously_used_passwords' => 'Previously used passwords',
    'next_passwords_were_valid_until_date' => 'Next passwords were valid until date',
    'feature_disabled_by_administrator' => 'Feature disabled by administrator',
    'shared_globaly' => 'Shared globaly',
    'settings_otv_subdomain' => 'OTV subdomain name',
    'settings_otv_subdomain_tip' => 'Dedicated subdomain for onetime links. Considere your main Teampass URL as isolated from internet, this subdomain could be reachable by everyone to share this item with someone outside your organisation. From security perspective it is a lot safer with such mechanics. Note: This would requite to have a DNS entry for this subdomain pointing to your Teampass server.',
    'existing_valid_otv_links' => 'OTV valid links',
    'started' => 'Started',
    'recovery_keys_not_downloaded' => 'Recovery keys not downloaded',
    'no_recovery_keys' => 'I do not have recovery keys. This will clear all passwords from my personal items.',
    'provide_recovery_keys' => 'Provide your recovery keys',
    'public_key' => 'Public key',
    'private_key' => 'Private key',
    'download_recovery_keys' => 'Download your recovery keys',
    'download_recovery_keys_confirmation' => 'You are about to download your recovery keys. Please store them in a safe place as they should be mandatory in case of deasaster.',
    'recovery_keys_download_date' => 'Recovery keys download date',
    'keys_not_recovered' => 'Public and Private keys not stored',
    'keys_not_recovered_explanation' => 'In order to prevent against any passwords lost, you should store safely your personal Teampass keys',
    'get_your_recovery_keys' => 'Get your recovery keys',
    'keys_management' => 'Keys management',
    'please_confirm_task_to_be_run' => 'Please confirm the task to be performed',
    'user_keys_downloaded' => 'User keys downloaded',
    'mfa_code_send_by_email' => 'MFA code sent by email',
    'otp' => '',
    'otp_code' => 'OTP code',
    'enabled_otp_for_item' => 'Enable OTP code',
    'at_otp_status' => 'OTP status',
    'phone_number' => 'Related phone number (optional)',
    'otp_secret' => 'OTP secret key',
    'settings_ldap_group_objectclasses_attibute' => 'AD Group ObjectClasses attribute',
    'settings_ldap_group_objectclasses_attibute_tip' => 'The objectClasses to use when searching for groups. Several objectClasses are separated by a comma (,). Example: groupOfNames,group or top,posixGroup',

);
