<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @file      hungarian.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your AD credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your AD since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Az alapértelmezett nem biztonságos LDAP port: 389, a biztonságos LDAP port: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Select all',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Naplók',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'Részletek',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn&apos;t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Biztos',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Szerepkörök',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Címke',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Click to open Teampass website',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Profilkép kiválasztása',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Mappa másolása',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Felhasználók',
    'folders' => 'Mappák',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% megtalálva',
    'auto_update_server_password_info' => 'A Start gombra kattintva a következők történnek:<ul><li>SSH protokollon keresztül kapcsolódik a szerverhez, a megadott hitelesítési és `URL` adatokkal,</li><li>Módosul a szerveren a felhasználó jelszava</il><li>Elmentésre kerül az új jelszó a Teampass-ban.</il><li>Bezárásra kerül az SSH kapcsolat</li></ul><br /><b>Bizonyosodjon meg róla, hogy a felhasználónak van joga a bejelentkezéshez és a jelszó megváltoztatásához (ha nincs, akkor adjon meg a root belépési kódot és jelszót) mielőtt elkezdené a műveletet.</b>',
    'share' => 'Tétel megosztása',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'Ki kell választani egy mappát',
    'email_subject_item_updated' => 'A jelszó aktualizálásra került.',
    'email_body_item_updated' => 'Helló,<br><br>A &apos;#item_label#&apos; jelszava módosítva lett.<br /><br />Ellenőrizheti <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">ITT</a><br /><br />Üdvözettel',
    'import_kp_finished' => 'A KeePass importálás befejeződött. Az új mappák jelszó erőssége Közepes lett, állítsa be a kívánt jelszó erősséget.',
    'password_is_empty' => 'Item has no password',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bugs_page' => 'Ha hibát talál, kérjük jelezze felénk.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Állítsa be a <i>bárki, aki a szerepkörhöz tartozik, módosíthatja</i> jogot minden importált tételre.',
    'import_csv_anyone_can_modify_txt' => '"Bárki módosíthatja" jog beállítása minden importált tételre.',
    'settings_upload_imageresize_options' => 'Képeket át kell méretezni',
    'user_not_exists' => 'Ez a felhasználó nem létezik!',
    'auto_create_folder_role' => 'Mappa és szerepkör létrehozása',
    'start_upload' => 'Feltöltés indítása',
    'error_upload_runtime_not_found' => 'Feltöltés: nincs "runtime".',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Saját jelszó módosítása',
    'admin_2factors_authentication_setting' => 'Google 2-szintű hitelesítés',
    'admin_2factors_authentication_setting_tip' => 'A Google két fázisú hitelesítés megnöveli a bejelentkezés biztonságát. Bejelentkezéskor egy QR kód jelenik meg, melyet be kell olvasni a Google Hitelesítővel ahhoz, hogy az generáljon egy egyszeri jelszót. Ehhez a felhasználóknak szükségük van a Google Hitelesítőre és egy Internethez kapcsolt mobil eszközre.',
    'admin_ga_website_name' => 'A Google Hitelesítőben megjelenő név.',
    'admin_ga_website_name_tip' => 'Ezt a nevet használja a profil azonosításra a Google Hitelesítő.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] egy tételt megosztottak Önnel',
    'email_share_item_mail' => 'Üdvözöljük!<br><br><u>#tp_user#</u> megosztotta Önnel  a(z) <b>#tp_item# tételt.</b><br>Kattintson erre a <a href="#tp_link#">hivatkozásra</a> a megtekintéshez.<br><br>',
    'index_maintenance_mode_admin' => 'Karbantartási üzemmód aktiválva. Felhasználók nem léphetnek be.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Google Hitelesítő küldése a felhasználónak email-ben.',
    'error_no_email' => 'Ennek a felhasználónak nincs email beállítva!',
    'error_no_user' => 'Nemlétező felhasználó!',
    'email_ga_subject' => 'Az Ön Google Hitelesítő kódja a Teampass számára.',
    'email_ga_text' => 'Üdvözöljük!<br><br>Kérjük kattintson <a href="#link#">IDE</a> és fotózza le a Google Hitelesítő alkalmazással, hogy megkapja az egyszeri Teampass azonosítóját.<br /><br />Viszontlátásra ',
    'settings_attachments_encryption' => 'Tételek csatolmányainak titkosítása.',
    'settings_attachments_encryption_tip' => 'EZ AZ OPCIÓ ELÉRHETETLENNÉ TEHETI A MEGLÉVŐ MELLÉKLETEKE',
    'admin_action_attachments_cryption' => 'Tételek csatolmányainak titkosítása és visszafejtése.',
    'admin_action_attachments_cryption_tip' => 'FIGYELEM: ezt a funkciót csak azt követően szabad használni, hogy megváltozott a "Teampass beállítások" lap kapcsolódó értéke. A művelet indítását megelőzően csináljon mentést az "upload" könyvtár tartalmáról.',
    'encrypt' => 'Titkosítás',
    'decrypt' => 'Visszafejtés',
    'ga_identification_code' => 'Azonosító kód',
    'ga_enter_credentials' => 'Meg kell adnia a bejelentkezési adatait',
    'ga_bad_code' => 'Hibás Google Hitelesítő kód',
    'settings_get_tp_info' => 'Automatikusan töltse be a Teampass információkat.',
    'settings_get_tp_info_tip' => 'Ez az opció lehetővé teszi a Teampass szerver verzió és modul használat információinak betöltését. ',
    'settings_offline_mode' => 'Off-line mód aktiválása',
    'settings_offline_mode_tip' => 'Az Off-line mód lehetővé teszi, hogy a tételeket HTML formátumban exportálhassa. A jelszavak egy a felhasználó által megadott jelszóval lesznek elkódolva.',
    'offline_mode_key_level' => 'Off-line titkosítási kulcs minimális erőssége',
    'categories' => 'Kategóriák',
    'no_category_defined' => 'Még nincs kategória rögzítve.',
    'confirm_deletion' => 'Biztos törli?',
    'settings_item_extra_fields' => 'Egyedi tétel mezők engedélyezve',
    'settings_item_extra_fields_tip' => 'Engedélyez egy újabb lapfület a jelszó adatainál, ahol további egyedi mezőket lehet kitölteni. Az adminisztrátornak előzetesen létre kell hoznia a kategóriákat, és a kategóriákhoz tartozó címkéket. Ez a funkció több szerver erőforrást igényel.',
    'settings_ldap_type' => 'LDAP szerver típusa',
    'server_time' => 'Szerver idő',
    'settings_tree_counters' => 'Számlálók megjelenítése a könyvtár struktúrában.',
    'settings_tree_counters_tip' => 'Ennek a funkciónak a hatására a könyvtár neve mellett megjelenik az alap mappában lévő tételek száma, az almappákban lévő tételek száma és az almappák száma. Engedélyezésével megnőhet a szerver terhelése és lassabb lesz a fa struktúra betöltése.',
    'admin_action_check_pf' => 'Személyes mappák aktualizálása (létrehozás, ha nincs).',
    'enable_personal_folder_feature_tip' => 'Aktiváláskor kézzel kell futtatni azt a szkriptet, ami létrehozza a személyes mappát a már létező felhasználók részére. Figyelem: ezt csak azoknak hozza létre a mappát, akiknek még nincs. A &apos;".$txt[&apos;admin_action_check_pf&apos;]."&apos; szkript a &apos;".$txt[&apos;admin_actions_title&apos;]."&apos; lapot érhető el.',
    'administrators_only' => 'Csak adminisztrátorok',
    'managers_of' => 'Az alábbi szerepkör menedzsere:',
    'managed_by' => 'Menedzseli',
    'settings_enable_sts' => 'HTTPS',
    'settings_enable_sts_tip' => 'Kényszeríti a HTTPS STS használatát. Az STS segít kiküszöbölni a közbeékelődéses támadásokat. Kell hozzá egy SSL tanúsítvány. Saját tanúsítvány használata esetén az engedélyezés tönkreteheti a teampass adatokat. Az &apos;SSLOptions +ExportCertData&apos; beállításnak léteznie kell az Apache SSL konfigurációban.',
    'settings_anyone_can_modify_bydefault' => 'Alapértelmezett a <i>Bárki módosíthatja</i> opció',
    'to' => 'eddig',
    'settings_upload_maxfilesize_tip' => 'Maximális fájl méret. Egyeznie kell a szerver beállításaival.',
    'settings_upload_docext_tip' => 'Dokumentum típusok. Sorolja fel az engedélyezett fájl kiterjesztéseket, vesszővel elválasztva. (,)',
    'settings_upload_imagesext_tip' => 'Kép típusok. Sorolja fel az engedélyezett fájl kiterjesztéseket, vesszővel elválasztva. (,)',
    'settings_upload_pkgext_tip' => 'Csomag típusok. Sorolja fel az engedélyezett fájl kiterjesztéseket, vesszővel elválasztva. (,)',
    'settings_upload_otherext_tip' => 'Más típusok. Sorolja fel az engedélyezett fájl kiterjesztéseket, vesszővel elválasztva. (,)',
    'settings_upload_imageresize_options_tip' => 'Aktiválás esetén átméretezi a képeket az alábbi formátumra.',
    'settings_upload_maxfilesize' => 'Max. fájl méret (Mb)',
    'settings_upload_docext' => 'Engedélyezett dokumentum kiterjesztések',
    'settings_upload_imagesext' => 'Engedélyezett kép kiterjesztések',
    'settings_upload_pkgext' => 'Engedélyezett csomag kiterjesztések',
    'settings_upload_otherext' => 'Engedélyezett egyéb kiterjesztések',
    'settings_upload_imageresize_options_w' => 'Átméretezett kép szélessége (pixel)',
    'settings_upload_imageresize_options_h' => 'Átméretezett kép magassága (pixel)',
    'settings_upload_imageresize_options_q' => 'Átméretezett kép minősége',
    'settings_importing' => 'Adatok importálása CVS/KeyPass fájlból engedélyezve',
    'admin_proxy_ip' => 'Proxi kiszolgáló IP címe',
    'admin_proxy_ip_tip' => '<span style="font-size:11px;max-width:300px;">Ha az internetet proxy kiszolgálón keresztül éri el, ittt adja meg az IP címét.<br />Egyébként hagyja üresen.</span>',
    'admin_proxy_port' => 'Proxy kiszolgáló portja',
    'admin_proxy_port_tip' => '<span style="font-size:11px;max-width:300px;">Ha az internetet proxy kiszolgálón keresztül éri el, ittt adja meg a használt portot.<br />Egyébként hagyja üresen.</span>',
    'settings_ldap_elusers' => ' Csak Teampass helyi felhasználók ',
    'settings_ldap_elusers_tip' => 'Ez a funkció engedélyezi, hogy a felhasználók LDAP szolgáltatáson keresztül kerüljenek azonosításra. Tiltsa le, ha bármely LDAP könyvtárat használhatja.',
    'db_items_edited' => 'Tételek szerkesztés alatt',
    'item_edition_start_hour' => 'A szerkesztés kezdete',
    'settings_delay_for_item_edition' => 'Annak az ideje, aminek letelte után a tétel szerkesztése elutasításra kerül (percben)',
    'settings_delay_for_item_edition_tip' => 'A tételek szerkesztésekor az adott tétel zárolva van, így mások nem módosíthatják. Ez a beállítás megadja, hogy mennyi idő után kerüljön feloldásra a zárolás. Ha az érték 0, a tétel soha nem lesz  automatikusan feloldva.',
    'db_users_logged' => 'Jelenleg bejelentkezett felhasználók',
    'action' => 'Művelet',
    'login_time' => 'Bejelentkezve',
    'lastname' => 'Keresztnév',
    'user_login' => 'Login',
    'role' => 'Szerepkör',
    'error_role_exist' => 'Ez a szerepkör már létezik!',
    'error_no_edition_possible_locked' => 'A módosítás nem lehetséges, mert a tétel jelenleg szerkesztés alatt áll!',
    'select' => 'kiválaszt',
    'items' => 'Tételek',
    'enable_personal_saltkey_cookie' => 'A személyes SALT kulcs tárolható sütiben.',
    'personal_saltkey_cookie_duration' => 'A személyes SALT kulcs süti érvényességi ideje (napokban).',
    'admin_email_smtp_server' => 'Kimenő (SMTP) szerver',
    'admin_email_auth' => 'A kimenő szervernek hitelesítésre van szüksége',
    'admin_email_auth_username' => 'Hitelesítési felhasználó',
    'admin_email_auth_pwd' => 'Hitelesítési jelszó',
    'admin_email_port' => 'Szerver port',
    'admin_email_from' => 'Küldő címe (email)',
    'admin_email_from_name' => 'Küldő neve',
    'admin_email_test_configuration_tip' => 'Ez a teszt elküld egy levelet a megadott címre. Ha nem kapja meg, ellenőrizze a beállításokat.',
    'admin_email_test_subject' => '[TeamPass] Teszt levél',
    'admin_email_test_body' => 'Üdvözöljük!<br><br>Az email kiküldése sikerült.<br><br>Viszontlátásra.',
    'admin_email_result_ok' => 'Az email kiküldésre került a #email# címre. Kérjük ellenőrizze postafiókját.',
    'email_bodyalt_item_updated' => 'A(z) #item_label# jelszava módosult.',
    'admin_email_send_backlog_tip' => 'Az adatbázisban várakozó kiküldetlen kimenő levelek újraküldése.',
    'please_wait' => 'Kérjük várjon!',
    'admin_path_to_files_folder' => 'A fájlok mappájának elérési útja',
    'admin_path_to_files_folder_tip' => 'A fájlok mappa tárolja mind a rendszer, mind a feltöltött fájlokat. A nagyobb biztonság érdekében nem tanácsos a www mappát használni. Célszerű a weboldal könyvtárán kívül létrehozni és rewrite, vagy redirect szablyok segítségével elérni.</span>',
    'admin_path_to_upload_folder_tip' => 'A csatolmányok a feltöltési mappába kerülnek egy véletlenszerűen generál névvel. Ennek a mappának a tartamát soha nem szabad kézzel törölni. A legnagyobb biztonság érdekében nem tanácsos a www mappát használni. Célszerű a weboldal könyvtárán kívül létrehozni és rewrite, vagy redirect szablyok segítségével elérni.</span>',
    'pdf_password_warning' => 'Adjon meg egy titkosító kulcsot!',
    'admin_pwd_maximum_length' => 'A jelszavak maximális hossza.',
    'admin_pwd_maximum_length_tip' => 'A jelszavak alapértelmezett hossza 40. Fontos megjegyezni, hogy a jelszavak hosszának növelése kihatással van a teljesítményre. Minél hosszabb egy jelszó, annál több ideig tart annak elkódolása és visszafejtése.',
    'settings_insert_manual_entry_item_history' => 'A tételek naplójába engedélyezett a kézi beszúrás.',
    'settings_insert_manual_entry_item_history_tip' => 'Előfordulhatnak olyan helyzetek, amikor be kell szúrni egy sort a tételek naplójába. A kézi beszúráshoz aktiválni kell ezt a funkciót.',
    'admin_path_to_upload_folder' => 'Feltöltési mappa útvonala',
    'admin_setting_enable_delete_after_consultation' => 'Konzultáció után a tételek automatikusan törölhetők ',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Ha engedélyezve van, a tétel létrehozója dönthet arról, hogy bizonyos számú megtekintés után automatikusan törlődjön.</span>',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Küldjön értesítést email-ben, ha a tételt valaki megnézi',
    'share_sent_ok' => 'Email elküldve',
    'see_item_title' => 'Tétel részletei',
    'email_on_open_notification_subject' => '[TeamPass] Értesítés tétel megtekintéséről',
    'email_on_open_notification_mail' => 'Üdvözöljük!<br><br>#tp_user# megnyitotta a &apos;#tp_item#&apos; tételt.<br>Kattintson erre a <a href="#tp_link#">hivatkozásra</a> a megnyitáshoz.<br><br>',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Az Ön hozzáférése',
    'email_new_user_mail' => 'Üdvözöljük!<br><br>Az adminisztrátor létrehozott Önnek egy hozzáférést a Teampasshoz.<br>Az alábbi adatokkal tud bejelntkezni:<br>- Felhasználó: #tp_login#<br>- Jelszó: #tp_pw#<br><br>Kattintson erre a <a href="#tp_link#">hivatkozásra</a> a belépéshez.<br><br>',
    'error_empty_data' => 'Nincsenek adatok!',
    'error_not_allowed_to' => 'Ez a funkció az Ön számára nem engedélyezett!',
    'request_access_ot_item' => 'Hozzáférési engedély kérése',
    'email_request_access_subject' => '[TeamPass] Hozzáférési engedély kérése ',
    'email_request_access_mail' => 'Üdvözöljük #tp_item_author#!<br><br>A #tp_user# felhasználó hozzáférést kér a &apos;#tp_item#&apos; tételhez.<br><br>Bizonyosodjon meg a felhasználó jogairól, mielőtt a tétel hozzáférését megváltoztatja.<br><br>',
    'admin_action_change_salt_key' => 'Fő SALT kulcs megváltoztatása',
    'nb_items_by_query' => 'Az egy menetben lekérdezett tételek száma',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Több tétel esetén azok megjelenítése is több időt vesz igénybe.<br />Az &apos;auto&apos; használatával a program automatikusan állítja be a lekérdezés paramétereit, a képernyő mérete alapján.<br />A &apos;max&apos; beállítással egyszerre az összes tétel megjelenítésre kerül.<br />Érték megadásával beállítható az egy menetben lekérdezett tételek száma.</span>',
    'open_url_link' => 'Megnyitás új lapon',
    'error_pw_too_long' => 'A jelszó túl hosszú! Maximum 40 karakter lehet.',
    'at_restriction' => 'Korlátozás',
    'pw_encryption_error' => 'Hiba a jelszó titkosítása során!',
    'enable_send_email_on_user_login' => 'Email küldése az adminisztrátornak a felhasználó belépésekor',
    'email_subject_on_user_login' => '[TeamPass] Egy felhasználó belépett',
    'email_body_on_user_login' => 'Üdvözöljük!<br><br>#tp_user# bejelentkezett a TeamPass rendszerbe. Időpont: #tp_date# at #tp_time#.<br><br>',
    'account_is_locked' => 'Ez a felhasználó zárolva van',
    'activity' => 'Aktivitás',
    'add_role_tip' => 'Új szerepkör',
    'admin' => 'Adminisztráció',
    'admin_action_db_backup' => 'Adatbázis mentése.',
    'admin_action_db_clean_items' => 'Árva tételek törlése az adatbázisból.',
    'admin_action_db_clean_items_tip' => 'Eltávolítja a mappák törlését követően visszamaradt tételeket és más bejegyzéseket. A funkció indítását megelőzően készítsen mentést.',
    'admin_action_db_optimize' => 'Adatbázis optimalizálása',
    'admin_action_db_restore' => 'Adatbázis visszatöltése',
    'admin_action_purge_old_files' => 'Ideiglenes fájlok törlése',
    'admin_action_purge_old_files_tip' => 'Minden 7 napnál régebbi ideiglenes fájl törlése.',
    'admin_action_reload_cache_table' => 'Gyorsítótár újraöltése',
    'admin_action_reload_cache_table_tip' => 'Tételek gyorsítótárának újra létrehozása. Kijavíthat jelszó megjelenítése és mentési problémákat.',
    'admin_help' => 'Segítség',
    'admin_ldap_configuration' => 'LDAP konfiguráció',
    'admin_main' => 'Információ',
    'admin_misc_cpassman_dir' => 'TeamPass elérése (teljes útvonal)',
    'admin_misc_cpassman_url' => 'TeamPass elérése (URL)',
    'admin_misc_custom_login_text' => 'Egyedi bejelentkező üzenet',
    'admin_misc_custom_logo' => 'Egyedi bejelentkező logo (URL)',
    'admin_misc_favicon' => 'Favicon (teljes URL)',
    'admin_settings' => 'Beállítások',
    'admin_settings_title' => 'Beállítások',
    'admin_setting_activate_expiration' => 'Jelszó lejárat engedélyezése',
    'admin_setting_activate_expiration_tip' => 'Engedélyezés esetén azok a jelszavak, melyek lejártak, nem jelennek meg többé. Ennek a funkciónak az engedélyezése előtt állítsa be a jelszavak lejáratát.',
    'admin_views' => 'Eszközök',
    'alert_message_done' => 'Kész!',
    'all' => 'összes',
    'anyone_can_modify' => 'Ezt a tételt bárki módosíthatja, aki hozzáfér',
    'at' => 'nál',
    'at_category' => 'Mappa',
    'at_copy' => 'A másolás elkészült',
    'at_delete' => 'Törlés',
    'at_description' => 'Leírás',
    'at_label' => 'Címke',
    'at_login' => 'Bejelentkezés',
    'at_moved' => 'Áthelyezve',
    'at_personnel' => 'Személyes',
    'at_restored' => 'Visszaállítva',
    'at_shown' => 'Hozzáférhető',
    'at_url' => 'URL',
    'author' => 'Szerző',
    'authorized_groups' => 'Engedélyezett csoportok',
    'auth_creation_without_complexity' => 'Engedélyezett az elvárt jelszó erősség nélküli tétel létrehozás',
    'auth_modification_without_complexity' => 'Engedélyezett az elvárt jelszó erősség nélküli tétel módosítás',
    'cancel' => 'Mégsem',
    'can_create_root_folder' => 'A gyökér mappában nem lehet mappát létrehozni',
    'changelog' => 'Legutóbbi szoftver frissítések',
    'close' => 'Bezárás',
    'complexity' => 'Minimális jelszó erősség',
    'complex_asked' => 'Szükséges jelszó erősség',
    'complex_level0' => 'Nagyon gyenge',
    'complex_level1' => 'Gyenge',
    'complex_level2' => 'Közepes',
    'complex_level3' => 'Erős',
    'complex_level4' => 'Nagyon erős',
    'complex_level5' => 'Erős',
    'complex_level6' => 'Nagyon erős',
    'confirm' => 'Megerősítés',
    'confirm_del_from_fav' => 'Erősítse meg a kedvencek törlését',
    'connections' => 'kapcsolatok',
    'copy' => 'Másolás',
    'copy_to_clipboard_small_icons' => '<i>Jelszó másolás</i> ikon engedélyezése a tétel listában',
    'copy_to_clipboard_small_icons_tip' => 'Megjelenít egy kis ikont a jelszó tételek felső táblázatában, melyre kattintva a jelszó közvetlenül a vágólapra másolható a nélkül, hogy be kéne tölteni a tétel összes adatát.',
    'date' => 'Dátum',
    'date_format' => 'Dátum formátum',
    'delete' => 'Törlés',
    'deletion' => 'Törlések',
    'del_button' => 'Törlés',
    'description' => 'Leírás',
    'disconnect' => 'Kijelentkezés',
    'done' => 'Kész',
    'duplicate_folder' => 'A mappa neve már létezik',
    'duplicate_item' => 'A tétel neve már létezik',
    'email' => 'Email',
    'email_subject' => 'Új jelszót hoztak létre a jelszó kezelőben',
    'enable_favourites' => 'A kedvencek funkció engedélyezve van',
    'enable_personal_folder' => 'Magán jelszavakhoz használható személyes mappák',
    'enable_personal_folder_feature' => 'Magán jelszavakhoz használható személyes mappák',
    'enable_user_can_create_folders' => 'Az almappákat mindenki kezelheti, aki kezelheti a szülő mappát',
    'encrypt_key' => 'Titkosító kulcs',
    'errors' => 'hibák',
    'error_group_exist' => 'Ez a mappa már létezik!',
    'error_html_codes' => 'Néhány szöveg HTML kódokat tartalmaz, ami nem megengedett!',
    'error_item_exists' => 'Ez a tétel már létezik!',
    'error_label' => 'A címke kötelező!',
    'error_must_enter_all_fields' => 'Minden mezőt ki kell tölteni!',
    'error_pw' => 'A jelszó lapon meg kell adni a jelszót.',
    'error_tags' => 'A címkékben csak szóközökkel lehet elválasztani a címkéket.',
    'error_user_exists' => 'A felhasználó már létezik',
    'expiration_date' => 'Lejárati dátum',
    'find' => 'Keresés',
    'forbidden_groups' => 'Tiltott mappák',
    'forgot_my_pw_email_sent' => 'Email elküldve',
    'functions' => 'Szerepkörök',
    'gestionnaire' => 'Menedzser',
    'god' => 'Adminisztrátor',
    'group' => 'Mappa',
    'group_parent' => 'Szülő mappa',
    'group_pw_duration' => 'Megújítási periódus',
    'group_pw_duration_tip' => 'Hónapokban. Adjon 0-át a tiltáshoz.',
    'history' => 'Történet',
    'home_personal_saltkey' => 'Az Ön személyes SALT kulcsa',
    'home_personal_saltkey_label' => 'Adja meg a személyes SALT kulcsát',
    'import_error_no_read_possible' => 'A fájl nem olvasható!',
    'import_error_no_read_possible_kp' => 'A fájl nem olvasható! KeePass fájlnak kell lennie.',
    'import_keepass_to_folder' => 'Jelölje ki a cél mappát',
    'index_add_one_hour' => 'Munkamenet kiterjesztése 1 órával',
    'index_change_pw_confirmation' => 'Megerősítés',
    'index_expiration_in' => 'munkamenet lejárata',
    'index_get_identified' => 'Kérjük azonosítsa magát',
    'index_last_pw_change' => 'Jelszó módosult',
    'index_last_seen' => 'Utolsó belépés ',
    'index_login' => 'Fiók',
    'index_new_pw' => 'Új jelszó',
    'index_password' => 'Jelszó',
    'index_pw_error_identical' => 'A jelszavaknak egyezniük kell!',
    'index_pw_level_txt' => 'Jelszó erősség',
    'index_session_duration' => 'Munkafolyamat időtartama',
    'info' => 'Információ',
    'item_menu_copy_login' => 'Bejelentkezés másolás',
    'item_menu_copy_pw' => 'Jelszó másolás',
    'item_menu_del_from_fav' => 'Törlés a kedvencekből',
    'kbs' => 'KB',
    'kb_menu' => 'Tudásbázis',
    'last_items_title' => 'Utolsó megtekintett tétel',
    'ldap_extension_not_loaded' => 'Az LDAP PHP kiterjesztés nincs betöltve.',
    'level' => 'Szint',
    'login' => 'Bejelentkezés',
    'mask_pw' => 'Jelszó elrejtése/mutatása',
    'max_last_items' => 'Gyakran megtekintett jelszavak listájának mérete (alapértelmezetten 10)',
    'minutes' => 'percek',
    'name' => 'Név',
    'nb_false_login_attempts' => 'Maximális bejelentkezési próbálkozások száma zárolás előtt (0 - nincs zárolás)',
    'nb_folders' => 'Mappák száma',
    'nb_items' => 'Tételek száma',
    'new_label' => 'Új címke',
    'no' => 'Nem',
    'none' => 'Nincs',
    'none_selected_text' => 'Nincs kiválasztva',
    'not_allowed_to_see_pw' => 'Hozzáférés tiltva!',
    'not_allowed_to_see_pw_is_expired' => 'Ez a tétel lejárt!',
    'not_defined' => 'Nincs megadva',
    'number_of_used_pw' => 'Régi jelszavak újra felhasználásának ciklusa (0 nincs újrahasználat)',
    'pages' => 'Lapok',
    'pdf_download' => 'Fájl letöltés',
    'personal_salt_key' => 'Személyes SALT kulcs',
    'pw' => 'Jelszó',
    'pw_generate' => 'Generálás',
    'pw_is_expired_-_update_it' => 'Ez a tétel lejárt! Meg kell változtatni a jelszót.',
    'pw_life_duration' => 'A belépési jelszavak lejárnak xx nap múlva (0 - soha nem jár le)',
    'readme_open' => 'Teljes &apos;readme&apos; megnyitása',
    'read_only_account' => 'Csak olvasható',
    'restore' => 'Visszatöltés',
    'restricted_to' => 'Korátozva',
    'restricted_to_roles' => 'Tételek korlátozásának engedélyezése felhasználókra é szerepkörökre',
    'root' => 'Gyökér',
    'secure' => 'Biztonságos',
    'see_logs' => 'Napló megtekintése',
    'settings_anyone_can_modify' => '<i>Bárki módosíthatja</i> funkció engedélyezése',
    'settings_anyone_can_modify_tip' => 'Ez a beállítás megjelenít egy jelölőt a jelszó tétel létrehozásakor, mellyel megadható, hogy bárki módosíthatja.',
    'settings_default_language' => 'Alapértelmezett nyelv',
    'settings_kb' => 'Tudásbázis engedélyezve (béta teszt)',
    'settings_kb_tip' => 'Megjelenít egy új "tudásbázis" menüpontot. A tudásbázis egy kereshető "gyakori kérdések", mely lehetővé teszi a jelszakvakhoz kapcsolt súgó, vagy jegyzet létrehozását.',
    'settings_ldap_domain' => 'LDAP fiók domain utótag',
    'settings_ldap_domain_controler' => 'LDAP domain vezérlő(k)',
    'settings_ldap_domain_controler_tip' => 'Adja meg a címtár szolgáltatásokat biztosító tartományvezérlőt. Több szerver közti terhelés elosztáshoz a szerverek nevét sorolja fel vesszővel elválasztva.  Példa: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'Az Ön domain-jének LDAP alapú DN-e.',
    'settings_ldap_mode' => 'Felhasználók LDAP alapú hitelesítésének engedélyezése',
    'settings_ldap_mode_tip' => 'Engedélyezze, ha a felhasználókat LDAP címtárkiszolgálón keresztül akarja azonosítani, a belső felhasználói adatbázis helyett.',
    'settings_ldap_ssl' => 'LDAP használata SSL-en keresztül (LDAPS)',
    'settings_ldap_tls' => 'LDAP használata TLS-en keresztül',
    'settings_log_accessed' => 'Felhasználók által megtekintett tételek naplózása',
    'settings_log_connections' => 'Minden felhasználói fiók bejelentkezésének naplózása',
    'settings_maintenance_mode' => 'Karbantartási mód engedélyezése (bejelentkezések tiltása)',
    'settings_manager_edit' => 'A Menedzserek bármely általuk hozzáférhető tételt szerkeszthetik és törölhetik',
    'settings_printing' => 'PDF, vagy CSV export engedélyezve',
    'settings_printing_tip' => 'Hozzáad egy export funkciót a tételek fa struktúrájához, mely lehetővé teszi a mappák exportálását PDF vagy CSV formátumban. A CSV formátum nem jelszó védett, míg a PDF fájl védhető jelszóval.',
    'settings_restricted_to' => '<i>Korlátozva</i> funkció engedélyezése a tételeknél',
    'settings_show_description' => 'Tétel leírás mutatása a tétel listában',
    'size' => 'Méret',
    'tags' => 'Címkék',
    'timezone_selection' => 'Időzóna',
    'time_format' => 'Idő formátum',
    'url' => 'URL',
    'user' => 'Felhasználó',
    'users_online' => 'felhasználó van belépve',
    'user_alarm_no_function' => 'Ehhez a felhasználóhoz nincsenek szerepkörök rendelve!',
    'yes' => 'Igen',
    'one_time_view_item_url_box' => 'Megoszthatja egy egyszeri hivatkozás (URL) segítségével a jelszót egy megbízató személlyel.<br><br>#URL#<br><br>Ez a hivatkozás csak egyszer lesz elérhető, és lejár ekkor: #DAY# ',
    'settings_api' => 'API elérés engedélyezve',
    'settings_api_tip' => 'Az Alkalmazás Programozási Interfész segítségével a fejlesztők olyan programot írhatnak, mely segítségével JSON formátumban hozzáférhetnek a jelszavakhoz a hálózaton keresztül.',
    'settings_api_keys_list' => 'APU kulcs lista',
    'settings_api_keys_list_tip' => 'API elérési kulcs. A más gyártók által készített szoftvereknek egy véletlenszerű kulcsot kell létrehozniuk, hogy elérjék a JSON interfészt.',
    'settings_api_key' => 'Kulcs',
    'settings_api_add_ip' => 'Új IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Az új al mappák öröklik a szülő mappák engedélyeit',
    'subfolder_rights_as_parent_tip' => 'Ha engedélyezve van, minden almappa örökli a szülő mappa szerepköreit és engedélyeit. Ellenkező esetben a mappa annak a felhasználónak a jogait és szerepköreit örökli, aki létrehozta.',
    'show_only_accessible_folders_tip' => 'Alapértelmezetten a felhasználók láthatják a teljes mappa listát még akkor is, ha valamelyik elérhetetlen számunkra. Az átláthatóság megkönnyítése érdekében elrejthetők az elérhetetlen mappák.',
    'show_only_accessible_folders' => 'Elérhetetlen mappák elrejtése',
    'comment' => 'Megjegyzés',
    'suggestion_menu' => 'Javaslatok',
    'settings_suggestion' => 'Javaslatok engedélyezése a Csak-Olvasható felhasználók részére',
    'settings_suggestion_tip' => 'A tétel jabaslat lehetővé teszi a Csak-Olvasható felhasználók részére, hogy javaslatot tegyenek új tételekre, vagy tételek módosítására. Ezeket a javaslatokat az Adminisztrátorok és Menedzserek érvényesítik.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP kapcsolt Dn',
    'settings_ldap_bind_passwd' => 'LDAP kapcsolt jelszó',
    'settings_ldap_search_base' => 'LDAP keresési alap',
    'settings_ldap_bind_dn_tip' => 'A "Kapcsolt Dn" tud a felhasználói fában keresni és összekapcsolni.',
    'settings_ldap_bind_passwd_tip' => 'A "Kapcsolt Dn" jelszava, aki a felhasználói fában kereshet.',
    'settings_ldap_search_base_tip' => 'A fában történő kereséshez használt gyökér DN helye',
    'admin_email_server_url' => 'Az emailekben szereplő hivatkozások (linkek) szerverének URL címe.',
    'enable_email_notification_on_user_pw_change' => 'Küldjön email-t a felhasználónak, ha megváltozik a jelszava',
    'settings_otv_expiration_period' => 'Az egyszeri nézetek (OTV) megosztott tételeinek lejárati ideje (napokban)',
    'write' => 'Írás',
    'read' => 'Olvasás',
    'no_access' => 'Nincs hozzásférés',
    'right_types_label' => 'A kiválasztott felhasználói csoport mappához való hozzáférésének típusa',
    'duplicate_item_in_folder' => 'Hasonló nevű tételek engedélyezése a közös mappákban',
    'settings_roles_allowed_to_print' => 'Tételek nyomtatására jogosult szerepkörök megadása',
    'settings_roles_allowed_to_print_tip' => 'A kiválasztott szerepkörök számára engedélyezett a tételek fájlba történő nyomtatása.',
    'admin_email_security' => 'SMTP biztonság',
    'alert_page_will_reload' => 'Az oldal most újratöltődik',
    'file_protection_password' => 'Fájl jelszó megadása',
    'expand' => 'Kibontás',
    'collapse' => 'Elrejtés',
    'settings_ldap_user_attribute' => 'Felhasználói tulajdonság, amiben keresni kell',
    'settings_ldap_user_attribute_tip' => 'LDAP tulajdonság amiben a felhasználó nevet keresni kell',
    'log_user_initial_pwd_changed' => 'Kezdeti jelszó létrehozva',
    'log_user_email_changed' => 'A felhasználó neve megvátozott: ',
    'log_user_created' => 'Felhasználó létrehozva',
    'log_user_locked' => 'Felhasználó zárolva',
    'log_user_unlocked' => 'Felhasználó visszanyitva',
    'log_user_pwd_changed' => 'Felhasználó jelszava megvátlozott',
    'settings_default_session_expiration_time' => 'Alapételmezett munkamenet lejárati ideje',
    'settings_duo' => '"DUO Security" engedélyezése, mint 2-lépéses hitelesítés.',
    'settings_duo_tip' => 'A 2-lépéses hitelesítés megvalósítható a DUOSecurity.com segítségével is. Ennek a könyvtárnak a segítségével garantásható a magas biztonságú felhasználói hitelesítés.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Az Ön fiókjához kapcsolódó Duo Security adminisztrációs oldalához tartozó hitelesítési adatokat kell itt megadni. A beállítások az sk.php fájlba kerülnek elmentésre a mentés gombra kattintáskor.',
    'admin_duo_intro' => 'Töltse ki a következő mezőket a szükséges adatokkal',
    'edit' => 'Szerkesztés',
    'user_info_locked' => 'A felhasználó jelenleg ZÁROLVA van.',
    'user_info_unlock_question' => 'Visszanyitja?',
    'user_info_lock_question' => 'Zárolja?',
    'user_info_delete_question' => 'Törli?',
    'user_info_active' => 'A felhasználó jelenleg ENGEDÉLYEZETT.',
    'refresh' => 'Frissítés',
    'loading' => 'Betöltés',
    'searching' => 'Keresés...',
    'list_items_with_tag' => 'Ezzel a címkével rendelkező tételek listázása',
    'no_item_to_display' => 'Nincs megjelenítendő adat',
    'opening_folder' => 'Mappa átnevezése...',
    'suggestion_notify_subject' => '[Teampass] Az új javaslat létrejött.',
    'suggestion_notify_body' => 'A user has submitted a password item suggestion to the password manager. You need to accept the submission before it can be used by other users.<br>Info:<br>- Label: #tp_label#<br>- Folder: #tp_folder#<br>- User: #tp_user#<br><br>This email has been sent to all managers.',
    'error_unknown' => 'Váratlan hiba történt!',
    'no_edit' => 'Írható, de nem szerkeszthető',
    'role_cannot_edit_item' => 'Nem lehet a tételeket szerkeszteni',
    'no_delete' => 'Írható, de nem törölhető',
    'role_cannot_delete_item' => 'Nem lehet a tételeket törölni',
    'my_profile' => 'Saját profil',
    'starting' => 'Indulás...',
    'total_number_of_items' => 'Tételek száma',
    'finalizing' => 'Befejezés',
    'treating_items' => 'Tételek feldolgozása folyamatban',
    'number_of_items_treated' => 'Feldolgozott tételek száma',
    'error_sent_back' => 'A következő hiba történt',
    'full' => 'Teljes',
    'sequential' => 'Szekvenciális',
    'tree_load_strategy' => 'Fa betöltési mód',
    'syslog_enable' => 'Naplózás a <i>syslog</i> szerverre',
    'syslog_host' => 'Syslog szerver neve, vagy IP címe',
    'syslog_port' => 'Syslog port (alapértelmezetten 514)',
    'error_bad_credentials' => 'Helytelen bejelentkezési adatok!',
    'settings_ldap_usergroup' => 'Kereséshez használt LDAP csoport',
    'settings_ldap_usergroup_tip' => 'Adja meg a könyvtárban szereplő, felhasználói azonosítókat tároló LDAP csoportot. Például: cn=sysadmins,ou=groups,dc=example,dc=com ',
    'server_password_change_enable' => 'Engedélyezi a jelszó módosítását egy távoli szerveren (ssh kapcsolaton keresztül)',
    'update_server_password' => 'Szerver jelszó módosítása',
    'ssh_pwd' => 'SSH jelszó',
    'ssh_user' => 'SSH felhasználó',
    'ssh_password_frequency_change_info' => 'Adja meg az automatikus szerver jelszó frissítés intervallumát (0 - nincs automatikus frissítés).<br>Az automatikus jelszó frissítés csak abban az esetben kerül végrehajtásra, ha a rendszer adminisztrátor elvégezte a a jelszó módosítás ütemezőjének beállítását.',
    'ssh_password_frequency_change' => 'Jelszó módosítás ciklusa (hónapokban)',
    'ssh_scheduled_change' => 'Ütemezett változtatás',
    'ssh_one_shot_change' => 'Egyszeri változtatás',
    'server_password_change_enable_tip' => 'Ez a beállítás lehetővé teszi a hivatkozásban szereplő szerver felhasználói jelszavának automatikus megváltoztatását. Ehhez szükség van arra, hogy a távoli UNIX szerver megengedje a jelszavak módosítását SSH-n keresztül. Az automatikusan ütemezett jelszó módosításhoz be kell állítani a crontab segítségével a <i>/files/script.ssh.php</i> napi egyszeri futtatását a jelszó menedzser szerveren.',
    'error_bad_credentials_more_than_3_times' => 'A megadott bejelentkezési adatok helytelenek!<br>Várjon 10 másodpercet az ismételt próbálkozás előtt.',
    'settings_ldap_object_class' => 'Osztály keresése',
    'settings_ldap_object_class_tip' => 'LDAP osztály keresése, úgymint felhasználói, vagy POSIX fiók',
    'rebuild_config_file' => 'Konfigurációs fájl újragenerálása',
    'rebuild_config_file_tip' => 'A konfigurációs fájl tartalmazza a rendszer változókat és az adatbázis kapcsolat létrehozását megelőzően is innen kerülnek beolvasásra a kapcsolat beállításai. A konfigurációs fájl újraépítése elmenti az adatbázisban lévő paramétereket egy fájlba. Ez bármikor megtehető. A fájl alapértelmezett helye ./includes/config/tp.config.php, de biztonsági okokból célszerű a www könyvtáron kívül elhelyezni.',
    'error_folder_complexity_lower_than_top_folder' => 'Az almappák jelszó erősségének azonosnak, vagy magasabb szintűnek kell lennie, mint a szülő mappa.',
    'new_item_email_body' => 'Helló, <br /><br />A(z) &apos;#label&apos; tétel létrehozsra került a Teampass-ban.<br />A megtekintéséhez kattintson <a href="#link#">IDE</a>.<br/><br />Üdvözlettel.',
    'failed_logins' => 'Sikertelen belépések',
    'error_only_numbers_in_folder_name' => 'A mappa neve nem lehet csak egy szám. Adjon meg olyan nevet, ami tartalmaz betűket is.',
    'encrypted_data' => 'Az adatbázis adatai titkosítottak',
    'settings_ldap_port' => 'LDAP port',
    'user_profile_agses_card_id' => 'Az Ön Agses kártyaszáma',
    'ga_flash_qr_and_login' => 'Flash this QR code with your mobile device, enter the 2Factor Authentication code and click `Enter` button.',
    'i_need_to_generate_new_ga_code' => 'I need a new QR code. Please send me by email a temporary Identication Code.',
    'settings_manager_move_item' => 'Managers can move any items they can view',
    'user_folders_rights' => 'Visible folders',
    'create_item_without_password' => 'Allow item to be created without any password defined',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Source user',
    'share_rights_destination' => 'Destination users',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Move selected Items',
    'delete_items' => 'Delete selected Items',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'suggest_password_change' => 'Suggest a password change',
    'otv_is_enabled' => 'User can propose One-Time-View links',
    'error_source_and_destination_are_equal' => 'Source and Destination cannot be the same!',
    'sending_anonymous_statistics' => 'Sending anonymous statistics',
    'favourites_option_enabled' => 'Favourites option enabled',
    'personalfolders_option_enabled' => 'Personal Folders option enabled',
    'country_statistics' => 'Worldmap usage',
    'country' => 'Country',
    'users_statistics' => 'Average number of users by instance',
    'items_all' => 'All items',
    'folders_all' => 'All folders',
    'items_shared' => 'All shared items (not including personal ones)',
    'folders_shared' => 'All shared folders (not including personal ones)',
    'items_statistics' => 'Average number of items by instance',
    'folders_statistics' => 'Average number of folders by instance',
    'administrators_number' => 'Number of Administrator users',
    'administrators_number_statistics' => 'Average number of Administrators by instance',
    'managers_number' => 'Number of Manager users',
    'managers_number_statistics' => 'Average number of Managers by instance',
    'readonly_number_statistics' => 'Average number of Read-Only users by instance',
    'readonly_number' => 'Number of Read-Only users',
    'mysql_version' => 'MySQL version',
    'php_version' => 'PHP version',
    'teampass_version' => 'Teampass version',
    'languages_used' => 'Languages used',
    'languages_statistics' => 'Most used language',
    'kb_option_enabled' => 'Knowledge Base option enabled',
    'suggestion_option_enabled' => 'Suggestion option enabled',
    'customfields_option_enabled' => 'Custom fields option enabled',
    'api_option_enabled' => 'API option enabled',
    '2fa_option_enabled' => '2FAoption enabled',
    'agses_option_enabled' => 'AGSES option enabled',
    'duo_option_enabled' => 'DUO Security option enabled',
    'ldap_option_enabled' => 'LDAP option enabled',
    'syslog_option_enabled' => 'SYSLOG option enabled',
    'stricthttps_option_enabled' => 'Strict HTTPS option enabled',
    'characteristic' => 'Characteristic',
    'current_value' => 'Current value',
    'communication_means' => 'Communication means',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'More information',
    'feature_request_canal' => 'For Feature Requests, please use',
    'bug_canal' => 'For Bugs, please use',
    'documentation_canal' => 'Complete documentation at',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'This Item has a change proposal',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revert?',
    'revert_the_database' => 'You have decided to revert the database. Please confirm?',
    'bad_psk' => 'This personal Saltkey is not correct!',
    'ldap_test_config' => 'Test current configuration',
    'ldap_test_username' => 'Username to use for testing purpose',
    'ldap_test_username_pwd' => 'Username password',
    'feature_support_canal' => 'For Support and Help, please use',
    'category' => 'Category',
    'text' => 'Text',
    'type' => 'Type',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',
    'generate_new_keys' => 'Generate new keys',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown.',
    'generate_new_keys_end' => 'Process is on going in background and could take several minutes. You can now close this window.',
    'confirm_password' => 'We need you to confirm your password',
    'no_code_is_requested' => 'No code is requested.',
    'user_encryption_ongoing' => 'Account is currently being encrypting. Your request cannot continue. Please wait until this is finished.',
    'teampass_information' => 'Teampass information',
    'show_password' => 'Show password',
    'new_user_info_by_mail' => 'New user will receive an email with his credentials',
    'login_credentials' => 'Login credentials',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following password is expected next time using Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Your Teampass account is fully ready.<br><br>Cheers',
    'email_body_user_config_5' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Following code is expected next time using Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Data is not valid',
    'mfa_enabled' => 'MFA enabled',
    'mfa_disabled_for_user' => 'MFA disabled for user',

);
