<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @file      dutch.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your AD credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your AD since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Standaard niet beveiligde LDAP poort: 389 Standaard beveiligde LDAP poort: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Selecteer alles',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Logs',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'definitie',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn&apos;t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Bevestig alstublieft',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Rollen',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Label',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Klik om de Teampass website te openen',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Selecteer profiel foto (PNG bestand)',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Kopieer map',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Gebruikers',
    'folders' => 'Mappen',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objecten gevonden',
    'auto_update_server_password_info' => 'Klik op START en de volgende stappen zullen automatisch uitgevoerd worden:<ul><li>Verbinding maken via SSH</l',
    'share' => 'Deel dit item',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'U moet een map selecteren',
    'email_subject_item_updated' => 'Uw wachtwoord is veranderd',
    'email_body_item_updated' => 'Hallo,<br><br>Wachtwoord voor &apos;#item_label#&apos; Is gewijzigd.<br /><br />U kunt het<a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">HIER</a><br /><br />bekijken.',
    'import_kp_finished' => 'Import van KeePass is klaar! <br /> De standard moeilijkheid`s graad van nieuwe mappen is gezet op medium. Wellicht dat je dit weer wilt veranderen.',
    'password_is_empty' => 'Item heeft geen wachtwoord',
    'bug_report_to_github' => 'Vul de inhoud aan van de rapportage, kopieer het naar het klembord en plak het in de nieuwe issue pagina van Github',
    'open_bug_report_in_github' => 'Open issue rapportage in Github',
    'bugs_page' => 'Als je een bug ontdekt, meldt deze alstublieft.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Stel "iedereen met dezelfde rol kan dit aanpassen" in op alle geïmporteerde onderdelen.',
    'import_csv_anyone_can_modify_txt' => 'Stel "iedereen kan dit aanpassen" in op alle geïmporteerde onderdelen.',
    'settings_upload_imageresize_options' => 'Moeten afbeeldingen worden verschaald',
    'user_not_exists' => 'Deze gebruiker bestaat niet!',
    'auto_create_folder_role' => 'Creëer map en rol voor ',
    'start_upload' => 'Start met uploaden van bestanden',
    'error_upload_runtime_not_found' => 'Upload feature: Geen runtime gevonden.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Uw wachtwoord wijzigen',
    'admin_2factors_authentication_setting' => 'Activeer Google 2-Factor authenticatie',
    'admin_2factors_authentication_setting_tip' => '<span style="font-size:11px;max-width:300px;">Google 2-Factor authenticatie Staat toe nog een beveiliging`s laag toe te voegen voor gebruiker authenticatie. Wanneer een gebruiker wil inloggen in Teampass word er een QR code gegenereerd. Deze code moet gescand worden door de gebruiker om een eenmalige wachtwoord te krijgen.<br /> WAARSCHUWING: Deze manier van inloggen heeft een smartphone en een iternet connectie nodig </span> ',
    'admin_ga_website_name' => 'Naam weergegeven in Google Authenticator voor Teampass',
    'admin_ga_website_name_tip' => 'Deze naam is gebruikt voor de identificatie code gebruikt in Google Authenticator',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[Teampass] Een item is met u gedeeld',
    'email_share_item_mail' => 'Hallo,<br><br><u>#tp_user#</u> heeft een item met u gedeeld <b>#tp_item#</b><br>Klik de<a href="#tp_link#">LINK</a> om deze te bekijken.<br><br>Vriendelijke groet.',
    'index_maintenance_mode_admin' => 'Onderhoudsmode aan, gebruikers kunnen momenteel niet inloggen.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'E-mail Google Authenticatie naar gebruiker',
    'error_no_email' => 'Gebruiker heeft geen e-mailadres ingesteld',
    'error_no_user' => 'Gebruiker niet gevonden!',
    'email_ga_subject' => 'Uw One-Time Google Authenticatie code voor Teampass',
    'email_ga_text' => 'Hallo,<br><br>Dit is een automatisch gegenereerde e-mail van de Teampass wachtwoord manager.<br><br>Uw beheerder verwacht dat u Two-Factor authenticatie gebruikt om te in te loggen aan Teampass.<br>Voor de eerste inlog met Two-Factor authenticatie gebruikt u de code die u hieronder in het :"Identificatie code" veld vind:<br><br>----------------------<br>#2FACode#<br>----------------------<br><br>Hierna zal u de gelegenheid gesteld worden om uw One-Time gegevens voor Teampass in te stellen.<br><br>Groeten',
    'settings_attachments_encryption' => 'Versleutel bestandsbijlagen',
    'settings_attachments_encryption_tip' => 'Deze optie kan huidige bijlagen kapot maken, lees de volgende tekst aandachtig door. Als uw bijlage aanstaan, dan zijn deze op de server opgeslagen met encryptie. Deze encryptie gebruikt salt gedefineerd voor Teampass. dit benodigd meer server capaciteit. WAARSCHUWING: Wanneer u van strategie veranderd is het verplicht om het script te draaien dat de bestaande bijlagen aanpast. zie tabblad &apos;specifieke acties&apos;.',
    'admin_action_attachments_cryption' => 'Versleutel of ontsleutel alle bestandsbijlagen',
    'admin_action_attachments_cryption_tip' => 'Waarschuwing: Deze actie alleen uitvoeren na het veranderen van de associatie optie in de Teampass instellingen. Maak een kopie van uw &apos;upload&apos; map alvorens een optie uit te voeren.',
    'encrypt' => 'Versleutelen',
    'decrypt' => 'Ontsleutelen',
    'ga_identification_code' => 'Identificatiecode',
    'ga_enter_credentials' => 'U dient uw login gegevens in te voeren.',
    'ga_bad_code' => 'De Google Authenticator code is onjuist',
    'settings_get_tp_info' => 'Laat software-nieuws en informatie aan admins zien',
    'settings_get_tp_info_tip' => 'Deze optie laat de administratie pagina toe on informatie te laten zien zoals versies en gegevens gebruikt van uw Teampass server',
    'settings_offline_mode' => 'Activeer Off-Line modus',
    'settings_offline_mode_tip' => 'Off-Line modus exporteert de items in een HTML bestand. De items in deze pagina zijn versleuteld met een sleutel opgegeven bij de gebruiker. ',
    'offline_mode_key_level' => 'minimum sterkte versleutel wachtwoord',
    'categories' => 'Categorieën',
    'no_category_defined' => 'Geen Categorie gedefineerd',
    'confirm_deletion' => 'Weet u zeker dat u wilt verwijderen?',
    'settings_item_extra_fields' => 'machtig items om te worden uitgebreid met meer velden (op categorie)',
    'settings_item_extra_fields_tip' => 'Deze functie staat toe om de item definitie uit te breiden met extra velden die de administrator kan definiëren en organiseren op categorie.  Alle gegevens zijn versleuteld. Deze functie gebruikt wel mer SQL queries (ongeveer 5 maal meer per veld gedurende een item update) en kan meer tijd in beslag nemen om te worden uitgevoerd. Dit hangt af van uw server.',
    'settings_ldap_type' => 'LDAP server type',
    'server_time' => 'Servertijd',
    'settings_tree_counters' => 'Laat meer tellers zien in mappenstructuur.',
    'settings_tree_counters_tip' => 'Deze optie laat voor elke map 3 tellers zien: het aantal items in een map, aantal items in alle submappen, aantal submappen. Deze functie gebruikt meer SQL query&apos;s en kan voor vertraging zorgen bij het weergeven.',
    'admin_action_check_pf' => 'Creeër persoonlijke mappen voor alle gebruikers waarbij deze nog niet bestaat',
    'enable_personal_folder_feature_tip' => 'Eenmaal geactiveerd, zult u handmatig dit bestand moeten uitvoeren dat persoonlijke folders aanmaakt voor bestaande gebruikers. Dit zal alleen persoonlijke mappen aanmaken voor gebruikers die ze niet hebben. het bestand &apos;".$txt[&apos;admin_action_check_pf&apos;]."&apos; is beschikbaar in  &apos;".$txt[&apos;admin_actions_title&apos;]."&apos;',
    'administrators_only' => 'Alleen beheerders',
    'managers_of' => 'Manager van rol',
    'managed_by' => 'Beheerd door',
    'settings_enable_sts' => 'Forceer HTTPS Strict Transport Security. <strong>Waarschuwing</strong>: lees tooltip!',
    'settings_enable_sts_tip' => 'Dit forceert HTTPS STS. STS helpt bij het tegengaan van SSL man-in-the-middle aanvallen. Je MOET een geldig SSL certificaat hebben om deze functie te gebruiken. Als je een self-signed certificaat hebt, mag je deze optie niet aanzetten',
    'settings_anyone_can_modify_bydefault' => 'Activeer de &apos;<b><i>Iedereen kan aanpassen</b></i>&apos; optie (standaard)',
    'to' => 'naar',
    'settings_upload_maxfilesize_tip' => 'De maximale grootte van het bestand om te uploaden. Dit moet gelijk zijn aan de instellingen van de server.',
    'settings_upload_docext_tip' => 'Documenttypes. Voer bestandsextensies toe die worden toegestaan gescheiden door een komma (,)',
    'settings_upload_imagesext_tip' => 'Afbeeldingstypes. Voer bestandsextensies toe die worden toegestaan gescheiden door een komma (,)',
    'settings_upload_pkgext_tip' => 'Gecomprimeerde bestandstypes. Voer bestandsextensies toe die worden toegestaan gescheiden door een komma (,)',
    'settings_upload_otherext_tip' => 'Overige types. Voer bestandsextensies toe die worden toegestaan gescheiden met een komma (,)',
    'settings_upload_imageresize_options_tip' => 'Wanneer deze optie is geactiveerd, zullen afbeeldingen worden verschaald naar de onderstaande instellingen',
    'settings_upload_maxfilesize' => 'Maximale bestandsgrootte (in Mb)',
    'settings_upload_docext' => 'Toegestane documentsformaten',
    'settings_upload_imagesext' => 'Toegestane afbeeldingsformaten',
    'settings_upload_pkgext' => 'Toegestane comprimeerde bestandsformaten',
    'settings_upload_otherext' => 'Toegestane overige formaten',
    'settings_upload_imageresize_options_w' => 'Breedte van geschaalde afbeeldingen (in pixels)',
    'settings_upload_imageresize_options_h' => 'Hoogte van geschaalde afbeeldingen (in pixels)',
    'settings_upload_imageresize_options_q' => 'Kwaliteit van geschaalde afbeeldingen',
    'settings_importing' => 'Activeer importeren van data van CVS/KeePass bestanden',
    'admin_proxy_ip' => 'IP adres van Proxy server',
    'admin_proxy_ip_tip' => 'en<span style="font-size:11px;max-width:300px;">Als u een proxy server wilt gebruiken, specificeer dan hier het IP adres.<br />Laat dit veld leeg als u geen proxy heeft.</span>',
    'admin_proxy_port' => 'Poortnummer van de Proxy server',
    'admin_proxy_port_tip' => '<span style="font-size:11px;max-width:300px;">Als u een proxy server wilt gebruiken, specificeer dan hier het poor nummer. Dit kan bijvoorbeeld 8080 zijn.<br />Laat dit veld leeg als u geen proxy heeft.</span>',
    'settings_ldap_elusers' => 'Alleen lokale Teampass gebruikers',
    'settings_ldap_elusers_tip' => 'Deze functie laat gebruikers in uw database gebruik maken van een LDAP server. Zet dit uit als u elke LDAP wilt kunnen gebruiken? (wazige vertaling).',
    'db_items_edited' => 'Items die daadwerkelijk worden bewerkt',
    'item_edition_start_hour' => 'Bewerking bezig sinds',
    'settings_delay_for_item_edition' => 'Na hoelang bewerken van een item moet het als mislukt worden beschouwd (in minuten)',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Wanneer u een item bewerkt word het item opslot gezet zodat niemand anders het tegelijk kan bewerken. Hiervoor word een token aangemaakt.<br />Deze optie laat u toe deze token te verwijderen. Als de waarde 0 is word deze nooit verwijderd ( tenzij door en administrator)</span>',
    'db_users_logged' => 'Gebruikers die in gelogged zijn',
    'action' => 'Actie',
    'login_time' => 'Ingelogd sinds',
    'lastname' => 'Achternaam',
    'user_login' => 'Login',
    'role' => 'Functie',
    'error_role_exist' => 'Deze functie bestaat al!',
    'error_no_edition_possible_locked' => 'U kunt dit item niet veranderen, Het item is al recentelijk bewerkt',
    'select' => 'selecteren',
    'items' => 'Items',
    'enable_personal_saltkey_cookie' => 'Activeer persoonlijke salt key opslag in browser cookie',
    'personal_saltkey_cookie_duration' => 'Persoonlijke salt key maximale leeftijd in dagen',
    'admin_email_smtp_server' => 'SMTP server',
    'admin_email_auth' => 'Uw SMTP server heeft authenticatie nodig',
    'admin_email_auth_username' => 'Authenticatie gebruikersnaam',
    'admin_email_auth_pwd' => 'Authenticatie wachtwoord',
    'admin_email_port' => 'Server Poort',
    'admin_email_from' => 'Afzender adres',
    'admin_email_from_name' => 'Afzender naam',
    'admin_email_test_configuration_tip' => 'Deze test zou een e-mail moeten sturen naar het adres dat is vermeld. Als u dit niet ontvangt controleer dan uw gebruikersnaam en wachtwoord.',
    'admin_email_test_subject' => 'Test e-mail van beheerder',
    'admin_email_test_body' => 'Dit is een test e-mail om de configuratie van de server te controleren. Als je dit leest is alles goed gegaan!',
    'admin_email_result_ok' => 'Een e-mail is verstuurd naar  #email# ... controleer uw postvak in.',
    'email_bodyalt_item_updated' => 'Wachtwoord voor #item_label# is aangepast.',
    'admin_email_send_backlog_tip' => 'Dit bestand laat het toe alle e-mails in de database te worden verzonden. <br /> dit kan even duren afhankelijk van het aantal e-mails dat moet worden verzonden.',
    'please_wait' => 'Even geduld aub',
    'admin_path_to_files_folder' => 'Pad nar bestanden in mappern',
    'admin_path_to_files_folder_tip' => '<span style="font-size:11px;max-width:300px;">De bestanden map is gebruikt om alle gegenereerde bestanden door Teampass en andere geuploade bestanden op te slaan.<br />BELANGRIJK: Voor veiligheid`s redenen moet deze map niet in uw websites WWW map zitten. Deze zou u het beste in een beveiligde omgeving kunnen opslaan met een omleiding`s regel in uw server configuratie.<br />BELANGRIJK 2:Het kan handig zijn om deze folder regelmatig te laten legen met een CRON taak.</span>',
    'admin_path_to_upload_folder_tip' => '"<span style="font-size:11px;max-width:300px;">De bestanden map is gebruikt om alle geuploade bestanden voor items op te slaan<br />BELANGRIJK: Voor veiligheid`s redenen moet deze map niet in uw websites WWW map zitten. Deze zou u het beste in een beveiligde omgeving kunnen opslaan met een omleiding`s regel in uw server configuratie.<br />BELANGRIJK 2:Deze map moet nooit worden leeg gemaakt! deze bestanden zijn gekoppeld aan items.</span>"',
    'pdf_password_warning' => 'U moet een encryptiesleutel opgeven',
    'admin_pwd_maximum_length' => 'Maximale lengte voor wachtwoorden',
    'admin_pwd_maximum_length_tip' => 'De standaard waarde voor wachtwoord lengte is gezet op 40 Het is belangrijk om te weten dat een hogere waarde voor deze instelling invloed kan hebben op de prestaties van uw server om wachtwoorden te versleutelen, ontsleutelen en weer te geven.',
    'settings_insert_manual_entry_item_history' => 'Activeer manuele input in de historie item log.',
    'settings_insert_manual_entry_item_history_tip' => 'Voor sommige redenen u kan u het nodig vinden om een manuele toevoeging te doen aan de historie of een item. Door deze optie te activeren is dit mogelijk.',
    'admin_path_to_upload_folder' => 'Pad naar upload map',
    'admin_setting_enable_delete_after_consultation' => 'Geraadpleegde item kan automatisch worden verwijderd',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Wanneer geactiveerd, de item maker kan besluiten dat een item automatisch word verwijderd nadat het een aantal maal is bekeke',
    'at_email' => 'e-mail',
    'enable_email_notification_on_item_shown' => 'Stuur een bericht wanneer een item is weergegeven',
    'share_sent_ok' => 'Een e-mail is verstuurd',
    'see_item_title' => 'Item details',
    'email_on_open_notification_subject' => '[Teampass] Notificate item is geopend',
    'email_on_open_notification_mail' => 'Hallo,<br><br>#tp_user# Heeft het volgende item geopend en bekeken: &apos;#tp_item#&apos;.<br>Klik de <a href="#tp_link#">LINK</a>Om te bekijken<br><br>Vriendelijke groet.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[Teampass] Uw account creatie',
    'email_new_user_mail' => 'Hallo,<br><br>Een administrator heeft een account voor u gemaakt op Teampass.<br>U kunt de volgende gegevens gebruiken om in te loggen:<br>- Login: #tp_login#<br>- wachtwoord: #tp_pw#<br><br>Klik de <a href="#tp_link#">LINK</a> om naar de site te gaan.<br><br>Vriendelijke groet.',
    'error_empty_data' => 'Geen data om verder te kunnen!',
    'error_not_allowed_to' => 'U mag dit niet doen! ',
    'request_access_ot_item' => 'Vraag toegang om te mogen bewerken',
    'email_request_access_subject' => '[Teampass] Vraag toestemming om een item te kunnen zien',
    'email_request_access_mail' => 'Hallo #tp_item_author#,<br><br>Gebruiker #tp_user# vraagt om toegang tot &apos;#tp_item#&apos;.<br><br>Wees er zeker van dat u deze rechten wil verlenen aan de gebruiker voor dat u de rechten van het bestand veranderd.<br><br>Vriendelijke groet.',
    'admin_action_change_salt_key' => 'Verander de hoofd salt key',
    'nb_items_by_query' => 'Aantal onderdelen dat geladen moet worden',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Hoe langer de lijst van items, hoe langer het duurt om de lijst te laden.<br />Kies &apos;auto&apos; om de tool zelf te laten kiezen hoeveel items getoond worden, afhankelijk van de scherm grootte van de gebruiker<br />Kies &apos;max&apos; om de hele lijst van items te tonen.<br />Kies het aantal items dat telkens getoond moet worden</span>',
    'open_url_link' => 'Open in een nieuwe pagina',
    'error_pw_too_long' => 'Het wachtwoord is te lang, het maximum is 40 karakters.',
    'at_restriction' => 'Beperking',
    'pw_encryption_error' => 'Het versleutelen van het wachtwoord is fout gegaan.',
    'enable_send_email_on_user_login' => 'Stuur een e-mail naar de beheerders als de gebruiker aanmeld',
    'email_subject_on_user_login' => '[TeamPass] Een gebruiker is aangemeld',
    'email_body_on_user_login' => 'Gebruiker #tp_user# is aangemeld bij TeamPass op #tp_date# at #tp_time#. <br><br>Dit is een normaal bericht als de optie <i>E-mail administrators bij login</i> is ingeschakeld.',
    'account_is_locked' => 'Dit account is geblokkeerd',
    'activity' => 'Activiteit',
    'add_role_tip' => 'Nieuwe rol toevoegen',
    'admin' => 'Informatie',
    'admin_action_db_backup' => 'Backup de database',
    'admin_action_db_clean_items' => 'Schoon de database op (Deze actie verwijderd verweesde items)',
    'admin_action_db_clean_items_tip' => 'Hiermee worden de items en logging verwijderd die achtergebleven zijn nadat een map verwijderd is. Het is raadzaam eerst een backup te maken. ',
    'admin_action_db_optimize' => 'Database optimaliseren',
    'admin_action_db_restore' => 'Database herstellen',
    'admin_action_purge_old_files' => 'Verwijder oude bestanden',
    'admin_action_purge_old_files_tip' => 'Hiermee verwijderd u alle tijdelijke bestanden die ouder zijn dan 7 dagen.',
    'admin_action_reload_cache_table' => 'Cache tabel laden',
    'admin_action_reload_cache_table_tip' => 'test',
    'admin_help' => 'Help',
    'admin_ldap_configuration' => 'LDAP configuratie',
    'admin_main' => 'Informatie',
    'admin_misc_cpassman_dir' => 'Volledige pad naar TeamPass',
    'admin_misc_cpassman_url' => 'Volledige URL naar TeamPass',
    'admin_misc_custom_login_text' => 'Wijzig aanmeld tekst',
    'admin_misc_custom_logo' => 'Volledige URL naar eigen logo',
    'admin_misc_favicon' => 'Volledige URL naar favicon bestand',
    'admin_settings' => 'Instellingen',
    'admin_settings_title' => 'TeamPass Instellingen',
    'admin_setting_activate_expiration' => 'Verlopen van wachtwoord toestaan',
    'admin_setting_activate_expiration_tip' => 'Wanneer dit is geactiveerd, zullen items niet worden weergegeven aan gebruikers.',
    'admin_views' => 'Log bestanden',
    'alert_message_done' => 'Klaar!',
    'all' => 'alles',
    'anyone_can_modify' => 'Dit item mag aangepast worden door iedereen die toegang heeft',
    'at' => 'op',
    'at_category' => 'map',
    'at_copy' => 'kopie gemaakt',
    'at_delete' => 'Verwijderd',
    'at_description' => 'Omschrijving.',
    'at_label' => 'Label',
    'at_login' => 'Aanmelden',
    'at_moved' => 'Verplaatst',
    'at_personnel' => 'Persoonlijk',
    'at_restored' => 'Herstelt',
    'at_shown' => 'Geopend',
    'at_url' => 'URL',
    'author' => 'Auteur',
    'authorized_groups' => 'Toegestane mappen',
    'auth_creation_without_complexity' => 'Sta toe dat een item wordt aangemaakt waarbij geen rekening gehouden wordt met de aangewezen wachtwoord complexiteit',
    'auth_modification_without_complexity' => 'Sta toe dat items worden aangepast zonder rekening te houden met de aangegeven wachtwoord complexiteit',
    'cancel' => 'Annuleren',
    'can_create_root_folder' => 'Mag mappen aanmaken op het hoofd niveau',
    'changelog' => 'Recente software updates',
    'close' => 'Sluiten',
    'complexity' => 'Complexiteit',
    'complex_asked' => 'Minimale complexiteit',
    'complex_level0' => 'Zeer zwak',
    'complex_level1' => 'Zwak',
    'complex_level2' => 'Medium',
    'complex_level3' => 'Sterk',
    'complex_level4' => 'Zeer sterk',
    'complex_level5' => 'Zwaar',
    'complex_level6' => 'Zeer zwaar',
    'confirm' => 'Bevestigen',
    'confirm_del_from_fav' => 'Bevestig verwijdering van uit uw favorieten:',
    'connections' => 'Verbindingen',
    'copy' => 'Kopiëren ',
    'copy_to_clipboard_small_icons' => 'Sta kopiëren icoontjes toe in het item pagina',
    'copy_to_clipboard_small_icons_tip' => '<span style="font-size:11px;max-width:300px;">Dit kan helpen om geheugen gebruik te beperken indien de gebruiker niet beschikt over een recente computer.<br /> Inderdaad, de items worden niet geladen in de clipbord. Maar dan werken snel copieren van paswoorden en login niet.</spa',
    'date' => 'Datum',
    'date_format' => 'Datum formaat',
    'delete' => 'Verwijderen',
    'deletion' => 'Verwijderde items',
    'del_button' => 'Verwijder',
    'description' => 'Omschrijving',
    'disconnect' => 'Afmelden',
    'done' => 'Klaar',
    'duplicate_folder' => 'Sta toe dat meerdere mappen met dezelfde naam mogen voorkomen',
    'duplicate_item' => 'Sta toe dat meerdere onderdelen met dezelfde naam mogen voorkomen',
    'email' => 'E-mail',
    'email_subject' => 'Een nieuw onderdeel toevoegen aan de Wachtwoord Manager',
    'enable_favourites' => 'Sta toe dat gebruikers favorieten gebruiken',
    'enable_personal_folder' => 'Persoonlijke map inschakelen',
    'enable_personal_folder_feature' => 'Persoonlijke mappen inschakelen',
    'enable_user_can_create_folders' => 'Sta toe dat gebruikers mappen beheren in bovenliggende mappen',
    'encrypt_key' => 'Encryptiesleutel',
    'errors' => 'foutmeldingen',
    'error_group_exist' => 'Deze map bestaat al!',
    'error_html_codes' => 'Sommige tekst bevat HTML code, dit is niet toegestaan.',
    'error_item_exists' => 'Dit onderdeel bestaat al!',
    'error_label' => 'Een label is verplicht!',
    'error_must_enter_all_fields' => 'Alle velden moeten worden ingevuld!',
    'error_pw' => 'Een wachtwoord is verplicht!',
    'error_tags' => 'Interpunctie is niet toegestaan in TAGS! Alleen spaties.',
    'error_user_exists' => 'Gebruiker bestaat al',
    'expiration_date' => 'Verloop datum',
    'find' => 'Zoeken',
    'forbidden_groups' => 'Verboden mappen',
    'forgot_my_pw_email_sent' => 'De e-mail is verstuurd',
    'functions' => 'Rollen',
    'gestionnaire' => 'Manager',
    'god' => 'GOD',
    'group' => 'Map',
    'group_parent' => 'Hoofdmap',
    'group_pw_duration' => 'Vernieuwing periode',
    'group_pw_duration_tip' => 'In maanden. Gebruik 0 om uit te schakelen.',
    'history' => 'Geschiedenis',
    'home_personal_saltkey' => 'Uw persoonlijke salt key',
    'home_personal_saltkey_label' => 'Voer uw persoonlijke salt key in',
    'import_error_no_read_possible' => 'Kan het bestand niet lezen!',
    'import_error_no_read_possible_kp' => 'Kan het bestand niet lezen, het moet een KeePass bestand zijn.',
    'import_keepass_to_folder' => 'Selecteer een eindbestemming',
    'index_add_one_hour' => 'Sessie verlengen',
    'index_change_pw_confirmation' => 'Bevestigen',
    'index_expiration_in' => 'Sessie verloopt over',
    'index_get_identified' => 'Aanmelden alstublieft',
    'index_last_pw_change' => 'Wachtwoord gewijzigd op',
    'index_last_seen' => 'Laatste connectie op',
    'index_login' => 'Account',
    'index_new_pw' => 'Nieuw wachtwoord',
    'index_password' => 'Wachtwoord',
    'index_pw_error_identical' => 'De wachtwoorden komen niet overeen!',
    'index_pw_level_txt' => 'Complexiteit',
    'index_session_duration' => 'Sessie duur',
    'info' => 'Informatie',
    'item_menu_copy_login' => 'kopieer gebruikersnaam',
    'item_menu_copy_pw' => 'kopieer wachtwoord',
    'item_menu_del_from_fav' => 'Uit favorieten verwijderen',
    'kbs' => 'KBs',
    'kb_menu' => 'Knowledge Base',
    'last_items_title' => 'Laatst bekeken onderdelen',
    'ldap_extension_not_loaded' => 'De LDAP extensie is op deze server niet geactiveerd.',
    'level' => 'Level',
    'login' => 'Gebruikersnaam',
    'mask_pw' => 'Wachtwoord tonen/verbergen',
    'max_last_items' => 'Aantal laatst bekeken onderdelen weergeven (standaard is dit 10)',
    'minutes' => 'minuten',
    'name' => 'Naam',
    'nb_false_login_attempts' => 'Aantal foutieve login pogingen voordat het account wordt gelocked (0 om uit te schakelen)',
    'nb_folders' => 'Aantal mappen',
    'nb_items' => 'Aantal Onderdelen',
    'new_label' => 'Nieuw label',
    'no' => 'Nee',
    'none' => 'Geen',
    'none_selected_text' => 'Niks geselecteerd',
    'not_allowed_to_see_pw' => 'U mag dit onderdeel niet bekijken!',
    'not_allowed_to_see_pw_is_expired' => 'Dit onderdeel is verlopen!',
    'not_defined' => 'niet gedefinieerd',
    'number_of_used_pw' => 'Aantal reeds gebruikte wachtwoorden onthouden om hergebruik te voorkomen (0 om uit te schakelen)',
    'pages' => 'Pagina&apos;s',
    'pdf_download' => 'Bestand downloaden',
    'personal_salt_key' => 'Uw persoonlijke salt key',
    'pw' => 'Wachtwoord',
    'pw_generate' => 'Genereer',
    'pw_is_expired_-_update_it' => 'Het wachtwoord van dit onderdeel is verlopen, u moet het veranderen!',
    'pw_life_duration' => 'Wachtwoorden verlopen na xx dagen (0 om uit te schakelen) ',
    'readme_open' => 'Open het readme bestand',
    'read_only_account' => 'Alleen lezen',
    'restore' => 'Herstellen',
    'restricted_to' => 'Beperkt tot',
    'restricted_to_roles' => 'Sta toe om items te beperken tot Users en Roles',
    'root' => 'Root',
    'secure' => 'Beveilig',
    'see_logs' => 'Logs bekijken',
    'settings_anyone_can_modify' => 'Activeer deze optie om toe te staan dat iedereen elk onderdeel mag aanpassen',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">Wanneer geactiveerd, wordt er een checkbox toegevoegd in het item formulier. Dit geeft de eigenaar de mogelijkheid om iedereen toe te laten dit item te aan te passen .</span> ',
    'settings_default_language' => 'Stel de standaard taal in',
    'settings_kb' => 'Knowledge Base activeren',
    'settings_kb_tip' => 'Door dit aan te zetten wordt er een pagina toegevoegd waar u uw knowledge base kan opzetten.',
    'settings_ldap_domain' => 'LDAP account voorzetsel voor het domein',
    'settings_ldap_domain_controler' => 'Komma gescheiden lijst van domein controllers',
    'settings_ldap_domain_controler_tip' => 'Specificeer meerdere domein controllers om de LDAP queries tussen verschillende servers te verdelen. De lijst moet komma gescheiden zijn ( , ). Bijvoorbeeld: domein_1,domein_2,domein_3',
    'settings_ldap_domain_dn' => 'LDAP base dn voor het domein',
    'settings_ldap_mode' => 'Gebruikers authenticatie d.m.v LDAP server aanzetten',
    'settings_ldap_mode_tip' => 'Alleen aanzetten als u een LDAP server heeft en u hier gebruikt van wilt maken in combinatie met Teampass',
    'settings_ldap_ssl' => 'LDAP over SSL (LDAPS)',
    'settings_ldap_tls' => 'LDAP over TLS',
    'settings_log_accessed' => 'Log gebruikerstoegang op onderdelen',
    'settings_log_connections' => 'Alle gebruikers aanmeldingen naar database wegschrijven.',
    'settings_maintenance_mode' => 'Zet TeamPass in Onderhoudsmodus',
    'settings_manager_edit' => 'Managers morgen de items die ze kunnen zien bewerken en verwijderen ',
    'settings_printing' => 'Printen van onderdelen naar PDF aanzetten',
    'settings_printing_tip' => 'Wanneer aangezet, zal er een knop op de gebruiker zijn home page gezet worden waarmee hij/zij een lijst van onderdelen naar een pdf kan schrijven. LET OP, de wachtwoorden in de lijst zijn dan niet versleuteld.',
    'settings_restricted_to' => 'Activeer beperkte functionaliteiten op items',
    'settings_show_description' => 'Laat beschrijving zijn in onderdelen lijst',
    'size' => 'Grootte',
    'tags' => 'Tags',
    'timezone_selection' => 'Selecteer tijdzone',
    'time_format' => 'tijdformaat',
    'url' => 'URL',
    'user' => 'Gebruiker',
    'users_online' => 'Gebruikers online',
    'user_alarm_no_function' => 'Deze gebruiker heeft nog geen rol!',
    'yes' => 'Ja',
    'one_time_view_item_url_box' => 'Deel deze Eenmalige-URL met een persoon die u kunt vertrouwen <br> <br>#URL#<br><br> Onthoud dat deze alleen eenmaal zichtbaat is tot #DAY#',
    'settings_api' => 'Sta toegang tot Teampass toe via de API',
    'settings_api_tip' => 'API toegang laat het toe items te bekijken met een app of programma van een andere maker in JSON formaat.',
    'settings_api_keys_list' => 'Lijst met sleutels',
    'settings_api_keys_list_tip' => 'Dit zijn de sleutels die toegang verschaffen naar Teampass. Zonder geldige sleutel is er geen toegang mogelijk. Deel deze sleutels met de nodige omzichtigheid!',
    'settings_api_key' => 'Sleutel',
    'settings_api_add_ip' => 'Voeg nieuw IP-adres toe',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'nieuwe secondaire map erft de rechten van bovenliggende map',
    'subfolder_rights_as_parent_tip' => 'Wanneer deze functionailteit gedeactiveerd is, krijgt elke sub map de rechten van de role die de eigenaar heeft. Als deze functionaliteit actief is, dan krijgt elke sub map de zelfde rechten als de bovenliggende map.',
    'show_only_accessible_folders_tip' => 'Standaard een gebruiker ziet het complete pad naar de mappen ook al heeft hij niet op iedere map toegang. U kunt de folders waar de gebruiker geen toegang tot heeft verwijderen.',
    'show_only_accessible_folders' => 'Maak de Item lijst makkelijker, door het verwijderen van mappen waar de gebruiker geen toegang tot heeft.',
    'comment' => 'Opmerking',
    'suggestion_menu' => 'Suggesties',
    'settings_suggestion' => 'Zet item suggesties aan voor gebruikers met alleen leesrechten',
    'settings_suggestion_tip' => 'Item suggesties laten toe dat read-only users nieuwe items of wijzigingen aan bestaande items kunnen voorstellen. Deze suggesties kunnen dan door een Administrator of Manager gevalideerd worden.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP BIND DN',
    'settings_ldap_bind_passwd' => 'LDAP BIND wachtwoord',
    'settings_ldap_search_base' => 'LDAP zoek base',
    'settings_ldap_bind_dn_tip' => 'een BIND DN welke kan BIND en SEARCH in het AD FORREST',
    'settings_ldap_bind_passwd_tip' => 'wachtwoord voor BIND DN welke kan BIND en SEARCH gebruikers in het AD FORREST',
    'settings_ldap_search_base_tip' => 'Zoek root DN voor zoek opdrachten in AD FORREST',
    'admin_email_server_url' => 'Server URL voor in de e-mails',
    'enable_email_notification_on_user_pw_change' => 'Stuur een e-mail naar een gebruiker wanneer zijn wachtwoord is veranderd',
    'settings_otv_expiration_period' => 'Vertraging voor het verlopen van eenmalig te bekijken gedeelde items (in dagen)',
    'write' => 'Schrijf',
    'read' => 'Lees',
    'no_access' => 'Geen Toegang',
    'right_types_label' => 'Selecteer het soort toegang voor deze map voor de geselecteerde groep gebruikers',
    'duplicate_item_in_folder' => 'Sta items met een soortgelijk label toe in een zelfde map',
    'settings_roles_allowed_to_print' => 'Definieer de rollen die bestanden mogen afdrukken',
    'settings_roles_allowed_to_print_tip' => 'De geselecteerde rollen mogen items afdrukken naar een bestand',
    'admin_email_security' => 'SMTP beveiliging',
    'alert_page_will_reload' => 'De pagina zal nu worden herladen',
    'file_protection_password' => 'Definieer een bestandswachtwoord',
    'expand' => 'Uitvouwen',
    'collapse' => 'Invouwen',
    'settings_ldap_user_attribute' => 'Gebruikersnaam attribuut',
    'settings_ldap_user_attribute_tip' => 'LDAP attribuut om de gebruikersnaam in te vinden',
    'log_user_initial_pwd_changed' => 'Initiële passwoord ingesteld',
    'log_user_email_changed' => 'E-mailadres van gebruiker veranderd naar ',
    'log_user_created' => 'Gebruikersaccount aangemaakt',
    'log_user_locked' => 'Gebruiker is vergrendeld',
    'log_user_unlocked' => 'Gebruiker is ontgrendeld',
    'log_user_pwd_changed' => 'Gebruikerswachtwoord is veranderd',
    'settings_default_session_expiration_time' => 'de standaard sessie verlooptijd',
    'settings_duo' => 'Schakel Duo Security in voor Two-factor authenticatie',
    'settings_duo_tip' => 'Gebruikers two factor authenticatie can ingesteld worden via DuoSecurity.com. Deze methode garandeert een hoog veiligheidsniveau bij het authenticeren.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Deze aanmeldingsgegevens worden uitgegeven vanuit de webapplicatie die je speciaal hebt aangemaakt voor Teampass op de Duo Security administratie pagina.<br />Door op opslaan te klikken worden ze opgeslagen in het sk.php bestand.',
    'admin_duo_intro' => 'Vul de volgende velden in',
    'edit' => 'Bewerken',
    'user_info_locked' => 'Gebruiker is vergrendeld',
    'user_info_unlock_question' => 'Account ontgrendelen?',
    'user_info_lock_question' => 'Account vergrendelen?',
    'user_info_delete_question' => 'Account verwijderen?',
    'user_info_active' => 'Gebruiker is momenteel ACTIEF',
    'refresh' => 'Vernieuwen',
    'loading' => 'Laden',
    'searching' => 'Zoeken...',
    'list_items_with_tag' => 'Bekijk items met deze tag',
    'no_item_to_display' => 'Geen items om weer te geven',
    'opening_folder' => 'Lezen van de map...',
    'suggestion_notify_subject' => '[Teampass] Er is een nieuwe suggestie gedaan.',
    'suggestion_notify_body' => 'Hallo,<br /><br />Een nieuwe suggestie is geplaatst. Je moet het bevestigen voordat anderen het kunnen gebruike',
    'error_unknown' => 'Een onbekende fout!',
    'no_edit' => 'Schrijven maar niet bewerken',
    'role_cannot_edit_item' => 'Kan geen items bewerken',
    'no_delete' => 'Schrijven maar niet verwijderen',
    'role_cannot_delete_item' => 'Kan geen items verwijderen',
    'my_profile' => 'Mijn profiel',
    'starting' => 'Starten ...',
    'total_number_of_items' => 'Totaal aantal items',
    'finalizing' => 'Afronden',
    'treating_items' => 'Behandel items',
    'number_of_items_treated' => 'Aantal behandelde items',
    'error_sent_back' => 'Volgende error',
    'full' => 'Vol',
    'sequential' => 'Opvolgend',
    'tree_load_strategy' => 'Tree laad strategie',
    'syslog_enable' => 'Schakel Syslog in',
    'syslog_host' => 'Syslog server',
    'syslog_port' => 'Syslog poort',
    'error_bad_credentials' => 'Login gegevens zijn onjuist!',
    'settings_ldap_usergroup' => 'Zoek in LDAP groep',
    'settings_ldap_usergroup_tip' => 'Een gebruiker moet lid zijn van een LDAP groep om in te kunnen loggen. Voorbeeld: cn=sysadmins,ou=groups,dc=example,dc=com ',
    'server_password_change_enable' => 'Zet het veranderen van het server user wachtwoord aan (via ssh verbinding)',
    'update_server_password' => 'Update server password',
    'ssh_pwd' => 'SSH wachtwoord',
    'ssh_user' => 'SSH gebruiker',
    'ssh_password_frequency_change_info' => 'Je kunt het automatisch vernieuwen een speciaal schema geven. Hiervoor moet je een schema opgeven wanneer de wachtwoorden worden geüpdatet. Selecteer 0 om de taak uit te schakelen.<br />Let op: dit werkt alleen als je beheerder de taak heeft ingeschakeld in het cron schema.',
    'ssh_password_frequency_change' => 'Paswoord verander frequentie (in maanden)',
    'ssh_scheduled_change' => 'Schema veranderen',
    'ssh_one_shot_change' => 'Eenmalige kans verandering',
    'server_password_change_enable_tip' => 'Deze optie zorgt ervoor dat gebruikers automatisch het wachtwoord op de server kunnen updaten via SSH.<br>Let op dat het automatisch ',
    'error_bad_credentials_more_than_3_times' => 'Login gegevens fout!<br>Wacht 10 seconden voor een nieuwe poging!',
    'settings_ldap_object_class' => 'Class om te dorzoeken',
    'settings_ldap_object_class_tip' => 'LDAP class om te doorzoeken, zoals gebruikers account of POSIX account',
    'rebuild_config_file' => 'Reconstrueer het configuratiebestand',
    'rebuild_config_file_tip' => 'Het configuratiebestand bevat systeem variabelen, deze instellingen worden gebruikt voordat de database verbinding is gemaakt. Het reconstrueren van het configuratiebestand bewaart de database instellingen in het bestand. Dit kan op elk moment uitgevoerd worden. De standaard locatie is ./includes/config/tp.config.php, maar moet buiten de www locatie gehouden worden in verband met beveiliging.',
    'error_folder_complexity_lower_than_top_folder' => 'Submappen moeten een wachtwoordsterkte hebben die hetzelfde of hoger is dan de bovenliggende map',
    'new_item_email_body' => 'Hallo, <br /><br />Nieuw item &apos;#label&apos; is aangemaakt in Teampass.<br />Je kan hem benaderen door op deze link te klikken:  <a href="#link#">LINK</a>.<br/><br />Groet.',
    'failed_logins' => 'Mislukte Logins',
    'error_only_numbers_in_folder_name' => 'Maplabel kan niet alleen bestaan uit een nummer. Geef je map een naam waarin letters zijn verwerkt. ',
    'encrypted_data' => 'Data is versleuteld in de database',
    'settings_ldap_port' => 'LDAP poort',
    'user_profile_agses_card_id' => 'Uw AGSES kaart id',
    'ga_flash_qr_and_login' => 'Fotografeer deze QR code met uw mobiele apparaat, voer de 2-Factor authenticatie in en klik op de &apos;Enter&apos; knop',
    'i_need_to_generate_new_ga_code' => 'Ik heb een nieuwe QR code nodig. Stuur mij een tijdelijke identificatieCode via e-mail',
    'settings_manager_move_item' => 'Managers kunnen elk item verplaatsen dat ze kunnen zien',
    'user_folders_rights' => 'Zichtbare mappen',
    'create_item_without_password' => 'Toestaan dat item zonder enig wachtwoord wordt aangemaakt',
    'share_rights_info' => 'Dit dialoogvenster staat u toe om rechten te delen van één gebruiker, met een selectie van gebruikers.<br>Merk op dat de rechten van de geselecteerde gebruikers worden gereset en dat ze dezelfde rechten krijgen als de brongebruiker.',
    'share_rights_source' => 'Brongebruiker',
    'share_rights_destination' => 'Doelgebruikers',
    'ga_reset_by_user' => 'Gebruiker kan zijn 2FA code resetten',
    'ga_reset_by_user_tip' => 'Wanneer geactiveerd, zal de gebruiker de mogelijkheid hebben om zijn 2FA code te resetten op de login pagina. Dit kan b.v.  handig zijn in het geval dat hij een ander mobiel apparaat heeft. Wanneer uitgeschakeld dient de gebruiker een nieuwe code aan de beheerder te vragen.',
    'enable_massive_move_delete' => 'Sta toe dat de gebruiker massale verplaats en verwijder acties uitvoert',
    'enable_massive_move_delete_tip' => 'Wanneer geactiveerd, zal deze optie gebruikers toestaan massale verplaats en/of verwijder acties uit te voeren. De gebruiker kan dit alleen toen op items waarop hij is geautoriseerd.',
    'mass_operation' => 'Massale acties op items',
    'move_items' => 'Verplaats geselecteerde items',
    'delete_items' => 'Verwijder geselecteerde items',
    'you_decided_to_move_items' => 'U heeft besloten om items te verplaatsen',
    'you_decided_to_delete_items' => 'U heeft besloten om items te verwijderen',
    'suggest_password_change' => 'Stel een wachtwoordwijziging voor',
    'otv_is_enabled' => 'Gebruiker kan One-Time-view links voorstellen',
    'error_source_and_destination_are_equal' => 'Bron en doel kunnen niet hetzelfde zijn',
    'sending_anonymous_statistics' => 'Versturen van anonieme statistieken',
    'favourites_option_enabled' => 'Favorieten optie geactiveerd',
    'personalfolders_option_enabled' => 'Persoonlijke mappen geactiveerd',
    'country_statistics' => 'Wereldkaart gebruik',
    'country' => 'Land',
    'users_statistics' => 'Gemiddeld aantal gebruikers per installatie',
    'items_all' => 'Alle items',
    'folders_all' => 'Alle mappen',
    'items_shared' => 'Alle gedeelde items (persoonlijke items niet meegeteld)',
    'folders_shared' => 'Alle gedeelde mappen (persoonlijke mappen niet meegeteld)',
    'items_statistics' => 'Gemiddeld aantal items per installatie',
    'folders_statistics' => 'Gemiddeld aantal mappen per installatie',
    'administrators_number' => 'Aantal Administrator gebruikers',
    'administrators_number_statistics' => 'Gemiddeld aantal Beheerders per installatie',
    'managers_number' => 'Aantal Manager gebruikers',
    'managers_number_statistics' => 'Gemiddeld aantal Managers per installatie',
    'readonly_number_statistics' => 'Gemiddeld aantal Read-Only gebruikers per installatie',
    'readonly_number' => 'Aantal Read-Only gebruikers',
    'mysql_version' => 'MySQL versie',
    'php_version' => 'HP versie',
    'teampass_version' => 'Teampass versie',
    'languages_used' => 'Gebruikte talen',
    'languages_statistics' => 'Meest gebruikte taal',
    'kb_option_enabled' => 'Knowledge Base optie geactiveerd',
    'suggestion_option_enabled' => 'Suggestie optie geactiveerd',
    'customfields_option_enabled' => 'Persoonlijke velden optie geactiveerd',
    'api_option_enabled' => 'API optie geactiveerd',
    '2fa_option_enabled' => '2FA optie geactiveerd',
    'agses_option_enabled' => 'AGSES optie geactiveerd',
    'duo_option_enabled' => 'DUO optie geactiveerd',
    'ldap_option_enabled' => 'LDAP optie geactiveerd',
    'syslog_option_enabled' => 'SYSLOG optie geactiveerd',
    'stricthttps_option_enabled' => 'Strict HTTPS optie geactiveerd',
    'characteristic' => 'Kenmerk',
    'current_value' => 'Huidige waarde',
    'communication_means' => 'Communicatie methoden',
    'consider_a_donation' => 'U kunt een donatie overwegen',
    'more_information' => 'Meer informatie',
    'feature_request_canal' => 'Voor nieuwe features of vragen gebruik',
    'bug_canal' => 'Voor het melden van Bugs gebruik',
    'documentation_canal' => 'Documentatie',
    'sending_anonymous_statistics_details' => 'Door het gebruik en de populatie van gebruikers te meten kunnen we Teampass verbeteren. De data die u verstrekt zal alleen intern voor datamining worden gebruikt en niet worden verstrekt aan derde partijen.',
    'item_has_change_proposal' => 'Dit item heeft een wijzigingsverzoek',
    'check_data_after_reencryption' => 'Controleer de data. Een nieuwe <b>Backup</b> tabel is gemaakt waarmee het mogelijk is om deze actie ongedaan te maken.',
    'revert' => 'Terugzetten?',
    'revert_the_database' => 'Je hebt besloten de database terug te zetten. Bevestig alstublieft?',
    'bad_psk' => 'De persoonlijke salt key is niet correct!',
    'ldap_test_config' => 'Test huidige configuratie',
    'ldap_test_username' => 'Te gebruiken gebruikersnaam voor test',
    'ldap_test_username_pwd' => 'Gebuikersnaam wachtwoord',
    'feature_support_canal' => 'Gebruik voor ondersteuning en hulp',
    'category' => 'Categorieen',
    'text' => 'Tekst',
    'type' => 'Type',
    'data_is_masked' => 'Data is verborgen',
    'at_export' => 'Exporteer',
    'settings_ldap_allowed_usergroup' => 'LDAP toegestaan voor gebruikersgroep',
    'settings_ldap_allowed_usergroup_tip' => 'Geef aan welke groep mag verbinden met Teampass. Laat dit veld leeg wanneer er geen restrictie is met betrekking tot groepslidmaatschap.',
    'error_security_level_not_reached' => 'Verwachte beveiligingsniveau niet bereik!',
    'personal_saltkey_security_level' => 'Minimum beveiligingsniveau persoonlijke sleutel',
    'settings_disable_forgot_password_link' => 'Verberg wachtwoord vergeten link op Home pagina',
    'newly_created_user_is_administrated_by' => 'Nieuw aangemaakte gebruiker wordt beheerd door',
    'settings_ldap_and_local_authentication' => 'Lokale en LDAP gebruikers',
    'settings_ldap_and_local_authentication_tip' => 'Activeer deze optie om zowel gebruikers geautenticeerd met LDAP en lokale gebruikers toe te staan.  ',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',
    'generate_new_keys' => 'Generate new keys',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown.',
    'generate_new_keys_end' => 'Process is on going in background and could take several minutes. You can now close this window.',
    'confirm_password' => 'We need you to confirm your password',
    'no_code_is_requested' => 'No code is requested.',
    'user_encryption_ongoing' => 'Account is currently being encrypting. Your request cannot continue. Please wait until this is finished.',
    'teampass_information' => 'Teampass information',
    'show_password' => 'Show password',
    'new_user_info_by_mail' => 'New user will receive an email with his credentials',
    'login_credentials' => 'Login credentials',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following password is expected next time using Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Your Teampass account is fully ready.<br><br>Cheers',
    'email_body_user_config_5' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Following code is expected next time using Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Data is not valid',
    'mfa_enabled' => 'MFA enabled',
    'mfa_disabled_for_user' => 'MFA disabled for user',

);
