<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @file      portuguese_br.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Exibir código de criptografia do usuário',
    'email_body_new_user' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>Um administrador criou para você uma conta de usuário no Teampass. Na próxima vez que você se autenticar no Teampass, por favor, use as seguintes credenciais:<ul><li>Login: #login#</li><li>Senha: #password#</li><li>Código de criptografia: #code#</li></ul><br><br><br>Atenciosamente',
    'user_password' => 'Senha do usuário',
    'user_temporary_encryption_code' => 'Código de criptografia do usuário',
    'no_email_set' => 'Nenhum e-mail foi registrado',
    'send_user_password_by_email' => 'Decide se a senha de usuário deve ser enviada via e-mail.<br>Se sim, então clique no botão Send.<br><br>Caso contrário, use o botão Copiar para a área de transferência para enviá-lo ao usuário por outro meio.<br>Será sua responsabilidade como Administrador prover ao usuário a senha através de um meio seguro.',
    'admin_change_user_encryption_code_info' => 'Essa operação redefinirá o código de criptografia para esse usuário.',
    'send_by_email' => 'Enviar via e-mail',
    'filters' => 'Filtros',
    'show_user_password' => 'Exibir senha do usuário',
    'open_website' => 'Abrir website',
    'mfa_for_roles' => 'MFA é requisitado para Usuários em Papéis',
    'mfa_for_roles_tip' => 'Por padrão, assim que um método MFA é selecionado, ele é habilitado para todos os usuários. Porém, você pode selecionar os papéis para os quais ele é esperado.<br>NÃO IMPLEMENTADO AINDA',
    'at_least_one_administrator_is_requested' => 'Pelo menos um administrador é requisitado',
    'bad_code' => 'Código de erro',
    'generating_keys' => 'Gerando chaves',
    'this_may_take_time' => 'Isso pode levar alguns minutos',
    'disable_enable' => 'Desabilitar / Habilitar',
    'user_disable_status' => 'Marque essa caixa para desabilitar ou deixe vazio para habilitá-lo',
    'help_for_launching_items_encryption' => 'Nós precisamos gerar as chaves de banco de dados para sua conta. Por favor, informe seu código de criptografia.',
    'managed_through_ad' => 'Gerenciado através do AD',
    'new_ldap_user_info' => 'Por favor, complete as definições para o usuário',
    'email_body_user_added_from_ldap_encryption_code' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>Agora você possui uma conta no Teampass. Você pode usar suas credenciais do AD para entrar.<br><br>No seu primeiro acesso, será solicitado seu código de criptografia, por favor informe:<br><br><b>#enc_code#</b><br><br><br>Atenciosamente',
    'settings_ldap_user_object_filter' => 'Filtro de Objeto de Usuário',
    'settings_ldap_user_object_filter_tip' => 'O filtro a ser utilizado ao pesquisar objetos de usuário. Exemplo: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Esse valor é usado adicionalmente ao DN base ao buscar e carregar usuários. Se nenhum valor for informado, a busca de subárvore iniciará à partir da DN base. Exemplos: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'DN Adicional de Usuário',
    'ldap_user_has_changed_his_password' => 'Sua senha de autenticação foi alterada no AD desde a última vez que você entrou no Teampass. Nós precisamos adaptar sua chave de criptografia. Por favor, informe sua senha anterior e a sua senha atual.',
    'provide_your_previous_password' => 'Sua senha anterior',
    'admin_change_user_password_info' => 'Essa operação redefinirá a senha atual do usuário selecionado.',
    'sending_email_message' => 'Enviando e-mail para o usuário, por favor, aguade',
    'change_your_password_info_message' => 'Por favor, informe sua nova senha de autenticação e confirme.',
    'user_has_to_change_password_info' => 'A senha de usuário atual foi gerada. É esperado que você a altere por razões de segurança.',
    'ready_to_go' => 'Pronto para continuar',
    'passwords_not_the_same' => 'As senhas informadas não correspondem',
    'inititialization' => 'Iniciando',
    'bad_password' => 'Senha incorreta',
    'perform_checks' => 'Realizando verificações',
    'email_body_temporary_encryption_code' => 'Olá,<br><br>Esse é um e-mail automático gerado pelo gerenciador de senhas Teampass.<br><br>Algumas mudanças foram realizadas na sua conta que requerem uma nova criptografia dos itens para a segurança dos dados. Da próxima vez que você acessar o Teampass, por favor, informe o seguinte código:<br><br><b>#enc_code#</b><br><br><br>Atenciosamente',
    'temporary_encryption_code' => 'Seu código de criptografia temporário',
    'renecyption_expected' => 'Nós precisamos regerar suas chaves para atender aos privilégios correspondentes para sua conta e direitos.',
    'error_no_user_in_ad' => 'Usuário não encontrado no AD!',
    'error_ad_user_expired' => 'Usuário expirado!',
    'error' => 'Erro encontrado',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'A opção hosts é um array de endereços IP ou host names localizados na sua rede que servem um diretório LDAP (separados por vírgulas). Você pode inserir quantos servidores você desejar de acordo com a sua floresta (no mínimo um servidor deve ser informado).',
    'base_distiguished_name' => 'DN Base',
    'settings_ldap_bdn_tip' => 'O nome distinto (DN) raiz para usar ao executar consultas ao seu servidor de diretório. Exemplos: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Nome de usuário',
    'settings_ldap_username_tip' => 'O nome distinto (DN) do usuário que o aplicativo usará ao se conectar ao seu servidor de diretório. Exemplos: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'A senha para o usuário especificado acima.',
    'settings_ldap_port_tip' => 'A opção de porta é usada para autenticação e conexão ao servidor LDAP. As portas padrão já são usadas para conexões não SSL e SSL (389 e 636). Insira uma porta apenas se o seu servidor LDAP usar uma porta exclusiva.',
    'undefined' => 'Indefinido',
    'error_cannot_open_file' => 'O arquivo não pôde ser aberto',
    'provide_current_psk_and_click_launch' => 'Quando estiver pronto, clique no botão Executar',
    'start' => 'Iniciar',
    'data_inconsistency' => 'Inconsistência de dados encontrada. Por favor, recarregue a página!',
    'one_time_code_expected' => 'Código-Único esperado',
    'data_are_missing' => 'Dados esperados estão ausentes',
    'one_time_code' => 'Código-Único',
    'provide_personal_one_time_code' => 'Por favor, informe o Código-Único',
    'change_authentification_type_to_ldap' => 'Alterar tipo de autenticação para LDAP',
    'change_authentification_type_to_local' => 'Alterar tipo de autenticação para o banco de dados local do Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Senha de usuário usada para autenticação LDAP',
    'local_user_password_is_used_for_authentication' => 'Senha de usuário usada para autenticação no Teampass',
    'provide_your_current_password' => 'Informe sua senha atual',
    'current_password' => 'Senha atual',
    'password_is_not_correct' => 'Senha incorreta',
    'ldap_password_change_warning' => 'Sua senha alterou desde seu último acesso. É necessário re-encriptar todas as suas chaves usando essa nova senha. Para essa operação, por favor, informe sua senha LDAP anterior no campo a seguir. Essa operação pode levar vários minutos.',
    'personal_items' => 'Itens pessoais',
    'logout_on_going' => 'Agora você será desconectado. Use sua nova senha para se conectar de agora em diante.',
    'fill_in_fields_and_hit_launch' => 'Informe os dados esperados e clique no botão Executar',
    'please_select_a_folder' => 'Por favor, selecione uma pasta',
    'user_must_have_login_and_email' => 'O usuário deve possuir um login e um e-mail',
    'user_has_this_role_in_teampass' => 'O usuário tem esse papel no Teampass',
    'select_role_to_create' => 'Selecione o papel para criar',
    'adding_ldap_role_to_teampass' => 'Você pode decidir criar um papel no Teampass advindo do seu Active Directory. Isso permitirá você associar o usuário para esse papel no Teampass.',
    'add_user_to_role' => 'Adicionar esse papel ao usuário no Teampass',
    'add_user_in_teampass' => 'Adicionar usuário no Teampass',
    'synchronized' => 'Sincronizado',
    'output' => 'Saída',
    'remove_install_folder' => 'O diretório install deve ser excluído',
    'list_users' => 'Listar usuários',
    'ldap_synchronization' => 'Sincronização LDAP',
    'in_progress' => 'Em progresso',
    'clipboard_password_life_duration' => 'Delay antes da área de transferência ser limpa (em segundos)',
    'clipboard_password_life_duration_tip' => 'Permite definir um atraso em segundos antes da senha copiada para a área de transferência ser limpa da área de transferência do navegador. Defina 0 para desabilitar.',
    'clipboard_will_be_cleared' => 'A senha foi copiada para a área de transferência. Ela será removida da área de transferência em breve...',
    'file_folder_not_accessible' => 'A pasta Files não está acessível',
    'error_missing_id' => 'Ocorreu um erro. ID está faltando ... ?',
    'error_folder_not_allowed' => 'A pasta selecionada não é permitida',
    'all_fields_mandatory' => 'Todos os campos são obrigatórios',
    'history_insert_entry' => 'Inserir no Histórico',
    'clear_form' => 'Limpar formulário',
    'info_about_history_insertion' => 'Cuidado - Esse recurso permite a você inserir manualmente um evento no log histórico do item. Assim que você adicioná-lo, não será possível removê-lo. Note também que o ID da sua conta será associada a essa nova entrada.',
    'select_all' => 'Selecionar tudo',
    'unselect_all' => 'Desmarcar todos',
    'no_data_to_display' => 'Nenhum dado para exibir! A pasta não existe ou você não possui permissão para acessá-la.',
    'server' => 'Servidor',
    'data_refreshed' => 'Dados atualizados',
    'loading_image' => 'Carregando imagem',
    'compare_with_another_role' => 'Comparar com outro papel',
    'only_display_folders_to_depth' => 'Somente exibir Pastas até a profundidade',
    'propagate_rights_to_descendants' => 'Propagar direitos aos descendentes',
    'loading_data' => 'Carregando dados',
    'password_overview_delay' => 'Delay de revelação de senhas',
    'password_overview_delay_tip' => 'Essa configuração permite definir o número de segundos antes de ocultar as senhas exibidas para o usuário.',
    'select_date_showing_items_expiration' => 'Listas os itens expirados na data',
    'renewal_page_info' => 'Esta página permite identificar os itens expirados ou próximos de expirar.',
    'filename' => 'Nome do arquivo',
    'exported_to_file' => 'Exportado para arquivo',
    'operation_progress' => 'Operação em progresso',
    'exporting_items' => 'Exportando itens',
    'select_folders_to_export' => 'Selecione as pastas para exportar',
    'export_format_type' => 'Selecione o formato de exportação',
    'export_items' => 'Exportar itens',
    'loading_item' => 'Carregando item',
    'otv_message' => 'Você pode compartilhar esse item com alguém sem uma conta no Teampass. A Visualização-Única (OTV) permite que seu convidado acesse campos básicos desse item uma única vez sem estar autenticado no Teampass. Por favor, note que esse link é válido para o período de ##otv_expiration_period## dias. Copie e compartilhe o link abaixo.',
    'no_sharekey_found' => 'Nenhuma chave encontrada para esse arquivo e sua conta',
    'otv_link' => 'Link de Visualização-Única',
    'one_time_view' => 'Visualização-Única',
    'move_right_columns_separator' => 'Mover colunas para o separador à Direita',
    'move_left_columns_separator' => 'Mover colunas para o separador à Esquerda',
    'form_presents_inconsistencies' => 'O formulário apresenta algumas inconsistências. Por favor, verifique os campos com bordas vermelhas.',
    'download' => 'Baixar',
    'see' => 'Ver',
    'at_anyoneconmodify' => 'Qualquer pessoa pode modificar',
    'disabled' => 'Desabilitado',
    'enabled' => 'Hbailitado',
    'confirmation_seems_wrong' => 'A confirmação parece incorreta, por favor, corrija',
    'i_cannot_remember' => 'Eu não consigo lembrar',
    'i_cannot_remember_info' => 'Não é possível reverter essa ação. Ela limpará as senhas armazenadas dentro dos seus itens pessoais. Os itens não serão excluídos, apenas suas senhas. Se você não lembra sua SaltKey pessoal, então essa é a única opção.',
    'user_has_psk_info' => 'Nós identificamos que alguns itens pessoais estão encriptados com uma SaltKey pessoal antiga. Esse passo consistente em encriptá-los com sua nova chave privada. Por favor, informe sua SaltKey pessoal.',
    'files' => 'Arquivos',
    'logs' => 'Relatórios',
    'suggestions' => 'Sugestões',
    'encryption_keys' => 'Chaves de criptografia',
    'clearing_old_sharekeys' => 'Limpar chaves de criptografia antigas',
    'hit_launch_to_start' => 'Por favor, clique no botão Executar para iniciar',
    'password_changed' => 'Senha atualizada',
    'password_already_used' => 'Senha já está em uso',
    'change_login_password' => 'Alterar senha de login',
    'current_password_mandatory' => 'A senha atual é obrigatória',
    'objects_encryption_explanation' => 'O Teampass foi atualizado para uma nova versão que inclui um novo protocolo de encriptação. Ele espera que você re-encripte seus itens pessoais. Para isso, você precisa prover sua chave de Salt Key Pessoal (PSK). Quando estiver pronto, clique no botão Executar e aguarde até o passo final. Dependendo do número de objetos, Isso pode levar vários minutos.',
    'description_has_changed' => 'A descrição foi alterada',
    'number_of_folders_imported' => 'Número de Pastas importadas',
    'number_of_items_imported' => 'Número de Itens importados',
    'propagate' => 'Propagar',
    'propagate_user_rights' => 'Propagar direitos de usuário',
    'register_new_yubiko_key' => 'Registrar uma nova chave Yubiko',
    'part_of_groups' => 'Parte de Grupos',
    'previous_value' => 'Valor anterior',
    'no_previous_value' => 'Nenhum valor anterior',
    'no_data_selected' => 'Nenhum dado selecionado',
    'selected_items_to_be_imported' => 'Itens selecionados para importação',
    'cannot_open_file' => 'O arquivo não pôde ser aberto',
    'no_item_found' => 'Nenhum Item encontrado',
    'reading_file' => 'Lendo arquivo',
    'where_shall_items_be_created' => 'Onde os Itens devem ser criados',
    'target_folder' => 'Pasta alvo',
    'select_file' => 'Selecionar arquivo',
    'data_type_for_import' => 'Inicie selecionando o tipo de dado da origem para importar',
    'get_tips_about_importation' => 'Veja dicas sobre importação',
    'import_new_items' => 'Importar novos itens',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'para',
    'request_access' => 'Requisitar acesso ao Item',
    'request_access_message' => 'Ao requisitar acesso a um item, um e-mail será enviado ao autor. O autor irá aceitar ou rejeitar a requisição adicionando você a lista de restrição do Item. Por favor, confirme o envio da sua requisição ao autor via e-mail.',
    'request_access_reason' => 'Informe ao autor o motivo da sua requisição',
    'error_provide_reason' => 'Por favor, informe o porquê você deseja ter acesso a esse item',
    'need_access' => 'Precisa de acesso?',
    'item_with_restricted_access' => 'Item com acesso restrito',
    'remaining_emails_to_send' => 'E-mails pendentes de envio',
    'mfa_flash' => 'Capture com seu dispositivo móvel',
    'import' => 'Importar',
    'export' => 'Exportar',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Sua atenção é necessária. Pelo menos uma tentativa de login com sua conta foi identificada desde a última conexão bem-sucedida. Por favor, verifique e reporte ao seu administrador local se não foi você.',
    'last_login_attempts' => 'Últimas tentativas de login',
    'see_detail' => 'Veja os detalhes',
    'role_definition' => 'Definição do papel',
    'not_yet_implemented' => 'Não implementado ainda',
    '2factors_expected_for_admin' => 'Administrador requer MFA para autenticação',
    '2factors_expected_for_admin_tip' => 'Por padrão, um Administrador deve usar um método MFA para entrar. Se desabilitado, o Administrador não requer MFA para autenticação, mesmo que o MFA esteja habilitado para outros usuários.',
    'restore_done_now_logout' => 'A restauração do banco de dados foi concluída. Agora você será desconectado para atualizar as variáveis de sessão.',
    'backup_and_restore' => 'Backup e Restauração',
    'explanation_for_oneshot_backup' => 'explanation_for_oneshot_backup',
    'explanation_for_oneshot_restore' => 'explanation_for_oneshot_restore',
    'perform_backup' => 'Realizar backup',
    'perform_restore' => 'Realizar restauração',
    'backup_select' => 'Arquivo de backup',
    'choose_file' => 'Escolher arquivo',
    'on_the_fly' => 'Agora',
    'scheduled' => 'Agendado',
    'caution_on_field_encryption_change' => 'Cuidado - Esteja ciente que alterar o tipo de encriptação requer o processamento de todos os dados existentes de forma a alterar a encriptação no banco de dados.',
    'caution_while_deleting_field' => 'Cuidado - Excluir esse campo também exclui todas as informações relacionadas no item.',
    'error_could_not_update_the_field' => 'Erro - O campo não pôde ser atualizado. Por favor, tente novamente após recarregar a página.',
    'caution_while_deleting_category' => 'Cuidado - Excluir essa pasta excluirá todos os campos filhos e também todos os campos de dados relacionados.',
    'your_attention_please' => 'Sua ação é requerida',
    'all_fields_are_required' => 'Todos os campos são requeridas',
    'position' => 'Posição',
    'before' => 'Antes de',
    'top' => 'Topo',
    'bottom' => 'Fundo',
    'field' => 'Campo',
    'configuration' => 'Configuração',
    'definition' => 'Definição',
    'number_of_modified_attachments' => 'Número de anexos modificados',
    'files_not_encrypted' => 'Atualmente, os arquivos não estão encriptados. Você deve realizar essa mudança por razões de segurança.',
    'files_already_encrypted' => 'Os arquivos já estão encriptados. Você não deve alterar isso por razões de segurança.',
    'action_to_be_performed' => 'Ação a ser realizada',
    'last_execution' => 'Última execução em',
    'never_performed' => 'Nunca realizada',
    'launch' => 'Executar',
    'set_of_actions' => 'Conjunto de ações',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Configuração de uploads',
    'email_configuration' => 'Configuração de e-mail',
    'email_configuration_test' => 'Teste de configuração de e-mail',
    'send_a_test_email' => 'Enviar um e-mail de teste',
    'manage_emails_not_sent' => 'E-mails de gerência não enviados',
    'email_send_backlog' => '#nb_emails# e-mails não enviados',
    'send_waiting_emails' => 'E-mails aguardando envio',
    'ip' => 'IP',
    'no_data_defined' => 'Nenhum dado foi definido',
    'adding_new_api_ip' => 'Adicionando um novo IP a lista de permitidos',
    'adding_new_api_key' => 'Adicionando uma nova chave de API',
    'api_configuration' => 'Configuração de API',
    'mfa_configuration' => 'Configuração de MFA',
    'yubico_authentication_tip' => 'Por favor, visite www.yubico.com para obter mais informações.',
    'complexity_level_not_reached' => 'Nível de complexidade não alcançado',
    'expected_complexity_level' => 'Nível de complexidade esperado',
    'your_attention_is_required' => 'Sua atenção é requerida',
    'favorite' => 'Favoritar',
    'unfavorite' => 'Remover dos favoritos',
    'you_need_to_select_at_least_one_folder' => 'Você precisa selecionar pelo menos uma pasta',
    'no_value_defined_please_fix' => 'Nenhum valor definido! Por favor, corrija.',
    'apply' => 'Aplicar',
    'from' => 'De',
    'please_confirm_by_clicking_checkbox' => 'Por favor, confirme clicando na caixa de seleção',
    'date_range' => 'Intervalo de datas',
    'purge' => 'Limpar',
    'belong_of_deleted_folder' => 'Pertencem a pasta excluída',
    'highlight_selected' => 'Destacar selecionados',
    'number_of_selected_objects' => 'Número de objetos selecionados',
    'confirm_selection_restore' => 'Por favor, confirme a restauração dos itens selecionados.',
    'confirm_selection_delete' => 'Por favor, confirme a exclusão dos itens selecionados.',
    'refreshing' => 'Atualizando',
    'empty_list' => 'Lista vazia',
    'deleted_folders' => 'Pastas excluídas',
    'deleted_items' => 'Itens excluídos',
    'recycled_bin' => 'Lixeira',
    'database' => 'Banco de dados',
    'renewal' => 'Renovação',
    'renewal_delay' => 'Delay de renovação',
    'please_confirm_deletion' => 'Por favor, confirme a exclusão',
    'caution' => 'Cuidado',
    'role_not_exist' => 'Esse papel não existe!',
    'role_can_edit_any_visible_item' => 'Papel pode editar quaisquer item visível',
    'role_can_edit_any_visible_item_tip' => 'A configuração padrão é manter essa caixa de seleção desmarcada. Quando marcada, ela permite que um usuário pertencente a esse papel editar quaisquer item que um usuário pode abrir, o que leva a um status de insegurança. Essa caixa só deve ser marcada por um período específico de tempo e apenas em caso de necessidade.',
    'edit_allowed' => 'Edições permitidas',
    'delete_allowed' => 'Exclusões permitidas',
    'add_allowed' => 'Adições permitidas',
    'edit_not_allowed' => 'Edições não permitidas',
    'delete_not_allowed' => 'Exclusões não permitidas',
    'select_a_role' => 'Selecionar um papel',
    'access_rights_for_user' => 'Direitos de acesso para o usuário',
    'logs_for_user' => 'Logs para o usuário',
    'please_confirm' => 'Por favor, confirme ',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Ao marcar essa caixa de seleção, você confirma a exclusão desse usuário.',
    'fields_with_mandatory_information_are_missing' => 'Campos com informações obrigatórios estão vazios',
    'enable_personal_folder_for_this_user' => 'Habilitar o recurso de Pastas Pessoais para esse usuário',
    'special' => 'Especial',
    'administrator' => 'Administrador',
    'super_manager' => 'Gerente do Teampass',
    'manager' => 'Gerente',
    'read_only' => 'Somente leitura',
    'privileges' => 'Privilégios',
    'roles' => 'Papéis',
    'user_definition' => 'Definição de usuário',
    'no_selection_done' => 'Nenhuma seleção',
    'tick_confirmation_box' => 'Por favor, marque a caixa de seleção para confirmar',
    'next_list_to_be_deleted' => 'A lista a seguir será excluída',
    'delete_folders' => 'Excluir Pastas',
    'submit' => 'Enviar',
    'label' => 'Título',
    'parent' => 'Pai',
    'password_minimal_complexity_target' => 'Complexidade mínima de senha do alvo',
    'access_right_for_roles' => 'Direitos de acesso para Papéis',
    'create_without_password_minimal_complexity_target' => 'Permitir a criação de um novo item sem atender a complexidade de senha mínima',
    'edit_without_password_minimal_complexity_target' => 'Permitir a edição sem atender a complexidade de senha mínima',
    'add_new_folder' => 'Adicionar uma nova senha',
    'new' => 'Novo',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Fator de Autenticação',
    'google_2fa' => 'Verificação de duas etapas do Google',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Clique para abrir o Site do Teampass',
    '2fa_credential_not_correct' => 'A credencial 2FA está incorreta',
    'no_change_performed' => 'Nenhuma alteração foi realizada.',
    'password_strength' => 'Força da senha',
    'new_password_required' => 'Uma nova senha é exigida',
    'limited_search' => 'Pesquisa limitada',
    'empty_psk' => 'SaltKey está ausente',
    'currently_no_favorites' => 'Você não possui nenhum favorito',
    'favorites' => 'Favoritos',
    'confirm_item_move' => 'Você selecionou "Mover"... você tem certeza?',
    'copy_to_clipboard' => 'Copiar para a área de transferência',
    'please_wait_while_loading' => 'Por favor, aguarde o carregamento dos dados',
    'defect_report' => 'Relatar um bug',
    'actions' => 'Ações',
    'no_user' => 'Usuário incorreto',
    'generate_api_token' => 'Gerar um novo token de API',
    'upload_feature' => 'Recurso de upload',
    'profile' => 'Perfil',
    'language' => 'Idioma',
    'upload_new_avatar' => 'Selecionar um arquivo PNG como avatar',
    'settings' => 'Configurações',
    'created_items' => 'Itens criados',
    'modification_performed' => 'Modificações realizadas',
    'items_opened' => 'Itens abertos',
    'passwords_seen' => 'Senhas visualizadas',
    'nothing_to_save' => 'Nada a salvar',
    'notification_engaged' => 'Você está recebendo notificações em eventos de modificação do Item',
    'notification_not_engaged' => 'Você não está recebendo notificações em eventos de modificação do Item',
    'viewed_number' => 'Número de Visualizações',
    'automatic_deletion_engaged' => 'Exclusão automática',
    'auto_update_enabled' => 'Alteração automática de senha de usuário habilitada. Próxima alteração prevista para',
    'copy_folder' => 'Copiar pasta',
    'select_source_folder' => 'Selecione a pasta para copiar',
    'select_destination_folder' => 'Selecione a pasta de destino',
    'delete_folder' => 'Excluir pasta',
    'select_folder_to_delete' => 'Selecione a pasta para excluir',
    'folder_delete_confirm' => 'A pasta selecionada e seus itens serão excluídos. Por favor, marque a caixa de seleção para confirmar essa exclusão.',
    'json_error_format' => 'Formato JSON inválido',
    'password_cannot_be_empty' => 'A senha não pode estar vazia',
    'password_too_long' => 'A senha é muito longa',
    'error_no_action_identified' => 'Nenhuma ação foi identificada',
    'ldap' => 'LDAP',
    'emails' => 'E-mails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Adicionar nova pasta',
    'select_folder_parent' => 'Selecionar pasta pai',
    'add' => 'Adicionar',
    'key_is_not_correct' => 'A chave de sessão provida é inválida',
    'suggestion_information' => 'Você pode sugerir quaisquer mudanças nesse item ao autor. Use o formulário acima para fazer sua solicitação de mudança e clique no botão Executar para informar ao autor.',
    'email_address' => 'Endereço de e-mail',
    'enter_email' => 'Digite o e-mail',
    'notification' => 'Notificações',
    'notify_on_change' => 'Notificar-me em modificações',
    'notification_message' => 'Você pode usar essa opção para ser notificado ou não sobre mudanças realizadas nesse item.',
    'share_item' => 'Compartilhar item',
    'share_item_message' => 'Você pode compartilhar esse item com alguém. Por favor, informe um endereço de e-mail válido e clique no botão Executar.',
    'delete_item_message' => 'Você decidiu excluir esse item. Você precisa confirmar sua ação clicando no botão Executar.',
    'warning' => 'Aviso',
    'information' => 'Informação',
    'perform' => 'Executar',
    'delete_item' => 'Excluir item',
    'copy_item' => 'Copiar item',
    'new_item' => 'Novo item',
    'error_not_allowed_to_edit_item' => 'Você não possui permissão para editar esse item',
    'error_not_allowed_to_access_this_folder' => 'Você não possui permissão para acessar essa pasta',
    'error_personal_saltkey_is_not_set' => 'Sua SaltKey pessoal não foi fornecida.',
    'provide_your_personal_saltkey' => 'Por favor, informe sua SaltKey pessoal',
    'no_fields' => 'Nenhum campo está relacionado a esse item.',
    'uploaded' => 'carregado',
    'changes_ongoing' => 'Algumas mudanças não foram salvas. Você confirma sair sem salvar?',
    'no_file_to_upload' => 'Nenhum arquivo carregado',
    'add_files_and_click_start' => 'Adicione arquivos para a fila de upload e clique no botão para iniciar.',
    'select_files' => 'Arquivos selecionados',
    'attached_files' => 'Arquivos anexados',
    'visible_by' => 'Visível para',
    'anounce_item_by_email' => 'Anunciar esse item aos usuários',
    'select_users_if_needed' => 'Selecione os usuários (se necessário)',
    'allow_item_to_be_deleted' => 'Permitir que esse item seja excluído nas condições a seguir',
    'item_deleted_after_being_viewed_x_times' => 'O item será excluído após ser visualizado X vezes',
    'item_deleted_after_date' => 'O item será excluído após a data definida',
    'password' => 'Senha',
    'save' => 'Salvar',
    'folder' => 'Pasta',
    'main' => 'Principal',
    'fields' => 'Campos',
    'details' => 'Detalhes',
    'no_special_restriction' => 'Nenhuma restrição especial',
    'generate_otv_link' => 'Gerar link de Visualização-Única',
    'no_custom_fields' => 'Nenhum campo personalizado',
    'no_attachment' => 'Nenhum anexo',
    'logout_confirm' => 'Deseja sair? Por favor, confirme.',
    'saved' => 'Salvo',
    'attachments' => 'Anexos',
    'success' => 'Sucesso',
    'server_answer_error' => 'Ocorreu um erro. A resposta do servidor não pôde ser processada!',
    'server_returned_data' => 'Dados retornados',
    'version_alone' => 'versão',
    'statistics' => 'Estatísticas',
    'options' => 'Opções',
    'users' => 'Usuários',
    'folders' => 'Pastas',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objetos encontrados',
    'auto_update_server_password_info' => 'Clicando para iniciar irá automaticamente executar os seguintes passos:<ul><li>Connectar no servidor através de SSH usando credenciais de login e campo `URL`,</li><li>Mudar a senha de usuário no servidor</il><li>Salva a nova senha no Teampass</il><li>Fecha a conexão SSH</li></ul><br /><b>Por favor assegure que o usuário possui direitos de logar e de mudar senhas no servidor (se não, indicar o usuário e senha de root) antes de iniciar.</b>',
    'share' => 'Compartilhar este item',
    'notify' => 'Notificar',
    'error_no_selected_folder' => 'Você precisa selecionar uma Pasta',
    'email_subject_item_updated' => '[Teampass] Um dos itens que você está acompanhando foi atualizado',
    'email_body_item_updated' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>Você decidiu ser notificado quando mudanças são realizadas no item `#item_label#` na pasta `#folder_name#`.<br><br>O usuário <b>#name# #lastname#</b> realizou pelo menos uma alteração.<br><br>Você pode verificá-la clicando <a href=&apos;#url#/index.php?page=items&group=#item_category#&id=#item_id#&apos;>AQUI</a>.<br><br>Atenciosamente',
    'import_kp_finished' => 'A importação do KeePass terminou! Por padrão, o nível de complexidade para novas pastas foram definidos como "Médio". Talvez você precisa mudar isso.',
    'password_is_empty' => 'Item sem senha',
    'bug_report_to_github' => 'Preencha os dados do relatório do problema, depois copie para a área de transferência e cole na página de problema do Github',
    'open_bug_report_in_github' => 'Abrir registro de problema no Github',
    'bugs_page' => 'Se você encontrar um bug, por favor, reporte-o.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Definir a permissão "qualquer um na mesma regra pode modificar" em todos os ítens importados. ',
    'import_csv_anyone_can_modify_txt' => 'Definir a permissão "qualquer um pode modificar" em todos os ítens importados. ',
    'settings_upload_imageresize_options' => 'As imagens devem ser redimensionadas',
    'user_not_exists' => 'Este usuário não existe!',
    'auto_create_folder_role' => 'Criar pasta e papel para ',
    'start_upload' => 'Iniciar carregamento dos arquivos',
    'error_upload_runtime_not_found' => 'Recurso de upload: Tempo de execução não encontrado',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Alterar sua senha',
    'admin_2factors_authentication_setting' => 'Ativar autenticação de duas etapas do Google',
    'admin_2factors_authentication_setting_tip' => 'A autenticação de duplas etapas do Google permite adicionar mais um nível de segurança na autenticação do usuário. No momento da autenticação no Teampass será gerado um QR code. Este QR code precisa ser escaneado para o usuário receber a senha dessa sessão.<br />CUIDADO: essa função extra requer conexão de internet e um dispositivo de escaneamento, como um smartphone.',
    'admin_ga_website_name' => 'Nome mostrado no Google Authenticator para o Teampass',
    'admin_ga_website_name_tip' => 'Este nome é usado para a identificação da conta do código no Google Authenticator.',
    'api_whitelist_ips' => 'IPs permitidos a API',
    'api_whitelist_ips_tip' => 'Se nenhum endereço IP for explicitamente listado aqui, então todos os endereços IP estão autorizados.',
    'email_share_item_subject' => '[Teampass] Um item foi compartilhado com você',
    'email_share_item_mail' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>#tp_user# compartilhou o item <b>#tp_item#</b> com você.<br>Clique<a href=#tp_link#>AQUI</a> para acessar o item.<br><br>Atenciosamente',
    'index_maintenance_mode_admin' => 'O modo de manutenção está ativado. Atualmente, os usuários não podem acessar o Teampass.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restringir visibilidade para',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Gerente do Teampass',
    'settings_secure_display_image' => 'Habilitar exibição segura de imagens',
    'settings_secure_display_image_tip' => 'A exibição segura de imagens permite ler a imagem através do PHP quando um usuário prevê uma imagem anexada a um item. Prós: o anexo é armazenado fora da pasta do site e não é acessível por um hacker. Contras: é mais lento do que prever a imagem diretamente através de uma URL.',
    'user_ga_code' => 'Enviar ao usuário o Código do Google Authenticator por e-mail',
    'error_no_email' => 'Este usuário não tem e-mail definido!',
    'error_no_user' => 'Usuário não encontrado!',
    'email_ga_subject' => 'Seu código único do Google Authenticator para o Teampass',
    'email_ga_text' => 'Olá,<br><br>Por favor, clique neste <a href="#link#">LINK</a> e o escaneie com o aplicativo Google Authenticator para obter sua credencial OTP para o Teampass.<br /><br />Saudações! ',
    'settings_attachments_encryption' => 'Ativar a criptografia dos itens anexados',
    'settings_attachments_encryption_tip' => 'ESTA OPÇÃO PODE CORROMPER ANEXOS EXISTENTES, por favor, leia cuidadosamente: Se habilitado, os anexos dos Itens são armazenados criptografados no servidor. Esta criptografia usa a SALT definida para o Teampass. Isso requer mais recursos do servidor. CUIDADO: Uma vez que você mudou a estratégia, é obrigatório executar o script para adaptar os anexos existentes. Veja a aba &apos;Ações Específicas&apos;.',
    'admin_action_attachments_cryption' => 'Criptografar ou descriptografar os anexos dos Itens.',
    'admin_action_attachments_cryption_tip' => 'CUIDADO: Esta ação só deve ser realizada depois de alterar a opção associada nas Configurações do Teampass. Por favor, faça uma cópia da pasta &apos;upload&apos; antes de fazer qualquer ação, apenas em caso de ...',
    'encrypt' => 'Criptografar',
    'decrypt' => 'Descriptografar',
    'ga_identification_code' => 'Código de identificação',
    'ga_enter_credentials' => 'Você precisa inserir suas credenciais de login',
    'ga_bad_code' => 'O código do Google Authenticator é inválido',
    'settings_get_tp_info' => 'Carregar automaticamente informações sobre o Teampass',
    'settings_get_tp_info_tip' => 'Esta opção permite que a página de administração carregue informações, tais como versão e uso de bibliotecas do servidor Teampass.',
    'settings_offline_mode' => 'Ativar modo off-line',
    'settings_offline_mode_tip' => 'O modo off-line consiste em exportar os itens para um arquivo HTML. Os itens nessa página são criptografados com uma chave fornecida pelo usuário.',
    'offline_mode_key_level' => 'Nível mínimo da chave de criptografia Off-line',
    'categories' => 'Categorias',
    'no_category_defined' => 'Nenhuma categoria definida.',
    'confirm_deletion' => 'Você está prestes a apagar... você tem certeza?',
    'settings_item_extra_fields' => 'Autorizar Itens serem completados com mais Campos (por Categorias)',
    'settings_item_extra_fields_tip' => 'Este recurso permite melhorar a definição do Item com campos extras que o Administrador pode definir e organizar por Categorias. Todas os dados são criptografados. Note que este recurso consome mais consultas SQL (em torno de mais 5 por Campo durante uma atualização de Item) e pode precisar de mais tempo para as ações serem realizadas. Isso vai depender do servidor.',
    'settings_ldap_type' => 'Tipo de servidor LDAP',
    'server_time' => 'Horário do servidor',
    'settings_tree_counters' => 'Mostrar mais contadores na árvore de pastas',
    'settings_tree_counters_tip' => 'Isso mostrará para cada pasta 3 contadores: número de itens na pasta; número de itens em todas as subpastas; número de subpastas. Este recurso precisa de mais consultas SQL e por precisar de mais tempos para exibir a árvore.',
    'admin_action_check_pf' => 'Criar Pastas Pessoais para todos os usuários que não a possuem',
    'enable_personal_folder_feature_tip' => 'As pastas pessoais são um local privado para senhas de usuários individuais. Os itens de senha são criptografados pela SaltKey de um usuário (mais seguro) ou por sua senha (mais fácil). A ativação desse recurso não cria as pastas reais para os usuários existentes - você também deve executar a tarefa de criação de pastas pessoais.',
    'administrators_only' => 'Apenas Administradores',
    'managers_of' => 'Gerentes do papel',
    'managed_by' => 'Gerenciado por',
    'settings_enable_sts' => 'Forçar a segurança HTTPS Strict Transport -- Aviso: Leia a dica.',
    'settings_enable_sts_tip' => 'Esta opção irá forçar o uso do HTTPS STS. O STS ajuda a evitar ataques  Man-in-the-Middle. Você DEVE ter um certificado VÁLIDO para utilizar essa opção. Se o seu certificado for autoassinado e habilitar essa opção, o sistema irá parar. Você deve ter &apos;SSLOptions +ExportCertData&apos; na configuração SSL do Apache.',
    'settings_anyone_can_modify_bydefault' => 'Ativar &apos;<b><i>Qualquer um pode modificar</b></i>&apos; opção padrão',
    'to' => 'para',
    'settings_upload_maxfilesize_tip' => 'Tamanho máximo de arquivo que você permite. Deve ser coerente com as configurações do seu servidor.',
    'settings_upload_docext_tip' => 'Tipos de documento. Indica as extensões de arquivo permitidas separadas por vírgula (,)',
    'settings_upload_imagesext_tip' => 'Tipos de imagem. Indica as extensões de arquivo permitidas separadas por vírgula (,)',
    'settings_upload_pkgext_tip' => 'Tipos de pacotes. Indica as extensões de arquivo permitidas separadas por vírgula (,)',
    'settings_upload_otherext_tip' => 'Outros tipos. Indica as extensões de arquivo permitidas separadas por vírgula (,)',
    'settings_upload_imageresize_options_tip' => 'Quando ativada, esta opção redimensiona as imagens para um formato indicado logo abaixo.',
    'settings_upload_maxfilesize' => 'Tamanho máximo de arquivo (em MB)',
    'settings_upload_docext' => 'Extensões de documento permitidas',
    'settings_upload_imagesext' => 'Extensões de imagem permitidas',
    'settings_upload_pkgext' => 'Extensões de pacote permitidas',
    'settings_upload_otherext' => 'Outras extensões permitidas',
    'settings_upload_imageresize_options_w' => 'Largura da imagem redimensionada (em pixels)',
    'settings_upload_imageresize_options_h' => 'Altura da imagem redimensionada (em pixels)',
    'settings_upload_imageresize_options_q' => 'Qualidade da imagem redimensionada',
    'settings_importing' => 'Habilitar importação de dados de arquivos CVS/KeyPass',
    'admin_proxy_ip' => 'IP utilizado pelo Proxy',
    'admin_proxy_ip_tip' => '<span style="font-size:11px;max-width:300px;">Se você sua conexão à Internet passa por um Proxy, indique aqui o IP.<br />Deixe vazio se não utilizar Proxy.</span>',
    'admin_proxy_port' => 'Porta utilizada pelo Proxy',
    'admin_proxy_port_tip' => '<span style="font-size:11px;max-width:300px;">Se você definiu um IP para o Proxy',
    'settings_ldap_elusers' => 'Apenas usuários locais do Teampass',
    'settings_ldap_elusers_tip' => 'Este recurso permite que usuários no banco de dados autentiquem via LDAP. Desabilite isso se você quiser buscar em em algum diretório LDAP.',
    'db_items_edited' => 'Itens em edição',
    'item_edition_start_hour' => 'Edição iniciada desde',
    'settings_delay_for_item_edition' => 'Depois de quanto tempo (em minutos) uma edição de Item é considerada como falha',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Ao editar um Item, o Item é bloqueado, de tal modo que nenhuma outra edição paralela possa ser realizada. Uma espécie de token é reservada.<br />Esta configuração permite excluir o token. Se o valor estiver definido em 0, então o token nunca será excluído (A não ser que seja por um Administrador)</span>',
    'db_users_logged' => 'Usuários conectados',
    'action' => 'Ação ',
    'login_time' => 'Conectado desde ',
    'lastname' => 'Último nome ',
    'user_login' => 'Login',
    'role' => 'Papel',
    'error_role_exist' => 'Esse Papel já existe!',
    'error_no_edition_possible_locked' => 'Não é possível editar. No momento, este item está sendo editado por outro usuário.',
    'select' => 'selecione',
    'items' => 'Itens',
    'enable_personal_saltkey_cookie' => 'Habilita SaltKey pessoal ser armazenada em um cookie',
    'personal_saltkey_cookie_duration' => 'Tempo de vida da SaltKey do usuário expira após XX dias',
    'admin_email_smtp_server' => 'Servidor SMTP',
    'admin_email_auth' => 'O servidor SMTP precisa de autenticação?',
    'admin_email_auth_username' => 'Nome de usuário para autenticação',
    'admin_email_auth_pwd' => 'Senha para autenticação',
    'admin_email_port' => 'Porta do servidor',
    'admin_email_from' => 'E-mail do Remetente',
    'admin_email_from_name' => 'Nome do Remetente',
    'admin_email_test_configuration_tip' => 'Este teste deve enviar um e-mail para o endereço indicado. Se você não recebê-lo, por favor, verifique suas credenciais.',
    'admin_email_test_subject' => '[Teampass] E-mail de teste',
    'admin_email_test_body' => 'Olá,<br><br>E-mail enviado com sucesso.<br><br>Felicidades!',
    'admin_email_result_ok' => 'E-mail enviado a #email# ... verifique sua caixa de entrada.',
    'email_bodyalt_item_updated' => 'A senha para #item_label# foi atualizada.',
    'admin_email_send_backlog_tip' => 'Este script permite forçar o envio dos e-mails da base de dados. Isso pode levar algum tempo, dependendo do número de e-mails a serem enviados.',
    'please_wait' => 'Por favor, espere!',
    'admin_path_to_files_folder' => 'Caminho para a pasta Arquivos',
    'admin_path_to_files_folder_tip' => '<span style="font-size:11px;max-width:300px;">A pasta Files é usada para armazenar todos os arquivos gerados pelo TeamPass e alguns arquivos de upload.<br />IMPORTANTE: por questões de segurança esta pasta não pode ser a pasta WWW do seu website. Deverá estar em uma área protegida com uma regra de redirecionamento as configurações do seu servidor.<br />IMPORTANTE 2: É interessante configurar uma tarefa no CRON para periodicamente limpar esta pasta.</span>',
    'admin_path_to_upload_folder_tip' => '<span style="font-size:11px;max-width:300px;">A pasta Upload é utilizada para armazenar todos os arquivos associados aos ítens. <br />IMPORTANTE: por questões de segurança esta pasta não pode ser a pasta WWW do seu website. Deverá estar em uma área protegida com uma regra de redirecionamento as configurações do seu servidor.<br />IMPORTANTE 2: Esta pasta nunca deve ser limpa! Estes arquivos estão associados com os ítens.</span>',
    'pdf_password_warning' => 'Você deve fornecer uma chave de criptografia!',
    'admin_pwd_maximum_length' => 'Comprimento máximo das senhas',
    'admin_pwd_maximum_length_tip' => 'O valor padrão para o comprimento é 40. É importante saber que configurando um valor alto para o comprimento impactará na performance. Na verdade quanto maior este valor, mais tempo o servidor precisa para criptografar e descriptografar, e mostrar as senhas.',
    'settings_insert_manual_entry_item_history' => 'Ativar inserção manual de itens no Log de Histórico',
    'settings_insert_manual_entry_item_history_tip' => 'Por alguma razão você pode precisar adicionar manualmente uma entrada no histórico do Item. Ao ativar este recurso isso é possível.',
    'admin_path_to_upload_folder' => 'Caminho para a pasta Upload',
    'admin_setting_enable_delete_after_consultation' => 'Item consultado pode ser excluído automaticamente',
    'admin_setting_enable_delete_after_consultation_tip' => 'Quando habilitado, o criador do Item pode decider se o Item será automaticamente excluído depois de ser visto X vezes.',
    'at_email' => 'e-mail',
    'enable_email_notification_on_item_shown' => 'Enviar notificação por e-mail aos Administradores quando um Item for exibido',
    'share_sent_ok' => 'O e-mail foi enviado',
    'see_item_title' => 'Detalhes do Item',
    'email_on_open_notification_subject' => '[Teampass] Notificação sobre um item aberto',
    'email_on_open_notification_mail' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>#tp_user# abriu e olhou o Item &apos;#tp_item#&apos;.<br>Clique no <a href="#tp_link#">LINK</a> para acessá-lo.<br><br>Meus cumprimentos. ',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[Teampass] Conta no sistema Teampass',
    'email_new_user_mail' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>Um Administrador criou uma conta para você no Teampass. Senhas seguras para sua organização estão a apenas um clique de distância! <br><br>Você pode usar essas credenciais para entrar:<br>- Conta: #tp_login#<br>- Senha: #tp_pw#<br><br>Clique <a href=#tp_link#>AQUI</a> para acessar.',
    'error_empty_data' => 'Não há dados para prosseguir!',
    'error_not_allowed_to' => 'Você não tem permissão para fazer isso!',
    'request_access_ot_item' => 'Solicitar acesso ao autor',
    'email_request_access_subject' => '[Teampass] Solicitação de acesso a item',
    'email_request_access_mail' => 'Olá #tp_item_author#,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>O usuário #tp_user# solicitou acesso ao item &apos;#tp_item#&apos;.<br><br>A requisição foi enviada com a seguinte justificativa:<br><i>\\&apos;#tp_reason#\\&apos;</i>Certifique-se dos direitos deste usuário antes de permitir o acesso ao Item.<br><br>Até mais!',
    'admin_action_change_salt_key' => 'Alterar a SALT Key principal',
    'nb_items_by_query' => 'Número de ítens por pesquisa ',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Mais itens significa mais tempo para exibir a lista.<br />Defina para &apos;auto&apos; para deixar a ferramenta  adaptar este número, dependendo do tamanho da tela do usuário.<br />Defina para &apos;max&apos; para forçar a exibição da lista completa<br /> Defina um numero para obter a cada consulta.</span> ',
    'open_url_link' => 'Abrir em uma nova página',
    'error_pw_too_long' => 'A senha é muito longa! A quantidade máxima de caracteres é 40.',
    'at_restriction' => 'Restrição',
    'pw_encryption_error' => 'Erro de encriptação da senha!',
    'enable_send_email_on_user_login' => 'Enviar notificação por e-mail aos Administradores quando um Usuário entrar',
    'email_subject_on_user_login' => '[Teampass] Um usuário se conectou',
    'email_body_on_user_login' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>O usuário #tp_user# se conectou ao Teampass em #tp_date# às #tp_time#.<br><br>Atenciosamente.',
    'account_is_locked' => 'Esta conta está bloqueada',
    'activity' => 'Atividade',
    'add_role_tip' => 'Adiciona uma nova função.',
    'admin' => 'Administração',
    'admin_action_db_backup' => 'Criar um backup do banco de dados',
    'admin_action_db_clean_items' => 'Remover itens órfãos do banco de dados',
    'admin_action_db_clean_items_tip' => 'Isso excluirá apenas aqueles itens e registros associados que não foram excluídos após a pasta associada ser excluída. É sugerido criar um backup antes.',
    'admin_action_db_optimize' => 'Otimizar o banco de dados',
    'admin_action_db_restore' => 'Restaurar o banco de dados',
    'admin_action_purge_old_files' => 'Excluir arquivos temporários antigos',
    'admin_action_purge_old_files_tip' => 'Isso excluirá todos os arquivos temporários mais antigos do que 7 dias.',
    'admin_action_reload_cache_table' => 'Recarregar cache da tabela',
    'admin_action_reload_cache_table_tip' => 'Recria o cache de itens. Pode corrigir problemas ao exibir ou salvar itens de senha.',
    'admin_help' => 'Ajuda',
    'admin_ldap_configuration' => 'Configuração LDAP',
    'admin_main' => 'Informações',
    'admin_misc_cpassman_dir' => 'Caminho completo do Teampass',
    'admin_misc_cpassman_url' => 'URL completa do Teampass',
    'admin_misc_custom_login_text' => 'Texto personalizado de Login',
    'admin_misc_custom_logo' => 'URL completa da Logo personalizada de Login',
    'admin_misc_favicon' => 'URL completa para o arquivo favicon',
    'admin_settings' => 'Configurações',
    'admin_settings_title' => 'Configurações do Teampass',
    'admin_setting_activate_expiration' => 'Habilitar expiração de senhas',
    'admin_setting_activate_expiration_tip' => 'Quando habilitado, itens expirados não serão mostrados aos usuários.',
    'admin_views' => 'Visualizações',
    'alert_message_done' => 'Pronto!',
    'all' => 'tudo ',
    'anyone_can_modify' => 'Permitir este item ser modificado por qualquer pessoa que pode acessá-lo',
    'at' => 'no',
    'at_category' => 'Pasta',
    'at_copy' => 'Cópias',
    'at_delete' => 'Exclusão',
    'at_description' => 'Descrição.',
    'at_label' => 'Título',
    'at_login' => 'Login',
    'at_moved' => 'Movido',
    'at_personnel' => 'Pessoal',
    'at_restored' => 'Restaurado',
    'at_shown' => 'Acessado',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Pastas permitidas',
    'auth_creation_without_complexity' => 'Permitir a criação de um Item sem respeitar a complexidade de senha necessária',
    'auth_modification_without_complexity' => 'Permitir a modificação de um Item sem respeitar a complexidade de senha necessária',
    'cancel' => 'Cancelar',
    'can_create_root_folder' => 'Pode criar pastas no nível raiz',
    'changelog' => 'Últimas notícias',
    'close' => 'Fechar',
    'complexity' => 'Complexidade',
    'complex_asked' => 'Complexidade necessária',
    'complex_level0' => 'Muito fraco',
    'complex_level1' => 'Fraco',
    'complex_level2' => 'Médio',
    'complex_level3' => 'Forte',
    'complex_level4' => 'Muito forte',
    'complex_level5' => 'Pesado',
    'complex_level6' => 'Muito pesado',
    'confirm' => 'Confirmar',
    'confirm_del_from_fav' => 'Por favor, confirme a exclusão dos Favoritos',
    'connections' => 'Conexões',
    'copy' => 'Copiar',
    'copy_to_clipboard_small_icons' => 'Habilitar ícone <i>Copiar para a área de transferência</i> na página dos itens',
    'copy_to_clipboard_small_icons_tip' => '<span style = "font-size: 11px; max-width: 300px;"> Isto pode ajudar a prevenir o uso de memória, se os usuários não têm computador recente <br /> Na verdade, a área de transferência não está carregado com informações.. Mas nenhuma cópia rápida de senha e login é possível. </span>',
    'date' => 'Data',
    'date_format' => 'Formato de data',
    'delete' => 'Excluir',
    'deletion' => 'Exclusões',
    'del_button' => 'Excluir',
    'description' => 'Descrição',
    'disconnect' => 'Sair',
    'done' => 'Pronto',
    'duplicate_folder' => 'Autorizar várias pastas com o mesmo nome',
    'duplicate_item' => 'Autorizar vários itens com o mesmo nome',
    'email' => 'E-mail',
    'email_subject' => 'Criação de um novo Item no Gerenciador de Senhas',
    'enable_favourites' => 'Habilitar os usuários a armazenar Favoritos',
    'enable_personal_folder' => 'Habilitar pasta pesssoal',
    'enable_personal_folder_feature' => 'Habilitar recurso pasta pessoal',
    'enable_user_can_create_folders' => 'O usuários são permitidos a gerenciar pastas em pastas pais permitidas',
    'encrypt_key' => 'Chave de criptografia',
    'errors' => 'Erros',
    'error_group_exist' => 'Esta pasta já existe!',
    'error_html_codes' => 'Alguns textos contêm códigos em HTML! Isto não é permitido.',
    'error_item_exists' => 'Este Item já existe!',
    'error_label' => 'O título é obrigatório!',
    'error_must_enter_all_fields' => 'Você deve preencher todos os campos!',
    'error_pw' => 'A senha é obrigatória!',
    'error_tags' => 'Não é permitido pontuação nas TAGS! Apenas espaço.',
    'error_user_exists' => 'O usuário já existe',
    'expiration_date' => 'Data de expiração',
    'find' => 'Pesquisar',
    'forbidden_groups' => 'Pastas proibidas',
    'forgot_my_pw_email_sent' => 'O e-mail foi enviado',
    'functions' => 'Papéis',
    'gestionnaire' => 'Gerente',
    'god' => 'Administrador',
    'group' => 'Pasta',
    'group_parent' => 'Pasta pai',
    'group_pw_duration' => 'Período de renovação',
    'group_pw_duration_tip' => 'Em meses. Use 0 para desabilitar.',
    'history' => 'Histórico',
    'home_personal_saltkey' => 'Sua SaltKey pessoal',
    'home_personal_saltkey_label' => 'Insira sua SaltKey pessoal',
    'import_error_no_read_possible' => 'Não é possível ler o arquivo!',
    'import_error_no_read_possible_kp' => 'Não é possível ler o arquivo! É preciso que seja um arquivo KeePass.',
    'import_keepass_to_folder' => 'Selecione a pasta de destino',
    'index_add_one_hour' => 'Estender tempo de sessão',
    'index_change_pw_confirmation' => 'Confirmar',
    'index_expiration_in' => 'Tempo de expiração da sessão',
    'index_get_identified' => 'Por favor, identifique-se',
    'index_last_pw_change' => 'Senha alterada em',
    'index_last_seen' => 'Última conexão em',
    'index_login' => 'Conta',
    'index_new_pw' => 'Nova senha',
    'index_password' => 'Senha',
    'index_pw_error_identical' => 'As senhas devem ser iguais',
    'index_pw_level_txt' => 'Complexidade',
    'index_session_duration' => 'Duração da sessão',
    'info' => 'Informações',
    'item_menu_copy_login' => 'Copiar login',
    'item_menu_copy_pw' => 'Copiar senha',
    'item_menu_del_from_fav' => 'Excluir dos Favoritos',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de Conhecimento',
    'last_items_title' => 'Últimos itens vistos',
    'ldap_extension_not_loaded' => 'A extensão LDAP não está ativada no servidor.',
    'level' => 'Nível',
    'login' => 'Login',
    'mask_pw' => 'Esconder/Mostrar a senha',
    'max_last_items' => 'Número máximo de últimos itens vistos pelo usuário (o padrão é 10)',
    'minutes' => 'minutos',
    'name' => 'Nome',
    'nb_false_login_attempts' => 'Número de tentativas de login fracassadas antes de a conta ser bloqueada (0 para desabilitar)',
    'nb_folders' => 'Número de Pastas',
    'nb_items' => 'Número de Itens',
    'new_label' => 'Novo título',
    'no' => 'Não',
    'none' => 'Nenhum',
    'none_selected_text' => 'Nenhum selecionado',
    'not_allowed_to_see_pw' => 'Você não tem permissão para ver esse Item!',
    'not_allowed_to_see_pw_is_expired' => 'Este item expirou!',
    'not_defined' => 'Não definido',
    'number_of_used_pw' => 'Número de novas senhas que um usuário tem que utilizar antes de reutilizar uma senha antiga.',
    'pages' => 'Páginas',
    'pdf_download' => 'Baixar arquivo',
    'personal_salt_key' => 'Sua SaltKey pessoal',
    'pw' => 'Senha',
    'pw_generate' => 'Gerar',
    'pw_is_expired_-_update_it' => 'Este item expirou! Você precisa alterá-lo.',
    'pw_life_duration' => 'Tempo de duração da senha do usuário antes de expirar (em dias, 0 para desabilitar)',
    'readme_open' => 'Abrir arquivo leia-me completo',
    'read_only_account' => 'Somente Leitura',
    'restore' => 'Restaurar',
    'restricted_to' => 'Restrito a',
    'restricted_to_roles' => 'Permite restringir itens a Usuários e Papéis',
    'root' => 'Raiz',
    'secure' => 'Seguro',
    'see_logs' => 'Ver logs',
    'settings_anyone_can_modify' => 'Ativar uma opção em cada item que permite qualquer um modificá-lo',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">Quando ativado, isso adicionará uma caixa de seleção no formulário do item que permite ao criador pemitir a modificação deste item por qualquer pessoa.</span> ',
    'settings_default_language' => 'Definir o Idioma Padrão',
    'settings_kb' => 'Habilitar a Base de Conhecimento (beta)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Quando ativado, isso adicionará uma página em que é possível construir sua base de conhecimento.</span> ',
    'settings_ldap_domain' => 'Sufixo de conta LDAP para seu domínio',
    'settings_ldap_domain_controler' => 'Lista de controladores de domínio LDAP',
    'settings_ldap_domain_controler_tip' => 'Especifique múltiplos controladores se você quiser balancear as consultas LDAP entre vários servidores. Você deve delimitar os domínios com uma vírgula (,). Por exemplo: dominio_1,dominio_2,dominio_3',
    'settings_ldap_domain_dn' => 'LDAP BASE DN do seu domínio ',
    'settings_ldap_mode' => 'Habilitar autenticação de usuários através de servidor LDAP',
    'settings_ldap_mode_tip' => 'Habilite apenas se você tiver um servidor LDAP e quiser usá-lo para autenticar os usuários através dele.',
    'settings_ldap_ssl' => 'Use LDAP sobre SSL (LDAPS)',
    'settings_ldap_tls' => 'Use LDAP sobre TLS',
    'settings_log_accessed' => 'Habilitar o registro de quem acessou os itens',
    'settings_log_connections' => 'Habilitar o registro de todas as conexões de usuário no banco de dados.',
    'settings_maintenance_mode' => 'Ativar o modo de Manutenção do Teampass',
    'settings_manager_edit' => 'Gerentes podem editar e excluir Itens que eles podem ver',
    'settings_printing' => 'Habilitar exportação de itens para um arquivo PDF ou CSV',
    'settings_printing_tip' => 'Quando habilitado, será adicionado na página inicial do usuário um botão que lhe permitirá salvar uma lista de itens que ele pode visualizar em um arquivo PDF. Note que as senhas listadas estarão descriptografadas.',
    'settings_restricted_to' => 'Habilitar a funcionalidade <i>Restrito a</i> nos itens',
    'settings_show_description' => 'Mostrar Descrição na lista de Itens',
    'size' => 'Tamanho',
    'tags' => 'Etiquetas',
    'timezone_selection' => 'Seleção de Timezone',
    'time_format' => 'Formato de hora',
    'url' => 'URL',
    'user' => 'Usuário',
    'users_online' => 'usuários online',
    'user_alarm_no_function' => 'Este usuário não tem Papéis!',
    'yes' => 'Sim',
    'one_time_view_item_url_box' => 'Compartilhar o One-Time URL com uma pessoa de confiança <br><br>#URL#<br><br>Lembre que este link estará visível apenas uma vez até o dia #DAY# ',
    'settings_api' => 'Habilitar acesso ao Itens do Teampass através de API',
    'settings_api_tip' => 'Acesso API permite fazer acesso aos itens por aplicações de terceiros em formato JSON.',
    'settings_api_keys_list' => 'Lista de Chaves',
    'settings_api_keys_list_tip' => 'Isto são as chaves que estão permitidas a acessar o Teampass. Sem uma chave válida, o acesso não é possível. Você deve compartilhar essas chaves cuidadosamente!',
    'settings_api_key' => 'Chave',
    'settings_api_add_ip' => 'Adicionar novo IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Nova subpasta herda permissões da pasta pai',
    'subfolder_rights_as_parent_tip' => 'Quando esse recurso está desabilitado, cada nova subpasta herda as permissões associadas aos papéis do criador. Se habilitada, então cada nova subpasta herda as permissões da pasta pai.',
    'show_only_accessible_folders_tip' => 'Por padrão, o usuário vê o caminho completo da árvore mesmo se ele não tem acesso a todas as pastas. Você pode simplificar isso removendo da árvore as pastas que ele não tem acesso.',
    'show_only_accessible_folders' => 'Simplificar a árvores de Itens removendo as Pastas que o usuário não tem acesso.',
    'comment' => 'Comentar',
    'suggestion_menu' => 'Sugestões',
    'settings_suggestion' => 'Habilitar sugestão de itens para usuários somente-leitura',
    'settings_suggestion_tip' => 'A sugestão de itens permite que os usuários somente-leitura proponham novos itens ou a modificação de itens existentes. Essa sugestões serão validadas pelo Administrador ou Gerenciador de usuários.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'Ldap Bind Dn',
    'settings_ldap_bind_passwd' => 'Ldap Bind Passwd',
    'settings_ldap_search_base' => 'Ldap Search Base ',
    'settings_ldap_bind_dn_tip' => 'Uma BIND DN que possa os usuários possam ser localizados na árvore do domínio ',
    'settings_ldap_bind_passwd_tip' => 'Senha DN para ingressar no servidor LDAP para procurar os usuários.',
    'settings_ldap_search_base_tip' => 'Buscar na raiz do domínio para buscas na árvore ',
    'admin_email_server_url' => 'URL do servidor para os links nos e-mails',
    'enable_email_notification_on_user_pw_change' => 'Enviar notificação por e-mail ao Usuário quando sua senha for alterada',
    'settings_otv_expiration_period' => 'Tempo para expiração (em dias) dos itens compartilhados como Visualização-Única (OTV)',
    'write' => 'Escrita',
    'read' => 'Leitura',
    'no_access' => 'Sem acesso',
    'right_types_label' => 'Selecione o tipo de acesso nesta pasta para o grupo de usuários selecionado',
    'duplicate_item_in_folder' => 'Permitir itens com nome similar em uma pasta comum',
    'settings_roles_allowed_to_print' => 'Definir os Papéis permitidos a exportar itens (seleção múltipla)',
    'settings_roles_allowed_to_print_tip' => 'Selecione múltiplos Papéis mantendo CTRL pressionado enquanto seleciona. Membros desses Papéis poderão exportar Pastas para CSV ou PDF se a exportação estiver habilitada globalmente.',
    'admin_email_security' => 'Segurança do SMTP',
    'alert_page_will_reload' => 'A página será recarregada agora',
    'file_protection_password' => 'Definir senha do arquivo',
    'expand' => 'Expandir',
    'collapse' => 'Recolher ',
    'settings_ldap_user_attribute' => 'Atributo Usuário para pesquisar',
    'settings_ldap_user_attribute_tip' => 'Atributo LDAP utilizado para procurar usuários ',
    'log_user_initial_pwd_changed' => 'Senha inicial definida',
    'log_user_email_changed' => 'E-mail do usuário alterado para ',
    'log_user_created' => 'Conta de usuário criada',
    'log_user_locked' => 'O usuário foi bloqueado',
    'log_user_unlocked' => 'O usuário foi desbloqueado',
    'log_user_pwd_changed' => 'A senha do usuário foi alterada',
    'settings_default_session_expiration_time' => 'Tempo padrão para expiração de sessão (minutos)',
    'settings_duo' => 'Habilitar DUO Security como autenticação de dois fatores',
    'settings_duo_tip' => 'Autenticação 2-Factor pode ser assegurada utilizando DUOSecurity.com. Esta biblioteca garante um alto nível de segurança  na autenticação do usuário.',
    'admin_duo_akey' => 'AKEY ',
    'admin_duo_ikey' => 'IKEY ',
    'admin_duo_skey' => 'SKEY ',
    'admin_duo_host' => 'Servidor',
    'settings_duo_explanation' => 'Essas credenciais são emitidas a partir do aplicativo web, criadas especialmente para Teampass partir da página de administração DUOSecurity. <br /> Ao clicar no botão salvar será armazenado no arquivo sk.php.',
    'admin_duo_intro' => 'Preencha os próximos campos com os dados esperados.',
    'edit' => 'Editar',
    'user_info_locked' => 'Usuário está atualmente BLOQUEADO.',
    'user_info_unlock_question' => 'Desbloquear conta?',
    'user_info_lock_question' => 'Bloquear conta?',
    'user_info_delete_question' => 'Apagar conta?',
    'user_info_active' => 'Usuário está atualmente ATIVADO.',
    'refresh' => 'Atualizar',
    'loading' => 'Carregando',
    'searching' => 'Buscando... ',
    'list_items_with_tag' => 'Listar os ítens com esta tag ',
    'no_item_to_display' => 'Sem ítens para mostrar ',
    'opening_folder' => 'Lendo a pasta ... ',
    'suggestion_notify_subject' => '[Teampass] Uma nova sugestão foi feita. ',
    'suggestion_notify_body' => 'Olá,<br><br>Uma nova sugestão foi concluída. Você precisa validar antes que ela possa ser utilizada por outros usuários <br> Algum informações sobre: <br>- Etiqueta: #tp_label#<br>- Pasta: #tp_folder#<br>- Usuário: #tp_user#<br><br>Observe que este email foi enviado a todos os gestores.<br><br> Cumprimentos.',
    'error_unknown' => 'Ocorreu um erro inesperado! ',
    'no_edit' => 'Escrever mas não editar',
    'role_cannot_edit_item' => 'Não é possível editar Itens',
    'no_delete' => 'Escrever mas não deletar',
    'role_cannot_delete_item' => 'Não é possível deletar itens',
    'my_profile' => 'Meu Perfil',
    'starting' => 'Iniciando ... ',
    'total_number_of_items' => 'Número total de itens ',
    'finalizing' => 'Finalizando ',
    'treating_items' => 'Processando itens ',
    'number_of_items_treated' => 'Número de itens processados ',
    'error_sent_back' => 'Próximo erro ',
    'full' => 'Completa',
    'sequential' => 'Sequencial ',
    'tree_load_strategy' => 'Estratégia de carregamento da árvore ',
    'syslog_enable' => 'Habilitar log remoto com <i>Syslog</i>',
    'syslog_host' => 'Servidor Syslog',
    'syslog_port' => 'Porta Syslog',
    'error_bad_credentials' => 'As credenciais de login não correspondem! ',
    'settings_ldap_usergroup' => 'Grupo de pesquisa LDAP',
    'settings_ldap_usergroup_tip' => 'Entre com o grupo de LDAP no diretório onde os logins de usuários autorizados estão armazenados. Exemplo: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Habilitar alteração de senha em um servidor remoto (utilizando conexão SSH)',
    'update_server_password' => 'Atualizar senha do servidor',
    'ssh_pwd' => 'Senha SSH',
    'ssh_user' => 'Usuário SSH',
    'ssh_password_frequency_change_info' => 'Selecione o intervalo entre o servidor de atualização de senhas automáticas (Selecionando 0 será desabilitado a troca automática de senhas) .<br />Atualizações automáticas de senhas serão realizadas apenas se o administrador do sistema tiver configurado e programado a funcionalidade de trabalho cron',
    'ssh_password_frequency_change' => 'Frequência de alteração de senha (em meses)',
    'ssh_scheduled_change' => 'Mudança programada',
    'ssh_one_shot_change' => 'Mudança única',
    'server_password_change_enable_tip' => 'Essa configuração adiciona uma opção no item senha para trocar automaticamente a senha de usuário em um endereço de servidor listado na url. Isso requer um servidor UNIX remoto para permitir login de um usuário e senha via SSH. Programar mudanças automáticas podem ser realizadas após adicionar <i>/files/script.ssh.php</i> para a crontab para executar uma vez por dia o webserver de gerenciador de senhas',
    'error_bad_credentials_more_than_3_times' => 'Credenciais de login incorretos!<br>Por favor, aguarde 10 segundos antes da próxima tentativa',
    'settings_ldap_object_class' => 'Classe de pesquisa',
    'settings_ldap_object_class_tip' => 'A classe de pesquisa do LDAP deve conter uma conta de usuário ou uma conta POSIX',
    'rebuild_config_file' => 'Recriar o arquivo de configuração',
    'rebuild_config_file_tip' => 'O arquivo de configuração contem variáveis do sistema e são usados quando essas configuração são necessárias depois da conexão ao banco de dados foi estabelecida. Recriar o arquivo de configuração salva os valores do banco de dados no arquivo, e pode ser feito a qualquer momento. A localização padrão é ./includes/config/tp.config.php, mas o arquivo pode estar localizado fora diretório www por segurança.',
    'error_folder_complexity_lower_than_top_folder' => 'Subpastas devem ter complexidade de senha igual ou superior a pastas pai',
    'new_item_email_body' => 'Olá, <br /><br />Um novo item &apos;#label&apos; foi criado no Teampass.<br />Você pode acessá-lo clicando no link <a href=#link#>LINK</a>.<br/><br />Atenciosamente',
    'failed_logins' => 'Falhas de Login',
    'error_only_numbers_in_folder_name' => 'O rotulo da pasta não pode ser apenas um número. Por favor de a sua pasta um nome que inclua letras',
    'encrypted_data' => 'Dados encriptados no banco de dados.',
    'settings_ldap_port' => 'Porta LDAP',
    'user_profile_agses_card_id' => 'Seu AGSES ID',
    'ga_flash_qr_and_login' => 'Leia este QR code com o seu dispositivo móvel, insira o código de autenticação 2FA e clique no botão de Entrar.',
    'i_need_to_generate_new_ga_code' => 'Eu preciso de um novo QR code. Por favor me envie um código temporário por email.',
    'settings_manager_move_item' => 'Gerentes podem mover qualquer item que ele possa visualizar',
    'user_folders_rights' => 'Pastas visíveis',
    'create_item_without_password' => 'Permitir que um item seja criado sem senha definida',
    'share_rights_info' => 'Esta opção permite compartilhar permissões de um usuário à usuários selecionados.<br>Ressalte-se que os usuários selecionados terão suas permissões resetadas e substituídas pelas do usuário de origem.',
    'share_rights_source' => 'Usuário de origem',
    'share_rights_destination' => 'Usuários de destino',
    'ga_reset_by_user' => 'Usuário pode redefinir seu código 2FA',
    'ga_reset_by_user_tip' => 'Se habilitado, o usuário poderá redefinir seu código 2FA usando um link na página de login. Este recurso é útil no caso do usuário ter mudado de dispositivo móvel, por exemplo. Se estiver desabilitado, o usuário terá que solicitar um novo código 2FA ao Administrador.',
    'enable_massive_move_delete' => 'Permitir que o usuário execute múltiplas operações de Mover e Remover itens',
    'enable_massive_move_delete_tip' => 'Quando habilitada, esta opção Permite que o usuário execute múltiplas operações Mover e Remover itens de uma vez. O usuário só será permitido realizar esta operação nos itens que ele tem permissão.',
    'mass_operation' => 'Operação em massa nos itens',
    'move_items' => 'Mover itens selecionados',
    'delete_items' => 'Excluir itens selecionados',
    'you_decided_to_move_items' => 'Você escolheu mover itens',
    'you_decided_to_delete_items' => 'Você escolheu excluir itens',
    'suggest_password_change' => 'Sugerir alteração de senha',
    'otv_is_enabled' => 'Usuários podem criar links de Visualização-Única (OTV)',
    'error_source_and_destination_are_equal' => 'Origem e destino não podem ser o mesmo',
    'sending_anonymous_statistics' => 'Enviando estatísticas anônimas',
    'favourites_option_enabled' => 'Opção "Favoritos" habilitada',
    'personalfolders_option_enabled' => 'Opção Pastas Pessoais habilitada',
    'country_statistics' => 'Utilização no mundo',
    'country' => 'País',
    'users_statistics' => 'Média de usuários por instância',
    'items_all' => 'Todos os itens',
    'folders_all' => 'Todas as pastas',
    'items_shared' => 'Todos os itens compartilhados (exceto os pessoais)',
    'folders_shared' => 'Todos as pastas compartilhadas (exceto as pessoais)',
    'items_statistics' => 'Média de itens por instância',
    'folders_statistics' => 'Média de pastas por instância',
    'administrators_number' => 'Quantidade de administradores',
    'administrators_number_statistics' => 'Média de administradores por instância',
    'managers_number' => 'Quantidade de usuários Gerentes',
    'managers_number_statistics' => 'Média de Gerentes por instância',
    'readonly_number_statistics' => 'Quantidade média de usuários somente-leitura por instância',
    'readonly_number' => 'Quantidade de usuários somente-leitura',
    'mysql_version' => 'Versão do MySQL',
    'php_version' => 'Versão do PHP',
    'teampass_version' => 'Versão do Teampass',
    'languages_used' => 'Linguagens utilizadas',
    'languages_statistics' => 'Linguagem mais utilizada',
    'kb_option_enabled' => 'Opção de Base de Conhecimento habilitada',
    'suggestion_option_enabled' => 'Opção de sugestão habilitada',
    'customfields_option_enabled' => 'Opção de campos customizados habilitada',
    'api_option_enabled' => 'Opção de API habilitada',
    '2fa_option_enabled' => 'Opção de autenticação 2FA habilitada',
    'agses_option_enabled' => 'Opção AGSES habilitada',
    'duo_option_enabled' => 'Opção DUO Security habilitada',
    'ldap_option_enabled' => 'Opção LDAP habilitada',
    'syslog_option_enabled' => 'Opção SYSLOG habilitada',
    'stricthttps_option_enabled' => 'Restrição à HTTPS habilitada',
    'characteristic' => 'Característica',
    'current_value' => 'Valor atual',
    'communication_means' => 'Meios de comunicação',
    'consider_a_donation' => 'Considere fazer uma doação',
    'more_information' => 'Mais informações',
    'feature_request_canal' => 'Para solicitar novas funcionalidades, por favor utilize',
    'bug_canal' => 'Para avisos de bugs, por favor utilize',
    'documentation_canal' => 'Documentação completa em',
    'sending_anonymous_statistics_details' => 'As estatísticas são necessárias para melhorar o Teampass com dados de utilização. As informações fornecidas serão utilizadas somente internamente e não serão comercializadas.',
    'item_has_change_proposal' => 'Este item tem uma proposta de mudança',
    'check_data_after_reencryption' => 'Por favor verifique os dados. Uma nova tabela <b>Backup</b> foi criada durante este processo possibilitando reverter quando necessário.',
    'revert' => 'Reverter?',
    'revert_the_database' => 'Você decidiu reverter o banco de dado',
    'bad_psk' => 'A SaltKey pessoal não está correta!',
    'ldap_test_config' => 'Testar a configuração atual',
    'ldap_test_username' => 'Usuário para teste LDAP',
    'ldap_test_username_pwd' => 'Senha do usuário',
    'feature_support_canal' => 'Para suporte e ajuda, por favor utilize',
    'category' => 'Categoria',
    'text' => 'Texto',
    'type' => 'Tipo',
    'data_is_masked' => 'O dado é Oculto',
    'at_export' => 'Exportar',
    'settings_ldap_allowed_usergroup' => 'Grupo de usuários do LDAP permitido',
    'settings_ldap_allowed_usergroup_tip' => 'Indique o grupo permitido a conectar ao Teampass. Se estiver em branco não haverá restrições de acesso a grupos.',
    'error_security_level_not_reached' => 'O nível de segurança esperado não foi alcançado!',
    'personal_saltkey_security_level' => 'Nível mínimo de segurança da chave SaltKey pessoal',
    'settings_disable_forgot_password_link' => 'Esconder a opção de Recuperar a senha na Home Page',
    'newly_created_user_is_administrated_by' => 'O usuário criado é administrado por',
    'settings_ldap_and_local_authentication' => 'Usuários locais e do LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Habilite esta opção para permitir a autenticação tanto dos usuários LDAP quanto dos usuários locais do Teampass.',
    'enable_http_request_login' => 'Login automático usando credenciais de cabeçalho HTTP',
    'duration_login_attempt' => 'Segundos até o login automático:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Selecione o nível de depuração',
    'email_debug_client' => 'Comandos de cliente',
    'email_debug_server' => 'Comandos de cliente e respostas do servidor',
    'email_debug_connection' => 'Comandos de cliente, respostas do servidor e status da conexão',
    'email_debug_low_level' => 'Saída de baixo nível, todas as mensagens',
    'email_debug_level_usage' => 'Essa configuração deve ser definida para None (Nenhuma). Somente para ser usada para depuração de e-mail para fins de teste. Quando habilitada, ela permite exibir a saída dos comandos de e-mail.',
    'email_body_temporary_login_password' => 'Olá,<br><br>Este é um e-mail gerado pelo gerenciador de senhas Teampass.<br><br>Um Administrador alterou sua senha de acesso ao Teampass. Na próxima vez que você acessar ao Teampass, use a senha a seguir:<br><br><b>#enc_code#</b><br><br><br>Atenciosamente',
    'your_new_password' => 'Sua nova senh',
    'user_specific_right' => 'Direitos específicos de usuário',
    'icon' => 'Ícone',
    'icon_on_selection' => 'Ícone na seleção',
    'fontawesome_icon_tip' => 'Você pode especificar um código de ícone Font Awesome disponível em Free and Solid icons (em inglês). Deixe em branco para usar o ícone padrão.',
    'settings_api_token_duration' => 'Delay de expiração de token JWT (em segundos)',
    'settings_api_token_duration_tip' => 'Delay durante o qual o token JWT gerado é válido. Após esse tempo, é requisitado o envio de uma requisição POST de autorização para a API.',
    'show_encryption_code_to_admin' => 'Esse é o código de criptografia que o usuário precisará para acessar o Teampass. Você solicitou vê-lo. Por favor, copie e compartilhe o código através de um meio seguro. O código é',
    'previous_password' => 'A senha anterior usada para acessar o Teampass',
    'generate_new_otp' => 'Gerar novo OTP',
    'generate_new_otp_informations' => 'Essa operação consiste em gerar todas as chaves para o usuário selecionado. Consequentemente, o usuário precisará informar o novo OTP no próximo login.',
    'html' => 'html',
    'execution_time' => 'Tempo de execução',
    'maximum_number_of_items_to_treat' => 'Número máximos de itens a serem tratados em um único ciclo',
    'maximum_number_of_items_to_treat_tip' => 'De forma a garantir que o script seja executado em sua totalidade antes de alcançar o tempo limite, é possível definir um valor personalizado.',
    'maximum_time_script_allowed_to_run' => 'Duranção em segundos permitidos para a execução de scripts em segundo-plano',
    'maximum_time_script_allowed_to_run_tip' => 'Por padrão, scripts PHP não podem executar mais tempo do que a duração definida no parâmetro max_execution_time no arquivo php.ini. O objetivo aqui é definir um valor maior para garantir que esse script seja executado em sua totalidade.',
    'refresh_data_every_on_screen' => 'Tempo de atualização de tela (em segundos)',
    'refresh_data_every_on_screen_tip' => 'Quando navegando através da visão de tarefas, essa opção permite atualizar a lista.',
    'refreshed' => 'Atualizado',
    'process_details' => 'Detalhes do processo',
    'created_at' => 'Criado em',
    'updated_at' => 'Atualizado em',
    'finished_at' => 'Finalizado em',
    'tasks_manager' => 'Gerenciador de tarefas',
    'tasks' => 'Tarefas',
    'task_in_progress_user_not_active' => 'Tarefas em progresso - Usuário não ativo',
    'enable_tasks_manager' => 'Habilitar tarefas demoradas a serem executadas pelo gerenciador cron',
    'enable_tasks_manager_tip' => 'Essa opção deve ser habilitada se você notar que algumas tarefas estão levando muito tempo para serem concluídas. Isso permite que você execute essas tarefas em segundo-plano através do gerenciador cron do servidor. Consulte a documentação para obter mais informações.',
    'sync_new_ldap_password' => 'Sincronizar nova senha',
    'error_new_ldap_password_detected' => 'Parece que sua senha foi alterada e o Teampass requer sua nova senha para encriptar sua chave privada.',
    'settings_ldap_tls_certifacte_check' => 'Validação de certificado TLS do LDAP',
    'settings_ldap_tls_certifacte_check_tip' => 'Especifica a estratégia de validação de certificado. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Mais informações</a> (em inglês).',
    'user_keys_management' => 'Gerenciamento de chaves de usuário',
    'sending_emails' => 'Enviando e-mails',
    'task_frequency' => 'Frequência (em minutos)',
    'tasks_information' => 'A tarefa depende de um trabalho cron dedicado. Para isso, é necessário adicionar uma nova entrada ao seu crontab para executar o agendador do TeamPass a cada minuto.<br>A entrada a seguir deve ser adicionada:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Nota: por favor, adapte o caminho para o executável do PHP (na maioria dos casos, ele pode ser substituído por <code>php</code>).',
    'bad_duo_mfa' => 'Código DUO inválido',
    'creation_date' => 'Data de criação',
    'never' => 'Nunca',
    'loading_main_page' => 'Por favor, aguarde. Carregando página inicial ...',
    'alert_session_not_consistent' => 'A sessão atual não é consistente e precisa ser atualizada. A página será recarregada.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'Você não tem permissão para autent.',
    'enable_tasks_log' => 'Habilitar log do cron job',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Estatísticas de itens e pastas',
    'item_copying' => 'O item está sendo copiado',
    'upgrade_requested' => 'BD do Teampass não está atualizado.',
    'upgrade_requested_more' => 'Algumas inconsistências foram identificadas entre os arquivos e a configuração. Seu adm deve exec. o processo de atualização antes de continuar.',
    'settings_ldap_group_object_filter' => 'Filtro de objeto de grupo LDAP',
    'settings_ldap_group_object_filter_tip' => 'Filtro LDAP a ser usado para localizar o objeto de grupo. Por exemplo: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'Funções de usuário AD mapeadas com seus grupos AD',
    'settings_ad_users_with_ad_groups_tip' => 'Funções de usuário AD mapeadas com seus grupos AD',
    'settings_ad_user_auto_creation' => 'Usuário AD para ser criado automaticamente',
    'settings_ad_user_auto_creation_tip' => 'Permite que um usuário do AD seja criado automaticamente no Teampass quando ele fizer login pela primeira vez. Observe que, se as funções de usuário AD da opção forem mapeadas com seus grupos AD ativados, ele obterá as funções mapeadas com seus grupos AD.',
    'settings_ldap_guid_attibute' => 'Atributo GUID do LDAP',
    'settings_ldap_guid_attibute_tip' => 'Atributo LDAP a ser usado para identificar o GUID de um objeto. Por exemplo: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'Grupo do AD',
    'mapped_with_role' => 'Mapeado com função',
    'ad_groupe_and_roles_mapping' => 'Grupo AD e mapeamento de funções',
    'select_adgroup_mapping' => 'Selecione a função para mapear com o grupo AD atual',
    'enable_backlog_mail' => 'Habilitar o envio de e-mails de lista de pendências',
    'provide_label' => 'Forneça um rótulo',
    'uploading' => 'Fazendo o Upload...',
    'keys_encryption_not_ready' => 'Suas chaves de senha estão em processo de criação. Aguarde mais alguns minutos.',
    'account_not_ready' => 'Criando conta...',
    'add_new_job' => 'Adicionar nova tarefa (cron)...',
    'tasks_cron_not_running' => 'A tarefa do cron não está definida. Edite o crontab com o usuário do seu servidor (geralmente www-data) com o comando <code>crontab -u www-data -e</code>.<br>Ou pressione o botão para tentar criá-lo automaticamente.',
    'tasks_cron_running' => 'O trabalho do cron (tarefa) está definido corretamente',
    'currently_using_version' => 'Versão atual carregada',
    'git_commit_value' => 'Valor do "Git commit"',
    'generate_new_keys' => 'Gerar novas chaves',
    'generate_new_keys_info' => 'Ao continuar, você gerará novas chaves de criptografia para todos os objetos aos quais tem acesso. Isso só deve ser feito se você não tiver senha mostrada',
    'generate_new_keys_end' => 'O processo está em andamento em segundo plano e pode levar vários minutos. Já pode fechar esta janela.',
    'confirm_password' => 'Precisamos que você confirme sua senha.',
    'no_code_is_requested' => 'Nenhum código é solicitado.',
    'user_encryption_ongoing' => 'A conta está sendo criptografada no momento. Sua solicitação não pode continuar. Aguarde até que isso seja concluído.',
    'teampass_information' => 'Informações do Teampass',
    'show_password' => 'Mostrar Senha',
    'new_user_info_by_mail' => 'New user will receive an email with his credentials',
    'login_credentials' => 'Login credentials',
    'email_body_user_config_1' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following password is expected next time using Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Your Teampass account is fully ready.<br><br>Cheers',
    'email_body_user_config_5' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Keys encryption is now finished. Following code is expected next time using Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Hello #lastname#,<br><br>This is a generated email from Teampass passwords manager.<br><br>Following credentials are expected next time using Teampass:<ul><li>login: #login#</li><li>Password: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Data is not valid',

);
