<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      spanish.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2025 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Mostrar código de cifrado del usuario',
    'email_body_new_user' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Un administrador ha creado para ti una cuenta de usuario en Teampass. La próxima vez que te conectes a Teampass, utiliza las siguientes credenciales:<ul><li>login: #login#</li><li>Contraseña: #password#</li><li>Código de cifrado: #code#</li></ul><br><br><br>Saludos',
    'user_password' => 'Contraseña del usuario',
    'user_temporary_encryption_code' => 'Código de cifrado del usuario',
    'no_email_set' => 'No se ha registrado ningún correo electrónico',
    'send_user_password_by_email' => 'Decide si la contraseña de inicio de sesión del usuario debe ser enviada por correo electrónico.<br>Si es así, presiona el botón Enviar.<br><br>De lo contrario, usa el botón Copiar al portapapeles para enviársela al usuario por otro medio.<br>Es tu responsabilidad como administrador proporcionar la contraseña al usuario de forma segura.',
    'admin_change_user_encryption_code_info' => 'Esta operación restablecerá el código de cifrado para este usuario.',
    'send_by_email' => 'Enviar por correo electrónico',
    'filters' => 'Filtros',
    'show_user_password' => 'Mostrar contraseña del usuario',
    'open_website' => 'Abrir sitio web',
    'mfa_for_roles' => 'Se requiere MFA para usuarios en Roles',
    'mfa_for_roles_tip' => 'Por defecto, una vez que se selecciona un método MFA, se habilita para todos los usuarios. Sin embargo, puedes seleccionar los roles para los cuales se espera.<br>NO IMPLEMENTADO AÚN',
    'at_least_one_administrator_is_requested' => 'Se solicita al menos un administrador',
    'bad_code' => 'Código incorrecto',
    'generating_keys' => 'Generando claves',
    'this_may_take_time' => 'Esto puede tardar un par de minutos',
    'disable_enable' => 'Deshabilitar / Habilitar',
    'user_disable_status' => 'Marca la casilla para deshabilitar o deja vacío para habilitar',
    'help_for_launching_items_encryption' => 'Necesitamos generar la base de datos de claves para tu cuenta. Por favor, proporciona tu código de cifrado.',
    'managed_through_ad' => 'Gestionado a través de AD',
    'new_ldap_user_info' => 'Por favor completa la definición para el usuario',
    'email_body_user_added_from_ldap_encryption_code' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Ahora tienes una cuenta en Teampass. Puedes usar tus credenciales de AD para iniciar sesión.<br><br>En el primer inicio de sesión, se esperará un código de cifrado de tu parte, por favor usa:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'settings_ldap_user_object_filter' => 'Filtro de objeto de usuario',
    'settings_ldap_user_object_filter_tip' => 'El filtro a utilizar al buscar objetos de usuario. Varios filtros se separan por una coma (,). Ejemplo: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Este valor se utiliza además del DN base al buscar y cargar usuarios. Si no se proporciona ningún valor, la búsqueda en el subárbol comenzará desde el DN base. Ejemplos: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'DN adicional del usuario',
    'ldap_user_has_changed_his_password' => 'Tu contraseña de autenticación ha sido cambiada en tu AD desde la última vez que iniciaste sesión en Teampass. Necesitamos adaptar tu clave de cifrado. Por favor proporciona tu contraseña anterior y la actual.',
    'provide_your_previous_password' => 'Tu contraseña anterior',
    'admin_change_user_password_info' => 'Esta operación restablecerá la contraseña actual del usuario seleccionado.',
    'sending_email_message' => 'Ahora enviando correo electrónico al usuario, por favor espera',
    'change_your_password_info_message' => 'Por favor proporciona tu nueva contraseña de autenticación y confírmala.',
    'user_has_to_change_password_info' => 'La contraseña actual utilizada ha sido generada. Se espera que la cambies por razones de seguridad.',
    'ready_to_go' => 'Listo para continuar',
    'passwords_not_the_same' => 'Las contraseñas proporcionadas no son iguales',
    'inititialization' => 'Inicialización',
    'bad_password' => 'Contraseña incorrecta',
    'perform_checks' => 'Realizar comprobaciones',
    'email_body_temporary_encryption_code' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Se han realizado algunos cambios en tu cuenta que requieren una nueva encriptación de los elementos por motivos de seguridad de datos. La próxima vez que te conectes a Teampass, utiliza tus credenciales actuales y usa este código de encriptación temporal cuando se te solicite:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'temporary_encryption_code' => 'Tu código de encriptación temporal',
    'renecyption_expected' => 'Necesitamos re-encriptar tus claves para ajustarlas a los privilegios correspondientes a tu cuenta y derechos.',
    'error_no_user_in_ad' => '¡Usuario no encontrado en AD!',
    'error_ad_user_expired' => '¡El usuario ha expirado!',
    'error' => 'Error detectado',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'La opción de hosts es un array de direcciones IP o nombres de host ubicados en tu red que sirven un directorio LDAP (separados por comas). Puedes insertar tantos servidores como desees, dependiendo de tu bosque (con un mínimo de uno, por supuesto).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'El nombre distinguido (DN) raíz que se utilizará al ejecutar consultas en el servidor de directorio. Ejemplos: o=ejemplo,c=com ; cn=usuarios,dc=ad,dc=ejemplo,dc=com',
    'username' => 'Nombre de usuario',
    'settings_ldap_username_tip' => 'El nombre distinguido del usuario que la aplicación utilizará al conectarse al servidor de directorio. Ejemplos: cn=administrador,cn=usuarios,dc=ad,dc=ejemplo,dc=com ; cn=usuario,dc=dominio,dc=nombre',
    'settings_ldap_password_tip' => 'La contraseña del usuario especificado arriba.',
    'settings_ldap_port_tip' => 'La opción de puerto se utiliza para autenticar y enlazar a tu servidor LDAP. Los puertos predeterminados ya se utilizan para conexiones no SSL y SSL (389 y 636). Solo inserta un puerto si tu servidor LDAP utiliza un puerto único.',
    'undefined' => 'No definido',
    'error_cannot_open_file' => 'No se puede abrir el archivo',
    'provide_current_psk_and_click_launch' => 'Cuando estés listo, haz clic en el botón Lanzar',
    'start' => 'Iniciar',
    'data_inconsistency' => 'Se encontró inconsistencia de datos. ¡Por favor, recarga la página!',
    'one_time_code_expected' => 'Se espera un código de un solo uso',
    'data_are_missing' => 'Faltan datos esperados',
    'one_time_code' => 'Código de un solo uso',
    'provide_personal_one_time_code' => 'Por favor, proporciona el código de un solo uso que recibiste por correo electrónico',
    'change_authentification_type_to_ldap' => 'Cambiar tipo de autenticación a LDAP',
    'change_authentification_type_to_local' => 'Cambiar tipo de autenticación a base de datos local de Teampass',
    'ldap_user_password_is_used_for_authentication' => 'La contraseña del usuario en LDAP se utiliza para autenticación',
    'local_user_password_is_used_for_authentication' => 'La contraseña del usuario en Teampass se utiliza para autenticación',
    'provide_your_current_password' => 'Proporciona tu contraseña actual',
    'current_password' => 'Contraseña actual',
    'password_is_not_correct' => 'Esta contraseña no es correcta',
    'ldap_password_change_warning' => 'Tu contraseña de inicio de sesión ha cambiado desde la última conexión. Se requiere re-encriptar todas las claves utilizando esta nueva contraseña. Para esta operación, por favor, llena el siguiente campo con tu contraseña LDAP anterior. La operación puede tardar varios minutos.',
    'personal_items' => 'Elementos personales',
    'logout_on_going' => 'Ahora serás desconectado. Usa tu nueva contraseña para conectarte desde ahora.',
    'fill_in_fields_and_hit_launch' => 'Proporciona los datos esperados y presiona el botón Lanzar',
    'please_select_a_folder' => 'Por favor, selecciona una carpeta',
    'user_must_have_login_and_email' => 'El usuario debe tener un inicio de sesión y un correo electrónico',
    'user_has_this_role_in_teampass' => 'El usuario tiene este rol en Teampass',
    'select_role_to_create' => 'Seleccionar rol para crear',
    'adding_ldap_role_to_teampass' => 'Puedes decidir crear un rol en Teampass proveniente de tu Active Directory. Esto permitirá asociar al usuario a este rol en Teampass.',
    'add_user_to_role' => 'Agregar este rol al usuario en Teampass',
    'add_user_in_teampass' => 'Agregar usuario en Teampass',
    'synchronized' => 'Sincronizado',
    'output' => 'Salida',
    'remove_install_folder' => 'La carpeta de instalación debe ser eliminada',
    'list_users' => 'Listar usuarios',
    'ldap_synchronization' => 'Sincronización LDAP',
    'in_progress' => 'En progreso',
    'clipboard_password_life_duration' => 'Tiempo antes de que el portapapeles se borre (en segundos)',
    'clipboard_password_life_duration_tip' => 'Permite definir un tiempo en segundos antes de que la contraseña copiada en el portapapeles se borre del portapapeles del navegador. Establecer en 0 para deshabilitar.',
    'clipboard_will_be_cleared' => 'La contraseña está ahora en el portapapeles. Se borrará pronto...',
    'file_folder_not_accessible' => 'La carpeta de archivos no es accesible',
    'error_missing_id' => 'Ocurrió un error. ID faltante ... ?',
    'error_folder_not_allowed' => 'La carpeta seleccionada no está permitida',
    'all_fields_mandatory' => 'Todos los campos son obligatorios',
    'history_insert_entry' => 'Insertar en el historial',
    'clear_form' => 'Limpiar formulario',
    'info_about_history_insertion' => 'Cuidado - Esta función permite insertar manualmente un evento en el registro de historial del ítem. Una vez agregado, no será posible eliminarlo. También ten en cuenta que tu ID de cuenta estará asociado a esta nueva entrada.',
    'select_all' => 'Seleccionar todo',
    'unselect_all' => 'Deseleccionar todo',
    'no_data_to_display' => '¡No hay datos para mostrar! O no existe ninguna carpeta, o no tienes acceso a ninguna de ellas.',
    'server' => 'Servidor',
    'data_refreshed' => 'Datos refrescados',
    'loading_image' => 'Cargando imagen',
    'compare_with_another_role' => 'Comparar con otro rol',
    'only_display_folders_to_depth' => 'Solo mostrar carpetas hasta la profundidad',
    'propagate_rights_to_descendants' => 'Propagar derechos a los descendientes',
    'loading_data' => 'Cargando datos',
    'password_overview_delay' => 'Retraso para vista general de la contraseña',
    'password_overview_delay_tip' => 'Esta configuración permite definir el número de segundos que la contraseña clara será mostrada al usuario.',
    'select_date_showing_items_expiration' => 'Listar los elementos expirados en la fecha',
    'renewal_page_info' => 'Esta página permite identificar los elementos actualmente expirados o que expiran en el próximo periodo.',
    'filename' => 'Nombre del archivo',
    'exported_to_file' => 'Exportado a archivo',
    'operation_progress' => 'La operación está en progreso',
    'exporting_items' => 'Exportando elementos',
    'select_folders_to_export' => 'Seleccionar carpetas para exportar',
    'export_format_type' => 'Seleccionar el tipo de formato de exportación',
    'export_items' => 'Exportar elementos',
    'loading_item' => 'Cargando ítem',
    'otv_message' => 'Puedes compartir este ítem con alguien sin una cuenta de Teampass. One-Time-View permite a tu invitado acceder a los campos básicos de este ítem solo una vez sin estar autenticado en Teampass. Ten en cuenta que este enlace es válido hasta que se alcance alguna de las siguientes configuraciones. Copia y comparte el enlace a continuación.',
    'no_sharekey_found' => 'No se encontró ninguna clave para este archivo y tu cuenta',
    'otv_link' => 'Enlace de visualización única',
    'one_time_view' => 'Visualización única',
    'move_right_columns_separator' => 'Mover separador de columnas a la derecha',
    'move_left_columns_separator' => 'Mover separador de columnas a la izquierda',
    'form_presents_inconsistencies' => 'El formulario presenta algunas inconsistencias. Por favor, revisa los campos con bordes rojos.',
    'download' => 'Descargar',
    'see' => 'Ver',
    'at_anyoneconmodify' => 'Cualquiera puede modificar',
    'disabled' => 'Deshabilitado',
    'enabled' => 'Habilitado',
    'confirmation_seems_wrong' => 'La confirmación parece incorrecta, por favor corrige',
    'i_cannot_remember' => 'No puedo recordar',
    'i_cannot_remember_info' => 'Esta acción no tiene reversa. Se borrarán las contraseñas almacenadas dentro de tus elementos personales. Los ítems no se eliminarán, solo sus contraseñas. Si no puedes recordar tu sal clave personal, entonces esta es la única opción.',
    'user_has_psk_info' => 'Hemos identificado que tienes algunos elementos personales codificados con una antigua sal clave personal. Este paso consiste en re-encriptarlos con tu nueva clave privada. Por favor, proporciónanos tu sal clave personal.',
    'files' => 'Archivos',
    'logs' => 'Registros',
    'suggestions' => 'Sugerencias',
    'encryption_keys' => 'Claves de encriptación',
    'clearing_old_sharekeys' => 'Borrando claves de uso compartido antiguas',
    'hit_launch_to_start' => 'Por favor, haga clic en el botón Lanzar para comenzar',
    'password_changed' => 'Contraseña actualizada',
    'password_already_used' => 'Contraseña ya utilizada',
    'change_login_password' => 'Cambiar contraseña de inicio de sesión',
    'current_password_mandatory' => 'La contraseña actual es obligatoria',
    'objects_encryption_explanation' => 'Teampass ha sido actualizado a una nueva versión que incluye un nuevo protocolo de cifrado. Se espera que vuelva a cifrar sus elementos personales. Para esto, necesita proporcionar su clave de sal personal (PSK) actual. Una vez hecho, haga clic en el botón Lanzar y espere hasta que el proceso alcance el paso final. Esto podría tardar varios minutos dependiendo del número de objetos.',
    'description_has_changed' => 'La descripción ha cambiado',
    'number_of_folders_imported' => 'Número de carpetas importadas',
    'number_of_items_imported' => 'Número de elementos importados',
    'propagate' => 'Propagar',
    'propagate_user_rights' => 'Propagar derechos de usuario',
    'register_new_yubiko_key' => 'Registrar una nueva clave Yubiko',
    'part_of_groups' => 'Parte de grupos',
    'previous_value' => 'Valor anterior',
    'no_previous_value' => 'No hay valor anterior',
    'no_data_selected' => 'No se seleccionaron datos',
    'selected_items_to_be_imported' => 'Elementos seleccionados para importar',
    'cannot_open_file' => 'No se puede abrir el archivo',
    'no_item_found' => 'No se encontró ningún elemento',
    'reading_file' => 'Leyendo archivo',
    'where_shall_items_be_created' => '¿Dónde se crearán los elementos?',
    'target_folder' => 'Carpeta de destino',
    'select_file' => 'Seleccionar archivo',
    'data_type_for_import' => 'Comience seleccionando el tipo de datos de origen para importar',
    'get_tips_about_importation' => 'Obtenga consejos sobre la importación',
    'import_new_items' => 'Importar nuevos elementos',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'para',
    'request_access' => 'Solicitar acceso al elemento',
    'request_access_message' => 'Al solicitar acceso a un elemento, se envía un correo electrónico al autor. El autor aceptará o rechazará la solicitud añadiéndote a la lista de restricciones del elemento. Por favor, confirme para enviar su solicitud por correo electrónico al autor.',
    'request_access_reason' => 'Proporcione al autor el motivo de su solicitud',
    'error_provide_reason' => 'Por favor, proporcione el motivo por el cual desea acceder a este elemento',
    'need_access' => '¿Necesita acceso?',
    'item_with_restricted_access' => 'Elemento con acceso restringido',
    'remaining_emails_to_send' => 'Correos electrónicos restantes por enviar',
    'mfa_flash' => 'Flash con su dispositivo móvil',
    'import' => 'Importar',
    'export' => 'Exportar',
    'offline' => 'Sin conexión',
    'login_attempts_identified_since_last_connection' => 'Se requiere su atención. Se ha identificado al menos un intento de inicio de sesión con su cuenta desde la última conexión exitosa. Por favor, verifique y reporte a su administrador local si no es el autor.',
    'last_login_attempts' => 'Últimos intentos de inicio de sesión',
    'see_detail' => 'Ver detalles',
    'role_definition' => 'Definición de rol',
    'not_yet_implemented' => 'Aún no implementado',
    '2factors_expected_for_admin' => 'El administrador requiere MFA para iniciar sesión',
    '2factors_expected_for_admin_tip' => 'Por defecto, un administrador debe utilizar un método de MFA para iniciar sesión. Si no está habilitado, el administrador no lo requerirá para iniciar sesión, incluso si MFA está habilitado para cualquier otro usuario.',
    'restore_done_now_logout' => 'La restauración de la base de datos se ha realizado. Ahora necesita desconectarse para refrescar las variables de sesión.',
    'backup_and_restore' => 'Copia de seguridad y restauración',
    'explanation_for_oneshot_backup' => 'explicación_de_la_copia_de_respaldo_unica',
    'explanation_for_oneshot_restore' => 'explicación_de_la_restauración_unica',
    'perform_backup' => 'Realizar copia de seguridad',
    'perform_restore' => 'Realizar restauración',
    'backup_select' => 'Archivo de copia de seguridad',
    'choose_file' => 'Elegir archivo',
    'on_the_fly' => 'Sobre la marcha',
    'scheduled' => 'Programado',
    'caution_on_field_encryption_change' => 'Precaución - Tenga en cuenta que cambiar el tipo de cifrado requerirá analizar todos los datos existentes para cambiar el cifrado en la base de datos.',
    'caution_while_deleting_field' => 'Precaución - Eliminar este campo también eliminará los datos relacionados en los elementos.',
    'error_could_not_update_the_field' => 'Error - No se pudo actualizar el campo. Por favor, intente nuevamente después de recargar la página.',
    'caution_while_deleting_category' => 'Precaución - Eliminar esta carpeta eliminará todos sus campos pertenecientes y también todos los datos relacionados con los campos.',
    'your_attention_please' => 'Su atención por favor',
    'all_fields_are_required' => 'Todos los campos son obligatorios',
    'position' => 'Posición',
    'before' => 'Antes',
    'top' => 'Arriba',
    'bottom' => 'Abajo',
    'field' => 'Campo',
    'configuration' => 'Configuración',
    'definition' => 'Definición',
    'number_of_modified_attachments' => 'Número de archivos adjuntos modificados',
    'files_not_encrypted' => 'Los archivos actualmente no están cifrados. Debe realizar este cambio por razones de seguridad.',
    'files_already_encrypted' => 'Los archivos ya están cifrados. No debe cambiar esto por razones de seguridad.',
    'action_to_be_performed' => 'Acción a realizar',
    'last_execution' => 'Última ejecución',
    'never_performed' => 'Nunca realizado',
    'launch' => 'Lanzar',
    'set_of_actions' => 'Conjunto de acciones',
    'uploads' => 'Subidas',
    'uploads_configuration' => 'Configuración de subidas',
    'email_configuration' => 'Configuración de correo electrónico',
    'email_configuration_test' => 'Prueba de configuración de correo electrónico',
    'send_a_test_email' => 'Enviar un correo electrónico de prueba',
    'manage_emails_not_sent' => 'Gestionar correos electrónicos no enviados',
    'email_send_backlog' => '#nb_emails# correos electrónicos no enviados',
    'send_waiting_emails' => 'Enviar correos electrónicos pendientes',
    'ip' => 'IP',
    'no_data_defined' => 'No se ha definido ningún dato',
    'adding_new_api_ip' => 'Añadiendo una nueva IP a la lista blanca',
    'adding_new_api_key' => 'Añadiendo una nueva clave API',
    'api_configuration' => 'Configuración de API',
    'mfa_configuration' => 'Configuración de MFA',
    'yubico_authentication_tip' => 'Por favor, visite www.yubico.com para más detalles.',
    'complexity_level_not_reached' => 'No se ha alcanzado el nivel de complejidad',
    'expected_complexity_level' => 'Nivel de complejidad esperado',
    'your_attention_is_required' => 'Su atención es requerida',
    'favorite' => 'Favorito',
    'unfavorite' => 'Eliminar de favoritos',
    'you_need_to_select_at_least_one_folder' => 'Necesita seleccionar al menos una carpeta',
    'no_value_defined_please_fix' => '¡No se ha definido ningún valor! Por favor, corrija.',
    'apply' => 'Aplicar',
    'from' => 'Desde',
    'please_confirm_by_clicking_checkbox' => 'Por favor, confirme haciendo clic en la casilla de verificación',
    'date_range' => 'Rango de fechas',
    'purge' => 'Purgar',
    'belong_of_deleted_folder' => 'Pertenece a la carpeta eliminada',
    'highlight_selected' => 'Resaltar seleccionado',
    'number_of_selected_objects' => 'Número de objetos seleccionados',
    'confirm_selection_restore' => 'Por favor, confirme la restauración de los elementos seleccionados.',
    'confirm_selection_delete' => 'Por favor, confirme la eliminación de los elementos seleccionados.',
    'refreshing' => 'Refrescando',
    'empty_list' => 'Lista vacía',
    'deleted_folders' => 'Carpetas eliminadas',
    'deleted_items' => 'Elementos eliminados',
    'recycled_bin' => 'Papelera de reciclaje',
    'database' => 'Base de datos',
    'renewal' => 'Renovación',
    'renewal_delay' => 'Retraso de renovación',
    'please_confirm_deletion' => 'Por favor, confirme la eliminación',
    'caution' => 'Precaución',
    'role_not_exist' => '¡Este rol no existe!',
    'role_can_edit_any_visible_item' => 'El rol puede editar cualquier elemento visible',
    'role_can_edit_any_visible_item_tip' => 'La configuración normal es dejar esta casilla sin marcar. De hecho, cuando está marcada, permitirá a un usuario que forme parte de este rol editar cualquier elemento que el usuario pueda abrir, lo que lleva a un estado de inseguridad. Solo debe marcarse por un período específico y por necesidad.',
    'edit_allowed' => 'Edición permitida',
    'delete_allowed' => 'Eliminación permitida',
    'add_allowed' => 'Adición permitida',
    'edit_not_allowed' => 'Edición no permitida',
    'delete_not_allowed' => 'Eliminación no permitida',
    'select_a_role' => 'Seleccionar un rol',
    'access_rights_for_user' => 'Derechos de acceso para el usuario',
    'logs_for_user' => 'Registros para el usuario',
    'please_confirm' => 'Por favor, confirme',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Al hacer clic en esta casilla de verificación, confirma la eliminación de este usuario.',
    'fields_with_mandatory_information_are_missing' => 'Faltan campos con información obligatoria',
    'enable_personal_folder_for_this_user' => 'Habilitar la función de Carpeta Personal para este usuario',
    'special' => 'Especial',
    'administrator' => 'Administrador',
    'super_manager' => 'Gerente de Teampass',
    'manager' => 'Gerente',
    'read_only' => 'Solo lectura',
    'privileges' => 'Privilegios',
    'roles' => 'Roles',
    'user_definition' => 'Definición de usuario',
    'no_selection_done' => 'No se ha realizado ninguna selección',
    'tick_confirmation_box' => 'Por favor, marque la casilla para confirmar',
    'next_list_to_be_deleted' => 'La siguiente lista será eliminada',
    'delete_folders' => 'Eliminar Carpetas',
    'submit' => 'Enviar',
    'label' => 'Etiqueta',
    'parent' => 'Padre',
    'password_minimal_complexity_target' => 'Objetivo de complejidad mínima de contraseña',
    'access_right_for_roles' => 'Derechos de acceso para Roles',
    'create_without_password_minimal_complexity_target' => 'Permitir la creación de nuevos elementos sin objetivo de complejidad mínima de contraseña',
    'edit_without_password_minimal_complexity_target' => 'Permitir la edición de elementos sin objetivo de complejidad mínima de contraseña',
    'add_new_folder' => 'Agregar una nueva carpeta',
    'new' => 'Nuevo',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Autenticación Multifactor',
    'google_2fa' => 'Verificación en 2 pasos de Google',
    'duo_security' => 'Seguridad Duo',
    'yubico' => 'Autenticador Yubico',
    'website_canal' => 'Sitio web de Teampass',
    '2fa_credential_not_correct' => 'La credencial de 2FA no es correcta',
    'no_change_performed' => 'No se realizó ningún cambio.',
    'password_strength' => 'Fuerza de la contraseña',
    'new_password_required' => 'Se requiere una nueva contraseña',
    'limited_search' => 'Búsqueda limitada',
    'empty_psk' => 'Falta la clave de sal',
    'currently_no_favorites' => 'Actualmente no tienes favoritos',
    'favorites' => 'Favoritos',
    'confirm_item_move' => 'Has seleccionado "Mover"... ¿estás seguro?',
    'copy_to_clipboard' => 'Copiar al portapapeles',
    'please_wait_while_loading' => 'Por favor, espera mientras se cargan los datos',
    'defect_report' => 'Informe de errores',
    'actions' => 'Acciones',
    'no_user' => 'Usuario incorrecto',
    'generate_api_token' => 'Generar nuevo token de API',
    'upload_feature' => 'Función de carga',
    'profile' => 'Perfil',
    'language' => 'Idioma',
    'upload_new_avatar' => 'Seleccionar archivo de imagen de perfil',
    'settings' => 'Configuraciones',
    'created_items' => 'Elementos creados',
    'modification_performed' => 'Modificación realizada',
    'items_opened' => 'Elementos abiertos',
    'passwords_seen' => 'Contraseñas vistas',
    'nothing_to_save' => 'Nada que guardar',
    'notification_engaged' => 'Estás recibiendo notificaciones sobre cambios en el elemento',
    'notification_not_engaged' => 'No estás recibiendo notificaciones sobre cambios en el elemento',
    'viewed_number' => 'Número de vistas',
    'automatic_deletion_engaged' => 'Eliminación automática',
    'auto_update_enabled' => 'Cambio automático de contraseña de usuario habilitado. Próximo cambio planificado',
    'copy_folder' => 'Copiar carpeta',
    'select_source_folder' => 'Seleccionar carpeta a copiar',
    'select_destination_folder' => 'Seleccionar carpeta de destino',
    'delete_folder' => 'Eliminar carpeta',
    'select_folder_to_delete' => 'Seleccionar carpeta para eliminar',
    'folder_delete_confirm' => 'La carpeta seleccionada y sus elementos serán eliminados. Por favor, marque la casilla para confirmar esta eliminación.',
    'json_error_format' => 'Formato JSON incorrecto',
    'password_cannot_be_empty' => 'La contraseña no puede estar vacía',
    'password_too_long' => 'La contraseña es demasiado larga',
    'error_no_action_identified' => 'No se ha identificado ninguna acción',
    'ldap' => 'LDAP',
    'emails' => 'Correos electrónicos',
    'backups' => 'Copias de seguridad',
    'api' => 'API',
    'add_folder' => 'Agregar nueva carpeta',
    'select_folder_parent' => 'Seleccionar carpeta padre',
    'add' => 'Agregar',
    'key_is_not_correct' => 'La clave de sesión proporcionada no es correcta',
    'suggestion_information' => 'Puedes sugerir cualquier cambio en este elemento al autor. Utiliza el formulario anterior para realizar tus propuestas de cambio y haz clic en el botón Realizar para informar al autor.',
    'email_address' => 'Dirección de correo electrónico',
    'enter_email' => 'Ingresar correo electrónico',
    'notification' => 'Notificación',
    'notify_on_change' => 'Notificarme sobre cambios',
    'notification_message' => 'Puedes usar esta configuración para recibir notificaciones o no sobre cambios realizados en este elemento.',
    'share_item' => 'Compartir elemento',
    'share_item_message' => 'Puedes compartir este elemento con alguien. Por favor, proporciona un correo electrónico válido y haz clic en el botón Realizar.',
    'delete_item_message' => 'Has decidido eliminar este elemento seleccionado. Necesitas confirmar tu elección haciendo clic en el botón Realizar.',
    'warning' => 'Advertencia',
    'information' => 'Información',
    'perform' => 'Realizar',
    'delete_item' => 'Eliminar elemento',
    'copy_item' => 'Copiar elemento',
    'new_item' => 'Nuevo elemento',
    'error_not_allowed_to_edit_item' => 'No tienes permiso para editar este elemento',
    'error_not_allowed_to_access_this_folder' => 'No tienes permiso para acceder a esta carpeta',
    'error_personal_saltkey_is_not_set' => 'Tu clave personal no está proporcionada.',
    'provide_your_personal_saltkey' => 'Por favor, proporciona tu clave personal',
    'no_fields' => 'No hay campos relacionados con este elemento.',
    'uploaded' => 'subido',
    'changes_ongoing' => 'Algunos cambios no se guardaron. ¿Confirmas salir sin guardar?',
    'no_file_to_upload' => 'No hay archivo para subir',
    'add_files_and_click_start' => 'Agrega archivos a la cola de subida y haz clic en el botón de inicio.',
    'select_files' => 'Seleccionar archivos',
    'attached_files' => 'Archivos adjuntos',
    'visible_by' => 'Visible por',
    'anounce_item_by_email' => 'Anunciar este elemento a los usuarios',
    'select_users_if_needed' => 'Selecciona usuarios si es necesario',
    'allow_item_to_be_deleted' => 'Permitir que este elemento sea eliminado bajo la siguiente condición',
    'item_deleted_after_being_viewed_x_times' => 'El elemento será eliminado después de ser visto X veces',
    'item_deleted_after_date' => 'El elemento será eliminado después de la fecha definida',
    'password' => 'Contraseña',
    'save' => 'Guardar',
    'folder' => 'Carpeta',
    'main' => 'Principal',
    'fields' => 'Campos',
    'details' => 'Detalles',
    'no_special_restriction' => 'Sin restricciones especiales',
    'generate_otv_link' => 'Generar enlace de vista única',
    'no_custom_fields' => 'Sin campos personalizados',
    'no_attachment' => 'Sin adjunto',
    'logout_confirm' => '¿Cerrar sesión? Por favor, confirma.',
    'saved' => 'Guardado',
    'attachments' => 'Adjuntos',
    'success' => 'Éxito',
    'server_answer_error' => 'Ha ocurrido un error. ¡La respuesta del servidor no puede ser analizada!',
    'server_returned_data' => 'Datos devueltos',
    'version_alone' => 'versión',
    'statistics' => 'Estadísticas',
    'options' => 'Opciones',
    'users' => 'Usuarios',
    'folders' => 'Carpetas',
    'find_message' => 'objetos encontrados',
    'auto_update_server_password_info' => 'Los siguientes pasos se realizarán automáticamente:<ul><li>Conéctese a través de SSH al servidor utilizando las credenciales de inicio de sesión y el campo `URL`,</li><li>Cambiar la contraseña del usuario en el servidor</li><li>Guardar la nueva contraseña en Teampass</li><li>Cerrar conexión SSH</li></ul><br /><b>Asegúrese de que el usuario tenga derechos para iniciar sesión y cambiar la contraseña en el servidor (si no, indique el inicio de sesión y la contraseña de root) antes de comenzar.</b>',
    'share' => 'Compartir',
    'notify' => 'Notificar',
    'error_no_selected_folder' => 'Se debe seleccionar al menos una carpeta',
    'email_subject_item_updated' => '[Teampass] Un elemento que estás siguiendo ha sido actualizado',
    'email_body_item_updated' => 'Hola,<br><br>Este es un correo electrónico generado desde el gestor de contraseñas Teampass.<br><br>Has solicitado ser notificado sobre cambios realizados en el elemento `#item_label#` en la carpeta `#folder_name#`.<br><br>El usuario <b>#name# #lastname#</b> realizó al menos un cambio.<br><br>Puedes abrirlo haciendo clic en el siguiente <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">ENLACE</a>.<br><br>Saludos',
    'import_kp_finished' => '¡La importación utilizando el archivo de KeePass ha finalizado! La complejidad de la contraseña requerida para las nuevas carpetas se ha establecido en Media.',
    'password_is_empty' => 'El elemento no tiene contraseña',
    'bug_report_to_github' => 'Completa el contenido del informe, luego cópialo al portapapeles y pégalo en la nueva página de problemas de Github',
    'open_bug_report_in_github' => 'Abrir informe de problemas en Github',
    'bugs_page' => 'Si estás enfrentando un defecto, por favor infórmalo.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Cualquier usuario que forme parte de tus Grupos podría editar todos los elementos importados.',
    'import_csv_anyone_can_modify_txt' => 'Cualquier usuario podría editar todos los elementos importados.',
    'settings_upload_imageresize_options' => 'Redimensionar imagen',
    'user_not_exists' => 'El usuario no existe',
    'auto_create_folder_role' => 'Crear nueva carpeta y rol llamado',
    'start_upload' => 'Iniciar carga',
    'error_upload_runtime_not_found' => 'No se encontró tiempo de ejecución',
    'user_profile_api_key' => 'Token API',
    'index_change_pw' => 'Cambiar contraseña',
    'admin_2factors_authentication_setting' => 'Habilitar Google 2-Step Verification',
    'admin_2factors_authentication_setting_tip' => 'La verificación en dos pasos de Google mejora la seguridad de inicio de sesión. Al iniciar sesión, se muestra un código QR que debe escanearse en la aplicación de verificación en dos pasos de Google del usuario para recibir una contraseña de un solo uso. Requiere que todos los usuarios tengan la aplicación de verificación en dos pasos de Google en un dispositivo móvil conectado a Internet.',
    'admin_ga_website_name' => 'Nombre mostrado en la verificación en dos pasos de Google para Teampass',
    'admin_ga_website_name_tip' => 'Este nombre se utiliza para el código de identificación de cuenta en la verificación en dos pasos de Google.',
    'api_whitelist_ips' => 'IP de la lista blanca de API',
    'api_whitelist_ips_tip' => 'Si no se enumeran explícitamente direcciones IP de clientes de API aquí, entonces cualquier dirección IP está autorizada.',
    'email_share_item_subject' => 'Un elemento de contraseña fue compartido contigo',
    'email_share_item_mail' => 'Hola,<br><br>Este es un correo electrónico generado desde el gestor de contraseñas Teampass.<br><br>#tp_user# te ha compartido el elemento de contraseña #tp_item#.<br><br><a href="#tp_link#">Haz clic en este enlace</a> para acceder al elemento.<br><br><br>Saludos',
    'index_maintenance_mode_admin' => 'El modo de mantenimiento está habilitado. Los usuarios no pueden iniciar sesión.',
    '2fa_authentication_selector' => 'Selecciona un método de autenticación de dos factores',
    'upload_empty_file' => 'Subir archivo vacío',
    'upload_any_extension_file' => 'Subir archivo de cualquier extensión',
    'upload_any_extension_file_tip' => 'Cuando se habilita, esta opción permitirá a los usuarios subir cualquier tipo de archivos.',
    'log_in' => 'Iniciar sesión',
    'create_item_based_upon_template' => 'Uso de plantilla para el elemento',
    'create_item_based_upon_template_tip' => 'Cuando se habilita, esta función permite al autor seleccionar una plantilla compuesta de Campos Personalizados. Ten en cuenta que esta función también requiere que los Campos Personalizados estén habilitados.',
    'main_template' => 'Usar como plantilla',
    'is_mandatory' => 'Es obligatorio',
    'error_field_is_mandatory' => 'Al menos un campo obligatorio está vacío',
    'restrict_visibility_to' => 'Restringir visibilidad a',
    'every_roles' => 'Todos los roles',
    'masked_text' => 'Texto enmascarado',
    'textarea' => 'Área de texto',
    'admin_yubico_authentication_setting' => 'Habilitar autenticación Yubico',
    'yubico_user_id' => 'ID de cliente',
    'yubico_user_key' => 'Clave secreta',
    'yubico_bad_code' => 'Información Yubico incorrecta',
    'press_your_yubico_key' => 'Presiona tu tecla Yubico',
    'human_resources' => 'Gestor de Teampass',
    'settings_secure_display_image' => 'Habilitar visualización segura de imágenes',
    'settings_secure_display_image_tip' => 'La visualización segura de imágenes permite leer la imagen a través de PHP cuando un usuario previsualiza una imagen adjunta a un elemento. Pro: el archivo adjunto se almacena fuera de la carpeta del sitio y no es accesible por un hacker. Con: es ligeramente más lento que la previsualización directamente desde una URL.',
    'user_ga_code' => 'Enviar Google Authentication al usuario por correo',
    'error_no_email' => '¡Este usuario no tiene dirección de correo electrónico configurada!',
    'error_no_user' => '¡Usuario no encontrado!',
    'email_ga_subject' => 'Tu código de un solo uso de Google Authenticator para TeamPass',
    'email_ga_text' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Tu administrador espera que uses la autenticación de dos factores para conectarte a Teampass.<br>Para tu primera conexión a Teampass con dos factores, por favor utiliza el código que encontrarás a continuación en el campo "Código de identificación":<br><br>----------------------<br>#2FACode#<br>----------------------<br><br>Luego tendrás la oportunidad de configurar tus credenciales de un solo uso para el gestor de contraseñas Teampass.<br><br>Saludos',
    'settings_attachments_encryption' => 'Cifrar archivos adjuntos',
    'settings_attachments_encryption_tip' => 'Si está habilitado, los archivos adjuntos de los elementos se cifran en el servidor con la clave de sal del sistema. El cifrado requiere más recursos del servidor. -- ¡Advertencia! -- Cambiar esta opción podría romper los archivos adjuntos existentes. Después de cambiar esta configuración, debes ejecutar la tarea para cifrar o descifrar archivos adjuntos existentes.',
    'admin_action_attachments_cryption' => 'Cifrar o descifrar todos los archivos adjuntos',
    'admin_action_attachments_cryption_tip' => 'Advertencia: Solo cifra o descifra archivos después de cambiar la configuración de cifrado de archivos adjuntos para que coincida. Selecciona si deseas cifrar o descifrar, luego presiona iniciar. Haz una copia de seguridad de la carpeta de carga antes de ejecutar esta función.',
    'encrypt' => 'Cifrar',
    'decrypt' => 'Descifrar',
    'ga_identification_code' => 'Código de identificación',
    'ga_enter_credentials' => 'Debes ingresar tus credenciales de inicio de sesión',
    'ga_bad_code' => 'El código de Google Authenticator es incorrecto',
    'settings_get_tp_info' => 'Mostrar noticias e información del software a los administradores',
    'settings_get_tp_info_tip' => 'Cuando está habilitado, se muestra información como versiones actuales del software, correcciones de errores y noticias de lanzamiento en la página de información del administrador desde servidores remotos.',
    'settings_offline_mode' => 'Modo offline HTML exportado habilitado',
    'settings_offline_mode_tip' => 'El modo offline crea una página web HTML independiente que se puede descargar a una computadora. Los elementos en la página offline están cifrados con una contraseña especificada por el usuario al crearse.',
    'offline_mode_key_level' => 'Nivel mínimo de seguridad de cifrado offline',
    'categories' => 'Campos personalizados',
    'no_category_defined' => 'No se han creado categorías.',
    'confirm_deletion' => 'Has seleccionado eliminar... ¿estás seguro?',
    'settings_item_extra_fields' => 'Campos personalizados para elementos habilitados',
    'settings_item_extra_fields_tip' => 'Habilita otra pestaña al crear elementos de contraseña, que contiene campos personalizados para otros tipos de datos. Un administrador debe crear primero categorías y las etiquetas de los campos personalizados que se mostrarán en esas categorías. Esta función consume más recursos del servidor.',
    'settings_ldap_type' => 'Tipo de servidor LDAP',
    'server_time' => 'Hora del servidor',
    'settings_tree_counters' => 'Mostrar contadores en el árbol de carpetas',
    'settings_tree_counters_tip' => 'Habilitar muestra tres números junto a cada carpeta: número de elementos en la carpeta base; número de elementos incluyendo subcarpetas; número de subcarpetas.',
    'admin_action_check_pf' => 'Crear carpetas personales para todos los usuarios sin una',
    'enable_personal_folder_feature_tip' => 'Las carpetas personales son un lugar privado para las contraseñas de los usuarios individuales. Los elementos de contraseña se cifran con la clave de sal de un usuario (más seguro) o con su contraseña (más fácil). Habilitar esta función no crea las carpetas reales para los usuarios existentes; también debes ejecutar la tarea de crear carpetas personales.',
    'administrators_only' => 'Solo administradores',
    'managers_of' => 'Gerentes de rol',
    'managed_by' => 'Gestionado por',
    'settings_enable_sts' => 'Seguridad de transporte estricta HTTPS (HSTS) <strong>Advertencia</strong>: ¡lee la descripción!',
    'settings_enable_sts_tip' => '¡Advertencia! Esto impondrá la política de seguridad de transporte estricta HTTPS (STS). STS ayuda a prevenir ataques de intermediarios. ¡Debes tener un certificado SSL emitido por una autoridad de certificación (CA) instalado antes de habilitar esta opción! Un certificado autofirmado no funcionará. Cualquier conexión web futura requerirá HTTPS. Debes tener &apos;SSLOptions +ExportCertData&apos; en la configuración SSL de Apache.',
    'settings_anyone_can_modify_bydefault' => 'Opción <i>Cualquiera puede modificar</i> seleccionada por defecto',
    'to' => 'a',
    'settings_upload_maxfilesize_tip' => 'Tamaño máximo de archivo permitido al cargar un archivo adjunto u otro archivo (en megabytes, configuración predeterminada 10 MB). También es posible que debas cambiar la configuración de tu php.ini upload_max_filesize y post_max_size; el valor predeterminado suele ser solo 2 MB.',
    'settings_upload_docext_tip' => 'Lista las extensiones de archivo para archivos de texto y procesadores de texto que permitirás como cargas de archivos adjuntos. Indica las extensiones de archivo permitidas separadas por una coma (,)',
    'settings_upload_imagesext_tip' => 'Lista las extensiones de archivo para archivos de imagen que permitirás como cargas de archivos adjuntos. Indica las extensiones de archivo permitidas separadas por una coma (,)',
    'settings_upload_pkgext_tip' => 'Lista las extensiones de archivo para archivos de archivo comprimido que permitirás como cargas de archivos adjuntos. Indica las extensiones de archivo permitidas separadas por una coma (,)',
    'settings_upload_otherext_tip' => 'Lista cualquier otra extensión de archivo que permitirás subir como archivos adjuntos. Indica las extensiones de archivo permitidas separadas por una coma (,)',
    'settings_upload_imageresize_options_tip' => 'Redimensionar imágenes grandes subidas (establecer dimensiones máximas en píxeles). Las imágenes más grandes de 1000 píxeles de ancho pueden no mostrarse bien en el navegador web.',
    'settings_upload_maxfilesize' => 'Tamaño máximo de archivo adjunto',
    'settings_upload_docext' => 'Extensiones de documentos permitidas',
    'settings_upload_imagesext' => 'Extensiones de imagen permitidas',
    'settings_upload_pkgext' => 'Extensiones de archivo permitidas',
    'settings_upload_otherext' => 'Otras extensiones permitidas',
    'settings_upload_imageresize_options_w' => 'Ancho máximo de imagen',
    'settings_upload_imageresize_options_h' => 'Altura máxima de imagen',
    'settings_upload_imageresize_options_q' => 'Calidad de imagen JPEG',
    'settings_importing' => 'Importar desde archivos KeePass o CSV habilitado',
    'admin_proxy_ip' => 'Dirección IP del servidor proxy',
    'admin_proxy_ip_tip' => 'Si necesitas un servidor proxy para conectarte a Internet, establece la dirección IP aquí. De lo contrario, déjalo en blanco.',
    'admin_proxy_port' => 'Puerto del servidor proxy',
    'admin_proxy_port_tip' => 'Si necesitas un servidor proxy para conectarte a Internet, establece el número de puerto aquí.',
    'settings_ldap_elusers' => 'Solo usuarios locales de Teampass',
    'settings_ldap_elusers_tip' => 'Esta función permite a los usuarios en la base de datos autenticar a través de LDAP. Desactiva esto si deseas explorar cualquier directorio LDAP.',
    'db_items_edited' => 'Elemento actualmente en edición',
    'item_edition_start_hour' => 'Edición iniciada',
    'settings_delay_for_item_edition' => 'El bloqueo de edición exclusiva expira después de XX minutos',
    'settings_delay_for_item_edition_tip' => 'Al editar un elemento, el elemento se bloquea para que ningún otro usuario pueda modificarlo. Esta configuración elimina el token de bloqueo después de un cierto número de minutos. Si el valor se establece en 0, un elemento nunca se desbloqueará automáticamente después de que alguien haya comenzado a editarlo.',
    'db_users_logged' => 'Usuarios conectados',
    'action' => 'Acción',
    'login_time' => 'Conectado desde',
    'lastname' => 'Apellido',
    'user_login' => 'Inicio de sesión',
    'role' => 'Rol',
    'error_role_exist' => '¡Este rol ya existe!',
    'error_no_edition_possible_locked' => 'Edición deshabilitada - el elemento está actualmente bloqueado debido a un proceso de cifrado en curso',
    'select' => 'Seleccionar',
    'items' => 'Elementos',
    'enable_personal_saltkey_cookie' => 'Almacenar clave de sal personal en una cookie del navegador',
    'personal_saltkey_cookie_duration' => 'Las claves de sal de los usuarios expiran después de XX días',
    'admin_email_smtp_server' => 'Dirección del servidor SMTP',
    'admin_email_auth' => 'El servidor requiere autenticación',
    'admin_email_auth_username' => 'Nombre de usuario del servidor de correo',
    'admin_email_auth_pwd' => 'Contraseña del servidor de correo',
    'admin_email_port' => 'Puerto del servidor SMTP',
    'admin_email_from' => 'De: Dirección de correo electrónico',
    'admin_email_from_name' => 'De: Nombre para mostrar',
    'admin_email_test_configuration_tip' => 'Envía un correo electrónico de prueba al usuario conectado. Primero debes configurar tu dirección de correo electrónico haciendo clic en el ícono de perfil de usuario.',
    'admin_email_test_subject' => 'Correo electrónico de prueba del administrador',
    'admin_email_test_body' => 'Este es un correo electrónico de prueba enviado para verificar la configuración del servidor de correo. Si estás leyendo esto, ¡felicitaciones!',
    'admin_email_result_ok' => 'Correo electrónico enviado a #email# ... verifica tu bandeja de entrada.',
    'email_bodyalt_item_updated' => 'La contraseña de #item_label# ha sido actualizada.',
    'admin_email_send_backlog_tip' => 'Reenviar cualquier correo electrónico pendiente en la base de datos.',
    'please_wait' => 'Por favor, espera',
    'admin_path_to_files_folder' => 'Carpeta de archivos (ruta completa)',
    'admin_path_to_files_folder_tip' => 'La carpeta de archivos se usa para almacenar tanto archivos del sistema como algunos archivos subidos. Para mayor seguridad, no debe ubicarse en la carpeta www de tu sitio; debe crearse en una carpeta fuera del directorio de tu sitio web, y accederse a través de una regla de reescritura o redirección.',
    'admin_path_to_upload_folder_tip' => 'Los archivos adjuntos se almacenan en la carpeta de carga con nombres aleatorios. El contenido de esta carpeta nunca debe eliminarse manualmente. Para mayor seguridad, no debe ubicarse en la carpeta www de tu sitio; debe crearse en una carpeta fuera del directorio de tu sitio web, y accederse a través de una regla de reescritura o redirección.',
    'pdf_password_warning' => '¡Debes proporcionar una clave de cifrado!',
    'admin_pwd_maximum_length' => 'Longitud máxima de la contraseña',
    'admin_pwd_maximum_length_tip' => 'La longitud máxima de la contraseña predeterminada es de 40 caracteres. Aumentar el tamaño de las contraseñas permitidas tomará más tiempo al cifrar, descifrar y mostrar contraseñas.',
    'settings_insert_manual_entry_item_history' => 'Se permiten inserciones manuales en el historial de elementos',
    'settings_insert_manual_entry_item_history_tip' => 'Normalmente querrás dejar esto desactivado. Cuando se activa, el historial de un elemento de contraseña puede ser editado o alterado.',
    'admin_path_to_upload_folder' => 'Carpeta de carga (ruta completa)',
    'admin_setting_enable_delete_after_consultation' => 'Las contraseñas pueden expirar después de vistas limitadas',
    'admin_setting_enable_delete_after_consultation_tip' => 'Cuando está habilitado, los creadores de elementos pueden decidir si un elemento de contraseña se eliminará automáticamente después de un número limitado de vistas.',
    'at_email' => 'correo electrónico',
    'enable_email_notification_on_item_shown' => 'Notificar a los administradores cuando se vea un elemento de contraseña',
    'share_sent_ok' => 'El correo ha sido enviado',
    'see_item_title' => 'Detalles del elemento',
    'email_on_open_notification_subject' => 'Notificación sobre la vista del elemento de contraseña',
    'email_on_open_notification_mail' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>#tp_user# ha abierto y visto el elemento de contraseña &apos;#tp_item#&apos;. <a href=&apos;#tp_link#&apos;>Haz clic en este enlace</a> para acceder al elemento.',
    'pdf' => 'PDF',
    'email_subject_new_user' => 'Cuenta de gestión de contraseñas creada para ti',
    'email_new_user_mail' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Un administrador ha creado una cuenta para ti en el gestor de contraseñas. ¡Las contraseñas seguras para tu organización están a solo un clic de distancia! <br><br>Usa estas credenciales para tu primer inicio de sesión:<br>- Inicio de sesión: #tp_login#<br>- Contraseña: #tp_pw#<br><br><a href=#tp_link#>Haz clic en este enlace</a> para iniciar sesión.',
    'error_empty_data' => '¡No hay datos para continuar!',
    'error_not_allowed_to' => '¡No tienes permiso para hacer eso!',
    'request_access_ot_item' => 'Solicitar acceso para modificar',
    'email_request_access_subject' => 'Tienes una solicitud para habilitar el acceso a tu elemento de contraseña',
    'email_request_access_mail' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>El usuario #tp_user# ha solicitado acceso al elemento de contraseña &apos;#tp_item#&apos;.<br><br>La solicitud viene con la siguiente justificación:<br><i>&apos;#tp_reason#&apos;</i><br><br>Por favor revisa esta solicitud y confirma que autorizarás el acceso.<br><br>Saludos.',
    'admin_action_change_salt_key' => 'Cambiar la clave de sal principal utilizada para cifrado',
    'nb_items_by_query' => 'Número de elementos a recuperar por consulta',
    'nb_items_by_query_tip' => 'Introduce el número de elementos a recuperar por solicitud del servidor. Múltiples solicitudes más pequeñas pueden funcionar mejor que menos solicitudes más grandes. Otras opciones: &apos;auto&apos; - ajustado al tamaño de la ventana de visualización del usuario. &apos;max&apos; - para cargar todo de una vez.',
    'open_url_link' => 'Abrir en una nueva ventana',
    'error_pw_too_long' => 'Contraseña más larga que el máximo del sistema (predeterminado 40 caracteres).',
    'at_restriction' => 'Restricción',
    'pw_encryption_error' => '¡Error al cifrar la contraseña!',
    'enable_send_email_on_user_login' => 'Notificar a los administradores al iniciar sesión cualquier usuario',
    'email_subject_on_user_login' => 'Info: usuario ha iniciado sesión en Teampass',
    'email_body_on_user_login' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>El usuario #tp_user# inició sesión en el gestor de contraseñas el #tp_date# a las #tp_time#. <br><br>Este es un mensaje normal cuando se activa la opción <i>Notificar a los administradores al iniciar sesión cualquier usuario</i>.',
    'account_is_locked' => 'Esta cuenta está bloqueada',
    'activity' => 'Actividad',
    'add_role_tip' => 'Agregar nuevo rol',
    'admin' => 'Administración',
    'admin_action_db_backup' => 'Hacer copia de seguridad de la base de datos',
    'admin_action_db_clean_items' => 'Eliminar elementos huérfanos de la base de datos',
    'admin_action_db_clean_items_tip' => 'Elimina cualquier elemento u otra entrada que haya quedado después de que se borra una carpeta. Por favor, haz una copia de seguridad antes de realizar esta tarea.',
    'admin_action_db_optimize' => 'Optimizar la base de datos',
    'admin_action_db_restore' => 'Restaurar la base de datos',
    'admin_action_purge_old_files' => 'Limpiar archivos temporales',
    'admin_action_purge_old_files_tip' => 'Elimina todos los archivos temporales que tengan más de 7 días.',
    'admin_action_reload_cache_table' => 'Recargar tabla de caché',
    'admin_action_reload_cache_table_tip' => 'Recrea la caché de elementos. Puede corregir problemas al mostrar o guardar elementos de contraseña.',
    'admin_help' => 'Ayuda',
    'admin_ldap_configuration' => 'Configuración de LDAP',
    'admin_main' => 'Información',
    'admin_misc_cpassman_dir' => 'Ubicación de TeamPass (ruta completa)',
    'admin_misc_cpassman_url' => 'Ubicación de TeamPass (URL)',
    'admin_misc_custom_login_text' => 'Mensaje de inicio de sesión personalizado',
    'admin_misc_custom_logo' => 'Logo de inicio de sesión personalizado (URL)',
    'admin_misc_favicon' => 'Favicon (URL completa)',
    'admin_settings' => 'Configuraciones',
    'admin_settings_title' => 'Configuraciones',
    'admin_setting_activate_expiration' => 'Habilitar expiración de contraseñas',
    'admin_setting_activate_expiration_tip' => 'Cuando está habilitado, los elementos de contraseña no se mostrarán después de haber expirado. Establece el tiempo de expiración de la contraseña en días en otro lugar antes de habilitar esta función.',
    'admin_views' => 'Utilidades',
    'alert_message_done' => '¡Hecho!',
    'all' => 'todo',
    'anyone_can_modify' => 'Permitir que este elemento sea modificado por cualquier persona que tenga acceso a él',
    'at' => 'en',
    'at_category' => 'Carpeta',
    'at_copy' => 'Copia realizada',
    'at_delete' => 'Eliminación',
    'at_description' => 'Descripción',
    'at_label' => 'Etiqueta',
    'at_login' => 'Inicio de sesión',
    'at_moved' => 'Movido',
    'at_personnel' => 'Personal',
    'at_restored' => 'Restaurado',
    'at_shown' => 'Accedido',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Carpetas permitidas',
    'auth_creation_without_complexity' => 'Permitir la creación de elementos sin requerir fuerza de contraseña',
    'auth_modification_without_complexity' => 'Permitir la modificación de elementos sin requerir fuerza de contraseña',
    'cancel' => 'Cancelar',
    'can_create_root_folder' => 'Puede crear una carpeta en el nivel raíz',
    'changelog' => 'Actualizaciones recientes de software',
    'close' => 'Cerrar',
    'complexity' => 'Fuerza mínima de la contraseña',
    'complex_asked' => 'Fuerza de contraseña requerida',
    'complex_level0' => 'Muy débil',
    'complex_level1' => 'Débil',
    'complex_level2' => 'Medio',
    'complex_level3' => 'Fuerte',
    'complex_level4' => 'Muy fuerte',
    'complex_level5' => 'Pesado',
    'complex_level6' => 'Muy pesado',
    'confirm' => 'Confirmar',
    'confirm_del_from_fav' => 'Por favor confirma la eliminación de favoritos',
    'connections' => 'conexiones',
    'copy' => 'Copiar',
    'copy_to_clipboard_small_icons' => 'Habilitar ícono <i>copiar contraseña</i> en la lista de elementos',
    'copy_to_clipboard_small_icons_tip' => 'Agrega un pequeño ícono a la lista de elementos de contraseña en el panel superior que copia la contraseña al portapapeles. Se puede copiar una contraseña sin necesidad de seleccionar y cargar todo el contenido del elemento.',
    'date' => 'Fecha',
    'date_format' => 'Formato de fecha',
    'delete' => 'Eliminar',
    'deletion' => 'Eliminaciones',
    'del_button' => 'Eliminar',
    'description' => 'Descripción',
    'disconnect' => 'Cerrar sesión',
    'done' => 'Hecho',
    'duplicate_folder' => 'Las carpetas pueden tener nombres duplicados',
    'duplicate_item' => 'Los elementos pueden tener nombres duplicados',
    'email' => 'Correo electrónico',
    'email_subject' => 'Nuevo elemento de contraseña creado en el gestor de contraseñas',
    'enable_favourites' => 'Función de marcadores de favoritos habilitada',
    'enable_personal_folder' => 'Carpetas personales con almacenamiento de contraseñas privadas',
    'enable_personal_folder_feature' => 'Carpetas personales con almacenamiento de contraseñas privadas',
    'enable_user_can_create_folders' => 'Subcarpetas gestionadas por cualquiera que pueda gestionar la carpeta principal',
    'encrypt_key' => 'Clave de cifrado',
    'errors' => 'errores',
    'error_group_exist' => '¡Esta carpeta ya existe!',
    'error_html_codes' => '¡Algunos textos contienen códigos HTML! Esto no está permitido.',
    'error_item_exists' => '¡Este elemento ya existe!',
    'error_label' => '¡Una etiqueta es obligatoria!',
    'error_must_enter_all_fields' => '¡Debes completar cada campo!',
    'error_pw' => 'Se requiere una contraseña en la pestaña de contraseña.',
    'error_tags' => 'Solo se permiten espacios en las etiquetas',
    'error_user_exists' => 'El usuario ya existe',
    'expiration_date' => 'Fecha de expiración',
    'find' => 'Buscar',
    'forbidden_groups' => 'Carpetas denegadas',
    'forgot_my_pw_email_sent' => 'El correo electrónico ha sido enviado',
    'functions' => 'Roles',
    'gestionnaire' => 'Gerente',
    'god' => 'Administrador',
    'group' => 'Carpeta',
    'group_parent' => 'Carpeta principal',
    'group_pw_duration' => 'Período de renovación',
    'group_pw_duration_tip' => 'En meses. Usa 0 para deshabilitar.',
    'history' => 'Historial',
    'home_personal_saltkey' => 'Tu clave sal personal',
    'home_personal_saltkey_label' => 'Introduce tu clave sal personal',
    'import_error_no_read_possible' => '¡No se puede leer el archivo!',
    'import_error_no_read_possible_kp' => '¡No se puede leer el archivo! Debe ser un archivo de KeePass.',
    'import_keepass_to_folder' => 'Selecciona la carpeta de destino',
    'index_add_one_hour' => 'Extender el tiempo de sesión',
    'index_change_pw_confirmation' => 'Confirmar',
    'index_expiration_in' => 'expiración de sesión en',
    'index_get_identified' => 'Inicia sesión para comenzar tu sesión',
    'index_last_pw_change' => 'Contraseña cambiada',
    'index_last_seen' => 'Última conexión',
    'index_login' => 'Cuenta',
    'index_new_pw' => 'Nueva contraseña',
    'index_password' => 'Contraseña',
    'index_pw_error_identical' => '¡Las contraseñas deben ser idénticas!',
    'index_pw_level_txt' => 'Fuerza',
    'index_session_duration' => 'Duración de la sesión',
    'info' => 'Información',
    'item_menu_copy_login' => 'Copiar inicio de sesión',
    'item_menu_copy_pw' => 'Copiar contraseña',
    'item_menu_del_from_fav' => 'Eliminar de favoritos',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de Conocimientos',
    'last_items_title' => 'Últimos elementos vistos',
    'ldap_extension_not_loaded' => 'La extensión LDAP de PHP no está cargada en el servidor.',
    'level' => 'Nivel',
    'login' => 'Iniciar sesión',
    'mask_pw' => 'Ocultar/mostrar contraseña',
    'max_last_items' => 'Tamaño de la lista de elementos de contraseña vistos recientemente (el valor predeterminado es 10)',
    'minutes' => 'minutos',
    'name' => 'Nombre',
    'nb_false_login_attempts' => 'Número máximo de intentos de inicio de sesión antes del bloqueo de la cuenta (0 para deshabilitar el bloqueo)',
    'nb_folders' => 'Número de Carpetas',
    'nb_items' => 'Número de Elementos',
    'new_label' => 'Nueva etiqueta',
    'no' => 'No',
    'none' => 'Ninguno',
    'none_selected_text' => 'Ninguno seleccionado',
    'not_allowed_to_see_pw' => '¡Acceso al elemento de contraseña denegado!',
    'not_allowed_to_see_pw_is_expired' => '¡Este elemento ha expirado!',
    'not_defined' => 'No definido',
    'number_of_used_pw' => 'Número de contraseñas antiguas recordadas para evitar su reutilización (0 para deshabilitar)',
    'pages' => 'Páginas',
    'pdf_download' => 'Descargar archivo',
    'personal_salt_key' => 'Tu clave sal personal',
    'pw' => 'Contraseña',
    'pw_generate' => 'Generar',
    'pw_is_expired_-_update_it' => '¡Este elemento ha expirado! Necesitas cambiar su contraseña.',
    'pw_life_duration' => 'Las contraseñas de inicio de sesión expiran después de xx días (0 para deshabilitar)',
    'readme_open' => 'Abrir el archivo de README completo',
    'read_only_account' => 'Solo lectura',
    'restore' => 'Restaurar',
    'restricted_to' => 'Restringido a',
    'restricted_to_roles' => 'Permitir restringir elementos a usuarios y roles',
    'root' => 'Raíz',
    'secure' => 'Seguro',
    'see_logs' => 'Ver registros',
    'settings_anyone_can_modify' => 'Función de <i>Cualquiera puede modificar</i> habilitada',
    'settings_anyone_can_modify_tip' => 'Esto agrega una casilla de verificación durante la creación de nuevos elementos de contraseña que puede establecer el elemento como modificable por cualquier persona.',
    'settings_default_language' => 'Idioma de interfaz de usuario predeterminado',
    'settings_kb' => 'Función de base de conocimientos',
    'settings_kb_tip' => 'Agrega un elemento de menú para acceder a la función de base de conocimientos. La base de conocimientos es una FAQ buscable, que te permite crear ayuda y notas, y adjuntarlas a elementos de contraseña.',
    'settings_ldap_domain' => 'Sufijo de cuenta LDAP para tu dominio',
    'settings_ldap_domain_controler' => 'Controlador(es) de dominio LDAP',
    'settings_ldap_domain_controler_tip' => 'Especifica el controlador de dominio que proporciona los servicios de directorio. Para equilibrar las consultas entre varios servidores, ingresa una lista separada por comas de cada nombre de servidor. Ejemplo: dominio_1,dominio_2,dominio_3',
    'settings_ldap_domain_dn' => 'DN base de LDAP para tu dominio',
    'settings_ldap_mode' => 'Habilitar autenticación de usuarios a través del servidor LDAP',
    'settings_ldap_mode_tip' => 'Habilitar si deseas autenticar los inicios de sesión de usuarios con un servidor de directorio LDAP en lugar de usar la base de datos interna de usuarios.',
    'settings_ldap_ssl' => 'Usar LDAP a través de SSL (LDAPS)',
    'settings_ldap_tls' => 'Usar LDAP a través de TLS',
    'settings_log_accessed' => 'Registrar vistas de elementos de contraseña por usuarios',
    'settings_log_connections' => 'Registrar todos los inicios de sesión de cuentas de usuario',
    'settings_maintenance_mode' => 'Habilitar modo de mantenimiento (deshabilitar inicio de sesión de usuarios)',
    'settings_manager_edit' => 'Los gerentes pueden editar o eliminar cualquier elemento que puedan ver',
    'settings_printing' => 'Exportar a PDF o CSV habilitado',
    'settings_printing_tip' => 'Agrega una opción de exportación al menú del árbol de elementos, permitiendo la exportación de carpetas completas a PDF o CSV. Las contraseñas CSV se exportarán sin cifrar, mientras que los archivos PDF pueden estar protegidos por contraseña.',
    'settings_restricted_to' => 'Habilitar función <i>restringido a</i> en elementos',
    'settings_show_description' => 'Mostrar campo de descripción del elemento en las listas de elementos',
    'size' => 'Tamaño',
    'tags' => 'Etiquetas',
    'timezone_selection' => 'Zona horaria',
    'time_format' => 'Formato de hora',
    'url' => 'URL',
    'user' => 'Usuario',
    'users_online' => 'usuarios en línea',
    'user_alarm_no_function' => '¡Este usuario no tiene roles asignados!',
    'yes' => 'Sí',
    'one_time_view_item_url_box' => 'Comparte una URL de vista única con una persona en quien confíes para ver la contraseña <br><br>#URL#<br><br>Este enlace solo será visible una vez y expira en #DAY#',
    'settings_api' => 'Acceso API habilitado',
    'settings_api_tip' => 'La interfaz de programación de aplicaciones permite a los desarrolladores de software acceder a elementos de contraseña en formato JSON a través de la red.',
    'settings_api_keys_list' => 'Lista de claves API',
    'settings_api_keys_list_tip' => 'Claves para acceder a la API. El software de terceros debe usar una clave aleatoria creada aquí para acceder a la interfaz JSON.',
    'settings_api_key' => 'Clave',
    'settings_api_add_ip' => 'Nueva IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Las nuevas subcarpetas heredan permisos de la carpeta principal',
    'subfolder_rights_as_parent_tip' => 'Si se habilita, cada nueva subcarpeta hereda los roles y permisos de la carpeta principal. De lo contrario, el permiso de la carpeta se asigna según el rol del usuario que las crea.',
    'show_only_accessible_folders_tip' => 'Por defecto, los usuarios ven el árbol completo de carpetas de elementos de contraseña, incluso si algunas carpetas son inaccesibles para el usuario. Puedes eliminar carpetas inaccesibles de la vista para simplificar la navegación.',
    'show_only_accessible_folders' => 'Ocultar carpetas de contraseña inaccesibles',
    'comment' => 'Comentario',
    'suggestion_menu' => 'Sugerencias',
    'settings_suggestion' => 'Función de sugerencia de contraseña habilitada',
    'settings_suggestion_tip' => 'La función de sugerencia agrega un nuevo menú y página, permitiendo a los usuarios crear sugerencias para nuevos elementos de contraseña. Esto es útil cuando solo los gerentes pueden crear elementos de contraseña.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'Contraseña de enlace LDAP',
    'settings_ldap_search_base' => 'Base de búsqueda LDAP',
    'settings_ldap_bind_dn_tip' => 'Introduce un bind DN que pueda acceder a los usuarios y buscar en el árbol. Un bind DN es una credencial que autentica tu acceso al directorio.',
    'settings_ldap_bind_passwd_tip' => 'Contraseña para el bind DN especificado arriba.',
    'settings_ldap_search_base_tip' => 'Ubicación del DN raíz para búsquedas en el árbol',
    'admin_email_server_url' => 'Personaliza la URL para los enlaces',
    'enable_email_notification_on_user_pw_change' => 'Notificar por correo electrónico al usuario cuando se cambie la contraseña',
    'settings_otv_expiration_period' => 'Los enlaces de vista única (OTV) expiran después de XX días',
    'write' => 'Escribir',
    'read' => 'Leer',
    'no_access' => 'Sin acceso',
    'right_types_label' => 'Selecciona el tipo de acceso a esta carpeta para el grupo de usuarios seleccionado',
    'duplicate_item_in_folder' => 'Los elementos en la misma carpeta pueden tener nombres similares',
    'settings_roles_allowed_to_print' => 'Exportación permitida por estos roles (selección múltiple)',
    'settings_roles_allowed_to_print_tip' => 'Selecciona múltiples roles manteniendo presionada la tecla CTRL mientras seleccionas. Los miembros de estos roles podrán exportar carpetas a CSV o PDF si la exportación también está habilitada a nivel global.',
    'admin_email_security' => 'Tipo de seguridad SMTP',
    'alert_page_will_reload' => 'La página se recargará ahora',
    'file_protection_password' => 'Definir contraseña para el archivo',
    'expand' => 'Expandir',
    'collapse' => 'Colapsar',
    'settings_ldap_user_attribute' => 'Atributo del nombre de usuario',
    'settings_ldap_user_attribute_tip' => 'El campo de atributo a usar al cargar el nombre de usuario.<br>Ejemplo: Para openLDAP: cn; uid. Para Active Directory: samaccountname.',
    'log_user_initial_pwd_changed' => 'Contraseña inicial definida',
    'log_user_email_changed' => 'Correo electrónico del usuario cambiado a ',
    'log_user_created' => 'Cuenta de usuario creada',
    'log_user_locked' => 'Usuario ha sido bloqueado',
    'log_user_unlocked' => 'Usuario ha sido desbloqueado',
    'log_user_pwd_changed' => 'La contraseña del usuario ha sido cambiada',
    'settings_default_session_expiration_time' => 'Tiempo de expiración de sesión predeterminado',
    'settings_duo' => 'Habilitar autenticación de dos factores DUO Security',
    'settings_duo_tip' => 'Autenticación de dos factores basada en la nube de Duo Security de duo.com. Códigos de acceso de un solo uso a través de SMS, llamada de voz o aplicación móvil. Se requiere una cuenta con Duo para usar esta función. El inicio de sesión de dos factores a través de Duo será obligatorio para todos los usuarios no administradores cuando se active.<br />Crea o convierte la aplicación teampass al Aviso Universal desde la página de administración de Duo.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'ID del cliente (duo_ikey)',
    'admin_duo_skey' => 'Secreto del cliente (duo_skey)',
    'admin_duo_host' => 'Nombre de host de la API (HOST)',
    'settings_duo_explanation' => 'Las credenciales de la aplicación de la página de administración de seguridad de Duo deben ingresarse aquí.',
    'admin_duo_intro' => 'Ingresa tus credenciales de aplicación de Duo',
    'edit' => 'Editar',
    'user_info_locked' => 'El usuario está bloqueado actualmente.',
    'user_info_unlock_question' => '¿Desbloquear cuenta?',
    'user_info_lock_question' => '¿Bloquear cuenta?',
    'user_info_delete_question' => '¿Eliminar cuenta?',
    'user_info_active' => 'El usuario está habilitado actualmente.',
    'refresh' => 'Actualizar',
    'loading' => 'Cargando',
    'searching' => 'Buscando...',
    'list_items_with_tag' => 'Listar elementos con esta etiqueta',
    'no_item_to_display' => 'No hay elementos para mostrar',
    'opening_folder' => 'Leyendo carpeta...',
    'suggestion_notify_subject' => 'Se ha enviado una nueva sugerencia de elemento de contraseña',
    'suggestion_notify_body' => 'Un usuario ha enviado una sugerencia de elemento de contraseña al gestor de contraseñas. Debes aceptar la sugerencia antes de que pueda ser utilizada por otros usuarios.<br>Info:<br>- Etiqueta: #tp_label#<br>- Carpeta: #tp_folder#<br>- Usuario: #tp_user#<br><br>Este correo ha sido enviado a todos los gerentes.',
    'error_unknown' => '¡Ocurrió un error inesperado!',
    'no_edit' => 'Escribir pero sin editar',
    'role_cannot_edit_item' => 'No se pueden editar elementos',
    'no_delete' => 'Escribir pero sin eliminar',
    'role_cannot_delete_item' => 'No se pueden eliminar elementos',
    'my_profile' => 'Mi perfil',
    'starting' => 'Iniciando...',
    'total_number_of_items' => 'Número total de elementos',
    'finalizing' => 'Finalizando',
    'treating_items' => 'Procesando elementos',
    'number_of_items_treated' => 'Número de elementos procesados',
    'error_sent_back' => 'Siguiente error ocurrido',
    'full' => 'Completo',
    'sequential' => 'Secuencial',
    'tree_load_strategy' => 'Estrategia de carga del árbol',
    'syslog_enable' => 'Registrar errores en el servidor <i>syslog</i>',
    'syslog_host' => 'Nombre o dirección IP del servidor Syslog',
    'syslog_port' => 'Puerto de Syslog (por defecto 514)',
    'error_bad_credentials' => '¡Las credenciales de inicio de sesión no coinciden!',
    'settings_ldap_usergroup' => 'Grupo LDAP para buscar',
    'settings_ldap_usergroup_tip' => 'Introduce el grupo LDAP en el directorio donde se almacenan los inicios de sesión permitidos. Ejemplo: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Habilitar cambio de contraseña en servidor remoto (usando conexión ssh)',
    'update_server_password' => 'Actualizar contraseña del servidor',
    'ssh_pwd' => 'Contraseña SSH',
    'ssh_user' => 'Usuario SSH',
    'ssh_password_frequency_change_info' => 'Selecciona el intervalo entre actualizaciones automáticas de la contraseña del servidor (seleccionar 0 deshabilitará el cambio automático de contraseña).<br />Las actualizaciones automáticas de contraseña solo se realizarán si el administrador del sistema también ha configurado la tarea programada de actualización de contraseña.',
    'ssh_password_frequency_change' => 'Frecuencia de cambio de contraseña (en meses)',
    'ssh_scheduled_change' => 'Cambio programado',
    'ssh_one_shot_change' => 'Cambio de una sola vez',
    'server_password_change_enable_tip' => 'Esta configuración agrega una opción en el elemento de contraseña para cambiar automáticamente la contraseña del usuario en una dirección del servidor listada en la URL. Esto requiere que el servidor UNIX remoto permita el inicio de sesión por nombre de usuario y contraseña a través de SSH. Los cambios automáticos programados de contraseña pueden realizarse después de agregar <i>/files/script.ssh.php</i> a la crontab para ejecutarse una vez al día en el servidor web del gestor de contraseñas.',
    'settings_ldap_object_class' => 'Clase para buscar',
    'settings_ldap_object_class_tip' => 'Clase LDAP para buscar, como cuenta de usuario o cuenta POSIX',
    'rebuild_config_file' => 'Reconstruir archivo de configuración',
    'rebuild_config_file_tip' => 'El archivo de configuración contiene variables del sistema y se usa cuando estas configuraciones son necesarias antes de que se haya establecido la conexión con la base de datos. Reconstruir el archivo de configuración guarda los valores de la base de datos en el archivo, y se puede hacer en cualquier momento. La ubicación predeterminada es ./includes/config/tp.config.php, pero el archivo debe estar ubicado fuera del directorio www por motivos de seguridad.',
    'error_folder_complexity_lower_than_top_folder' => 'Las subcarpetas deben tener un nivel de complejidad de contraseña igual o mayor que la carpeta principal',
    'new_item_email_body' => 'Hola,<br><br>Este es un correo electrónico generado desde el gestor de contraseñas Teampass.<br><br>Se ha creado un nuevo elemento &apos;#label&apos; en Teampass.<br />Puedes acceder haciendo clic en este <a href=&apos;#link#&apos;>ENLACE</a>.<br /><br />Saludos.',
    'failed_logins' => 'Intentos de inicio de sesión fallidos',
    'error_only_numbers_in_folder_name' => 'La etiqueta de la carpeta no puede ser solo un número. Por favor, dale un nombre a tu carpeta que incluya letras.',
    'encrypted_data' => 'Los datos están cifrados en la base de datos',
    'settings_ldap_port' => 'Puerto LDAP',
    'user_profile_agses_card_id' => 'ID de tu tarjeta Agses',
    'ga_flash_qr_and_login' => 'Escanea este código QR con tu dispositivo móvil, ingresa el código de autenticación de 2 factores y haz clic en el botón `Ingresar`.',
    'i_need_to_generate_new_ga_code' => 'Necesito un nuevo código QR. Por favor envíame un Código de Identificación temporal por correo electrónico.',
    'settings_manager_move_item' => 'Los administradores pueden mover cualquier elemento que puedan ver',
    'user_folders_rights' => 'Carpetas visibles',
    'create_item_without_password' => 'Permitir crear un elemento sin definir ninguna contraseña',
    'share_rights_info' => 'Este cuadro de diálogo te permite compartir los derechos de un usuario con una selección de usuarios.<br>Ten en cuenta que los usuarios seleccionados tendrán sus derechos existentes restablecidos y reemplazados con exactamente los mismos derechos que el usuario origen.',
    'share_rights_source' => 'Usuario origen',
    'share_rights_destination' => 'Usuarios destino',
    'ga_reset_by_user' => 'El usuario puede restablecer su código 2FA',
    'ga_reset_by_user_tip' => 'Si está habilitado, el usuario tendrá la posibilidad de restablecer su código 2FA usando el enlace en la página de inicio de sesión. Esto podría ser útil, por ejemplo, si ha cambiado de dispositivo móvil. Si no está habilitado, el usuario tendrá que pedir al administrador que genere un nuevo código.',
    'enable_massive_move_delete' => 'Permitir que el usuario realice operaciones masivas de mover y eliminar',
    'enable_massive_move_delete_tip' => 'Cuando está habilitada, esta opción permite a un usuario realizar una operación masiva de mover y/o eliminar en un solo momento. El usuario solo podrá realizar esto en los elementos para los cuales tenga permiso.',
    'mass_operation' => 'Operación masiva en elementos',
    'move_items' => 'Mover elementos seleccionados',
    'delete_items' => 'Eliminar elementos seleccionados',
    'you_decided_to_move_items' => 'Has decidido mover elementos',
    'you_decided_to_delete_items' => 'Has decidido eliminar elementos',
    'suggest_password_change' => 'Sugerir un cambio de contraseña',
    'otv_is_enabled' => 'El usuario puede proponer enlaces de visualización única (One-Time-View)',
    'error_source_and_destination_are_equal' => '¡El origen y el destino no pueden ser iguales!',
    'sending_anonymous_statistics' => 'Enviando estadísticas anónimas',
    'favourites_option_enabled' => 'Opción de favoritos habilitada',
    'personalfolders_option_enabled' => 'Opción de carpetas personales habilitada',
    'country_statistics' => 'Uso del mapa mundial',
    'country' => 'País',
    'users_statistics' => 'Número promedio de usuarios por instancia',
    'items_all' => 'Todos los elementos',
    'folders_all' => 'Todas las carpetas',
    'items_shared' => 'Todos los elementos compartidos (no incluyendo los personales)',
    'folders_shared' => 'Todas las carpetas compartidas (no incluyendo las personales)',
    'items_statistics' => 'Número promedio de elementos por instancia',
    'folders_statistics' => 'Número promedio de carpetas por instancia',
    'administrators_number' => 'Número de usuarios administradores',
    'administrators_number_statistics' => 'Número promedio de administradores por instancia',
    'managers_number' => 'Número de usuarios gestores',
    'managers_number_statistics' => 'Número promedio de gestores por instancia',
    'readonly_number_statistics' => 'Número promedio de usuarios de solo lectura por instancia',
    'readonly_number' => 'Número de usuarios de solo lectura',
    'mysql_version' => 'Versión de MySQL',
    'php_version' => 'Versión de PHP',
    'teampass_version' => 'Versión de Teampass',
    'languages_used' => 'Idiomas utilizados',
    'languages_statistics' => 'Idioma más utilizado',
    'kb_option_enabled' => 'Opción de base de conocimientos habilitada',
    'suggestion_option_enabled' => 'Opción de sugerencias habilitada',
    'customfields_option_enabled' => 'Opción de campos personalizados habilitada',
    'api_option_enabled' => 'Opción de API habilitada',
    '2fa_option_enabled' => 'Opción de 2FA habilitada',
    'agses_option_enabled' => 'Opción AGSES habilitada',
    'duo_option_enabled' => 'Opción DUO Security habilitada',
    'ldap_option_enabled' => 'Opción LDAP habilitada',
    'syslog_option_enabled' => 'Opción SYSLOG habilitada',
    'stricthttps_option_enabled' => 'Opción Strict HTTPS habilitada',
    'characteristic' => 'Característica',
    'current_value' => 'Valor actual',
    'communication_means' => 'Medios de comunicación',
    'consider_a_donation' => 'Teampass es un proyecto gratuito para todos. Ha requerido días y días de trabajo, y seguirá requiriendo tanto como ya se ha hecho. Podrías considerar una donación o incluso convertirte en patrocinador.',
    'more_information' => 'Más información',
    'feature_request_canal' => 'Para solicitudes de funciones, por favor utiliza',
    'bug_canal' => 'Para reportar errores, por favor utiliza',
    'documentation_canal' => 'Documentación',
    'sending_anonymous_statistics_details' => 'Las estadísticas son necesarias para mejorar Teampass conociendo la población y el uso de los usuarios. Los datos que proporciones solo se usarán internamente para minería de datos y absolutamente no se distribuirán ni venderán a terceros.',
    'item_has_change_proposal' => 'Este elemento tiene una propuesta de cambio',
    'check_data_after_reencryption' => 'Por favor, revisa los datos. Se creó una nueva tabla <b>Backup</b> durante esta operación que permite revertir.',
    'revert' => '¿Revertir?',
    'revert_the_database' => 'Has decidido revertir la base de datos. ¿Por favor confirma?',
    'bad_psk' => '¡Esta Saltkey personal no es correcta!',
    'ldap_test_config' => 'Probar la configuración actual',
    'ldap_test_username' => 'Nombre de usuario para propósitos de prueba',
    'ldap_test_username_pwd' => 'Contraseña del nombre de usuario',
    'feature_support_canal' => 'Para soporte y ayuda, por favor utiliza',
    'category' => 'Categoría',
    'text' => 'Texto',
    'type' => 'Tipo',
    'data_is_masked' => 'Los datos están enmascarados',
    'at_export' => 'Exportar',
    'settings_ldap_allowed_usergroup' => 'Grupo de usuarios permitido en LDAP',
    'settings_ldap_allowed_usergroup_tip' => 'Indica el grupo permitido para conectarse a Teampass. Déjalo vacío si no se espera ninguna restricción en cuanto a la pertenencia al grupo.',
    'error_security_level_not_reached' => '¡El nivel de seguridad esperado no se ha alcanzado!',
    'personal_saltkey_security_level' => 'Nivel mínimo de seguridad para la Saltkey personal',
    'settings_disable_forgot_password_link' => 'Ocultar enlace "Olvidé mi contraseña" en la página de inicio',
    'newly_created_user_is_administrated_by' => 'El usuario recién creado es administrado por',
    'settings_ldap_and_local_authentication' => 'Usuarios locales y LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Habilita esta opción para permitir tanto a los usuarios autenticados en la biblioteca LDAP como a los usuarios locales de Teampass.',
    'enable_http_request_login' => 'Inicio de sesión automático utilizando credenciales de cabecera http',
    'duration_login_attempt' => 'Segundos hasta el inicio de sesión automático:',
    'newly_created_user_role' => 'El usuario recién creado tiene el rol',
    'email_debug_level' => 'Selecciona un nivel de depuración',
    'email_debug_client' => 'Comandos del cliente',
    'email_debug_server' => 'Comandos del cliente y respuestas del servidor',
    'email_debug_connection' => 'Comandos del cliente, respuestas del servidor y estado de conexión',
    'email_debug_low_level' => 'Salida de datos de bajo nivel, todos los mensajes',
    'email_debug_level_usage' => 'Esta configuración debe establecerse en Ninguno. Solo debe utilizarse para depuración de correo durante pruebas. Cuando está habilitada, permite mostrar una salida de los comandos de correo electrónico.',
    'email_body_temporary_login_password' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Un administrador ha cambiado tu contraseña de inicio de sesión para Teampass. La próxima vez que te conectes a Teampass, utiliza la siguiente:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'your_new_password' => 'Tu nueva contraseña',
    'user_specific_right' => 'Derecho específico del usuario',
    'icon' => 'Ícono',
    'icon_on_selection' => 'Ícono en selección',
    'fontawesome_icon_tip' => 'Puedes especificar un código de ícono de Font Awesome seleccionado en íconos Gratis y Sólidos. Deja vacío para el ícono predeterminado.',
    'settings_api_token_duration' => 'Tiempo de expiración del token JWT (en segundos)',
    'settings_api_token_duration_tip' => 'Tiempo durante el cual el token JWT generado es válido. Después de este tiempo, se solicita enviar una solicitud de autorización a la API.',
    'show_encryption_code_to_admin' => 'Este es el código cifrado que el usuario necesitará en este inicio de sesión. Has solicitado verlo, por favor cópialo y compártelo de forma segura. El código es',
    'previous_password' => 'Contraseña anterior utilizada para conectarse a Teampass',
    'generate_new_otp' => 'Generar nuevo OTP',
    'generate_new_otp_informations' => 'Esta operación consiste en generar desde cero todas las claves para el usuario seleccionado. Como consecuencia, el usuario deberá proporcionar el nuevo OTP generado en su próximo inicio de sesión.',
    'html' => 'html',
    'execution_time' => 'Tiempo de ejecución',
    'maximum_number_of_items_to_treat' => 'Número máximo de elementos a tratar durante un ciclo',
    'maximum_number_of_items_to_treat_tip' => 'Para asegurar la finalización del script sin tiempo de espera, es posible definir un valor personal.',
    'maximum_time_script_allowed_to_run' => 'Duración en segundos permitida para que el script se ejecute en segundo plano',
    'maximum_time_script_allowed_to_run_tip' => 'Por defecto, el script PHP no puede ejecutarse más allá de la duración definida por el parámetro max_execution_time en el archivo php.ini. El objetivo aquí es definir un valor más alto para asegurar que el script se complete.',
    'refresh_data_every_on_screen' => 'Período de actualización de pantalla (en segundos)',
    'refresh_data_every_on_screen_tip' => 'Al navegar por la vista de tareas, esto permite tener una lista actualizada.',
    'refreshed' => 'Refrescado',
    'process_details' => 'Detalles del proceso',
    'created_at' => 'Creado en',
    'updated_at' => 'Actualizado en',
    'finished_at' => 'Finalizado en',
    'tasks_manager' => 'Gestor de tareas',
    'tasks' => 'Tareas',
    'task_in_progress_user_not_active' => 'Tareas en progreso - Usuario no activo',
    'enable_tasks_manager' => 'Habilitar tareas en segundo plano con el gestor de cron',
    'enable_tasks_manager_tip' => 'Esta opción debe estar habilitada si has notado que algunas tareas tardan mucho tiempo. Esto permite manejar esas tareas utilizando un trabajo en segundo plano realizado por el gestor de cron del servidor. Consulta la documentación para más detalles.',
    'sync_new_ldap_password' => 'Sincronizar nueva contraseña',
    'error_new_ldap_password_detected' => 'Parece que tu contraseña ha cambiado y Teampass la requiere para cifrar tu clave privada maestra.',
    'settings_ldap_tls_certifacte_check' => 'Verificación de certificado para LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Especifica la estrategia de verificación de certificados. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Más información</a>.',
    'user_keys_management' => 'Gestión de claves de usuario',
    'sending_emails' => 'Enviando correos electrónicos',
    'tasks_information' => 'La tarea depende de un trabajo cron dedicado. Para ello, se solicita agregar una nueva entrada a tu crontab para ejecutar el programador de Teampass cada minuto.<br>La siguiente entrada debe ser agregada:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br>Nota: por favor, adapta la ruta al binario de php (en la mayoría de los casos, puede ser reemplazado por <code>php</code>).',
    'bad_duo_mfa' => 'Código DUO erróneo',
    'creation_date' => 'Fecha de creación',
    'never' => 'Nunca',
    'loading_main_page' => 'Cargando página principal ...',
    'link' => 'Enlace',
    'error_not_allowed_to_authenticate' => 'No se te permite autenticarte',
    'enable_tasks_log' => 'Habilitar registro de tareas',
    'enable_tasks_log_tip' => 'Permite registrar todas las tareas realizadas por el trabajo cron dentro de la tabla <i>processes_log</i>. Puede ser útil para comprobar eventos.',
    'items_and_folders_statistics' => 'Estadísticas de elementos y carpetas',
    'item_copying' => 'El elemento se está copiando',
    'upgrade_requested' => 'La base de datos de Teampass no está actualizada.',
    'upgrade_requested_more' => 'Se han identificado algunas inconsistencias entre los archivos y la configuración. Tu administrador debe realizar el proceso de actualización antes de que continúes.',
    'settings_ldap_group_object_filter' => 'Filtro de objeto de grupo LDAP',
    'settings_ldap_group_object_filter_tip' => 'Filtro LDAP a utilizar para encontrar el objeto de grupo. Por ejemplo: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'Roles de usuario AD mapeados con sus grupos AD',
    'settings_ad_users_with_ad_groups_tip' => 'Permite mapear roles de usuario AD con sus grupos AD. Estos roles se agregarán al definido en su perfil.',
    'settings_ad_user_auto_creation' => 'Usuario AD para ser creado automáticamente',
    'settings_ad_user_auto_creation_tip' => 'Permite que un usuario AD sea creado automáticamente en Teampass cuando inicie sesión por primera vez. Ten en cuenta que si la opción de roles de usuario AD mapeados con sus grupos AD está habilitada, entonces obtendrá los roles mapeados con sus grupos AD.',
    'settings_ldap_guid_attibute' => 'Atributo GUID de LDAP',
    'settings_ldap_guid_attibute_tip' => 'Atributo LDAP a utilizar para identificar el GUID de un objeto. Por ejemplo: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'Grupo AD',
    'mapped_with_role' => 'Mapeado con rol',
    'ad_groupe_and_roles_mapping' => 'Mapeo de grupos AD y roles',
    'select_adgroup_mapping' => 'Selecciona el rol a mapear con el grupo AD actual',
    'enable_backlog_mail' => 'Habilitar el envío de correos electrónicos de retraso',
    'provide_label' => 'Proporcione una etiqueta',
    'uploading' => 'Descargando...',
    'keys_encryption_not_ready' => 'Ten en cuenta que tus claves de contraseña están actualmente en proceso de creación. Por favor, espera unos minutos más.',
    'account_not_ready' => 'Cuenta en construcción',
    'add_new_job' => 'Agregar nuevo trabajo',
    'tasks_cron_not_running' => 'La tarea Cron no está configurada. Por favor, edita el crontab con tu usuario del servidor (generalmente www-data) con el comando <code>crontab -u www-data -e</code>.<br>O presiona el botón para intentar su creación automáticamente.',
    'tasks_cron_running' => 'La tarea Cron está configurada correctamente',
    'currently_using_version' => 'Versión actual cargada',
    'git_commit_value' => 'Valor de commit de Git',
    'generate_new_keys' => 'Generar nuevas claves',
    'generate_new_keys_info' => 'Al continuar, generarás nuevas claves de cifrado para todos los objetos a los que tienes acceso. Esto solo debe hacerse si no tienes contraseñas mostradas.',
    'generate_new_keys_end' => 'El proceso está en curso en segundo plano y podría tardar varios minutos. Ahora puedes cerrar esta ventana.',
    'confirm_password' => 'Necesitamos que confirmes tu contraseña',
    'no_code_is_requested' => 'No se ha solicitado ningún código.',
    'user_encryption_ongoing' => 'La cuenta se está cifrando actualmente. Tu solicitud no puede continuar. Por favor, espera a que esto se termine.',
    'teampass_information' => 'Información de Teampass',
    'show_password' => 'Mostrar contraseña',
    'new_user_info_by_mail' => 'El nuevo usuario recibirá un correo electrónico con sus credenciales',
    'login_credentials' => 'Credenciales de inicio de sesión',
    'email_body_user_config_1' => 'Hola #lastname#,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>Las siguientes credenciales se esperan la próxima vez que uses Teampass:<ul><li>inicio de sesión: #login#</li><li>Contraseña: #password#</li><li>Código de cifrado: #code#</li></ul><br><br><br>Saludos',
    'email_body_user_config_3' => 'Hola #lastname#,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>La siguiente contraseña se espera la próxima vez que uses Teampass:<br><br><b>#password#</b><br><br><br>Saludos',
    'email_body_user_config_4' => 'Hola #lastname#,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>Tu cuenta de Teampass está completamente lista.<br><br>Saludos',
    'email_body_user_config_5' => 'Hola #lastname#,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>El siguiente código se espera la próxima vez que uses Teampass:<br><br><b>#code#</b><br><br><br>Saludos',
    'email_body_user_config_6' => 'Hola #lastname#,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>Las siguientes credenciales se esperan la próxima vez que uses Teampass:<ul><li>inicio de sesión: #login#</li><li>Contraseña: #password#</li></ul><br><br><br>Saludos',
    'error_data_not_valid' => 'Los datos no son válidos',
    'mfa_enabled' => 'MFA habilitado',
    'mfa_disabled_for_user' => 'MFA deshabilitado para el usuario',
    'users_personal_folder' => 'Asegurarse de que se creen las carpetas personales de los usuarios',
    'maintenance_operations' => 'Operaciones de mantenimiento',
    'maintenance_operations_tip' => 'Operaciones de mantenimiento seleccionadas en la base de datos de Teampass.',
    'purge_temporary_files' => 'Purgar archivos temporales',
    'task_scheduling' => 'Programación de tareas',
    'parameter' => 'Parámetro',
    'frequency' => 'Frecuencia',
    'in_minutes' => 'en minutos',
    'hourly' => 'Cada hora',
    'daily' => 'Diariamente',
    'clean_orphan_objects' => 'Limpiar objetos huérfanos',
    'run_once' => 'Ejecutar una vez',
    'run_weekday' => 'Ejecutar en día laborable',
    'monday' => 'Lunes',
    'tuesday' => 'Martes',
    'wednesday' => 'Miércoles',
    'thursday' => 'Jueves',
    'friday' => 'Viernes',
    'saturday' => 'Sábado',
    'sunday' => 'Domingo',
    'monthly' => 'Mensualmente',
    'day_of_month' => 'Día del mes',
    'day' => 'Día',
    'reset' => 'Restablecer',
    'error_while_creating_file' => 'Error al crear el archivo',
    'new_keys_generated' => 'Nuevas claves generadas',
    'user_creation' => 'Creación de usuario',
    'user_deletion' => 'Eliminación de usuario',
    'maximum_session_expiration_time' => 'Tiempo máximo de expiración de sesión',
    'maximum_session_expiration_time_tip' => 'Tiempo máximo en minutos que una sesión puede ser extendida por un usuario',
    'index_session_duration_too_long' => 'La duración de la sesión es demasiado larga',
    'extend_session_duration_by' => 'Extender duración de sesión por',
    'settings_ldap_user_dn_attribute' => 'Nombre distinguido del usuario',
    'settings_ldap_user_dn_attribute_tip' => 'La etiqueta del atributo para el Nombre Distinguido (DN) del usuario en el AD.<br>Ejemplo: Para openLDAP: dn. Para Active Directory: distinguishedname.',
    'open_tasks_settings' => 'Abrir configuraciones de tareas',
    'maximum' => 'máximo',
    'updated' => 'Actualizado',
    'number_of_days' => 'Número de días',
    'number_of_times' => 'Número de veces',
    'sharekey_not_ready' => 'Sharekey aún no generado ... todos los datos del elemento pueden no estar listos ... por favor, inténtalo más tarde',
    'item_action_not_yet_possible' => 'Acción aún no posible en este elemento',
    'open' => 'Abrir',
    'reload_user_cache_table' => 'Recargar tabla de caché de usuario',
    'send_email_to_user' => 'Enviar correo electrónico al usuario',
    'items_management' => 'Operaciones con elementos',
    'previously_used_passwords' => 'Contraseñas utilizadas anteriormente',
    'next_passwords_were_valid_until_date' => 'Las siguientes contraseñas fueron válidas hasta la fecha',
    'feature_disabled_by_administrator' => 'Función deshabilitada por el administrador',
    'shared_globaly' => 'Compartido globalmente',
    'settings_otv_subdomain' => 'Nombre de subdominio OTV',
    'settings_otv_subdomain_tip' => 'Subdominio dedicado para enlaces de un solo uso. Considere su URL principal de Teampass como aislada de internet, este subdominio podría ser accesible por todos para compartir este elemento con alguien fuera de su organización. Desde una perspectiva de seguridad, es mucho más seguro con dicha mecánica. Nota: Esto requerirá tener una entrada DNS para este subdominio apuntando a su servidor Teampass.',
    'existing_valid_otv_links' => 'Enlaces OTV válidos',
    'started' => 'Iniciado',
    'recovery_keys_not_downloaded' => 'Claves de recuperación no descargadas',
    'no_recovery_keys' => 'No tengo claves de recuperación. Esto solo regenerará la clave para los elementos compartidos (sin impacto en los personales que se volverán inutilizables).',
    'provide_recovery_keys' => 'Proporcione sus claves de recuperación',
    'public_key' => 'Clave pública',
    'private_key' => 'Clave privada',
    'download_recovery_keys' => 'Descargue sus claves de recuperación',
    'download_recovery_keys_confirmation' => 'Está a punto de descargar sus claves de recuperación. Por favor, guárdelas en un lugar seguro, ya que deben ser obligatorias en caso de desastre.',
    'recovery_keys_download_date' => 'Fecha de descarga de claves de recuperación',
    'keys_not_recovered' => 'Claves públicas y privadas no almacenadas',
    'keys_not_recovered_explanation' => 'Para prevenir la pérdida de contraseñas, debe almacenar de manera segura sus claves personales de Teampass.',
    'get_your_recovery_keys' => 'Obtenga sus claves de recuperación',
    'keys_management' => 'Gestión de claves',
    'please_confirm_task_to_be_run' => 'Por favor, confirme la tarea a realizar',
    'user_keys_downloaded' => 'Claves de usuario descargadas',
    'mfa_code_send_by_email' => 'Código MFA enviado por correo electrónico',
    'otp' => 'OTP',
    'otp_code' => 'Código OTP',
    'enabled_otp_for_item' => 'Habilitar código OTP',
    'at_otp_status' => 'Estado OTP',
    'phone_number' => 'Número de teléfono relacionado (opcional)',
    'otp_secret' => 'Clave secreta OTP',
    'settings_ldap_group_objectclasses_attibute' => 'Atributo de clases de objeto del grupo AD',
    'settings_ldap_group_objectclasses_attibute_tip' => 'Las clases de objeto a utilizar al buscar grupos. Varias clases de objeto están separadas por una coma (,). Ejemplo: groupOfNames, group o top, posixGroup',
    'display_warning_icons' => 'Mostrar íconos de advertencia',
    'password_length_by_default' => 'Longitud de la contraseña por defecto',
    'progress' => 'Progreso',
    'tasks_log_retention_delay_in_days' => 'Retención del registro de tareas (en días)',
    'tasks_log_table_size' => 'Tamaño de la tabla de registros de tareas',
    'error_otp_secret' => '¿Habilitar para decodificar el secreto OTP, es correcto el secreto?',
    'users_api_access_info' => 'Los usuarios pueden acceder a la API con los mismos derechos de acceso que en Teampass.',
    'error_folder_not_allowed_for_this_user' => 'La carpeta no está permitida para este usuario',
    'allowed_to_create' => 'Permitido crear',
    'allowed_to_read' => 'Permitido leer',
    'allowed_to_update' => 'Permitido actualizar',
    'allowed_to_delete' => 'Permitido eliminar',
    'folder_created' => 'Carpeta creada',
    'login_with_sso' => 'Iniciar sesión con SSO',
    'server_connected_to_internet' => 'El servidor está conectado a internet',
    'server_not_connected_to_internet' => 'El servidor no está conectado a internet',
    'server_not_connected_to_internet_tip' => 'Esto podría provocar que varias funcionalidades no funcionen correctamente. Especialmente MFA.',
    'tools' => 'Herramientas',
    'user_config_not_compliant' => 'La configuración del usuario no cumple con los requisitos',
    'fix_personal_items_empty' => 'Solucionar que los elementos personales estén vacíos',
    'fix_personal_items_empty_tip' => 'Esta herramienta permite solucionar el problema de que los elementos personales estén vacíos después de una actualización de Teampass. Requiere haber restaurado una copia de la tabla teampass_items de la versión 2 de Teampass. La tabla debe llamarse teampass_items_v2.',
    'table_not_exists' => 'La tabla esperada no existe. Por favor, restáurela desde una copia de seguridad.',
    'tools_usage_warning' => 'El uso de herramientas puede tener un impacto directo en la base de datos. Por favor, sea cuidadoso. Siempre realice un volcado antes y defina un periodo de mantenimiento.',
    'select_user' => 'Seleccionar usuario',
    'show_item_data' => 'Mostrar los datos del elemento en la lista de elementos',
    'show_item_data_tip' => 'Permite mostrar información adicional en la lista de elementos (nombre de usuario, correo electrónico y URL). Esto podría ser útil para tener una vista rápida del contenido del elemento.',
    'items_page_split_view_mode' => 'Mostrar los detalles del elemento en modo de vista dividida de página',
    'replace_tenant_id' => 'Adapte la URL pero mantenga {tenant-id} tal cual. Se reemplazará en vivo por el ID del inquilino.',
    'user_not_allowed_to_auth_to_teampass_app' => 'El usuario no tiene permitido autenticarse en la aplicación Teampass',
    'user_is_not_auth_with_oauth2' => 'El usuario no debe autenticarse con Entra/Azure AD',
    'highlight_favorites' => 'Resaltar favoritos',
    'highlight_favorites_tip' => 'Cuando está habilitado, los elementos favoritos se resaltarán en la lista.',
    'limited_search_default' => 'Búsqueda limitada por defecto',
    'limited_search_default_tip' => 'Cuando está habilitada, la búsqueda se limitará a la carpeta actual y sus subcarpetas. De lo contrario, la búsqueda se realizará en todos los elementos.',
    'highlight_selected_tip' => 'Cuando está habilitado, el elemento seleccionado se resaltará en la lista.',
    'encryptClientServer' => 'Cifrar cliente/servidor',
    'encryptClientServer_tip' => 'Cuando está habilitado, el cliente cifra los datos antes de enviarlos al servidor. El servidor solo almacena los datos cifrados. Se puede deshabilitar.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL para obtener los detalles del usuario',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL para obtener los detalles del usuario. Se utiliza para obtener los detalles del usuario después de la autenticación.',
    'duo_redirect_uri' => 'Redirigiendo al aviso de Duo',
    'number_users_build_cache_tree' => 'Número de usuarios procesados para la tarea build_cache_tree.',
    'number_users_build_cache_tree_tip' => 'Número de usuarios procesados para la tarea build_cache_tree en cada ejecución del programador.',
    'user_password_expired' => 'Tu contraseña ha expirado. Por favor, cámbiala.',
    'user_password_policy_tip' => 'La nueva contraseña debe cumplir con los siguientes requisitos:<br/> - Ser diferente a la anterior<br/> - Contener al menos 10 caracteres<br/> - Incluir al menos una letra mayúscula y una minúscula<br/> - Incluir al menos un número o un carácter especial<br/> - No contener tu nombre, apellidos, nombre de usuario o correo electrónico.',
    'bruteforce_unlock_at' => 'Cuenta desbloqueada a las (anti fuerza bruta): ',
    'bruteforce_reset_account' => 'Restablecer protección anti fuerza bruta del usuario',
    'bruteforce_reset_mail_subject' => 'TEAMPASS - Tu cuenta está deshabilitada',
    'bruteforce_reset_mail_body' => 'Hola #name#,<br/><br/>Tu cuenta de Teampass ha sido bloqueada debido a numerosos intentos fallidos de autenticación.<br/><br/>Puedes desbloquearla haciendo clic en este enlace <a href="#reset_url#" target="_blank">#reset_url#</a><br/><br/>Desbloqueo automático: #unlock_at#',
    'disable_user_edit_profile' => 'Los usuarios ya no pueden editar su perfil',
    'disable_user_edit_language' => 'Los usuarios ya no pueden cambiar el idioma',
    'disable_user_edit_timezone' => 'Los usuarios ya no pueden cambiar la zona horaria',
    'disable_user_edit_tree_load_strategy' => 'Los usuarios ya no pueden cambiar la estrategia de carga del árbol',
    'bruteforce_wait' => 'Demasiados intentos fallidos, tu cuenta está bloqueada hasta: ',
    'disable_drag_drop' => 'Deshabilitar la función de arrastrar y soltar elementos',
    'clipboard_cleared' => 'Clipboard cleared',
    'error_data_not_consistent' => 'Data is not consistent',
    'error_permission_denied' => 'Permission denied',
    'error_invalid_action' => 'Invalid action',
    'error_fetching_password' => 'Error fetching password',
    'unable_to_clear_clipboard' => 'Unable to clear the clipboard manually',
    'clipboard_unsafe' => 'The clipboard could not be cleared automatically, this is unsafe!',
    'clipboard_clear_now' => 'Clear it now!',
    'clipboard_clearing_failed' => 'Clipboard clearing failed',
    'clipboard_error' => 'Clipboard error',

);
