<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      polish.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2025 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Wyświetl kod szyfrowania użytkownika',
    'email_body_new_user' => 'Witaj,<br><br>Ten email został wygenerowany z system zarządzania haseł Teampass.<br><br>Administrator utworzył dla Ciebie hasło w systemie. Przy następnym logowaniu do systemu Teampass, użyj następujących poświadczeń:<ul><li>login: #login#</li><li>Password: #password#</li><li>Kod szyfrowania: #code#</li></ul><br><br><br>Pozdrowienia',
    'user_password' => 'Hasło użytkownika',
    'user_temporary_encryption_code' => 'Kod szyfrowania użytkownika',
    'no_email_set' => 'Nie został zarejestrowany adres email',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'Ta czynność spowoduje zresetowanie kodu szyfrowania dla tego użytkownika.',
    'send_by_email' => 'Wyślij wiadomością email',
    'filters' => 'Filtry',
    'show_user_password' => 'Wyświetl hasło użytkownika',
    'open_website' => 'Otwórz stronę WWW',
    'mfa_for_roles' => 'Mechanizm MFA jest wymagany dla roli użytkowników',
    'mfa_for_roles_tip' => 'Domyślnie, jedna metoda MFA może być wybrana włączona dla wszystkich użytkowników. Jednakże możesz wybrać role, dla których jest ona Wymagana.<br>JESZCZE NIE WDRAŻONE',
    'at_least_one_administrator_is_requested' => 'Wymagany jest co najmniej jeden administrator',
    'bad_code' => 'Niepoprawny kod',
    'generating_keys' => 'Generowanie kluczy',
    'this_may_take_time' => 'To może zająć kilka minut',
    'disable_enable' => 'Wyłączenie / Włączenie',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'Wymagane jest wygenerowanie bazy kluczy dla Twojego konta. Proszę o podanie Twojego klucza szyfrowania',
    'managed_through_ad' => 'Zarządzane za pomocą AD',
    'new_ldap_user_info' => 'Uzupełnij definicję użytkownika',
    'email_body_user_added_from_ldap_encryption_code' => 'Cześć,<br><br>To jest wiadomość e-mail wygenerowana od menedżera haseł Teampass.<br><br>Masz teraz aktywne konto w systemie Teampass. Możesz użyć swoich danych logowania LDAP, aby się zalogować do systemu.<br><br>Przy pierwszym logowaniu będzie oczekiwany od Ciebie kod szyfrujący wskazany poniżej:<br><br><b>#enc_code#</b><br><br><br>',
    'settings_ldap_user_object_filter' => 'Filtr użytkowników',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Dodatkowy DN użytkownika',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your LDAP since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Twoje poprzednie hasło',
    'admin_change_user_password_info' => 'Ta czynność spowoduje zresetowanie aktualnego hasła dla wybranego użytkownika.',
    'sending_email_message' => 'Wysyłanie wiadomości email do użytkownika, proszę poczekać',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Wprowadzone hasła nie są takie same',
    'inititialization' => 'Inicjalizacja',
    'bad_password' => 'Błędne hasło',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, use your current credentials and use this temporary encryption code when requested:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosty',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Port używane do uwierzytelnienia do LDAP. Domyślnie używane porty: dla połączenie nieszyfrowanych: 389, dla połączeń szyfrowanych: 636. ',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'Lista użytkowników',
    'ldap_synchronization' => 'Synchronizacja LDAP',
    'in_progress' => 'W trakcie',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Hasło zostało skopiowane do schowka. Wkrótce zostanie z niego usunięte…',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Wyczyść formularz',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Zaznacz wszystko',
    'unselect_all' => 'Odznacz wszystko',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Serwer',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Wyświetlaj foldery tylko do głębokości',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Logi',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propaguj uprawnienia',
    'propagate_user_rights' => 'Propaguj prawa użytkownika',
    'register_new_yubiko_key' => 'Zarejestruj nowy klucz Yubiko',
    'part_of_groups' => 'Członek następujących grup',
    'previous_value' => 'Poprzednia wartość',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'Nie można otworzyć pliku',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Folder docelowy',
    'select_file' => 'Wybierz plik',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Wykonaj kopię zapasową',
    'perform_restore' => 'Przywróć kopię',
    'backup_select' => 'Plik kopii zapasowej',
    'choose_file' => 'Wybierz plik',
    'on_the_fly' => 'W locie',
    'scheduled' => 'Zaplanowane',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Pozycja',
    'before' => 'Przed',
    'top' => 'Na górze',
    'bottom' => 'Na dole',
    'field' => 'Pole',
    'configuration' => 'Konfiguracja',
    'definition' => 'Szczegóły',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Ostatnie wykonanie',
    'never_performed' => 'Nigdy nie wykonane',
    'launch' => 'Uruchom',
    'set_of_actions' => 'Zestaw akcji',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Konfiguracja przesyłania plików',
    'email_configuration' => 'Konfiguracja emaila',
    'email_configuration_test' => 'Test konfiguracji emaila',
    'send_a_test_email' => 'Wyślij testowy email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Wyślij maile oczekujące',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Dodaj nowy adres IP do białej listy',
    'adding_new_api_key' => 'Dodaj nowy klucz API',
    'api_configuration' => 'Konfiguracja API',
    'mfa_configuration' => 'Konfiguracja MFA',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'Musisz wybrać przynajmniej jeden folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Zastosuj',
    'from' => 'Od',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Zakres dat',
    'purge' => 'Oczyść',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Uwaga',
    'role_not_exist' => 'This role doesn\"t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Wybierz rolę',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Proszę zatwierdzić',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Role',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Etykieta',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Kliknij aby otworzyć stronę internetową Teampass',
    '2fa_credential_not_correct' => 'Poświadczenia 2FA są nieprawidłowe',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Siła hasła',
    'new_password_required' => 'Wymagane jest nowe hasło',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'Aktualnie nie posiadasz żadnych ulubionych wpisów',
    'favorites' => 'Ulubione',
    'confirm_item_move' => 'You have selected Moving"... are you sure?"',
    'copy_to_clipboard' => 'Skopiuj do schowka',
    'please_wait_while_loading' => 'Proszę poczekać na załadowanie danych',
    'defect_report' => 'Zgłoś błąd',
    'actions' => 'Akcje',
    'no_user' => 'Nieprawidłowy użytkownik',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profil',
    'language' => 'Język',
    'upload_new_avatar' => 'Wybierz plik PNG awatara',
    'settings' => 'Ustawienia',
    'created_items' => 'Utworzone wpisy',
    'modification_performed' => 'Wykonane modyfikacje',
    'items_opened' => 'Otwarte wpisy',
    'passwords_seen' => 'Widziane hasła',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Liczba wyświetleń',
    'automatic_deletion_engaged' => 'Automatyczne kasowanie',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Kopiuj katalog',
    'select_source_folder' => 'Wybierz katalog do kopiowania',
    'select_destination_folder' => 'Wskaż katalog docelowy',
    'delete_folder' => 'Wykasuj katalog',
    'select_folder_to_delete' => 'Wskaż folder do wykasowani',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Niepoprawny format JSON',
    'password_cannot_be_empty' => 'Hasło nie może być puste',
    'password_too_long' => 'Hasło ma zbyt dużo znaków',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'E-maile',
    'backups' => 'Kopie zapasowe',
    'api' => 'API',
    'add_folder' => 'Dodaj nowy katalog',
    'select_folder_parent' => 'Wybierz katalog nadrzędny',
    'add' => 'Dodaj',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Adres email',
    'enter_email' => 'Enter email',
    'notification' => 'Powiadomienia',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Udostępnij element',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Informacja',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'Nowy wpis',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Wybierz pliki',
    'attached_files' => 'Attached files',
    'visible_by' => 'Widoczne dla',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Hasło',
    'save' => 'Zapisz',
    'folder' => 'Katalog',
    'main' => 'Main',
    'fields' => 'Pola',
    'details' => 'Szczegóły',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Zapisane',
    'attachments' => 'Załączniki',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'wersja',
    'statistics' => 'Statystyki',
    'options' => 'Opcje',
    'users' => 'Użytkownicy',
    'folders' => 'Katalog',
    'find_message' => 'obiektów znaleziono',
    'auto_update_server_password_info' => 'Kliknięcie start, automatycznie wykona poniższe kroki:<ul><li>Połączenie przez SSH do serwera wykorzystując dane logowania i pole `URL`,</li><li>Zmiana hasła użytkownika na serwerze</il><li>Zachowanie nowego hasła w Teampass</il><li>Zakończenie połączenia SSH</li></ul><br /><b>Upewnij się, że użytkownik posiada prawa do zalogowania się i zmiany hasła na serwerze (jeśli nie, określ hasło użytkownika root) przed uruchomieniem.</b> ',
    'share' => 'Udostępnij',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'Musisz wybrać folder',
    'email_subject_item_updated' => 'Hasło zostało zaktualizowane.',
    'email_body_item_updated' => 'Witaj,<br><br>To jest wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Poprosiłeś o otrzymywanie powiadomień o zmianach wprowadzonych w pozycji `#item_label#` w folderze `#folder_name#`.<br><br>Użytkownik <b>#name# #lastname#</b> dokonał co najmniej jednej zmiany.<br><br>Można go otworzyć, klikając przycisk <a href=&apos;#url#/index.php?page=items&group=#item_category#&id=#item_id#&apos;>LINK</a>.<br><br>Cheers',
    'import_kp_finished' => 'Importowanie z KeePass zastało zakończone !<br />Domyślnie, poziom skomplikowania nowych folderów zostały ustawione na `Medium`. Być może będziesz musiał to zmienić.',
    'password_is_empty' => 'Element nie posiada hasła',
    'bug_report_to_github' => 'Wypełnij zawartość raportu, następnie skopiuj ją i wklej na nowej stronie z błędami w Github-ie.',
    'open_bug_report_in_github' => 'Zgłoś problem na Github-ie',
    'bugs_page' => 'Jeżeli wykryłeś błąd, możesz go zgłosić na github.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Ustaw uprawnienie "każdy z taką samą rolą może modyfikować" na wszystkich importowanych elementach.',
    'import_csv_anyone_can_modify_txt' => 'Ustaw uprawnienie "każdy może modyfikować" na wszystkich importowanych elementach.',
    'settings_upload_imageresize_options' => 'Zmień rozmiar obrazów',
    'user_not_exists' => 'Użytkownik nie istnieje',
    'auto_create_folder_role' => 'Dodaj Folder oraz Rolę dla ',
    'start_upload' => 'Rozpocznij wysyłanie plików',
    'error_upload_runtime_not_found' => 'Opcja uaktualnienia: Nie znaleziono wykonania.',
    'user_profile_api_key' => 'Twój klucz API',
    'index_change_pw' => 'Zmień hasło',
    'admin_2factors_authentication_setting' => 'Uaktywnij 2-poziomową autoryzację dla Google',
    'admin_2factors_authentication_setting_tip' => '<span style="font-size:11px;max-width:300px;">Uwierzytelnianie dwuskładnikowe Google umożliwia dodanie kolejnego zabezpieczenia do logowania się użytkownika. W momencie gdy użytkownik chce logować się do TeamPass w ten sposób generowany jest jednorazowy kod QR. Kod QR musi zostać zeskanowany, aby otrzymać jednorazowe hasło.<br />UWAGA: Wymaga to skanera kodów QR (np. smartphon-a) oraz dostępu do internetu przy pierwszym użyciu.</span> ',
    'admin_ga_website_name' => 'Wyświetlana nazwa w Google Authenticator dla Teampass',
    'admin_ga_website_name_tip' => 'Ta nazwa jest użyta jako kod identyfikacyjny w Google Authenticator.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] Element został Ci udostępniony',
    'email_share_item_mail' => 'Witaj,<br><br><u>#tp_user#</u> udostępnia Ci pozycję <b>#tp_item#</b>.<br>Kliknij na <a href="#tp_link#">LINK</a> aby ją obejrzeć.<br><br>Pozdrawiam.',
    'index_maintenance_mode_admin' => 'Tryb konserwacji został aktywowany. Normalni Użytkownicy nie mogą się zalogować do TeamPass.',
    '2fa_authentication_selector' => 'Wybierz metodę uwierzytelnienia 2FA',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Zaloguj',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'ID użytkownika',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Wyślij emaila z Google Authenticator do użytkownika',
    'error_no_email' => 'Ten użytkownik nie ma ustawionego adresu e-mail',
    'error_no_user' => 'Nie znaleziono użytkownika!',
    'email_ga_subject' => 'Twój jednorazowy kod dostępu (Google Authenticator) do Teampass-a',
    'email_ga_text' => 'Witaj,<br><br>Ta wiadomość e-mail wygenerowana jest przez menadżera hasła Teampass.<br><br>Twój administrator oczekuje że będziesz korzystał z weryfikacji dwuetapowej, podczas korzystania z Teampass-a.<br>Przy pierwszym połączeniu z Teampass-em, proszę użyj kodu znajdującego się poniżej pola "Kod identyfikacyjny":  <br><br>----------------------<br>#2FACode#<br>----------------------<br><br> Będziesz miał możliwość ustawić jednorazowo twoje dane do menadżera haseł Teampass<br><br>Pozdrawiamy!',
    'settings_attachments_encryption' => 'Szyfruj załączone pliki',
    'settings_attachments_encryption_tip' => 'TA OPCJA MOŻE USZKODZIĆ ZAPISANE ZAŁĄCZNIKI, proszę przeczytaj poniższe uwagi. Jeśli opcja szyfrowania jest aktywowana, załączniki są zaszyfrowane na serwerze. Szyfrowanie używa klucz SALT podanego w Teampass. Opcja ta zwiększa zużycie zasobów serwera. OSTRZEŻENIE: po zmianie, wymagane jest uruchomienie skryptu aktualizacji zapisanych załączników. Zobacz zakładkę &apos;Operacje Dodatkowe&apos;.',
    'admin_action_attachments_cryption' => 'Zaszyfruj lub Odszyfruj wszystkie załączone pliki',
    'admin_action_attachments_cryption_tip' => 'OSTRZEŻENIE:  to działanie musi być wykonane tylko po zmianie wybranej opcji w ustawieniach Teampass. Proszę, utwórz kopię folderu &apos;upload&apos; przed zmianą opcji, tak na wszelki wypadek ...',
    'encrypt' => 'Zaszyfruj',
    'decrypt' => 'Odszyfruj',
    'ga_identification_code' => 'Kod identyfikacyjny',
    'ga_enter_credentials' => 'Musisz wprowadzić Twoje dane logowania',
    'ga_bad_code' => 'Błędny kod Google Authenticator',
    'settings_get_tp_info' => 'Pokaż informacje o nowościach administratorowi.',
    'settings_get_tp_info_tip' => 'Kiedy włączone, informacje takie jak: bieżąca wersja, poprawki błędów czy nowe wydania, są wyświetlane na stronie administratora "informacje", z serwera Teampass.',
    'settings_offline_mode' => 'Aktywuj tryb Off-line',
    'settings_offline_mode_tip' => 'Tryb Off-line polega na wyeksportowaniu pozycji do pliku HTML. Pozycje na tej stronie są szyfrowane kluczem zdefiniowanym przez Użytkownika.',
    'offline_mode_key_level' => 'Minimalny poziom klucza szyfrującego dla trybu Off-line',
    'categories' => 'Pola niestandardowe',
    'no_category_defined' => 'Kategoria NIE została stworzona.',
    'confirm_deletion' => 'Wybrałeś usuń ... jesteś pewien?',
    'settings_item_extra_fields' => 'Niestandardowe pola elementów włączone',
    'settings_item_extra_fields_tip' => 'Ta opcja zezwala na dodanie do pozycji dodatkowych pól, które są zdefiniowane i podzielone na kategorie przez administratora. Wszystkie dane są szyfrowane. Opcja ta wykorzystuje dodatkowe zapytania SQL (około 5 razy więcej na dodatkowe Pole podczas aktualizacji pozycji) co może wymagać więcej czasu na zakończenie działania. Zależnie od możliwości serwera.',
    'settings_ldap_type' => 'Typ serwera LDAP',
    'server_time' => 'Czas na serwerze',
    'settings_tree_counters' => 'Pokaż więcej liczników w drzewie folderów',
    'settings_tree_counters_tip' => 'Po wybraniu tej opcji przy każdym katalogu będą wyświetlane 3 liczniki: liczba pozycji w folderze, liczba pozycji w podfolderze, liczba podfolderów. Włączenie tej opcji może wydłużyć czas potrzebny na wyświetlenie drzewa katalogów.',
    'admin_action_check_pf' => 'Stwórz osobisty folder dla wszystkich użytkowników (jeśli go nie posiadają)',
    'enable_personal_folder_feature_tip' => 'Osobiste Foldery - to miejsce na prywatne hasła poszczególnych użytkowników. Hasła są zaszyfrowane przez klucz "Saltkey" (bardziej bezpieczne), lub przez ich własne hasło (prostsze). Włączenie tej opcji nie tworzy katalogów dla istniejących użytkowników',
    'administrators_only' => 'Tylko Administratorzy',
    'managers_of' => 'Role menadżerów',
    'managed_by' => 'Zarządzany przez',
    'settings_enable_sts' => 'Wymuś połączenie szyfrowane HTTPS STS -- <strong>Ostrzeżenie !</strong> Przeczytaj uwagi.',
    'settings_enable_sts_tip' => 'Ostrzeżenie! Wymusi to szyfrowanie połączenie HTTPS STS. STS pomaga uniknąć ataku "man-in-the-middle". Do użycia tej opcji WYMAGANY jest podpisany certyfikat SSL. Jeśli posiadasz własny, niepodpisany certyfikat SSL i wybierzesz tą opcję Teampass przestanie działać!! Wymagana jest również konfiguracja SSL serwera Apache:  &apos;SSLOptions +ExportCertData&apos;.',
    'settings_anyone_can_modify_bydefault' => 'Aktywuj &apos;<b><i>Każdy może modyfikować</b></i>&apos; (opcja domyślna)',
    'to' => 'do',
    'settings_upload_maxfilesize_tip' => 'Maksymalna dozwolona wielkość pliku. Powinna być zgodna z ustawieniami twojego serwera.',
    'settings_upload_docext_tip' => 'Typy dokumentów. Dodaj rozszerzenia plików dokumentów oddzielając je przecinkiem (,)',
    'settings_upload_imagesext_tip' => 'Typy obrazów. Dodaj rozszerzenia plików obrazów dozwolonych w załącznikach oddzielając je przecinkiem (,)',
    'settings_upload_pkgext_tip' => 'Typy archiwów. Dodaj rozszerzenia plików archiwów dozwolonych w załącznikach oddzielając je przecinkiem (,)',
    'settings_upload_otherext_tip' => 'Inne typy. Dodaj rozszerzenia plików innego typu, dozwolonych w załącznikach oddzielając je przecinkiem (,)',
    'settings_upload_imageresize_options_tip' => 'Po zaznaczeniu, opcja ta zmienia rozmiar obrazów do formatu wskazanego poniżej.Wybierz maksymalny dozwolony rozmiar (w pikselach). Obrazy powyżej 1000 pikseli szerokości mogą być wyświetlane nieprawidłowo.',
    'settings_upload_maxfilesize' => 'Maksymalny rozmiar pliku załącznika (MB)',
    'settings_upload_docext' => 'Dozwolone rozszerzenia dokumentów',
    'settings_upload_imagesext' => 'Dozwolone rozszerzenia obrazów',
    'settings_upload_pkgext' => 'Dozwolone rozszerzenia archiwów',
    'settings_upload_otherext' => 'Inne dozwolone rozszerzenia',
    'settings_upload_imageresize_options_w' => 'Maksymalna szerokość obrazu (piksele)',
    'settings_upload_imageresize_options_h' => 'Maksymalna wysokość obrazu (piksele)',
    'settings_upload_imageresize_options_q' => 'Jakość obrazu JPEG',
    'settings_importing' => 'Zezwól na importowanie danych z pliku CVS/KeyPass',
    'admin_proxy_ip' => 'Adres IP używanego Proxy',
    'admin_proxy_ip_tip' => '<span style="font-size:11px;max-width:300px;">Jeśli łączysz się za pomocą serwera proxy podaj jego adres IP tutaj.<br />Pozostaw puste, jeśli nie używasz Proxy</span> ',
    'admin_proxy_port' => 'Port serwera Proxy',
    'admin_proxy_port_tip' => '<span style="font-size:11px;max-width:300px;">Jeśli ustawiony został adres IP Proxy, wymagane jest podanie również portu (przeważnie jest nim PORT 8080).<br />Pozostaw puste jeśli IP Proxy nie zostało ustawione.</span> ',
    'settings_ldap_elusers' => '␣Tylko lokalni użytkownicy Teampass␣',
    'settings_ldap_elusers_tip' => ' Cecha ta umożliwia użytkownikom na uwierzytelnianie się poprzez LDAP. Wyłącz tą cechę jeśli chcesz przeglądać dowolny folder LDAP. ',
    'db_items_edited' => 'Element jest w trakcie edycji',
    'item_edition_start_hour' => 'Edycja rozpoczęta od',
    'settings_delay_for_item_edition' => 'Po jakim czasie edytowania modyfikowanie uznane jest za nieudane (w minutach)',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Podczas edytowania elementu, jest on zablokowany dla reszty Użytkowników. Ustawiany jest odpowiedni znacznik elementu podczas edycji<br />Opcja ta pozwala na pominięcie tego znacznika jak również zablokowanie edycji elementu (nie dla Administratora)</span>',
    'db_users_logged' => 'Aktualnie zalogowani Użytkownicy',
    'action' => 'Akcja',
    'login_time' => 'Zalogowany od',
    'lastname' => 'Nazwisko',
    'user_login' => 'Login',
    'role' => 'Rola',
    'error_role_exist' => 'Ta rola już istnieje!',
    'error_no_edition_possible_locked' => 'Edycja nie jest możliwa. Ten element jest aktualnie edytowany!',
    'select' => 'wybierz',
    'items' => 'Elementy',
    'enable_personal_saltkey_cookie' => 'Zezwól na przetrzymywanie osobistego klucza SALTKey w Ciasteczkach',
    'personal_saltkey_cookie_duration' => 'Ilość dni do wygaśnięcia Ciasteczka z osobistym kluczem SALTKey',
    'admin_email_smtp_server' => 'Serwer SMTP',
    'admin_email_auth' => 'Serwer SMTP wymaga autoryzacji',
    'admin_email_auth_username' => 'Nazwa Użytkownika do autoryzacji',
    'admin_email_auth_pwd' => 'Hasło do autoryzacji',
    'admin_email_port' => 'Port Serwera',
    'admin_email_from' => 'Adres Nadawcy (z adresu E-mail)',
    'admin_email_from_name' => 'Nazwa Nadawcy (z Nazwy)',
    'admin_email_test_configuration_tip' => 'Ten test powinien wysłać wiadomość email na wprowadzony adres. Jeśli nie otrzymasz wiadomości, proszę sprawdź swoje dane logowania.',
    'admin_email_test_subject' => '[TeamPass] E-mail testowy',
    'admin_email_test_body' => 'Cześć,<br><br>E-mail został wysłany poprawnie.<br><br>Pozdrawiam.',
    'admin_email_result_ok' => 'E-mail wysłany do #email# ... sprawdź skrzynkę.',
    'email_bodyalt_item_updated' => 'Hasło dla #item_label# zostało zaktualizowane.',
    'admin_email_send_backlog_tip' => 'Skrypt ten wymusza wysłanie e-maili zapisanych w bazie danych.<br />Czynność ta może wymagać większej ilości czasu, zależnie od ilości maili do wysłania.',
    'please_wait' => 'Proszę czekaj!',
    'admin_path_to_files_folder' => 'Ścieżka do folderu Plików',
    'admin_path_to_files_folder_tip' => '<span style="font-size:11px;max-width:300px;">Folder Files jest przeznaczony do przechowywania plików wygenerowanych przez TeamPass, oraz plików wgranych przez użytkowników.<br />Ważne: ze względów bezpieczeństwa, folder ten nie powinien być w katalogu głównym serwera. Powinien być odpowiednim, zabezpieczonym katalogu. Dodatkowo powinno się ten katalog co pewien czas czyścić np. za pomocą zadań CRON serwera</span>',
    'admin_path_to_upload_folder_tip' => '<span style="font-size:11px;max-width:300px;">Katalog Upload jest przeznaczony do przechowywania wszystkich plików, które są skojarzone z elementami.<br />WAŻNE: Dla celów bezpieczeństwa, katalog ten nie powinien być katalogiem z dostępem do przeglądania. Powinien zawierać odpowiednie zabezpieczenia.<br />WAŻNE 2: Folder nie powinien być czyszczony z racji powiązania z wpisanymi pozycjami!</span> ',
    'pdf_password_warning' => 'Musisz wprowadzić klucz szyfrowania!',
    'admin_pwd_maximum_length' => 'Maksymalna długość hasła',
    'admin_pwd_maximum_length_tip' => 'Domyślnie długość hasła ustawiona jest na 40. Długość hasła ma wpływ na wydajność. Im dłuższe hasło tym więcej potrzebnych jest zasobów serwera na szyfrowanie i odszyfrowanie, lub wyświetlenie hasła.',
    'settings_insert_manual_entry_item_history' => 'Zezwalaj na ręczne edytowanie logów Historii pozycji',
    'settings_insert_manual_entry_item_history_tip' => 'W przypadku gdy potrzebujesz dodać ręcznie wpisy historii pozycji możesz uaktywnić tą opcję.',
    'admin_path_to_upload_folder' => 'Ścieżka do folderu wysyłania',
    'admin_setting_enable_delete_after_consultation' => 'Konsultowany element może być automatycznie kasowany',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Aktywowane, użytkownik dodający pozycję może zdecydować kiedy element zostanie automatycznie skasowanym, po tym jak zostanie wyświetlony X razy</span>',
    'at_email' => 'e-mail',
    'enable_email_notification_on_item_shown' => 'Wyślij notyfikacje poprzez e-mail, gdy element jest pokazany',
    'share_sent_ok' => 'E-mail został wysłany',
    'see_item_title' => 'Szczegóły elementu',
    'email_on_open_notification_subject' => '[TeamPass] Powiadomienia o otwarciu elementu',
    'email_on_open_notification_mail' => 'Witaj,<br><br>#tp_user# otworzył oraz przegląda pozycję &apos;#tp_item#&apos;.<br>Kliknij na <a href="#tp_link#">LINK</a> aby do niej przejść.<br><br>Pozdrawiam.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Dodawanie konta',
    'email_new_user_mail' => 'Witaj,<br><br>Administrator dodał Twoje konto w Teampass.<br>Poniżej podane są dane wymagane przy logowaniu:<br>- Login: #tp_login#<br>- Hasło: #tp_pw#<br><br>Możesz się zalogować klikając <a href="#tp_link#">TUTAJ</a>.<br><br>Pozdrawiam. ',
    'error_empty_data' => 'Nie wprowadzono danych!',
    'error_not_allowed_to' => 'Nie jesteś do tego upoważniony!',
    'request_access_ot_item' => 'Uzyskaj dostęp autora',
    'email_request_access_subject' => '[TeamPass] Zarządzaj dostępu do elementu',
    'email_request_access_mail' => 'Witaj #tp_item_author#,<br><br>Użytkownik #tp_user# prosi o dostęp do hasła &apos;#tp_item#&apos;.<br><br>Żądanie przychodzi z następującym uzasadnieniem:<br><i>"#tp_reason#"</i><br><br>Zapoznaj się z tą prośbą i potwierdź, że autoryzujesz dostęp.<br><br>Pozdrawiam. ',
    'admin_action_change_salt_key' => 'Zmień główny klucz SALTKey',
    'nb_items_by_query' => 'Liczba elementów na pobranie przy każdej iteracji zapytania',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Więcej pozycji znaczy więcej czasu aby wyświetlić listę.<br />Ustaw &apos;auto&apos; aby pozwolić na automatyczne dostosowanie liczby pozycji w zależności od wielkości ekranu użytkownika.<br />Ustaw &apos;max&apos; aby wymusić pełną listę za jednym razem.<br />Ustaw liczbę pozycji pobieranych przy każdej iteracji.</span> ',
    'open_url_link' => 'Otwórz w nowej karcie',
    'error_pw_too_long' => 'Hasło jest zbyt długie! Maksymalna długość to 40 znaków.',
    'at_restriction' => 'Restrykcje',
    'pw_encryption_error' => 'Błąd szyfrowania hasła!',
    'enable_send_email_on_user_login' => 'Po zalogowaniu Użytkownika wyślij email do Administratora',
    'email_subject_on_user_login' => '[TeamPass] Użytkownik się zalogował',
    'email_body_on_user_login' => 'Witam,<br><br>Użytkownik #tp_user# zalogował się doTeamPass dnia #tp_date# o godzinie #tp_time#.<br><br>Pozdrawiam.',
    'account_is_locked' => 'Konto zablokowane',
    'activity' => 'Aktywność',
    'add_role_tip' => 'Dodan nową Rolę.',
    'admin' => 'Zarządzanie',
    'admin_action_db_backup' => 'Wykonaj kopię bezpieczeństwa bazy danych',
    'admin_action_db_clean_items' => 'Usuń niepowiązane pozycje z bazy danych',
    'admin_action_db_clean_items_tip' => 'Spowoduje to tylko usunięcie tych elementów i powiązanych logów, które nie zostały usunięte, kiedy skojarzony folder został usunięty.. Sugeruje się wcześniejsze wykonanie kopii.',
    'admin_action_db_optimize' => 'Optymalizuj bazę danych',
    'admin_action_db_restore' => 'Odzyskaj bazę danych',
    'admin_action_purge_old_files' => 'Oczyść stare pliki',
    'admin_action_purge_old_files_tip' => 'Zostaną usunięte pliki tymczasowe, które są starsze niż 7 dni.',
    'admin_action_reload_cache_table' => 'Przeładuj pamięć podręczną tabeli',
    'admin_action_reload_cache_table_tip' => 'Umożliwia to przeładowanie pełnej zawartości pamięci podręcznej tabeli. Czasem wykonanie tej czynności może być przydatne.',
    'admin_help' => 'Pomoc',
    'admin_ldap_configuration' => 'Konfiguracja LDAP',
    'admin_main' => 'Informacje',
    'admin_misc_cpassman_dir' => 'Pełna ścieżka do TeamPass',
    'admin_misc_cpassman_url' => 'Pełen adres URL do TeamPass',
    'admin_misc_custom_login_text' => 'Własny tekst logowania',
    'admin_misc_custom_logo' => 'Pełen adres URL dla własnego Loga logowania',
    'admin_misc_favicon' => 'Pełen adres URL ikony favicon',
    'admin_settings' => 'Ustawienia',
    'admin_settings_title' => 'Ustawienia TeamPass',
    'admin_setting_activate_expiration' => 'Aktywuj wygasanie haseł',
    'admin_setting_activate_expiration_tip' => 'Po wybraniu tej opcji dane pozycje nie będą wyświetlane Użytkownikom.',
    'admin_views' => 'Widoki',
    'alert_message_done' => 'Zrobione!',
    'all' => 'wszystkie',
    'anyone_can_modify' => 'Zezwól na modyfikację elementu przez każdego, kto ma do niego dostęp',
    'at' => 'przy',
    'at_category' => 'Folder',
    'at_copy' => 'Kopia wykonana',
    'at_delete' => 'Usunięcie',
    'at_description' => 'Opis.',
    'at_label' => 'Etykieta',
    'at_login' => 'Login',
    'at_moved' => 'Przeniesiony',
    'at_personnel' => 'Osobisty',
    'at_restored' => 'Przywrócony',
    'at_shown' => 'Udostępniono',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Foldery udostępnione',
    'auth_creation_without_complexity' => 'Zezwól na dodanie elementu bez respektowania wymogu złożoności hasła',
    'auth_modification_without_complexity' => 'Zezwól na modyfikowanie elementu bez respektowania wymogu złożoności hasła',
    'cancel' => 'Anuluj',
    'can_create_root_folder' => 'Może dodać folder na poziomie Root',
    'changelog' => 'Ostatnie informacje',
    'close' => 'Zamknij',
    'complexity' => 'Złożoność',
    'complex_asked' => 'Wymagana złożoność',
    'complex_level0' => 'Bardzo słabe',
    'complex_level1' => 'Słabe',
    'complex_level2' => 'Średnie',
    'complex_level3' => 'Silne',
    'complex_level4' => 'Bardzo silne',
    'complex_level5' => 'Ciężkie',
    'complex_level6' => 'Bardzo ciężkie',
    'confirm' => 'Zatwierdź',
    'confirm_del_from_fav' => 'Zatwierdź usunięcie elementu z Ulubionych',
    'connections' => 'połączenia',
    'copy' => 'Kopiuj',
    'copy_to_clipboard_small_icons' => 'Zezwól na kopiowanie do schowka małych ikon',
    'copy_to_clipboard_small_icons_tip' => '<span style="font-size:11px;max-width:300px;">To powinno pomóc w zapobieganiu użyciu dużej ilości pamięci, jeżeli użytkownicy mają starsze komputery.<br />Schowek nie jest ładowany razem z elementami informacji, lecz szybkie kopiowanie haseł oraz loginów jest niemożliwe.</span>',
    'date' => 'Data',
    'date_format' => 'Format daty',
    'delete' => 'Usuń',
    'deletion' => 'Usunięcie',
    'del_button' => 'Usuń',
    'description' => 'Opis',
    'disconnect' => 'Wyloguj',
    'done' => 'Zakończono',
    'duplicate_folder' => 'Zezwól na dodawanie folderów o tej samej nazwie.',
    'duplicate_item' => 'Zezwól na dodawanie elementów o tej samej nazwie.',
    'email' => 'Email',
    'email_subject' => 'Dodawanie nowego elementu do Menedżera Haseł',
    'enable_favourites' => 'Zezwól Użytkownikom na dodawanie elementów do Ulubionych',
    'enable_personal_folder' => 'Zezwól na Foldery Osobiste',
    'enable_personal_folder_feature' => 'Zezwól Użytkownikom na posiadanie folderów osobistych',
    'enable_user_can_create_folders' => 'Użytkownicy są upoważnieni do zmiany podfolderów w udostępnionych folderach',
    'encrypt_key' => 'Klucz szyfrowania',
    'errors' => 'błędy',
    'error_group_exist' => 'Folder o podanej nazwie już istnieje!',
    'error_html_codes' => 'Treść zawiera kod HTML! To nie jest dozwolone.',
    'error_item_exists' => 'Element już istnieje!',
    'error_label' => 'Etykieta jest wymagana!',
    'error_must_enter_all_fields' => 'Trzeba wypełnić każde pole!',
    'error_pw' => 'Hasło jest wymagane!',
    'error_tags' => 'Znaki interpunkcyjne nie są dozwolone w TAGACH! Można używać tylko spacji.',
    'error_user_exists' => 'Użytkownik już istnieje',
    'expiration_date' => 'Data wygaśnięcia',
    'find' => 'Znajdź',
    'forbidden_groups' => 'Zabronione Foldery',
    'forgot_my_pw_email_sent' => 'Wiadomość email została wysłana',
    'functions' => 'Role',
    'gestionnaire' => 'Menedżer',
    'god' => 'Administrator',
    'group' => 'Folder',
    'group_parent' => 'Folder nadrzędny',
    'group_pw_duration' => 'Czas ponowienia',
    'group_pw_duration_tip' => 'W miesącach. Użyj 0 aby deaktywować.',
    'history' => 'Historia',
    'home_personal_saltkey' => 'Twój osobisty SALTKey',
    'home_personal_saltkey_label' => 'Podaj swój osobidy SALTKey',
    'import_error_no_read_possible' => 'Nie można odczytać pliku!',
    'import_error_no_read_possible_kp' => 'Nie można odczytać pliku! Plik musi być typu KeePass.',
    'import_keepass_to_folder' => 'Wybierz folder docelowy',
    'index_add_one_hour' => 'Wydłuż sesję o 1 godzinę',
    'index_change_pw_confirmation' => 'Potwierdź',
    'index_expiration_in' => 'Sesja wygaśnie za',
    'index_get_identified' => 'Proszę się zidentyfikować',
    'index_last_pw_change' => 'Hasło zmienione.',
    'index_last_seen' => 'Ostatnie połączenie',
    'index_login' => 'Konto',
    'index_new_pw' => 'Nowe hasło',
    'index_password' => 'Hasło',
    'index_pw_error_identical' => 'Hasła muszą być takie same!',
    'index_pw_level_txt' => 'Złożoność',
    'index_session_duration' => 'Czas trwania sesji',
    'info' => 'Informacja',
    'item_menu_copy_login' => 'Kopiuj Login',
    'item_menu_copy_pw' => 'Kopiuj hasło',
    'item_menu_del_from_fav' => 'Usuń z Ulubionych',
    'kbs' => 'KBs',
    'kb_menu' => 'Baza wiedzy',
    'last_items_title' => 'Ostatnio oglądane elementy',
    'ldap_extension_not_loaded' => 'Rozszerzenie LDAP nie zostało aktywowane na serwerze.',
    'level' => 'Poziom',
    'login' => 'Login',
    'mask_pw' => 'Ukryj/Pokaż hasło',
    'max_last_items' => 'Maksymalna ilość ostatnio oglądanych elementów przez Użytkownika (domyślną wartością jest 10)',
    'minutes' => 'minuty',
    'name' => 'Nazwa',
    'nb_false_login_attempts' => 'Ilość błędnych prób do zablokowania konta (0 blokuje)',
    'nb_folders' => 'Liczba Folderów',
    'nb_items' => 'Liczba elementów',
    'new_label' => 'Nowa etykieta',
    'no' => 'Nie',
    'none' => 'Żaden',
    'none_selected_text' => 'Nie zaznaczono',
    'not_allowed_to_see_pw' => 'Nie jesteś upoważniony do przeglądania tego elementu!',
    'not_allowed_to_see_pw_is_expired' => 'Ważność elementu wygasła!',
    'not_defined' => 'Nie zdefiniowany',
    'number_of_used_pw' => 'Liczba nowych haseł, które użytkownik musi wprowadzić przed ponownym użyciem starego.',
    'pages' => 'Strony',
    'pdf_download' => 'Pobierz plik',
    'personal_salt_key' => 'Twój osobisty SALTKey',
    'pw' => 'Hasło',
    'pw_generate' => 'Wygeneruj',
    'pw_is_expired_-_update_it' => 'Pozycja wygasła! Musisz zmienić swoje hasło.',
    'pw_life_duration' => 'Żywotność hasła użytkowników przed wygaśnięciem (w dniach, 0 aby wyłączyć)',
    'readme_open' => 'Otwórz plik readme',
    'read_only_account' => 'Tylko do odczytu',
    'restore' => 'Odzyskaj',
    'restricted_to' => 'Ograniczone do',
    'restricted_to_roles' => 'Pozwól, aby ograniczyć elementy do użytkowników i ról',
    'root' => 'Root',
    'secure' => 'Zabezpiecz',
    'see_logs' => 'Obejrzyj Logi',
    'settings_anyone_can_modify' => 'Aktywuj opcję dla wszystkich elementów, która pozwoli każdemu na ich modyfikowanie.',
    'settings_anyone_can_modify_tip' => 'To dodaje przycisk wyboru podczas tworzenia nowej pozycji z hasłem, który może ustawić pozycję aby mogła być modyfikowana przez każdego.',
    'settings_default_language' => 'Wybierz domyślny język',
    'settings_kb' => 'Włącz Bazę Wiedzy (wersja testowa)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Kiedy aktywowane, opcja doda stronę gdzie możesz tworzyć swoją bazę wiedzy.</span> ',
    'settings_ldap_domain' => 'LDAP konto przyrostek dla domeny',
    'settings_ldap_domain_controler' => 'tablica LDAP kontrolerów domen',
    'settings_ldap_domain_controler_tip' => 'Sprecyzuj kontroler domeny świadczący usługi katalogowe. Aby równoważyć zapytania między wieloma serwerami, wpisz listę nazw serwerów oddzieloną przecinkami. Przykładowo domena_1, domena_2, domena_3',
    'settings_ldap_domain_dn' => 'LDAP base DN dla twojej domeny',
    'settings_ldap_mode' => 'Włącz autentykację użytkowników przy użyciu serwera LDAP',
    'settings_ldap_mode_tip' => 'Włącz tylko jeśli posiadasz serwer LDAP oraz chcesz używać go do uwierzytelniania użytkowników TeamPass.',
    'settings_ldap_ssl' => 'Używaj LDAP z wykorzystaniem SSL (LDAPS)',
    'settings_ldap_tls' => 'Używaj LDAP z wykorzystaniem TLS',
    'settings_log_accessed' => 'Aktywuj logowanie przeglądania elementów',
    'settings_log_connections' => 'Aktywuj logowanie połączeń użytkowników z bazą danych.',
    'settings_maintenance_mode' => 'Ustaw tryb konserwacji w TeamPass',
    'settings_manager_edit' => 'Menedżerowie mogą edytować i kasować elementy, które mogą przeglądać',
    'settings_printing' => 'Aktywuj drukowanie elementów do pliku PDF',
    'settings_printing_tip' => 'Kiedy włączone, przycisk zostanie dodany do strony domowej użytkownika, który pozwoli użytkownikowi zapis do pliku PDF, który może zobaczyć. Zauważ, że wymienione hasła zostaną odszyfrowane.',
    'settings_restricted_to' => 'Włącz funkcję <i>ograniczony do</i> przy pozycjach',
    'settings_show_description' => 'Pokaż opisy w liście elementów',
    'size' => 'Rozmiar',
    'tags' => 'Tagi',
    'timezone_selection' => 'Wybór strefy czasowej',
    'time_format' => 'Format czasu',
    'url' => 'URL',
    'user' => 'Użytkownik',
    'users_online' => 'użytkownicy zalogowani',
    'user_alarm_no_function' => 'Użytkownik nie posiada żadnych Roli',
    'yes' => 'Tak',
    'one_time_view_item_url_box' => 'Udostępnij ten jednorazowy link zaufanej osobie <br><br>#URL#<br><br>Pamiętaj, że ten link może być otwarty tylko jeden raz do #DAY#',
    'settings_api' => 'Zezwól na dostęp do pozycji Teampass poprzez API',
    'settings_api_tip' => 'API umożliwia programistom dostęp do pozycji z hasłami w formacie JSON.',
    'settings_api_keys_list' => 'Lista kluczy',
    'settings_api_keys_list_tip' => 'To są klucze przy których użyciu można uzyskać dostęp do Teampass. Bez poprawnego klucza, dostęp będzie niemożliwy. Proszę zachować ostrożność udostępniając te klucze.',
    'settings_api_key' => 'Klucz',
    'settings_api_add_ip' => 'Dodaj nowy adres IP',
    'settings_api_ip' => 'adres IP',
    'subfolder_rights_as_parent' => 'Nowy katalog podrzędny dziedziczy uprawnienia z katalogu nadrzędnego',
    'subfolder_rights_as_parent_tip' => 'Gdy ta właściwość jest wyłączona, każdy nowy podkatalog dziedziczy uprawnienie przypisane do twórcy. Jeśli włączone, każdy nowy podkatalog dziedziczy uprawnienia z katalogu nadrzędnego.',
    'show_only_accessible_folders_tip' => 'Domyślnie użytkownik widzi pełną ścieżkę, nawet gdy nie ma dostępu do wszystkich katalogów. Możesz to uprościć, usuwając z drzewa katalogów te do których użytkownik nie ma dostępu.',
    'show_only_accessible_folders' => 'Uprość drzewo katalogów przez usunięcie katalogów do których użytkownik nie ma dostępu',
    'comment' => 'Komentarz',
    'suggestion_menu' => 'Sugestie',
    'settings_suggestion' => 'Włącz sugestię dla użytkowników posiadających uprawnienia tylko do odczytu',
    'settings_suggestion_tip' => 'Funkcja sugestii dodaje nowe menu oraz stronę, pozwalając użytkownikom tworzenie sugestii dla nowych pozycji z hasłami. Jest to użyteczne tylko gdy menedżerowie mogą tworzyć nowe pozycje z hasłami.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'Hasło do LDAP',
    'settings_ldap_search_base' => 'Baza przeszukiwania LDAP',
    'settings_ldap_bind_dn_tip' => 'Wpisz bind DN który może uzyskać dostęp do użytkowników oraz wyszukiwania w drzewie. Bind DN jest poświadczeniem które uwierzytelnia twój dostęp do katalogu.',
    'settings_ldap_bind_passwd_tip' => 'Hasło dla bind DN wymienionego powyżej',
    'settings_ldap_search_base_tip' => 'Podstawowa lokalizacja DN do przeszukiwania w drzewie',
    'admin_email_server_url' => 'Adres URL serwera w e-mailach',
    'enable_email_notification_on_user_pw_change' => 'Wyślij email do użytkownika, kiedy hasło zostanie zmienione.',
    'settings_otv_expiration_period' => 'Opóźnij przed wygaśnięciem jednorazowego podglądu (OTV) udostępnionych pozycji (w dniach)',
    'write' => 'Zapisz',
    'read' => 'Czytaj',
    'no_access' => 'Brak dostępu',
    'right_types_label' => 'Wybierz typ prawa dostępu do folderu dla wybranej grupy użytkowników',
    'duplicate_item_in_folder' => 'Zezwól na podobne elementy w tym samym folderze',
    'settings_roles_allowed_to_print' => 'Zdefiniuj role, które będą posiadały uprawnienia do wydruku.',
    'settings_roles_allowed_to_print_tip' => 'Wybrane role będą mogli wydrukować pozycje do pliku.',
    'admin_email_security' => 'zabezpieczenie SMTP',
    'alert_page_will_reload' => 'Strona właśnie zostanie przeładowana',
    'file_protection_password' => 'Wybierz plik hasła',
    'expand' => 'Rozwiń',
    'collapse' => 'Zwiń',
    'settings_ldap_user_attribute' => 'Atrybut użytkownika do wyszukania',
    'settings_ldap_user_attribute_tip' => 'Atrybut LDAP do wyszukiwania nazwy użytkownika',
    'log_user_initial_pwd_changed' => 'Zdefiniowane hasło początkowe',
    'log_user_email_changed' => 'Email Użytkownika zmieniono na ',
    'log_user_created' => 'Konto Użytkownika zostało dodane',
    'log_user_locked' => 'Użytkownik został zablokowany',
    'log_user_unlocked' => 'Użytkownik został odblokowany',
    'log_user_pwd_changed' => 'Hasło Użytkownika zostało zmienione',
    'settings_default_session_expiration_time' => 'Domyślny czas zakończenia sesji użytkownika',
    'settings_duo' => 'Włącz DUO Security jako dwuskładnikowe uwierzytelnianie użytkownika',
    'settings_duo_tip' => 'Dwuskładnikowe uwierzytelnienie może być zapewnione przy użyciu DUOSecurity.com. Biblioteka ta gwarantuje wysoki poziom bezpieczeństwa związany z uwierzytelnianiem użytkownika.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'Gospodarz',
    'settings_duo_explanation' => 'Poświadczenia te są przydzielone z aplikacji internetowej którą utworzyłeś dla Teampass z panelu administracyjnego DUO Security.<br />Klikając przycisk zapisz, poświadczenia zostaną zapisane w pliku sk.php.',
    'admin_duo_intro' => 'Wypełnij pola odpowiednimi danymi',
    'edit' => 'Edytuj',
    'user_info_locked' => 'Użytkownik jest ZABLOKOWANY.',
    'user_info_unlock_question' => 'Odblokować konto?',
    'user_info_lock_question' => 'Zablokować konto?',
    'user_info_delete_question' => 'Usunąć konto?',
    'user_info_active' => 'Użytkownik został aktywowany.',
    'refresh' => 'Odświerz',
    'loading' => 'Ładowanie',
    'searching' => 'Szukam ...',
    'list_items_with_tag' => 'Lista elementów z podobnym tagiem',
    'no_item_to_display' => 'Nie ma elementów do wyświetlenia',
    'opening_folder' => 'Wczytywanie katalogu ...',
    'suggestion_notify_subject' => '[Teampass] Dodano nową sugestię.',
    'suggestion_notify_body' => 'Witaj,<br><br>Nowa sugestia została dodana. Musisz zweryfikować ją zanim będzie mogła być używana przez innych użytkowników.<br>Trochę informacji o tym:<br>- Opis: #tp_user#<br><br>Ta wiadomość email została wysłana do wszystkich Menedżerów.<br><br>Pozdrawiamy!',
    'error_unknown' => 'Wystąpił nieoczekiwany błąd!',
    'no_edit' => 'Zapis bez edycji',
    'role_cannot_edit_item' => 'Nie można edytować elementów',
    'no_delete' => 'Zapis bez kasowania',
    'role_cannot_delete_item' => 'Nie można kasować elementów',
    'my_profile' => 'Mój profil',
    'starting' => 'Startuję ...',
    'total_number_of_items' => 'Ilość wszystkich elementów',
    'finalizing' => 'Kończę',
    'treating_items' => 'Leczenie przedmiotów',
    'number_of_items_treated' => 'Liczba przetworzonych pozycji',
    'error_sent_back' => 'Wystąpił błąd "Przejścia dalej"',
    'full' => 'Pełny',
    'sequential' => 'Sekwencyjny',
    'tree_load_strategy' => 'Strategia ładowania drzewa',
    'syslog_enable' => 'Aktywuj log-i za pomocą Syslog',
    'syslog_host' => 'Serwer Syslog',
    'syslog_port' => 'Port serwera Syslog',
    'error_bad_credentials' => 'Poświadczenia logowania nie odpowiadają!',
    'settings_ldap_usergroup' => 'Grupa LDAP do przeszukiwania',
    'settings_ldap_usergroup_tip' => 'Grupa LDAP której użytkownik musi być członkiem aby się zalogowa�',
    'server_password_change_enable' => 'Włącz zmianę hasła na zdalnym serwerze (używając połączenia SSH)',
    'update_server_password' => 'Zaktualizuj hasło serwera',
    'ssh_pwd' => 'Hasło SSH',
    'ssh_user' => 'Użytkownik SSH',
    'ssh_password_frequency_change_info' => 'Wskaż interwał pomiędzy automatycznym uaktualnieniem hasła na serwerze (wybranie 0 spowoduje wyłączenie automatycznej zmiany hasła).<br />Automatyczna aktualizacja hasła zostanie przeprowadzona jedynie, gdy administrator również skonfiguruje plan aktualizacji hasła.',
    'ssh_password_frequency_change' => 'Częstotliwość zmiany hasła (w miesiącach)',
    'ssh_scheduled_change' => 'Zaplanowana zmiana',
    'ssh_one_shot_change' => 'Jednorazowa zmiana',
    'server_password_change_enable_tip' => 'Ta opcja pozwala użytkownikom na automatyczna zmianę hasła użytkownika na serwerze z pola URL używając połączenia SSH.<br>Zauważ, że automatyczna zmiana z określoną częstotliwością może być wykonywana gdy plik <i>/files/script.ssh.php</i> jest dodany do listy zadań crona na serwerze. Dobrym pomysłem jest uruchamianie automatycznej zmiany raz dziennie.',
    'settings_ldap_object_class' => 'Klasa do wyszukiwania',
    'settings_ldap_object_class_tip' => 'Klasa LDAP do wyszukiwania np. Osoba lub konto posix',
    'rebuild_config_file' => 'Przebuduj plik konfiguracyjny',
    'rebuild_config_file_tip' => 'Plik konfiguracyjny znajduje się w katalogu ./includes/config/tp.config.php. Zawiera zmienne konfiguracyjne zdefiniowane w ustawieniach oraz niestandardowe zakładki. Przebudowa pliku konfiguracyjnego może być wykonana w każdym momencie.',
    'error_folder_complexity_lower_than_top_folder' => 'Wymagane jest, aby skomplikowanie hasła było co najmniej takie samo jak dla katalogu nadrzędnego.',
    'new_item_email_body' => 'Cześć, <br /><br />Nowa pozycja &apos;#label&apos; została stworzona w Teampas',
    'failed_logins' => 'Nieudane logowania',
    'error_only_numbers_in_folder_name' => 'Opis folderu nie może być numerem. Proszę użyj nazwy zawierającej litery.',
    'encrypted_data' => 'Dane są zaszyfrowane w bazie danych.',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'Twoje ID karty Agses',
    'ga_flash_qr_and_login' => 'Zeskanuj ten kod QR za pomocą swojego urządzenia mobilnego, wpisz kod uwierzytelniania 2Factor i kliknij przycisk "Wprowadź".',
    'i_need_to_generate_new_ga_code' => 'Potrzebuję nowego kodu QR. Proszę wyślij mi na email tymczasowy kod identyfikacyjny.',
    'settings_manager_move_item' => 'Menedżerowie mogą przesunąć każdy element, który widzą',
    'user_folders_rights' => 'Widoczne katalogi',
    'create_item_without_password' => 'Pozwól na dodanie pozycji bez zdefiniowanego hasła',
    'share_rights_info' => 'To okno dialogowe pozwala na ustawienie współdzielenie praw użytkownika z wybranymi użytkownikami.<br>Zmieni to bieżące uprawnienia wybranych użytkowników, które zostaną ustawione na takie jakie ma użytkownik źródłowy.',
    'share_rights_source' => 'Źródło użytkownika',
    'share_rights_destination' => 'Cel użytkowników',
    'ga_reset_by_user' => 'Użytkownik może zresetować swój kod 2FA',
    'ga_reset_by_user_tip' => 'Jeśli ta opcja jest aktywna pozwala on użytkownikowi na zresetowanie jego kodu 2FA za pomocą linku na stronie logowania. Ta opcja może być pomocna na przykład w przypadku zmiany urządzenia mobilnego.',
    'enable_massive_move_delete' => 'Zezwalaj na wykonywanie ogromnych operacji przenoszenia i usuwania',
    'enable_massive_move_delete_tip' => 'Jeśli ta opcja jest aktywna pozwala ona użytkownikowi na dokonanie dużych operacji przenoszenia i/lub kasowania. Użytkownik będzie mógł dokonać operacji jedynie na elementach, do których ma uprawnienia.',
    'mass_operation' => 'Masowa operacja na elementach',
    'move_items' => 'Przenieś wybrane elementy',
    'delete_items' => 'Usuń wybrane elementy',
    'you_decided_to_move_items' => 'Zdecydowałeś, aby przenieść elementy',
    'you_decided_to_delete_items' => 'Zdecydowałeś, aby usunąć elementy',
    'suggest_password_change' => 'Zasugeruj zmianę hasła',
    'otv_is_enabled' => 'Użytkownik może zaproponować jednorazowe linki',
    'error_source_and_destination_are_equal' => 'Źródło i Cel nie mogą być identyczne!',
    'sending_anonymous_statistics' => 'Wysyłanie anonimowych statystyk',
    'favourites_option_enabled' => 'Włączona opcja Ulubionych',
    'personalfolders_option_enabled' => 'Włączona opcja Osobistych katalogów',
    'country_statistics' => 'Mapa użycia na świecie',
    'country' => 'Kraj',
    'users_statistics' => 'Średnia liczba użytkowników według przykładu',
    'items_all' => 'Wszystkie elementy',
    'folders_all' => 'Wszystkie katalogi',
    'items_shared' => 'Wszystkie współdzielone elementy (nie zawiera osobistych)',
    'folders_shared' => 'Wszystkie współdzielone katalogi (nie zawiera osobistych)',
    'items_statistics' => 'Średnia liczba elementów według przykładu',
    'folders_statistics' => 'Średnia liczba folderów według przykładu',
    'administrators_number' => 'Liczba użytkowników administracyjnych',
    'administrators_number_statistics' => 'Średnia liczba Administratorów',
    'managers_number' => 'Liczba użytkowników Menedżerów',
    'managers_number_statistics' => 'Średnia liczba Menedżerów',
    'readonly_number_statistics' => 'Średnia liczba użytkowników "tylko do odczytu"',
    'readonly_number' => 'Liczba użytkowników z prawami tylko do odczytu',
    'mysql_version' => 'Wersja MySQL',
    'php_version' => 'Wersja PHP',
    'teampass_version' => 'Wesja Teampass',
    'languages_used' => 'Używane języki',
    'languages_statistics' => 'Najczęściej używany język',
    'kb_option_enabled' => 'Włączona opcja Bazy wiedzy',
    'suggestion_option_enabled' => 'Włączona opcja Sugestii',
    'customfields_option_enabled' => 'Włączona opcja Niestandardowych pól',
    'api_option_enabled' => 'Włączona opcja API',
    '2fa_option_enabled' => 'Włączona opcja 2FA',
    'agses_option_enabled' => 'Włączona opcja AGSES',
    'duo_option_enabled' => 'Włączona opcja DUO Security',
    'ldap_option_enabled' => 'Włączona opcja LDAP',
    'syslog_option_enabled' => 'Włączona opcja SYSLOG',
    'stricthttps_option_enabled' => 'Włączona opcja ścisłego HTTPS',
    'characteristic' => 'Charakterystyczny',
    'current_value' => 'Aktualna wartość',
    'communication_means' => 'Środki komunikacji',
    'consider_a_donation' => 'Możesz rozważyć darowiznę',
    'more_information' => 'Więcej informacji',
    'feature_request_canal' => 'Dla zgłaszania nowych funkcjonalności, proszę użyj',
    'bug_canal' => 'Dla błędów, proszę użyj',
    'documentation_canal' => 'Kompletna dokumentacja na',
    'sending_anonymous_statistics_details' => 'Statystyki pomagają polepszyć Teampass poprzez poznanie potrzeb użytkowników. Otrzymane informację nie są sprzedawane ani rozpowszechniane osobom trzecim. ',
    'item_has_change_proposal' => 'Ta pozycja ma propozycję zmiany',
    'check_data_after_reencryption' => 'Sprawdź proszę dane. Została dodana nowa tabela <b>Backup</b> w celu umożliwienia przywrócenia danych.',
    'revert' => 'Przywrócić?',
    'revert_the_database' => 'Zdecydowałeś przywrócić bazę danych. Proszę potwierdź.',
    'bad_psk' => 'Ten osobisty klucz soli nie jest poprawny!',
    'ldap_test_config' => 'Sprawdź aktualną konfigurację',
    'ldap_test_username' => 'Nazwa użytkownika dla celów testowych',
    'ldap_test_username_pwd' => 'Nazwa użytkownika hasło',
    'feature_support_canal' => 'Dla wsparcia i pomocy, proszę użyj',
    'category' => 'Kategoria',
    'text' => 'Tekst',
    'type' => 'Wpisz',
    'data_is_masked' => 'Dane są ukryte',
    'at_export' => 'Eksportuj',
    'settings_ldap_allowed_usergroup' => 'LDAP zezwolony przez użytkownika grupy',
    'settings_ldap_allowed_usergroup_tip' => 'Wskazuje grupę której zezwolono na dostęp do Teampass-a. Pozostawienie pustego nie ogranicza dostępu, (dostęp w zależności do której grupy należy).',
    'error_security_level_not_reached' => 'Oczekiwany poziom zabezpieczeń nie został osiągnięty!',
    'personal_saltkey_security_level' => 'Minimalny poziom klucza osobistego "Saltkey"',
    'settings_disable_forgot_password_link' => 'Ukryj link "zapomniałem hasło" na stronie głównej.',
    'newly_created_user_is_administrated_by' => 'Nowi użytkownicy są administrowani przez',
    'settings_ldap_and_local_authentication' => 'Użytkownicy lokalni oraz LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Włącz tę opcję, aby zezwolić na uwierzytelnianie użytkowników w LDAP lub na lokalnej liście użytkowników Teampass.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Ikona',
    'icon_on_selection' => 'Ikona gdy zaznaczono',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon."',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'TTo jest zaszyfrowany kod, którego użytkownik będzie potrzebował podczas tego logowania. Poprosiłeś o jego obejrzenie, skopiuj go i udostępnij w bezpieczny sposób. Kod to',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Wygeneruj nowy kod OTP',
    'generate_new_otp_informations' => 'Operacja ta polega na wygenerowaniu od podstaw wszystkich kluczy dla wybranego użytkownika. W rezultacie użytkownik będzie musiał podać nowy wygenerowany OTP przy następnym logowaniu.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Zsynchronizuj nowe hasło',
    'error_new_ldap_password_detected' => 'Wygląda na to, że hasło uległo zmianie, a Teampass wymaga go do zaszyfrowania głównego klucza prywatnego.',
    'settings_ldap_tls_certifacte_check' => 'Sprawdzanie certyfikatu dla LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Określa strategię sprawdzania certyfikatów. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Więcej informacji</a>.',
    'user_keys_management' => 'Zarządzanie kluczami użytkownika',
    'sending_emails' => 'Wysyłanie wiadomości email',
    'tasks_information' => 'Task relies on a dedicated cron job. W tym celu należy dodać nowy wpis do crontab, aby uruchamiać harmonogram Teampass co minutę.<br>Następny wpis do dodania:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Uwaga: należy dostosować ścieżkę do php bin (w większości przypadków można ją zastąpić <code>php</code>).',
    'bad_duo_mfa' => 'Niepoprawny kod DUO',
    'creation_date' => 'Data utworzenia',
    'never' => 'Nigdy',
    'loading_main_page' => 'ładowana jest strona główna …',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'Uwierzytelnianie nie jest dozwolone',
    'enable_tasks_log' => 'Włącz rejestr zadań cron',
    'enable_tasks_log_tip' => 'Umożliwia rejestrowanie wszystkich zadań wykonywanych przez zadanie cron w tabeli <i>processes_log</i>. Może być przydatne do sprawdzania zdarzeń.',
    'items_and_folders_statistics' => 'Elementy w folderze statystyk',
    'item_copying' => 'Rozpoczęto kopiowanie elementów',
    'upgrade_requested' => 'Baza danych Teampass nie jest aktualna.',
    'upgrade_requested_more' => 'Zidentyfikowano pewne niespójności między plikami i konfiguracją, administrator powinien przeprowadzić proces aktualizacji przed kontynuowaniem.',
    'settings_ldap_group_object_filter' => 'Filtr LDAP dla grup',
    'settings_ldap_group_object_filter_tip' => 'Filtr LDAP do użycia w celu znalezienia obiektu grupy. Na przykład: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'Role użytkowników AD zmapowane z ich grupami AD',
    'settings_ad_users_with_ad_groups_tip' => 'Zezwala na mapowanie ról użytkowników AD z ich grupami AD. Role te zostaną dodane do ról zdefiniowanych w profilu użytkownika.',
    'settings_ad_user_auto_creation' => 'Użytkownik AD zostanie utworzony automatycznie',
    'settings_ad_user_auto_creation_tip' => 'Zezwala na automatyczne utworzenie użytkownika AD w Teampass przy pierwszym logowaniu. Zauważ, że jeśli role użytkownika AD opcji są zmapowane z włączonymi grupami AD, to otrzyma on role zmapowane z jego grupami AD.',
    'settings_ldap_guid_attibute' => 'Atrybut GUID LDAP',
    'settings_ldap_guid_attibute_tip' => 'Atrybut LDAP używany do identyfikacji identyfikatora GUID obiektu. Na przykład: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'Grupy AD',
    'mapped_with_role' => 'Zmapowane z rolą',
    'ad_groupe_and_roles_mapping' => 'Mapowanie grup i ról AD',
    'select_adgroup_mapping' => 'Wybierz rolę do zmapowania z bieżącą grupą AD',
    'enable_backlog_mail' => 'Włącz wysyłanie zaległych wiadomości e-mail',
    'provide_label' => 'Wprowadź etykietę',
    'uploading' => 'Wgrywanie…',
    'keys_encryption_not_ready' => 'Informujemy, że klucze haseł są obecnie w trakcie tworzenia. Poczekaj jeszcze kilka minut.',
    'account_not_ready' => 'Konto jest aktualnie tworzone',
    'add_new_job' => 'Dodaj nowe zadanie',
    'tasks_cron_not_running' => 'Zadanie Cron nie jest ustawione. Należy edytować crontab z użytkownikiem serwera (zwykle www-data) za pomocą polecenia <code>crontab -u www-data -e</code>.<br>Lub naciśnij przycisk, aby spróbować utworzyć ją automatycznie.',
    'tasks_cron_running' => 'Zadanie Cron zostało poprawnie utworzone',
    'currently_using_version' => 'Aktualna wersja',
    'git_commit_value' => 'Wartość commita Git',
    'generate_new_keys' => 'Wygeneruj nowe klucze',
    'generate_new_keys_info' => 'Kontynuując, wygenerujesz nowe klucze szyfrowania dla wszystkich obiektów, do których masz dostęp. Należy to zrobić tylko wtedy, gdy nie ma wyświetlonego hasła.',
    'generate_new_keys_end' => 'Proces trwa w tle i może potrwać kilka minut. Możesz teraz zamknąć to okno.',
    'confirm_password' => 'Musisz potwierdzić swoje hasło',
    'no_code_is_requested' => 'Nie jest wymagany żaden kod.',
    'user_encryption_ongoing' => 'Konto jest obecnie szyfrowane. Twoje żądanie nie może być kontynuowane. Poczekaj, aż proces się zakończy.',
    'teampass_information' => 'Informacje o Teampass',
    'show_password' => 'Pokaż hasło',
    'new_user_info_by_mail' => 'Nowy użytkownik otrzyma wiadomość e-mail z danymi uwierzytelniającymi.',
    'login_credentials' => 'Dane logowania',
    'email_body_user_config_1' => 'Witaj #lastname#,<br><br>Jest to wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Następujące dane uwierzytelniające są oczekiwane przy następnym użyciu Teampass:<ul><li>login: #login#</li><li>Hasło: #password#</li><li>Kod szyfrujący: #code#</li></ul><br><br><br>Cheers',
    'email_body_user_config_3' => 'Witaj #lastname#,<br><br>Jest to wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Następujące hasło jest oczekiwane przy następnym użyciu Teampass:<br><br><b>#password#</b><br><br><br>Cheers',
    'email_body_user_config_4' => 'Witaj #lastname#,<br><br>Jest to wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Twoje konto Teampass jest w pełni gotowe.<br><br>Cheers',
    'email_body_user_config_5' => 'Witaj #lastname#,<br><br>Jest to wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Następujący kod jest oczekiwany przy następnym użyciu Teampass:<br><br><b>#code#</b><br><br><br>Cheers',
    'email_body_user_config_6' => 'Witaj #lastname#,<br><br>Jest to wiadomość e-mail wygenerowana przez menedżera haseł Teampass.<br><br>Następujące dane uwierzytelniające są oczekiwane przy następnym użyciu Teampass:<ul><li>login: #login#</li><li>Hasło: #password#</li></ul><br><br><br>Cheers',
    'error_data_not_valid' => 'Dane są nieprawidłowe',
    'mfa_enabled' => 'MFA włączone',
    'mfa_disabled_for_user' => 'MFA wyłączone dla użytkownika',
    'users_personal_folder' => 'Folder osobisty użytkownika',
    'maintenance_operations' => 'Czynności konserwacyjne',
    'maintenance_operations_tip' => 'Wybrane operacje konserwacyjne w bazie danych Teampass.',
    'purge_temporary_files' => 'Wyczyść pliki tymczasowe',
    'task_scheduling' => 'Harmonogram zadań',
    'parameter' => 'Parametr',
    'frequency' => 'Częstotliwość',
    'in_minutes' => 'w minutach',
    'hourly' => 'Godzinowo',
    'daily' => 'Codziennie',
    'clean_orphan_objects' => 'Wyczyść obiekty osierocone',
    'run_once' => 'Uruchom raz',
    'run_weekday' => 'Uruchom w dni robocze',
    'monday' => 'Poniedziałek',
    'tuesday' => 'Wtorek',
    'wednesday' => 'Środa',
    'thursday' => 'Czwartek',
    'friday' => 'Piątek',
    'saturday' => 'Sobota',
    'sunday' => 'Niedziela',
    'monthly' => 'Miesięcznie',
    'day_of_month' => 'Dzień miesiąca',
    'day' => 'Dzień',
    'reset' => 'Zresetuj',
    'error_while_creating_file' => 'Błąd podczas tworzenia pliku',
    'new_keys_generated' => 'Wygenerowano nowe klucze',
    'user_creation' => 'Tworzenie użytkownika',
    'user_deletion' => 'Usunięcie użytkownika',
    'maximum_session_expiration_time' => 'Maksymalny czas wygaśnięcia sesji',
    'maximum_session_expiration_time_tip' => 'Maksymalny czas w minutach, o jaki użytkownik może przedłużyć sesję',
    'index_session_duration_too_long' => 'Czas trwania sesji jest zbyt długi',
    'extend_session_duration_by' => 'Wydłużenie czasu trwania sesji o',
    'settings_ldap_user_dn_attribute' => 'Nazwa wyróżniająca użytkownika',
    'settings_ldap_user_dn_attribute_tip' => 'Etykieta atrybutu dla nazwy wyróżniającej (DN) użytkownika w usłudze AD.<br>Przykład: Dla openLDAP: dn. Dla Active Directory: distinguishedname.',
    'open_tasks_settings' => 'Otwórz ustawienia zadań',
    'maximum' => 'maksimum',
    'updated' => 'Zaktualizowano',
    'number_of_days' => 'Liczba dni',
    'number_of_times' => 'Liczba powtórzeń',
    'sharekey_not_ready' => 'Klucz udostępniania nie został jeszcze wygenerowany ... wszystkie dane pozycji mogą nie być gotowe ... spróbuj później',
    'item_action_not_yet_possible' => 'Podjęcie działań w tej sprawie nie jest jeszcze możliwe',
    'open' => 'Otwórz',
    'reload_user_cache_table' => 'Przeładowanie tabeli pamięci podręcznej użytkownika',
    'send_email_to_user' => 'Wyślij wiadomość e-mail do użytkownika',
    'items_management' => 'Operacje na elementach',
    'previously_used_passwords' => 'Poprzednio używane hasła',
    'next_passwords_were_valid_until_date' => 'Kolejne hasła były ważne do daty',
    'feature_disabled_by_administrator' => 'Funkcja wyłączona przez administratora',
    'shared_globaly' => 'Udostępnione globalnie',
    'settings_otv_subdomain' => 'Nazwa subdomeny OTV',
    'settings_otv_subdomain_tip' => 'Dedykowana subdomena dla jednorazowych linków. Uznając główny adres URL Teampass za odizolowany od Internetu, ta subdomena może być dostępna dla każdego, aby udostępnić ten element komuś spoza organizacji. Z punktu widzenia bezpieczeństwa taka mechanika jest znacznie bezpieczniejsza. Uwaga: Wymagałoby to posiadania wpisu DNS dla tej subdomeny wskazującego na serwer Teampass.',
    'existing_valid_otv_links' => 'Prawidłowe linki OTV',
    'started' => 'Rozpoczęto',
    'recovery_keys_not_downloaded' => 'Klucze odzyskiwania nie zostały pobrane',
    'no_recovery_keys' => 'Nie mam kluczy odzyskiwania. Spowoduje to usunięcie wszystkich haseł z moich osobistych przedmiotów.',
    'provide_recovery_keys' => 'Podaj klucze odzyskiwania',
    'public_key' => 'Klucz publiczny',
    'private_key' => 'Klucz prywatny',
    'download_recovery_keys' => 'Pobierz klucze odzyskiwania',
    'download_recovery_keys_confirmation' => 'Za chwilę pobierzesz klucze odzyskiwania. Przechowuj je w bezpiecznym miejscu, ponieważ powinny być obowiązkowe w przypadku katastrofy.',
    'recovery_keys_download_date' => 'Data pobrania kluczy odzyskiwania',
    'keys_not_recovered' => 'Klucze publiczne i prywatne nie są przechowywane',
    'keys_not_recovered_explanation' => 'Aby zapobiec utracie haseł, należy bezpiecznie przechowywać osobiste klucze Teampass',
    'get_your_recovery_keys' => 'Pobierz klucze odzyskiwania',
    'keys_management' => 'Zarządzanie kluczami',
    'please_confirm_task_to_be_run' => 'Potwierdź zadanie do wykonania',
    'user_keys_downloaded' => 'Pobrane klucze użytkownika',
    'mfa_code_send_by_email' => 'Kod MFA wysłany pocztą elektroniczną',
    'otp' => 'otp',
    'otp_code' => 'Kod OTP',
    'enabled_otp_for_item' => 'Włącz kod OTP',
    'at_otp_status' => 'Status OTP',
    'phone_number' => 'Powiązany numer telefonu (opcjonalnie)',
    'otp_secret' => 'Tajny klucz OTP',
    'settings_ldap_group_objectclasses_attibute' => 'Atrybut ObjectClasses grupy AD',
    'settings_ldap_group_objectclasses_attibute_tip' => 'ObjectClasses do użycia podczas wyszukiwania grup. Kilka objectClasses jest oddzielonych przecinkiem (,). Przykład: groupOfNames,group lub top,posixGroup',
    'display_warning_icons' => 'Wyświetlanie ikon ostrzeżeń',
    'password_length_by_default' => 'Domyślna długość hasła',
    'progress' => 'Postęp',
    'tasks_log_retention_delay_in_days' => 'Opóźnienie przechowywania dziennika zadań (w dniach)',
    'tasks_log_table_size' => 'Rozmiar tabeli dziennika zadań',
    'error_otp_secret' => 'Umożliwić odszyfrowanie hasła OTP, czy hasło jest prawidłowe?',
    'users_api_access_info' => 'Users can access the API with same access rights as in Teampass.',
    'error_folder_not_allowed_for_this_user' => 'Folder is not allowed for this user',
    'allowed_to_create' => 'Allowed to create',
    'allowed_to_read' => 'Allowed to read',
    'allowed_to_update' => 'Allowed to update',
    'allowed_to_delete' => 'Allowed to delete',
    'folder_created' => 'Folder created',
    'login_with_sso' => 'Login with SSO',
    'server_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet_tip' => 'This could lead to several functionnalities not working properly. Especially MFA',
    'tools' => 'Tools',
    'user_config_not_compliant' => 'User configuration is not compliant',
    'fix_personal_items_empty' => 'Fix personal items are empty',
    'fix_personal_items_empty_tip' => 'This tool permits to fix the issue where personal items are empty after a Teampass upgrade. It requires to have restored a copy of table teampass_items from Teampass version 2. The table needs to be named teampass_items_v2.',
    'table_not_exists' => 'Expected table does not exist. Please restore it from a backup.',
    'tools_usage_warning' => 'Using tools can have a direct impact on the database. Please be careful. Always perform a dump before and define a maintenance period.',
    'select_user' => 'Select user',
    'show_item_data' => 'Show item data in items list',
    'show_item_data_tip' => 'Permits to display extra information in the items list (username, email and url). This could be useful to have a quick view of the item content.',
    'items_page_split_view_mode' => 'Show item details in page split view mode',
    'replace_tenant_id' => 'Adapt the URL but keep {tenant-id} as is. It will be replaced live by the tenant ID.',
    'user_not_allowed_to_auth_to_teampass_app' => 'User is not allowed to authenticate with Teampass application',
    'user_is_not_auth_with_oauth2' => 'User should not authenticate with Entra/Azure AD',
    'highlight_favorites' => 'Highlight favorites',
    'highlight_favorites_tip' => '',
    'limited_search_default' => 'Limited search selected by default',
    'limited_search_default_tip' => '',
    'highlight_selected_tip' => '',
    'encryptClientServer' => 'Encrypt client-server exchanges',
    'encryptClientServer_tip' => 'When enabled, the client encrypts the data before sending it to the server. The server only stores encrypted data. It can be disabled.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL to get user details',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL to get user details. It is used to get user details after authentication.',
    'duo_redirect_uri' => 'Redirecting to Duo Prompt',
    'number_users_build_cache_tree' => '',
    'number_users_build_cache_tree_tip' => 'Number of users processed for build_cache_tree task at each run of the scheduler.',
    'user_password_expired' => 'Your password has expired. Please change it.',
    'user_password_policy_tip' => 'Th
e new password must:<br/> - Be different from the previous one<br/> - Contain at least 10 characters<br/> - Contain at least one uppercase letter and one lowercase letter<br/> - Contain at least one number or special character<br/> - Not contain your name, first name, username, or email.',
    'bruteforce_unlock_at' => 'Account unlocked at (anti bruteforce): ',
    'bruteforce_reset_account' => 'Reset anti bruteforce of user',
    'bruteforce_reset_mail_subject' => 'TEAMPASS - Your account is disabled',
    'bruteforce_reset_mail_body' => 'Hello #name#,<br/><br/>Your teampass account has been locked due to a large number of authentication failures.<br/><br/>You can unblock it by clicking on this link <a href="#reset_url#" target="_blank">#reset_url#</a><br/><br/>Automatic unlock: #unlock_at#',
    'disable_user_edit_profile' => 'Users can no longer edit their profile',
    'disable_user_edit_language' => 'Users can no longer change language',
    'disable_user_edit_timezone' => 'Users can no longer change time zones',
    'disable_user_edit_tree_load_strategy' => 'Users can no longer change tree loading strategy',
    'bruteforce_wait' => 'Too many failed attempts, your account is blocked until: ',
    'disable_drag_drop' => 'Disable item drag and drop',
    'clipboard_cleared' => 'Clipboard cleared',
    'error_data_not_consistent' => 'Data is not consistent',
    'error_permission_denied' => 'Permission denied',
    'error_invalid_action' => 'Invalid action',
    'error_fetching_password' => 'Error fetching password',
    'unable_to_clear_clipboard' => 'Unable to clear the clipboard manually',
    'clipboard_unsafe' => 'The clipboard could not be cleared automatically, this is unsafe!',
    'clipboard_clear_now' => 'Clear it now!',
    'clipboard_clearing_failed' => 'Clipboard clearing failed',
    'clipboard_error' => 'Clipboard error',

);
