<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      ukrainian.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2024 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Показати код шифрування користувача',
    'email_body_new_user' => 'Привіт,<br><br>Цей лист автоматично згенерований менеджером паролів Teampass. <br><br>Адміністратор створив для вас обліковий запис користувача в Teampass. Наступного разу, коли ви підключатиметеся до Teampass, будь ласка, використовуйте наступні облікові дані:<ul><li>Логін: #login#</li><li>Пароль: #password#</li><li>Код шифрування: #code#</li></ul><br><br><br>Дякую',
    'user_password' => 'Пароль користувача',
    'user_temporary_encryption_code' => 'Код шифрування користувача',
    'no_email_set' => 'Жодної електронної пошти не зареєстровано',
    'send_user_password_by_email' => 'Вирішіть, чи потрібно надсилати пароль для входу на електронну пошту.<br>Якщо так, то натисніть кнопку Надіслати.<br><br>В іншому випадку скористайтеся кнопкою Копіювати в буфер обміну, щоб відправити його користувачеві іншим способом.<br>Ви, як адміністратор, несете відповідальність за надання користувачеві пароля у безпечний спосіб.',
    'admin_change_user_encryption_code_info' => 'Ця операція скине код шифрування для цього користувача.',
    'send_by_email' => 'Надіслати електронною поштою',
    'filters' => 'Фільтри',
    'show_user_password' => 'Показати пароль користувача',
    'open_website' => 'Відкрити веб-сайт',
    'mfa_for_roles' => 'MFA запитується для користувачів у ролях',
    'mfa_for_roles_tip' => 'За замовчуванням, коли метод MFA вибрано, він увімкнений для всіх користувачів. Тим не менш, ви можете вибрати ролі, для яких це очікується.<br>ЩЕ НЕ РЕАЛІЗОВАНО',
    'at_least_one_administrator_is_requested' => 'Потрібен хоча б один адміністратор',
    'bad_code' => 'Поганий код',
    'generating_keys' => 'Створення ключів',
    'this_may_take_time' => 'Це може зайняти кілька хвилин',
    'disable_enable' => 'Вимкнути / Увімкнути',
    'user_disable_status' => 'Поставте прапорець, щоб вимкнути, або залиште порожнім, щоб увімкнути',
    'help_for_launching_items_encryption' => 'Нам потрібно створити базу даних ключів для вашого облікового запису. Будь ласка, введіть свій код шифрування.',
    'managed_through_ad' => 'Керується через AD',
    'new_ldap_user_info' => 'Будь ласка, заповніть визначення для користувача',
    'email_body_user_added_from_ldap_encryption_code' => 'Привіт,<br><br>Це згенерований лист від менеджера паролів Teampass.<br><br>Ви тепер маєте обліковий запис в Teampass. Ви можете використовувати свої облікові дані LDAP для входу в систему.<br><br>При першому вході вам буде запропоновано ввести код шифрування, будь ласка, введіть:<br><br><b>#enc_code#</b><br><br><br>Добридень',
    'settings_ldap_user_object_filter' => 'Фільтр об\’єктів користувача',
    'settings_ldap_user_object_filter_tip' => 'Фільтр для пошуку об&apos;єктів користувача. Кілька фільтрів розділяються комою (,). Приклад: (objectCategory=Person),(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Це значення використовується на додаток до базового DN при пошуку і завантаженні користувачів. Якщо значення не вказано, пошук у піддереві буде розпочато з базового DN. Приклади: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Додатковий користувацький DN',
    'ldap_user_has_changed_his_password' => 'Ваш пароль авторизації було змінено в LDAP з моменту вашого останнього входу в Teampass. Нам потрібно адаптувати ваш ключ шифрування. Будь ласка, вкажіть ваш попередній пароль і поточний.',
    'provide_your_previous_password' => 'Попередній пароль',
    'admin_change_user_password_info' => 'Ця операція призведе до скидання поточного пароля вибраного користувача.',
    'sending_email_message' => 'Надсилання електронного листа користувачеві, зачекайте',
    'change_your_password_info_message' => 'Будь ласка, введіть свій новий пароль автентифікації та підтвердьте його.',
    'user_has_to_change_password_info' => 'Поточний використовуваний пароль було згенеровано. Від вас очікується, що ви зміните його з міркувань безпеки.',
    'ready_to_go' => 'Готовий до роботи',
    'passwords_not_the_same' => 'Введені паролі не збігаються',
    'inititialization' => 'Ініціалізація',
    'bad_password' => 'Поганий пароль',
    'perform_checks' => 'Виконайте перевірки',
    'email_body_temporary_encryption_code' => 'Доброго дня,<br><br>Це згенерований лист від менеджера паролів Teampass.<br><br>У вашому обліковому записі були виконані деякі зміни, які вимагають нового шифрування елементів для забезпечення безпеки даних. Наступного разу при підключенні до Teampass, будь ласка, використовуйте наступний код:<br><br><b>#enc_code#</b><br><br><br>Всього найкращого',
    'temporary_encryption_code' => 'Ваш тимчасовий код шифрування',
    'renecyption_expected' => 'Нам потрібно перешифрувати ваші ключі, щоб вони відповідали привілеям вашого облікового запису та правам.',
    'error_no_user_in_ad' => 'Користувача не знайдено в AD!',
    'error_ad_user_expired' => 'Термін дії користувача закінчився!',
    'error' => 'Виявлено помилку',
    'hosts' => 'Хости',
    'settings_ldap_hosts_tip' => 'Параметр hosts — це масив IP-адрес або імен хостів, розташованих у вашій мережі, які обслуговують каталог LDAP (відокремлених комами). Ви вставляєте стільки серверів, скільки забажаєте, залежно від вашого лісу (звичайно, хоча б один).',
    'base_distiguished_name' => 'Основний DN',
    'settings_ldap_bdn_tip' => 'Кореневе розпізнаване ім’я (DN), яке використовується під час виконання запитів до сервера каталогів. Приклади: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Ім&apos;я користувача',
    'settings_ldap_username_tip' => 'Розпізнаване ім’я користувача, яке використовуватиме програма під час підключення до сервера каталогів. Приклади: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'Пароль вказаного вище користувача.',
    'settings_ldap_port_tip' => 'Параметр порту використовується для автентифікації та прив&apos;язки до вашого LDAP-сервера. Порти за замовчуванням вже використовуються для з&apos;єднань без SSL і з SSL (389 і 636). Вводьте порт, тільки якщо ваш LDAP-сервер використовує унікальний порт.',
    'undefined' => 'Невизначено',
    'error_cannot_open_file' => 'Файл не може бути відкрито',
    'provide_current_psk_and_click_launch' => 'Коли будете готові, натисніть кнопку Запустити',
    'start' => 'Пуск',
    'data_inconsistency' => 'Виявлено неузгодженість даних. Будь ласка, оновіть сторінку!',
    'one_time_code_expected' => 'Очікується одноразовий код',
    'data_are_missing' => 'Очікувані дані відсутні',
    'one_time_code' => 'Одноразовий код',
    'provide_personal_one_time_code' => 'Будь ласка, введіть одноразовий код, який ви отримали електронною поштою',
    'change_authentification_type_to_ldap' => 'Змінити тип аутентифікації на LDAP',
    'change_authentification_type_to_local' => 'Змінити тип аутентифікації на локальну базу даних Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Для автентифікації використовується пароль користувача в LDAP',
    'local_user_password_is_used_for_authentication' => 'Для автентифікації використовується пароль користувача в Teampass',
    'provide_your_current_password' => 'Введіть поточний пароль',
    'current_password' => 'Поточний пароль',
    'password_is_not_correct' => 'Цей пароль невірний',
    'ldap_password_change_warning' => 'Ваш пароль для входу змінився з моменту останнього з’єднання. Потрібно повторно зашифрувати всі ключі за допомогою цього нового пароля. Для цієї операції заповніть наступне поле своїм попереднім паролем LDAP. Операція може зайняти декілька хвилин.',
    'personal_items' => 'Особисті елементи',
    'logout_on_going' => 'Тепер ви вийдете з системи. Відтепер, для підключення, використовуйте свій новий пароль.',
    'fill_in_fields_and_hit_launch' => 'Надайте очікувані дані та натисніть кнопку запуску',
    'please_select_a_folder' => 'Будь ласка, оберіть теку',
    'user_must_have_login_and_email' => 'Користувач повинен мати логін і електронну пошту',
    'user_has_this_role_in_teampass' => 'Користувач має цю роль у Teampass',
    'select_role_to_create' => 'Виберіть роль, яку потрібно створити',
    'adding_ldap_role_to_teampass' => 'Ви можете створити роль у Teampass зі свого Active Directory. Це дозволить прив\’язати користувача до цієї ролі в Teampass.',
    'add_user_to_role' => 'Додати цю роль користувачеві в Teampass',
    'add_user_in_teampass' => 'Додати користувача у Teampass',
    'synchronized' => 'Синхронізовано',
    'output' => 'Вихідні дані',
    'remove_install_folder' => 'Інсталяційну теку необхідно видалити',
    'list_users' => 'Список користувачів',
    'ldap_synchronization' => 'Синхронізація LDAP',
    'in_progress' => 'В процесі',
    'clipboard_password_life_duration' => 'Затримка перед очищенням буфера обміну (у секундах)',
    'clipboard_password_life_duration_tip' => 'Дозволяє визначити затримку в секундах, до того, як пароль, скопійований у буфер обміну, буде видалено з буфера обміну веб-переглядача. Встановіть 0, щоб вимкнути.',
    'clipboard_will_be_cleared' => 'Пароль наразі у буфері обміну. Скоро буде очищено...',
    'file_folder_not_accessible' => 'Тека з файлами недоступна',
    'error_missing_id' => 'Сталась помилка. Відсутній ідентифікатор ...?',
    'error_folder_not_allowed' => 'Вибрана тека не дозволена',
    'all_fields_mandatory' => 'Усі поля є обов\’язковими для заповнення',
    'history_insert_entry' => 'Вставити в журнал',
    'clear_form' => 'Очистити форму',
    'info_about_history_insertion' => 'Увага! Ця функція дозволяє вручну вставляти подію в журнал історії елементів. Після додавання його буде неможливо видалити. Також зауважте, що ваш обліковий запис буде пов&apos;язано з цим новим записом.',
    'select_all' => 'Виділити все',
    'unselect_all' => 'Зняти вибір із усіх',
    'no_data_to_display' => 'Немає даних для відображення! Або жодної теки не існує, або ви не маєте доступу до жодної з них.',
    'server' => 'Сервер',
    'data_refreshed' => 'Дані оновлені',
    'loading_image' => 'Завантаження зображення',
    'compare_with_another_role' => 'Порівняти з іншою роллю',
    'only_display_folders_to_depth' => 'Відображати лише теки на глибину',
    'propagate_rights_to_descendants' => 'Поширювати права на нащадків',
    'loading_data' => 'Завантаження даних',
    'password_overview_delay' => 'Затримка для перегляду пароля',
    'password_overview_delay_tip' => 'Цей параметр дозволяє визначити кількість секунд, протягом яких відкритий пароль відображатиметься користувачеві.',
    'select_date_showing_items_expiration' => 'Список елементів, термін придатності яких закінчився',
    'renewal_page_info' => 'Ця сторінка дозволяє визначити позиції, термін дії яких закінчився або закінчується в наступному періоді.',
    'filename' => 'Ям&apos;я файлу',
    'exported_to_file' => 'Експортувати у файл',
    'operation_progress' => 'Операція триває',
    'exporting_items' => 'Експорт елементів',
    'select_folders_to_export' => 'Виберіть теки для експорту',
    'export_format_type' => 'Виберіть тип формату експорту',
    'export_items' => 'Експорт елементів',
    'loading_item' => 'Завантаження елементу',
    'otv_message' => 'Ви можете поділитися цим предметом з кимось, хто не має облікового запису Teampass. Одноразовий перегляд дозволяє вашому гостю отримати доступ до основних полів цього елемента лише один раз без автентифікації в Teampass. Будь ласка, зауважте, що це посилання дійсне протягом ##otv_expiration_period## днів. Скопіюйте посилання нижче та поділіться ним.',
    'no_sharekey_found' => 'Не знайдено ключа для цього файлу та вашого облікового запису',
    'otv_link' => 'Посилання для одноразового перегляду',
    'one_time_view' => 'Одноразовий перегляд',
    'move_right_columns_separator' => 'Перемістити роздільник стовпців праворуч',
    'move_left_columns_separator' => 'Перемістити роздільник стовпців ліворуч',
    'form_presents_inconsistencies' => 'Форма містить певні невідповідності. Будь ласка, перевірте поля у червоних рамках.',
    'download' => 'Завантажити',
    'see' => 'Побачити',
    'at_anyoneconmodify' => 'Будь-хто може змінити',
    'disabled' => 'Вимкнено',
    'enabled' => 'Увімкнено',
    'confirmation_seems_wrong' => 'Підтвердження здається неправильним, виправте',
    'i_cannot_remember' => 'Я не пам&apos;ятаю',
    'i_cannot_remember_info' => 'Ця дія здійснюється без відкату. Він очистить паролі, що зберігаються у ваших особистих елементах. Елементи не будуть видалені, а лише їхні паролі. Якщо ви не пам&apos;ятаєте свій особистий ключ, це єдиний варіант.',
    'user_has_psk_info' => 'Ми виявили, що у вас є деякі особисті елементи, закодовані старим особистим ключем. Мета цього етапу полягає в повторному шифруванні їх за допомогою вашого нового закритого ключа. Будь ласка, надайте нам свій персональний ключ.',
    'files' => 'Файли',
    'logs' => 'Журнали',
    'suggestions' => 'Пропозиції',
    'encryption_keys' => 'Ключі шифрування',
    'clearing_old_sharekeys' => 'Очищення старих спільних ключів',
    'hit_launch_to_start' => 'Натисніть кнопку «Запустити», щоб почати',
    'password_changed' => 'Пароль оновлено',
    'password_already_used' => 'Пароль вже використано',
    'change_login_password' => 'Змінити пароль для входу в систему',
    'current_password_mandatory' => 'Поточний пароль обов&apos;язковий',
    'objects_encryption_explanation' => 'Teampass було оновлено до нової версії, яка включає новий протокол шифрування. Він очікує від вас повторного шифрування ваших особистих даних. Для цього вам потрібно надати ваш поточний персональний сольовий ключ (PSK). Після цього, будь ласка, натисніть кнопку Запустити і зачекайте, поки процес не дійде до завершального етапу. Це може зайняти кілька хвилин, залежно від кількості об&apos;єктів.',
    'description_has_changed' => 'Опис змінено',
    'number_of_folders_imported' => 'Кількість імпортованих папок',
    'number_of_items_imported' => 'Кількість імпортованих елементів',
    'propagate' => 'Розповсюджуйте',
    'propagate_user_rights' => 'Розповсюджуйте права користувачів',
    'register_new_yubiko_key' => 'Зареєструйте новий ключ Yubiko',
    'part_of_groups' => 'Частина груп',
    'previous_value' => 'Попереднє значення',
    'no_previous_value' => 'Немає попереднього значення',
    'no_data_selected' => 'Не вибрано жодних даних',
    'selected_items_to_be_imported' => 'Вибрані елементи для імпорту',
    'cannot_open_file' => 'Файл не вдається відкрити',
    'no_item_found' => 'Елемент не знайдено',
    'reading_file' => 'Читання файлу',
    'where_shall_items_be_created' => 'Де створюються об&apos;єкти',
    'target_folder' => 'Цільова папка',
    'select_file' => 'Вибрати файл',
    'data_type_for_import' => 'Почніть з вибору типу даних для імпорту',
    'get_tips_about_importation' => 'Отримайте поради щодо імпорту',
    'import_new_items' => 'Імпортувати нові елементи',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'для',
    'request_access' => 'Запитати доступ до елемента',
    'request_access_message' => 'При запиті доступу до елемента, автору надсилається електронний лист. Автор прийме або відхилить запит, додавши вас до списку обмежень елемента. Будь ласка, підтвердіть відправку вашого запиту електронною поштою автору.',
    'request_access_reason' => 'Вкажіть автору причину вашого запиту',
    'error_provide_reason' => 'Будь ласка, вкажіть причину, чому ви хочете отримати доступ до цього елемента',
    'need_access' => 'Потрібен доступ?',
    'item_with_restricted_access' => 'Елемент з обмеженим доступом',
    'remaining_emails_to_send' => 'Залишилося надіслати електронних листів',
    'mfa_flash' => 'Спалахніть вашим мобільним пристроєм',
    'import' => 'Імпорт',
    'export' => 'Експорт',
    'offline' => 'Офлайн',
    'login_attempts_identified_since_last_connection' => 'Потрібна ваша увага. Виявлено принаймні одну спробу входу з вашим обліковим записом з моменту останнього успішного підключення. Будь ласка, перевірте та повідомте місцевого адміністратора, якщо це були не ви.',
    'last_login_attempts' => 'Останні спроби входу',
    'see_detail' => 'Переглянути деталі',
    'role_definition' => 'Визначення ролі',
    'not_yet_implemented' => 'Ще не реалізовано',
    '2factors_expected_for_admin' => 'Адміністратор вимагає MFA для входу',
    '2factors_expected_for_admin_tip' => 'За замовчуванням адміністратор повинен використовувати метод MFA для входу. Якщо не ввімкнено, адміністратор не вимагатиме його для входу, навіть якщо MFA ввімкнено для будь-якого іншого користувача.',
    'restore_done_now_logout' => 'Відновлення бази даних завершено. Тепер вам потрібно відключитися, щоб оновити змінні сеансу.',
    'backup_and_restore' => 'Резервне копіювання та відновлення',
    'explanation_for_oneshot_backup' => 'null',
    'explanation_for_oneshot_restore' => 'null',
    'perform_backup' => 'Виконати резервне копіювання',
    'perform_restore' => 'Виконати відновлення',
    'backup_select' => 'Файл резервного копіювання',
    'choose_file' => 'Вибрати файл',
    'on_the_fly' => 'На льоту',
    'scheduled' => 'Заплановано',
    'caution_on_field_encryption_change' => 'Увага - Зверніть увагу, що зміна типу шифрування вимагатиме обробки всіх існуючих даних для зміни шифрування в базі даних.',
    'caution_while_deleting_field' => 'Увага - Видалення цього поля також видалить пов&apos;язані дані в елементах.',
    'error_could_not_update_the_field' => 'Помилка - Поле не вдалося оновити. Будь ласка, спробуйте ще раз після перезавантаження сторінки.',
    'caution_while_deleting_category' => 'Увага - Видалення цієї папки видалить усі її поля та всі пов&apos;язані дані полів.',
    'your_attention_please' => 'Увага, будь ласка',
    'all_fields_are_required' => 'Усі поля обов&apos;язкові',
    'position' => 'Позиція',
    'before' => 'Перед',
    'top' => 'Верх',
    'bottom' => 'Низ',
    'field' => 'Поле',
    'configuration' => 'Конфігурація',
    'definition' => 'Деталі',
    'number_of_modified_attachments' => 'Кількість змінених вкладень',
    'files_not_encrypted' => 'Файли наразі не зашифровані. Ви повинні виконати цю зміну з міркувань безпеки.',
    'files_already_encrypted' => 'Файли вже зашифровані. Ви не повинні змінювати це з міркувань безпеки.',
    'action_to_be_performed' => 'Дія, яку потрібно виконати',
    'last_execution' => 'Останнє виконання',
    'never_performed' => 'Ніколи не виконувалося',
    'launch' => 'Запуск',
    'set_of_actions' => 'Набір дій',
    'uploads' => 'Відвантаження',
    'uploads_configuration' => 'Конфігурація відвантажень',
    'email_configuration' => 'Конфігурація електронної пошти',
    'email_configuration_test' => 'Тест конфігурації електронної пошти',
    'send_a_test_email' => 'Надіслати тестовий електронний лист',
    'manage_emails_not_sent' => 'Керування ненадісланими електронними листами',
    'email_send_backlog' => '#nb_emails# ненадісланих електронних листів',
    'send_waiting_emails' => 'Надіслати очікуючі електронні листи',
    'ip' => 'IP',
    'no_data_defined' => 'Дані не визначені',
    'adding_new_api_ip' => 'Додавання нової IP-адреси до білого списку',
    'adding_new_api_key' => 'Додавання нового API-ключа',
    'api_configuration' => 'Конфігурація API',
    'mfa_configuration' => 'Конфігурація MFA',
    'yubico_authentication_tip' => 'Будь ласка, відвідайте www.yubico.com для отримання додаткової інформації.',
    'complexity_level_not_reached' => 'Рівень складності не досягнуто',
    'expected_complexity_level' => 'Очікуваний рівень складності',
    'your_attention_is_required' => 'Потрібна ваша увага',
    'favorite' => 'Улюблене',
    'unfavorite' => 'Не улюблене',
    'you_need_to_select_at_least_one_folder' => 'Вам потрібно вибрати принаймні одну папку',
    'no_value_defined_please_fix' => 'Значення не визначено! Будь ласка, виправте.',
    'apply' => 'Застосувати',
    'from' => 'Від',
    'please_confirm_by_clicking_checkbox' => 'Будь ласка, підтвердіть, натиснувши на прапорець',
    'date_range' => 'Діапазон дат',
    'purge' => 'Очищення',
    'belong_of_deleted_folder' => 'Належить до видаленої папки',
    'highlight_selected' => 'Виділити вибране',
    'number_of_selected_objects' => 'Кількість вибраних об&apos;єктів',
    'confirm_selection_restore' => 'Будь ласка, підтвердіть відновлення вибраних елементів.',
    'confirm_selection_delete' => 'Будь ласка, підтвердіть видалення вибраних елементів.',
    'refreshing' => 'Оновлення',
    'empty_list' => 'Порожній список',
    'deleted_folders' => 'Видалені папки',
    'deleted_items' => 'Видалені елементи',
    'recycled_bin' => 'Кошик',
    'database' => 'База даних',
    'renewal' => 'Поновлення',
    'renewal_delay' => 'Затримка поновлення',
    'please_confirm_deletion' => 'Будь ласка, підтвердіть видалення',
    'caution' => 'Увага',
    'role_not_exist' => 'Ця роль не існує!',
    'role_can_edit_any_visible_item' => 'Роль може редагувати будь-який видимий елемент',
    'role_can_edit_any_visible_item_tip' => 'Зазвичай цей прапорець залишається незаповненим. Якщо його встановити, користувач, який належить до цієї ролі, зможе редагувати будь-який елемент, який він може відкрити, що призводить до небезпечного стану. Його слід встановлювати лише на певний період часу та за необхідності.',
    'edit_allowed' => 'Редагування дозволено',
    'delete_allowed' => 'Видалення дозволено',
    'add_allowed' => 'Додавання дозволено',
    'edit_not_allowed' => 'Редагування не дозволено',
    'delete_not_allowed' => 'Видалення не дозволено',
    'select_a_role' => 'Виберіть роль',
    'access_rights_for_user' => 'Права доступу для користувача',
    'logs_for_user' => 'Журнали для користувача',
    'please_confirm' => 'Підтвердьте, будь ласка',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Натиснувши цей прапорець, ви підтверджуєте видалення цього користувача.',
    'fields_with_mandatory_information_are_missing' => 'Відсутні поля з обов&apos;язковою інформацією',
    'enable_personal_folder_for_this_user' => 'Увімкнути функцію особистої папки для цього користувача',
    'special' => 'Спеціальний',
    'administrator' => 'Адміністратор',
    'super_manager' => 'Менеджер Teampass',
    'manager' => 'Менеджер',
    'read_only' => 'Тільки для читання',
    'privileges' => 'Привілеї',
    'roles' => 'Ролі',
    'user_definition' => 'Визначення користувача',
    'no_selection_done' => 'Вибір не зроблено',
    'tick_confirmation_box' => 'Будь ласка, встановіть прапорець для підтвердження',
    'next_list_to_be_deleted' => 'Наступний список буде видалено',
    'delete_folders' => 'Видалити папки',
    'submit' => 'Надіслати',
    'label' => 'Мітка',
    'parent' => 'Батьківський',
    'password_minimal_complexity_target' => 'Мінімальний рівень складності пароля',
    'access_right_for_roles' => 'Права доступу для ролей',
    'create_without_password_minimal_complexity_target' => 'Дозволити створення нового елемента без мінімального рівня складності пароля',
    'edit_without_password_minimal_complexity_target' => 'Дозволити редагування елемента без мінімального рівня складності пароля',
    'add_new_folder' => 'Додати нову папку',
    'new' => 'Новий',
    'id' => 'Ідентифікатор',
    'mfa_short' => 'MFA',
    'mfa' => 'Багатофакторна автентифікація',
    'google_2fa' => 'Двоетапна перевірка Google',
    'duo_security' => 'Duo Security',
    'yubico' => 'Аутентифікатор Yubico',
    'website_canal' => 'Клікнути для переходу на Teampass вебсайт',
    '2fa_credential_not_correct' => 'Облікові дані 2FA невірні',
    'no_change_performed' => 'Зміни не виконано.',
    'password_strength' => 'Сила пароля',
    'new_password_required' => 'Потрібен новий пароль',
    'limited_search' => 'Обмежений пошук',
    'empty_psk' => 'Відсутній Saltkey',
    'currently_no_favorites' => 'У вас наразі немає улюблених',
    'favorites' => 'Улюблені',
    'confirm_item_move' => 'Ви вибрали "Переміщення"... ви впевнені?',
    'copy_to_clipboard' => 'Скопіювати в буфер обміну',
    'please_wait_while_loading' => 'Будь ласка, зачекайте, поки завантажуються дані',
    'defect_report' => 'Звіт про помилку',
    'actions' => 'Дії',
    'no_user' => 'Невірний користувач',
    'generate_api_token' => 'Створити новий API-токен',
    'upload_feature' => 'Функція відвантаження',
    'profile' => 'Профіль',
    'language' => 'Мова',
    'upload_new_avatar' => 'Виберіть файл зображення профілю',
    'settings' => 'Налаштування',
    'created_items' => 'Створені елементи',
    'modification_performed' => 'Зміни виконано',
    'items_opened' => 'Відкриті елементи',
    'passwords_seen' => 'Переглянуті паролі',
    'nothing_to_save' => 'Нічого зберігати',
    'notification_engaged' => 'Ви отримуєте сповіщення про зміну елемента',
    'notification_not_engaged' => 'Ви не отримуєте сповіщення про зміну елемента',
    'viewed_number' => 'Кількість переглядів',
    'automatic_deletion_engaged' => 'Автоматичне видалення',
    'auto_update_enabled' => 'Увімкнено автоматичну зміну пароля користувача. Наступна зміна запланована',
    'copy_folder' => 'Копіювати теку',
    'select_source_folder' => 'Виберіть папку для копіювання',
    'select_destination_folder' => 'Виберіть папку призначення',
    'delete_folder' => 'Видалити папку',
    'select_folder_to_delete' => 'Виберіть папку для видалення',
    'folder_delete_confirm' => 'Вибрана папка та її елементи будуть видалені. Будь ласка, встановіть прапорець для підтвердження цього видалення.',
    'json_error_format' => 'Невірний формат JSON',
    'password_cannot_be_empty' => 'Пароль не може бути порожнім',
    'password_too_long' => 'Пароль занадто довгий',
    'error_no_action_identified' => 'Дію не визначено',
    'ldap' => 'LDAP',
    'emails' => 'Електронні листи',
    'backups' => 'Резервні копії',
    'api' => 'API',
    'add_folder' => 'Додати нову папку',
    'select_folder_parent' => 'Вибрати батьківську папку',
    'add' => 'Додати',
    'key_is_not_correct' => 'Наданий ключ сесії неправильний',
    'suggestion_information' => 'Ви можете запропонувати будь-які зміни цього елемента автору. Використовуйте форму вище, щоб зробити свої пропозиції щодо змін, і натисніть кнопку Виконати, щоб повідомити автора.',
    'email_address' => 'Адреса електронної пошти',
    'enter_email' => 'Введіть електронну пошту',
    'notification' => 'Сповіщення',
    'notify_on_change' => 'Повідомляти про зміни',
    'notification_message' => 'Ви можете використовувати це налаштування, щоб отримувати або не отримувати сповіщення про зміни, внесені до цього елемента.',
    'share_item' => 'Поділитися елементом',
    'share_item_message' => 'Ви можете поділитися цим елементом з кимось. Будь ласка, надайте дійсну електронну адресу і натисніть кнопку Виконати.',
    'delete_item_message' => 'Ви вирішили видалити цей вибраний елемент. Вам потрібно підтвердити свій вибір, натиснувши кнопку Виконати.',
    'warning' => 'Попередження',
    'information' => 'Інформація',
    'perform' => 'Виконати',
    'delete_item' => 'Видалити елемент',
    'copy_item' => 'Копіювати елемент',
    'new_item' => 'Новий елемент',
    'error_not_allowed_to_edit_item' => 'Вам не дозволено редагувати цей елемент',
    'error_not_allowed_to_access_this_folder' => 'Вам не дозволено доступ до цієї папки',
    'error_personal_saltkey_is_not_set' => 'Ваш особистий ключ солі не надано.',
    'provide_your_personal_saltkey' => 'Будь ласка, надайте свій особистий ключ солі',
    'no_fields' => 'Жодне поле не пов&apos;язане з цим елементом.',
    'uploaded' => 'відвантажено',
    'changes_ongoing' => 'Деякі зміни не були збережені. Ви підтверджуєте вихід без збереження?',
    'no_file_to_upload' => 'Немає файлу для відвантаження',
    'add_files_and_click_start' => 'Додайте файли до черги завантаження і натисніть кнопку старту.',
    'select_files' => 'Вибрати файли',
    'attached_files' => 'Прикріплені файли',
    'visible_by' => 'Видно для',
    'anounce_item_by_email' => 'Оголосити цей елемент користувачам',
    'select_users_if_needed' => 'Виберіть користувачів, якщо потрібно',
    'allow_item_to_be_deleted' => 'Дозволити видалення цього елемента за наступною умовою',
    'item_deleted_after_being_viewed_x_times' => 'Елемент буде видалено після перегляду X разів',
    'item_deleted_after_date' => 'Елемент буде видалено після визначеної дати',
    'password' => 'Пароль',
    'save' => 'Зберегти',
    'folder' => 'Папка',
    'main' => 'Головна',
    'fields' => 'Поля',
    'details' => 'Деталі',
    'no_special_restriction' => 'Немає спеціальних обмежень',
    'generate_otv_link' => 'Генерувати одноразове посилання для перегляду',
    'no_custom_fields' => 'Немає користувацьких полів',
    'no_attachment' => 'Немає вкладень',
    'logout_confirm' => 'Вийти? Будь ласка, підтвердіть.',
    'saved' => 'Збережено',
    'attachments' => 'Вкладення',
    'success' => 'Успіх',
    'server_answer_error' => 'Виникла помилка. Відповідь від сервера не може бути розібрана!',
    'server_returned_data' => 'Повернені дані',
    'version_alone' => 'версія',
    'statistics' => 'Статистика',
    'options' => 'Опції',
    'users' => 'Користувачі',
    'folders' => 'Теки',
    'find_message' => 'об&apos;єктів знайдено',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'share' => 'Поділитися цим об&apos;єктом',
    'notify' => 'Повідомити',
    'error_no_selected_folder' => 'Необхідно вибрати теку',
    'email_subject_item_updated' => '[Teampass] Один елемент, за яким ви стежите, оновлено',
    'email_body_item_updated' => 'Привіт,<br><br>Це згенерований лист від менеджера паролів Teampass.<br><br>Ви просили сповіщати вас про зміни, виконані в елементі `#мітка_елемента#` в папці `#назва_папки#`. <br><br>Користувач <b>#ім&apos;я# #прізвище#</b> зробив принаймні одну зміну.<br><br>Ви можете відкрити його, натиснувши наступне <a href=&apos;#url#/index.php?page=items&group=#item_category#&id=#item_id#&apos;>ПОСИЛАННЯ</a>.<br><br>Всього найкращого',
    'import_kp_finished' => 'Імпорт за допомогою файлу KeePass завершено! Необхідну складність пароля для нових папок встановлено на Середню.',
    'password_is_empty' => 'Елемент не має пароля',
    'bug_report_to_github' => 'Заповніть вміст звіту, потім скопіюйте його в буфер обміну та вставте на сторінку нової проблеми Github',
    'open_bug_report_in_github' => 'Відкрити звіт про проблему в Github',
    'bugs_page' => 'Якщо ви виявили помилку, будь ласка, повідомте про це.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Будь-який користувач вашої групи може редагувати всі імпортовані елементи.',
    'import_csv_anyone_can_modify_txt' => 'Будь-який користувач може редагувати всі імпортовані елементи.',
    'settings_upload_imageresize_options' => 'Змінювати розмір завантажених зображень',
    'user_not_exists' => 'Користувача не існує',
    'auto_create_folder_role' => 'Створіть нову теку та виберіть роль',
    'start_upload' => 'Почати завантаження',
    'error_upload_runtime_not_found' => 'Не знайдено жодного часу виконання',
    'user_profile_api_key' => 'Ваш токен для API',
    'index_change_pw' => 'Зміна поролю',
    'admin_2factors_authentication_setting' => 'Увімкнути 2-факторну перевірку Google',
    'admin_2factors_authentication_setting_tip' => 'Двофакторна автентифікація Google покращує безпеку входу. Під час входу відображається QR-код, який потрібно відсканувати в програму Google Authentication користувача, щоб отримати одноразовий пароль. Вимагає, щоб усі користувачі мали програму автентифікації Google на підключеному до Інтернету мобільному пристрої.',
    'admin_ga_website_name' => 'Ім&apos;я, котре відображається в Google Authenticator для Teampass',
    'admin_ga_website_name_tip' => 'Це ім&apos;я використовується для облікового запису з ідентифікаційним кодом у 2-етапній верифікації Google.',
    'api_whitelist_ips' => 'Білий список IP-адрес API',
    'api_whitelist_ips_tip' => 'Якщо тут явно не вказані IP-адреси клієнтів API, то будь-яка IP-адреса авторизована.',
    'email_share_item_subject' => 'Вам надали доступ до елемента пароля',
    'email_share_item_mail' => 'Привіт,<br><br>Це згенерований лист від менеджера паролів Teampass.<br><br>#tp_user# поділився з вами елементом пароля',
    'index_maintenance_mode_admin' => 'Увімкнено режим обслуговування. Користувачі не можуть увійти.',
    '2fa_authentication_selector' => 'Виберіть 2-факторний метод автентифікації',
    'upload_empty_file' => 'Завантажити пустий файл',
    'upload_any_extension_file' => 'Завантажити файл будь-якого розширення',
    'upload_any_extension_file_tip' => 'Якщо цей параметр увімкнено, користувачі зможуть завантажувати будь-які файли.',
    'log_in' => 'Увійти',
    'create_item_based_upon_template' => 'Використання шаблону для елемента',
    'create_item_based_upon_template_tip' => 'Коли увімкнено, ця функція дозволяє автору вибрати шаблон, створений з користувацьких полів. Зверніть увагу, що ця функція також вимагає увімкнення користувацьких полів.',
    'main_template' => 'Використання в якості шаблону',
    'is_mandatory' => 'Обов&apos;зкове',
    'error_field_is_mandatory' => 'Принаймні одне обов\’язкове поле порожнє',
    'restrict_visibility_to' => 'Обмежити видимість для',
    'every_roles' => 'Всі ролі',
    'masked_text' => 'Прихований текст',
    'textarea' => 'Текстове поле',
    'admin_yubico_authentication_setting' => 'Увімкнути аутентифікацію Yubico',
    'yubico_user_id' => 'Ідентифікатор клієнта (ID)',
    'yubico_user_key' => 'Секретний ключ',
    'yubico_bad_code' => 'Неправильна інформація Yubico',
    'press_your_yubico_key' => 'Натисніть вашу Yubico ключ',
    'human_resources' => 'Супер менеджер',
    'settings_secure_display_image' => 'Увімкнути захищене відображення зображень',
    'settings_secure_display_image_tip' => 'Захищене відображення зображення дозволяє читати зображення через PHP, коли користувач переглядає зображення, прикріплене до елемента. Плюси: вкладення зберігається поза текою сайту і недоступне для хакерів. Мінус: це трохи повільніше, ніж попередній перегляд безпосередньо з URL-адреси.',
    'user_ga_code' => 'Відправити Google Authenticator користувачу на електронну пошту',
    'error_no_email' => 'У цього користувача не вказано електронну пошту!',
    'error_no_user' => 'Користувач не знайдений!',
    'email_ga_subject' => 'Ваш Google Authenticator флеш код для Teampass',
    'email_ga_text' => 'Вітаю, <a href="#link#">перейдіть за цим посиланням</a> і зіскануйте QR-код за допомогою застосунка Google Authenticator. Це потрібно для налаштування вашого флеш-коду',
    'settings_attachments_encryption' => 'Ввімкнути шифрування для вкладень',
    'settings_attachments_encryption_tip' => 'ЦЕ НАЛАШТУВАННЯ МОЖЕ ПОШКОДИТИ ІСНУЮЧІ ВКЛАДЕННЯ',
    'admin_action_attachments_cryption' => 'Зашифрувати або розшифрувати всі вкладення',
    'admin_action_attachments_cryption_tip' => 'Застереження: шифруйте або розшифровуйте файли лише після зміни налаштувань шифрування вкладень. Виберіть, чи потрібно зашифрувати чи розшифрувати, а потім натисніть «Пуск». Перед запуском цієї функції створіть резервну копію теки завантаження.',
    'encrypt' => 'Зашифрувати',
    'decrypt' => 'Розшифрувати',
    'ga_identification_code' => 'Ідентифікаційний код',
    'ga_enter_credentials' => 'Вам необхідно ввести ваші дані для входу',
    'ga_bad_code' => 'Код Google Authenticator неправильний',
    'settings_get_tp_info' => 'Показувати новини та інформацію адміністраторам',
    'settings_get_tp_info_tip' => 'Якщо ввімкнено, така інформація, як поточні версії програмного забезпечення, виправлення помилок і новини про випуск, відображається на сторінці інформації адміністратора з віддалених серверів.',
    'settings_offline_mode' => 'Експорт HTML для режиму офлайн ввімкнено',
    'settings_offline_mode_tip' => 'Офлайн режим створює автономну HTML вебсторінку, яку можна завантажити на комп&apos;ютер. Елементи на офлайн сторінці зашифровані паролем, вказаним користувачем при створенні.',
    'offline_mode_key_level' => 'Мінімальна стійкість шифрування для режиму офлайн',
    'categories' => 'Користувацькі поля',
    'no_category_defined' => 'Жодної категорії не створено',
    'confirm_deletion' => 'Ви обрали видалення... впевнені?',
    'settings_item_extra_fields' => 'Користувацькі поля ввімкнено',
    'settings_item_extra_fields_tip' => 'Дозволяє додати ще одну вкладку при створенні елементів пароля, яка містить спеціальні поля для інших типів даних. Адміністратор повинен спочатку створити категорії та мітки спеціальних полів, які будуть відображатися в цих категоріях. Ця функція споживає більше ресурсів сервера.',
    'settings_ldap_type' => 'Тип LDAP-серверу',
    'server_time' => 'Час на сервері',
    'settings_tree_counters' => 'Відображати лічильникі у дереві тек',
    'settings_tree_counters_tip' => 'Увімкнення, показує три числа поруч із кожною текою: кількість елементів у основній теці; кількість елементів, включаючи вкладені теки; кількість вкладених тек.',
    'admin_action_check_pf' => 'Створити персональні теки для всіх користувачів окрім поточного',
    'enable_personal_folder_feature_tip' => 'Особисті теки – це приватне місце для паролів окремих користувачів. Елементи паролів шифруються за допомогою сольового ключа користувача (більш безпечно) або його паролем (простіше). Якщо ввімкнути цю функцію, фактичні теки, для наявних користувачів, не створюватимуться – вам також потрібно запустити завдання створення особистих тек.',
    'administrators_only' => 'Тільки адміністратори',
    'managers_of' => 'Менеджери ролі',
    'managed_by' => 'Керується',
    'settings_enable_sts' => 'HTTPS Strict Transport Security (HSTS) <strong>Попередження</strong>: прочитайте підказку!',
    'settings_enable_sts_tip' => 'Попередження! Це забезпечить дотримання політики HTTPS strict transport security (STS). STS допомагає запобігти атакам типу "людина посередині". Ви повинні мати SSL сертифікат, виданий сертифікаційним центром (CA), встановлений перед увімкненням цієї опції! Самопідписаний сертифікат не працюватиме! Будь-які майбутні веб-з&apos;єднання вимагатимуть HTTPS. Ви повинні мати &apos;SSLOptions +ExportCertData&apos; в конфігурації Apache SSL.',
    'settings_anyone_can_modify_bydefault' => '<i>Будь-хто може змінити</i> опція вибрана за замовчуванням',
    'to' => 'для',
    'settings_upload_maxfilesize_tip' => 'Максимальний розмір файлу, дозволений при завантаженні вкладення або іншого файлу (в мегабайтах, налаштування за замовчуванням 10 МБ). Вам також може знадобитися змінити налаштування у php.ini upload_max_filesize та post_max_size, за замовчуванням, там часто лише 2 МБ.',
    'settings_upload_docext_tip' => 'Перерахуйте розширення файлів для текстових і текстових процесорів, які ви дозволите завантажувати як вкладення. Вкажіть дозволені розширення файлів, розділені комою (,)',
    'settings_upload_imagesext_tip' => 'Перерахуйте розширення файлів для зображень, які ви дозволите завантажувати як вкладення. Вкажіть дозволені розширення файлів, розділені комою (,)',
    'settings_upload_pkgext_tip' => 'Перерахуйте розширення файлів для стиснутих архівів, які ви дозволите завантажувати як вкладення. Вкажіть дозволені розширення файлів, розділені комою (,)',
    'settings_upload_otherext_tip' => 'Перерахуйте будь-які інші розширення файлів, які ви дозволите завантажувати як вкладення. Вкажіть дозволені розширення файлів, розділені комою (,)',
    'settings_upload_imageresize_options_tip' => 'Змініть розмір великих завантажених зображень (встановіть максимальні розміри в пікселях). Зображення ширше 1000 пікселів можуть не відображатися добре у веббраузері.',
    'settings_upload_maxfilesize' => 'Максимальний розмір вкладення',
    'settings_upload_docext' => 'Дозволені розширення документів',
    'settings_upload_imagesext' => 'Дозволені розширення зображень',
    'settings_upload_pkgext' => 'Дозволені розширення архівів',
    'settings_upload_otherext' => 'Інші дозволені розширення',
    'settings_upload_imageresize_options_w' => 'Максимальна ширина зображення',
    'settings_upload_imageresize_options_h' => 'Максимальна висота зображення',
    'settings_upload_imageresize_options_q' => 'Якість зображення jpeg',
    'settings_importing' => 'Імпорт з KeePass чи CSV файлів активовано',
    'admin_proxy_ip' => 'IP адреса проксі сервера',
    'admin_proxy_ip_tip' => 'Якщо вам потрібен проксі-сервер для підключення до Інтернету, вкажіть тут IP-адресу. В іншому випадку залиште порожнім.',
    'admin_proxy_port' => 'Порт проксі сервера',
    'admin_proxy_port_tip' => 'Якщо вам потрібен проксі-сервер для підключення до Інтернету, вкажіть тут номер порту.',
    'settings_ldap_elusers' => 'Тільки локальні користувачі Teampass',
    'settings_ldap_elusers_tip' => 'Ця функція дозволяє користувачам у базі даних аутентифікуватися через LDAP. Вимкніть це, якщо ви хочете переглядати будь-який LDAP каталог.',
    'db_items_edited' => 'Елемент зараз редагується',
    'item_edition_start_hour' => 'Редагування розпочато',
    'settings_delay_for_item_edition' => 'Ексклюзивне блокування редагування закінчується через XX хвилин',
    'settings_delay_for_item_edition_tip' => 'При редагуванні елемента, елемент блокується, щоб жоден інший користувач не міг його змінити. Це налаштування видаляє токен блокування через певну кількість хвилин. Якщо значення встановлено на 0, елемент ніколи не буде автоматично розблоковано після початку редагування.',
    'db_users_logged' => 'Користувачів в системі',
    'action' => 'Дія',
    'login_time' => 'Logged since',
    'lastname' => 'Прізвище',
    'user_login' => 'Логін',
    'role' => 'Роль',
    'error_role_exist' => 'Ця роль вже існує!',
    'error_no_edition_possible_locked' => 'Редагування вимкнено, бо елемент заблокований іншим користувачем',
    'select' => 'вибрати',
    'items' => 'Об&apos;єкти',
    'enable_personal_saltkey_cookie' => 'Зберігати персональний salt key у cookie браузера',
    'personal_saltkey_cookie_duration' => 'Термін дії salt key користувача закінчується через XX днів',
    'admin_email_smtp_server' => 'Адреса серверу SMTP',
    'admin_email_auth' => 'Сервер вимагає аутентифікації',
    'admin_email_auth_username' => 'Ім&apos;я користувача поштового сервера',
    'admin_email_auth_pwd' => 'Пароль поштового сервера',
    'admin_email_port' => 'Порт серверу SMTP',
    'admin_email_from' => 'Від: Адреса електронної пошти',
    'admin_email_from_name' => 'From: Display name',
    'admin_email_test_configuration_tip' => 'Надіслати тестовий електронний лист користувачу, який увійшов у систему. Спочатку потрібно встановити свою електронну адресу, натиснувши на іконку профілю користувача.',
    'admin_email_test_subject' => 'Тестовий електронний лист від адміністратора',
    'admin_email_test_body' => 'Це тестовий електронний лист, надісланий для перевірки конфігурації поштового сервера. Якщо ви це читаєте, вітаємо!',
    'admin_email_result_ok' => 'Лист надіслано на',
    'email_bodyalt_item_updated' => 'Пароль для',
    'admin_email_send_backlog_tip' => 'Повторно надіслати будь-які відкладені вихідні листи, що очікують у базі даних.',
    'please_wait' => 'Будь ласка, зачекайте',
    'admin_path_to_files_folder' => 'Папка файлів (повний шлях)',
    'admin_path_to_files_folder_tip' => 'Папка файлів використовується для зберігання як системних файлів, так і деяких завантажених файлів. Для найвищої безпеки вона не повинна знаходитися у папці www вашого сайту - вона повинна бути створена у папці за межами каталогу вашого вебсайту та доступна через правило перенаправлення або переписування.</span>',
    'admin_path_to_upload_folder_tip' => 'Вкладення файлів зберігаються у папці завантажень з випадковими іменами. Вміст цієї папки ніколи не повинен видалятися вручну. Для найвищої безпеки вона не повинна знаходитися у папці www вашого сайту - вона повинна бути створена у папці за межами каталогу вашого вебсайту та доступна через правило перенаправлення або переписування.</span>',
    'pdf_password_warning' => 'Ви повинні надати ключ шифрування!',
    'admin_pwd_maximum_length' => 'Максимальна довжина пароля',
    'admin_pwd_maximum_length_tip' => 'Максимальна довжина пароля за замовчуванням становить 40 символів. Збільшення розміру дозволених паролів займе більше часу при шифруванні, дешифруванні та відображенні паролів.',
    'settings_insert_manual_entry_item_history' => 'Дозволені ручні вставки в історію елементів',
    'settings_insert_manual_entry_item_history_tip' => 'Зазвичай ви захочете залишити це вимкненим. Коли увімкнено, історія елемента пароля може бути відредагована або змінена.',
    'admin_path_to_upload_folder' => 'Папка завантажень (повний шлях)',
    'admin_setting_enable_delete_after_consultation' => 'Паролі можуть закінчитися після обмеженої кількості переглядів',
    'admin_setting_enable_delete_after_consultation_tip' => 'Коли увімкнено, творці елементів можуть вирішити, чи буде елемент пароля автоматично видалено після обмеженої кількості переглядів.',
    'at_email' => 'електронна адреса',
    'enable_email_notification_on_item_shown' => 'Повідомляти адміністраторів, коли елемент пароля переглядається',
    'share_sent_ok' => 'Лист надіслано',
    'see_item_title' => 'Деталі елемента',
    'email_on_open_notification_subject' => 'Сповіщення про перегляд елемента пароля',
    'email_on_open_notification_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has opened and viewed the password item &apos;#tp_item#&apos;. <a href="#tp_link#">Click this link</a> to access the item.',
    'pdf' => 'PDF',
    'email_subject_new_user' => 'Обліковий запис для управління паролями створено для вас',
    'email_new_user_mail' => 'Привіт,<br><br>Це автоматично згенерований лист від менеджера паролів Teampass.<br><br>Адміністратор створив для вас обліковий запис у менеджері паролів. Безпечні паролі для вашої організації лише за один клік! <br><br>Використовуйте ці облікові дані для першого входу:<br>- Логін: #tp_login#<br>- Пароль: #tp_pw#<br><br><a href="#tp_link#">Натисніть це посилання</a>, щоб увійти та змінити свій пароль.',
    'error_empty_data' => 'Немає даних для обробки!',
    'error_not_allowed_to' => 'Відсутні права доступу для даної операції!',
    'request_access_ot_item' => 'Запитати дозвіл на зміну',
    'email_request_access_subject' => 'У вас є запит на доступ до елемента пароля',
    'email_request_access_mail' => 'Привіт,<br><br>Це автоматично згенерований лист від менеджера паролів Teampass.<br><br>Користувач #tp_user# запитав доступ до елемента пароля "#tp_item#".<br><br>Запит супроводжується наступним обґрунтуванням:<br><i>"#tp_reason#"</i><br><br>Будь ласка, перегляньте цей запит і підтвердіть, що ви дозволите доступ.<br><br>З повагою.',
    'admin_action_change_salt_key' => 'Змінити основний salt key, що використовується для шифрування',
    'nb_items_by_query' => 'Кількість елементів для отримання за запитом',
    'nb_items_by_query_tip' => 'Введіть кількість елементів для отримання за запитом сервера. Кілька менших запитів можуть працювати краще, ніж менше, але більших запитів. Інші варіанти: &apos;&apos;auto&apos;&apos; - налаштовано на розмір вікна відображення користувача. &apos;&apos;max&apos;&apos; - завантажити все одразу.',
    'open_url_link' => 'Відкрити у новому вікні',
    'error_pw_too_long' => 'Пароль довший за максимальну довжину системи (за замовчуванням 40 символів).',
    'at_restriction' => 'Обмеження',
    'pw_encryption_error' => 'Помилка шифрування пароля!',
    'enable_send_email_on_user_login' => 'Повідомляти адміністраторів при кожному вході користувача',
    'email_subject_on_user_login' => 'Інформація: вхід користувача у менеджер паролів',
    'email_body_on_user_login' => 'Привіт,<br><br>Це автоматично згенерований лист від менеджера паролів Teampass.<br><br>Користувач #tp_user# увійшов у менеджер паролів #tp_date# о #tp_time#. <br><br>Це нормальне повідомлення, коли увімкнено опцію <i>Повідомляти адміністраторів при кожному вході користувача</i>.',
    'account_is_locked' => 'Цей обліковий запис заблоковано',
    'activity' => 'Діяльність',
    'add_role_tip' => 'Додати нову роль',
    'admin' => 'Адміністрування',
    'admin_action_db_backup' => 'Резервне копіювання бази даних',
    'admin_action_db_clean_items' => 'Видалити сирітські елементи з бази даних',
    'admin_action_db_clean_items_tip' => 'Видаляє будь-які елементи або інші записи, що залишилися після видалення папки. Будь ласка, зробіть резервну копію перед виконанням цього завдання.',
    'admin_action_db_optimize' => 'Оптимізувати базу даних',
    'admin_action_db_restore' => 'Відновити базу даних',
    'admin_action_purge_old_files' => 'Очистити тимчасові файли',
    'admin_action_purge_old_files_tip' => 'Видаляє всі тимчасові файли старше 7 днів.',
    'admin_action_reload_cache_table' => 'Перезавантажити таблицю кешу',
    'admin_action_reload_cache_table_tip' => 'Пересоздає кеш елементів. Може виправити проблеми з відображенням або збереженням елементів пароля.',
    'admin_help' => 'Допомога',
    'admin_ldap_configuration' => 'Конфігурація LDAP',
    'admin_main' => 'Інформація',
    'admin_misc_cpassman_dir' => 'Розташування TeamPass (повний шлях)',
    'admin_misc_cpassman_url' => 'Розташування TeamPass (URL)',
    'admin_misc_custom_login_text' => 'Спеціальне повідомлення для входу',
    'admin_misc_custom_logo' => 'Спеціальний логотип для входу (URL)',
    'admin_misc_favicon' => 'Favicon (повний URL)',
    'admin_settings' => 'Налаштування',
    'admin_settings_title' => 'Налаштування',
    'admin_setting_activate_expiration' => 'Увімкнути закінчення терміну дії пароля',
    'admin_setting_activate_expiration_tip' => 'Коли увімкнено, елементи пароля не будуть відображатися після закінчення їх терміну дії. Встановіть час закінчення терміну дії пароля в днях в іншому місці перед увімкненням цієї функції.',
    'admin_views' => 'Утиліти',
    'alert_message_done' => 'Виконано!',
    'all' => 'всі',
    'anyone_can_modify' => 'Дозволити цей елемент змінювати будь-кому, хто має до нього доступ',
    'at' => 'в',
    'at_category' => 'Папка',
    'at_copy' => 'Копіювання виконано',
    'at_delete' => 'Видалення',
    'at_description' => 'Опис',
    'at_label' => 'Мітка',
    'at_login' => 'Логін',
    'at_moved' => 'Переміщено',
    'at_personnel' => 'Персональний',
    'at_restored' => 'Відновлено',
    'at_shown' => 'Доступ',
    'at_url' => 'URL',
    'author' => 'Автор',
    'authorized_groups' => 'Дозволені папки',
    'auth_creation_without_complexity' => 'Дозволити створення елементів без необхідної складності пароля',
    'auth_modification_without_complexity' => 'Дозволити зміну елементів без необхідної складності пароля',
    'cancel' => 'Скасувати',
    'can_create_root_folder' => 'Може створювати папку на кореневому рівні',
    'changelog' => 'Останні оновлення програмного забезпечення',
    'close' => 'Закрити',
    'complexity' => 'Мінімальна складність пароля',
    'complex_asked' => 'Необхідна складність пароля',
    'complex_level0' => 'Дуже слабкий',
    'complex_level1' => 'Слабкий',
    'complex_level2' => 'Середній',
    'complex_level3' => 'Сильний',
    'complex_level4' => 'Дуже сильний',
    'complex_level5' => 'Важкий',
    'complex_level6' => 'Дуже важкий',
    'confirm' => 'Підтвердити',
    'confirm_del_from_fav' => 'Будь ласка, підтвердіть видалення з обраного',
    'connections' => 'з&apos;єднання',
    'copy' => 'Копіювати',
    'copy_to_clipboard_small_icons' => 'Увімкнути іконку <i>копіювати пароль</i> у списку елементів',
    'copy_to_clipboard_small_icons_tip' => 'Додає маленьку іконку до списку елементів пароля на верхній панелі, яка копіює пароль у буфер обміну. Пароль можна скопіювати без необхідності вибору та завантаження всього вмісту елемента.',
    'date' => 'Дата',
    'date_format' => 'Формат дати',
    'delete' => 'Видалити',
    'deletion' => 'Видалення',
    'del_button' => 'Видалити',
    'description' => 'Опис',
    'disconnect' => 'Вийти',
    'done' => 'Готово',
    'duplicate_folder' => 'Папки можуть мати однакові імена',
    'duplicate_item' => 'Елементи можуть мати однакові імена',
    'email' => 'Електронна пошта',
    'email_subject' => 'Створено новий елемент пароля в менеджері паролів',
    'enable_favourites' => 'Функція закладок обраного увімкнена',
    'enable_personal_folder' => 'Персональні папки з приватним зберіганням паролів',
    'enable_personal_folder_feature' => 'Персональні папки з приватним зберіганням паролів',
    'enable_user_can_create_folders' => 'Підпапки, керовані будь-ким, хто може керувати батьківською папкою',
    'encrypt_key' => 'Ключ шифрування',
    'errors' => 'помилки',
    'error_group_exist' => 'Ця папка вже існує!',
    'error_html_codes' => 'Деякий текст містить HTML-коди! Це не дозволено.',
    'error_item_exists' => 'Цей елемент вже існує!',
    'error_label' => 'Мітка обов&apos;язкова!',
    'error_must_enter_all_fields' => 'Ви повинні заповнити всі поля!',
    'error_pw' => 'Потрібен пароль на вкладці пароля.',
    'error_tags' => 'У тегах дозволені лише пробіли',
    'error_user_exists' => 'Користувач вже існує',
    'expiration_date' => 'Дата закінчення терміну дії',
    'find' => 'Пошук',
    'forbidden_groups' => 'Заборонені папки',
    'forgot_my_pw_email_sent' => 'Лист надіслано',
    'functions' => 'Ролі',
    'gestionnaire' => 'Менеджер',
    'god' => 'Адміністратор',
    'group' => 'Папка',
    'group_parent' => 'Батьківська папка',
    'group_pw_duration' => 'Період оновлення',
    'group_pw_duration_tip' => 'У місяцях. Використовуйте 0 для відключення.',
    'history' => 'Історія',
    'home_personal_saltkey' => 'Ваш особистий ключ солі',
    'home_personal_saltkey_label' => 'Введіть ваш особистий ключ солі',
    'import_error_no_read_possible' => 'Неможливо прочитати файл!',
    'import_error_no_read_possible_kp' => 'Неможливо прочитати файл! Це має бути файл KeePass.',
    'import_keepass_to_folder' => 'Виберіть папку призначення',
    'index_add_one_hour' => 'Продовжити сесію на 1 годину',
    'index_change_pw_confirmation' => 'Підтвердити',
    'index_expiration_in' => 'закінчення сесії через',
    'index_get_identified' => 'Будь ласка, ідентифікуйте себе',
    'index_last_pw_change' => 'Пароль змінено',
    'index_last_seen' => 'Останнє підключення ',
    'index_login' => 'Обліковий запис',
    'index_new_pw' => 'Новий пароль',
    'index_password' => 'Пароль',
    'index_pw_error_identical' => 'Паролі повинні бути однаковими!',
    'index_pw_level_txt' => 'Сила пароля',
    'index_session_duration' => 'Тривалість сесії',
    'info' => 'Інформація',
    'item_menu_copy_login' => 'Скопіювати логін',
    'item_menu_copy_pw' => 'Скопіювати пароль',
    'item_menu_del_from_fav' => 'Видалити з обраного',
    'kbs' => 'КБ',
    'kb_menu' => 'База знань',
    'last_items_title' => 'Останні переглянуті елементи',
    'ldap_extension_not_loaded' => 'Розширення LDAP PHP не завантажено на сервері.',
    'level' => 'Рівень',
    'login' => 'Логін',
    'mask_pw' => 'Приховати/показати пароль',
    'max_last_items' => 'Розмір списку нещодавно переглянутих елементів паролів (за замовчуванням 10)',
    'minutes' => 'хвилин',
    'name' => 'Ім&apos;я',
    'nb_false_login_attempts' => 'Максимальна кількість спроб входу до блокування облікового запису (0 для відключення блокування)',
    'nb_folders' => 'Кількість папок',
    'nb_items' => 'Кількість елементів',
    'new_label' => 'Нова мітка',
    'no' => 'Ні',
    'none' => 'Немає',
    'none_selected_text' => 'Нічого не вибрано',
    'not_allowed_to_see_pw' => 'Доступ до елемента пароля заборонено!',
    'not_allowed_to_see_pw_is_expired' => 'Цей елемент закінчився!',
    'not_defined' => 'Не визначено',
    'number_of_used_pw' => 'Кількість старих паролів, які запам&apos;ятовуються для запобігання повторного використання (0 для відключення)',
    'pages' => 'Сторінки',
    'pdf_download' => 'Завантажити файл',
    'personal_salt_key' => 'Ваш особистий ключ солі',
    'pw' => 'Пароль',
    'pw_generate' => 'Згенерувати',
    'pw_is_expired_-_update_it' => 'Цей елемент закінчився! Вам потрібно змінити його пароль.',
    'pw_life_duration' => 'Паролі для входу закінчуються через xx днів (0 для відключення)',
    'readme_open' => 'Відкрити повний файл readme',
    'read_only_account' => 'Тільки для читання',
    'restore' => 'Відновити',
    'restricted_to' => 'Обмежено для',
    'restricted_to_roles' => 'Дозволити обмеження елементів для користувачів та ролей',
    'root' => 'Корінь',
    'secure' => 'Безпечно',
    'see_logs' => 'Переглянути журнали',
    'settings_anyone_can_modify' => 'Функція <i>Будь-хто може змінювати</i> увімкнена',
    'settings_anyone_can_modify_tip' => 'Це додає прапорець під час створення нового елемента пароля, який дозволяє зробити елемент змінюваним будь-ким.',
    'settings_default_language' => 'Мова інтерфейсу за замовчуванням',
    'settings_kb' => 'Функція бази знань',
    'settings_kb_tip' => 'Додає пункт меню для доступу до функції бази знань. База знань - це пошуковий FAQ, який дозволяє створювати довідку та нотатки, і прикріплювати їх до елементів паролів.',
    'settings_ldap_domain' => 'Суфікс облікового запису LDAP для вашого домену',
    'settings_ldap_domain_controler' => 'Контролер(и) домену LDAP',
    'settings_ldap_domain_controler_tip' => 'Вкажіть контролер домену, який надає послуги каталогу. Щоб збалансувати запити між кількома серверами, введіть список кожного імені сервера через кому. Приклад: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'Базовий DN LDAP для вашого домену',
    'settings_ldap_mode' => 'Увімкнути автентифікацію користувачів через сервер LDAP',
    'settings_ldap_mode_tip' => 'Увімкніть, якщо ви хочете автентифікувати входи користувачів за допомогою LDAP-сервера замість використання внутрішньої бази даних користувачів.',
    'settings_ldap_ssl' => 'Використовувати LDAP через SSL (LDAPS)',
    'settings_ldap_tls' => 'Використовувати LDAP через TLS',
    'settings_log_accessed' => 'Журнал переглядів елементів паролів користувачами',
    'settings_log_connections' => 'Журнал всіх входів в облікові записи користувачів',
    'settings_maintenance_mode' => 'Увімкнути режим обслуговування (відключити вхід користувачів)',
    'settings_manager_edit' => 'Менеджери можуть редагувати або видаляти будь-які елементи, які вони можуть переглядати',
    'settings_printing' => 'Експорт у PDF або CSV увімкнено',
    'settings_printing_tip' => 'Додає опцію експорту в меню дерева елементів, дозволяючи експортувати цілі папки у PDF або CSV. Паролі у CSV будуть експортовані без шифрування, тоді як файли PDF можуть бути захищені паролем.',
    'settings_restricted_to' => 'Увімкнути функцію <i>обмежено для</i> на елементах',
    'settings_show_description' => 'Показувати поле опису елемента у списках елементів',
    'size' => 'Розмір',
    'tags' => 'Теги',
    'timezone_selection' => 'Часовий пояс',
    'time_format' => 'Формат часу',
    'url' => 'URL',
    'user' => 'Користувач',
    'users_online' => 'користувачів онлайн',
    'user_alarm_no_function' => 'Цьому користувачеві не призначено жодних ролей!',
    'yes' => 'Так',
    'one_time_view_item_url_box' => 'Поділіться одноразовим URL з людиною, якій ви довіряєте, щоб побачити пароль <br><br>',
    'settings_api' => 'Доступ до API увімкнено',
    'settings_api_tip' => 'Інтерфейс прикладного програмування дозволяє розробникам програмного забезпечення отримувати доступ до елементів паролів у форматі JSON через мережу.',
    'settings_api_keys_list' => 'Список ключів API',
    'settings_api_keys_list_tip' => 'Ключі для доступу до API. Стороннє програмне забезпечення повинно використовувати випадковий ключ, створений тут, для доступу до інтерфейсу JSON.',
    'settings_api_key' => 'Ключ',
    'settings_api_add_ip' => 'Нова IP-адреса',
    'settings_api_ip' => 'IP-адреса',
    'subfolder_rights_as_parent' => 'Нові підпапки успадковують дозволи від батьківської папки',
    'subfolder_rights_as_parent_tip' => 'Якщо увімкнено, кожна нова підпапка успадковує ролі та дозволи батьківської папки. В іншому випадку дозвіл на папку призначається на основі ролі користувача, який її створює.',
    'show_only_accessible_folders_tip' => 'За замовчуванням користувачі бачать повне дерево папок елементів паролів, навіть якщо деякі папки недоступні для користувача. Ви можете видалити недоступні папки з перегляду, щоб спростити навігацію.',
    'show_only_accessible_folders' => 'Приховати недоступні папки паролів',
    'comment' => 'Коментар',
    'suggestion_menu' => 'Пропозиції',
    'settings_suggestion' => 'Функція пропозицій паролів увімкнена',
    'settings_suggestion_tip' => 'Функція пропозицій додає нове меню та сторінку, дозволяючи користувачам створювати пропозиції для нових елементів паролів. Це корисно, коли тільки менеджери можуть створювати елементи паролів.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'Пароль для LDAP bind DN',
    'settings_ldap_search_base' => 'База пошуку LDAP',
    'settings_ldap_bind_dn_tip' => 'Введіть bind DN, який може отримати доступ до користувачів і здійснювати пошук у дереві. Bind DN - це облікові дані, які автентифікують ваш доступ до каталогу.',
    'settings_ldap_bind_passwd_tip' => 'Пароль для вказаного вище bind DN.',
    'settings_ldap_search_base_tip' => 'Розташування кореневого DN для пошуку в дереві',
    'admin_email_server_url' => 'Налаштувати URL для посилань',
    'enable_email_notification_on_user_pw_change' => 'Надсилати електронний лист користувачу при зміні пароля',
    'settings_otv_expiration_period' => 'Одноразові посилання (OTV) закінчуються через XX днів',
    'write' => 'Запис',
    'read' => 'Читання',
    'no_access' => 'Немає доступу',
    'right_types_label' => 'Виберіть тип доступу до цієї папки для вибраної групи користувачів',
    'duplicate_item_in_folder' => 'Елементи в одній папці можуть мати схожі назви',
    'settings_roles_allowed_to_print' => 'Експорт дозволено для цих ролей (мультивибір)',
    'settings_roles_allowed_to_print_tip' => 'Виберіть кілька ролей, утримуючи CTRL під час вибору. Члени цих ролей зможуть експортувати папки у CSV або PDF, якщо експорт також увімкнено глобально.',
    'admin_email_security' => 'Тип безпеки SMTP',
    'alert_page_will_reload' => 'Сторінка зараз буде перезавантажена',
    'file_protection_password' => 'Визначити пароль для файлу',
    'expand' => 'Розгорнути',
    'collapse' => 'Згорнути',
    'settings_ldap_user_attribute' => 'Атрибут користувача для пошуку',
    'settings_ldap_user_attribute_tip' => 'Атрибут LDAP для пошуку імені користувача',
    'log_user_initial_pwd_changed' => 'Початковий пароль визначено',
    'log_user_email_changed' => 'Електронна пошта користувача змінена на ',
    'log_user_created' => 'Обліковий запис користувача створено',
    'log_user_locked' => 'Користувач заблокований',
    'log_user_unlocked' => 'Користувач розблокований',
    'log_user_pwd_changed' => 'Пароль користувача змінено',
    'settings_default_session_expiration_time' => 'Час закінчення сесії за замовчуванням',
    'settings_duo' => 'Увімкнути двофакторну автентифікацію DUO Security',
    'settings_duo_tip' => 'Хмарна двофакторна автентифікація Duo Security від duo.com. Одноразові коди входу через SMS, голосовий дзвінок або мобільний додаток. Для використання цієї функції потрібен обліковий запис у Duo. Двофакторний вхід через Duo буде вимагатися для всіх користувачів, крім адміністраторів, коли функція активована.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Облікові дані зі сторінки адміністрування Duo Security для вашого облікового запису повинні бути введені тут. Налаштування будуть збережені у файлі sk.php лише після натискання кнопки збереження.',
    'admin_duo_intro' => 'Введіть або згенеруйте секрет Duo Security',
    'edit' => 'Редагувати',
    'user_info_locked' => 'Користувач наразі заблокований.',
    'user_info_unlock_question' => 'Розблокувати обліковий запис?',
    'user_info_lock_question' => 'Заблокувати обліковий запис?',
    'user_info_delete_question' => 'Видалити обліковий запис?',
    'user_info_active' => 'Користувач наразі активний.',
    'refresh' => 'Оновити',
    'loading' => 'Завантаження',
    'searching' => 'Пошук ...',
    'list_items_with_tag' => 'Перелічити елементи з цим тегом',
    'no_item_to_display' => 'Немає елементів для відображення',
    'opening_folder' => 'Читання папки ...',
    'suggestion_notify_subject' => 'Подано нову пропозицію елемента пароля',
    'suggestion_notify_body' => 'Користувач подав пропозицію елемента пароля до менеджера паролів. Ви повинні прийняти подання, перш ніж його зможуть використовувати інші користувачі.<br>Інформація:<br>- Мітка: #tp_label#<br>- Папка: #tp_folder#<br>- Користувач: #tp_user#<br><br>Цей лист надіслано всім менеджерам.',
    'error_unknown' => 'Сталася несподівана помилка!',
    'no_edit' => 'Запис без редагування',
    'role_cannot_edit_item' => 'Не можна редагувати елементи',
    'no_delete' => 'Запис без видалення',
    'role_cannot_delete_item' => 'Не можна видаляти елементи',
    'my_profile' => 'Мій профіль',
    'starting' => 'Запуск...',
    'total_number_of_items' => 'Загальна кількість елементів',
    'finalizing' => 'Завершення',
    'treating_items' => 'Обробка елементів',
    'number_of_items_treated' => 'Кількість оброблених елементів',
    'error_sent_back' => 'Виникла наступна помилка',
    'full' => 'Повний',
    'sequential' => 'Послідовний',
    'tree_load_strategy' => 'Стратегія завантаження дерева',
    'syslog_enable' => 'Записувати помилки на сервер <i>syslog</i>',
    'syslog_host' => 'Ім&apos;я або IP-адреса сервера Syslog',
    'syslog_port' => 'Порт Syslog (за замовчуванням 514)',
    'error_bad_credentials' => 'Облікові дані для входу не відповідають!',
    'settings_ldap_usergroup' => 'Група LDAP для пошуку',
    'settings_ldap_usergroup_tip' => 'Введіть групу LDAP у каталозі, де зберігаються дозволені входи користувачів. Приклад: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Увімкнути зміну пароля на віддаленому сервері (використовуючи ssh-з&apos;єднання)',
    'update_server_password' => 'Оновити пароль сервера',
    'ssh_pwd' => 'Пароль SSH',
    'ssh_user' => 'Користувач SSH',
    'ssh_password_frequency_change_info' => 'Виберіть інтервал між автоматичними оновленнями пароля сервера (вибір 0 відключить автоматичну зміну пароля).<br />Автоматичні оновлення пароля будуть виконуватися лише в тому випадку, якщо системний адміністратор також налаштував функцію запланованого оновлення пароля через cron.',
    'ssh_password_frequency_change' => 'Частота зміни пароля (в місяцях)',
    'ssh_scheduled_change' => 'Запланована зміна',
    'ssh_one_shot_change' => 'Одноразова зміна',
    'server_password_change_enable_tip' => 'Ця настройка додає опцію в елемент пароля для автоматичної зміни пароля користувача на сервері, вказаному в URL. Це вимагає, щоб віддалений UNIX-сервер дозволяв вхід за допомогою імені користувача та пароля через SSH. Автоматичні заплановані зміни пароля можуть виконуватися після додавання <i>/files/script.ssh.php</i> до crontab для запуску один раз на день на веб-сервері менеджера паролів.',
    'settings_ldap_object_class' => 'Клас для пошуку',
    'settings_ldap_object_class_tip' => 'Клас LDAP для пошуку, наприклад, обліковий запис користувача або обліковий запис POSIX',
    'rebuild_config_file' => 'Перебудувати конфігураційний файл',
    'rebuild_config_file_tip' => 'Конфігураційний файл містить системні змінні і використовується, коли ці налаштування потрібні до встановлення з&apos;єднання з базою даних. Перебудова конфігураційного файлу зберігає значення бази даних у файл і може бути виконана в будь-який час. Місце за замовчуванням - ./includes/config/tp.config.php, але файл повинен знаходитися поза каталогом www для безпеки.',
    'error_folder_complexity_lower_than_top_folder' => 'Підпапки повинні мати силу пароля, встановлену на тому ж рівні або вище, ніж у батьківської папки',
    'new_item_email_body' => 'Привіт,<br><br>Це згенерований лист від менеджера паролів Teampass.<br><br>Новий елемент &apos;#label&apos; був створений у Teampass.<br />Ви можете отримати до нього доступ, натиснувши на це <a href="#link#">ПОСИЛАННЯ</a>.<br/><br />З повагою.',
    'failed_logins' => 'Невдалі спроби входу',
    'error_only_numbers_in_folder_name' => 'Назва папки не може бути лише числом. Будь ласка, дайте вашій папці ім&apos;я, яке містить літери.',
    'encrypted_data' => 'Дані зашифровані в базі даних',
    'settings_ldap_port' => 'Порт LDAP',
    'user_profile_agses_card_id' => 'Ваш ідентифікатор картки Agses',
    'ga_flash_qr_and_login' => 'Скануйте цей QR-код за допомогою мобільного пристрою, введіть код двофакторної автентифікації та натисніть кнопку `Enter`.',
    'i_need_to_generate_new_ga_code' => 'Мені потрібен новий QR-код. Будь ласка, надішліть мені тимчасовий ідентифікаційний код електронною поштою.',
    'settings_manager_move_item' => 'Менеджери можуть переміщувати будь-які елементи, які вони можуть переглядати',
    'user_folders_rights' => 'Видимі папки',
    'create_item_without_password' => 'Дозволити створення елемента без визначеного пароля',
    'share_rights_info' => 'Це діалогове вікно дозволяє вам поділитися правами одного користувача з вибраними користувачами.<br>Зверніть увагу, що вибрані користувачі матимуть свої існуючі права скинуті та замінені точно такими ж правами, як у вихідного користувача.',
    'share_rights_source' => 'Вихідний користувач',
    'share_rights_destination' => 'Користувачі призначення',
    'ga_reset_by_user' => 'Користувач може скинути свій 2FA код',
    'ga_reset_by_user_tip' => 'Якщо увімкнено, користувач матиме можливість скинути свій 2FA код за допомогою посилання на сторінці входу. Це може бути корисно, наприклад, якщо він змінив мобільний пристрій. Якщо не увімкнено, користувач повинен буде попросити адміністратора згенерувати новий код.',
    'enable_massive_move_delete' => 'Дозволити користувачеві виконувати масові операції переміщення та видалення',
    'enable_massive_move_delete_tip' => 'Коли увімкнено, ця опція дозволяє користувачеві виконувати масові операції переміщення та/або видалення за один раз. Користувач зможе виконувати це лише для елементів, до яких він має доступ.',
    'mass_operation' => 'Масова операція з елементами',
    'move_items' => 'Перемістити вибрані елементи',
    'delete_items' => 'Видалити вибрані елементи',
    'you_decided_to_move_items' => 'Ви вирішили перемістити елементи',
    'you_decided_to_delete_items' => 'Ви вирішили видалити елементи',
    'suggest_password_change' => 'Запропонувати зміну пароля',
    'otv_is_enabled' => 'Користувач може запропонувати посилання для одноразового перегляду',
    'error_source_and_destination_are_equal' => 'Джерело та призначення не можуть бути однаковими!',
    'sending_anonymous_statistics' => 'Надсилання анонімної статистики',
    'favourites_option_enabled' => 'Опція "Вибране" увімкнена',
    'personalfolders_option_enabled' => 'Опція "Особисті папки" увімкнена',
    'country_statistics' => 'Використання на карті світу',
    'country' => 'Країна',
    'users_statistics' => 'Середня кількість користувачів на інстанцію',
    'items_all' => 'Усі елементи',
    'folders_all' => 'Усі папки',
    'items_shared' => 'Усі спільні елементи (не включаючи особисті)',
    'folders_shared' => 'Усі спільні папки (не включаючи особисті)',
    'items_statistics' => 'Середня кількість елементів на інстанцію',
    'folders_statistics' => 'Середня кількість папок на інстанцію',
    'administrators_number' => 'Кількість користувачів-адміністраторів',
    'administrators_number_statistics' => 'Середня кількість адміністраторів на інстанцію',
    'managers_number' => 'Кількість користувачів-менеджерів',
    'managers_number_statistics' => 'Середня кількість менеджерів на інстанцію',
    'readonly_number_statistics' => 'Середня кількість користувачів з правами лише для читання на інстанцію',
    'readonly_number' => 'Кількість користувачів з правами лише для читання',
    'mysql_version' => 'Версія MySQL',
    'php_version' => 'Версія PHP',
    'teampass_version' => 'Версія Teampass',
    'languages_used' => 'Використовувані мови',
    'languages_statistics' => 'Найбільш використовувана мова',
    'kb_option_enabled' => 'Опція "База знань" увімкнена',
    'suggestion_option_enabled' => 'Опція "Пропозиції" увімкнена',
    'customfields_option_enabled' => 'Опція "Користувацькі поля" увімкнена',
    'api_option_enabled' => 'Опція API увімкнена',
    '2fa_option_enabled' => 'Опція 2FA увімкнена',
    'agses_option_enabled' => 'Опція AGSES увімкнена',
    'duo_option_enabled' => 'Опція DUO Security увімкнена',
    'ldap_option_enabled' => 'Опція LDAP увімкнена',
    'syslog_option_enabled' => 'Опція SYSLOG увімкнена',
    'stricthttps_option_enabled' => 'Опція Strict HTTPS увімкнена',
    'characteristic' => 'Характеристика',
    'current_value' => 'Поточне значення',
    'communication_means' => 'Засоби зв&apos;язку',
    'consider_a_donation' => 'Ви можете розглянути можливість пожертвування',
    'more_information' => 'Більше інформації',
    'feature_request_canal' => 'Для запитів на функції, будь ласка, використовуйте',
    'bug_canal' => 'Для повідомлень про помилки, будь ласка, використовуйте',
    'documentation_canal' => 'Повна документація знаходиться',
    'sending_anonymous_statistics_details' => 'Статистика потрібна для покращення Teampass шляхом вивчення популяції користувачів та використання. Дані, які ви надасте, будуть використовуватися лише внутрішньо для аналізу даних і абсолютно не будуть поширюватися або продаватися третім сторонам.',
    'item_has_change_proposal' => 'Цей елемент має пропозицію змін',
    'check_data_after_reencryption' => 'Будь ласка, перевірте дані. Під час цієї операції була створена нова таблиця <b>Backup</b>, що дозволяє повернутися назад.',
    'revert' => 'Повернути назад?',
    'revert_the_database' => 'Ви вирішили повернути базу даних. Будь ласка, підтвердіть?',
    'bad_psk' => 'Цей особистий Saltkey неправильний!',
    'ldap_test_config' => 'Перевірити поточну конфігурацію',
    'ldap_test_username' => 'Ім&apos;я користувача для тестування',
    'ldap_test_username_pwd' => 'Пароль користувача',
    'feature_support_canal' => 'Для підтримки та допомоги, будь ласка, використовуйте',
    'category' => 'Категорія',
    'text' => 'Текст',
    'type' => 'Тип',
    'data_is_masked' => 'Дані приховані',
    'at_export' => 'Експорт',
    'settings_ldap_allowed_usergroup' => 'Дозволена група користувачів LDAP',
    'settings_ldap_allowed_usergroup_tip' => 'Вкажіть групу, якій дозволено підключатися до Teampass. Залиште порожнім, якщо не очікується жодних обмежень щодо членства в групі.',
    'error_security_level_not_reached' => 'Очікуваний рівень безпеки не досягнуто!',
    'personal_saltkey_security_level' => 'Мінімальний рівень безпеки особистого Saltkey',
    'settings_disable_forgot_password_link' => 'Приховати посилання на відновлення пароля на головній сторінці',
    'newly_created_user_is_administrated_by' => 'Новостворений користувач адмініструється',
    'settings_ldap_and_local_authentication' => 'Локальні та LDAP користувачі',
    'settings_ldap_and_local_authentication_tip' => 'Увімкніть цю опцію, щоб дозволити автентифікацію як користувачів LDAP, так і локальних користувачів Teampass.',
    'enable_http_request_login' => 'Автоматичний вхід за допомогою облікових даних заголовка HTTP',
    'duration_login_attempt' => 'Секунди до автоматичного входу:',
    'newly_created_user_role' => 'Новостворений користувач має роль',
    'email_debug_level' => 'Виберіть рівень налагодження',
    'email_debug_client' => 'Команди клієнта',
    'email_debug_server' => 'Команди клієнта та відповіді сервера',
    'email_debug_connection' => 'Команди клієнта, відповіді сервера та статус з&apos;єднання',
    'email_debug_low_level' => 'Вивід даних низького рівня, всі повідомлення',
    'email_debug_level_usage' => 'Це налаштування має бути встановлено на None. Використовується лише для налагодження електронної пошти під час тестування. Коли увімкнено, це дозволить показати вивід команд електронної пошти.',
    'email_body_temporary_login_password' => 'Привіт,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Адміністратор змінив ваш пароль для входу в Teampass. Наступного разу, коли ви підключитеся до Teampass, будь ласка, використовуйте наступний:<br><br><b>#enc_code#</b><br><br><br>З повагою',
    'your_new_password' => 'Ваш новий пароль',
    'user_specific_right' => 'Специфічне право користувача',
    'icon' => 'Іконка',
    'icon_on_selection' => 'Іконка при виборі',
    'fontawesome_icon_tip' => 'Ви можете вказати код іконки Font Awesome, вибраної з безплатний і твердих іконок. Залиште порожнім для іконки за замовчуванням.',
    'settings_api_token_duration' => 'Термін дії JWT токена (в секундах)',
    'settings_api_token_duration_tip' => 'Час, протягом якого згенерований JWT токен є дійсним. Після цього часу потрібно надіслати запит на авторизацію до API.',
    'show_encryption_code_to_admin' => 'Це зашифрований код, який користувачеві потрібно буде ввести під час цього входу. Ви попросили побачити його, будь ласка, скопіюйте його та поділіться безпечним способом. Код',
    'previous_password' => 'Попередній пароль, використаний для підключення до Teampass',
    'generate_new_otp' => 'Згенерувати новий OTP',
    'generate_new_otp_informations' => 'Ця операція полягає у створенні з нуля всіх ключів для вибраного користувача. Як наслідок, користувач повинен буде надати новий згенерований OTP при наступному вході.',
    'html' => 'html',
    'execution_time' => 'Час виконання',
    'maximum_number_of_items_to_treat' => 'Максимальна кількість елементів для обробки за один цикл',
    'maximum_number_of_items_to_treat_tip' => 'Щоб забезпечити завершення скрипта без тайм-ауту, можна визначити персональне значення.',
    'maximum_time_script_allowed_to_run' => 'Тривалість у секундах, дозволена для виконання скрипта у фоновому режимі',
    'maximum_time_script_allowed_to_run_tip' => 'За замовчуванням PHP скрипт не може виконуватися більше часу, визначеного параметром max_execution_time у файлі php.ini. Мета тут - визначити більш високе значення, щоб забезпечити повне виконання скрипта.',
    'refresh_data_every_on_screen' => 'Період оновлення екрану (в секундах)',
    'refresh_data_every_on_screen_tip' => 'Під час перегляду завдань це дозволяє отримати оновлений список.',
    'refreshed' => 'Оновлено',
    'process_details' => 'Деталі процесу',
    'created_at' => 'Створено о',
    'updated_at' => 'Оновлено о',
    'finished_at' => 'Завершено о',
    'tasks_manager' => 'Менеджер завдань',
    'tasks' => 'Завдання',
    'task_in_progress_user_not_active' => 'Завдання в процесі - Користувач не активний',
    'enable_tasks_manager' => 'Увімкнути фонові завдання з менеджером cron',
    'enable_tasks_manager_tip' => 'Цю опцію слід увімкнути, якщо ви помітили, що деякі завдання займають багато часу. Це дозволяє обробляти ці завдання за допомогою фонової роботи, виконуваної менеджером cron сервера. Дивіться документацію для отримання додаткової інформації.',
    'sync_new_ldap_password' => 'Синхронізувати новий пароль',
    'error_new_ldap_password_detected' => 'Схоже, ваш пароль змінився, і Teampass вимагає його для шифрування вашого головного приватного ключа.',
    'settings_ldap_tls_certifacte_check' => 'Перевірка сертифіката для LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Вказує стратегію перевірки сертифіката. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Детальніше</a>.',
    'user_keys_management' => 'Управління ключами користувачів',
    'sending_emails' => 'Надсилання електронних листів',
    'tasks_information' => 'Завдання покладається на спеціальну роботу cron. Для цього потрібно додати новий запис у ваш crontab для запуску планувальника Teampass кожну хвилину.<br>Наступний запис для додавання:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Примітка: будь ласка, адаптуйте шлях до php bin (у більшості випадків його можна замінити на <code>php</code>).',
    'bad_duo_mfa' => 'Неправильний код DUO',
    'creation_date' => 'Дата створення',
    'never' => 'Ніколи',
    'loading_main_page' => 'Завантаження головної сторінки ...',
    'link' => 'Посилання',
    'error_not_allowed_to_authenticate' => 'Вам не дозволено аутентифікуватися',
    'enable_tasks_log' => 'Увімкнути журнал завдань cron',
    'enable_tasks_log_tip' => 'Дозволяє вести журнал усіх завдань, виконаних завданням cron, у таблиці <i>processes_log</i>. Може бути корисним для перевірки подій.',
    'items_and_folders_statistics' => 'Статистика елементів і папок',
    'item_copying' => 'Елемент копіюється',
    'upgrade_requested' => 'База даних Teampass не оновлена.',
    'upgrade_requested_more' => 'Виявлено деякі невідповідності між файлами та конфігурацією. Ваш адміністратор повинен виконати процес оновлення перед тим, як ви продовжите.',
    'settings_ldap_group_object_filter' => 'Фільтр об&apos;єктів групи LDAP',
    'settings_ldap_group_object_filter_tip' => '&apos;Фільтр LDAP для використання для пошуку об&apos;єкта групи. Наприклад: (objectClass=group1)(objectClass=group2)&apos;',
    'settings_ad_users_with_ad_groups' => 'Ролі користувачів AD, зіставлені з їхніми групами AD',
    'settings_ad_users_with_ad_groups_tip' => 'Дозволяє зіставити ролі користувачів AD з їхніми групами AD. Ці ролі будуть додані до тих, що визначені в їхньому профілі.',
    'settings_ad_user_auto_creation' => 'Автоматичне створення користувача AD',
    'settings_ad_user_auto_creation_tip' => 'Дозволяє автоматично створити користувача AD у Teampass, коли він вперше входить у систему. Зверніть увагу, що якщо увімкнено опцію зіставлення ролей користувачів AD з їхніми групами AD, то він отримає ролі, зіставлені з його групами AD.',
    'settings_ldap_guid_attibute' => 'Атрибут GUID LDAP',
    'settings_ldap_guid_attibute_tip' => '&apos;Атрибут LDAP для використання для ідентифікації GUID об&apos;єкта. Наприклад: objectGUID, objectSid, GUID, gidNumber, ...&apos;',
    'ad_group' => 'AD група',
    'mapped_with_role' => 'Відповідає ролі',
    'ad_groupe_and_roles_mapping' => 'Відповідність AD групи та ролей',
    'select_adgroup_mapping' => 'Виберіть роль для відповідності з поточною AD групою',
    'enable_backlog_mail' => 'Увімкнути надсилання електронних листів із заборгованістю',
    'provide_label' => 'Вкажіть мітку',
    'uploading' => 'Відвантаження...',
    'keys_encryption_not_ready' => 'Повідомляємо, що ваші ключі паролів наразі створюються. Будь ласка, зачекайте кілька хвилин.',
    'account_not_ready' => 'Обліковий запис у процесі створення',
    'add_new_job' => 'Додати нове завдання',
    'tasks_cron_not_running' => 'Завдання cron не налаштовано. Будь ласка, відредагуйте crontab з вашим користувачем сервера (зазвичай www-data) за допомогою команди <code>crontab -u www-data -e</code>.<br>Або натисніть кнопку, щоб спробувати створити його автоматично.',
    'tasks_cron_running' => 'Завдання cron налаштовано правильно',
    'currently_using_version' => 'Поточна завантажена версія',
    'git_commit_value' => 'Значення коміту Git',
    'generate_new_keys' => 'Згенерувати нові ключі',
    'generate_new_keys_info' => 'Продовжуючи, ви згенеруєте нові ключі шифрування для всіх об&apos;єктів, до яких ви маєте доступ. Це слід робити лише у випадку, якщо у вас не відображається пароль.',
    'generate_new_keys_end' => 'Процес триває у фоновому режимі і може зайняти кілька хвилин. Ви можете закрити це вікно.',
    'confirm_password' => 'Нам потрібно, щоб ви підтвердили свій пароль',
    'no_code_is_requested' => 'Код не запитується.',
    'user_encryption_ongoing' => 'Обліковий запис наразі шифрується. Ваш запит не може продовжуватися. Будь ласка, зачекайте, поки це завершиться.',
    'teampass_information' => 'Інформація Teampass',
    'show_password' => 'Показати пароль',
    'new_user_info_by_mail' => 'Новий користувач отримає електронний лист з його обліковими даними',
    'login_credentials' => 'Облікові дані для входу',
    'email_body_user_config_1' => 'Привіт #lastname#,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Наступні облікові дані очікуються наступного разу при використанні Teampass:<ul><li>логін: #login#</li><li>Пароль: #password#</li><li>Код шифрування: #code#</li></ul><br><br><br>З повагою',
    'email_body_user_config_3' => 'Привіт #lastname#,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Наступний пароль очікується наступного разу при використанні Teampass:<br><br><b>#password#</b><br><br><br>З повагою',
    'email_body_user_config_4' => 'Привіт #lastname#,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Ваш обліковий запис Teampass повністю готовий.<br><br>З повагою',
    'email_body_user_config_5' => 'Привіт #lastname#,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Наступний код очікується наступного разу при використанні Teampass:<br><br><b>#code#</b><br><br><br>З повагою',
    'email_body_user_config_6' => 'Привіт #lastname#,<br><br>Це згенерований електронний лист від менеджера паролів Teampass.<br><br>Наступні облікові дані очікуються наступного разу при використанні Teampass:<ul><li>логін: #login#</li><li>Пароль: #password#</li></ul><br><br><br>З повагою',
    'error_data_not_valid' => 'Дані недійсні',
    'mfa_enabled' => 'MFA увімкнено',
    'mfa_disabled_for_user' => 'MFA відключено для користувача',
    'users_personal_folder' => 'Особиста папка користувачів',
    'maintenance_operations' => 'Операції з обслуговування',
    'maintenance_operations_tip' => 'Вибрані операції з обслуговування бази даних Teampass.',
    'purge_temporary_files' => 'Очищення тимчасових файлів',
    'task_scheduling' => 'Планування завдань',
    'parameter' => 'Параметр',
    'frequency' => 'Частота',
    'in_minutes' => 'в хвилинах',
    'hourly' => 'Щогодини',
    'daily' => 'Щодня',
    'clean_orphan_objects' => 'Очищення сирітських об&apos;єктів',
    'run_once' => 'Запустити один раз',
    'run_weekday' => 'Запустити в будній день',
    'monday' => 'Понеділок',
    'tuesday' => 'Вівторок',
    'wednesday' => 'Середа',
    'thursday' => 'Четвер',
    'friday' => 'П&apos;ятниця',
    'saturday' => 'Субота',
    'sunday' => 'Неділя',
    'monthly' => 'Щомісяця',
    'day_of_month' => 'День місяця',
    'day' => 'День',
    'reset' => 'Скинути',
    'error_while_creating_file' => 'Помилка при створенні файлу',
    'new_keys_generated' => 'Створено нові ключі',
    'user_creation' => 'Створення користувача',
    'user_deletion' => 'Видалення користувача',
    'maximum_session_expiration_time' => 'Максимальний час закінчення сесії',
    'maximum_session_expiration_time_tip' => 'Максимальний час у хвилинах, на який користувач може продовжити сесію',
    'index_session_duration_too_long' => 'Тривалість сесії занадто довга',
    'extend_session_duration_by' => 'Продовжити тривалість сесії на',
    'settings_ldap_user_dn_attribute' => 'Відмінне ім&apos;я користувача',
    'settings_ldap_user_dn_attribute_tip' => 'Мітка атрибута для відмінного імені користувача (DN) в AD.<br>Приклад: Для openLDAP: dn. Для Active Directory: distinguishedname.',
    'open_tasks_settings' => 'Налаштування відкритих завдань',
    'maximum' => 'максимальний',
    'updated' => 'Оновлено',
    'number_of_days' => 'Кількість днів',
    'number_of_times' => 'Кількість разів',
    'sharekey_not_ready' => 'Ключ спільного доступу ще не згенеровано ... всі дані елемента можуть бути не готові ... будь ласка, спробуйте пізніше',
    'item_action_not_yet_possible' => 'Дія на цьому елементі поки що неможлива',
    'open' => 'Відкрити',
    'reload_user_cache_table' => 'Перезавантажити таблицю кешу користувачів',
    'send_email_to_user' => 'Надіслати електронний лист користувачу',
    'items_management' => 'Управління елементами',
    'previously_used_passwords' => 'Раніше використані паролі',
    'next_passwords_were_valid_until_date' => 'Наступні паролі були дійсні до дати',
    'feature_disabled_by_administrator' => 'Функція відключена адміністратором',
    'shared_globaly' => 'Спільний доступ глобально',
    'settings_otv_subdomain' => 'Назва піддомену OTV',
    'settings_otv_subdomain_tip' => 'Присвячений піддомен для одноразових посилань. Вважайте вашу основну URL-адресу Teampass ізольованою від інтернету, цей піддомен може бути доступний для всіх, щоб поділитися цим елементом з кимось за межами вашої організації. З точки зору безпеки це набагато безпечніше з такою механікою. Примітка: Це вимагатиме наявності DNS-запису для цього піддомену, що вказує на ваш сервер Teampass.',
    'existing_valid_otv_links' => 'Дійсні посилання OTV',
    'started' => 'Розпочато',
    'recovery_keys_not_downloaded' => 'Ключі відновлення не завантажені',
    'no_recovery_keys' => 'У мене немає ключів відновлення. Це очистить всі паролі з моїх особистих елементів.',
    'provide_recovery_keys' => 'Надати ваші ключі відновлення',
    'public_key' => 'Публічний ключ',
    'private_key' => 'Приватний ключ',
    'download_recovery_keys' => 'Завантажити ваші ключі відновлення',
    'download_recovery_keys_confirmation' => 'Ви збираєтеся завантажити ваші ключі відновлення. Будь ласка, зберігайте їх у безпечному місці, оскільки вони повинні бути обов&apos;язковими у разі катастрофи.',
    'recovery_keys_download_date' => 'Дата завантаження ключів відновлення',
    'keys_not_recovered' => 'Публічні та приватні ключі не збережені',
    'keys_not_recovered_explanation' => 'Щоб запобігти втраті будь-яких паролів, ви повинні безпечно зберігати ваші особисті ключі Teampass',
    'get_your_recovery_keys' => 'Отримати ваші ключі відновлення',
    'keys_management' => 'Управління ключами',
    'please_confirm_task_to_be_run' => 'Будь ласка, підтвердіть завдання, яке потрібно виконати',
    'user_keys_downloaded' => 'Ключі користувача завантажені',
    'mfa_code_send_by_email' => 'Код MFA надіслано електронною поштою',
    'otp' => 'OTP',
    'otp_code' => 'Код OTP',
    'enabled_otp_for_item' => 'Увімкнути код OTP',
    'at_otp_status' => 'Статус OTP',
    'phone_number' => 'Відповідний номер телефону (необов&apos;язково)',
    'otp_secret' => 'Секретний ключ OTP',
    'settings_ldap_group_objectclasses_attibute' => 'Атрибут AD Group ObjectClasses',
    'settings_ldap_group_objectclasses_attibute_tip' => 'ObjectClasses для використання при пошуку груп. Кілька ObjectClasses розділяються комою (,). Приклад: groupOfNames,group або top,posixGroup',
    'display_warning_icons' => 'Відображати іконки попередження',
    'password_length_by_default' => 'Довжина пароля за замовчуванням',
    'progress' => 'Прогрес',
    'tasks_log_retention_delay_in_days' => 'Затримка збереження журналу завдань (у днях)',
    'tasks_log_table_size' => 'Розмір таблиці журналу завдань',
    'error_otp_secret' => 'Неможливо декодувати секрет OTP, чи правильний секрет?',
    'users_api_access_info' => 'Користувачі можуть отримати доступ до API з тими ж правами доступу, що й у Teampass.',
    'error_folder_not_allowed_for_this_user' => 'Папка не дозволена для цього користувача',
    'allowed_to_create' => 'Дозволено створювати',
    'allowed_to_read' => 'Дозволено читати',
    'allowed_to_update' => 'Дозволено оновлювати',
    'allowed_to_delete' => 'Дозволено видаляти',
    'folder_created' => 'Папка створена',
    'login_with_sso' => 'Вхід за допомогою SSO',
    'server_connected_to_internet' => 'Сервер підключений до інтернету',
    'server_not_connected_to_internet' => 'Сервер не підключений до інтернету',
    'server_not_connected_to_internet_tip' => 'Це може призвести до неправильної роботи кількох функцій, особливо MFA',
    'tools' => 'Інструменти',
    'user_config_not_compliant' => 'Конфігурація користувача не відповідає вимогам',
    'fix_personal_items_empty' => 'Виправити порожні особисті елементи',
    'fix_personal_items_empty_tip' => 'Цей інструмент дозволяє виправити проблему, коли особисті елементи порожні після оновлення Teampass. Потрібно відновити копію таблиці teampass_items з версії Teampass 2. Таблиця повинна називатися teampass_items_v2.',
    'table_not_exists' => 'Очікувана таблиця не існує. Будь ласка, відновіть її з резервної копії.',
    'tools_usage_warning' => 'Використання інструментів може мати прямий вплив на базу даних. Будьте обережні. Завжди робіть резервну копію перед використанням і визначайте період обслуговування.',
    'select_user' => 'Вибрати користувача',
    'show_item_data' => 'Показати дані елемента у списку елементів',
    'show_item_data_tip' => 'Дозволяє відображати додаткову інформацію у списку елементів (ім&apos;я користувача, електронна пошта та URL). Це може бути корисно для швидкого перегляду вмісту елемента.',
    'items_page_split_view_mode' => 'Показати деталі елемента у режимі розділеного перегляду сторінки',
    'replace_tenant_id' => 'Адаптувати URL, але залишити {tenant-id} як є. Він буде замінений в реальному часі на ID орендаря.',
    'user_not_allowed_to_auth_to_teampass_app' => 'Користувачеві не дозволено автентифікуватися за допомогою додатку Teampass',
    'user_is_not_auth_with_oauth2' => 'Користувач не повинен автентифікуватися за допомогою Entra/Azure AD',
    'highlight_favorites' => 'Виділити обрані',
    'highlight_favorites_tip' => 'Порада щодо виділення обраних',
    'limited_search_default' => 'Обмежений пошук вибрано за замовчуванням',
    'limited_search_default_tip' => 'Порада щодо обмеженого пошуку за замовчуванням',
    'highlight_selected_tip' => 'Порада щодо виділення вибраного',
    'encryptClientServer' => 'Шифрувати обмін даними між клієнтом і сервером',
    'encryptClientServer_tip' => 'Коли увімкнено, клієнт шифрує дані перед відправкою на сервер. Сервер зберігає лише зашифровані дані. Це можна вимкнути.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL для отримання даних користувача',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL для отримання даних користувача. Використовується для отримання даних користувача після автентифікації.',
    'duo_redirect_uri' => 'Перенаправлення до Duo Prompt',
    'number_users_build_cache_tree' => 'Кількість користувачів для обробки завдання build_cache_tree під час кожного запуску планувальника.',
    'number_users_build_cache_tree_tip' => 'Порада щодо кількості користувачів для обробки завдання build_cache_tree під час кожного запуску планувальника.',
    'user_password_expired' => 'Термін дії вашого пароля закінчився. Будь ласка, змініть його.',
    'user_password_policy_tip' => 'Th
e new password must:<br/> - Be different from the previous one<br/> - Contain at least 10 characters<br/> - Contain at least one uppercase letter and one lowercase letter<br/> - Contain at least one number or special character<br/> - Not contain your name, first name, username, or email.',
    'bruteforce_unlock_at' => 'Account unlocked at (anti bruteforce): ',
    'bruteforce_reset_account' => 'Reset anti bruteforce of user',
    'bruteforce_reset_mail_subject' => 'TEAMPASS - Your account is disabled',
    'bruteforce_reset_mail_body' => 'Hello #name#,<br/><br/>Your teampass account has been locked due to a large number of authentication failures.<br/><br/>You can unblock it by clicking on this link <a href="#reset_url#" target="_blank">#reset_url#</a><br/><br/>Automatic unlock: #unlock_at#',
    'disable_user_edit_profile' => 'Users can no longer edit their profile',
    'disable_user_edit_language' => 'Users can no longer change language',
    'disable_user_edit_timezone' => 'Users can no longer change time zones',
    'disable_user_edit_tree_load_strategy' => 'Users can no longer change tree loading strategy',
    'bruteforce_wait' => 'Too many failed attempts, your account is blocked until: ',
    'disable_drag_drop' => 'Disable item drag and drop',

);
