<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This file is part of the TeamPass project.
 * 
 * TeamPass is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * TeamPass is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * 
 * Certain components of this file may be under different licenses. For
 * details, see the `licenses` directory or individual file headers.
 * ---
 * @file      catalan.php
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2024 Teampass.net
 * @license   GPL-3.0
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Mostra el codi de xifratge de l&apos;usuari',
    'email_body_new_user' => 'Hola,<br><br>Aquest és un correu electrònic generat pel gestor de contrasenyes de Teampass.<br><br>Un administrador us ha creat un compte d&apos;usuari a Teampass. La propera vegada que us connecteu a Teampass, utilitzeu les següents credencials:<ul><li>inici de sessió: #login#</li><li>Contrasenya: #contrasenya#</li><li>Codi de xifratge: #code#< /li></ul><br><br><br>Salut',
    'user_password' => 'Contrasenya',
    'user_temporary_encryption_code' => 'Codi de xifratge',
    'no_email_set' => 'No té correu electrònic',
    'send_user_password_by_email' => 'Decidiu si la contrasenya d&apos;inici de sessió de l&apos;usuari s&apos;ha d&apos;enviar per correu electrònic.<br>En cas afirmatiu, premeu el botó Envia.<br><br>En cas contrari, utilitzeu el botó Copia al porta-retalls per enviar-la a l&apos;usuari per un altre mitjà.<br>Es converteix en la seva responsabilitat com a Administrador de proporcionar a l&apos;usuari la contrasenya de manera segura.',
    'admin_change_user_encryption_code_info' => 'Aquesta operació restablirà el codi de xifratge d&apos;aquest usuari.',
    'send_by_email' => 'Envia per correu electrònic',
    'filters' => 'Filtres',
    'show_user_password' => 'Mostra la contrasenya de l&apos;usuari',
    'open_website' => 'Obrir lloc web',
    'mfa_for_roles' => 'Es demana MFA per als usuaris de Rols',
    'mfa_for_roles_tip' => 'Per defecte, un cop seleccionat un mètode MFA, s&apos;habilita per a tots els usuaris. No obstant això, podeu seleccionar els rols per als quals s&apos;espera.<br>ENCARA NO S&apos;HA IMPLEMENTAT',
    'at_least_one_administrator_is_requested' => 'Es demana almenys un administrador',
    'bad_code' => 'Codi erroni',
    'generating_keys' => 'Generant claus',
    'this_may_take_time' => 'Això pot trigar uns minuts',
    'disable_enable' => 'Deshabilita / Habilita',
    'user_disable_status' => 'Marqueu la casella per desactivar-la o deixeu-la buida per activar-la',
    'help_for_launching_items_encryption' => 'Hem de generar la base de dades de claus per al vostre compte. Proporcioneu el vostre codi de xifratge.',
    'managed_through_ad' => 'Gestionat a través de AD',
    'new_ldap_user_info' => 'Completeu la definició per a l&apos;usuari',
    'email_body_user_added_from_ldap_encryption_code' => 'Hola,<br><br>Aquest és un correu electrònic generat pel gestor de contrasenyes de Teampass.<br><br>Ara teniu un compte a Teampass. Podeu utilitzar les vostres credencials LDAP per iniciar sessió.<br><br>En iniciar sessió per primera vegada, s&apos;esperarà un codi d&apos;encriptació de la vostra part, feu servir:<br><br><b>#enc_code#</b><br> <br><br>Salut',
    'settings_ldap_user_object_filter' => 'Filtre d&apos;objectes d&apos;usuari',
    'settings_ldap_user_object_filter_tip' => 'El filtre que cal utilitzar quan cerqueu objectes d&apos;usuari. Diversos filtres estan separats per una coma (,). Exemple: (objectCategory = persona), (samacCountName =*)',
    'settings_ldap_additional_user_dn_tip' => 'Aquest valor s&apos;utilitza a més del DN base en cercar i carregar usuaris. Si no es proporciona cap valor, la cerca del subarbre començarà des del DN base. Exemples: ou=Usuaris ; cn=usuaris',
    'settings_ldap_additional_user_dn' => 'DN d&apos;usuari addicional',
    'ldap_user_has_changed_his_password' => 'La vostra contrasenya d&apos;autenticació s&apos;ha canviat al vostre LDAP des que vau iniciar sessió per darrera vegada a Teampass. Hem d&apos;adaptar la vostra clau de xifratge. Proporcioneu la vostra contrasenya anterior i l&apos;actual.',
    'provide_your_previous_password' => 'La vostra contrasenya anterior',
    'admin_change_user_password_info' => 'Aquesta operació restablirà la contrasenya actual de l&apos;usuari seleccionada.',
    'sending_email_message' => 'Enviant correu a l&apos;usuari, espera si us plau',
    'change_your_password_info_message' => 'Proporcioneu la vostra nova contrasenya d&apos;autenticació i confirmeu-la.',
    'user_has_to_change_password_info' => 'S&apos;ha generat la contrasenya actual usada. S’espera que el canvieu amb finalitat de seguretat.',
    'ready_to_go' => 'Llest',
    'passwords_not_the_same' => 'Les contrasenyes proporcionades no son iguals',
    'inititialization' => 'Inicialització',
    'bad_password' => 'Contrasenya incorrecta',
    'perform_checks' => 'Realitzar comprovacions',
    'email_body_temporary_encryption_code' => 'Hola,<br><br>Aquest és un correu electrònic generat pel gestor de contrasenyes de Teampass.<br><br>S&apos;han realitzat alguns canvis al vostre compte que requereixen un nou xifratge dels elements per a la seguretat de les dades. La propera vegada que us connecteu a Teampass, utilitzeu el següent codi:<br><br><b>#enc_code#</b><br><br><br>Salut',
    'temporary_encryption_code' => 'El vostre codi de xifratge temporal',
    'renecyption_expected' => 'Hem de renunciar a les vostres claus per adaptar-se als privilegis corresponents al vostre compte i drets.',
    'error_no_user_in_ad' => 'L&apos;usuari no es troba a AD',
    'error_ad_user_expired' => 'L’usuari està caducat!',
    'error' => 'Error capturat',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'L’opció hosts és una sèrie d’adreces IP o noms d’amfitrió situats a la vostra xarxa que serveixen un directori LDAP (SEPRATE per una coma). Inseriu tants servidors o tan poc com voldríeu dependre del vostre bosc (amb el mínim d’un, per descomptat).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'El nom distingit root (DN) a utilitzar en executar consultes amb el servidor de directori. Exemples: o = exemple, c = com; cn = usuaris, dc = ad, dc = exemple, dc = com',
    'username' => 'Nom d&apos;usuari',
    'settings_ldap_username_tip' => 'El nom distingit de l&apos;usuari que l&apos;utilitzarà l&apos;aplicació quan es connecta al servidor de directori. Exemples: cn = administrador, cn = usuaris, dc = AD, dc = exemple, dc = com; cn = usuari, dc = domini, dc = nom',
    'settings_ldap_password_tip' => 'La contrasenya de l&apos;usuari especificat anteriorment.',
    'settings_ldap_port_tip' => 'L&apos;opció de port s&apos;utilitza per autenticar i vincular-se al vostre servidor LDAP. Els ports predeterminats ja s&apos;utilitzen per a connexions no SSL i SSL (389 i 636). Inseriu un port només si el vostre servidor LDAP utilitza un port únic.',
    'undefined' => 'Indefinida',
    'error_cannot_open_file' => 'No es pot obrir el fitxer',
    'provide_current_psk_and_click_launch' => 'Quan estigui a punt, feu clic al botó Inici',
    'start' => 'Comença ',
    'data_inconsistency' => 'Inconsistència de dades. Torneu a carregar la pàgina.',
    'one_time_code_expected' => 'Codi únic previst',
    'data_are_missing' => 'Falten les dades esperades',
    'one_time_code' => 'Codi únic',
    'provide_personal_one_time_code' => 'Proporcioneu el codi únic que heu rebut per correu electrònic',
    'change_authentification_type_to_ldap' => 'Canvieu el tipus d&apos;autenticació a LDAP',
    'change_authentification_type_to_local' => 'Canvieu el tipus d&apos;autenticació a la base de dades local TeamPass',
    'ldap_user_password_is_used_for_authentication' => 'La contrasenya d&apos;usuari en LDAP s&apos;utilitza per a l&apos;autenticació',
    'local_user_password_is_used_for_authentication' => 'La contrasenya d&apos;usuari a TeamPass s&apos;utilitza per a l&apos;autenticació',
    'provide_your_current_password' => 'Proporcioneu la vostra contrasenya actual',
    'current_password' => 'Contrasenya actual',
    'password_is_not_correct' => 'Aquesta contrasenya no és correcta',
    'ldap_password_change_warning' => 'La vostra contrasenya d’inici de sessió ha canviat des de la darrera connexió. Es demana que torni a xifrar totes les tecles mitjançant aquesta nova contrasenya. Per a aquesta operació, empleneu el següent camp amb la vostra contrasenya LDAP anterior. L’operació pot trigar diversos minuts.',
    'personal_items' => 'Elements personals',
    'logout_on_going' => 'Ara es tancarà la sessió. Utilitzeu la vostra nova contrasenya per estar connectat a partir d’ara.',
    'fill_in_fields_and_hit_launch' => 'Proporcioneu les dades esperades i premeu el botó de llançament',
    'please_select_a_folder' => 'Seleccioneu una carpeta',
    'user_must_have_login_and_email' => 'L&apos;usuari ha de tenir un inici de sessió i un correu electrònic',
    'user_has_this_role_in_teampass' => 'L&apos;usuari té aquest rol a TeamPass',
    'select_role_to_create' => 'Seleccioneu el rol per crear',
    'adding_ldap_role_to_teampass' => 'Podeu decidir crear un rol a TeamPass procedents del vostre Directory Active. Això permetrà associar l&apos;usuari a aquest rol a TeamPass.',
    'add_user_to_role' => 'Afegiu aquest rol a l&apos;usuari a TeamPass',
    'add_user_in_teampass' => 'Afegiu l&apos;usuari a TeamPass',
    'synchronized' => 'Sincronitzat',
    'output' => 'Producció',
    'remove_install_folder' => 'S&apos;ha de suprimir la carpeta d&apos;instal·lació',
    'list_users' => 'Enumereu els usuaris',
    'ldap_synchronization' => 'Sincronització LDAP',
    'in_progress' => 'En progrés',
    'clipboard_password_life_duration' => 'Retard abans que el porta-retalls esborri (en segons)',
    'clipboard_password_life_duration_tip' => 'Permet definir un retard en segons abans, la contrasenya copiada al porta-retalls serà esborrat del porta-retalls del navegador. Configureu a 0 per desactivar.',
    'clipboard_will_be_cleared' => 'La contrasenya es troba ara al porta-retalls. Aviat serà esborrat ...',
    'file_folder_not_accessible' => 'La carpeta de fitxers no és accessible',
    'error_missing_id' => 'Hi ha hagut un error. Falta identificació ...?',
    'error_folder_not_allowed' => 'La carpeta seleccionada no està permesa',
    'all_fields_mandatory' => 'Tots els camps són obligatoris',
    'history_insert_entry' => 'Inseriu a la història',
    'clear_form' => 'Forma clara',
    'info_about_history_insertion' => 'Precaució: aquesta funció us permet inserir manualment un esdeveniment al registre de la història de l&apos;element. Un cop afegit, no serà possible eliminar-lo. Tingueu en compte que el vostre identificador de compte estarà associat a aquesta nova entrada.',
    'select_all' => 'Selecciona tot',
    'unselect_all' => 'Deselecciona tot',
    'no_data_to_display' => 'No hi ha dades per mostrar! Ja no existeix cap carpeta, o bé no teniu accés a cap.',
    'server' => 'Servidor',
    'data_refreshed' => 'Dades actualitzades',
    'loading_image' => 'Imatge de càrrega',
    'compare_with_another_role' => 'Compara amb un altre rol',
    'only_display_folders_to_depth' => 'Només visualitzeu carpetes a la profunditat',
    'propagate_rights_to_descendants' => 'Propagar els drets als descendents',
    'loading_data' => 'Carregant dades',
    'password_overview_delay' => 'Retard per la visió general de la contrasenya',
    'password_overview_delay_tip' => 'Aquesta configuració permet definir el nombre de segons, la contrasenya clara es mostrarà a l&apos;usuari.',
    'select_date_showing_items_expiration' => 'Enumereu els elements caducats a la data',
    'renewal_page_info' => 'Aquesta pàgina permet identificar els elements que actualment caducen o caducen en el període següent.',
    'filename' => 'Nom de l&apos;arxiu',
    'exported_to_file' => 'Exportat al fitxer',
    'operation_progress' => 'L’operació està en curs',
    'exporting_items' => 'Exportació d&apos;elements',
    'select_folders_to_export' => 'Seleccioneu les carpetes per exportar',
    'export_format_type' => 'Seleccioneu el tipus de format d&apos;exportació',
    'export_items' => 'Exportar elements',
    'loading_item' => 'L&apos;element de càrrega',
    'otv_message' => 'Podeu compartir aquest element amb algú sense un compte de Teampass. Una visió única permet al vostre convidat accedir a camps bàsics d’aquest element només una vegada sense ser autenticat a TeamPass. Observeu que aquest enllaç és vàlid fins que s’arribi a una de les configuracions següents. Copieu i compartiu l’enllaç següent.',
    'no_sharekey_found' => 'No es troba cap clau per a aquest fitxer i el vostre compte',
    'otv_link' => 'Enllaç únic de vista',
    'one_time_view' => 'Vista única',
    'move_right_columns_separator' => 'Mou el separador de columnes a la dreta',
    'move_left_columns_separator' => 'Desplaceu les columnes Separator a l&apos;esquerra',
    'form_presents_inconsistencies' => 'El formulari presenta algunes incoherències. Consulteu els camps amb les fronteres vermelles.',
    'download' => 'descarregar',
    'see' => 'Veure',
    'at_anyoneconmodify' => 'Qualsevol pot modificar',
    'disabled' => 'Desactivat',
    'enabled' => 'Activat',
    'confirmation_seems_wrong' => 'La confirmació sembla equivocada, corregiu-la',
    'i_cannot_remember' => 'No puc recordar',
    'i_cannot_remember_info' => 'Aquesta acció no té marxa enrrere. Esborrarà les contrasenyes emmagatzemades dins dels elements personals. Els elements no seran suprimits, sinó només les seves contrasenyes. Si no recordeu la vostra Saltkey personal, és l’única opció.',
    'user_has_psk_info' => 'Hem identificat que teniu alguns elements personals codificats amb una antiga Saltkey personal. Aquest objectiu consisteix a tornar a xifrar-los amb la vostra nova clau privada. Proporcioneu-nos la vostra Saltkey personal.',
    'files' => 'Fitxers',
    'logs' => 'Registres de registres',
    'suggestions' => 'Suggeriments',
    'encryption_keys' => 'Xifratge de claus',
    'clearing_old_sharekeys' => 'Esborrant antics claus compartides',
    'hit_launch_to_start' => 'Feu clic al botó de llançament per començar',
    'password_changed' => 'Actualitzada amb contrasenya',
    'password_already_used' => 'La contrasenya ja s&apos;utilitza',
    'change_login_password' => 'Canvieu la contrasenya d&apos;inici de sessió',
    'current_password_mandatory' => 'La contrasenya actual és obligatòria',
    'objects_encryption_explanation' => 'TeamPass s&apos;ha actualitzat a una nova versió que inclou un nou protocol de xifrat. S’espera de tornar a xifrar els vostres elements personals. Per això, heu de proporcionar la vostra clau de sal personal actual (PSK). Un cop ODNE, feu clic al llançament del botó i espereu fins que el procés arribi al pas final. Això podria trigar diversos minuts en funció del nombre d&apos;objectes.',
    'description_has_changed' => 'La descripció ha canviat',
    'number_of_folders_imported' => 'Nombre de carpetes importades',
    'number_of_items_imported' => 'Nombre d&apos;elements importats',
    'propagate' => 'Propagar',
    'propagate_user_rights' => 'Propagar els drets dels usuaris',
    'register_new_yubiko_key' => 'Registra una nova clau de Yubiko',
    'part_of_groups' => 'Part de grups',
    'previous_value' => 'Valor previ',
    'no_previous_value' => 'Sense valor previ',
    'no_data_selected' => 'No hi ha dades seleccionades',
    'selected_items_to_be_imported' => 'Els elements seleccionats a importar',
    'cannot_open_file' => 'No es pot obrir el fitxer',
    'no_item_found' => 'No s&apos;ha trobat cap element',
    'reading_file' => 'Fitxer de lectura',
    'where_shall_items_be_created' => 'On es crearan els elements',
    'target_folder' => 'Carpeta de destinació',
    'select_file' => 'Seleccioneu l&apos;arxiu',
    'data_type_for_import' => 'Comença per seleccionar el tipus d&apos;origen de dades a importar',
    'get_tips_about_importation' => 'Obteniu consells sobre la importació',
    'import_new_items' => 'Importa nous elements',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'per',
    'request_access' => 'Sol·liciteu l&apos;accés a l&apos;element',
    'request_access_message' => 'Quan sol·liciteu un accés a un element, s’envia un correu electrònic a l’autor. L’autor acceptarà o rebutjarà la sol·licitud afegint-vos a la llista de restriccions d’elements. Confirmeu per enviar la vostra sol·licitud per correu electrònic a l’autor.',
    'request_access_reason' => 'Proporcioneu a l’autor el motiu de la vostra sol·licitud',
    'error_provide_reason' => 'Proporcioneu el motiu pel qual voleu accedir a aquest element',
    'need_access' => 'Necessiteu accés?',
    'item_with_restricted_access' => 'Element amb accés restringit',
    'remaining_emails_to_send' => 'Correus electrònics restants per enviar',
    'mfa_flash' => 'Flash amb el dispositiu mòbil',
    'import' => 'Importar',
    'export' => 'Exportar',
    'offline' => 'Fora de línia',
    'login_attempts_identified_since_last_connection' => 'La vostra atenció és necessària. Almenys un intent d’inici de sessió amb el vostre compte s’ha identificat des de la darrera connexió amb èxit. Comproveu i informeu al vostre administrador local si no sou l’autor.',
    'last_login_attempts' => 'Últims intents d’inici de sessió',
    'see_detail' => 'Vegeu el detall',
    'role_definition' => 'Definició del rol',
    'not_yet_implemented' => 'Encara no implementat',
    '2factors_expected_for_admin' => 'L’administrador requereix que el MFA es registri',
    '2factors_expected_for_admin_tip' => 'De manera predeterminada, un administrador ha d’utilitzar un mètode MFA per registrar-se. Si no està activat, l&apos;administrador no requerirà que es registri fins i tot si MFA està habilitat per a qualsevol altre usuari.',
    'restore_done_now_logout' => 'La restauració de bases de dades s&apos;ha fet. Ara heu de desconnectar per actualitzar les variables de sessió.',
    'backup_and_restore' => 'Còpia de seguretat i restaurar',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Realitzeu una còpia de seguretat',
    'perform_restore' => 'Realitzeu Restore',
    'backup_select' => 'Fitxer de còpia de seguretat',
    'choose_file' => 'Trieu l&apos;arxiu',
    'on_the_fly' => 'Sobre la marxa',
    'scheduled' => 'Programat',
    'caution_on_field_encryption_change' => 'Precaució: tingueu en compte que canviar el tipus de xifratge requerirà analitzar totes les dades existents per canviar el xifrat a la base de dades.',
    'caution_while_deleting_field' => 'Precaució: eliminar aquest camp també suprimirà les dades relacionades en els ítems.',
    'error_could_not_update_the_field' => 'Error: el camp no es pot actualitzar. Realitzeu-ho després de tornar a carregar la pàgina.',
    'caution_while_deleting_category' => 'Precaució: eliminar aquesta carpeta suprimirà tots els seus camps pertanyents i també totes les dades relacionades amb els camps.',
    'your_attention_please' => 'La vostra atenció si us plau',
    'all_fields_are_required' => 'Tots els camps són obligatoris',
    'position' => 'Posició',
    'before' => 'Abans',
    'top' => 'Superior',
    'bottom' => 'Fons',
    'field' => 'Camp',
    'configuration' => 'Configuració',
    'definition' => 'Definició',
    'number_of_modified_attachments' => 'Nombre de fitxers adjunts modificats',
    'files_not_encrypted' => 'Actualment, els fitxers no estan xifrats. Hauríeu de realitzar aquest canvi per motius de seguretat.',
    'files_already_encrypted' => 'Els fitxers ja estan xifrats. No heu de canviar això per motius de seguretat.',
    'action_to_be_performed' => 'Acció a realitzar',
    'last_execution' => 'Última execució',
    'never_performed' => 'Mai realitzat',
    'launch' => 'Llençar',
    'set_of_actions' => 'Conjunt d’accions',
    'uploads' => 'Càrregues',
    'uploads_configuration' => 'Configuració de càrrega',
    'email_configuration' => 'Configuració del correu electrònic',
    'email_configuration_test' => 'Prova de configuració del correu electrònic',
    'send_a_test_email' => 'Envieu un correu electrònic de prova',
    'manage_emails_not_sent' => 'Gestiona els correus electrònics no enviats',
    'email_send_backlog' => '#NB_EMAILS# correus electrònics no centrals',
    'send_waiting_emails' => 'Envia correus electrònics en espera',
    'ip' => 'IP',
    'no_data_defined' => 'No s’han definit dades',
    'adding_new_api_ip' => 'Afegint una nova IP a Whitelist',
    'adding_new_api_key' => 'Afegint una nova clau API',
    'api_configuration' => 'Configuració de l&apos;API',
    'mfa_configuration' => 'Configuració de MFA',
    'yubico_authentication_tip' => 'Visiteu www.yubico.com per obtenir més detalls.',
    'complexity_level_not_reached' => 'No s’arriba al nivell de complexitat',
    'expected_complexity_level' => 'Nivell de complexitat esperat',
    'your_attention_is_required' => 'La vostra atenció és necessària',
    'favorite' => 'Favorit',
    'unfavorite' => 'Desfà Favorit',
    'you_need_to_select_at_least_one_folder' => 'Heu de seleccionar almenys una carpeta',
    'no_value_defined_please_fix' => 'No es defineix cap valor! Si us plau, solucioneu-ho.',
    'apply' => 'Aplica',
    'from' => 'Des de',
    'please_confirm_by_clicking_checkbox' => 'Confirmeu fent clic a la casella de selecció',
    'date_range' => 'Interval de dates',
    'purge' => 'Purga',
    'belong_of_deleted_folder' => 'Pertany a la carpeta suprimida',
    'highlight_selected' => 'Ressalteu seleccionat',
    'number_of_selected_objects' => 'Nombre d&apos;objectes seleccionats',
    'confirm_selection_restore' => 'Confirmeu la restauració dels elements seleccionats.',
    'confirm_selection_delete' => 'Confirmeu la supressió dels elements seleccionats.',
    'refreshing' => 'Refrescant',
    'empty_list' => 'Llista buida',
    'deleted_folders' => 'Carpetes suprimides',
    'deleted_items' => 'Elements suprimits',
    'recycled_bin' => 'Paperera reciclada',
    'database' => 'Base de dades',
    'renewal' => 'Renovació',
    'renewal_delay' => 'Retard de renovació',
    'please_confirm_deletion' => 'Confirmeu la supressió',
    'caution' => 'Cautela',
    'role_not_exist' => 'Aquest rol no existeix!',
    'role_can_edit_any_visible_item' => 'El rol pot editar qualsevol element visible',
    'role_can_edit_any_visible_item_tip' => 'La configuració normal és deixar que aquesta casella de selecció no estigui marcada. De fet, quan es comprovi, permetrà que un usuari sigui part d&apos;aquest rol editar qualsevol element que l&apos;usuari pugui obrir, cosa que comporta un estat no segur. Només s’ha de comprovar un període de temps i una necessitat específic.',
    'edit_allowed' => 'Editar',
    'delete_allowed' => 'Esborra permès',
    'add_allowed' => 'Afegir permès',
    'edit_not_allowed' => 'Edita no permès',
    'delete_not_allowed' => 'Esborra no permès',
    'select_a_role' => 'Seleccioneu un rol',
    'access_rights_for_user' => 'Drets d’accés per a l’usuari',
    'logs_for_user' => 'Registres per a l&apos;usuari',
    'please_confirm' => 'Siusplau confirma',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Feu clic a aquesta casella de selecció, confirma la supressió d’aquest usuari.',
    'fields_with_mandatory_information_are_missing' => 'Falten camps amb informació obligatòria',
    'enable_personal_folder_for_this_user' => 'Activa la funció de la carpeta personal per a aquest usuari',
    'special' => 'Especial',
    'administrator' => 'Administradora',
    'super_manager' => 'Gerent de pas d&apos;equip',
    'manager' => 'Gerent',
    'read_only' => 'Llegeix només',
    'privileges' => 'Privilegis',
    'roles' => 'Rols',
    'user_definition' => 'Definició de l&apos;usuari',
    'no_selection_done' => 'No es fa la selecció',
    'tick_confirmation_box' => 'Marqueu la casella de selecció per confirmar',
    'next_list_to_be_deleted' => 'La següent llista s’eliminarà',
    'delete_folders' => 'Suprimeix les carpetes',
    'submit' => 'Presentar',
    'label' => 'Etiqueta',
    'parent' => 'Pare',
    'password_minimal_complexity_target' => 'Objectiu mínim de complexitat de la contrasenya',
    'access_right_for_roles' => 'Drets d’accés dels rols',
    'create_without_password_minimal_complexity_target' => 'Permet una nova creació d’elements sense contrasenya objectiu mínima de complexitat',
    'edit_without_password_minimal_complexity_target' => 'Permet l&apos;edició de l&apos;element sense contrasenya objectiu de complexitat mínima',
    'add_new_folder' => 'Afegiu una carpeta nova',
    'new' => 'Nou',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Autenticació de diversos factors',
    'google_2fa' => 'Verificació de Google en 2 passos',
    'duo_security' => 'Duo Security',
    'yubico' => 'Autenticador de Yubico',
    'website_canal' => 'Click to open Teampass website',
    '2fa_credential_not_correct' => 'La credencial 2FA no és correcta',
    'no_change_performed' => 'Cap canvi',
    'password_strength' => 'Solidesa de la contrasenya',
    'new_password_required' => 'Cal una nova contrasenya',
    'limited_search' => 'Cerca limitada',
    'empty_psk' => 'Falta Saltkey',
    'currently_no_favorites' => 'Actualment no teniu cap favorit',
    'favorites' => 'Favorits',
    'confirm_item_move' => 'Heu seleccionat "Moving" ... esteu segur?',
    'copy_to_clipboard' => 'Copiar al portarols',
    'please_wait_while_loading' => 'Espereu mentre es carreguen les dades',
    'defect_report' => 'Informe d&apos;error',
    'actions' => 'Accions',
    'no_user' => 'Usuari incorrecte',
    'generate_api_token' => 'Generar un nou token API',
    'upload_feature' => 'Possibilitat de càrrega',
    'profile' => 'Perfil',
    'language' => 'Llenguatge',
    'upload_new_avatar' => 'Seleccioneu el fitxer de la imatge del perfil',
    'settings' => 'Configuració',
    'created_items' => 'Elements creats',
    'modification_performed' => 'Modificació realitzada',
    'items_opened' => 'Elements oberts',
    'passwords_seen' => 'Contrasenyes vistes',
    'nothing_to_save' => 'Res a desar',
    'notification_engaged' => 'Esteu rebent notificacions sobre el canvi d’elements',
    'notification_not_engaged' => 'No rebeu notificacions sobre el canvi d’elements',
    'viewed_number' => 'Nombre de visualitzacions',
    'automatic_deletion_engaged' => 'Supressió automàtica',
    'auto_update_enabled' => 'Canvi automàtic de contrasenya d&apos;usuari activat. Següent canvi previst',
    'copy_folder' => 'Copia la carpeta',
    'select_source_folder' => 'Seleccioneu la carpeta per copiar',
    'select_destination_folder' => 'Seleccioneu la carpeta de destinació',
    'delete_folder' => 'Elimina la carpeta',
    'select_folder_to_delete' => 'Seleccioneu la carpeta per eliminar',
    'folder_delete_confirm' => 'La carpeta seleccionada i els seus elements seran suprimits. Marqueu la casella de selecció per confirmar aquesta supressió.',
    'json_error_format' => 'Format JSON dolent',
    'password_cannot_be_empty' => 'La contrasenya no pot estar buida',
    'password_too_long' => 'La contrasenya és massa llarga',
    'error_no_action_identified' => 'No s&apos;ha identificat cap acció',
    'ldap' => 'LDAP',
    'emails' => 'Correus electrònics',
    'backups' => 'Còpies de seguretat',
    'api' => 'Api',
    'add_folder' => 'Afegiu una carpeta nova',
    'select_folder_parent' => 'Seleccioneu la carpeta de pares',
    'add' => 'Addiccionar',
    'key_is_not_correct' => 'La clau de sessió proporcionada no és correcta',
    'suggestion_information' => 'Podeu suggerir qualsevol canvi sobre aquest element a l’autor. Utilitzeu el formulari anterior per fer les vostres propostes de canvi i feu clic al botó Realitzeu per informar a l’autor.',
    'email_address' => 'Correu electrònic',
    'enter_email' => 'Introduïu el correu electrònic',
    'notification' => 'Notificació',
    'notify_on_change' => 'Notifiqueu-me els canvis',
    'notification_message' => 'Podeu utilitzar aquesta configuració per obtenir notificació o no en els canvis realitzats en aquest element.',
    'share_item' => 'Comparteix element',
    'share_item_message' => 'Podeu compartir aquest element amb algú. Proporcioneu un correu electrònic vàlid i feu clic al botó Realitzeu.',
    'delete_item_message' => 'Heu decidit eliminar aquest element seleccionat. Heu de confirmar la vostra elecció fent clic al botó Realització.',
    'warning' => 'Advertència',
    'information' => 'Informació',
    'perform' => 'Realitzar',
    'delete_item' => 'Eliminar l&apos;element',
    'copy_item' => 'Còpia',
    'new_item' => 'Nou element',
    'error_not_allowed_to_edit_item' => 'No teniu permès editar aquest element',
    'error_not_allowed_to_access_this_folder' => 'No teniu permès accedir a aquesta carpeta',
    'error_personal_saltkey_is_not_set' => 'No es proporciona la vostra Saltkey personal.',
    'provide_your_personal_saltkey' => 'Proporcioneu la vostra Saltkey personal',
    'no_fields' => 'Cap camp no està relacionat amb aquest element.',
    'uploaded' => 'penjat',
    'changes_ongoing' => 'Alguns canvis no s&apos;han desat. Confirmes que vols sortir?',
    'no_file_to_upload' => 'No hi ha cap fitxer per penjar',
    'add_files_and_click_start' => 'Afegiu fitxers a la cua de càrrega i feu clic al botó Inici.',
    'select_files' => 'Seleccioneu fitxers',
    'attached_files' => 'Fitxers adjunts',
    'visible_by' => 'Visible per',
    'anounce_item_by_email' => 'Anuncieu aquest element als usuaris',
    'select_users_if_needed' => 'Seleccioneu els usuaris si cal',
    'allow_item_to_be_deleted' => 'Permet que aquest element es suprimeixi a la següent condició',
    'item_deleted_after_being_viewed_x_times' => 'L&apos;element s&apos;eliminarà després de ser vist x vegades',
    'item_deleted_after_date' => 'L&apos;element s&apos;eliminarà després de la data definida',
    'password' => 'Contrasenya',
    'save' => 'Desar',
    'folder' => 'Carpeta',
    'main' => 'Principal',
    'fields' => 'Camps',
    'details' => 'Detalls',
    'no_special_restriction' => 'Sense restricció especial',
    'generate_otv_link' => 'Genereu un enllaç únic',
    'no_custom_fields' => 'Sense camps personalitzats',
    'no_attachment' => 'Sense adjunt',
    'logout_confirm' => 'Tancar sessió? Siusplau confirma.',
    'saved' => 'Desat',
    'attachments' => 'Adjunts',
    'success' => 'Èxit',
    'server_answer_error' => 'Apareix un error. La resposta del servidor no es pot analitzar.',
    'server_returned_data' => 'Dades retornades',
    'version_alone' => 'versió',
    'statistics' => 'Estadística',
    'options' => 'Les opcions',
    'users' => 'Usuaris',
    'folders' => 'Directoris',
    'find_message' => '%X% Objectes es van trobar',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'share' => 'Comparteix aquest ítem',
    'notify' => 'Notificar',
    'error_no_selected_folder' => 'Has de seleccionar un directori',
    'email_subject_item_updated' => '[Teampass] L&apos;element que estàs seguint ha estat actualitzat',
    'email_body_item_updated' => 'Hola,<br><br>Aquest és un correu electrònic generat des del gestor de contrasenyes de Teampass.<br><br>Heu demanat que us notifiquin els canvis realitzats a l&apos;element `#item_label#` a la carpeta `#folder_name#`.<br ><br>L&apos;usuari <b>#name# #lastname#</b> ha fet almenys un canvi.<br><br>Podeu obrir-lo fent clic a <a href=&apos;#url#/index.php?page=items&group=#item_category#&id=#item_id#&apos;>LINK</a>.<br><br>Salut',
    'import_kp_finished' => 'La importació amb el fitxer KeePass ja s&apos;ha acabat! La força de contrasenya necessària per a les carpetes noves s&apos;ha establert en Mitjana.',
    'password_is_empty' => 'L&apos;element no té contrasenya',
    'bug_report_to_github' => 'Completeu el contingut de l’informe i, a continuació, copieu-lo al porta-retalls i enganxeu-lo a la pàgina New Neat',
    'open_bug_report_in_github' => 'Informe d&apos;emissió obert a GitHub',
    'bugs_page' => 'Si descobreixes un bug, si us plau, reporta&apos;l,.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Qualsevol part d&apos;usuari dels vostres Grups pot editar tots els elements importats.',
    'import_csv_anyone_can_modify_txt' => 'Qualsevol usuari podria editar tots els elements importats.',
    'settings_upload_imageresize_options' => 'Redimensiona les imatges pujades',
    'user_not_exists' => 'Aquest usuari no existeix',
    'auto_create_folder_role' => 'Creeu una carpeta nova i un rol anomenat',
    'start_upload' => 'Començar pujada de l&apos;arxiu',
    'error_upload_runtime_not_found' => 'No s&apos;ha trobat cap execució',
    'user_profile_api_key' => 'Token API',
    'index_change_pw' => 'Canvia la teva contrasenya',
    'admin_2factors_authentication_setting' => 'Habilitar autenticació de dos factors de Google',
    'admin_2factors_authentication_setting_tip' => 'L&apos;autenticació de dos factors de Google millora la seguretat de l&apos;inici de sessió. En iniciar la sessió es mostra un codi QR que s&apos;ha d&apos;escanejar amb l&apos;aplicació Google Authentication de l&apos;usuari per rebre una contrasenya d&apos;us únic. Requereix que els usuaris comptin amb l&apos;aplicació Google Authentication amb un dispositiu connectat a Internet.',
    'admin_ga_website_name' => 'Nom mostrat al Google Authenticator per Teampass',
    'admin_ga_website_name_tip' => 'Aquest nom s&apos;utilitza pel compte d&apos;identificació de codi a Google Authenticator.',
    'api_whitelist_ips' => 'API IPS Whitelist',
    'api_whitelist_ips_tip' => 'Si no hi ha cap adreça IP de client API que es mostri explícitament aquí, qualsevol adreça IP està autoritzada.',
    'email_share_item_subject' => '[TeamPass] Un ítem ha sigut compartit amb tu',
    'email_share_item_mail' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br>#tp_user#ha compartit amb vosaltres l’element de la contrasenya#tp_item#. <br> <br> <a href = "## tp_link#"> Feu clic a aquest enllaç </a> per accedir a l&apos;element. <br> <br> <br> Salutacions',
    'index_maintenance_mode_admin' => 'Mode de Manteniment activat. Ara els usuaris no poden accedir a TeamPass.',
    '2fa_authentication_selector' => 'Seleccioneu un mètode d&apos;autenticació de 2 factors',
    'upload_empty_file' => 'Pengeu el fitxer buit',
    'upload_any_extension_file' => 'Pengeu qualsevol fitxer d&apos;extensió',
    'upload_any_extension_file_tip' => 'Quan estigui activat, aquesta opció permetrà als usuaris penjar qualsevol tipus de fitxers.',
    'log_in' => 'Iniciar Sessió',
    'create_item_based_upon_template' => 'Ús de la plantilla per a l&apos;element',
    'create_item_based_upon_template_tip' => 'Quan està activada, aquesta funció permet a l&apos;autor seleccionar una plantilla feta de camps personalitzats. Tingueu en compte que aquesta funció requereix que els camps personalitzats també estiguin habilitats.',
    'main_template' => 'Utilitzeu com a plantilla',
    'is_mandatory' => 'És obligatori',
    'error_field_is_mandatory' => 'Almenys un camp obligatori està buit',
    'restrict_visibility_to' => 'Restringir la visibilitat a',
    'every_roles' => 'Tots els Rols',
    'masked_text' => 'Text emmascarat',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Activa l&apos;autenticació de Yubico',
    'yubico_user_id' => 'Identificació del client',
    'yubico_user_key' => 'Clau secreta',
    'yubico_bad_code' => 'Informació incorrecta de Yubico',
    'press_your_yubico_key' => 'Premeu la tecla Yubico',
    'human_resources' => 'Gerent de Teampass',
    'settings_secure_display_image' => 'Activa la visualització de la imatge segura',
    'settings_secure_display_image_tip' => 'La visualització de la imatge segura permet llegir la imatge mitjançant PHP quan un usuari previsualitza una imatge adjunta a un element. PRO: El fitxer adjunt s’emmagatzema fora de la carpeta del lloc i no és accessible per un pirata informàtic. CON: És lleugerament més lent que la vista prèvia directament d’una URL.',
    'user_ga_code' => 'Envia Google Authenticator per email a l&apos;usuari',
    'error_no_email' => 'L&apos;usuari no te email configurat!',
    'error_no_user' => 'No s&apos;ha trobat l&apos;usuari!',
    'email_ga_subject' => 'El teu codi flash de Google Authenticator per Teampass',
    'email_ga_text' => 'Si us plau <a href="#link#">cliqueu aquest enllaç</a> i escanegeu el codi QR amb la vostra aplicació de Google Authenticator per a establir unes credencials d&apos;un sol us per al gestor de contrasenyes.',
    'settings_attachments_encryption' => 'Habilita xifrat dels ítems adjunts',
    'settings_attachments_encryption_tip' => 'Si s&apos;activa, els elements adjuntats es xifren al servidor amb la clau de sistema. El xifrat requereix més recursos de servidor. -- Alerta! -- Canviar aquesta opció podria trencar els fitxers d&apos;adjunts existents! Després de canviar aquesta opció, hauríeu d&apos;executar la tasca de xifra o desxifra els adjunts existents.',
    'admin_action_attachments_cryption' => 'Xifra o desxifra els adjunts dels ítems',
    'admin_action_attachments_cryption_tip' => 'Alerta: Xifreu o desxifreu els fitxers només després de canviar l&apos;opció de xifrar els adjunts a coincidir. Seleccioneu xifra o desxifra i llavors premeu comença. Realitzeu una còpia de seguretat de la carpeta pujada abans d&apos;executar aquesta opció.',
    'encrypt' => 'Xifrar',
    'decrypt' => 'Desxifrar',
    'ga_identification_code' => 'Codi d&apos;identificació',
    'ga_enter_credentials' => 'Has de introduir les teves credencials d&apos;accés',
    'ga_bad_code' => 'El codi de Google Authenticator es erroni',
    'settings_get_tp_info' => 'Carregar informació sobre Teampass automàticament',
    'settings_get_tp_info_tip' => 'Aquesta opció permet carregar informació, com la versió i les llibreries utilitzades al servidor de Teampass, a la pàgina de administració',
    'settings_offline_mode' => 'Activar mode Off-line',
    'settings_offline_mode_tip' => 'El mode fora de línia crea una sola pàgina web HTML que es pot descarregar a un ordinador. Els elements a la pàgina fora de línia estan xifrats amb una contrasenya especificada per l&apos;usuari.',
    'offline_mode_key_level' => 'Seguretat mínima del xifrat de fora de línia',
    'categories' => 'Camps personalitzats',
    'no_category_defined' => 'Cap categoria definida.',
    'confirm_deletion' => 'Estàs a punt d&apos;esborrar... estàs segur?',
    'settings_item_extra_fields' => 'Camps personalitzats habilitats',
    'settings_item_extra_fields_tip' => 'Activa una altra pestanya en crear elements de contrasenya que conté camps personalitzables per a altres tipus de dades. Un administrador ha de crear primer categories i camps personalitzats perquè se mostrin dins aquestes categories. Aquesta funció consumeix més recursos de servidor.',
    'settings_ldap_type' => 'Tipus de servidor LDAP',
    'server_time' => 'Hora del servidor',
    'settings_tree_counters' => 'Mostra mes comptadors a l&apos;arbre de directoris',
    'settings_tree_counters_tip' => 'En activar-ho es mostren tres números al costat de cada carpeta: quantitat d&apos;elements a la carpeta base; quantitat d&apos;element incloent subcarpetes; quantitat de subcarpetes. Activar aquesta funció pot alentir la càrrega del panell d&apos;arbre de carpetes.',
    'admin_action_check_pf' => 'Crea carpetes personals per a tots els usuaris que no en tenguin',
    'enable_personal_folder_feature_tip' => 'Les carpetes personals són una ubicació privada per a contrasenyes d&apos;usuaris individuals. Els elements de contrasenya es xifren amb una clau de sal d&apos;usuari (més segur) o amb la seva contrasenya. Activar aquesta funció no crea les carpetes pels usuaris existents - heu d&apos;executar la tasca de creació de carpetes personals.',
    'administrators_only' => 'Només administradors',
    'managers_of' => 'Managers del rol',
    'managed_by' => 'Gestionat per',
    'settings_enable_sts' => 'Seguretat de transport estricte HTTPS. <strong>Alerta</strong>: llegiu l&apos;anotació!',
    'settings_enable_sts_tip' => 'Atenció! Això forçarà la política de seguretat de transport estricte de HTTPS (STS). L&apos;STS ajuda a prevenir atacs del tipus man-in-the-middle. Heu de tenir instal·lat un certificat SSL emès per una autoritat certificadora (CA) abans d&apos;activar aquesta opció! Un certificat auto-signat no funcionarà! Totes les connexions futures requeriran HTTPS. Heu de tenir &apos;SSLOptions +ExportCertData&apos; a la configuració SSL de l&apos;Apache.',
    'settings_anyone_can_modify_bydefault' => '<i>Tothom pot modificar</i> l&apos;opció seleccionada per defecte',
    'to' => 'a',
    'settings_upload_maxfilesize_tip' => 'Mida màxima de fitxer permesa en pujar un adjunt o un altre fitxer (en megabytes, per defecte 10mb). Pot ser que hagueu de canviar també upload_max_filesize i post_max_size a la vostra configuració del php.ini, habitualment el valor predeterminat és només 2M.',
    'settings_upload_docext_tip' => 'Llista les extensions per a fitxers de text i processadors de text que permetreu pujar com a adjunts. Indiqueu les extensions de fitxer permeses separades amb una coma (,)',
    'settings_upload_imagesext_tip' => 'Llisteu les extensions de fitxers d&apos;imatge que permetreu com a adjunts. Indiqueu les extensions permeses separades amb una coma (,)',
    'settings_upload_pkgext_tip' => 'Llisteu les extensions de fitxers comprimits que permetreu com a adjunts. Indiqueu les extensions permeses separades amb una coma (,)',
    'settings_upload_otherext_tip' => 'Llisteu qualsevol altra extensió de fitxer que permetreu pujar com a adjunt. Indiqueu les extensions permeses separades amb una coma (,)',
    'settings_upload_imageresize_options_tip' => 'Redimensiona imatges pujades grans (establiu la mida màxima en píxels). Pot ser que les imatges majors de 1000 píxels no es mostrin be al navegador.',
    'settings_upload_maxfilesize' => 'Tamany màxim d&apos;arxiu (en Mb)',
    'settings_upload_docext' => 'Extensions de document permeses',
    'settings_upload_imagesext' => 'Extensions de imatges permeses',
    'settings_upload_pkgext' => 'Extensions de paquets permeses',
    'settings_upload_otherext' => 'Altres extensions permeses',
    'settings_upload_imageresize_options_w' => 'Ample de la imatge redimensionada (en píxels)',
    'settings_upload_imageresize_options_h' => 'Alt de la imatge redimensionada (en píxels)',
    'settings_upload_imageresize_options_q' => 'Qualitat de l&apos;imatge redimensionada',
    'settings_importing' => 'Habilita la importació de dades des de CVS/KeyPass files',
    'admin_proxy_ip' => 'IP del Proxy utilitzat',
    'admin_proxy_ip_tip' => 'Si necessites un servidor proxy per connectar a internet, especifica la adreça IP aquí. Altrament, deixa el camp en blanc.',
    'admin_proxy_port' => 'PORT del Proxy utilitzat',
    'admin_proxy_port_tip' => 'Si necessites un servidor proxy per connectar a internet, especifica el número de port aquí.',
    'settings_ldap_elusers' => 'només usuaris locals',
    'settings_ldap_elusers_tip' => 'Aquesta funció permet als usuaris dins la base de dades autenticar via LDAP. Desactiveu aquesta opció si voleu navegar qualsevol directori LDAP.',
    'db_items_edited' => 'Actualment s&apos;està editat l&apos;element',
    'item_edition_start_hour' => 'Edició començada',
    'settings_delay_for_item_edition' => 'El bloqueig d&apos;edició exclusiva expira després de XX minuts',
    'settings_delay_for_item_edition_tip' => 'En editar un element, aquest es bloqueja per tal que cap altra usuari el pugui modificar. Aquest ajust elimina l&apos;etiqueta de bloqueig després d&apos;un cert nombre de minuts. Si el valor s&apos;estableix a 0, no es desbloquejarà automàticament mai un element després qua algú l&apos;hagi començat a editar.',
    'db_users_logged' => 'Usuaris connectats actualment',
    'action' => 'Acció',
    'login_time' => 'Connectat des de',
    'lastname' => 'Cognom',
    'user_login' => 'Inici de sessió',
    'role' => 'Rol',
    'error_role_exist' => 'Aquest rol ja existeix!',
    'error_no_edition_possible_locked' => 'Edició no possible. L&apos;ítem s&apos;està editant actualment.',
    'select' => 'selecciona',
    'items' => 'ítems',
    'enable_personal_saltkey_cookie' => 'Emmagatzema la clau de sal personal dins una galeta del navegador',
    'personal_saltkey_cookie_duration' => 'Les claus de sal de l&apos;usuari expiren després de XX dies',
    'admin_email_smtp_server' => 'Servidor SMTP',
    'admin_email_auth' => 'El servidor SMTP necessita autenticació',
    'admin_email_auth_username' => 'Usuari del servidor de correu',
    'admin_email_auth_pwd' => 'Contrasenya del servidor de correu',
    'admin_email_port' => 'Port del servidor',
    'admin_email_from' => 'Remitent: Adreça de correu',
    'admin_email_from_name' => 'Remitent: Nom mostrat',
    'admin_email_test_configuration_tip' => 'Envia un correu de prova a l&apos;usuari amb la sessió iniciada. Heu d&apos;establir primer la vostra adreça de correu fent clic a la icona del perfil d&apos;usuari.',
    'admin_email_test_subject' => '[TeamPass] Mail de prova',
    'admin_email_test_body' => 'Això és un correu de prova enviat per verificar la configuració del servidor de correu. Si esteu llegint això, enhorabona!',
    'admin_email_result_ok' => 'Email enviat a #email# ... Comprova la teva safata d&apos;entrada',
    'email_bodyalt_item_updated' => 'La contrasenya de #item_label# ha sigut actualitzada',
    'admin_email_send_backlog_tip' => 'Torna a enviar qualsevol registre en cua de correus sortints esperant a la base de dades.',
    'please_wait' => 'Si us plau, espera!',
    'admin_path_to_files_folder' => 'Directori de fitxers (ruta completa)',
    'admin_path_to_files_folder_tip' => 'El directori de fitxers s&apos;utilitza per emmagatzemar tant els fitxers de sistema com els pujats. Per a més seguretat, no hauria d&apos;estar localitzat al directori www del vostre lloc - S&apos;hauria de crear a un directori fora del vostre lloc web i accedir-hi via una regla de rewrite o redirecció./span>',
    'admin_path_to_upload_folder_tip' => 'Els adjunts s&apos;emmagatzemen al directori de pujades amb noms aleatoris. El contingut d&apos;aquest directori no s&apos;hauria d&apos;esborrar mai manualment. Per a major seguretat, no hauria d&apos;estar localitzat al directori www del vostre lloc - S&apos;hauria de crear a un directori fora del vostre lloc web i accedir-hi via una regla de rewrite o redirecció./span>',
    'pdf_password_warning' => 'Has de introduir un clau de xifrat!',
    'admin_pwd_maximum_length' => 'Màxima llargada dels passwords',
    'admin_pwd_maximum_length_tip' => 'La mida màxima de les contrasenyes és de 40 caràcters. Augmentar la mida de les contrasenyes prendria més temps en xifrar, desxifrar i mostrar les contrasenyes.',
    'settings_insert_manual_entry_item_history' => 'Permet insercions manuals al registre històric d&apos;elements.',
    'settings_insert_manual_entry_item_history_tip' => 'Normalment heu de deixar això desmarcat. En activar-ho, l&apos;històric d&apos;una contrasenya pot ser alterat o editat.',
    'admin_path_to_upload_folder' => 'Directori de pujades (ruta completa)',
    'admin_setting_enable_delete_after_consultation' => 'Permet l&apos;expiració de contrasenyes després de visualitzacions limitades',
    'admin_setting_enable_delete_after_consultation_tip' => 'En activar-ho, els creadors d&apos;elements poden decidir si una contrasenya s&apos;esborrarà automàticament després d&apos;un nombre limitat de visualitzacions.',
    'at_email' => 'correu electrònic',
    'enable_email_notification_on_item_shown' => 'Envia una notificació per email quan es mostra un ítem',
    'share_sent_ok' => 'L&apos;email ha sigut enviat',
    'see_item_title' => 'Detalls de l&apos;element',
    'email_on_open_notification_subject' => 'Notificació a la vista de contrasenya de l&apos;element ',
    'email_on_open_notification_mail' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br>#TP_USER#ha obert i vist l’element de la contrasenya \ &apos;#tp_item#&apos;. <a href=&apos;#tp_link#&apos;> Feu clic a aquest enllaç </a> per accedir a l&apos;element.',
    'pdf' => 'PDF',
    'email_subject_new_user' => 'Compte de gestió de contrasenya creat per a vosaltres',
    'email_new_user_mail' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> Un administrador ha creat un compte per a vosaltres al gestor de contrasenyes. Les contrasenyes segures per a la vostra organització són a només un clic. <br> <br> Utilitzeu aquestes credencials per al vostre primer inici de sessió: <br>- inici de sessió:#tp_login#<br>- contrasenya:#tp_pw#<br> <br> <a href=#tp_link#> Feu clic a aquest enllaç < /a> per iniciar la sessió.',
    'error_empty_data' => 'No hi ha dades per continuar!',
    'error_not_allowed_to' => 'No tens permisos per fer això!',
    'request_access_ot_item' => 'Demana accés a l&apos;autor',
    'email_request_access_subject' => 'Teniu una sol·licitud per habilitar l&apos;accés a l&apos;element de la vostra contrasenya',
    'email_request_access_mail' => 'Hola, <br> <br> Aquest és un correu electrònic generat del gestor de contrasenyes de TeamPass. <br> <br> usuari#tp_user#ha sol·licitat accés a l&apos;element de contrasenya \\ &apos;#tp_item#\&apos;. <br> < Br> La sol·licitud ve amb la següent justificació: <br> <i> \\ &apos;#tp_reason#\&apos; </i> <br> <br> Reviseu aquesta sol·licitud i confirmeu que autoritzareu l&apos;accés. < Br> <br> Salutacions.',
    'admin_action_change_salt_key' => 'Canvia la clau SALT principal',
    'nb_items_by_query' => 'Nombre de ítems a recuperar per consulta',
    'nb_items_by_query_tip' => 'Introduïu el nombre d’elements a recuperar per sol·licitud del servidor. Múltiples sol·licituds més petites poden funcionar millor que menys peticions més grans. Altres opcions: \ &apos;Auto &apos;- Sintonitzat a la mida de la finestra de visualització de l&apos;usuari. \ &apos;max &apos;- per carregar-ho tot alhora.',
    'open_url_link' => 'Obrir en una pàgina nova',
    'error_pw_too_long' => 'Contrasenya massa llarga! El màxim de caràcters es 40.',
    'at_restriction' => 'Restricció',
    'pw_encryption_error' => 'Error xifrant la contrasenya',
    'enable_send_email_on_user_login' => 'Els administradors de correu electrònic a qualsevol inici de sessió de l&apos;usuari',
    'email_subject_on_user_login' => '[TeamPass] Un usuari s&apos;ha conectat',
    'email_body_on_user_login' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> usuari #tp_user #inici de sessió al gestor de contrasenyes de #tp_date #a #tp_time #. <br> <br> Aquest és un missatge normal quan es defineix l&apos;opció <i> administradors de correu electrònic a qualsevol inici de sessió d&apos;usuari </i>.',
    'account_is_locked' => 'Aquest compte està bloquejat',
    'activity' => 'Activitat',
    'add_role_tip' => 'Afegiu un nou rol',
    'admin' => 'Administració',
    'admin_action_db_backup' => 'Fes una còpia de seguretat de la base de dades',
    'admin_action_db_clean_items' => 'Elimina elements orfes de la base de dades',
    'admin_action_db_clean_items_tip' => 'Esborra tots els elements o entrades que han quedat després que un directori s&apos;hagi eliminat. Si us plau, realitzeu una còpia de seguretat abans de fer aquesta tasca.',
    'admin_action_db_optimize' => 'Optimitza la base de dades',
    'admin_action_db_restore' => 'Restaura la base de dades',
    'admin_action_purge_old_files' => 'Neteja els fitxers temporals',
    'admin_action_purge_old_files_tip' => 'Elimina tots els fitxers temporals més antics de 7 dies.',
    'admin_action_reload_cache_table' => 'Recarrega la taula de Cache',
    'admin_action_reload_cache_table_tip' => 'Recrea la memòria cau dels elements. Pot corregir problemes en mostrar o desar elements de contrasenya.',
    'admin_help' => 'Ajuda',
    'admin_ldap_configuration' => 'Configuració LDAP',
    'admin_main' => 'Informació',
    'admin_misc_cpassman_dir' => 'Ruta sencera del TeamPass',
    'admin_misc_cpassman_url' => 'URL sencera del TeamPass',
    'admin_misc_custom_login_text' => 'Missatge d&apos;inici de sessió personalitzat',
    'admin_misc_custom_logo' => 'Logo d&apos;inici de sessió personalitzat (URL)',
    'admin_misc_favicon' => 'URL sencera del fitxer favicon',
    'admin_settings' => 'Ajustos',
    'admin_settings_title' => 'Ajustos de TeamPass',
    'admin_setting_activate_expiration' => 'Habilita l&apos;expiració de contrasenyes',
    'admin_setting_activate_expiration_tip' => 'Quan estiguin habilitats, els elements de contrasenya no es mostraran després d&apos;haver caducat. Definiu el temps de caducitat de la contrasenya en dies en un altre lloc abans d&apos;activar aquesta funció.',
    'admin_views' => 'Vistes',
    'alert_message_done' => 'Fet!',
    'all' => 'tot',
    'anyone_can_modify' => 'Permet que qualsevol que tingui accés a l&apos;element el pugui modificar.',
    'at' => 'a',
    'at_category' => 'Directori',
    'at_copy' => 'Còpia feta',
    'at_delete' => 'Esborrat',
    'at_description' => 'Descripció',
    'at_label' => 'Etiqueta',
    'at_login' => 'iniciar Sessió',
    'at_moved' => 'Mogut',
    'at_personnel' => 'Personal',
    'at_restored' => 'Restaurat',
    'at_shown' => 'Accedit',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Directoris permesos',
    'auth_creation_without_complexity' => 'Permet la creació d’elements sense força de contrasenya necessària',
    'auth_modification_without_complexity' => 'Permet la modificació de l&apos;element sense força de contrasenya necessària',
    'cancel' => 'Canceŀla',
    'can_create_root_folder' => 'Permet crear un directori al nivell arrel',
    'changelog' => 'Últimes notícies',
    'close' => 'Tancar',
    'complexity' => 'Complexitat',
    'complex_asked' => 'Complexitat de contrasenya requerida',
    'complex_level0' => 'Molt fluixa',
    'complex_level1' => 'Fluixa',
    'complex_level2' => 'Mitjana',
    'complex_level3' => 'Forta',
    'complex_level4' => 'Molt forta',
    'complex_level5' => 'Pesat',
    'complex_level6' => 'Molt pesat',
    'confirm' => 'Confirmar',
    'confirm_del_from_fav' => 'Si us plau, confirmeu l&apos;eliminació dels favorits',
    'connections' => 'connexions',
    'copy' => 'Còpia',
    'copy_to_clipboard_small_icons' => 'Permet la icona de <i>copia contrasenya</i> a la llista d&apos;elements',
    'copy_to_clipboard_small_icons_tip' => 'Afegeix una petita icona a la llista d&apos;elements de contrasenyes al panell superior que copia la contrasenya al porta-retalls. Es podrà copiar la contrasenya sense necessitat de seleccionar i carregar el contingut complet de l&apos;element.',
    'date' => 'Data',
    'date_format' => 'Format de data',
    'delete' => 'Esborra',
    'deletion' => 'Eliminacions',
    'del_button' => 'Esborrar',
    'description' => 'Descripció',
    'disconnect' => 'Desconnectar',
    'done' => 'Fet',
    'duplicate_folder' => 'Les carpetes poden tenir noms duplicats',
    'duplicate_item' => 'Els elements poden tenir nom duplicat',
    'email' => 'Correu electrònic',
    'email_subject' => 'Nou element de contrasenya creat al gestor de contrasenyes',
    'enable_favourites' => 'Habilita que els usuaris guardin Favorits',
    'enable_personal_folder' => 'Habilita directori Personal',
    'enable_personal_folder_feature' => 'Habilita la funcionalitat de directori Personal',
    'enable_user_can_create_folders' => 'Subcarpetes gestionades per qualsevol persona que pugui gestionar els pares',
    'encrypt_key' => 'Clau de xifrat',
    'errors' => 'errors',
    'error_group_exist' => 'Aquest directori ja existeix!',
    'error_html_codes' => 'Alguns textos conté codis HTML. Això no està permès.',
    'error_item_exists' => 'Aquest ítem ja existeix!',
    'error_label' => 'Una etiqueta és obligatòria.',
    'error_must_enter_all_fields' => 'Has d&apos;omplir tots els camps!',
    'error_pw' => 'Una contrasenya es obligatòria!',
    'error_tags' => 'Només es permeten espais a les etiquetes',
    'error_user_exists' => 'Aquest usuari ja existeix',
    'expiration_date' => 'Data d&apos;expiració',
    'find' => 'Cerca',
    'forbidden_groups' => 'Les carpetes negades',
    'forgot_my_pw_email_sent' => 'L&apos;email ha sigut enviat',
    'functions' => 'Rols',
    'gestionnaire' => 'Gerent',
    'god' => 'Administrador',
    'group' => 'Directori',
    'group_parent' => 'Carpeta pare',
    'group_pw_duration' => 'Període de renvació',
    'group_pw_duration_tip' => 'En mesos. 0 per deshabilitar.',
    'history' => 'Història',
    'home_personal_saltkey' => 'La teva clau SALT personal',
    'home_personal_saltkey_label' => 'Introdueix la teva clau personal SALT',
    'import_error_no_read_possible' => 'No es pot llegit l&apos;arxiu!',
    'import_error_no_read_possible_kp' => 'No es pot llegir l&apos;arxiu! Deu ser un arxiu de KeePass.',
    'import_keepass_to_folder' => 'Seŀlecciona la carpeta destí',
    'index_add_one_hour' => 'Ampliar la sessió en 1 hora',
    'index_change_pw_confirmation' => 'Confirma',
    'index_expiration_in' => 'caducitat de sessió a',
    'index_get_identified' => 'Si us plau identifique&apos;t!',
    'index_last_pw_change' => 'Contrasenya canviada',
    'index_last_seen' => 'Ultima connexió',
    'index_login' => 'Compte',
    'index_new_pw' => 'Nova contrasenya',
    'index_password' => 'Contrasenya',
    'index_pw_error_identical' => 'Les contrasenyes han de ser idèntiques!',
    'index_pw_level_txt' => 'Complexitat',
    'index_session_duration' => 'Durada de la sessió',
    'info' => 'Informació',
    'item_menu_copy_login' => 'Copia "login"',
    'item_menu_copy_pw' => 'Copia la contrasenya',
    'item_menu_del_from_fav' => 'Esborra de favorits',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de coneixement',
    'last_items_title' => 'Últims elements vistos',
    'ldap_extension_not_loaded' => 'L&apos;extensió PHP LDAP no es carrega al servidor.',
    'level' => 'Nivell',
    'login' => 'iniciar Sessió',
    'mask_pw' => 'Emmascara/Mostra la contrasenya',
    'max_last_items' => 'Màxim nombre de últims elements vistos per usuari (10 per defecte)',
    'minutes' => 'minuts',
    'name' => 'Nom',
    'nb_false_login_attempts' => 'Intents d&apos;inici de sessió màxim abans del bloqueig del compte (0 per desactivar el bloqueig)',
    'nb_folders' => 'Número de directoris',
    'nb_items' => 'Número d&apos;elements',
    'new_label' => 'Nova etiqueta',
    'no' => 'No',
    'none' => 'Cap',
    'none_selected_text' => 'Cap seŀleccionat',
    'not_allowed_to_see_pw' => 'No estàs autoritzat per veure aquest ítem!',
    'not_allowed_to_see_pw_is_expired' => 'Aquest ítem ha expirat!',
    'not_defined' => 'No definit',
    'number_of_used_pw' => 'Nombre de contrasenyes antigues recordades per evitar la reutilització (0 per desactivar)',
    'pages' => 'Pàgines',
    'pdf_download' => 'Descarregar arxiu',
    'personal_salt_key' => 'La teva clau salt',
    'pw' => 'Contrasenya',
    'pw_generate' => 'Generar',
    'pw_is_expired_-_update_it' => 'Aquest element ha expirat! Cal canviar la seva contrasenya.',
    'pw_life_duration' => 'Les contrasenyes d’inici de sessió caduquen després de xx dies (0 per desactivar)',
    'readme_open' => 'Obre el fitxer de llegeix-me sencer',
    'read_only_account' => 'Llegeix només',
    'restore' => 'Restaura',
    'restricted_to' => 'Restringit a',
    'restricted_to_roles' => 'Permet restringir els elements als usuaris i als rols',
    'root' => 'Arrel',
    'secure' => 'Segur',
    'see_logs' => 'Veure Logs',
    'settings_anyone_can_modify' => 'Activa una opció per cada element que permeti que qualsevol el modifiqui.',
    'settings_anyone_can_modify_tip' => 'Això afegeix una casella de selecció durant la creació de nous elements de contrasenya que pot configurar l&apos;element per ser modificable per qualsevol persona.',
    'settings_default_language' => 'Defineix l&apos;idioma per defecte',
    'settings_kb' => 'Habilitar Base de Coneixemnt (beta)',
    'settings_kb_tip' => 'Afegeix un element de menú per accedir a la funció de base de coneixement. La base de coneixement és una FAQ que es pot cercar, que us permet crear ajuda i notes i adjuntar-les als elements de contrasenya.',
    'settings_ldap_domain' => 'Sufix del compte LDAP per el teu domini',
    'settings_ldap_domain_controler' => 'Vector de controladors de domini LDAP',
    'settings_ldap_domain_controler_tip' => 'Especifiqueu el controlador de domini que proporciona els serveis de directori. Per equilibrar les consultes entre diversos servidors, introduïu una llista delimitada per comes de cada nom del servidor. Exemple: domini_1, domini_2, domini_3',
    'settings_ldap_domain_dn' => 'Base dn LDAP per el teu domini',
    'settings_ldap_mode' => 'Habilita l&apos;autenticació d&apos;usuari a través del servidor LDAP',
    'settings_ldap_mode_tip' => 'Activeu si voleu autenticar els inicis de sessió d&apos;usuari amb un servidor de directori LDAP en lloc d&apos;utilitzar la base de dades d&apos;usuari interna.',
    'settings_ldap_ssl' => 'Empra LDAP a través de SSL (LDAPS)',
    'settings_ldap_tls' => 'Empra LDAP a través de TLS',
    'settings_log_accessed' => 'Registra les visualitzacions de l&apos;element de la contrasenya dels usuaris',
    'settings_log_connections' => 'Registra tots els inicis de sessió',
    'settings_maintenance_mode' => 'Posa TeamPass en mode Manteniment',
    'settings_manager_edit' => 'Els gestors poden editar o eliminar qualsevol element que puguin veure',
    'settings_printing' => 'Habilitar impressió d&apos;items en un fitxer PDF',
    'settings_printing_tip' => 'Afegeix una opció d’exportació al menú Arbre d’elements, permetent l’exportació de carpetes senceres a PDF o CSV. Les contrasenyes CSV s’exportaran sense xifrar, mentre que els fitxers PDF poden protegir-se amb contrasenya.',
    'settings_restricted_to' => 'Habilita <i> Funció restringida a </i> als elements',
    'settings_show_description' => 'Mostra el camp de descripció de l&apos;element als llistats d&apos;elements',
    'size' => 'Mida',
    'tags' => 'Etiquetes',
    'timezone_selection' => 'Fus horari',
    'time_format' => 'Format de temps',
    'url' => 'URL',
    'user' => 'Usuari',
    'users_online' => 'usuaris online',
    'user_alarm_no_function' => 'Aquest usuari no te Rols!',
    'yes' => 'Si',
    'one_time_view_item_url_box' => 'Comparteix una URL única amb una persona de confiança per veure la contrasenya <br> <br>#url#<br> <br> Aquest enllaç només serà visible una vegada i caduca#dia#',
    'settings_api' => 'Accés a la API habilitat',
    'settings_api_tip' => 'La interfície de programació d&apos;aplicacions permet als desenvolupadors de programari accedir a elements de contrasenya en format JSON a la xarxa.',
    'settings_api_keys_list' => 'Llista de claus',
    'settings_api_keys_list_tip' => 'Claus per accedir a l&apos;API. El programari de tercers ha d’utilitzar una tecla aleatòria creada aquí per accedir a la interfície JSON.',
    'settings_api_key' => 'Clau',
    'settings_api_add_ip' => 'Afegir nova IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Les noves subppoletes hereten permisos de la carpeta matriu',
    'subfolder_rights_as_parent_tip' => 'Si està activat, cada nou sub-foller hereta els rols i els permisos de la carpeta pare. En cas contrari, el permís de la carpeta s’assigna en funció del rol de l’usuari que els crei.',
    'show_only_accessible_folders_tip' => 'De manera predeterminada, els usuaris veuen l’arbre complet de les carpetes d’elements de contrasenya, fins i tot si algunes carpetes són inaccessibles per a l’usuari. Podeu eliminar les carpetes inaccessibles de la vista per simplificar la navegació.',
    'show_only_accessible_folders' => 'Amagueu les carpetes de contrasenya inaccessibles',
    'comment' => 'Comentari',
    'suggestion_menu' => 'Suggeriments',
    'settings_suggestion' => 'Funció de suggeriment de contrasenya activada',
    'settings_suggestion_tip' => 'La funció de suggeriment afegeix un menú i una pàgina nous, permetent als usuaris crear suggeriments per a nous elements de contrasenya. Això és útil quan només es permet als gestors crear elements de contrasenya.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP BIND DN',
    'settings_ldap_bind_passwd' => 'Ldap Bind Passwd',
    'settings_ldap_search_base' => 'Base de cerca LDAP',
    'settings_ldap_bind_dn_tip' => 'Introduïu un DN de Bind que pot accedir als usuaris i cercar a l&apos;arbre. Un DN BIND és una credencial que autentica el vostre accés al directori.',
    'settings_ldap_bind_passwd_tip' => 'Contrasenya per al DN de BIND especificat anteriorment.',
    'settings_ldap_search_base_tip' => 'Root DN Ubicació per a cerques a l&apos;arbre',
    'admin_email_server_url' => 'Personalitzeu URL per a enllaços',
    'enable_email_notification_on_user_pw_change' => 'Usuari de correu electrònic quan es canvia la contrasenya de l&apos;usuari',
    'settings_otv_expiration_period' => 'Els enllaços únics de vista (OTV) caduquen després de xx dies',
    'write' => 'Escriure',
    'read' => 'Llegir',
    'no_access' => 'Sense accés',
    'right_types_label' => 'Seleccioneu el tipus d&apos;accés d&apos;aquesta carpeta per al grup d&apos;usuaris seleccionat',
    'duplicate_item_in_folder' => 'Els elements de la mateixa carpeta poden tenir noms similars',
    'settings_roles_allowed_to_print' => 'Exportació permesa per aquests rols (multi-selecció)',
    'settings_roles_allowed_to_print_tip' => 'Seleccioneu diversos rols mantenint CTRL mentre seleccioneu. Els membres d&apos;aquests rols podran exportar carpetes a CSV o PDF si l&apos;exportació també està habilitada a nivell mundial.',
    'admin_email_security' => 'Seguretat SMTP',
    'alert_page_will_reload' => 'La pàgina ara es tornarà a carregar',
    'file_protection_password' => 'Definiu la contrasenya del fitxer',
    'expand' => 'Expandir',
    'collapse' => 'Col·lapsar',
    'settings_ldap_user_attribute' => 'User attribute to search',
    'settings_ldap_user_attribute_tip' => 'LDAP attribute to search within for username',
    'log_user_initial_pwd_changed' => 'S&apos;ha definit la contrasenya inicial',
    'log_user_email_changed' => 'El correu electrònic de l&apos;usuari va canviar a',
    'log_user_created' => 'Compte d&apos;usuari creada',
    'log_user_locked' => 'L&apos;usuari ha sigut bloquejat',
    'log_user_unlocked' => 'L&apos;usuari ha sigut desbloquejat',
    'log_user_pwd_changed' => 'La contrasenya del usuari s&apos;ha canviat',
    'settings_default_session_expiration_time' => 'Temps d&apos;expiració de sessió per defecte',
    'settings_duo' => 'Habilita l&apos;autenticació de dos factors DUO Security',
    'settings_duo_tip' => 'Duo Security Basation Cloud Autenticació de Duo.com. Utilitzeu els codis de passada d&apos;inici de sessió únicament mitjançant SMS, trucada de veu o aplicació per a mòbils. Es requereix un compte amb duo per utilitzar aquesta funció. La sessió de dos factors mitjançant duo serà necessari per a tots els usuaris que no siguin Admin quan s’activa.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'Host',
    'settings_duo_explanation' => 'Les credencials de la pàgina d’administració de seguretat del duo per al vostre compte s’han d’introduir aquí.',
    'admin_duo_intro' => 'Introduïu o genereu un secret de seguretat de duo',
    'edit' => 'Editar',
    'user_info_locked' => 'L&apos;usuari està bloquejat.',
    'user_info_unlock_question' => 'Desbloquejar compte?',
    'user_info_lock_question' => 'Bloquejar compte?',
    'user_info_delete_question' => 'Esborrar compte?',
    'user_info_active' => 'L&apos;usuari està habilitat.',
    'refresh' => 'Refrescar',
    'loading' => 'Carregant',
    'searching' => 'Buscant ...',
    'list_items_with_tag' => 'Enumereu els elements amb aquesta etiqueta',
    'no_item_to_display' => 'No hi ha elements per mostrar',
    'opening_folder' => 'Lectura de la carpeta ...',
    'suggestion_notify_subject' => 'S&apos;ha enviat un nou suggeriment d&apos;elements de contrasenya',
    'suggestion_notify_body' => 'Un usuari ha enviat un suggeriment d&apos;elements de contrasenya al gestor de contrasenyes. Heu d’acceptar l’enviament abans que altres usuaris puguin ser utilitzats. <br> Aquest correu electrònic s&apos;ha enviat a tots els gestors.',
    'error_unknown' => 'S&apos;ha produït un error inesperat!',
    'no_edit' => 'Escriptura però no edició',
    'role_cannot_edit_item' => 'No es poden editar els elements',
    'no_delete' => 'Escriptura però no esborrat',
    'role_cannot_delete_item' => 'No es poden eliminar els elements',
    'my_profile' => 'El meu perfil',
    'starting' => 'Començant ...',
    'total_number_of_items' => 'Nombre total d’elements',
    'finalizing' => 'Finalitzant',
    'treating_items' => 'Processament d’elements',
    'number_of_items_treated' => 'Nombre de ítems processats',
    'error_sent_back' => 'S&apos;ha produït el següent error',
    'full' => 'Plena',
    'sequential' => 'Secuencial',
    'tree_load_strategy' => 'Estratègia de càrrega dels arbres',
    'syslog_enable' => 'Registra els errors al <i> syslog </i> servidor',
    'syslog_host' => 'Nom del servidor Syslog o adreça IP',
    'syslog_port' => 'Port Syslog (predeterminat 514)',
    'error_bad_credentials' => 'Les credencials d’inici de sessió no es corresponen!',
    'settings_ldap_usergroup' => 'Grup LDAP per cercar',
    'settings_ldap_usergroup_tip' => 'Introduïu el grup LDAP al directori on es guarden els inicis de sessió de l&apos;usuari permesos. Exemple: cn = sysadmins, ou = grups, dc = exemple, dc = com',
    'server_password_change_enable' => 'Activa el canvi de contrasenya al servidor distant (mitjançant la connexió SSH)',
    'update_server_password' => 'Actualitza la contrasenya del servidor',
    'ssh_pwd' => 'Contrasenya SSH',
    'ssh_user' => 'Usuari SSH',
    'ssh_password_frequency_change_info' => 'Seleccioneu l’interval entre les actualitzacions de contrasenya automàtica del servidor (seleccionant 0 Desactivarà el canvi de contrasenya automàtica). <br /> Les actualitzacions automàtiques de contrasenya només es realitzaran si l’administrador del sistema també ha configurat la funció Cron de la funció d’actualització de contrasenya programada.',
    'ssh_password_frequency_change' => 'Freqüència de canvi de contrasenya (en mesos)',
    'ssh_scheduled_change' => 'Canvi programat',
    'ssh_one_shot_change' => 'Canvi únic',
    'server_password_change_enable_tip' => 'Aquesta configuració afegeix una opció a l&apos;element de la contrasenya per canviar automàticament la contrasenya d&apos;usuari en una adreça del servidor que figura a l&apos;URL. Això requereix que el servidor unix remot permeti iniciar la sessió d&apos;usuari i contrasenya mitjançant SSH. Els canvis automàtics de contrasenya programats es poden realitzar després d’afegir <i> /files/script.ssh.php </i> a Crontab per executar-se un cop al dia al servidor web de gestor de contrasenyes.',
    'error_bad_credentials_more_than_3_times' => 'Credencials d’inici de sessió incorrectes! <br> Si us plau, espereu 10 segons abans del següent intent',
    'settings_ldap_object_class' => 'Classe a cercar',
    'settings_ldap_object_class_tip' => 'Classe LDAP per cercar, com ara el compte d&apos;usuari o el compte POSIX',
    'rebuild_config_file' => 'Reconstruir el fitxer de configuració',
    'rebuild_config_file_tip' => 'El fitxer de configuració conté variables del sistema i s’utilitza quan es necessiten aquestes configuracions abans que s’hagi establert la connexió de base de dades. La reconstrucció del fitxer de configuració desa els valors de la base de dades al fitxer i es pot fer en qualsevol moment. La ubicació predeterminada és ./include/config/tp.config.php, però el fitxer s&apos;ha de situar fora del directori www per a la seguretat.',
    'error_folder_complexity_lower_than_top_folder' => 'Els subcarpetes han de tenir la força de contrasenya de la mateixa o superior a la carpeta pare',
    'new_item_email_body' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> Element nou \ &apos;#Label &apos; s&apos;ha creat a TeamPass. <br /> Podeu accedir-hi fent clic a aquest < A href = \ &apos;#enllaç#&apos;> enllaç </a>. <br/> <br /> Salutacions.',
    'failed_logins' => 'Inicis de sessió fallits',
    'error_only_numbers_in_folder_name' => 'L’etiqueta de la carpeta no pot ser només un número. Si us plau, doneu a la vostra carpeta un nom que inclogui lletres.',
    'encrypted_data' => 'Les dades es xifren a la base de dades',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'La vostra identificació de la targeta Agses',
    'ga_flash_qr_and_login' => 'Flash aquest codi QR amb el dispositiu mòbil, introduïu el codi d&apos;autenticació 2Factor i feu clic al botó "Enter".',
    'i_need_to_generate_new_ga_code' => 'Necessito un nou codi QR. Envieu-me per correu electrònic un codi d’identificació temporal.',
    'settings_manager_move_item' => 'Els gestors poden moure els elements que puguin veure',
    'user_folders_rights' => 'Carpetes visibles',
    'create_item_without_password' => 'Permet que l&apos;element es crei sense que es defineixi cap contrasenya',
    'share_rights_info' => 'Aquest quadre de diàleg us permet compartir els drets d’un usuari amb una selecció d’usuaris.',
    'share_rights_source' => 'Usuari d&apos;origen',
    'share_rights_destination' => 'Usuaris de destinació',
    'ga_reset_by_user' => 'L&apos;usuari pot restablir el seu codi 2FA',
    'ga_reset_by_user_tip' => 'Si està activat, l&apos;usuari tindrà la possibilitat de restablir el seu codi 2FA mitjançant l&apos;enllaç a la pàgina d&apos;inici de sessió. Això podria ser útil per si ha canviat de dispositiu mòbil, per exemple. Si no està activat, l’usuari haurà de demanar a l’administrador que generi un codi nou.',
    'enable_massive_move_delete' => 'Permet a l&apos;usuari realitzar un moviment massiu i eliminar les operacions',
    'enable_massive_move_delete_tip' => 'Quan està activada, aquesta opció permet a un usuari realitzar un moviment massiu i/o eliminar el funcionament en un mateix temps. L&apos;usuari només podrà realitzar-ho en els elements on se li permeti.',
    'mass_operation' => 'Funcionament massiu en elements',
    'move_items' => 'Moveu els elements seleccionats',
    'delete_items' => 'Suprimeix els elements seleccionats',
    'you_decided_to_move_items' => 'Heu decidit moure elements',
    'you_decided_to_delete_items' => 'Heu decidit suprimir elements',
    'suggest_password_change' => 'Suggeriu un canvi de contrasenya',
    'otv_is_enabled' => 'L&apos;usuari pot proposar enllaços únics',
    'error_source_and_destination_are_equal' => 'La font i la destinació no poden ser iguals!',
    'sending_anonymous_statistics' => 'Enviant estadístiques anònimes',
    'favourites_option_enabled' => 'Opció favorita activada',
    'personalfolders_option_enabled' => 'Opció de carpetes personals activada',
    'country_statistics' => 'Ús del mapa mundial',
    'country' => 'Pais',
    'users_statistics' => 'Nombre mitjà d’usuaris per instància',
    'items_all' => 'Tots els elements',
    'folders_all' => 'Totes les carpetes',
    'items_shared' => 'Tots els elements compartits (no inclosos els personals)',
    'folders_shared' => 'Totes les carpetes compartides (sense incloure-les personals)',
    'items_statistics' => 'Nombre mitjà d’elements per instància',
    'folders_statistics' => 'Nombre mitjà de carpetes per instància',
    'administrators_number' => 'Nombre d&apos;usuaris d&apos;administrador',
    'administrators_number_statistics' => 'Nombre mitjà d&apos;administradors per instància',
    'managers_number' => 'Nombre d’usuaris del gestor',
    'managers_number_statistics' => 'Nombre mitjà de gestors per instància',
    'readonly_number_statistics' => 'Nombre mitjà d’usuaris de només lectura per instància',
    'readonly_number' => 'Nombre d&apos;usuaris de només lectura',
    'mysql_version' => 'Versió MySQL',
    'php_version' => 'Versió PHP',
    'teampass_version' => 'Versió del pas d&apos;equip',
    'languages_used' => 'Idiomes utilitzats',
    'languages_statistics' => 'El llenguatge més utilitzat',
    'kb_option_enabled' => 'Activat l&apos;opció base de coneixement',
    'suggestion_option_enabled' => 'L&apos;opció de suggeriment activada',
    'customfields_option_enabled' => 'Opció de camps personalitzats activat',
    'api_option_enabled' => 'L&apos;opció API activada',
    '2fa_option_enabled' => 'Activat 2FaOption',
    'agses_option_enabled' => 'L&apos;opció Agses activada',
    'duo_option_enabled' => 'Opció de seguretat duo activada',
    'ldap_option_enabled' => 'L&apos;opció LDAP activada',
    'syslog_option_enabled' => 'L&apos;opció Syslog activada',
    'stricthttps_option_enabled' => 'L&apos;opció HTTPS estricta activada',
    'characteristic' => 'Característica',
    'current_value' => 'Valor actual',
    'communication_means' => 'Communication means',
    'consider_a_donation' => 'TeamPass és un projecte gratuït per a tothom. Ha requerit dies i dies de treball i encara requerirà tant com ja s’ha fet. Podeu considerar una donació o fins i tot convertir-vos en patrocinador.',
    'more_information' => 'Més informació',
    'feature_request_canal' => 'Per a les sol·licituds de funcions, utilitzeu',
    'bug_canal' => 'Per a errors, utilitzeu',
    'documentation_canal' => 'Complete documentation at',
    'sending_anonymous_statistics_details' => 'Es necessiten estadístiques per millorar el pas de Teampass, coneixent la població i l’ús dels usuaris. Les dades que proporcionareu només s’utilitzaran internament per a DataMining i no es distribuiran ni es vendran a cap tercer.',
    'item_has_change_proposal' => 'Aquest element té una proposta de canvi',
    'check_data_after_reencryption' => 'Comproveu les dades. Durant aquesta operació es va crear una nova taula <b> còpia de seguretat </b>.',
    'revert' => 'Revertir?',
    'revert_the_database' => 'Heu decidit revertir la base de dades. Siusplau confirma?',
    'bad_psk' => 'Aquesta Saltkey personal no és correcta.',
    'ldap_test_config' => 'Configuració actual de prova',
    'ldap_test_username' => 'Nom d&apos;usuari per utilitzar per a la prova',
    'ldap_test_username_pwd' => 'Usuari contrasenya',
    'feature_support_canal' => 'Per obtenir suport i ajuda, utilitzeu',
    'category' => 'Categoria',
    'text' => 'Text',
    'type' => 'Tipus',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Exportar',
    'settings_ldap_allowed_usergroup' => 'LDAP va permetre el grup d&apos;usuaris',
    'settings_ldap_allowed_usergroup_tip' => 'Indiqueu que el grup permeti connectar-se a TeamPass. Deixeu-ho buit no s’espera cap restricció pel que fa a l’adhesió del grup.',
    'error_security_level_not_reached' => 'Nivell de seguretat previst no assolit!',
    'personal_saltkey_security_level' => 'Nivell mínim de seguretat personal de Saltkey',
    'settings_disable_forgot_password_link' => 'Oculta l&apos;enllaç de la contrasenya oblidada a la pàgina d&apos;inici',
    'newly_created_user_is_administrated_by' => 'L&apos;usuari de nova creació és administrat per',
    'settings_ldap_and_local_authentication' => 'Usuaris locals i LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Activa aquesta opció per permetre als usuaris autenticats a la biblioteca LDAP o a la llista d’usuaris locals de TeamPass.',
    'enable_http_request_login' => 'Inici de sessió automàtica mitjançant les credencials de la capçalera HTTP',
    'duration_login_attempt' => 'Segons fins a la sessió automàtica:',
    'newly_created_user_role' => 'L’usuari de nova creació té un rol',
    'email_debug_level' => 'Seleccioneu un nivell de depuració',
    'email_debug_client' => 'Comandes del client',
    'email_debug_server' => 'Comandes del client i respostes del servidor',
    'email_debug_connection' => 'Comandes del client, respostes del servidor i estat de connexió',
    'email_debug_low_level' => 'Sortida de dades de baix nivell, tots els missatges',
    'email_debug_level_usage' => 'Aquesta configuració s&apos;ha d&apos;establir en cap. Només per utilitzar-se per a la depuració de correu electrònic durant la prova de les proves. Quan estigui activat, permetrà mostrar una sortida de les ordres de correu electrònic.',
    'email_body_temporary_login_password' => 'Hola, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> Un administrador ha canviat la contrasenya d’inici de sessió per TeamPass. La propera vegada que us connectareu a TeamPass, utilitzeu el següent: <br> <br> <b> #enc_code#</b> <br> <br> <br>',
    'your_new_password' => 'La vostra nova contrasenya',
    'user_specific_right' => 'Dret per un usuari específic',
    'icon' => 'Icona',
    'icon_on_selection' => 'Icona a la selecció',
    'fontawesome_icon_tip' => 'Podeu especificar un codi de Font Awesome de tipus de lletra seleccionat en icones lliures i sòlides. Deixeu buit per a la icona per defecte.',
    'settings_api_token_duration' => 'Retard de caducitat de JWT Token (en segons)',
    'settings_api_token_duration_tip' => 'El retard durant el cas generat el testimoni JWT és vàlid. Després d&apos;aquest retard, es demana que publiqui una sol·licitud d&apos;autorització a l&apos;API.',
    'show_encryption_code_to_admin' => 'Aquest és el codi xifrat que l&apos;usuari necessitarà en aquest inici de sessió. Heu demanat veure-ho, copieu-lo i compartiu-lo de manera segura. El codi és',
    'previous_password' => 'Contrasenya anterior que s&apos;utilitzava per connectar-se a TeamPass',
    'generate_new_otp' => 'Generar nous OTP',
    'generate_new_otp_informations' => 'Aquesta operació consisteix en generar des de zero totes les tecles per a l&apos;usuari seleccionat. Com a conseqüència, l&apos;usuari haurà de proporcionar el nou OTP generat al proper inici de sessió.',
    'html' => 'html',
    'execution_time' => 'Hora d&apos;execució',
    'maximum_number_of_items_to_treat' => 'Nombre màxim d’elements a tractar durant un cicle',
    'maximum_number_of_items_to_treat_tip' => 'Per tal d’assegurar la finalització del script sense temps d’espera, és possible definir un valor personal.',
    'maximum_time_script_allowed_to_run' => 'La durada en segons va permetre que el guió funcionés en segon pla',
    'maximum_time_script_allowed_to_run_tip' => 'De manera predeterminada, l&apos;script PHP no pot executar més que la durada definida pel paràmetre max_execution_time al fitxer php.ini. L’objectiu aquí és definir un valor més superior per assegurar-se que el guió funciona completament.',
    'refresh_data_every_on_screen' => 'Període refrescant de la pantalla (en segons)',
    'refresh_data_every_on_screen_tip' => 'Quan navegueu per la vista de les tasques, això permet tenir una llista actualitzada basada.',
    'refreshed' => 'Refrescat',
    'process_details' => 'Detalls del procés',
    'created_at' => 'Creat a',
    'updated_at' => 'Actualitzat a',
    'finished_at' => 'Acabat a',
    'tasks_manager' => 'Gestor de tasques',
    'tasks' => 'Tasques',
    'task_in_progress_user_not_active' => 'Tasques en curs: l&apos;usuari no està actiu',
    'enable_tasks_manager' => 'Activa les tasques de fons amb Cron Manager',
    'enable_tasks_manager_tip' => 'Aquesta opció s&apos;ha d&apos;activar si heu notat que algunes tasques triguen molt de temps. Això permet permetre gestionar aquestes tasques mitjançant un treball de fons realitzat pel servidor Cron Manager. Consulteu la documentació per obtenir més detalls.',
    'sync_new_ldap_password' => 'Sincronitzar una nova contrasenya',
    'error_new_ldap_password_detected' => 'Sembla que la vostra contrasenya ha canviat i TeamPass ho requereix per xifrar la clau privada de Master.',
    'settings_ldap_tls_certifacte_check' => 'Comprovació de certificats per a LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Especifica l&apos;estratègia de comprovació del certificat. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank"> Més informació </a>.',
    'user_keys_management' => 'Gestió de les claus d&apos;usuari',
    'sending_emails' => 'Enviant correus electrònics',
    'tasks_information' => 'La tasca es basa en una feina dedicada a Cron. Per a això, es demana que afegeixi una nova entrada al vostre crontab per executar el planificador TeamPass cada minut. Fonts/Scheduler.php </code> <br> <br> NOTA: Si us plau, adapteu la ruta a la ruta PHP (en la majoria dels casos, es pot substituir per <code> php </code>).',
    'bad_duo_mfa' => 'Codi Duo erroni',
    'creation_date' => 'Data de creació',
    'never' => 'Mai',
    'loading_main_page' => 'Carregant pàgina principal ...',
    'link' => 'Enllaç',
    'error_not_allowed_to_authenticate' => 'No teniu permès autenticar-vos',
    'enable_tasks_log' => 'Activa el registre de treballs de Cron',
    'enable_tasks_log_tip' => 'Permet registrar totes les tasques realitzades per la feina de Cron dins de la taula <i> processos_log </i>. Podria ser útil per comprovar els esdeveniments.',
    'items_and_folders_statistics' => 'Estadístiques d’elements i carpetes',
    'item_copying' => 'L&apos;element s&apos;està copiant',
    'upgrade_requested' => 'La base de dades TeamPass no està actualitzada.',
    'upgrade_requested_more' => 'S&apos;han identificat algunes incoherències entre els fitxers i la configuració, el vostre administrador hauria de realitzar un procés d&apos;actualització abans de continuar.',
    'settings_ldap_group_object_filter' => 'Filtre d&apos;objectes del grup LDAP',
    'settings_ldap_group_object_filter_tip' => 'Filtre LDAP per utilitzar per trobar l&apos;objecte del grup. Per exemple: (ObjectClass = Group1) (ObjectClass = Group2)',
    'settings_ad_users_with_ad_groups' => 'Els rols d’usuari d’AD es mapegen amb els seus grups d’AD',
    'settings_ad_users_with_ad_groups_tip' => 'Permet mapar els rols d’usuari d’AD amb els seus grups d’AD. Aquests rols s’afegiran al definit al seu perfil.',
    'settings_ad_user_auto_creation' => 'L&apos;usuari de AD es crea automàticament',
    'settings_ad_user_auto_creation_tip' => 'Permet que un usuari d&apos;AD es crei automàticament a TeamPass quan inicia la sessió per primera vegada. Observeu que si els rols d’usuari d’AD d’opcions es mapegen amb els grups AD habilitats, obtindrà els rols mapejats amb els seus grups d’AD.',
    'settings_ldap_guid_attibute' => 'Atribut LDAP Guid',
    'settings_ldap_guid_attibute_tip' => 'Atribut LDAP a utilitzar per identificar el guia d’un objecte. Per exemple: ObjectGuid, ObjectSID, Guid, Gidnumber, ...',
    'ad_group' => 'Grup d&apos;AD',
    'mapped_with_role' => 'Maped amb el rol',
    'ad_groupe_and_roles_mapping' => 'Mapeig de grups de AD i rols',
    'select_adgroup_mapping' => 'Seleccioneu el rol per mapar amb el grup d&apos;AD actuals',
    'enable_backlog_mail' => 'Activa l&apos;enviament de correus electrònics de backlog',
    'provide_label' => 'Indiqui un text',
    'uploading' => 'Carregant ...',
    'keys_encryption_not_ready' => 'Informeu-vos que actualment les tecles de contrasenya estan en procés de creació. Espereu uns minuts més.',
    'account_not_ready' => 'Compte en la construcció',
    'add_new_job' => 'Afegiu una nova feina',
    'tasks_cron_not_running' => 'El treball de Cron no està definit. Editeu Crontab amb el vostre usuari del servidor (normalment www-data) amb la comanda <code> crontab-u www-data-e </code>. <br> o premeu el botó per provar la seva creació automàticament.',
    'tasks_cron_running' => 'Cron Job es defineix correctament',
    'currently_using_version' => 'La versió actual es carrega',
    'git_commit_value' => 'Git Commit Value',
    'generate_new_keys' => 'Generar noves claus',
    'generate_new_keys_info' => 'Continuant, generareu noves claus de xifratge per a tots els objectes als quals tingueu accés. Això només s&apos;ha de fer si no teniu cap contrasenya.',
    'generate_new_keys_end' => 'El procés està en marxa i podria trigar diversos minuts. Ara podeu tancar aquesta finestra.',
    'confirm_password' => 'Necessitem que confirmeu la vostra contrasenya',
    'no_code_is_requested' => 'No es demana cap codi.',
    'user_encryption_ongoing' => 'Actualment s’està xifant el compte. La vostra sol·licitud no pot continuar. Espereu fins que s’acabi.',
    'teampass_information' => 'Informació de Teampass',
    'show_password' => 'Ensenya la contrasenya',
    'new_user_info_by_mail' => 'Un nou usuari rebrà un correu electrònic amb les seves credencials',
    'login_credentials' => 'Credencials d’inici de sessió',
    'email_body_user_config_1' => 'Hola #LastName #, <br> <br> Aquest és un correu electrònic generat del gestor de contrasenyes TeamPass. <br> <br> Seguir les credencials següents es preveu la propera vegada que utilitzi TeamPass: <ul> <li> Inici de sessió: #login #</li > <li> Contrasenya: #Password #</li> <li> Codi de xifrat: #code #</li> </ul> <br> <br> <br>',
    'email_body_user_config_3' => 'Hola#LastName#, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> La següent contrasenya s&apos;espera la propera vegada que utilitzi TeamPass: <br> <br> <b> #Password#</s b> <br> <br> <br> Salutacions',
    'email_body_user_config_4' => 'Hola #LastName #, <br> <br> Aquest és un correu electrònic generat del gestor de contrasenyes de TeamPass. <br> <br> El vostre compte TeamPass està completament a punt. <br> <br> Salutacions',
    'email_body_user_config_5' => 'Hola#LastName#, <br> <br> Aquest és un correu electrònic generat de TeamPass Passwords Manager. <br> <br> El següent codi s&apos;espera la propera vegada que utilitzi TeamPass: <br> <br> <b> #code#</s B> <br> <br> <br> Salutacions',
    'email_body_user_config_6' => 'Hola #LastName #, <br> <br> Aquest és un correu electrònic generat del gestor de contrasenyes TeamPass. <br> <br> Seguir les credencials següents es preveu la propera vegada que utilitzi TeamPass: <ul> <li> Inici de sessió: #login #</li > <li> Contrasenya: #Password #</li> </ul> <br> <br> <br> Salutacions',
    'error_data_not_valid' => 'Les dades no són vàlides',
    'mfa_enabled' => 'MFA activat',
    'mfa_disabled_for_user' => 'MFA desactivat per a l&apos;usuari',
    'users_personal_folder' => 'Carpeta personal dels usuaris',
    'maintenance_operations' => 'Operacions de manteniment',
    'maintenance_operations_tip' => 'Operacions de manteniment seleccionades a la base de dades TeamPass.',
    'purge_temporary_files' => 'Purga fitxers temporals',
    'task_scheduling' => 'Programació de tasques',
    'parameter' => 'Paràmetre',
    'frequency' => 'Freqüència',
    'in_minutes' => 'en minuts',
    'hourly' => 'Per hora',
    'daily' => 'Cada dia',
    'clean_orphan_objects' => 'Neteja objectes orfes',
    'run_once' => 'Fer funcionar una vegada',
    'run_weekday' => 'Córrer el dia de la setmana',
    'monday' => 'Dilluns',
    'tuesday' => 'Dimarts',
    'wednesday' => 'Dimecres',
    'thursday' => 'Dijous',
    'friday' => 'Divendres',
    'saturday' => 'Dissabte',
    'sunday' => 'Diumenge',
    'monthly' => 'Mensual',
    'day_of_month' => 'Dia del mes',
    'day' => 'Dia',
    'reset' => 'Reset',
    'error_while_creating_file' => 'Error en crear fitxer',
    'new_keys_generated' => 'Noves claus generades',
    'user_creation' => 'Creació dels usuaris',
    'user_deletion' => 'Supressió de l&apos;usuari',
    'maximum_session_expiration_time' => 'Temps màxim de caducitat de la sessió',
    'maximum_session_expiration_time_tip' => 'Temps màxim en minuts Una sessió pot ampliar-se per un usuari',
    'index_session_duration_too_long' => 'La durada de la sessió és massa llarga',
    'extend_session_duration_by' => 'Ampliar la durada de la sessió per',
    'settings_ldap_user_dn_attribute' => 'Nom distingit de l&apos;usuari',
    'settings_ldap_user_dn_attribute_tip' => 'L’etiqueta d’atributs del nom distingit de l’usuari (DN) a AD. <br> Exemple: per a OpenLDAP: DN. Per a Active Directory: DistinguishedName.',
    'open_tasks_settings' => 'Obriu la configuració de les tasques',
    'maximum' => 'màxim',
    'updated' => 'Actualitzat',
    'number_of_days' => 'Nombre de dies',
    'number_of_times' => 'Nombre de vegades',
    'sharekey_not_ready' => 'ShareKey encara no es va generar ... és possible que totes les dades de l&apos;element no estiguin a punt ... proveu-ho més tard',
    'item_action_not_yet_possible' => 'Acció encara no és possible en aquest element',
    'open' => 'Obrir',
    'reload_user_cache_table' => 'Torna a carregar la taula de memòria cau de l&apos;usuari',
    'send_email_to_user' => 'Enviar correu electrònic a l&apos;usuari',
    'items_management' => 'Items operations',
    'previously_used_passwords' => 'Previously used passwords',
    'next_passwords_were_valid_until_date' => 'Next passwords were valid until date',
    'feature_disabled_by_administrator' => 'Feature disabled by administrator',
    'shared_globaly' => 'Shared globaly',
    'settings_otv_subdomain' => 'OTV subdomain name',
    'settings_otv_subdomain_tip' => 'Dedicated subdomain for onetime links. Considere your main Teampass URL as isolated from internet, this subdomain could be reachable by everyone to share this item with someone outside your organisation. From security perspective it is a lot safer with such mechanics. Note: This would requite to have a DNS entry for this subdomain pointing to your Teampass server.',
    'existing_valid_otv_links' => 'OTV valid links',
    'started' => 'Started',
    'recovery_keys_not_downloaded' => 'Recovery keys not downloaded',
    'no_recovery_keys' => 'I do not have recovery keys. This will clear all passwords from my personal items.',
    'provide_recovery_keys' => 'Provide your recovery keys',
    'public_key' => 'Public key',
    'private_key' => 'Private key',
    'download_recovery_keys' => 'Download your recovery keys',
    'download_recovery_keys_confirmation' => 'You are about to download your recovery keys. Please store them in a safe place as they should be mandatory in case of disaster.',
    'recovery_keys_download_date' => 'Recovery keys download date',
    'keys_not_recovered' => 'Public and Private keys not stored',
    'keys_not_recovered_explanation' => 'In order to prevent against any passwords lost, you should store safely your personal Teampass keys',
    'get_your_recovery_keys' => 'Get your recovery keys',
    'keys_management' => 'Keys management',
    'please_confirm_task_to_be_run' => 'Please confirm the task to be performed',
    'user_keys_downloaded' => 'User keys downloaded',
    'mfa_code_send_by_email' => 'MFA code sent by email',
    'otp' => 'OTP',
    'otp_code' => 'OTP code',
    'enabled_otp_for_item' => 'Enable OTP code',
    'at_otp_status' => 'OTP status',
    'phone_number' => 'Related phone number (optional)',
    'otp_secret' => 'OTP secret key',
    'settings_ldap_group_objectclasses_attibute' => 'AD Group ObjectClasses attribute',
    'settings_ldap_group_objectclasses_attibute_tip' => 'The objectClasses to use when searching for groups. Several objectClasses are separated by a comma (,). Example: groupOfNames,group or top,posixGroup',
    'display_warning_icons' => 'Display warning icons',
    'password_length_by_default' => 'By default password length',
    'progress' => 'Progress',
    'tasks_log_retention_delay_in_days' => 'Tasks log retention delay (in days)',
    'tasks_log_table_size' => 'Tasks log table size',
    'error_otp_secret' => 'Enable to decode the OTP secret, is the secret correct?',
    'users_api_access_info' => 'Users can access the API with same access rights as in Teampass.',
    'error_folder_not_allowed_for_this_user' => 'Folder is not allowed for this user',
    'allowed_to_create' => 'Allowed to create',
    'allowed_to_read' => 'Allowed to read',
    'allowed_to_update' => 'Allowed to update',
    'allowed_to_delete' => 'Allowed to delete',
    'folder_created' => 'Folder created',
    'login_with_sso' => 'Login with SSO',
    'server_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet' => 'Server is connected to internet',
    'server_not_connected_to_internet_tip' => 'This could lead to several functionnalities not working properly. Especially MFA',
    'tools' => 'Tools',
    'user_config_not_compliant' => 'User configuration is not compliant',
    'fix_personal_items_empty' => 'Fix personal items are empty',
    'fix_personal_items_empty_tip' => 'This tool permits to fix the issue where personal items are empty after a Teampass upgrade. It requires to have restored a copy of table teampass_items from Teampass version 2. The table needs to be named teampass_items_v2.',
    'table_not_exists' => 'Expected table does not exist. Please restore it from a backup.',
    'tools_usage_warning' => 'Using tools can have a direct impact on the database. Please be careful. Always perform a dump before and define a maintenance period.',
    'select_user' => 'Select user',
    'show_item_data' => 'Show item data in items list',
    'show_item_data_tip' => 'Permits to display extra information in the items list (username, email and url). This could be useful to have a quick view of the item content.',
    'items_page_split_view_mode' => 'Show item details in page split view mode',
    'replace_tenant_id' => 'Adapt the URL but keep {tenant-id} as is. It will be replaced live by the tenant ID.',
    'user_exists_but_not_oauth2' => 'User has to authenticate using Entra/Azure AD',
    'user_not_allowed_to_auth_to_teampass_app' => 'User is not allowed to authenticate with Teampass application',
    'user_is_not_auth_with_oauth2' => 'User should not authenticate with Entra/Azure AD',
    'highlight_favorites' => 'Highlight favorites',
    'highlight_favorites_tip' => '',
    'limited_search_default' => 'Limited search selected by default',
    'limited_search_default_tip' => '',
    'highlight_selected_tip' => '',
    'encryptClientServer' => 'Encrypt client-server exchanges',
    'encryptClientServer_tip' => 'When enabled, the client encrypts the data before sending it to the server. The server only stores encrypted data. It can be disabled.',
    'oauth2_client_urlResourceOwnerDetails' => 'URL to get user details',
    'oauth2_client_urlResourceOwnerDetails_tip' => 'URL to get user details. It is used to get user details after authentication.',
    'duo_redirect_uri' => 'Redirecting to Duo Prompt',
    'number_users_build_cache_tree' => '',
    'number_users_build_cache_tree_tip' => 'Number of users processed for build_cache_tree task at each run of the scheduler.',

);
