<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.6
 * @file      spanish.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Mostrar el código de cifrado del usuario',
    'email_body_new_user' => 'Hola,<br><br>Este es un correo generado desde Teampass passwords manager.<br><br>Un administrador ha creado una cuenta de usuario para tí en Teampass. En la siguiente ocasión que te conectes a Teampass, usa las siguientes credenciales:<ul><li>login: #login#</li><li>Contraseña: #password#</li><li>Código de cifrado: #code#</li></ul><br><br><br>Saludos',
    'user_password' => 'Contraseña de usuario',
    'user_temporary_encryption_code' => 'Código de cifrado de usuario',
    'no_email_set' => 'No se ha registrado ningún correo electrónico',
    'send_user_password_by_email' => 'Elige si la contraseña de inicio de sesión del usuario debería enviarse por correo electrónico.<br>En caso de ser así, presiona el botón «Enviar».<br><br>Si no, utiliza el botón «Copiar» al portapapeles para enviarla al usuario por otro medio.<br>Es tu responsabilidad como administrador proporcionar al usuario la contraseña de manera segura.',
    'admin_change_user_encryption_code_info' => 'Esta operación restablecerá el código de cifrado para este usuario.',
    'send_by_email' => 'Enviar por correo electrónico',
    'filters' => 'Filtros',
    'show_user_password' => 'Mostrar contraseña de usuario',
    'open_website' => 'Abrir sitio web',
    'mfa_for_roles' => 'Se solicita MFA para los usuarios en roles',
    'mfa_for_roles_tip' => 'De manera predeterminada, una vez que se selecciona un método MFA, se activa para todos los usuarios. Sin embargo, puedes seleccionar los roles esperados.<br>AÚN NO SE HA IMPLEMENTADO',
    'at_least_one_administrator_is_requested' => 'Se solicita al menos un administrador',
    'bad_code' => 'Código incorrecto',
    'generating_keys' => 'Generar claves',
    'this_may_take_time' => 'Esto puede llevar un par de minutos',
    'disable_enable' => 'Desactivar / Activar',
    'user_disable_status' => 'Marca la casilla para desactivar o déjala vacía para activar',
    'help_for_launching_items_encryption' => 'Necesitamos generar la base de datos de claves para tu cuenta. Proporciona tu código de cifrado.',
    'managed_through_ad' => 'Gestionado a través de AD',
    'new_ldap_user_info' => 'Completa la definición de usuario',
    'email_body_user_added_from_ldap_encryption_code' => 'Hola,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>Ahora tienes una cuenta en Teampass. Puedes utilizar tus credenciales DA para iniciar la sesión.<br><br>En el primer inicio de sesión, se espera un código de cifrado de ti, por favor, utiliza:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'settings_ldap_user_object_filter' => 'Filtro de objetos del usuario',
    'settings_ldap_user_object_filter_tip' => 'El filtro a utilizar en la búsqueda de objetos de usuario. Ejemplo: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Este valor se utiliza además del DN base al buscar y cargar usuarios. Si no se proporciona ningún valor, la búsqueda en el subárbol comenzará desde el DN base. Ejemplos: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'DN de usuario adicional',
    'ldap_user_has_changed_his_password' => 'Tu contraseña de autentificación ha sido cambiada en tu DA desde la última vez que te conectaste en Teampass. Necesitamos adaptar tu clave de cifrado. Por favor, indica tu contraseña anterior y la actual.',
    'provide_your_previous_password' => 'Tu contraseña anterior',
    'admin_change_user_password_info' => 'Esta operación restablecerá la contraseña actual del usuario seleccionado.',
    'sending_email_message' => 'Enviando el correo electrónico al usuario, por favor espera',
    'change_your_password_info_message' => 'Indica tu nueva contraseña de autentificación y confírmala.',
    'user_has_to_change_password_info' => 'La contraseña actual ha sido generada. Se espera que la cambies por motivos de seguridad.',
    'ready_to_go' => 'Listo para empezar',
    'passwords_not_the_same' => 'Las contraseñas proporcionadas no son las mismas',
    'inititialization' => 'Inicialización',
    'bad_password' => 'Contraseña incorrecta',
    'perform_checks' => 'Realizar comprobaciones',
    'email_body_temporary_encryption_code' => 'Hola,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>e han realizado algunos cambios en tu cuenta que requieren una nueva codificación de los elementos para la seguridad de los datos. La próxima vez que conectes a Teampass, utiliza el siguiente código:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'temporary_encryption_code' => 'Tu código de cifrado temporal',
    'renecyption_expected' => 'Tenemos que volver a cifrar tus claves para que se ajusten a los privilegios correspondientes a tu cuenta y derechos.',
    'error_no_user_in_ad' => '¡Usuario no encontrado en DA!',
    'error_ad_user_expired' => '¡El usuario ha caducado!',
    'error' => 'Error detectado',
    'hosts' => 'Anfitriones',
    'settings_ldap_hosts_tip' => 'La opción de hosts es una matriz de direcciones IP o nombres de hosts ubicados en tu red que sirven a un directorio LDAP (separados por una coma). Puedes insertar tantos servidores o tan pocos como quieras dependiendo de tu bosque (con el mínimo de uno, por supuesto).',
    'base_distiguished_name' => 'DN base',
    'settings_ldap_bdn_tip' => 'El nombre distintivo (DN) de root que se utilizará cuando se realicen consultas en el servidor de directorios. Ejemplos: o=ejemplo,c=com ; cn=usuarios,dc=ad,dc=ejemplo,dc=com',
    'username' => 'Nombre de usuario',
    'settings_ldap_username_tip' => 'El nombre distintivo del usuario que la aplicación utilizará cuando se conecte al servidor de directorios. Ejemplos: cn=administrador,cn=usuarios,dc=ad,dc=ejemplo,dc=com ; cn=usuario,dc=dominio,dc=nombre',
    'settings_ldap_password_tip' => 'La contraseña del usuario especificado arriba.',
    'settings_ldap_port_tip' => 'Puerto LDAP no seguro predeterminado: 389, puerto LDAP seguro predeterminado: 636',
    'undefined' => 'Indefinido',
    'error_cannot_open_file' => 'No se puede abrir el archivo',
    'provide_current_psk_and_click_launch' => 'Cuando esté listo, pulse el botón Iniciar',
    'start' => 'Inicio',
    'data_inconsistency' => 'Se ha encontrado una incoherencia en los datos. Por favor, ¡recarga la página!',
    'one_time_code_expected' => 'Código-Único esperado',
    'data_are_missing' => 'Faltan los datos esperados',
    'one_time_code' => 'Código-Único',
    'provide_personal_one_time_code' => 'Indique el código-único que has recibido por correo electrónico',
    'change_authentification_type_to_ldap' => 'Cambiar el tipo de autenticación a LDAP',
    'change_authentification_type_to_local' => 'Cambiar el tipo de autenticación a la base de datos local de Teampass',
    'ldap_user_password_is_used_for_authentication' => 'La contraseña del usuario en LDAP se utiliza para la autenticación',
    'local_user_password_is_used_for_authentication' => 'La contraseña del usuario en Teampass se utiliza para la autenticación',
    'provide_your_current_password' => 'Indica tu contraseña actual',
    'current_password' => 'Contraseña actual',
    'password_is_not_correct' => 'Esta contraseña no es correcta',
    'ldap_password_change_warning' => 'Tu contraseña de acceso ha cambiado desde la última conexión. Se solicita volver a cifrar todas las claves utilizando esta nueva contraseña. Para esta operación, rellena el siguiente campo con tu anterior contraseña ldap. La operación puede durar varios minutos.',
    'personal_items' => 'Elementos personales',
    'logout_on_going' => 'Ahora se cerrará la sesión. Utiliza tu nueva contraseña para conectarte a partir de ahora.',
    'fill_in_fields_and_hit_launch' => 'Proporciona los datos esperados y pulsa el botón de inicio',
    'please_select_a_folder' => 'Por favor, selecciona una carpeta',
    'user_must_have_login_and_email' => 'El usuario debe tener un nombre de usuario y un correo electrónico',
    'user_has_this_role_in_teampass' => 'El usuario tiene este rol en Teampass',
    'select_role_to_create' => 'Elegir rol a crear',
    'adding_ldap_role_to_teampass' => 'Puedes decidir crear un rol en Teampass a partir de tu Directorio Activo. Esto permitirá asociar al usuario a este rol en Teampass.',
    'add_user_to_role' => 'Añadir este rol al usuario en Teampass',
    'add_user_in_teampass' => 'Añadir usuario en Teampass',
    'synchronized' => 'Sincronizado',
    'output' => 'Salida',
    'remove_install_folder' => 'La carpeta de instalación debe ser eliminada',
    'list_users' => 'Listar usuarios',
    'ldap_synchronization' => 'Sincronización LDAP',
    'in_progress' => 'En progreso',
    'clipboard_password_life_duration' => 'Retraso antes de que se borre el portapapeles (en segundos)',
    'clipboard_password_life_duration_tip' => 'Permite definir un retardo en segundos antes del cual la contraseña copiada en el portapapeles se borrará del portapapeles del navegador. Si se establece en 0, se desactiva.',
    'clipboard_will_be_cleared' => 'La contraseña está ahora en el portapapeles. Pronto se borrará...',
    'file_folder_not_accessible' => 'Carpeta de archivos no es accesible',
    'error_missing_id' => 'Se ha producido un error. Falta el ID ... ?',
    'error_folder_not_allowed' => 'La carpeta seleccionada no está permitida',
    'all_fields_mandatory' => 'Todos los campos son obligatorios',
    'history_insert_entry' => 'Insertar en la historia',
    'clear_form' => 'Borrar formulario',
    'info_about_history_insertion' => 'Precaución - Esta función permite insertar manualmente un evento en el registro del historial de artículos. Una vez añadido no será posible eliminarlo. Ten en cuenta también que el ID de tu cuenta se asociará a esta nueva entrada.',
    'select_all' => 'Seleccionar todo',
    'unselect_all' => 'Deseleccionar todo',
    'no_data_to_display' => '¡No hay datos para mostrar! O bien no existe ninguna carpeta, o bien no hay acceso a ninguna de ellas.',
    'server' => 'Servidor',
    'data_refreshed' => 'Datos actualizados',
    'loading_image' => 'Cargando imagen',
    'compare_with_another_role' => 'Comparar con otro rol',
    'only_display_folders_to_depth' => 'Mostrar sólo las carpetas hasta la profundidad',
    'propagate_rights_to_descendants' => 'Propagar los derechos a los descendientes',
    'loading_data' => 'Cargando datos',
    'password_overview_delay' => 'Retraso en el resumen de contraseñas',
    'password_overview_delay_tip' => 'Este ajuste permite definir el número de segundos que se mostrará al usuario la contraseña en claro.',
    'select_date_showing_items_expiration' => 'Enumerar los artículos caducados en la fecha',
    'renewal_page_info' => 'Esta página permite identificar los artículos que han caducado o que caducan en el próximo periodo.',
    'filename' => 'Nombre del archivo',
    'exported_to_file' => 'Exportado al archivo',
    'operation_progress' => 'Operaciones en progreso',
    'exporting_items' => 'Exportando elementos',
    'select_folders_to_export' => 'Selecciona las carpetas a exportar',
    'export_format_type' => 'Seleccione el tipo de formato de exportación',
    'export_items' => 'Exportar elementos',
    'loading_item' => 'Cargando elemento',
    'otv_message' => 'Puedes compartir este elemento con alguien sin una cuenta Teampass. La vista única permite a tu invitado acceder a los campos básicos de este artículo sólo una vez sin estar autentificado en Teampass. Ten en cuenta que este enlace es válido durante un período de ##otv_expiration_period## días. Copia y comparte el enlace a continuación.',
    'no_sharekey_found' => 'No se ha encontrado ninguna clave para este archivo y tu cuenta',
    'otv_link' => 'Enlace de una-sola-vista',
    'one_time_view' => 'Una-sola-vista',
    'move_right_columns_separator' => 'Mover el separador de columnas a la derecha',
    'move_left_columns_separator' => 'Mover el separador de columnas a la izquierda',
    'form_presents_inconsistencies' => 'El formulario presenta algunas inconsistencias. Por favor, comprueba los campos con bordes rojos.',
    'download' => 'Descargar',
    'see' => 'Ver',
    'at_anyoneconmodify' => 'Cualquiera puede modificar',
    'disabled' => 'Deshabilitado',
    'enabled' => 'Habilitado',
    'confirmation_seems_wrong' => 'La confirmación parece errónea, por favor corrijelo',
    'i_cannot_remember' => 'No puedo recordar',
    'i_cannot_remember_info' => 'Esta acción es sin reversión. Borrará las contraseñas almacenadas en tus elementos personales. Los elementos no se borrarán, sino sólo sus contraseñas. Si no puedes recordar tu clave de acceso personal, esta es la única opción.',
    'user_has_psk_info' => 'Hemos identificado que tienes algunos objetos personales codificados con una antigua saltkey personal. El objetivo de este paso es volver a cifrarlos con tu nueva clave privada. Por favor, facilítanos tu saltkey personal.',
    'files' => 'Archivos',
    'logs' => 'Logs',
    'suggestions' => 'Sugerencias',
    'encryption_keys' => 'Claves de cifrado',
    'clearing_old_sharekeys' => 'Borrando las antiguas sharekeys',
    'hit_launch_to_start' => 'Clic en el botón de inicio para comenzar, por favor',
    'password_changed' => 'Conrtaseña actualizada',
    'password_already_used' => 'Contraseña ya utilizada',
    'change_login_password' => 'Cambiar la contraseña de acceso',
    'current_password_mandatory' => 'La contraseña actual es obligatoria',
    'objects_encryption_explanation' => 'Teampass ha sido actualizado a una nueva versión que incluye un nuevo protocolo de cifrado. Se espera que vuelvas a cifrar tus objetos personales. Para ello, debes proporcionar tu Saltkey (PSK) actual. Una vez que la hayas proporcionado, haz clic en el botón de inicio y espera hasta que el proceso llegue al paso final. Esto puede tardar varios minutos dependiendo del número de objetos.',
    'description_has_changed' => 'La descripción ha cambiado',
    'number_of_folders_imported' => 'Número de carpetas importadas',
    'number_of_items_imported' => 'Número de elementos importados',
    'propagate' => 'Propagar',
    'propagate_user_rights' => 'Propagar los derechos de los usuarios',
    'register_new_yubiko_key' => 'Registrar una nueva clave Yubiko',
    'part_of_groups' => 'Parte de los grupos',
    'previous_value' => 'Valor anterior',
    'no_previous_value' => 'Sin valor anterior',
    'no_data_selected' => 'No hay datos seleccionados',
    'selected_items_to_be_imported' => 'Elementos seleccionados para ser importados',
    'cannot_open_file' => 'No se puede abrir el archivo',
    'no_item_found' => 'No se encontró elemento',
    'reading_file' => 'Leyendo archivo',
    'where_shall_items_be_created' => 'Dónde se crearán los artículos',
    'target_folder' => 'Carpeta de destino',
    'select_file' => 'Elegir archivo',
    'data_type_for_import' => 'Comienza por seleccionar el tipo de datos que deseas importar',
    'get_tips_about_importation' => 'Obten consejos sobre la importación',
    'import_new_items' => 'Importar nuevos elementos',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'para',
    'request_access' => 'Solicitud de acceso al Elemento',
    'request_access_message' => 'Cuando se solicita el acceso a un artículo, se envía un correo electrónico al autor. El autor aceptará o rechazará la solicitud añadiéndola a la lista de restricción de artículos. Confirma el envío de tu solicitud por correo electrónico al autor.',
    'request_access_reason' => 'Indica al autor el motivo de tu solicitud',
    'error_provide_reason' => 'Por favor, indica la razón por la que deseas acceder a este elemento',
    'need_access' => '¿Necesitas acceso?',
    'item_with_restricted_access' => 'Elemento de acceso restringido',
    'remaining_emails_to_send' => 'Correos electrónicos que quedan por enviar',
    'mfa_flash' => 'Flash con tu dispositivo móvil',
    'import' => 'Importar',
    'export' => 'Exportar',
    'offline' => 'Fuera de línea',
    'login_attempts_identified_since_last_connection' => 'Se requiere tu atención. Se ha identificado al menos un intento de inicio de sesión con tu cuenta desde la última conexión con éxito. Por favor, comprueba e informa a tu administrador local si no eres el autor.',
    'last_login_attempts' => 'Últimos intentos de acceso',
    'see_detail' => 'Ver detalle',
    'role_definition' => 'Definición del rol',
    'not_yet_implemented' => 'Aún no se ha implementado',
    '2factors_expected_for_admin' => 'El administrador requiere AMF para iniciar la sesión',
    '2factors_expected_for_admin_tip' => 'Por defecto, un Administrador tiene que utilizar un método AMF para poder iniciar la sesión. Si no está habilitado, el administrador no lo requerirá para iniciar la sesión, incluso si AMF está habilitado para cualquier otro usuario.',
    'restore_done_now_logout' => 'La restauración de la base de datos se ha realizado. Ahora debes desconectarte para refrescar las variables de sesión.',
    'backup_and_restore' => 'Copia de seguridad y Restauración',
    'explanation_for_oneshot_backup' => 'explicación_de_la_copia_de_respaldo_unica',
    'explanation_for_oneshot_restore' => 'explicación_de_la_restauración_unica',
    'perform_backup' => 'Realizar copia de seguridad',
    'perform_restore' => 'Realizar restauración',
    'backup_select' => 'Archivo de copia de seguridad',
    'choose_file' => 'Seleccionar archivo',
    'on_the_fly' => 'Al vuelo',
    'scheduled' => 'Programado',
    'caution_on_field_encryption_change' => 'Precaución - Ten en cuenta que para cambiar el tipo de cifrado será necesario analizar todos los datos existentes para cambiar el cifrado en la base de datos.',
    'caution_while_deleting_field' => 'Precaución - La eliminación de este campo también borrará los datos relacionados en los artículos.',
    'error_could_not_update_the_field' => 'Error - El campo no ha podido ser actualizado. Por favor, vuelve a intentarlo después de recargar la página.',
    'caution_while_deleting_category' => 'Precaución - Al eliminar esta carpeta se borrarán todos los campos que le pertenecen y también todos los datos relacionados con los campos.',
    'your_attention_please' => 'Atención, por favor',
    'all_fields_are_required' => 'Todos los campos son obligatorios',
    'position' => 'Posición',
    'before' => 'Antes',
    'top' => 'Arriba',
    'bottom' => 'Abajo',
    'field' => 'Campo',
    'configuration' => 'Configuración',
    'definition' => 'Definición',
    'number_of_modified_attachments' => 'Número de adjuntos modificados',
    'files_not_encrypted' => 'Actualmente los archivos no están cifrados. Se debe realizar este cambio por razones de seguridad.',
    'files_already_encrypted' => 'Los archivos ya están cifrados. No debes cambiar esto por razones de seguridad.',
    'action_to_be_performed' => 'Acción a realizar',
    'last_execution' => 'Última ejecución',
    'never_performed' => 'Nunca realizado',
    'launch' => 'Iniciar',
    'set_of_actions' => 'Conjunto de acciones',
    'uploads' => 'Cargas',
    'uploads_configuration' => 'Configuración de cargas',
    'email_configuration' => 'Configuración de correo electrónico',
    'email_configuration_test' => 'Prueba de configuración del correo electrónico',
    'send_a_test_email' => 'Enviar un correo electrónico de prueba',
    'manage_emails_not_sent' => 'Gestionar los correos electrónicos no enviados',
    'email_send_backlog' => '#nb_emails# correos electrónicos no enviados',
    'send_waiting_emails' => 'Enviar correos electrónicos en espera',
    'ip' => 'IP',
    'no_data_defined' => 'No se ha definido ningún dato',
    'adding_new_api_ip' => 'Añadir una nueva IP a la lista blanca',
    'adding_new_api_key' => 'Agregando una nueva clave API',
    'api_configuration' => 'Configuración API',
    'mfa_configuration' => 'Configuración AMF',
    'yubico_authentication_tip' => 'Para más información, visita www.yubico.com.',
    'complexity_level_not_reached' => 'No se alcanza el nivel de complejidad',
    'expected_complexity_level' => 'Nivel de complejidad esperado',
    'your_attention_is_required' => 'Se requiere tu atención',
    'favorite' => 'Favorito',
    'unfavorite' => 'Desfavorable',
    'you_need_to_select_at_least_one_folder' => 'Debes seleccionar al menos una carpeta',
    'no_value_defined_please_fix' => '¡No se ha definido ningún valor! Por favor, arréglalo.',
    'apply' => 'Aplicar',
    'from' => 'Desde',
    'please_confirm_by_clicking_checkbox' => 'Por favor, confirma haciendo clic en la casilla de verificación',
    'date_range' => 'Rango de fechas',
    'purge' => 'Purgar',
    'belong_of_deleted_folder' => 'Pertenece a la carpeta eliminada',
    'highlight_selected' => 'Resaltar lo seleccionado',
    'number_of_selected_objects' => 'Número de objetos seleccionados',
    'confirm_selection_restore' => 'Por favor, confirma la restauración de los artículos seleccionados.',
    'confirm_selection_delete' => 'Por favor, confirma la eliminación de los elementos seleccionados.',
    'refreshing' => 'Actualizando',
    'empty_list' => 'Lista vacía',
    'deleted_folders' => 'Carpetas eliminadas',
    'deleted_items' => 'Elementos eliminados',
    'recycled_bin' => 'Papelera de reciclaje',
    'database' => 'Base de datos',
    'renewal' => 'Renovación',
    'renewal_delay' => 'Retraso en la renovación',
    'please_confirm_deletion' => 'Por favor, confirma el borrado',
    'caution' => 'Precaución',
    'role_not_exist' => '¡Este rol no existe!',
    'role_can_edit_any_visible_item' => 'El rol puede editar cualquier elemento visible',
    'role_can_edit_any_visible_item_tip' => 'La configuración normal es dejar esta casilla sin marcar. De hecho, cuando está marcada, permitirá a un usuario que forme parte de este rol editar cualquier elemento que el usuario pueda abrir, lo que lleva a un estado inseguro. Sólo debería estar marcada durante un periodo de tiempo y necesidad específicos.',
    'edit_allowed' => 'Edición permitida',
    'delete_allowed' => 'Eliminación permitida',
    'add_allowed' => 'Adición permitida',
    'edit_not_allowed' => 'Edición no permitida',
    'delete_not_allowed' => 'Eliminación no permitida',
    'select_a_role' => 'Elige un rol',
    'access_rights_for_user' => 'Derechos de acceso para el usuario',
    'logs_for_user' => 'Registros para el usuario',
    'please_confirm' => 'Por favor confirma',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Al hacer clic en esta casilla, se confirma la eliminación de este usuario.',
    'fields_with_mandatory_information_are_missing' => 'Faltan campos con información obligatoria',
    'enable_personal_folder_for_this_user' => 'Habilitar la función de carpeta personal para este usuario',
    'special' => 'Especial',
    'administrator' => 'Administrador',
    'super_manager' => 'estor Teampass',
    'manager' => 'Gestor',
    'read_only' => 'Sólo lectura',
    'privileges' => 'Privilegios',
    'roles' => 'Roles',
    'user_definition' => 'Definición de usuario',
    'no_selection_done' => 'No se ha realizado ninguna selección',
    'tick_confirmation_box' => 'Por favor, marca la casilla para confirmar',
    'next_list_to_be_deleted' => 'La siguiente lista será eliminada',
    'delete_folders' => 'Eliminar Carpetas',
    'submit' => 'Enviar',
    'label' => 'Etiqueta',
    'parent' => 'Padre',
    'password_minimal_complexity_target' => 'Objetivo de complejidad mínima de la contraseña',
    'access_right_for_roles' => 'Derechos de acceso para los Roles',
    'create_without_password_minimal_complexity_target' => 'Permitir la creación de nuevos elementos sin objetivo de complejidad mínima de la contraseña',
    'edit_without_password_minimal_complexity_target' => 'Permitir la edición de artículos sin objetivo de complejidad mínima de la contraseña',
    'add_new_folder' => 'Añadir una nueva carpeta',
    'new' => 'Nuevo',
    'id' => 'ID',
    'mfa_short' => 'AMF',
    'mfa' => 'Autenticaión Multi-Factor',
    'google_2fa' => 'Verificación en 2 pasos de Google',
    'duo_security' => 'Seguridad Duo',
    'yubico' => 'Autenticador Yubico',
    'website_canal' => 'Haz clic para abrir el sitio web de Teampass',
    '2fa_credential_not_correct' => 'La credencial 2FA no es correcta',
    'no_change_performed' => 'No se ha realizado ningún cambio.',
    'password_strength' => 'Seguridad de la contraseña',
    'new_password_required' => 'Se requiere una nueva contraseña',
    'limited_search' => 'Búsqueda limitada',
    'empty_psk' => 'Falta Saltkey',
    'currently_no_favorites' => 'Actualmente no tienes favoritos',
    'favorites' => 'Favoritos',
    'confirm_item_move' => 'Has seleccionado "Mover"... ¿estás seguro?',
    'copy_to_clipboard' => 'Copiar al portapapeles',
    'please_wait_while_loading' => 'Por favor, espera mientras se cargan los datos',
    'defect_report' => 'Informe de errores',
    'actions' => 'Acciones',
    'no_user' => 'Usuario erróneo',
    'generate_api_token' => 'Generar un nuevo token de API',
    'upload_feature' => 'Cargar característica',
    'profile' => 'Perfil',
    'language' => 'Idioma',
    'upload_new_avatar' => 'Selecciona el archivo PNG del avatar',
    'settings' => 'Ajustes',
    'created_items' => 'Elementos creados',
    'modification_performed' => 'Modificación realizada',
    'items_opened' => 'Elementos abiertos',
    'passwords_seen' => 'Contraseñas vistas',
    'nothing_to_save' => 'Nada que guardar',
    'notification_engaged' => 'Estás recibiendo notificaciones sobre el cambio de Elementos',
    'notification_not_engaged' => 'No estás recibiendo notificaciones sobre el cambio de Elementos',
    'viewed_number' => 'Número de Visionados',
    'automatic_deletion_engaged' => 'Eliminación automática',
    'auto_update_enabled' => 'Cambio automático de contraseña de usuario activado. Próximo cambio previsto',
    'copy_folder' => 'Cipoar carpeta',
    'select_source_folder' => 'Selecciona la carpeta a copiar',
    'select_destination_folder' => 'Seleccionar carpeta de destino',
    'delete_folder' => 'Eliminar carpeta',
    'select_folder_to_delete' => 'Seleccionar carpeta a eliminar',
    'folder_delete_confirm' => 'La carpeta seleccionada y sus elementos serán eliminados. Por favor, marca la casilla de verificación para confirmar esta eliminación.',
    'json_error_format' => 'Formato JSON incorrecto',
    'password_cannot_be_empty' => 'La contraseña no puede estar vacía',
    'password_too_long' => 'La contraseña es muy larga',
    'error_no_action_identified' => 'No se ha identificado ninguna acción',
    'ldap' => 'LDAP',
    'emails' => 'Correos electrónicos',
    'backups' => 'Copias de seguridad',
    'api' => 'API',
    'add_folder' => 'Añadir nueva carpeta',
    'select_folder_parent' => 'Seleccionar carpeta principal',
    'add' => 'Añadir',
    'key_is_not_correct' => 'La clave de sesión proporcionada no es correcta',
    'suggestion_information' => 'Puedes sugerir al autor cualquier cambio en este artículo. Utiliza el formulario de arriba para hacer tus propuestas de cambio y haz clic en el botón Realizar para informar al autor.',
    'email_address' => 'Dirección de correo electrónico',
    'enter_email' => 'Introducir correo electrónico',
    'notification' => 'Notificación',
    'notify_on_change' => 'Notificarme los cambios',
    'notification_message' => 'Puedes utilizar esta configuración para ser notificado o no de los cambios realizados en este elemento.',
    'share_item' => 'Compartir el artículo',
    'share_item_message' => 'Puedes compartir este artículo con alguien. Por favor, proporciona un correo electrónico válido y haz clic en el botón Ejecutar.',
    'delete_item_message' => 'Has decidido eliminar este elemento seleccionado. Debes confirmar tu elección haciendo clic en el botón Ejecutar.',
    'warning' => 'Advertencia',
    'information' => 'Información',
    'perform' => 'Ejecutar',
    'delete_item' => 'Eliminar artículo',
    'copy_item' => 'Copiar artículo',
    'new_item' => 'Nuevo artículo',
    'error_not_allowed_to_edit_item' => 'No puedes editar este artículo',
    'error_not_allowed_to_access_this_folder' => 'No puedes acceder a esta carpeta',
    'error_personal_saltkey_is_not_set' => 'No se ha proporcionado tu Saltkey personal.',
    'provide_your_personal_saltkey' => 'Por favor, proporciona tu Saltkey personal',
    'no_fields' => 'Ningún campo está relacionado con este artículo.',
    'uploaded' => 'cargado',
    'changes_ongoing' => 'Algunos cambios no se han guardado. ¿Confirmar salir sin guardar?',
    'no_file_to_upload' => 'No hay archivos para cargar',
    'add_files_and_click_start' => 'Añade los archivos a la cola de subida y haz clic en el botón de inicio.',
    'select_files' => 'Seleccionar archivos',
    'attached_files' => 'Archivos adjuntos',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anunciar este artículo a los usuarios',
    'select_users_if_needed' => 'Seleccionar los usuarios si es necesario',
    'allow_item_to_be_deleted' => 'Permitir que este elemento se elimine en la siguiente condición',
    'item_deleted_after_being_viewed_x_times' => 'El artículo será eliminado después de ser visto X veces',
    'item_deleted_after_date' => 'El artículo se eliminará después de la fecha definida',
    'password' => 'Contraseña',
    'save' => 'Guardar',
    'folder' => 'Carpeta',
    'main' => 'Principal',
    'fields' => 'Campos',
    'details' => 'Detalles',
    'no_special_restriction' => 'Ninguna restricción especial',
    'generate_otv_link' => 'Generar un enlace de Una-Sola-Vista',
    'no_custom_fields' => 'Sin campos personalizados',
    'no_attachment' => 'Sin adjuntos',
    'logout_confirm' => '¿Cierre de sesión? Por favor, confirma.',
    'saved' => 'Guardado',
    'attachments' => 'Adjuntos',
    'success' => 'Éxito',
    'server_answer_error' => 'Aparece un error. La respuesta del servidor no puede ser analizada.',
    'server_returned_data' => 'Datos devueltos',
    'version_alone' => 'versión',
    'statistics' => 'Estadísticas',
    'options' => 'Opciones',
    'users' => 'Usuarios',
    'folders' => 'Carpetas',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objeto(s) encontrado(s)',
    'auto_update_server_password_info' => 'Al hacer clic en el botón EMPEZAR realizará automáticamente los siguientes pasos:<ul><li>Conectar a través de SSH al servidor Linux usando las credenciales de inicio de sesión y campo `URL`,</li><li>Cambiar contraseña de usuario en el servidor Linux</il><li>Guardar la nueva contraseña en Teampass </il><li>Cerrar la conexión SSH</li></ul><br /><b>Asegúrese de que el usuario tiene privilegios de root en el servidor (si no, indicar el inicio de sesión root y su contraseña) antes de comenzar.</b>',
    'share' => 'Compartir este elemento',
    'notify' => 'Notificar',
    'error_no_selected_folder' => 'Es necesario que seleccione una carpeta',
    'email_subject_item_updated' => 'La clave ha sido actualizada',
    'email_body_item_updated' => 'Hola:<br><br>La clave para \'#item_label#\' ha sido actualizada.<br /><br />Puede comprobarla <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">AQUÍ</a><br /><br />Saludos',
    'import_kp_finished' => 'La importación desde KeePass ha finalizad',
    'password_is_empty' => 'El artículo no tiene contraseña',
    'bug_report_to_github' => 'Completa el contenido del informe, cópialo en el portapapeles y pégualo en la página de nueva incidencia en Github',
    'open_bug_report_in_github' => 'Abrir informe de problema en Github',
    'bugs_page' => 'Si descubre un error, por favor repórtelo.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Activar "todos los del mismo rol pueden modificar" en todos los elementos importados.',
    'import_csv_anyone_can_modify_txt' => 'Activar "todos pueden modificar" en todos los elementos importados.',
    'settings_upload_imageresize_options' => '¿Deberían redimensionarse las imágenes?',
    'user_not_exists' => 'El usuario no existe!',
    'auto_create_folder_role' => 'Crear carpeta y rol para ',
    'start_upload' => 'Empezar a subir archivos',
    'error_upload_runtime_not_found' => 'Función de carga: No se encuentra el tiempo de ejecución',
    'user_profile_api_key' => ' Su clave API ',
    'index_change_pw' => 'Debe cambiar su contraseña',
    'admin_2factors_authentication_setting' => 'Habilitar autenticación Google en dos pasos',
    'admin_2factors_authentication_setting_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;La autenticación Google en dos pasos permite añadir un nivel más de seguridad en la autenticación. Cuando el usuario quiere logarse a Teampass, se genera un código QR. Este código tiene que ser escaneado por el usuario para obtener un password de un solo uso.&lt;br /&gt;ADVERTENCIA: este paso extra necesita una conexión a Internet y un escaneador de códigos (por ejemplo un smartphone)&lt;/span&gt;',
    'admin_ga_website_name' => 'Nombre mostrado en Google Authenticator para Teampass',
    'admin_ga_website_name_tip' => 'Este nombre se utiliza para la cuenta de código de identificación en Google Authenticator.',
    'api_whitelist_ips' => 'Lista blanca de IPs de la API',
    'api_whitelist_ips_tip' => 'Si no hay direcciones IP de clientes de la API enumeradas explícitamente aquí, cualquier dirección IP está autorizada.',
    'email_share_item_subject' => '[TeamPass] Un elemento ha sido compartido con usted',
    'email_share_item_mail' => 'Hola,&lt;br&gt;&lt;br&gt;&lt;u&gt;#tp_user#&lt;/u&gt; ha compartido con usted el elemento &lt;b&gt;#tp_item#&lt;/b&gt;&lt;br&gt;Pulse &lt;a href="#tp_link#"&gt;aquí&lt;/a&gt; para acceder.&lt;br&gt;&lt;br&gt;Saludos.',
    'index_maintenance_mode_admin' => 'Modo de mantenimiento activado. En este momento los usuarios no pueden acceder a TeamPass.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Enviar el código de GoogleAuthenticator por correo al usuario',
    'error_no_email' => '¡Este usuario no tiene dirección de correo electrónico configurada!',
    'error_no_user' => '¡No se encontró el usuario!',
    'email_ga_subject' => 'Su código de Google Authenticator para Teampass',
    'email_ga_text' => 'Hola,<br><br>Este es un correo generado por el gestor de contraseñas Teampass.<br><br>Su administrador espera que utilice la autenticación Two Factor para conectarse a Teampass.<br>Para su primera conexión a Teampass con Two Factor, utilice el código que encontrará a continuación en el campo "Identificación":<br><br>----------------------<br>#2FACode#<br>----------------------<br><br>A continuación, tendrá la oportunidad de configurar sus credenciales de una sola vez para el gestor de contraseñas Teampass.<br><br>Saludos. ',
    'settings_attachments_encryption' => 'Cifrar los archivos adjuntos',
    'settings_attachments_encryption_tip' => 'ESTA OPCIÓN PODRÍA CORROMPER ADJUNTOS EXISTENTES, por favor lea atentamente lo siguiente. Si está habilitado, los adjuntos se almacenan cifrados en el servidor. El cifrado utiliza la función SALT definida por Teampass. Esta opción necesita más recursos en el servidor. ATENCIÓN: una que vez lo modifiques, es obligatorio ejecutar el script para adaptar los adjuntos existentes. Vea la pestaña: \'Acciones específicas\'',
    'admin_action_attachments_cryption' => 'Cifrar o descifrar todos los archivos adjuntos',
    'admin_action_attachments_cryption_tip' => 'ATENCIÓN: esta acción tiene que ser ejecutada ÚNICAMENTE después de cambiar la opción asociada en la configuración de Teampass. Por favor, haga una copia de la carpeta \'upload\' antes de  ejecutar cualquier acción. por si acaso...',
    'encrypt' => 'Cifrar',
    'decrypt' => 'Descifrar',
    'ga_identification_code' => 'Código de identificación',
    'ga_enter_credentials' => 'Debe introducir las crendenciales de usuario',
    'ga_bad_code' => 'El código de autentificación de Google es incorrecto',
    'settings_get_tp_info' => 'Cargar automáticamente la información de Teampass',
    'settings_get_tp_info_tip' => 'Cuando esta habilitada, la información tal como las versiones actuales de software, parches de bugs y noticias sobre lanzamientos, son mostrados en la página de administrador desde los servicios remotos.',
    'settings_offline_mode' => 'Exportación de modo HTML Offline activado',
    'settings_offline_mode_tip' => 'El modo Fuera de linea consiste en exportar los items en un archivo HTML. Los items son cifrados con una clave dada por el usuario.',
    'offline_mode_key_level' => 'Calidad mínima para la clave de cifrado Fuera de linea.',
    'categories' => 'Categorías',
    'no_category_defined' => 'Aun no hay Categorías definidas',
    'confirm_deletion' => 'Va a eliminar, ¿está seguro?',
    'settings_item_extra_fields' => 'Autorizar a los elementos para que se puedan completar con más campos (por Categorías)',
    'settings_item_extra_fields_tip' => 'Esta característica permite mejorar la definición de elementos con campos extra que el administrador puede definir y organizar por categorías. Toda la información está cifrada. Tenga en cuenta que esta característica consume más consultas SQL (unas 5 más por campo durante la actualización de un elemento) y puede tardar más tiempo en ejecutar las acciones dependiendo del servidor.',
    'settings_ldap_type' => 'Tipo de servidor LDAP',
    'server_time' => 'Hora del servidor',
    'settings_tree_counters' => 'Mostrar contadores en el árbol de carpetas',
    'settings_tree_counters_tip' => 'Está opción mostrará 3 contadores por cada carpeta: el numero de elementos en la carpeta; el numero de elementos en las subcarpetas y el numero de subcarpetas. Está opción requiere más consultas SQL y puede demorar más tiempo en mostrar el árbol.',
    'admin_action_check_pf' => 'Actualizar Carpetas Personales para todos los usuarios (las crea si no existen)',
    'enable_personal_folder_feature_tip' => 'Una vez activada, debes ejecutar manualmente el script que crea las carpetas personales para los usuarios existentes. Está opción únicamente creará las carpetas personales para usuarios que no tienen creada dicha carpet',
    'administrators_only' => 'Sólo administradores',
    'managers_of' => 'Gestionadores del rol',
    'managed_by' => 'Gestionado por',
    'settings_enable_sts' => 'Forzar el uso de HTTPS-STS (Strict Transport Security) -- Cuidado: Leer el consejo.',
    'settings_enable_sts_tip' => 'Esto forzará el uso del protocolo HTTPS STS. Este protocolo ayuda a evitar los ataques SSL del tipo "Man-in-The Middle". DEBERÍAS tener un certificado SSL valido para poder usar esta opción. Si tienes un certificado auto-firmado y habilitas esta opción, ¡¡perderás el acceso a la aplicación!!. DEBES tener la línea \'SSLOptions +ExportCertData\' en la configuración SSL de Apache.',
    'settings_anyone_can_modify_bydefault' => 'Activate la opción de \'&lt;b&gt;&lt;i&gt;Cualquiera puede editar&lt;/b&gt;&lt;/i&gt;\' por defecto',
    'to' => 'hacia',
    'settings_upload_maxfilesize_tip' => 'Tamaño máximo de fichero permitido. Debe ser coherente con los parámetros del servidor.',
    'settings_upload_docext_tip' => 'Tipos de documento. Indicar las extensiones de fichero permitidas separadas por comas (,)',
    'settings_upload_imagesext_tip' => 'Tipos de imagen. Indicar las extensiones de fichero permitidas separadas por comas (,)',
    'settings_upload_pkgext_tip' => 'Tipos de paquete. Indicar las extensiones de fichero permitidas separadas por comas (,)',
    'settings_upload_otherext_tip' => 'Otros tipos de fichero. Indicar las extensiones de fichero permitidas separadas por comas (,)',
    'settings_upload_imageresize_options_tip' => 'Cuando se activa, esta opción redimensiona las imágenes al formato indicado justo debajo.',
    'settings_upload_maxfilesize' => 'Tamaño máximo del fichero (en MB)',
    'settings_upload_docext' => 'Extensiones de documento permitidas',
    'settings_upload_imagesext' => 'Extensiones de imagen permitidas',
    'settings_upload_pkgext' => 'Extensiones de paquete permitidas',
    'settings_upload_otherext' => 'Otras extensiones de fichero permitidas',
    'settings_upload_imageresize_options_w' => 'Anchura de la imagen redimensionada (en píxeles)',
    'settings_upload_imageresize_options_h' => 'Altura de la imagen redimensionada (en píxeles)',
    'settings_upload_imageresize_options_q' => 'Calidad de la imagen redimensionada',
    'settings_importing' => 'Habilitar importación de datos desde ficheros CVS/KeePass',
    'admin_proxy_ip' => 'IP/nombre del proxy usado',
    'admin_proxy_ip_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Si su conexión a internet requiere un proxy, indíquelo aquí.&lt;br /&gt;Déjelo en blanco si no hay proxy.&lt;/span&gt;',
    'admin_proxy_port' => 'Puerto del proxy',
    'admin_proxy_port_tip' => 'Si necesitas un servidor proxy para conectarte a Internet, establece aquí el número de puerto.',
    'settings_ldap_elusers' => ' solo usuarios locales de TeamPass',
    'settings_ldap_elusers_tip' => ' Esta característica permite a los usuarios de la base de datos autenticarse mediante LDAP. Deshabilite esta opción si quiere navegar por cualquier directorio LDAP.',
    'db_items_edited' => 'Elementos que se están editando actualmente',
    'item_edition_start_hour' => 'La edición empezó en',
    'settings_delay_for_item_edition' => 'Después de cuánto tiempo la edición de un elemento se considera fallida (en minutos)',
    'settings_delay_for_item_edition_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Cuando se edita un elemento, el elemento se bloquea para impedir ediciones paralelas. Para ello se reserva una especie de token.&lt;br /&gt;Este parámetro permite borrar el token tras un cierto tiempo. Si el valor se establece a 0, el token nunca se borrará.&lt;/span&gt;',
    'db_users_logged' => 'Usuarios logados actualmente',
    'action' => 'Acción',
    'login_time' => 'Registrado desde',
    'lastname' => 'Apellidos',
    'user_login' => 'Login',
    'role' => 'Rol',
    'error_role_exist' => 'Este Rol ya existe',
    'error_no_edition_possible_locked' => 'No es posible editar ya que el elemento está siendo editado en este momento.',
    'select' => 'elegir',
    'items' => 'Elementos',
    'enable_personal_saltkey_cookie' => 'Habilitar el almacenamiento de la clave Salt personal en una cookie',
    'personal_saltkey_cookie_duration' => 'Caducidad en DÍAS de la clave Salt personal',
    'admin_email_smtp_server' => 'Servidor SMTP',
    'admin_email_auth' => 'El servidor SMTP necesita autenticación',
    'admin_email_auth_username' => 'Usuario de autenticación',
    'admin_email_auth_pwd' => 'Clave de autenticación',
    'admin_email_port' => 'Puerto del servidor',
    'admin_email_from' => 'Correo electrónico emisor (from)',
    'admin_email_from_name' => 'Nombre del emisor',
    'admin_email_test_configuration_tip' => 'Esta prueba enviará un email a la dirección indicada. Si no lo recibes, por favor comprueba tus credenciales.',
    'admin_email_test_subject' => '[TeamPass] Correo electrónico de prueba',
    'admin_email_test_body' => 'Hola:&lt;br /&gt;&lt;br /&gt;El correo electrónico ha sido enviado satisfactoriamente.&lt;br /&gt;&lt;br /&gt;Saludos.',
    'admin_email_result_ok' => 'Correo electrónico enviado... revise su bandeja de entrada.',
    'email_bodyalt_item_updated' => 'La clave para #item_label# ha sido actualizada.',
    'admin_email_send_backlog_tip' => 'Este script permite forzar en la base de datos que los correos electrónicos sean enviados.&lt;br /&gt;Puede llevar algo de tiempo dependiendo del número de mensajes a enviar.',
    'please_wait' => 'Por favor, espere...',
    'admin_path_to_files_folder' => 'Ruta física a la carpeta Files',
    'admin_path_to_files_folder_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;La carpeta de Archivos (Files) se usa para almacenar todos los archivos generados por TeamPass y también algunos archivos subidos.&lt;br /&gt;IMPORTANTE: por razones de seguridad, esta carpeta no tiene que estar en la carpeta WWW de su sitio web. Tiene que estar en una zona protegida con una regla de redirección en la configuración del Servidor.&lt;br /&gt;IMPORTANTE 2: Puede ser bueno programar una tarea CRON para limpiar periódicamente esta carpeta.&lt;/span&gt;',
    'admin_path_to_upload_folder_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;La carpeta de Upload se usa para almacenar todos los archivos subidos asociados a los Elementos.&lt;br /&gt;IMPORTANTE: por razones de seguridad, esta carpeta no tiene que estar en la carpeta WWW de su sitio web. Tiene que estar en una zona protegida con una regla de redirección en la configuración del Servidor.&lt;br /&gt;IMPORTANTE 2: ¡Esta carpeta nunca debe ser eliminada! Esos archivos están asociados a Elementos.',
    'pdf_password_warning' => '¡Debes proporcionar una clave de cifrado!',
    'admin_pwd_maximum_length' => 'Longitud máxima de las claves',
    'admin_pwd_maximum_length_tip' => 'El valor por defecto de la longitud de clave está establecido en 40. Es importante saber que estableciendo un valor elevado tiene un impacto en el rendimiento. Cuanto mayor es este valor, el servidor necesita más tiempo para cifrar y descifrar, y también para mostrar las claves.',
    'settings_insert_manual_entry_item_history' => 'Habilitar la introducción de elementos en el LOG historico de los elementos.',
    'settings_insert_manual_entry_item_history_tip' => 'Si por algún motivo necesitases añadir manualmente una entrada en  el LOG histórico del elemento, activando esta característica sería posible.',
    'admin_path_to_upload_folder' => 'Ruta física a la carpeta Upload',
    'admin_setting_enable_delete_after_consultation' => 'El elemento consultado puede ser automáticamente eliminado',
    'admin_setting_enable_delete_after_consultation_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Cuando esta activado, el creador del elemento puede decidir si el elemento va a ser eliminado automáticamente después de ser visto X veces.&lt;/span&gt;',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Enviar notificaciones por email cuando el elemento sea visualizado',
    'share_sent_ok' => 'El email ha sido enviado',
    'see_item_title' => 'Detalles del elemento',
    'email_on_open_notification_subject' => '[TeamPass] Notificación de acceso a elemento',
    'email_on_open_notification_mail' => 'Hola,&lt;br&gt;&lt;br&gt;#tp_user# ha abierto y visualizado el elemento \'#tp_item#\'.&lt;br&gt;Pulse &lt;a href=\'#tp_link#\'&gt;aquí&lt;/a&gt; para acceder.&lt;br&gt;&lt;br&gt;Saludos.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Creación de su cuenta',
    'email_new_user_mail' => 'Hola,&lt;br /&gt;&lt;br /&gt;Un administrador ha creado su cuenta para TeamPass.&lt;br /&gt;Puede usar las siguientes credenciales para iniciar sesión:&lt;br /&gt;- Usuario: #tp_login#&lt;br /&gt;- Contraseña: #tp_pw#&lt;br /&gt;&lt;br /&gt;Haga click &lt;a href=\'#tp_link#\'&gt;aquí&lt;/a&gt; para acceder.&lt;br /&gt;&lt;br /&gt;Saludos.',
    'error_empty_data' => 'No hay datos para proceder',
    'error_not_allowed_to' => '¡No está autorizado a hacer eso!',
    'request_access_ot_item' => 'Solicitar acceso al autor',
    'email_request_access_subject' => '[TeamPass] Solicitar acceso a un elemento',
    'email_request_access_mail' => 'Hola #tp_item_author#,&lt;br /&gt;&lt;br /&gt;El usuario #tp_user# solicita acceso al elemento \'#tp_item#\'.&lt;br /&gt;&lt;br /&gt;Confirme los privilegios de este usuario antes de cambiar la restricción al elemento.&lt;br /&gt;&lt;br /&gt;Un saludo.',
    'admin_action_change_salt_key' => 'Cambiar la clave salt principal usada para el cifrado',
    'nb_items_by_query' => 'Numero de elementos a obtener en cada consulta',
    'nb_items_by_query_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Cuantos más elementos, más tiempo tardará en mostrar la lista.&lt;br /&gt;Seleccione \'auto\' para dejar a la herramienta que adapte este valor dependiendo del tamaño de la pantalla del usuario.&lt;br /&gt;Seleccione \'max\' para forzar que se muestre la lista completa de una sola vez.&lt;br /&gt;Escriba un número que corresponderá a la cantidad de elementos que se van a obtener en cada consulta.&lt;/span&gt;',
    'open_url_link' => 'Abrir en página nueva',
    'error_pw_too_long' => '¡La contraseña es demasiado larga! máximo 40 caracteres.',
    'at_restriction' => 'Restricción',
    'pw_encryption_error' => '¡Error cifrando la contraseña!',
    'enable_send_email_on_user_login' => 'Enviar un correo a los administradores cuando un usuario se conecte',
    'email_subject_on_user_login' => 'Información: Un usuario se ha conectado',
    'email_body_on_user_login' => 'Hola,&lt;br /&gt;&lt;br /&gt;El usuario #tp_user# se ha conectado a TeamPass el día #tp_date# a las #tp_time#.&lt;br /&gt;Saludos.',
    'account_is_locked' => 'Esta cuenta está bloqueada',
    'activity' => 'Actividad',
    'add_role_tip' => 'Agregar nuevo rol',
    'admin' => 'Administración',
    'admin_action_db_backup' => 'Crear una copia de seguridad de la base de datos',
    'admin_action_db_clean_items' => 'Eliminar elementos huerfanos de la base de datos',
    'admin_action_db_clean_items_tip' => 'Esto solo borrara los elementos y logs asociados que no han sido borrados después de que la carpeta asociada haya sido eliminada. Se recomienda crear una copia de seguridad previamente.',
    'admin_action_db_optimize' => 'Optimizar la base de datos',
    'admin_action_db_restore' => 'Restaurar la base de datos',
    'admin_action_purge_old_files' => 'Purgar archivos obsoletos',
    'admin_action_purge_old_files_tip' => 'Esto borrará todos los archivos temporales con mas de 7 días.',
    'admin_action_reload_cache_table' => 'Recargar tabla Caché',
    'admin_action_reload_cache_table_tip' => 'Permite recargar todo el contenido de la tabla de Caché. Puede ser útil hacerlo a veces.',
    'admin_help' => 'Ayuda',
    'admin_ldap_configuration' => 'Configuración LDAP',
    'admin_main' => 'Información',
    'admin_misc_cpassman_dir' => 'Ruta física completa a TeamPass',
    'admin_misc_cpassman_url' => 'URL completa a TeamPass',
    'admin_misc_custom_login_text' => 'Texto de login personalizado',
    'admin_misc_custom_logo' => 'URL completa del logotipo personalizado',
    'admin_misc_favicon' => 'URL completa al archivo favicon',
    'admin_settings' => 'Ajustes',
    'admin_settings_title' => 'Ajustes de TeamPass',
    'admin_setting_activate_expiration' => 'Habilitar expiración de contraseñas',
    'admin_setting_activate_expiration_tip' => 'Si esta activado, los elementos expirados no les serán mostrados a los usuarios.',
    'admin_views' => 'Vistas',
    'alert_message_done' => '¡Hecho!',
    'all' => 'todo',
    'anyone_can_modify' => 'Permitir que este elemento sea modificado por cualquiera que pueda acceder a él',
    'at' => 'en',
    'at_category' => 'Carpeta',
    'at_copy' => 'Copia creada',
    'at_delete' => 'Eliminación',
    'at_description' => 'Descripción.',
    'at_label' => 'Etiqueta',
    'at_login' => 'Login',
    'at_moved' => 'Movido',
    'at_personnel' => 'Personal',
    'at_restored' => 'Restaurado',
    'at_shown' => 'Accedido',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Carpetas permitidas',
    'auth_creation_without_complexity' => 'Permitir crear un elemento sin respetar la complejidad de clave requerida',
    'auth_modification_without_complexity' => 'Permitir modificar un elemento sin respetar la complejidad de clave requerida',
    'cancel' => 'Cancelar',
    'can_create_root_folder' => 'Puede crear carpetas en el nivel raiz',
    'changelog' => 'Últimas noticias',
    'close' => 'Cerrar',
    'complexity' => 'Complejidad',
    'complex_asked' => 'Complejidad requerida',
    'complex_level0' => 'Muy débil',
    'complex_level1' => 'Débil',
    'complex_level2' => 'Media',
    'complex_level3' => 'Fuerte',
    'complex_level4' => 'Muy fuerte',
    'complex_level5' => 'Contundente',
    'complex_level6' => 'Muy contundente',
    'confirm' => 'Confirmar',
    'confirm_del_from_fav' => 'Por favor, confirme la eliminación de Favoritos',
    'connections' => 'Conexiones',
    'copy' => 'Copiar',
    'copy_to_clipboard_small_icons' => 'Activar los iconos de copiar al portapapeles en la página de elementos',
    'copy_to_clipboard_small_icons_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Esto puede ayudar a prevenir el consumo de memoria si los usuarios no tienen un ordenador moderno. De hecho, no se cargará la información de los elementos en el portapapeles.&lt;br /&gt;Por tanto no se podrá hacer una copia rápida de usuario y contraseña.&lt;/span&gt;',
    'date' => 'Fecha',
    'date_format' => 'Formato de la fecha',
    'delete' => 'Eliminar',
    'deletion' => 'Eliminaciones ',
    'del_button' => 'Eliminar',
    'description' => 'Descripción',
    'disconnect' => 'Desconexión',
    'done' => 'Hecho',
    'duplicate_folder' => 'Permitir varias carpetas con el mismo nombre.',
    'duplicate_item' => 'Permitir varios elementos con el mismo nombre.',
    'email' => 'Email',
    'email_subject' => 'Creando un nuevo elemento en el Administrador de Contraseñas',
    'enable_favourites' => 'Permitir a los usuarios almacenar Favoritos',
    'enable_personal_folder' => 'Habilitar Carpeta Personal',
    'enable_personal_folder_feature' => 'Habilitar la opción de Carpeta Personal',
    'enable_user_can_create_folders' => 'Los usuarios pueden administrar carpetas en las carpetas padre autorizadas',
    'encrypt_key' => 'Clave de cifrado',
    'errors' => 'errores',
    'error_group_exist' => 'Esa carpeta ya existe',
    'error_html_codes' => 'El texto contiene código HTML, esto no está permitido.',
    'error_item_exists' => 'El elemento ya existe',
    'error_label' => 'La etiqueta es obligatoria',
    'error_must_enter_all_fields' => 'Tiene que completar todos los campos',
    'error_pw' => 'La contraseña es obligatoria',
    'error_tags' => 'No se permiten caracteres de puntuación en las etiquetas, solo espacios.',
    'error_user_exists' => 'El usuario ya existe',
    'expiration_date' => 'Fecha de expiración',
    'find' => 'Buscar',
    'forbidden_groups' => 'Carpetas prohibidas',
    'forgot_my_pw_email_sent' => 'El email ha sido enviado',
    'functions' => 'Roles',
    'gestionnaire' => 'Gestor',
    'god' => 'DIOS',
    'group' => 'Carpeta',
    'group_parent' => 'Carpeta Padre',
    'group_pw_duration' => 'Periodo de renovación',
    'group_pw_duration_tip' => 'En meses. Use 0 para deshabilitar.',
    'history' => 'Historial',
    'home_personal_saltkey' => 'Su clave Salt personal',
    'home_personal_saltkey_label' => 'Escriba su clave Salt personal',
    'import_error_no_read_possible' => 'No se puede leer el archivo',
    'import_error_no_read_possible_kp' => 'No se puede leer el archivo. Debe ser un archivo KeePass.',
    'import_keepass_to_folder' => 'Seleccione la carpeta de destino',
    'index_add_one_hour' => 'Extender la sesión 1 hora',
    'index_change_pw_confirmation' => 'Confirmar',
    'index_expiration_in' => 'la sesión expira en',
    'index_get_identified' => 'Por favor, identifíquese',
    'index_last_pw_change' => 'Contraseña cambiada el',
    'index_last_seen' => 'Última conexión, el',
    'index_login' => 'Cuenta',
    'index_new_pw' => 'Nueva contraseña',
    'index_password' => 'Contraseña',
    'index_pw_error_identical' => 'Las contraseñas deben ser idénticas',
    'index_pw_level_txt' => 'Complejidad',
    'index_session_duration' => 'Duración de la sesión',
    'info' => 'Información',
    'item_menu_copy_login' => 'Copiar login',
    'item_menu_copy_pw' => 'Copiar contraseña',
    'item_menu_del_from_fav' => 'Eliminar de Favoritos',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de conocimientos',
    'last_items_title' => 'Últimos elementos vistos',
    'ldap_extension_not_loaded' => 'La extensión LDAP no está activada en el servidor.',
    'level' => 'Nivel',
    'login' => 'Login',
    'mask_pw' => 'Enmascarar/Mostrar la contraseña',
    'max_last_items' => 'Máximo número de últimos elementos vistos por el usuario (por defecto es 10)',
    'minutes' => 'minutos',
    'name' => 'Nombre',
    'nb_false_login_attempts' => 'Número de intentos de autenticación incorrectos antes de deshabilitar la cuenta (0 para deshabilitar)',
    'nb_folders' => 'Número de Carpetas',
    'nb_items' => 'Número de Elementos',
    'new_label' => 'Nueva etiqueta',
    'no' => 'No',
    'none' => 'Ninguno',
    'none_selected_text' => 'Ningún elemento seleccionado',
    'not_allowed_to_see_pw' => 'No esta autorizado a ver ese elemento',
    'not_allowed_to_see_pw_is_expired' => 'Este elemento ha expirado',
    'not_defined' => 'No definido',
    'number_of_used_pw' => 'El número de contraseñas nuevas que el usuario debe usar antes de poder reutilizar una contraseña antigua.',
    'pages' => 'Páginas',
    'pdf_download' => 'Descargar archivo',
    'personal_salt_key' => 'Su clave Salt personal',
    'pw' => 'Contraseña',
    'pw_generate' => 'Generar',
    'pw_is_expired_-_update_it' => 'El elemento ha expirado. Debe cambiar su contraseña.',
    'pw_life_duration' => 'Tiempo de vida de la contraseña de los usuarios antes de expirar (en dias, 0 para deshabilitar)',
    'readme_open' => 'Abrir archivo README completo',
    'read_only_account' => 'Solo Lectura',
    'restore' => 'Restaurar',
    'restricted_to' => 'Restringido a',
    'restricted_to_roles' => 'Permitir restringir elementos a Usuarios y Roles',
    'root' => 'Raíz',
    'secure' => 'Seguro',
    'see_logs' => 'Ver los logs',
    'settings_anyone_can_modify' => 'Activar una opción para cada elemento que le permita a cualquier persona modificarlo',
    'settings_anyone_can_modify_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Cuando está activado, añade una casilla en el elemento que permite a su creador posibilitar la modificación de este elemento por cualquier usuario.&lt;/span&gt;',
    'settings_default_language' => 'Define el idioma por defecto',
    'settings_kb' => 'Habilitar Base de Conocimientos (beta)',
    'settings_kb_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Una vez activado, esto agregará una página en la cual usted puede construir su Base de Conocimientos.&lt;/span&gt;',
    'settings_ldap_domain' => 'Sufijo de cuentas LDAP para su dominio',
    'settings_ldap_domain_controler' => 'Array de controladores de dominio LDAP',
    'settings_ldap_domain_controler_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Especifique múltiples servidores si desea que la clase balancee las consultas LDAP entre ellos.&lt;br /&gt;Debe delimitar los dominios con una coma (,). Por ejemplo: dominio_1,dominio_2,dominio_3.&lt;/span&gt;',
    'settings_ldap_domain_dn' => 'Base DN del LDAP para su dominio',
    'settings_ldap_mode' => 'Permitir autenticación de usuarios a traves de servidor LDAP',
    'settings_ldap_mode_tip' => 'Habilitar solamente si usted tiene un servidor LDAP y desea utilizarlo para autenticar los usuarios de TeamPass.',
    'settings_ldap_ssl' => 'Usar LDAP a traves de SSL (LDAPS)',
    'settings_ldap_tls' => 'Usar LDAP a traves de TSL',
    'settings_log_accessed' => 'Habilitar logs de quién accedió a los elementos',
    'settings_log_connections' => 'Habilitar el logging de todas las conexiones de los usuarios a la base de datos.',
    'settings_maintenance_mode' => 'Activar Modo Mantenimiento (deshabilita login de usuarios)',
    'settings_manager_edit' => 'Los gestores pueden editar y eliminar los elementos que pueden ver',
    'settings_printing' => 'Habilitar la impresión de elementos a archivos PDF',
    'settings_printing_tip' => 'Una vez habilitado, aparecerá un botón en la página inicial del usuario que le permitirá escribir un listado de elementos en un archivo PDF. Tenga en cuenta que el listado de claves aparecerá descifrado.',
    'settings_restricted_to' => 'Activar la funcionalidad \'Restringido Para\' en los elementos',
    'settings_show_description' => 'Mostrar descripción en la lista de elementos',
    'size' => 'Tamaño',
    'tags' => 'Etiquetas ',
    'timezone_selection' => 'Zona horaria selecionada',
    'time_format' => 'Formato de la hora',
    'url' => 'URL',
    'user' => 'Usuario',
    'users_online' => 'Usuarios conectados',
    'user_alarm_no_function' => 'Este usuario no tiene Roles',
    'yes' => 'Sí',
    'one_time_view_item_url_box' => 'Compartir la URL One-Time con una persona de confianza <br><br>#URL#<br><br>Recuerda que este link será visible una vez hasta el #DAY# ',
    'settings_api' => 'Habilitar el acceso los elementos de Teampass a través de la API',
    'settings_api_tip' => 'El acceso a la API permite acceder a los elementos desde una aplicación de terceros en formato JSON',
    'settings_api_keys_list' => 'Lista de claves',
    'settings_api_keys_list_tip' => 'Estas son las claves que tienen permitido el acceso a Teampass. Sin una clave válida, el acceso no es posible. Debería compartir estas claves con cuidado.',
    'settings_api_key' => 'Clave',
    'settings_api_add_ip' => 'Agregar nueva IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Las nuevas sub-carpetas heredan los permisos de las carpetas de las que dependen.',
    'subfolder_rights_as_parent_tip' => 'Cuando esta característica esta deshabilitada, cada nuevo sub-carpeta hereda los permisos asociados al rol del usuario que la crea. Si esta habilitada, cada nueva subcarpeta heredará los permisos de la carpeta superior.',
    'show_only_accessible_folders_tip' => 'Por defecto, el usuario puede ver la ruta completa del árbol incluso aunque no tenga permisos de acceso a todas las carpetas. Deberías simplificar esto eliminando las carpetas del árbol a las que el usuario no tiene acceso.',
    'show_only_accessible_folders' => 'Simplificar el árbol de elementos eliminando las carpetas a las que el usuario no tiene acceso',
    'comment' => 'Comentario',
    'suggestion_menu' => 'Sugerencias',
    'settings_suggestion' => 'Habilitar la sugerencia de elementos para usuarios de solo lectura.',
    'settings_suggestion_tip' => 'Elementos sugeridos permite a los usuarios con permisos de solo Lectura el poder proponer nuevos elementos o su modificación. Estas sugerencias deberán ser validadas por el administrador o el gestor de usuarios.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'Ldap Bind Dn',
    'settings_ldap_bind_passwd' => 'Ldap Bind Passwd ',
    'settings_ldap_search_base' => 'Ldap Search Base',
    'settings_ldap_bind_dn_tip' => 'Un Bind dn que pueda enlazar y buscar usuarios en el árbol',
    'settings_ldap_bind_passwd_tip' => 'Contraseña para el Bind dn que enlaza y busca usuarios en el árbol',
    'settings_ldap_search_base_tip' => 'Buscar en la raiz DN para búsquedas en el arbol',
    'admin_email_server_url' => 'URL del servidor para los enlaces de los correos',
    'enable_email_notification_on_user_pw_change' => 'Enviar un correo al Usuario cuando su contraseña haya sido modificada',
    'settings_otv_expiration_period' => 'Espera antes de expiración de nuevos elementos compartidos mediante "una sola visión" (One Time View - OTV) (en días)',
    'write' => 'Escritura',
    'read' => 'Lectura',
    'no_access' => 'Sin Acceso',
    'right_types_label' => 'Selecciona el tipo de acceso para la carpeta para el grupo de usuarios seleccionado',
    'duplicate_item_in_folder' => 'Permitir claves con similar etiqueta en una carpeta común',
    'settings_roles_allowed_to_print' => 'Define los roles que podrán imprimir los elementos.',
    'settings_roles_allowed_to_print_tip' => 'Los roles seleccionados serán capaces de imprimir el contenido en un archivo.',
    'admin_email_security' => 'Seguridad SMTP',
    'alert_page_will_reload' => 'La página será actualizada',
    'file_protection_password' => 'Define el fichero contraseña',
    'expand' => 'Expandir',
    'collapse' => 'Contraer',
    'settings_ldap_user_attribute' => 'Busqueda de atributo de usuario',
    'settings_ldap_user_attribute_tip' => 'Atributo LDAP para la búsqueda de nombres de usuario',
    'log_user_initial_pwd_changed' => 'Contraseña inicial establecida',
    'log_user_email_changed' => 'El correo del usuario fue cambiado por ',
    'log_user_created' => 'Cuenta de usuario creada',
    'log_user_locked' => 'El usuario ha sido bloqueado',
    'log_user_unlocked' => 'El usuario ha sido desbloqueado',
    'log_user_pwd_changed' => 'La contraseña del usuario ha sido cambiada',
    'settings_default_session_expiration_time' => 'El tiempo de expiración de la sesión por defecto',
    'settings_duo' => 'Habilitar DUOSecurity.com como proveedor de doble factor de validación',
    'settings_duo_tip' => 'La validación de doble factor puede ser asegurada usando DUOSecurity.com. Esta libreria garantiza un alto nivel de seguridad en cuanto a la validación del usuario.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Estas credenciales son las entregadas para la aplicación web que has creado específicamente para Teampass desde la página de administración de DUOSecurity.<br />Pulsando en el botón GUARDAR se almacenarán en el archivo sk.php.',
    'admin_duo_intro' => 'Rellena los siguientes campos con los datos necesarios',
    'edit' => 'Editar',
    'user_info_locked' => 'El usuario se encuentra BLOQUEADO.',
    'user_info_unlock_question' => '¿Desbloquear cuenta?',
    'user_info_lock_question' => '¿Bloquear cuenta?',
    'user_info_delete_question' => '¿Eliminar cuenta?',
    'user_info_active' => 'El usuario esta ACTIVO.',
    'refresh' => 'Actualizar',
    'loading' => 'Cargando',
    'searching' => 'Buscando ...',
    'list_items_with_tag' => 'Mostrar items con esta etiqueta',
    'no_item_to_display' => 'No hay items para mostrar',
    'opening_folder' => 'Folder de lectura ...',
    'suggestion_notify_subject' => '[Teampass] Una nueva sugerencia ha sido creada',
    'suggestion_notify_body' => 'Hola, <br><br>Una nueva sugerencia ha sido creada. Necesitas validarla antes de que pueda ser vista por otros usuario',
    'error_unknown' => '¡Un error desconocido ha ocurrido!',
    'no_edit' => 'Escritura pero no edición',
    'role_cannot_edit_item' => 'No se pueden editar los items',
    'no_delete' => 'Escritura pero no eliminación',
    'role_cannot_delete_item' => 'No se pueden eliminar items',
    'my_profile' => 'Mi perfil.',
    'starting' => 'Empezando...',
    'total_number_of_items' => 'Número total de ítems ',
    'finalizing' => 'Finalizando',
    'treating_items' => 'Procesando elementos',
    'number_of_items_treated' => 'Número de elementos procesados',
    'error_sent_back' => 'Ocurrió el siguiente error',
    'full' => 'Completo',
    'sequential' => 'Secuencial',
    'tree_load_strategy' => 'Estrategia de carga de árbol',
    'syslog_enable' => 'Habilitar logs con Syslog',
    'syslog_host' => 'Servidor Syslog',
    'syslog_port' => 'Puerto Syslog',
    'error_bad_credentials' => '¡Las credenciales de inicio de sesión no corresponden!',
    'settings_ldap_usergroup' => 'grupo LDAP para buscar',
    'settings_ldap_usergroup_tip' => 'Grupo LDAP donde se encuentran los usuarios con acceso permitido. Ejemplo: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Permitir el cambio de contraseña en el servidor remoto (utilizando una conexión ssh)',
    'update_server_password' => 'Actualiza la contraseña del serividor',
    'ssh_pwd' => 'Contraseña SSH',
    'ssh_user' => 'Usuario SSH',
    'ssh_password_frequency_change_info' => 'Es posible que desee el cambio se realize de forma automática a una frecuencia en particular. Para ello, es necesario seleccionar la frecuencia a la que se cambiarán las contraseñas de usuario de servidor (seleccionando 0 desactivará la tarea).<br />Nótese que esto sólo funcionará si el administrador ha activado la tarea en el programa cronológico del servidor.',
    'ssh_password_frequency_change' => 'Frecuencia de cambio de contraseña (en meses)',
    'ssh_scheduled_change' => 'Cambio programado',
    'ssh_one_shot_change' => 'Cambio único',
    'server_password_change_enable_tip' => 'Esta opción permite que los usuarios puedan cambiar automáticamente la contraseña del usuario de un servidor que se encuentra en el campo URL usando la conexión SSH.<br>Observe que el cambio automático a una frecuencia específica se puede hacer si el archivo <i>/files/script.ssh.php</i> está añadido al crontab de este servidor. El consejo sería que se ejecutasen una vez al día.',
    'error_bad_credentials_more_than_3_times' => '!Credenciales de sesión incorrectas!<br>Por favor, espere 10 segundos antes de volverlo a intentar',
    'settings_ldap_object_class' => 'Clase a buscar',
    'settings_ldap_object_class_tip' => 'Clase LDAP a buscar, como una cuenta de usuario o una cuenta POSIX',
    'rebuild_config_file' => 'Reconstruir archivo de configuración',
    'rebuild_config_file_tip' => 'El archivo de configuración contiene variables del sistema, y se usa cuando esas variables se necesitadas antes de que se establezca la conexión a la base de datos. La reconstrucción del archivo almacena la configuración de la base de datos en dicho archivo y puede ser realizada en cualquier momento. La trayectoria del archivo por defecto es ./includes/config/tp.config.php, pero el archivo podría encontrarse fuera del directorio www por seguridad.',
    'error_folder_complexity_lower_than_top_folder' => 'Las subcarpetas deberían tener una contraseña tan fuerte o mayor que la carpeta en la que se encuentran',
    'new_item_email_body' => 'Hola, <br /><br />Un nuevo elemento \'#label\' ha sido creado en Teampass.<br />Puedes acceder a él pulsando en el este <a href="#link#">ENLACE</a>.<br/><br />Saludos. ',
    'failed_logins' => 'Inicios de sesión fallidos',
    'error_only_numbers_in_folder_name' => 'La nombre de carpeta no puede contener solo números. Por favor, escribe un nombre de carpeta que incluya letras.',
    'encrypted_data' => 'Los datos están ecriptados en la base de datos',
    'settings_ldap_port' => 'puerto LDAP',
    'user_profile_agses_card_id' => 'Tu ID de tarjeta Agses',
    'ga_flash_qr_and_login' => 'Flashea este código QR con tu dispositivo móvil, ingrese el código de autenticación de 2Factor y haga clic en el botón "Enter".',
    'i_need_to_generate_new_ga_code' => 'Necesito un nuevo código QR. Por favor, envíeme por correo electrónico un código de identificación temporal.',
    'settings_manager_move_item' => 'Los administradores pueden mover cualquier elemento que puedan ver',
    'user_folders_rights' => 'Carpetas visibles',
    'create_item_without_password' => 'Permitir que el elemento se cree sin ninguna contraseña definida',
    'share_rights_info' => 'Esta ventana de diálogo le permite compartir los derechos de un usuario con una selección de usuarios. <br>Note que los usuarios seleccionados tendrán sus derechos existentes reseted y reemplazados con exactamente los mismos derechos que el usuario de origen.',
    'share_rights_source' => 'Usuario de origen',
    'share_rights_destination' => 'Usuarios de destino',
    'ga_reset_by_user' => 'El usuario puede restablecer su código 2FA',
    'ga_reset_by_user_tip' => 'Si está habilitado, el usuario tendrá la posibilidad de restablecer su código 2FA usando el enlace en la página de inicio de sesión. Esto podría ser útil en caso de que haya cambiado el dispositivo móvil, por ejemplo. Si no está habilitado, el usuario deberá solicitar al Administrador que genere un nuevo código.',
    'enable_massive_move_delete' => 'Permitir al usuario realizar operaciones masivas de movimiento y eliminación',
    'enable_massive_move_delete_tip' => 'Cuando está habilitada, esta opción permite que un usuario realice una operación masiva de movimiento y/o supresión de una vez. El usuario sólo podrá realizar esto en Elementos en los que se le permita hacerlo.',
    'mass_operation' => 'Operación masiva en los elementos',
    'move_items' => 'Mover elementos seleccionados',
    'delete_items' => 'Eliminar elementos seleccionados',
    'you_decided_to_move_items' => 'Decidiste mover elementos',
    'you_decided_to_delete_items' => 'Decidiste eliminar elementos',
    'suggest_password_change' => 'Sugerir un cambio de contraseña',
    'otv_is_enabled' => 'El usuario puede proponer enlaces de una-sola-vista',
    'error_source_and_destination_are_equal' => '¡El origen y el destino no pueden ser iguales!',
    'sending_anonymous_statistics' => 'Enviando estadísticas anónimas',
    'favourites_option_enabled' => 'Opción Favoritos habilitada',
    'personalfolders_option_enabled' => 'Opción Carpetas Personales habilitada',
    'country_statistics' => 'Uso del Mapa Mundial',
    'country' => 'País',
    'users_statistics' => 'Promedio de usuarios por instancia',
    'items_all' => 'Todos los artículos',
    'folders_all' => 'Todas las carpetas',
    'items_shared' => 'Todos los artículos compartidos (sin incluir los personales)',
    'folders_shared' => 'Todas las carpetas compartidas (sin incluir las personales)',
    'items_statistics' => 'Número promedio de elementos por instancia',
    'folders_statistics' => 'Número medio de carpetas por instancia',
    'administrators_number' => 'Número de usuarios de administrador',
    'administrators_number_statistics' => 'Número medio de administradores por instancia',
    'managers_number' => 'Número de usuarios administrador',
    'managers_number_statistics' => 'Promedio de Administradores por instancia',
    'readonly_number_statistics' => 'Promedio de usuarios de sólo lectura por instancia',
    'readonly_number' => 'Número de usuarios de sólo lectura',
    'mysql_version' => 'Versión de MySQL',
    'php_version' => 'Versión de PHP',
    'teampass_version' => 'Versión Teampass',
    'languages_used' => 'Idiomas utilizados',
    'languages_statistics' => 'Idioma más utilizado',
    'kb_option_enabled' => 'Se ha habilitado la opción Base de conocimientos',
    'suggestion_option_enabled' => 'Opción de sugerencia activada',
    'customfields_option_enabled' => 'Se ha habilitado la opción Campos personalizados',
    'api_option_enabled' => 'Se ha habilitado la opción API',
    '2fa_option_enabled' => '2FAopción habilitada',
    'agses_option_enabled' => 'Opción AGSES habilitada',
    'duo_option_enabled' => 'Se ha habilitado la opción de seguridad DUO',
    'ldap_option_enabled' => 'Opción LDAP activada',
    'syslog_option_enabled' => 'Opción SYSLOG habilitada',
    'stricthttps_option_enabled' => 'Opción HTTPS estricta activada',
    'characteristic' => 'Característica',
    'current_value' => 'Valor actual',
    'communication_means' => 'Medios de comunicación',
    'consider_a_donation' => 'Usted puede considerar realizar una donación',
    'more_information' => 'Más información',
    'feature_request_canal' => 'Para Solicitudes o Preguntas, por favor utilice',
    'bug_canal' => 'Para Errores, por favor use',
    'documentation_canal' => 'Documentación',
    'sending_anonymous_statistics_details' => 'Las estadísticas son necesarias para mejorar Teampass por conocer la población de usuarios y el uso. Los datos que proporcionará solo se utilizarán internamente para el datamining y no serán absolutamente distribuidos o vendidos a terceros.',
    'item_has_change_proposal' => 'Este artículo tiene una propuesta de cambio',
    'check_data_after_reencryption' => 'Por favor compruebe los datos. Una nueva tabla <b>Copia de seguridad</b> se creó durante esta operación permitiendo revertir.',
    'revert' => '¿Revertir?',
    'revert_the_database' => 'Ha decidido revertir la base de datos. Por favor confirmalo',
    'bad_psk' => '¡Este Saltkey personal no es correcto!',
    'ldap_test_config' => 'Probar la configuración actual',
    'ldap_test_username' => 'Nombre de usuario para usar para con propósito de la prueba',
    'ldap_test_username_pwd' => 'Contraseña del nombre de usuario',
    'feature_support_canal' => 'Para soporte y ayuda, utilice',
    'category' => 'Categoría',
    'text' => 'Texto',
    'type' => 'Tipo',
    'data_is_masked' => 'Los datos están Ocultos',
    'at_export' => 'Exportar',
    'settings_ldap_allowed_usergroup' => 'Grupo de usuarios permitido por LDAP',
    'settings_ldap_allowed_usergroup_tip' => 'Indica el grupo permitido para conectarse a Teampass. Déjalo vacío si no se espera ninguna restricción con respecto a la pertenencia al grupo.',
    'error_security_level_not_reached' => '¡Nivel de seguridad esperado no alcanzado!',
    'personal_saltkey_security_level' => 'Nivel mínimo personal de seguridad Saltkey',
    'settings_disable_forgot_password_link' => 'Ocultar enlace de contraseña olvidada en la Página de inicio',
    'newly_created_user_is_administrated_by' => 'El usuario creado reacientemente es administrado por',
    'settings_ldap_and_local_authentication' => 'Usuarios locales y LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Habilite esta opción para permitir que los usuarios se autentiquen en la biblioteca LDAP o en la lista local de usuarios de Teampass.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Selecciona un nivel de depuración',
    'email_debug_client' => 'Comandos del cliente',
    'email_debug_server' => 'Comandos del cliente y respuestas del servidor',
    'email_debug_connection' => 'Comandos del cliente, respuestas del servidor y estado de la conexión',
    'email_debug_low_level' => 'Salida de datos de bajo-nivel, todos los mensajes',
    'email_debug_level_usage' => 'Este ajuste debe ser establecido como Ninguno. Sólo se utiliza para depurar el correo electrónico durante las pruebas. Cuando se activa, permitirá mostrar una salida de los comandos de correo electrónico.',
    'email_body_temporary_login_password' => 'Hola,<br><br>Este es un correo electrónico generado por el gestor de contraseñas Teampass.<br><br>Un administrador ha cambiado tu contraseña de acceso a Teampass. La próxima vez que te conectes a Teampass, por favor utiliza la siguiente:<br><br><b>#enc_code#</b><br><br><br>Saludos',
    'your_new_password' => 'Tu nueva contraseña',
    'user_specific_right' => 'Derecho específico del usuario',
    'icon' => 'Icono',
    'icon_on_selection' => 'Icono de selección',
    'fontawesome_icon_tip' => 'Puedes especificar un código de icono de Font Awesome seleccionado en Iconos libres y sólidos. Dejar vacío para el icono por defecto.',
    'settings_api_token_duration' => 'Retraso de expiración del token JWT (en segundos)',
    'settings_api_token_duration_tip' => 'Retraso durante el cual el token JWT generado es válido. Tras este retardo, se solicita enviar una solicitud de autorización a la API.',
    'show_encryption_code_to_admin' => 'Este es el código encriptado que el usuario necesitará en este inicio de sesión. Has pedido verlo, por favor cópialo y compártelo de forma segura. El código es',
    'previous_password' => 'Contraseña anterior usada para conectar a Teampass',
    'generate_new_otp' => 'Generar nueva OTP',
    'generate_new_otp_informations' => 'Esta operación consiste en generar desde cero todas las claves para el usuario seleccionado. Como consecuencia, el usuario tendrá que proporcionar la nueva OTP generada en el siguiente inicio de sesión.',
    'html' => 'html',
    'execution_time' => 'Tiempo de ejecución',
    'maximum_number_of_items_to_treat' => 'Número máximo de elementos a tratar durante un ciclo',
    'maximum_number_of_items_to_treat_tip' => 'Con el fin de garantizar la finalización de la secuencia de comandos sin tiempo de espera, es posible definir un valor personal.',
    'maximum_time_script_allowed_to_run' => 'Duración en segundos permitida para que el script se ejecute en segundo plano',
    'maximum_time_script_allowed_to_run_tip' => 'Por defecto, el script PHP no puede ejecutarse más allá de la duración definida por el parámetro max_execution_time en el archivo php.ini. El objetivo aquí es definir un valor más alto para asegurar que el script se ejecute completamente.',
    'refresh_data_every_on_screen' => 'Periodo de refresco de pantalla (en segundos)',
    'refresh_data_every_on_screen_tip' => 'Cuando se navega por la vista de tareas, esto permite tener una lista actualizada basada.',
    'refreshed' => 'Actualizado',
    'process_details' => 'Detalles del proceso',
    'created_at' => 'Creado el',
    'updated_at' => 'Actualizado el',
    'finished_at' => 'Terminado el',
    'tasks_manager' => 'Administrador de tareas',
    'tasks' => 'Tareas',
    'task_in_progress_user_not_active' => 'Tareas en curso - Usuario no activo',
    'enable_tasks_manager' => 'Permitir que el gestor cron realice tareas pesadas',
    'enable_tasks_manager_tip' => 'Esta opción debe ser activada si notas que algunas tareas requieren mucho tiempo. Esto permite manejar esas tareas usando un trabajo en segundo plano realizado por el administrador cron del servidor. Consulta la documentación para más detalles.',
    'sync_new_ldap_password' => 'Sincronizar la nueva contraseña',
    'error_new_ldap_password_detected' => 'Parece que tu contraseña ha cambiado y Teampass la requiere para encriptar tu clave privada maestra.',
    'settings_ldap_tls_certifacte_check' => 'Comprobación de certificados para LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Especifica la estrategia de comprobación de certificados. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Más información</a>.',
    'user_keys_management' => 'Gestión de claves de usuario',
    'sending_emails' => 'Enviando correos electrónicos',
    'task_frequency' => 'Frecuencia (en minutos)',
    'tasks_information' => 'La tarea se basa en un cron job dedicado. Para ello, es necesario añadir una nueva entrada a su crontab para ejecutar el programador de Teampass cada minuto.<br>Siguiente entrada a añadir:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Nota: por favor, adapta la ruta a php bin (en la mayoría de los casos, se puede sustituir por <code>php</code>).',
    'bad_duo_mfa' => 'Código DUO erróneo',
    'creation_date' => 'Fecha de creación',
    'never' => 'Nunca',
    'loading_main_page' => 'Por favor espera, cargando página principal...',
    'alert_session_not_consistent' => 'La sesión actual no es consistente y necesita ser actualizada. La página se recargará.',
    'link' => 'Enlace',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',
    'generate_new_keys' => 'Generate new keys',
    'generate_new_keys_info' => 'By continuing, you will generate new encryption keys for all objects you have access to. This should only be done if you have no password shown
.',
    'generate_new_keys_end' => 'Process is on going in background and could take several minutes. You can now close this window.',
    'confirm_password' => 'We need you to confirm your password',

);
