<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.3
 * @file      french.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Afficher le code de chiffrement de l\'utilisateur',
    'email_body_new_user' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Un administrateur vous a créé un compte utilisateur sur Teampass. Lors de votre prochaine connexion, veuillez utiliser les identifiants suivants :<ul><li>Login: #login#</li><li>Mot de passe: #password#</li><li>Code de chiffrement : #code#</li></ul><br><br><br>Merci',
    'user_password' => 'Mot de passe utilisateur',
    'user_temporary_encryption_code' => 'Code de chiffrement utilisateur',
    'no_email_set' => 'Aucun email n\'a été enregistré',
    'send_user_password_by_email' => 'Choisissez si le login utilisateur doit être envoyé par mail.<br> Si oui, cliquez sur le bouton Envoyer. <br><br>Sinon, cliquez sur le bouton Copier dans le presse papier pour l\'envoyer à l\'utilisateur par un autre moyen.<br>Cela devient votre responsabilité en tant qu\'administrateur de fournir le mot de passe de l\'utilisateur de façon sécurisée.',
    'admin_change_user_encryption_code_info' => 'Cette opération aura comme conséquence de réinitialiser le code de chiffrement pour cet utilisateur.',
    'send_by_email' => 'Envoyer par email',
    'filters' => 'Filtres',
    'show_user_password' => 'Afficher le mot de passe utilisateur',
    'open_website' => 'Accéder au site web',
    'mfa_for_roles' => 'L’authentification multifacteur est requise pour les utilisateurs dans les Rôles',
    'mfa_for_roles_tip' => 'Par défaut, une fois que l\'authentification multifacteurs est sélectionnée, cela est activé pour l\'ensemble des utilisateurs. Néanmoins, vous pouvez sélectionner les rôles pour lesquels vous souhaitez l\'activer.<br>Pas encore mis en place.',
    'at_least_one_administrator_is_requested' => 'Au moins un administrateur est requis',
    'bad_code' => 'Mauvais code',
    'generating_keys' => 'Clés en cours de génération',
    'this_may_take_time' => 'Cela peut prendre quelques minutes',
    'disable_enable' => 'Désactiver/Activer',
    'user_disable_status' => 'Cochez la case pour désactiver ou laissez-la vide pour activer',
    'help_for_launching_items_encryption' => 'Il est maintenant nécessaire de générer les clés de la base de données pour votre compte. Merci de fournir votre code de chiffrement.',
    'managed_through_ad' => 'Géré via AD',
    'new_ldap_user_info' => 'Veuillez compléter la définition de l\'utilisateur',
    'email_body_user_added_from_ldap_encryption_code' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Vous avez maintenant un compte Teampass. Vous pouvez utiliser vos identifiants AD pour vous connecter.<br><br>A la première connexion, un code de chiffrement vous sera demandé, veuillez utiliser :<br><br><b>#enc_code#</b><br><br><br>Merci.',
    'settings_ldap_user_object_filter' => 'Filtre d\'objets utilisateur',
    'settings_ldap_user_object_filter_tip' => 'Le filtre à utiliser lors de la recherche d\'objets utilisateur. Exemple : (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Cette valeur est utilisée en plus de la base DN lors de la recherche et du chargement des utilisateurs. Si aucune valeur n\'est fournie, la recherche des sous-arbres commencera à partir de la base. Exemples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Identifiant DN utilisateur supplémentaire',
    'ldap_user_has_changed_his_password' => 'Votre mot de passe d\'authentification a été changé dans votre AD depuis votre dernière connexion à Teampass. Nous devons adapter votre clé de chiffrement. Veuillez fournir votre précédent mot de passe et l\'actuel.',
    'provide_your_previous_password' => 'Votre précédent mot de passe',
    'admin_change_user_password_info' => 'Cette opération réinitialisera le mot de passe actuel de l\'utilisateur sélectionné.',
    'sending_email_message' => 'Envoi de l\'email à l\'utilisateur, veuillez patienter',
    'change_your_password_info_message' => 'Merci de renseigner votre nouveau mot de passe d\'authentification et de le confirmer.',
    'user_has_to_change_password_info' => 'Le mot de passe utilisé actuellement a été généré. Il est préférable que vous le changiez, pour des raisons de sécurité.',
    'ready_to_go' => 'Prêt à l\'emploi',
    'passwords_not_the_same' => 'Les mots de passe fournis ne sont pas les mêmes',
    'inititialization' => 'Initialisation',
    'bad_password' => 'Mauvais mot de passe',
    'perform_checks' => 'Vérifications en cours',
    'email_body_temporary_encryption_code' => 'Bonjour,<br><br>Ceci est un mail généré par le gestionnaire de mot de passe Teampass.<br><br>Des changements ont été effectués sur votre compte et nécessitent un nouveau chiffrement des éléments pour la sécurité des données. A votre prochaine connexion, veuillez utiliser le code suivant :<br><br><b>#enc_code#</b><br><br><br>Merci',
    'temporary_encryption_code' => 'Votre code de chiffrement temporaire',
    'renecyption_expected' => 'Il est maintenant nécessaire de régénérer vos clés en fonction de votre compte et privilèges.',
    'error_no_user_in_ad' => 'Utilisateur introuvable dans l\'AD !',
    'error_ad_user_expired' => 'Utilisateur expiré !',
    'error' => 'Erreur détectée',
    'hosts' => 'Hôtes',
    'settings_ldap_hosts_tip' => 'L\'option hôtes est un tableau d\'adresses IP ou de noms d\'hôtes situés sur votre réseau qui fournissent une base de données LDAP (séparés par une virgule). Vous pouvez insérer autant de serveurs que vous le souhaitez (un au minimum)',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Nom d\'utilisateur',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'Le mot de passe de l\'utilisateur indiqué',
    'settings_ldap_port_tip' => 'L\'option de port est utilisée pour l\'authentification et la liaison avec votre serveur LDAP. Les ports par défaut sont déjà utilisés pour les connexions non SSL et SSL (389 et 636). N\'insérez un port que si votre serveur LDAP utilise un port unique.',
    'undefined' => 'Indéfini',
    'error_cannot_open_file' => 'Le fichier ne peut pas être ouvert',
    'provide_current_psk_and_click_launch' => 'Quand vous êtes prêt, cliquez sur le bouton Lancer',
    'start' => 'Commencer',
    'data_inconsistency' => 'Une donnée semble corrompue. Merci de recharger la page !',
    'one_time_code_expected' => 'Code à usage unique exigé',
    'data_are_missing' => 'Les données attendues sont manquantes',
    'one_time_code' => 'Code à usage unique',
    'provide_personal_one_time_code' => 'Veuillez fournir le code à usage unique que vous avez reçu par email',
    'change_authentification_type_to_ldap' => 'Changer le type d\'authentification en LDAP',
    'change_authentification_type_to_local' => 'Changer le type d\'authentification en base de données locale Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Le mot de passe utilisateur de l\'annuaire LDAP est utilisé pour l\'authentification',
    'local_user_password_is_used_for_authentication' => 'Le mot de passe utilisateur est utilisé pour l\'authentification',
    'provide_your_current_password' => 'Veuillez fournir votre mot de passe actuel',
    'current_password' => 'Mot de passe actuel',
    'password_is_not_correct' => 'Ce mot de passe n\'est pas correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Eléments personnels',
    'logout_on_going' => 'Vous allez maintenant être déconnecté. Merci d\'utiliser votre nouveau mot de passe par la suite.',
    'fill_in_fields_and_hit_launch' => 'Merci de renseigner les champs requis et cliquer sur le bouton',
    'please_select_a_folder' => 'Veuillez sélectionner un dossier',
    'user_must_have_login_and_email' => 'L\'utilisateur doit avoir un login et un email',
    'user_has_this_role_in_teampass' => 'L\'utilisateur dispose de ce rôle',
    'select_role_to_create' => 'Sélectionner le rôle à créer',
    'adding_ldap_role_to_teampass' => 'Vous pouvez importer, dans Teampass, un rôle existant dans votre annuaire AD. Cela permettra d\'associer un utilisateur à ce rôle dans Teampass.',
    'add_user_to_role' => 'Ajouter ce rôle à cet utilisateur dans Teampass',
    'add_user_in_teampass' => 'Ajouter un utilisateur dans Teampass',
    'synchronized' => 'Synchronisé',
    'output' => 'Sortie',
    'remove_install_folder' => 'Le dossier d\'installation doit être supprimé',
    'list_users' => 'Liste des utilisateurs',
    'ldap_synchronization' => 'Synchronisation LDAP',
    'in_progress' => 'En cours',
    'clipboard_password_life_duration' => 'Délai, en secondes, avant l\'effacement du presse-papier',
    'clipboard_password_life_duration_tip' => 'Permet de définir un délai en secondes avant lequel le mot de passe  copié dans le presse-papier sera effacé. La valeur 0 désactive la fonctionnalité.',
    'clipboard_will_be_cleared' => 'Le mot de passe a été copié. Il sera bientôt supprimé...',
    'file_folder_not_accessible' => 'Le répertoire Files n\'est pas accessible',
    'error_missing_id' => 'Une erreur est survenue. Un ID est-il manquant... ?',
    'error_folder_not_allowed' => 'La sélection n\'est pas autorisée',
    'all_fields_mandatory' => 'Tous les champs sont nécessaires',
    'history_insert_entry' => 'Ajouter à l\'historique',
    'clear_form' => 'Vider le formulaire',
    'info_about_history_insertion' => 'Attention - cette fonctionnalité vous permet d\'insérer manuellement un événement dans l\'historique de l\'élément. Une fois l\'événement ajouté, il vous sera impossible de le supprimer. Notez également qu\'un ID de compte sera associé à cette insertion.',
    'select_all' => 'Tout sélectionner',
    'unselect_all' => 'Tout désélectionner',
    'no_data_to_display' => 'Aucune donnée à afficher ! Soit aucun répertoire n\'existe, soit vous n\'avez aucun accès.',
    'server' => 'Serveur',
    'data_refreshed' => 'Données rafraîchies',
    'loading_image' => 'Chargement de l\'image',
    'compare_with_another_role' => 'Comparer avec un autre rôle',
    'only_display_folders_to_depth' => 'Afficher les répertoires jusqu\'au niveau',
    'propagate_rights_to_descendants' => 'Propager les droits vers les descendants',
    'loading_data' => 'Chargement des données',
    'password_overview_delay' => 'Durée d\'affichage du mot de passe',
    'password_overview_delay_tip' => 'Permet de définir la durée d\'affichage en clair d\'un mot de passe à l\'utilisateur.',
    'select_date_showing_items_expiration' => 'Lister les objets expirés à compter du',
    'renewal_page_info' => 'Cette page permet d\'identifier les éléments expirés ou expirant prochainement.',
    'filename' => 'Nom de fichier',
    'exported_to_file' => 'Exporter dans le fichier',
    'operation_progress' => 'L\'opération est en cours',
    'exporting_items' => 'Exportation en cours',
    'select_folders_to_export' => 'Choisir les répertoires à exporter',
    'export_format_type' => 'Choisir le format d\'export',
    'export_items' => 'Export d\'objets',
    'loading_item' => 'Chargement de l\'objet',
    'otv_message' => 'Vous pouvez partager cet objet avec un invité. Cette vue permet à cet invité d’accéder à un certain nombre de champs de l\'objet sans avoir à s\'identifier. Merci de noter que le lien généré sera valide uniquement pour une durée de ##otv_expiration_period##  jours. Copier et partager le lien ci-dessous.',
    'no_sharekey_found' => 'Aucune clé de chiffrement trouvée pour ce fichier',
    'otv_link' => 'Lien à visualisation unique',
    'one_time_view' => 'Visualisation unique',
    'move_right_columns_separator' => 'Déplacer le séparateur de colonne sur la droite',
    'move_left_columns_separator' => 'Déplacer le séparateur de colonne sur la gauche',
    'form_presents_inconsistencies' => 'Le formulaire présente des incohérences. Merci de vérifier les champs en rouge.',
    'download' => 'Télécharger',
    'see' => 'Voir',
    'at_anyoneconmodify' => 'Tout le monde peut modifier',
    'disabled' => 'Désactivé',
    'enabled' => 'Activé',
    'confirmation_seems_wrong' => 'La confirmation semble erronée, veuillez corriger',
    'i_cannot_remember' => 'Je ne m\'en souviens pas',
    'i_cannot_remember_info' => 'Cette action est sans moyen de retour. Cela supprimera l\'ensemble des mots de passe présent dans les objets de votre répertoire personnel. Seuls les mots de passe seront supprimés, pas les objets.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Fichiers',
    'logs' => 'Journaux',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Clés de chiffrement',
    'clearing_old_sharekeys' => 'Supprimer les anciennes clés partagées',
    'hit_launch_to_start' => 'Merci de cliquer le bouton pour exécuter',
    'password_changed' => 'Mot de passe à jour',
    'password_already_used' => 'Mot de passe déjà utilisé',
    'change_login_password' => 'Changer le mot de passe d\'authentification',
    'current_password_mandatory' => 'Le mot de passe actuel est requis',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'La description a changé',
    'number_of_folders_imported' => 'Nombre de répertoires importés',
    'number_of_items_imported' => 'Nombre d\'objets importés',
    'propagate' => 'Diffuser',
    'propagate_user_rights' => 'Propager les droits utilisateur',
    'register_new_yubiko_key' => 'Enregistrer une nouvelle clé Yubiko',
    'part_of_groups' => 'Appartient aux Rôles',
    'previous_value' => 'Valeur précédente',
    'no_previous_value' => 'Pas de valeur précédente',
    'no_data_selected' => 'Pas de donnée sélectionnée',
    'selected_items_to_be_imported' => 'Sélectionner les objets à importer',
    'cannot_open_file' => 'Le fichier ne peut pas être ouvert',
    'no_item_found' => 'Pas d\'élément trouvé',
    'reading_file' => 'Lecture du fichier en cours',
    'where_shall_items_be_created' => 'Destination des objets à créer',
    'target_folder' => 'Fichier cible',
    'select_file' => 'Choisissez le fichier',
    'data_type_for_import' => 'Commencez par choisir le type de source à importer',
    'get_tips_about_importation' => 'Quelques astuces relatives à l\'importation',
    'import_new_items' => 'Importer de nouveaux objets',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'pour',
    'request_access' => 'Demander un accès à l\'objet',
    'request_access_message' => 'Lorsque vous demandez l\'accès à un objet, un email est envoyé à l\'auteur. L\'auteur peut accepter ou refuser votre requête en vous ajoutant à la liste de restriction de l\'objet. Veuillez confirmer pour envoyer votre demande à l\'auteur.',
    'request_access_reason' => 'Fournissez la raison de votre demande',
    'error_provide_reason' => 'Merci de renseigner la raison de l\'accès à cet objet',
    'need_access' => 'Besoin de l\'accès ?',
    'item_with_restricted_access' => 'Elément avec accès restreint',
    'remaining_emails_to_send' => 'Nombre d\'emails restant à envoyer',
    'mfa_flash' => 'Flasher avec un smartphone',
    'import' => 'Importer',
    'export' => 'Exporter',
    'offline' => 'Hors ligne',
    'login_attempts_identified_since_last_connection' => 'Votre attention est requise. Au moins une tentative d\'identification depuis votre compte a été détectée depuis votre dernière connexion réussie. Veuillez vérifier et contacter votre administrateur local si vous n\'êtes pas l\'auteur de cette tentative d\'identification.',
    'last_login_attempts' => 'Dernières tentatives de connexion',
    'see_detail' => 'Voir le détail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Pas encore implémenté',
    '2factors_expected_for_admin' => 'L\'administrateur doit utiliser l\'authentification multifacteurs pour s\'identifier.',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'La restauration de la base de données a été effectuée. Veuillez maintenant vous déconnecter pour rafraîchir les variables de session.',
    'backup_and_restore' => 'Sauvegarder et restaurer',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Effectuer une sauvegarde',
    'perform_restore' => 'Effectuer une restauration',
    'backup_select' => 'Fichier de sauvegarde',
    'choose_file' => 'Choisir un fichier',
    'on_the_fly' => 'À la volée',
    'scheduled' => 'Programmé',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Attention - la suppression de ce champ entraînera la suppression des données liées dans les objets',
    'error_could_not_update_the_field' => 'Une erreur est survenue lors de la mise à jour du champ. Merci de recharger la page et de ré-essayer.',
    'caution_while_deleting_category' => 'Attention, en supprimant ce répertoire, tous les objets et sous-répertoires seront également effacés.',
    'your_attention_please' => 'Votre attention s\'il vous plaît',
    'all_fields_are_required' => 'Tous les champs sont requis',
    'position' => 'Position',
    'before' => 'Avant',
    'top' => 'Haut',
    'bottom' => 'Bas',
    'field' => 'Champ',
    'configuration' => 'Paramétrage',
    'definition' => 'Définition',
    'number_of_modified_attachments' => 'Nombre de pièces jointes modifiées',
    'files_not_encrypted' => 'Actuellement, les fichiers ne sont pas chiffrés. Pour des raisons de sécurité, vous devriez les chiffrer.',
    'files_already_encrypted' => 'Les fichiers sont déjà chiffrés. Vous ne devriez pas changer cette option, pour des raisons de sécurité.',
    'action_to_be_performed' => 'Action à réaliser',
    'last_execution' => 'Dernière exécution',
    'never_performed' => 'Jamais réalisé',
    'launch' => 'Lancer',
    'set_of_actions' => 'Actions possibles',
    'uploads' => 'Téléchargements',
    'uploads_configuration' => 'Paramètres de téléversement',
    'email_configuration' => 'Configuration de la messagerie',
    'email_configuration_test' => 'Tester la configuration de la messagerie',
    'send_a_test_email' => 'Envoyer un email de test',
    'manage_emails_not_sent' => 'Gérer les messages non envoyés',
    'email_send_backlog' => '#nb_emails# non envoyé·s',
    'send_waiting_emails' => 'Envoyer les emails en attente',
    'ip' => 'IP',
    'no_data_defined' => 'Aucune donnée n\'a été définie.',
    'adding_new_api_ip' => 'Ajout d\'une nouvelle adresse IP à la liste blanche.',
    'adding_new_api_key' => 'Ajout d\'une nouvelle clé d\'API',
    'api_configuration' => 'Paramétres de l\'API',
    'mfa_configuration' => 'Configuration de l\'authentification multifacteurs',
    'yubico_authentication_tip' => 'Veuillez visiter www.yobico.com for plus de détails.',
    'complexity_level_not_reached' => 'Niveau de complexité requise non atteint',
    'expected_complexity_level' => 'Niveau de complexité requis',
    'your_attention_is_required' => 'Merci de votre attention',
    'favorite' => 'Favori',
    'unfavorite' => 'Non favori',
    'you_need_to_select_at_least_one_folder' => 'Vous devez sélectionner au moins un répertoire',
    'no_value_defined_please_fix' => 'Aucune valeur définie ! Vous devriez le faire.',
    'apply' => 'Appliquer',
    'from' => 'De',
    'please_confirm_by_clicking_checkbox' => 'Merci de confirmer en cliquant la case à cocher',
    'date_range' => 'Période',
    'purge' => 'Purger',
    'belong_of_deleted_folder' => 'Appartient à un répertoire supprimé',
    'highlight_selected' => 'Mettre en évidence la sélection',
    'number_of_selected_objects' => 'Nombre d\'objets sélectionnés',
    'confirm_selection_restore' => 'Merci de confirmer la restauration des objets sélectionnés.',
    'confirm_selection_delete' => 'Merci de confirmer la suppression des objets sélectionnés.',
    'refreshing' => 'Rafraichissement',
    'empty_list' => 'Liste vide',
    'deleted_folders' => 'Répertoires supprimés',
    'deleted_items' => 'Objets supprimés',
    'recycled_bin' => 'Corbeille',
    'database' => 'Base de données',
    'renewal' => 'Renouvellement',
    'renewal_delay' => 'Délais avant renouvellement',
    'please_confirm_deletion' => 'Merci de confirmer la suppression',
    'caution' => 'Attention',
    'role_not_exist' => 'Ce rôle n\'existe pas !',
    'role_can_edit_any_visible_item' => 'Ce rôle peut éditer n\'importe quel objet visible',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Modification autorisée',
    'delete_allowed' => 'Suppression autorisée',
    'add_allowed' => 'Ajout autorisé',
    'edit_not_allowed' => 'Modification non autorisée',
    'delete_not_allowed' => 'Suppression non autorisée',
    'select_a_role' => 'Sélectionner un rôle',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Veuillez confirmer',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'En cochant cette case, vous confirmez la suppression de cet utilisateur.',
    'fields_with_mandatory_information_are_missing' => 'Certains champs obligatoires ne sont pas renseignés',
    'enable_personal_folder_for_this_user' => 'Activer la fonctionnalité "dossier personnel" pour cet utilisateur.',
    'special' => 'Special',
    'administrator' => 'Administrateur',
    'super_manager' => 'Gestionnaire Teampass',
    'manager' => 'Gestionnaire',
    'read_only' => 'Lecture seule',
    'privileges' => 'Privilèges',
    'roles' => 'Rôles',
    'user_definition' => 'User definition',
    'no_selection_done' => 'Aucune sélection',
    'tick_confirmation_box' => 'Merci de cocher la case pour confirmer',
    'next_list_to_be_deleted' => 'Cette liste sera supprimée',
    'delete_folders' => 'Supprimer des répertoires',
    'submit' => 'Soumettre',
    'label' => 'Intitulé',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Ajouter un répertoire',
    'new' => 'Nouveau',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Authentification multifacteurs',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Authentificateur Yubico',
    'website_canal' => 'Cliquer pour accéder à Teampass.net',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'Aucun changement réalisé',
    'password_strength' => 'Complexité',
    'new_password_required' => 'Un nouveau mot de passe est requis',
    'limited_search' => 'Recherche limitée',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'Vous n\'avez aucun favori',
    'favorites' => 'Favoris',
    'confirm_item_move' => 'Déplacement ... merci de confirmer ?',
    'copy_to_clipboard' => 'Copier dans le presse-papier',
    'please_wait_while_loading' => 'Merci de patienter le temps du chargement des données',
    'defect_report' => 'Rapport de défaut',
    'actions' => 'Actions',
    'no_user' => 'Mauvais utilisateur',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profil',
    'language' => 'Langue',
    'upload_new_avatar' => 'Sélectionner un avatar (.PNG)',
    'settings' => 'Paramétres',
    'created_items' => 'Objets créés',
    'modification_performed' => 'Modifications réalisées',
    'items_opened' => 'Objets consultés',
    'passwords_seen' => 'Mots de passe consultés',
    'nothing_to_save' => 'Rien à sauvegarder',
    'notification_engaged' => 'Vous serez notifier sur modification',
    'notification_not_engaged' => 'Vous ne serez pas notifier sur modification',
    'viewed_number' => 'Nombre de vues',
    'automatic_deletion_engaged' => 'Suppression automatique',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Copier le dossier',
    'select_source_folder' => 'Sélectionner le répertoire à copier',
    'select_destination_folder' => 'Sélectionner le répertoire de destination',
    'delete_folder' => 'Supprimer',
    'select_folder_to_delete' => 'Sélectionner le répertoire à supprimer',
    'folder_delete_confirm' => 'Le répertoire sélectionné ainsi que tous les objets seront supprimés. Merci de confirmer en cochant la case.',
    'json_error_format' => 'Format JSON corrompu',
    'password_cannot_be_empty' => 'Un mot de passe doit être saisi',
    'password_too_long' => 'Le mot de passe est trop long',
    'error_no_action_identified' => 'Aucune action identifiée',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Sauvegardes',
    'api' => 'API',
    'add_folder' => 'Ajouter un nouveau répertoire',
    'select_folder_parent' => 'Sélectionner le répertoire parent',
    'add' => 'Ajouter',
    'key_is_not_correct' => 'La clé de session n\'est pas conforme',
    'suggestion_information' => 'Suggérer un changement ? Merci de renseigner le formulaire et valider pour informer l\'auteur.',
    'email_address' => 'Email',
    'enter_email' => 'Saisir l\'email',
    'notification' => 'Notification',
    'notify_on_change' => 'Me notifier en cas de changement',
    'notification_message' => 'Vous pouvez utiliser cette option pour recevoir des notifications lors de changements réalisés sur cet objet.',
    'share_item' => 'Partager',
    'share_item_message' => 'Vous pouvez partager cet object. Pour cela, indiquer un email et cliquer le bouton.',
    'delete_item_message' => 'Vous avez décider de supprimer cet objet. Merci de confirmer votre choix.',
    'warning' => 'Attention',
    'information' => 'Information',
    'perform' => 'Réaliser',
    'delete_item' => 'Supprimer',
    'copy_item' => 'Copier',
    'new_item' => 'Nouveau',
    'error_not_allowed_to_edit_item' => 'Vous n\'êtes pas autoriser à éditer cet objet',
    'error_not_allowed_to_access_this_folder' => 'Vous n\'êtes pas autoriser à accéder à ce répertoire',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'Aucun champ pour cet objet',
    'uploaded' => 'Téléversé',
    'changes_ongoing' => 'Certains changements n\'ont pas été sauvegardé. Confirmez-vous la fermeture ?',
    'no_file_to_upload' => 'Aucun fichier à téléverser',
    'add_files_and_click_start' => 'Sélectionner des fichiers et cliquer le bouton',
    'select_files' => 'Sélectionner des fichiers',
    'attached_files' => 'Fichiers attachés',
    'visible_by' => 'Visible par',
    'anounce_item_by_email' => 'Informer des utilisateurs',
    'select_users_if_needed' => 'Sélectionner les utilisateurs à informer',
    'allow_item_to_be_deleted' => 'Autoriser la suppression de cet objet au critère',
    'item_deleted_after_being_viewed_x_times' => 'Après avec été vue X fois',
    'item_deleted_after_date' => 'Après une date prédéfinie',
    'password' => 'Mot de passe',
    'save' => 'Sauvegarder',
    'folder' => 'Dossier',
    'main' => 'Principal',
    'fields' => 'Champs',
    'details' => 'Détails',
    'no_special_restriction' => 'Sans restriction',
    'generate_otv_link' => 'Gérérer un lien de visualisation unique',
    'no_custom_fields' => 'Pas de champs personnalisés',
    'no_attachment' => 'Pas de pièce jointe',
    'logout_confirm' => 'Se déconnecter ?Veuillez confirmer',
    'saved' => 'Sauvegardé',
    'attachments' => 'Fichiers joints',
    'success' => 'Succès',
    'server_answer_error' => 'Une erreur est survenue. La réponse du serveur ne peut pas être interprétée !',
    'server_returned_data' => 'Données retournées',
    'version_alone' => 'version',
    'statistics' => 'Statistiques',
    'options' => 'Options',
    'users' => 'Utilisateurs',
    'folders' => 'Dossiers',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objets trouvés',
    'auto_update_server_password_info' => 'En cliquant sur le bouton COMMENCER, les différentes actions seront réalisées :<ul><li>Une connexion SSH sera ouverte avec le serveur Linux en utilisant les identifiants et l\'URL fournis,</li><li>Le mot de passe de l\'utilisateur sera changé,</li><li>Le nouveau mot de passe sera sauvegardé dans Teampass,</li><li>La connexion SSH sera fermée.</li></ul><br><b>Merci de vous assurer que l\'utilisateur dispose des privilèges Root sur le serveur avant de commencer (sinon vous disposez de champs supplémentaires pour saisir les identifiants d\'un compte root).',
    'share' => 'Partager cet élément',
    'notify' => 'Notifier',
    'error_no_selected_folder' => 'Vous devez sélectionner un dossier',
    'email_subject_item_updated' => 'Mot de passe mis à jour',
    'email_body_item_updated' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>Le mot de passe de l"élément "#item_label#" a été mis à jour.<br /><br />Vous pouvez le vérifier <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">ICI</a><br /><br />Salutation',
    'import_kp_finished' => 'L\'importation depuis KeePass est maintenant terminée ! Par défaut, le niveau de complexité des nouveaux dossiers a été défini à \'Moyen\'. Vous devriez peut-être le changer en fonction de vos besoins.',
    'password_is_empty' => 'L\'élément n\'a pas de mot de passe',
    'bug_report_to_github' => 'Complétez le contenu du rapport, copiez le contenu dans le presse-papier et collez-le dans un nouveau rapport dans Github.',
    'open_bug_report_in_github' => 'Ouvrir un ticket sur Github',
    'bugs_page' => 'Pour tout problème, merci de créer un ticket.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Permettre la modification par n\'importe qui ayant le même rôle que les éléments importés.',
    'import_csv_anyone_can_modify_txt' => 'Permettre la modification par n\'importe qui des éléments importés.',
    'settings_upload_imageresize_options' => 'Les Images doivent-elles être redimensionnées ?',
    'user_not_exists' => 'Cet utilisateur n\'existe pas !',
    'auto_create_folder_role' => 'Créer un nouveau dossier et un rôle pour',
    'start_upload' => 'Lancer le chargement des nouveaux fichier',
    'error_upload_runtime_not_found' => 'Téléversement : aucun environnement d\'exécution trouvé.',
    'user_profile_api_key' => 'Votre clé API',
    'index_change_pw' => 'Changer votre mot de passe',
    'admin_2factors_authentication_setting' => 'Activer l\'authentification Google en deux étapes',
    'admin_2factors_authentication_setting_tip' => 'L\'authentification Google en deux étapes permet d\'accroître la sécurité de connexion des Utilisateurs. Dès qu\'un utilisateur veut se connecter, un code à usage unique est généré. Ce code doit être scanné et fourni par l\'utilisateur en plus de son mot de passe traditionnel.<br />ATTENTION : Cette fonctionnalité nécessite une connexion permanente à Internet ainsi qu\'un smartphone',
    'admin_ga_website_name' => 'Nom affiché pour Teampass  dans Google Authenticator',
    'admin_ga_website_name_tip' => 'Ce nom sera affiché pour le code d\'identification dans l\'application Google Authenticator',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] Un élément a été partagé avec vous',
    'email_share_item_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br><u>#tp_user#</u> a partagé l\'élément <b>#tp_item#</b> avec vous.<br>Cliquez le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br>Cordialement.',
    'index_maintenance_mode_admin' => 'Mode Maintenance activé. Les Utilisateurs ne peuvent pas se connecter à TeamPass.',
    '2fa_authentication_selector' => 'Authentification double',
    'upload_empty_file' => 'Téléverser des fichiers vides',
    'upload_any_extension_file' => 'Téléverser tout type d\'extension de fichier',
    'upload_any_extension_file_tip' => 'Quand activé, cette option permet aux utilisateurs d\'attacher tout type de fichier aux objets.',
    'log_in' => 'Connexion',
    'create_item_based_upon_template' => 'Activer le Modèle par Objet',
    'create_item_based_upon_template_tip' => 'Quand activée, cette fonction permet à l\'auteur de choisir un modèle réalisé à partir des Champs Spéciaux. A noter que cela ne fonctionnera que si l\'option Champs Spéciaux est activée.',
    'main_template' => 'Utiliser comme Modèle',
    'is_mandatory' => 'Est obligatoire',
    'error_field_is_mandatory' => 'Au moins un champ spécial est obligatoire.',
    'restrict_visibility_to' => 'Uniquement visible par',
    'every_roles' => 'Tous les rôles',
    'masked_text' => 'Texte masqué',
    'textarea' => 'Zone de texte',
    'admin_yubico_authentication_setting' => 'Activer la double identification avec Yubico',
    'yubico_user_id' => 'ID client',
    'yubico_user_key' => 'CLE secrète',
    'yubico_bad_code' => 'Mauvaises informations Yubico',
    'press_your_yubico_key' => 'Toucher la clé Yubico',
    'human_resources' => 'Super gestionnaire',
    'settings_secure_display_image' => 'Activer la sécurisation de prévisualisation des images',
    'settings_secure_display_image_tip' => 'Sécuriser la prévisualisation des images permet de réaliser la lecture de l\'image via le moteur de PHP quand un utilisateur demande un affichage d\'une image. Avantage: permet de sauvegarder les pièces jointes hors du domaine dans un dossier serveur inaccessible. Inconvéniant : l\'affichage de l\'image est légèrement ralentie.',
    'user_ga_code' => 'Envoyer le code Google Authenticator à l\'utilisateur par email',
    'error_no_email' => 'Cet utilisateur n\'a pas de courriel de défini !',
    'error_no_user' => 'Aucun utilisateur trouvé !',
    'email_ga_subject' => 'Votre code Google Authenticator pour Teampass',
    'email_ga_text' => 'Bonjour,<br><br>Cet email a été généré depuis votre gestionnaire de mots de passe Teampass.<br><br>Votre administrateur vous demande d\'utiliser une double authentification pour vous connecter à Teampass.<br>Lors de votre première connexion à Teampass, merci de bien vouloir recopier le code suivant dans le champ "Code d\'identification" : <br><br>----------------------<br>#2FACode#<br>----------------------<br><br>Vous aurez ensuite la possibilité de paramètrer votre application Google Authenticator pour obtenir vos codes temporaire d\'identification.<br /><br />Salutations',
    'settings_attachments_encryption' => 'Activer le chiffrement des fichiers joints aux Éléments',
    'settings_attachments_encryption_tip' => 'CETTE OPTION PEUT CORROMPRE LES FICHIERS JOINTS EXISTANTS. Merci de lire la suite avec attention. Si activée, cette option chiffrera les fichiers joints aux Éléments sur le serveur. L\'algorithme de chiffrement utilise le sel défini pour Teampass. Cela requiert également un peu de ressource supplémentaire de la part du serveur. ATTENTION : en cas de changement de stratégie, il est nécessaire de faire tourner le script permettant d\'adapter les fichiers joints existants. Pour cela, voir l\'onglet "Actions spécifiques".',
    'admin_action_attachments_cryption' => 'Déchiffrer ou chiffrer les fichiers joints aux Éléments',
    'admin_action_attachments_cryption_tip' => 'ATTENTION : cette opération ne DOIT être faite UNIQUEMENT après avoir modifié l\'option associée dans la page Paramètres. Merci de réaliser une sauvegarde du dossier \'upload\' avant de procéder.',
    'encrypt' => 'Chiffrer',
    'decrypt' => 'Déchiffrer',
    'ga_identification_code' => 'Code d\'identification',
    'ga_enter_credentials' => 'Merci de saisir vos identifiants de connexion',
    'ga_bad_code' => 'Le code Google Authenticator est faux',
    'settings_get_tp_info' => 'Charger automatiquement des informations à propos de Teampass',
    'settings_get_tp_info_tip' => 'Cette option chargera dans la page d\'administration des informations concernant les versions et librairies utilisées.',
    'settings_offline_mode' => 'Activer le mode Hors-Ligne',
    'settings_offline_mode_tip' => 'Le mode Hors-Ligne permet d\'exporter les Éléments dans un fichier HTML qui peut être lu avec un simple navigateur Internet. Les éléments sont chiffrés avec la clé saisie par l\'Utilisateur.',
    'offline_mode_key_level' => 'Niveau de chiffrement minimum de la clé du mode Hors-Ligne',
    'categories' => 'Catégories',
    'no_category_defined' => 'Aucune Catégorie n\'existe',
    'confirm_deletion' => 'Confirmer la suppression ?',
    'settings_item_extra_fields' => 'Permettre l\'ajout des champs complémentaires (par Catégories) à la définition des Éléments',
    'settings_item_extra_fields_tip' => 'Cette fonction permet d\'ajouter des champs personnalisés aux Éléments. Ces champs sont créés par un Administrateur et organisés en Catégories. Les données sauvegardées sont chiffrées. Attention, cette fonction consomme plus de requêtes SQL (environ 5 par champ lors de la mise à jour d\'un Élément) et peut surcharger votre serveur. Cela dépend de votre serveur.',
    'settings_ldap_type' => 'Type de serveur LDAP',
    'server_time' => 'Horaire serveur',
    'settings_tree_counters' => 'Montrer des compteurs dans l\'arborescence',
    'settings_tree_counters_tip' => 'Cette option affiche pour chaque dossier 3 compteurs : le nombre d\'éléments dans le dossier; le nombre d\'éléments dans l\'ensemble des sous-dossiers; le nombre de sous-dossiers.',
    'admin_action_check_pf' => 'Actualiser les Dossiers Personnels des utilisateurs (les créer s\'ils n\'existent pas)',
    'enable_personal_folder_feature_tip' => 'Une fois activé, il est nécessaire de lancer manuellement le script de mise à jour des dossiers personnels pour les utilisateurs existants. Cela ne créera les dossiers personnels que pour les utilisateurs n\'en n\'ayant pas à ce jour. Le script \'".$txt[\'admin_action_check_pf\']."\' est accessible dans l\'onglet \'".$txt[\'admin_actions_title\']."\'.',
    'administrators_only' => 'Administrateurs uniquement',
    'managers_of' => 'Managers du Role',
    'managed_by' => 'Administré par',
    'settings_enable_sts' => 'Renforcer la sécurité relative à HTTPS -- Attention : bien lire l\'info-bulle',
    'settings_enable_sts_tip' => 'Cette option force le protocole HTTPS STS. STS permet de déjouer les attaques \'Man-in-the-Middle\'. Il est IMPÉRATIF de disposer d\'un certificat SSL valide pour pouvoir l\'utiliser. Ne pas activer l\'option avec un certificat auto-signé ! Vous devez vous assurer d\'avoir activé l\'option \'SSLOptions +ExportCertData\' SSL dans la configuration d\'Apache.',
    'settings_anyone_can_modify_bydefault' => 'Activer l\'option \'<b><i>Tout le monde peut modifier</b></i>\' par défaut',
    'to' => 'à',
    'settings_upload_maxfilesize_tip' => 'Taille maximum autorisée. Cette taille doit être cohérente avec les paramètrages du serveur.',
    'settings_upload_docext_tip' => 'Les types de Documents. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_imagesext_tip' => 'Les types d\'Images. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_pkgext_tip' => 'Les types de Compression. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_otherext_tip' => 'Les autres types. Préciser les extensions de fichiers autorisées en les séparant par une virgule (,)',
    'settings_upload_imageresize_options_tip' => 'Quand activée, cette option permet de redimensionner les Images au format indiqué ci-dessous.',
    'settings_upload_maxfilesize' => 'Taille maximum par fichier (en Mo)',
    'settings_upload_docext' => 'Extensions de Documents autorisées',
    'settings_upload_imagesext' => 'Extensions de Images autorisées',
    'settings_upload_pkgext' => 'Extensions de fichiers de Compression autorisées',
    'settings_upload_otherext' => 'Autres extensions autorisées',
    'settings_upload_imageresize_options_w' => 'Redimensionnement des Images en Largeur (en pixels)',
    'settings_upload_imageresize_options_h' => 'Redimensionnement des Images en Hauteur (en pixels)',
    'settings_upload_imageresize_options_q' => 'Qualité de l\'Image redimensionnée',
    'settings_importing' => 'Permettre d\'importer des données depuis des fichiers CVS/KeyPass',
    'admin_proxy_ip' => 'Adresse IP du proxy',
    'admin_proxy_ip_tip' => 'Si votre connexion intenet passe par un proxy, indiquer ici son IP. Sinon, laisser vide.',
    'admin_proxy_port' => 'Port du proxy',
    'admin_proxy_port_tip' => 'Si vous avez indiqué une IP pour le proxy, indiquez ici son port. En général 8080. Sinon, laisser vide.',
    'settings_ldap_elusers' => 'Utilisateurs locaux de TeamPass uniquement',
    'settings_ldap_elusers_tip' => 'Cette fonction autorise les utilisateurs de la base de données de s\'identifier via LDAP. Désactiver ceci si vous voulez utiliser un annuaire LDAP.',
    'db_items_edited' => 'Éléments actuellement en cours d\'édition',
    'item_edition_start_hour' => 'Édition démarrée depuis',
    'settings_delay_for_item_edition' => 'Après quelle durée, en minutes, l\'édition d\'un Élément est-elle considérée comme échouée',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Lorsqu\'un Élément est édité, ce dernier est verrouillé de façon à interdire toute autre édition parallèle.<br />Cette option permet de supprimer ce verrou automatiquement dès lors qu\'une durée en minute est écoulé. La valeur 0 indique que le verrou ne sera jamais supprimé automatiquement.</span>',
    'db_users_logged' => 'Utilisateurs actuellement connectés',
    'action' => 'Action',
    'login_time' => 'Connecté depuis',
    'lastname' => 'Nom',
    'user_login' => 'Identifiant',
    'role' => 'Rôle',
    'error_role_exist' => 'Ce Rôle existe déjà !',
    'error_no_edition_possible_locked' => 'Édition impossible. Cet élément est déjà en cours d\'édition !',
    'select' => 'Parcourir…',
    'items' => 'Éléments',
    'enable_personal_saltkey_cookie' => 'La clé personnelle de salage est sauvegardée dans un cookie',
    'personal_saltkey_cookie_duration' => 'Durée avant expiration du cookie de la clé personelle de salage',
    'admin_email_smtp_server' => 'Serveur SMTP',
    'admin_email_auth' => 'Le serveur SMTP requiert une authentification',
    'admin_email_auth_username' => 'Identifiant',
    'admin_email_auth_pwd' => 'Mot de passe',
    'admin_email_port' => 'Port du serveur',
    'admin_email_from' => 'E-mail de l\'expéditeur',
    'admin_email_from_name' => 'Nom de l\'expéditeur',
    'admin_email_test_configuration_tip' => 'Ce test va envoyer un e-mail à l\'adresse indiquée. Si vous ne le recevez pas, merci de vérifier le paramétrage.',
    'admin_email_test_subject' => '[TeamPass] E-mail de test',
    'admin_email_test_body' => 'Bonjour,<br /><br />E-mail envoyé avec succès.<br / ><br />Salutations',
    'admin_email_result_ok' => 'E-mail envoyé à #email# ... vérifiez votre boite de réception',
    'email_bodyalt_item_updated' => 'Le mot de passe de #item_label# a été mis à jour.',
    'admin_email_send_backlog_tip' => 'Ce script permet de forcer l\'envoi des e-mails dans la file d\'attente de la base de données.<br /> Cela peut prendre plusieurs minutes en fonction du nombre d\'e-mails à envoyer.',
    'please_wait' => 'Merci de patienter !',
    'admin_path_to_files_folder' => 'Chemin du dossier Fichiers (chemin complet)',
    'admin_path_to_files_folder_tip' => 'Le dossier Fichiers est utilisé pour sauvegarder tous les fichiers générés par TeamPass ainsi que certains fichiers envoyés.<br />IMPORTANT : pour des raisons de sécurité, ce dossier ne devrait pas être dans le dossier WWW de votre serveur. Il devrait être mis dans un endroit protégé avec une règle de redirection.<br />IMPORTANT 2 : Il serait bien de rajouter une tâche périodique pour supprimer son contenu.',
    'admin_path_to_upload_folder_tip' => 'Le dossier d\'Envoi contient tous les fichiers attachés à vos Éléments.<br />IMPORTANT : Pour des raisons de sécurité, ce dossier ne devrait pas être dans le dossier WWW de votre serveur. Il devrait être mis dans un endroit protégé avec une règle de redirection.<br />IMPORTANT 2 : Ce dossier ne doit absolument pas être nettoyé ! Ces fichiers sont associés à vos Éléments.',
    'pdf_password_warning' => 'Vous devez fournir une clé de chiffrement',
    'admin_pwd_maximum_length' => 'Longueur maximale des mots de passe',
    'admin_pwd_maximum_length_tip' => 'La valeur par défaut est fixée à 40 caractères. Il est important de savoir qu\'une taille plus grande aura un impact sur les performances de l\'outil. En effet plus la longueur du mot de passe est grande et plus il faut de temps au serveur pour chiffrer, déchiffrer et afficher les éléments',
    'settings_insert_manual_entry_item_history' => 'Permettre l\'insertion manuelle dans l\'Historique',
    'settings_insert_manual_entry_item_history_tip' => 'Il peut être parfois utile de saisir une entrée dans l\'historique d\'un Élément. En activant cette fonction, cela devient possible.',
    'admin_path_to_upload_folder' => 'Chemin du dossier d\'Envoi',
    'admin_setting_enable_delete_after_consultation' => 'L\'élément consulté peut être automatiquement supprimé',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Quand activée, cette option permet à l\'auteur de l\'élément de décider si ce dernier devra être automatiquement supprimé après avoir été consulté X fois.</span>',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Notifier par email lorsque l\'élément est consulté',
    'share_sent_ok' => 'E-mail envoyé',
    'see_item_title' => 'Détails de l\'élément',
    'email_on_open_notification_subject' => '[TeamPass] Notification suite à la consultation d\'un élément',
    'email_on_open_notification_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>#tp_user# a consulté l\'élément \'#tp_item#\'.<br>Cliquez sur le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br>Cordialement.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Votre nouveau compte',
    'email_new_user_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>Un Administrateur vous a créé un compte pour TeamPass.<br>Vos identifiants de connexion sont les suivants :<br>- Identifiant : #tp_login#<br>- Mot de passe : #tp_pw#<br><br>Cliquez sur le <a href="#tp_link#">LIEN</a> pour y accéder.<br><br>Cordialement',
    'error_empty_data' => 'Aucune donnée à traiter !',
    'error_not_allowed_to' => 'Vous n\'etes pas autorisé à faire cela !',
    'request_access_ot_item' => 'Demander un accès au créateur',
    'email_request_access_subject' => '[TeamPass] Demande d\'accès à un élément',
    'email_request_access_mail' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>L\'utilisateur #tp_user# a demandé un accès à \'#tp_item#\'.<br>Cette demande est accompagnée du justificatif suivant:<br><br><i>"#tp_reason#"</i><br><br>Merci de revoir et confirmer ou pas l\'accès.<br><br>Cordialement.',
    'admin_action_change_salt_key' => 'Changer la clé de salage principale',
    'nb_items_by_query' => 'Nombre d\'éléments à afficher par requête',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Plus d\'éléments signifie plus de temps pour les afficher.<br>Sélectionner \'auto\' pour laisser l\'outil choisir le nombre d\'éléments à afficher en fonction de la taille de l\'écran.<br>Sélectionner \'max\' pour forcer l\'affichage de la liste complète en une seule fois.<br>Sélectionner un nombre fixe d\'éléments à afficher à chaque nouvelle requête.</span>',
    'open_url_link' => 'Ouvrir dans une nouvelle page',
    'error_pw_too_long' => 'Mot de passe trop long ! Maximum 40 caractères.',
    'at_restriction' => 'Restriction',
    'pw_encryption_error' => 'Erreur de déchiffrement du mot de passe !',
    'enable_send_email_on_user_login' => 'Envoyer un email aux Administrateurs lorsqu\'un utilisateur se connecte',
    'email_subject_on_user_login' => '[TeamPass] Un utilisateur s\'est connecté',
    'email_body_on_user_login' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>L\'utilisateur #tp_user# s\'est connecté à TeamPass le #tp_date# à #tp_time#.<br><br>Cordialement.',
    'account_is_locked' => 'Ce compte est bloqué',
    'activity' => 'Activité',
    'add_role_tip' => 'Ajouter un rôle',
    'admin' => 'Administration',
    'admin_action_db_backup' => 'Réaliser une sauvegarde de la base de donnée',
    'admin_action_db_clean_items' => 'Retirer tous les éléments orphelins de la base de donnée',
    'admin_action_db_clean_items_tip' => 'Cela ne fera que supprimer tous les éléments qui sont associés à un dossier ayant été supprimé. Pensez à faire une sauvegarde avant',
    'admin_action_db_optimize' => 'Optimiser la base de donnée',
    'admin_action_db_restore' => 'Restaurer la base de donnée',
    'admin_action_purge_old_files' => 'Purger les vieux fichier',
    'admin_action_purge_old_files_tip' => 'Cela va supprimer les fichiers temporaires de plus de 7 jours',
    'admin_action_reload_cache_table' => 'Reconstruire la table Cache',
    'admin_action_reload_cache_table_tip' => 'Cela permet de reconstruire entièrement la table Cache. Cette action peut-être réalisée de temps en temps',
    'admin_help' => 'Aide',
    'admin_ldap_configuration' => 'Configuration LDAP',
    'admin_main' => 'Informations',
    'admin_misc_cpassman_dir' => 'Chemin d\'accès à TeamPass',
    'admin_misc_cpassman_url' => 'URL complète de TeamPass',
    'admin_misc_custom_login_text' => 'Texte personnel sur l\'écran de connexion',
    'admin_misc_custom_logo' => 'URL complète vers un logo personnel',
    'admin_misc_favicon' => 'URL du fichier favicon',
    'admin_settings' => 'Paramètres',
    'admin_settings_title' => 'Paramètres',
    'admin_setting_activate_expiration' => 'Activer l\'expiration des éléments',
    'admin_setting_activate_expiration_tip' => 'Quand activée, cette option permet de ne pas afficher les éléments expirés.',
    'admin_views' => 'Vues',
    'alert_message_done' => 'Fait !',
    'all' => 'tous',
    'anyone_can_modify' => 'Cet élément peut être modifié par tout utilisateur',
    'at' => 'à',
    'at_category' => 'Dossier',
    'at_copy' => 'Copie faite',
    'at_delete' => 'Suppression',
    'at_description' => 'Description.',
    'at_label' => 'Label',
    'at_login' => 'Login',
    'at_moved' => 'Déplacé',
    'at_personnel' => 'Personnel',
    'at_restored' => 'Restauré',
    'at_shown' => 'Vu',
    'at_url' => 'URL',
    'author' => 'Auteur',
    'authorized_groups' => 'Dossiers autorisés',
    'auth_creation_without_complexity' => 'Autoriser la création d\'un élément sans que le niveau de complexité ne soit atteint',
    'auth_modification_without_complexity' => 'Autoriser la modification d\'un élément sans que le niveau de complexité ne soit atteint',
    'cancel' => 'Annuler',
    'can_create_root_folder' => 'Peut créer un dossier à la racine',
    'changelog' => 'Évolutions',
    'close' => 'Fermer',
    'complexity' => 'Complexité',
    'complex_asked' => 'Complexité requise',
    'complex_level0' => 'Très faible',
    'complex_level1' => 'Faible',
    'complex_level2' => 'Moyen',
    'complex_level3' => 'Fort',
    'complex_level4' => 'Très fort',
    'complex_level5' => 'Sûr',
    'complex_level6' => 'Très sûr',
    'confirm' => 'Confirmation',
    'confirm_del_from_fav' => 'Merci de confirmer la suppression.',
    'connections' => 'Connexions',
    'copy' => 'Copier',
    'copy_to_clipboard_small_icons' => 'Activer les icônes de copie dans le presse-papier',
    'copy_to_clipboard_small_icons_tip' => '<span style="font-size:11px;max-width:300px;">Cela peut permettre de limiter l\'utilisation de la mémoire de l\'ordinateur.<br />En effet, le presse-papier n\'est pas utilisé pour charger les informations des éléments. Dans ce cas, aucune copie rapide n\'est possible.</span>',
    'date' => 'Date',
    'date_format' => 'Format de la date',
    'delete' => 'Supprimer',
    'deletion' => 'Suppressions',
    'del_button' => 'Supprimer',
    'description' => 'Description',
    'disconnect' => 'Déconnexion',
    'done' => 'Fait',
    'duplicate_folder' => 'Les dossiers peuvent avoir des noms identiques',
    'duplicate_item' => 'Autoriser plusieurs éléments avec le même nom.',
    'email' => 'E-mail',
    'email_subject' => 'Création d\'un nouveau mot de passe',
    'enable_favourites' => 'Autoriser les utilisateurs à utiliser les Favoris',
    'enable_personal_folder' => 'Activer le Dossier Personnel',
    'enable_personal_folder_feature' => 'Activer la fonctionnalité de Dossier Personnel',
    'enable_user_can_create_folders' => 'Les utilisateurs peuvent gérer les sous-dossiers auxquels ils ont accès.',
    'encrypt_key' => 'Clé de chiffrement',
    'errors' => 'Erreurs',
    'error_group_exist' => 'Ce dossier existe déjà !',
    'error_html_codes' => 'Du texte contient du code html. Ceci n\'est pas une bonne idée !',
    'error_item_exists' => 'Cet élément existe déjà !',
    'error_label' => 'Un intitulé est obligatoire !',
    'error_must_enter_all_fields' => 'Vous devez saisir chaque champs !',
    'error_pw' => 'Un mot de passe est obligatoire !',
    'error_tags' => 'Aucune ponctuation n\'est autorisée ! Seulement des espaces.',
    'error_user_exists' => 'L\'utilisateur existe déjà !',
    'expiration_date' => 'Date d\'expiration',
    'find' => 'Rechercher',
    'forbidden_groups' => 'Dossiers interdits',
    'forgot_my_pw_email_sent' => 'E-mail envoyé',
    'functions' => 'Rôles',
    'gestionnaire' => 'Gestionnaire',
    'god' => 'Administrateur',
    'group' => 'Dossier',
    'group_parent' => 'Dossier parent',
    'group_pw_duration' => 'Période de renouvellement',
    'group_pw_duration_tip' => 'En mois. 0 pour désactiver.',
    'history' => 'Historique',
    'home_personal_saltkey' => 'Votre clé personnelle de salage',
    'home_personal_saltkey_label' => 'Saisir votre clé personnelle de salage',
    'import_error_no_read_possible' => 'Impossible de lire le fichier !',
    'import_error_no_read_possible_kp' => 'Lecture du fichier impossible ! Il ne semble pas etre généré par KeePass.',
    'import_keepass_to_folder' => 'Choisir le dossier de destination',
    'index_add_one_hour' => 'Ajouter une heure',
    'index_change_pw_confirmation' => 'Confirmation',
    'index_expiration_in' => 'expiration de la session dans',
    'index_get_identified' => 'Merci de vous identifier',
    'index_last_pw_change' => 'Mot de passe changé la dernière fois le',
    'index_last_seen' => 'Dernière connexion, le',
    'index_login' => 'Compte',
    'index_new_pw' => 'Nouveau mot de passe',
    'index_password' => 'Mot de passe',
    'index_pw_error_identical' => 'Les mots de passe doivent être identiques !',
    'index_pw_level_txt' => 'Complexité',
    'index_session_duration' => 'Durée de la session',
    'info' => 'Informations',
    'item_menu_copy_login' => 'Copier l\'identifiant',
    'item_menu_copy_pw' => 'Copier le mot de passe',
    'item_menu_del_from_fav' => 'Supprimer des Favoris',
    'kbs' => 'KBs',
    'kb_menu' => 'Base de connaissance',
    'last_items_title' => 'Derniers éléments vus',
    'ldap_extension_not_loaded' => 'L\'extension LDAP n\'est pas activée sur le serveur.',
    'level' => 'Niveau',
    'login' => 'Identifiant',
    'mask_pw' => 'Afficher/Masquer le mot de passe',
    'max_last_items' => 'Nombre maximum d\'éléments dernièrement vus (par défaut 10)',
    'minutes' => 'minutes',
    'name' => 'Nom',
    'nb_false_login_attempts' => 'Nombre de tentatives de connexion erronées avant blocage (0 pour désactiver)',
    'nb_folders' => 'Nombre de dossiers',
    'nb_items' => 'Nombre d\'éléments',
    'new_label' => 'Nouvel intitulé',
    'no' => 'Non',
    'none' => 'Aucun',
    'none_selected_text' => 'Aucun',
    'not_allowed_to_see_pw' => 'Vous n\'avez pas le droit de consulter ce mot de passe',
    'not_allowed_to_see_pw_is_expired' => 'Cet élément a expiré !',
    'not_defined' => 'Non défini',
    'number_of_used_pw' => 'Nombre de mots de passe différents saisis avant de pouvoir en réutiliser un',
    'pages' => 'Pages',
    'pdf_download' => 'Télécharger le fichier',
    'personal_salt_key' => 'Votre clé personnel',
    'pw' => 'Mots de passe',
    'pw_generate' => 'Générer',
    'pw_is_expired_-_update_it' => 'Cet élément a expiré ! Vous devez changer son mot de passe.',
    'pw_life_duration' => 'Durée en jours avant expiration d\'un mot de passe utilisateur (0 pour désactiver)',
    'readme_open' => 'Ouvrir le fichier ReadMe complet',
    'read_only_account' => 'Lecture Seule',
    'restore' => 'Restaurer',
    'restricted_to' => 'Restreint à',
    'restricted_to_roles' => 'Autoriser la restriction des éléments aux Utilisateurs et aux Rôles',
    'root' => 'Racine',
    'secure' => 'Sécurisé',
    'see_logs' => 'Voir les journaux',
    'settings_anyone_can_modify' => 'Activer l\'option permettant que chaque élément soit modifiable',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">Quand activé, cela rajoutera une option dans la fiche de création et édition de l\'élément qui permettra à l\'auteur d\'autoriser la modification de l\'élément par tout utilisateur.</span>',
    'settings_default_language' => 'Définir la langue par défaut',
    'settings_kb' => 'Activer la Base de Connaissance (béta)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Quand activé, cela ajoutera la possibilité de créer votre propre Base de Connaissance au travers d\'une page dédiée.</span>',
    'settings_ldap_domain' => 'Suffixe LDAP de votre domaine',
    'settings_ldap_domain_controler' => 'Tableau des contrôleurs de votre domaine LDAP',
    'settings_ldap_domain_controler_tip' => '<span style="font-size:11px;max-width:300px;">Vous pouvez spécifier plusieurs contrôleurs si vous désirez que la classe balance les requetes LDAP sur plusieurs serveurs.<br />Attention, vous devez délimiter les domaines par une virgule ( , )!<br />Par exemple : domaine_1,domaine_2,domaine_3</span>',
    'settings_ldap_domain_dn' => 'Base dn de votre domaine LDAP',
    'settings_ldap_mode' => 'Activer l\'identification LDAP des utilisateurs',
    'settings_ldap_mode_tip' => 'A activer seulement si vous avez un serveur LDAP et si vous voulez que les utilisateurs TeamPass s\'authentifient par celui-ci.',
    'settings_ldap_ssl' => 'Connexion SSL de votre LDAP (LDAPS)',
    'settings_ldap_tls' => 'Connexion TLS de votre LDAP',
    'settings_log_accessed' => 'Activer la journalisation des accès aux éléments',
    'settings_log_connections' => 'Activer la sauvegarde en base de données des connexions utilisateurs',
    'settings_maintenance_mode' => 'Passer TeamPass en mode Maintenance',
    'settings_manager_edit' => 'Les Gestionnaires peuvent éditer et supprimer les éléments auxquels ils ont accès.',
    'settings_printing' => 'Autoriser l\'impression PDF des éléments',
    'settings_printing_tip' => 'Quand activé, un bouton sera rajouté sur la page d\'accueil permettant à l\'utilisateur d\'imprimer un listing PDF des éléments auxquels il a accès. Attention, cette liste laisse apparaître les mots de passe sans chiffrement.',
    'settings_restricted_to' => 'Restreindre l\'accès aux Eléments',
    'settings_show_description' => 'Afficher la Description dans la liste des éléments',
    'size' => 'Taille',
    'tags' => 'Mots clé',
    'timezone_selection' => 'Choix du fuseau horaire',
    'time_format' => 'Format de l\'heure',
    'url' => 'URL',
    'user' => 'Utilisateur',
    'users_online' => 'utilisateur(s) en ligne',
    'user_alarm_no_function' => 'Cet utilisateur n\'a aucune Rôle associée !',
    'yes' => 'Oui',
    'one_time_view_item_url_box' => 'Partager l\'URL de Vue Unique avec une personne de confiance<br><br>#URL#<br><br>Ce lien ne sera visible qu\'une seule fois jusqu\'au #DAY#',
    'settings_api' => 'Autoriser l\'accès aux éléments de Teampass via l\'API',
    'settings_api_tip' => 'L\'accès via API permet d\'accéder aux éléments depuis une tierce application au format JSON.',
    'settings_api_keys_list' => 'Liste des clés',
    'settings_api_keys_list_tip' => 'Ce sont les clés d\'accès autorisées. Sans une clé valide, l\'accès n\'est pas possible. Vous devez partager ces clés avec précaution.',
    'settings_api_key' => 'Clé',
    'settings_api_add_ip' => 'Ajouter une nouvelle IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Tout nouveau sous-dossier hérite des droits du dossier parent',
    'subfolder_rights_as_parent_tip' => 'Si cette option est activée, chaque nouveau sous-dossier hérite des rôles et des autorisations du dossier parent. Sinon, les autorisations du dossier sont attribuées en fonction du rôle de l\'utilisateur qui les créé.',
    'show_only_accessible_folders_tip' => 'Par défaut, un utilisateur voit l\'arbre des dossiers dans son ensemble ce qui inclut les répertoires auxquels il n\'a pas accès. Il est possible de simplifier cette vue en supprimant ces dossiers auxquels il n\'a pas accès de l\'affichage de l\'arbre.',
    'show_only_accessible_folders' => 'Rendre l\'affichage de l’arbre des dossiers plus lisible.',
    'comment' => 'Commentaire',
    'suggestion_menu' => 'Suggestions',
    'settings_suggestion' => 'Autoriser le système de Suggestion pour les utilisateurs en lecture seule',
    'settings_suggestion_tip' => 'Le système de Suggestions permet aux utilisateurs en lecture seule de pouvoir proposer de nouveaux Élément ou d\'en demander la modification. Les Suggestions sont validées par les Administrateurs et les Gestionnaires.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'DN LDAP',
    'settings_ldap_bind_passwd' => 'Mot de Passe LDAP',
    'settings_ldap_search_base' => 'Base de Recherche LDAP',
    'settings_ldap_bind_dn_tip' => 'Un identifiant qui attache et recherche les utilisateurs de l\'arbre',
    'settings_ldap_bind_passwd_tip' => 'Mot de passe pour l\'identifiant qui attache et recherche les utilisateurs de l\'arbre',
    'settings_ldap_search_base_tip' => 'Recherche le root dn pour les recherches dans l\'arbre',
    'admin_email_server_url' => 'URL serveur pour les liens dans les emails',
    'enable_email_notification_on_user_pw_change' => 'Envoyer un e-mail à l\'utilisateur une fois que son mot de passe est changé',
    'settings_otv_expiration_period' => 'Délai avant l\'expiration d\'un élément partagé à vue unique',
    'write' => 'Ecriture',
    'read' => 'Lecture',
    'no_access' => 'Aucun accès',
    'right_types_label' => 'Sélectionner le type d\'accès à ce dossier pour le groupe d\'utilisateurs sélectionné',
    'duplicate_item_in_folder' => 'Autoriser les doublons dans un même dossier',
    'settings_roles_allowed_to_print' => 'Définir le rôle autorisé à imprimer les éléments',
    'settings_roles_allowed_to_print_tip' => 'Les rôles sélectionnés seront autorisés à imprimer les Éléments.',
    'admin_email_security' => 'Sécurité SMTP',
    'alert_page_will_reload' => 'La page va maintenant être rechargée',
    'file_protection_password' => 'Définir le mot de passe du fichier',
    'expand' => 'Étendre ',
    'collapse' => 'Réduire',
    'settings_ldap_user_attribute' => 'Attribut dans lequel rechercher l\'utilisateur',
    'settings_ldap_user_attribute_tip' => 'Attribut LDAP dans lequel rechercher l\'utilisateur',
    'log_user_initial_pwd_changed' => 'Mot de passe initial défini',
    'log_user_email_changed' => 'Email de l\'utilisateur changé par ',
    'log_user_created' => 'Compte utilisateur créé',
    'log_user_locked' => 'L\'utilisateur a été bloqué',
    'log_user_unlocked' => 'L\'utilisateur a été débloqué',
    'log_user_pwd_changed' => 'Mot de passe de l\'utilisateur a été changé',
    'settings_default_session_expiration_time' => 'Délais par défaut pour l\'expiration d\'une session utilisateur',
    'settings_duo' => 'Activer DUO Security pour l\'authentification utilisateur à 2 facteurs',
    'settings_duo_tip' => 'L\'authentification utilisateur à deux facteurs peut être assurée par DUOSecurity.com. Cette bibliothèque guarantie un niveau de sécurité élevé pour l\'authentification utilisateur. ',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Ces identifiants sont issues de l\'application web dédiée depuis la page d\'administration DUOSecurity dans le cadre de l\'utilisation de Teampass.<br/>En validant, vous acceptez la sauvegarde de ceux-ci au sein du fichier sk.php',
    'admin_duo_intro' => 'Remplir le champs suivant avec les informations escomptés',
    'edit' => 'Editer',
    'user_info_locked' => 'L\'utilisateur est VERROUILLER',
    'user_info_unlock_question' => 'Déverrouiller le compte ? ',
    'user_info_lock_question' => 'Verrouiller le compte ?',
    'user_info_delete_question' => 'Supprimer le compte ?',
    'user_info_active' => 'L\'utilisateur est actuellement ACTIVÉ.',
    'refresh' => 'Rafraîchir',
    'loading' => 'En chargement',
    'searching' => 'Recherche en cours ...',
    'list_items_with_tag' => 'Liste des éléments avec le mot clé',
    'no_item_to_display' => 'Aucun élément à afficher',
    'opening_folder' => 'Lecture du dossier ...',
    'suggestion_notify_subject' => '[Teampass] Une nouvelle suggestion a été faite.',
    'suggestion_notify_body' => 'Bonjour,<br><br>Une nouvelle suggestion a été faite. Vous devez la valider avant qu\'elle ne puisse servir à d\'autres utilisateurs.<br>Ses informations :<br>- Titre: #tp_label#<br>- Dossier: #tp_folder#<br>- Utilisateur: #tp_user#<br><br>Veuillez noter que cet e-mail a été envoyé à tous les administrateurs.<br><br>Cordialement.',
    'error_unknown' => 'Une erreur inatendue est arrivée !',
    'no_edit' => 'Écrire mais sans éditer',
    'role_cannot_edit_item' => 'Ne peut pas éditer des éléments',
    'no_delete' => 'Écrire mais sans effacer',
    'role_cannot_delete_item' => 'Ne peut pas effacer des éléments',
    'my_profile' => 'Mon Profil',
    'starting' => 'Initialisation ...',
    'total_number_of_items' => 'Nombre total d\'éléments',
    'finalizing' => 'Finalisation',
    'treating_items' => 'Eléments traités',
    'number_of_items_treated' => 'Nombre d\'éléments traités',
    'error_sent_back' => 'L\'erreur suivante est apparue',
    'full' => 'Complet',
    'sequential' => 'Séquentiel',
    'tree_load_strategy' => 'Stratégie de chargement de l\'arborescence',
    'syslog_enable' => 'Activer Syslog',
    'syslog_host' => 'Serveur Syslog',
    'syslog_port' => 'Port Syslog',
    'error_bad_credentials' => 'Informations de connexion erronées',
    'settings_ldap_usergroup' => 'Groupe LDAP dans lequel faire la recherche',
    'settings_ldap_usergroup_tip' => 'Groupe LDAP dans lequel les utilisateurs doivent être membre pour pouvoir se connecter. Exemple : cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Activer le changement automatique du mot de passe du compte du serveur (en utilisant une connexion SSH)',
    'update_server_password' => 'Mettre à jour le mot de passe du serveur',
    'ssh_pwd' => 'Mot de passe SSH',
    'ssh_user' => 'Identifiant SSH',
    'ssh_password_frequency_change_info' => 'Vous désirez peut-etre que le changement se fasse de façon automatique à une fréquence définie. Pour cela, il est nécessaire de définir la fréquence à laquelle le mot de passe de l\'utilisateur du serveur devra être changé (mettre à 0 pour désactiver la tache).<br>Merci de noter que cela ne fonctionnera que si votre administrateur a activé la tâche dans le crontab du serveur.',
    'ssh_password_frequency_change' => 'Fréquence de changement du mot de passe (en mois)',
    'ssh_scheduled_change' => 'Planifier un changement',
    'ssh_one_shot_change' => 'Changement direct',
    'server_password_change_enable_tip' => 'Cette option permet aux utilisateurs de réaliser automatiquement le changement de mot de passe d\'un utilisateur sur le serveur localisé à l\'URL indiquée, en utilisant une connexion SSH.<br>Notez que le changement automatique à la fréquence indiquée n\'est possible que si le fichier <i>/files/script.ssh.php</i> est ajouté au crontab de ce serveur. La recommandation serait que celui-ci s’exécute une fois par jour.',
    'error_bad_credentials_more_than_3_times' => 'Informations de connexion erronées !<br>Merci de patienter 10 secondes avant de faire une nouvelle tentative',
    'settings_ldap_object_class' => 'Recherche de la Classe',
    'settings_ldap_object_class_tip' => 'Rechercher dans la CLasse LDAP, par exemple, une Personne ou un posixAccount',
    'rebuild_config_file' => 'Reconstruire le ficher de configuration',
    'rebuild_config_file_tip' => 'Le fichier de Configuration est situé dans le répertoire  ./includes/config/tp.config.php. Il contient toutes les variables de configuration comme définies dans les pages de Configuration de Teampass. La reconstruction de ce fichier peut être réalisé à tout moment.',
    'error_folder_complexity_lower_than_top_folder' => 'Il est nécessaire de définir un niveau de complexité de mot de passe au moins égale à celui du répertoire parent.',
    'new_item_email_body' => 'Bonjour,<br><br>Ceci est un email généré par Teampass.<br><br>Une nouvelle entrée \'#label\' a été créée dans TeamPass.<br />Vous pouvez la consulter en cliquant sur ce <a href="#link#">LIEN</a>.<br/><br />Cordialement.',
    'failed_logins' => 'Connexions échouées',
    'error_only_numbers_in_folder_name' => 'Le nom d\'un répertoire ne peut pas être seulement un nombre. Veuillez entrer un nom contenant des lettres.',
    'encrypted_data' => 'Les données sont cryptées dans la base de données',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'Identifiant de votre carte AGSES',
    'ga_flash_qr_and_login' => 'Flasher ce code depuis votre smartphone, saisissez le code d\'identification et cliquer le bouton "Entrer".',
    'i_need_to_generate_new_ga_code' => 'J\'ai besoin d\'un nouveau flash code. Merci de m\'envoyer un nouveau code temporaire par email.',
    'settings_manager_move_item' => 'Les Gestionnaires peuvent déplacer tout objet qu\'ils peuvent accéder',
    'user_folders_rights' => 'Dossiers visibles',
    'create_item_without_password' => 'Permettre de créer une entrée sans renseigner un mot de passe',
    'share_rights_info' => 'Cette fenêtre de dialogue permet de partager les permissions d\'un utilisateur avec une sélection d\'utilisateurs.<br>Prenez note que les permissions des utilisateurs sélectionnés seront remises à zéro et remplacées par exactement les mêmes permissions que l\'utilisateur source.',
    'share_rights_source' => 'Utilisateur source',
    'share_rights_destination' => 'Utilisateurs de destination',
    'ga_reset_by_user' => 'L\'utilisateur peut ré-initialiser son code.',
    'ga_reset_by_user_tip' => 'Si activé, l\'utilisateur aura la possibilité de ré-initialiser son code authentification en utilisant un lien présent sur la page d\'accueil. Cela peut être pratique si ce dernier change de smartphone. Si désactivé, l\'utilisateur devra faire sa demande à son administrateur.',
    'enable_massive_move_delete' => 'Autoriser les opérations massives de suppression et de déplacement.',
    'enable_massive_move_delete_tip' => 'Si activité, cette option permet à un utilisateur de réaliser des opérations de déplacement et de suppression massive sur plusieurs objets. Celles-ci ne seront possible en fonction des droits associés aux objets.',
    'mass_operation' => 'Opération sur',
    'move_items' => 'Déplacer les objets sélectionnés',
    'delete_items' => 'Supprimer les objets sélectionnés',
    'you_decided_to_move_items' => 'Vous avez décidé de déplacer les objets',
    'you_decided_to_delete_items' => 'Vous avez décidé de supprimer les objets',
    'suggest_password_change' => 'Suggérer une évolution concernant l\'objet',
    'otv_is_enabled' => 'L\'utilisateur peut proposer des liens à usage unique pour des objets',
    'error_source_and_destination_are_equal' => 'Les 2 répertoires ne peuvent être identiques',
    'sending_anonymous_statistics' => 'Envoyer des statistiques anonymes',
    'favourites_option_enabled' => 'Option `Favoris` activée',
    'personalfolders_option_enabled' => 'Option `Répertoires Personels` activée',
    'country_statistics' => 'Mapmonde',
    'country' => 'Pays',
    'users_statistics' => 'Nombre moyen d\'utilisateurs',
    'items_all' => 'Tous les Objets',
    'folders_all' => 'Tous les Répertoires',
    'items_shared' => 'Tous les Objets publics',
    'folders_shared' => 'Tous les Répertoires publics',
    'items_statistics' => 'Nombre moyen d\'Objets',
    'folders_statistics' => 'Nombre moyen de Répertoires',
    'administrators_number' => 'Nombre d\'Administrateurs',
    'administrators_number_statistics' => 'Nombre moyen d\'Administrateurs',
    'managers_number' => 'Nombre de Gestionnaires',
    'managers_number_statistics' => 'Nombre moyen de Gestionnaires',
    'readonly_number_statistics' => 'Nombre moyen d\'utilisateurs en Lecture-Seule',
    'readonly_number' => 'Nombre d\'utilisateurs en Lecture-Seule',
    'mysql_version' => 'Version MySQL',
    'php_version' => 'Version PHP',
    'teampass_version' => 'Version Teampass',
    'languages_used' => 'Langues utilisées',
    'languages_statistics' => 'Langues les plus utilisées',
    'kb_option_enabled' => 'Option `Base de Connaissance` activée',
    'suggestion_option_enabled' => 'Option `Suggestions` activée ',
    'customfields_option_enabled' => 'Option `Champs Personnalisés` activée ',
    'api_option_enabled' => 'Option `API` activée ',
    '2fa_option_enabled' => 'Option `Identification à 2 Facteurs` activée ',
    'agses_option_enabled' => 'Option `AGSES` activée ',
    'duo_option_enabled' => 'Option `DUO Security` activée ',
    'ldap_option_enabled' => 'Option `LDAP` activée ',
    'syslog_option_enabled' => 'Option `SYSLOG` activée ',
    'stricthttps_option_enabled' => 'Option `HTTPS strict` activée ',
    'characteristic' => 'Donnée',
    'current_value' => 'Valeur actuelle',
    'communication_means' => 'Moyens de Communication',
    'consider_a_donation' => 'Merci de considérer une donnation',
    'more_information' => 'Plus d\'information',
    'feature_request_canal' => 'Pour toute Question ou Demande, merci d\'utiliser',
    'bug_canal' => 'Pour tout Bug, merci d\'utiliser',
    'documentation_canal' => 'Documentation',
    'sending_anonymous_statistics_details' => 'Des statistiques relatives à l\'utilisation de Teampass sont nécessaires pour connaitre les contexts d\'utilisation de l\'outil par le développeur. Elles permettent d\'évaluer comment Teampass est utilisé et par conséquent orienter l\'implémentation des nouvelles fonctionnalités. Les données envoyées sont uniquement utilisées en interne and ne seront absolument pas distribuées ou vendues à un tiers.',
    'item_has_change_proposal' => 'Une proposition d\'évolution est disponible pour cet objet',
    'check_data_after_reencryption' => 'Merci d\'effectuer une vérification de vos données. Une table de sauvegarde <b>Backup</b> a été créée durant l\'opération de ré-encryptage.',
    'revert' => 'Restaurer les données ?',
    'revert_the_database' => 'Vous avez décidé de restaurer les anciennes données. Merci de confirmer.',
    'bad_psk' => 'Cette clé de salage personnelle n\'est pas correcte !',
    'ldap_test_config' => 'Tester cette configuration',
    'ldap_test_username' => 'Nom d\'utilisateur',
    'ldap_test_username_pwd' => 'Mot de passe utilisateur',
    'feature_support_canal' => 'Pour obtenir du soutien et de l\'aide, SVP utilisez',
    'category' => 'Catégorie',
    'text' => 'Texte',
    'type' => 'Type',
    'data_is_masked' => 'Données cachées',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP groupe autorisé',
    'settings_ldap_allowed_usergroup_tip' => 'Indiquer le nom du groupe autorisé à se connecter à Teampass. Laisser vide si aucune restriction n\'est requise.',
    'error_security_level_not_reached' => 'Niveau de sécurité non atteint !',
    'personal_saltkey_security_level' => 'Niveau minimum de sécurité de la clé personnelle de salage',
    'settings_disable_forgot_password_link' => 'Cacher le lien de récupération de mot de passe',
    'newly_created_user_is_administrated_by' => 'Les nouveaux utilisateurs sont administrés par',
    'settings_ldap_and_local_authentication' => 'Utilisateurs locaux et LDAP',
    'settings_ldap_and_local_authentication_tip' => 'En activant cette option, l\'dentification sera acceptée pour les utilisateurs locaux et dans un annuaire LDAP.',
    'enable_http_request_login' => 'Authentification automatique via l\'en-tête http',
    'duration_login_attempt' => 'Nombre de secondes avant authentification automatique',
    'newly_created_user_role' => 'Rôle de l\'utilisateur créé',
    'email_debug_level' => 'Sélectionnez un niveau de débogage',
    'email_debug_client' => 'Commandes du client',
    'email_debug_server' => 'Commandes du client et réponses du serveur',
    'email_debug_connection' => 'Commandes du client, réponse du serveur et statut de la connexion',
    'email_debug_low_level' => 'Sortie de bas niveau, tous les messages',
    'email_debug_level_usage' => 'Cette option ne devrait pas être activée. Elle est uniquement utilisée durant le débogage, à des fins de tests. Lorsque activée, cette option permet d\'obtenir la sortie des commandes du client.',
    'email_body_temporary_login_password' => 'Bonjour,<br><br>Ceci est un email généré par Teampass passwords manager.<br><br>Un administrateur a changé votre mot de passe de connexion. Vous devrez donc utiliser le code suivant lors de votre prochaine connexion à Teampass.<br><br><b>#enc_code#</b><br><br><br>À bientot sur Teampass',
    'your_new_password' => 'Votre nouveau mot de passe',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icone',
    'icon_on_selection' => 'Icone sur sélection',
    'fontawesome_icon_tip' => 'Sélectionner un code d\'icône de la librarie Font Awesome sélectionné dans Free et Solid. Laisser vide pour utiliser les icônes par défaut.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Précédent mot de passe utilisé pour vous identifier dans Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Durée d\'exécution',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Temps de rafraichissement de l\'écran (en secondes)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Rafraichi',
    'process_details' => 'Détails',
    'created_at' => 'Crée à',
    'updated_at' => 'Mis à jour à',
    'finished_at' => 'Terminé à',
    'tasks_manager' => 'Gestionnaire de tâches',
    'tasks' => 'Tâches',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Activer le gestionnaire de tâches via cron',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchroniser les nouveaux mots de passe',
    'error_new_ldap_password_detected' => 'Teampass détecte un changement de mot de passe. Il est nécessaire de réencrypter votre clé principale.',
    'settings_ldap_tls_certifacte_check' => 'Vérification du certificat LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Indique la stratégie de vérification du certificat. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Plus informations</a>.',
    'user_keys_management' => 'Gestion des clés utilisateurs',
    'sending_emails' => 'Envoi d\'emails',
    'task_frequency' => 'Fréquence (en minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Code DUO eronné',
    'creation_date' => 'Date de création',
    'never' => 'Jamais',
    'loading_main_page' => 'Merci de patienter, la page se charge ...',
    'alert_session_not_consistent' => 'La session courante est corrompue et doit être rafraichie. La page va être rechargée.',
    'link' => 'Lien',
    'error_not_allowed_to_authenticate' => 'Vous n’êtes pas autorisé à vous authentifier',
    'enable_tasks_log' => 'Activer le log des taches du cron',
    'enable_tasks_log_tip' => 'Permet d\'enregistrer l\'exécution des taches du cron dans la table <i>processes_log</i>.  Cela peut être utile pour vérifier que les taches tournent correctement.',
    'items_and_folders_statistics' => 'Statistiques relatives aux objets et répertoires',
    'item_copying' => 'Copie de l\'objet en cours',
    'upgrade_requested' => 'La base de données n\'est pas à jour.',
    'upgrade_requested_more' => 'Des inconsistances ont été détectées entre les fichiers et la base de données. Votre administrateur doit impérativement réaliser une mise à jour avant de continuer.',
    'settings_ldap_group_object_filter' => 'Filtre des groupes LDAP',
    'settings_ldap_group_object_filter_tip' => 'Filtre LDAP permettant de rechercher des objets de type Groupe. Exemple : (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'Rôles des utilisateurs AD ajustés en fonction de leurs groupes AD',
    'settings_ad_users_with_ad_groups_tip' => 'Permet d\'ajuster les rôles des utilisateurs AD avec ceux de leurs groupes AD. Ces rôles seront ajoutés à ceux définis dans leur profile.',
    'settings_ad_user_auto_creation' => 'Utilisateur AD automatiquement créé',
    'settings_ad_user_auto_creation_tip' => 'Permet à un utilisateur AD d\'être automatiquement crée lors de leur 1ère connexion à Teampass. A noter que si l\'option "Rôles des utilisateurs AD ajustés en fonction de leurs groupes AD" est activée alors il aura les rôles associés à ses groupes AD.',
    'settings_ldap_guid_attibute' => 'Attribut du GUID LDAP',
    'settings_ldap_guid_attibute_tip' => 'Attribut LDAP à utiliser pour identifier le GUID d\'un objet de l\'AD. Par exemple, objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'Groupe AD',
    'mapped_with_role' => 'Lié au rôle',
    'ad_groupe_and_roles_mapping' => 'Liaison entre les groupes AD et les rôles',
    'select_adgroup_mapping' => 'Sélectionner le rôle à lier avec le groupe AD courant',
    'enable_backlog_mail' => 'Activer l\'envoi des emails en attente',
    'provide_label' => 'Saisir un intitulé',
    'uploading' => 'Téléversement ...',
    'keys_encryption_not_ready' => 'Les clés de cryptage de vos objets sont actuellement en cours. Merci de patienter quelques minutes.',
    'account_not_ready' => 'Compte en construction',
    'add_new_job' => 'Ajouter un nouveau job',
    'tasks_cron_not_running' => 'Cron job non trouvé. Merci d\'éditer le crontab avec l\'utilisateur du serveur (typiquement www-data) avec la commande <code>crontab -u www-data -e</code>.<br>Sinon appuyer le bouton ci-dessous.',
    'tasks_cron_running' => 'Cron job trouvé',
    'currently_using_version' => 'Version actuellement chargée',
    'git_commit_value' => 'Version du commit de Git',

);
