<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.3
 * @file      estonian.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your AD credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your AD since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Vaikimisi ebaturvaline LDAP port: 389, vaikimisi turvaline LDAP port: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Select all',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Logid',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'Definitsioon',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn\'t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Palun kinnita',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Rollid',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Pealkiri',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Click to open Teampass website',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Vali profiilipildi PNG fail',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Copy folder',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Kasutajad',
    'folders' => 'Kaustad',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objekt(i) leitud',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'share' => 'Jaga antud objekti',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'Sa pead valima kausta',
    'email_subject_item_updated' => 'Parool on muudetud',
    'email_body_item_updated' => 'Tere!<br /><br />Parool \'#item_label#\' on uuendatud<br /><br />Saad seda vaadata  <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">SIIN</a><br /><br />Tervitades<br />TeamPass',
    'import_kp_finished' => 'Importimine KeyPass\'ist lõppes!<br />Vaikimisi uute kaustade parooli keerukuse tase on nüüd `Keskmine`. Sa pead seda võib-olla muutma.',
    'password_is_empty' => 'Item has no password',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bugs_page' => 'Kui avastate vea, teatage sellest.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Määra "igaüks samas rollis saab muuta" õigus kõigile imporditud kirjetele.',
    'import_csv_anyone_can_modify_txt' => 'Määra "igaüks saab muuta" õigus kõigile imporditud kirjetele.',
    'settings_upload_imageresize_options' => 'Kas piltide suurust tuleks muuta',
    'user_not_exists' => 'Sellist kasutajat ei ole olemas!',
    'auto_create_folder_role' => 'Loo kaust ja roll kasutajale ',
    'start_upload' => 'Alusta failide üleslaadimist',
    'error_upload_runtime_not_found' => 'Üleslaadimise funktsioon: Kestvust ei leitud.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Muuda parooli',
    'admin_2factors_authentication_setting' => 'Aktiveeri Google 2-faktoriline autentimine',
    'admin_2factors_authentication_setting_tip' => 'Google two-factor authentication enhances logon security. When logging in, a QR code is displayed, which must be scanned into the user\'s Google Authentication app to receive a one-time password. Requires all users to have Google authentication app on an Internet-connected mobile device.',
    'admin_ga_website_name' => 'Google Authenticatoris kasutatav nimi Teampassi jaoks',
    'admin_ga_website_name_tip' => 'Seda väärtust kasutatakse Google Authenticator äpis Teampass nime näitemisel.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] Sinuga jagati kirjet',
    'email_share_item_mail' => 'Tere!<br /><br /><u>#tp_user#</u> jagas sinuga kirjet <b>#tp_item#</b><br />Vajuta <a href="#tp_link#">SIIA</a>, et avada.<br /><br />Tervitades<br />TeamPass',
    'index_maintenance_mode_admin' => 'Hooldusrežiim on aktiveeritud. Kasutajad ei saa hetkel TeamPassi siseneda.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Saada GoogleAuthenticator kasutajale e-mailiga',
    'error_no_email' => 'Kasutajal puudub e-posti aadress!',
    'error_no_user' => 'Kasutajat ei leitud!',
    'email_ga_subject' => 'Sinu Google Authenticatori ühekordne kood Teampassi jaoks',
    'email_ga_text' => 'Tere!<br /><br />Kliki sellel lingil <a href="#link#">LINK</a> ja kasuta oma GoogleAuthenticator äppi, et luua 2 astmeline OTP autentimine TeamPassi jaoks.<br /><br />Tervitades<br />TeamPass',
    'settings_attachments_encryption' => 'Lülita sisse manustatud failide krüpteering',
    'settings_attachments_encryption_tip' => 'If enabled, items attachments are encrypted on the server with the system salt key. Encryption requires more server resources. -- Warning! -- Changing this option could break existing file attachments! After changing this setting, you must run the task to encrypt or decrypt existing file attachments.',
    'admin_action_attachments_cryption' => 'Krüpteeri või dekrüpteeri manustatud faile',
    'admin_action_attachments_cryption_tip' => 'HOIATUS! - Seda valikut võib muuta alles peale seda kui vastav säte on ka Teampass sätetes muudetud. Igaks juhuks tee \'upload\' kataloogist ennem muutmist koopia. Nii igaks-juhuks ...',
    'encrypt' => 'Krüpteeri',
    'decrypt' => 'Dekrüpteeri',
    'ga_identification_code' => 'Tunnuskood',
    'ga_enter_credentials' => 'Sa pead sisestama oma kasutajatunnuse ja parooli',
    'ga_bad_code' => 'Sinu Google Authenticatori kood on vale',
    'settings_get_tp_info' => 'Lae automaatselt TeamPassi puudutavat informatsiooni',
    'settings_get_tp_info_tip' => 'See säte lubab administraatori lehel laadida tehnilist informatsiooni Teampass serverist.',
    'settings_offline_mode' => 'Aktiveeri offline režiim',
    'settings_offline_mode_tip' => 'Offline režiim võimaldab kirjete eksportimist HTML faili, et saaksid neid kuvada ka siis, kui puudub ühendus TeamPassi serveriga. Kirjed on krüpteeritud kasutaja poolt määratud parooliga.',
    'offline_mode_key_level' => 'Offline krüpteerimisvõtme minimaalne turvatase',
    'categories' => 'Kategooriad',
    'no_category_defined' => 'Defineeritud kategooriad puuduvad',
    'confirm_deletion' => 'Sa oled kustutamas... oled ikka kindel?',
    'settings_item_extra_fields' => 'Luba kirjeid täiendada lisaväljadega (kategooriatest)',
    'settings_item_extra_fields_tip' => 'Enables another tab when creating password items, which contains custom fields for other types of data. An administrator must first create categories and the custom field labels to be displayed in those categories. This feature consumes more server resources.',
    'settings_ldap_type' => 'LDAP serveri tüüp',
    'server_time' => 'Serveri aeg',
    'settings_tree_counters' => 'Kuva kaustade puu juures rohkem detaile',
    'settings_tree_counters_tip' => 'See valik näitab iga kataloogi juures 3 loendurit: Palju asju kataloogis; Palju asju kõigis alamkataloogides; Alamkataloogide arv. Kasutab intensiivselt SQL päringuid. Võib minna rohkem aega kataloogipuu näitamiseks.',
    'admin_action_check_pf' => 'Aktiveeri personaalsed kaustad ja tekita kui kasutajal puudub',
    'enable_personal_folder_feature_tip' => 'Personal folders are a private location for individual user passwords. Password items are encrypted by a user\'s salt key (more secure) or by their password (easier). Enabling this feature does not create the actual folders for existing users - you must also run the create personal folders task.',
    'administrators_only' => 'Ainult administraatorid',
    'managers_of' => 'Rolli haldajad',
    'managed_by' => 'Haldab',
    'settings_enable_sts' => 'Sunni HTTPS STS kasutamist -- Hoiatus: loe märkusi.',
    'settings_enable_sts_tip' => 'HTTPS STS lubamine. STS aitab tõrjuda vahemehe ründeid. Saidil peab olema kehtiv SSL sertifikaat mõne globaalselt tunnustatud CA käst. ÄRA aktiveeri seda valikut, kui sul on isegenereeritud sertifikaat. TeamPass lakkab töötamast. Apache konfis peab olema lubatud ka \'SSLOptions +ExportCertData\'',
    'settings_anyone_can_modify_bydefault' => 'Aktiveeri \'<b><i>igaüks saab muuta</b></i>\' valik vaikimisi',
    'to' => 'kellele',
    'settings_upload_maxfilesize_tip' => 'Maksimaalne lubatud faili suurus. See peab olema kooskõlas serveri seadetega.',
    'settings_upload_docext_tip' => 'Dokumentide tüübid. Määra lubatud faililaiendid eraldades need komaga (,)',
    'settings_upload_imagesext_tip' => 'Piltide tüübid. Määra lubatud faililaiendid eraldades need komaga (,)',
    'settings_upload_pkgext_tip' => 'Pakitud failide tüübid. Määra lubatud faililaiendid eraldades need komaga (,)',
    'settings_upload_otherext_tip' => 'Muud failitüübid. Määra lubatud faililaiendid eraldades need komaga (,)',
    'settings_upload_imageresize_options_tip' => 'See valik muudab piltide suuruse allmärgitud formaati.',
    'settings_upload_maxfilesize' => 'Maksimaalne faili suurus',
    'settings_upload_docext' => 'Lubatud dokumendiformaadid',
    'settings_upload_imagesext' => 'Lubatud pildiformaadid',
    'settings_upload_pkgext' => 'Lubatud pakkeformaadid',
    'settings_upload_otherext' => 'Luba teisi failiformaate',
    'settings_upload_imageresize_options_w' => 'Uute piltide laius (pikslites)',
    'settings_upload_imageresize_options_h' => 'Uute piltide kõrgus (pikslites)',
    'settings_upload_imageresize_options_q' => 'Uute piltide kvaliteet',
    'settings_importing' => 'Luba andmete import CVS/KeyPass failidest',
    'admin_proxy_ip' => 'Proxy IP',
    'admin_proxy_ip_tip' => 'Kui sul on internetti ühendumiseks vajalik proxy server, siis määra selle IP aadress siin.',
    'admin_proxy_port' => 'Proxy port',
    'admin_proxy_port_tip' => 'Kui sul on internetti ühendumiseks vajalik proxy server, siis määra selle pordi number siin.',
    'settings_ldap_elusers' => 'Ainult TeamPassi lokaalsed kontod',
    'settings_ldap_elusers_tip' => 'See säte lubab andmebaasi kasutajaid autentida vastu LDAP\'i. Lülita välja, kui soovid LDAP puud sirvida.',
    'db_items_edited' => 'Kirje on praegu muutmisel',
    'item_edition_start_hour' => 'Muutmine algas',
    'settings_delay_for_item_edition' => 'Kui pika aja pärast loeme kirje muutmise ebaõnnestunuks (minutites)',
    'settings_delay_for_item_edition_tip' => 'When editing an item, the item is locked so that no other user can modify it. This setting deletes the lock token after a certain number of minutes. If the value is set to 0, an item will never be automatically unlocked after someone has started editing.',
    'db_users_logged' => 'Sisselogitud kasutajate arv',
    'action' => 'Tegevus',
    'login_time' => 'Sisseloginud alates',
    'lastname' => 'Perekonnanimi',
    'user_login' => 'Kasutajatunnus',
    'role' => 'Roll',
    'error_role_exist' => 'Selline roll juba eksisteerib!',
    'error_no_edition_possible_locked' => 'Muutmine ei ole võimalik. Antud kirjet juba muudetakse hetkel!',
    'select' => 'vali',
    'items' => 'Kirjed',
    'enable_personal_saltkey_cookie' => 'Luba personaalse parooli soola meelespidamine küpsisega',
    'personal_saltkey_cookie_duration' => 'Personaalse parooli soola küpsise eluiga (päevades)',
    'admin_email_smtp_server' => 'SMTP server',
    'admin_email_auth' => 'SMTP server vajab autentimist',
    'admin_email_auth_username' => 'Kasutajanimi autentimiseks',
    'admin_email_auth_pwd' => 'Parool autentimiseks',
    'admin_email_port' => 'Serveri port',
    'admin_email_from' => 'Saatja e-mail (kellelt)',
    'admin_email_from_name' => 'Saatja nimi (kellelt)',
    'admin_email_test_configuration_tip' => 'See test peaks saatma e-kirja märgitud aadressile. Kui kiri ei tulnud läbi, kontrolli oma kontoseadeid.',
    'admin_email_test_subject' => '[Teampass] Test e-mail',
    'admin_email_test_body' => 'Tere!<br /><br />E-mail on edukalt saadetud.<br /><br />Tervitades<br />TeamPass',
    'admin_email_result_ok' => 'E-mail on saadetud #email# aadressile... Kontrolli oma postkasti.',
    'email_bodyalt_item_updated' => 'Kirje #item_label# parool on uuendatud.',
    'admin_email_send_backlog_tip' => 'Antud skript sunnib kõik andmebaasis olevad e-kirjad koheselt saatmisele.<br/> Sõltuvalt e-kirjade arvust, võib see tegevus natuke aega võtta.',
    'please_wait' => 'Palun oota!',
    'admin_path_to_files_folder' => 'Manuste kausta absoluutne tee',
    'admin_path_to_files_folder_tip' => 'The files folder is used to store both system files and some uploaded files. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'admin_path_to_upload_folder_tip' => 'File attachments are stored in the upload folder with randomized names.  Contents of this folder should never be manually deleted. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'pdf_password_warning' => 'Sa pead määrama krüpteerimisparooli!',
    'admin_pwd_maximum_length' => 'Maksimaalne paroolide pikkus',
    'admin_pwd_maximum_length_tip' => 'Vaikimisi paroolide pikkuseks on 40 tähemärki. Tõstes selle parameetri väärtust väheneb ka serveri jõudlus sest vajatakse rohkem aega krüpteerimiseks/dekrüpteerimiseks ning paroolide näitamiseks.',
    'settings_insert_manual_entry_item_history' => 'Luba manuaalne info lisamine kirje ajaloo logisse',
    'settings_insert_manual_entry_item_history_tip' => 'You would normally want to leave this off. When enabled, the history of a password item can be edited or altered.',
    'admin_path_to_upload_folder' => 'Upload kausta absoluutne teekond',
    'admin_setting_enable_delete_after_consultation' => 'Luba peale teistelt nõu küsimist kirjete automaatne kustutamine',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Kui aktiivne, siis võib kirje looja otsustada, et peale X korda näitamist see kustutatakse.</span>',
    'at_email' => 'e-mail',
    'enable_email_notification_on_item_shown' => 'Saada e-postiga teavitus, kui seda kirjet kuvatakse',
    'share_sent_ok' => 'E-mail on saadetud',
    'see_item_title' => 'Objekti detailid',
    'email_on_open_notification_subject' => '[TeamPass] Teavitus kirje avamisest',
    'email_on_open_notification_mail' => 'Tere!<br /><br />#tp_user# avas ja vaatas kirjet \'#tp_item#\'.<br />Vajuta <a href="#tp_link#">SIIA</a>, et avada.<br /><br />Tervitades<br />TeamPass',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Sinu konto loomine',
    'email_new_user_mail' => 'Tere!<br /><br />Administraator tekitas sulle konto Teampassi.<br />Sinu konto andmed on:<br />- Kasutaja: #tp_login#<br />- Parool: #tp_pw#<br /><br />Vajuta <a href="#tp_link#">SIIA</a>, et rakendus avada.<br /><br />Tervitades<br />TeamPass',
    'error_empty_data' => 'Viga, andmed puuduvad!',
    'error_not_allowed_to' => 'Sul ei ole lubatud seda toimingut teostada!',
    'request_access_ot_item' => 'Taotle autorilt juurdepääsu',
    'email_request_access_subject' => '[TeamPass] Kirjele juurdepääsu taotlus',
    'email_request_access_mail' => 'Tere #tp_item_author#!<br /><br />Kasutaja #tp_user# taotleb juurdepääsu kirjele \'#tp_item#\'.<br /><br />Enne juurdepääsu lubamist, palun kontrolli üle, kas see kasutaja tohib seda näha.<br /><br />Tervitades<br />TeamPass',
    'admin_action_change_salt_key' => 'Muuda peamist parooli soola',
    'nb_items_by_query' => 'Mitu kirjet iga päringuga kuvada',
    'nb_items_by_query_tip' => 'Input the number of items to retrieve per server request. Multiple smaller requests may perform better than fewer, larger requests. Other options: \'auto\' - tuned to user display window size. \'max\' - to load all at once.',
    'open_url_link' => 'Ava uuel lehel',
    'error_pw_too_long' => 'Parool on liiga pikk! On lubatud kuni 40 tähemärki.',
    'at_restriction' => 'Piirang',
    'pw_encryption_error' => 'Tekkis parooli krüpteerimise viga!',
    'enable_send_email_on_user_login' => 'Saada kasutaja sisselogimisel adminnidele e-mail',
    'email_subject_on_user_login' => '[TeamPass] Kasutaja logis sisse',
    'email_body_on_user_login' => 'Tere<br /><br />Kasutaja #tp_user# sisenes TeamPassi #tp_date# kell #tp_time#.<br /><br />Tervitades<br />TeamPass',
    'account_is_locked' => 'See konto on lukustatud',
    'activity' => 'Tegevus',
    'add_role_tip' => 'Lisa uus roll.',
    'admin' => 'Haldamine',
    'admin_action_db_backup' => 'Loo andmebaasist varukoopia',
    'admin_action_db_clean_items' => 'Puhasta andmebaas vanadest jäänukitest',
    'admin_action_db_clean_items_tip' => 'Removes any items or other entries left behind after a folder is deleted. Please backup before performing this task.',
    'admin_action_db_optimize' => 'Optimeeri andmebaasi',
    'admin_action_db_restore' => 'Taasta andmebaas',
    'admin_action_purge_old_files' => 'Puhasta vanad failid',
    'admin_action_purge_old_files_tip' => 'See kustutab kõik ajutised failid, mis on üle 7 päeva vanad.',
    'admin_action_reload_cache_table' => 'Värskenda vahemälu tabelit',
    'admin_action_reload_cache_table_tip' => 'See võimaldab terve vahemälu tabeli uuesti laadida. See võib vahel kasulik olla.',
    'admin_help' => 'Abi',
    'admin_ldap_configuration' => 'LDAP seadistus',
    'admin_main' => 'Informatsioon',
    'admin_misc_cpassman_dir' => 'Absoluutne asukoht failisüsteemis',
    'admin_misc_cpassman_url' => 'TeamPassi terviklik URL',
    'admin_misc_custom_login_text' => 'Enda valitud sisselogimise tekst',
    'admin_misc_custom_logo' => 'Enda valitud sisselogmise logo URL',
    'admin_misc_favicon' => 'Favicon pildi URL',
    'admin_settings' => 'Sätted',
    'admin_settings_title' => 'Sätted',
    'admin_setting_activate_expiration' => 'Aktiveeri paroolide aegumine',
    'admin_setting_activate_expiration_tip' => 'Kui on aktiveeritud, siis ei kuvata kasutajatele aegunud kirjeid.',
    'admin_views' => 'Vaated',
    'alert_message_done' => 'Valmis!',
    'all' => 'kõik',
    'anyone_can_modify' => 'Lubab seda kirjet muuta igaühel, kellel on õigus seda vaadata',
    'at' => '@',
    'at_category' => 'Kaust',
    'at_copy' => 'Kopeerimine',
    'at_delete' => 'Kustutamine',
    'at_description' => 'Kirjeldus.',
    'at_label' => 'Pealkiri',
    'at_login' => 'Sisenemine',
    'at_moved' => 'Liigutatud',
    'at_personnel' => 'Personal',
    'at_restored' => 'Taastatud',
    'at_shown' => 'Avamine',
    'at_url' => 'URL',
    'author' => 'Autor',
    'authorized_groups' => 'Lubatud kaustad',
    'auth_creation_without_complexity' => 'Luba luua uut kirjet sõltumata parooli keerukuse nõude täitmisest',
    'auth_modification_without_complexity' => 'Luba kirje muutmist sõltumata parooli keerukuse nõude täitmisest',
    'cancel' => 'Katkesta',
    'can_create_root_folder' => 'Saab luua uut kausta juurkausta tasemele',
    'changelog' => 'Viimased uudised',
    'close' => 'Sulge',
    'complexity' => 'Keerukus',
    'complex_asked' => 'Nõutud keerukus',
    'complex_level0' => 'Väga nõrk',
    'complex_level1' => 'Nõrk',
    'complex_level2' => 'Keskmine',
    'complex_level3' => 'Tugev',
    'complex_level4' => 'Väga tugev',
    'complex_level5' => 'Turvaline',
    'complex_level6' => 'Väga turvaline',
    'confirm' => 'Kinnita',
    'confirm_del_from_fav' => 'Palun kinnita lemmikute alt kustutamist',
    'connections' => 'ühendused',
    'copy' => 'Kopeeri',
    'copy_to_clipboard_small_icons' => 'Luba lõikelauale kopeerimise ikoonide kuvamine kirjete lehel',
    'copy_to_clipboard_small_icons_tip' => 'Adds a small icon to the password item listing on the top panel which copies the password to the clipboard. A password can be copied without needing to select and load the whole item contents.',
    'date' => 'Kuupäev',
    'date_format' => 'Kuupäeva formaat',
    'delete' => 'Kustuta',
    'deletion' => 'Kustutamised',
    'del_button' => 'Kustuta',
    'description' => 'Kirjeldus',
    'disconnect' => 'Välju',
    'done' => 'Valmis',
    'duplicate_folder' => 'Luba kasutada mitut samanimelist kausta.',
    'duplicate_item' => 'Luba kasutada mitut samanimelist kirjet.',
    'email' => 'E-mail',
    'email_subject' => 'Paroolihaldurisse uue kirje loomine',
    'enable_favourites' => 'Luba kasutajatel lemmikute salvestamine',
    'enable_personal_folder' => 'Aktiveeri personaalne kaust',
    'enable_personal_folder_feature' => 'Aktiveeri personaalse kausta funktsioon',
    'enable_user_can_create_folders' => 'Kasutajatel on lubatud hallata ja lisada uusi alamkaustu peakaustas',
    'encrypt_key' => 'Krüpteerimisparool',
    'errors' => 'vead',
    'error_group_exist' => 'Selline kaust on juba olemas!',
    'error_html_codes' => 'Osa tekstist sisaldab HTML koodi! See ei ole lubatud.',
    'error_item_exists' => 'Selline kirje on juba olemas!',
    'error_label' => 'Pealkiri on kohustuslik!',
    'error_must_enter_all_fields' => 'Sa pead täitma kõik väljad!',
    'error_pw' => 'Parool on kohustuslik!',
    'error_tags' => 'Lubamatu kirjavahemärk märksõna sees! Ainult tühik on lubatud.',
    'error_user_exists' => 'Selline kasutaja on juba olemas',
    'expiration_date' => 'Aegumine',
    'find' => 'Otsi',
    'forbidden_groups' => 'Keelatud kaustad',
    'forgot_my_pw_email_sent' => 'E-post on saadetud',
    'functions' => 'Rollid',
    'gestionnaire' => 'Haldaja',
    'god' => 'Administraator',
    'group' => 'Kaust',
    'group_parent' => 'Ülemkaust',
    'group_pw_duration' => 'Uuendamise periood',
    'group_pw_duration_tip' => 'Kuudes. Keelamiseks sisesta 0.',
    'history' => 'Ajalugu',
    'home_personal_saltkey' => 'Sinu parooli sool',
    'home_personal_saltkey_label' => 'Sisesta oma personaalne parooli sool',
    'import_error_no_read_possible' => 'Faili ei saa lugeda!',
    'import_error_no_read_possible_kp' => 'Faili lugemine ei õnnestu! See peab olema KeePass fail.',
    'import_keepass_to_folder' => 'Vali sihtkaust',
    'index_add_one_hour' => 'Pikenda sessiooni 1 tund',
    'index_change_pw_confirmation' => 'Kinnita',
    'index_expiration_in' => 'sessioon aegub',
    'index_get_identified' => 'Palun tuvasta ennast',
    'index_last_pw_change' => 'Parool muudetud',
    'index_last_seen' => 'Viimane ühendus',
    'index_login' => 'Konto',
    'index_new_pw' => 'Uus parool',
    'index_password' => 'Parool',
    'index_pw_error_identical' => 'Paroolid peavad olema identsed!',
    'index_pw_level_txt' => 'Keerukus',
    'index_session_duration' => 'Sessiooni kestvus',
    'info' => 'Informatsioon',
    'item_menu_copy_login' => 'Kopeeri kasutajanimi',
    'item_menu_copy_pw' => 'Kopeeri parool',
    'item_menu_del_from_fav' => 'Kustuta lemmikutest',
    'kbs' => 'KKK',
    'kb_menu' => 'Teadmiste baas',
    'last_items_title' => 'Viimati nähtud kirjed',
    'ldap_extension_not_loaded' => 'LDAP moodul ei ole serveris aktiveeritud.',
    'level' => 'Tase',
    'login' => 'Kasutajatunnus',
    'mask_pw' => 'Varja/Kuva parool',
    'max_last_items' => 'Maksimaalne viimati nähtud kirjete arv kasutaja kohta (vaikimisi on 10)',
    'minutes' => 'minutit',
    'name' => 'Nimi',
    'nb_false_login_attempts' => 'Mitu korda võib vale parooli sisestada enne kui konto lukustub (0 keelab)',
    'nb_folders' => 'Kaustade arv',
    'nb_items' => 'Kirjete arv',
    'new_label' => 'Uus pealkiri',
    'no' => 'Ei',
    'none' => 'Puudub',
    'none_selected_text' => 'Pole midagi valitud',
    'not_allowed_to_see_pw' => 'Sul ei ole õigusi seda kirjet näha!',
    'not_allowed_to_see_pw_is_expired' => 'Antud kirje on aegunud!',
    'not_defined' => 'Pole defineeritud',
    'number_of_used_pw' => 'Mitut uut parooli peab kasutama enne kui saab jälle endist kasutada.',
    'pages' => 'Leheküljed',
    'pdf_download' => 'Lae fail alla',
    'personal_salt_key' => 'Sinu personaalne parooli sool',
    'pw' => 'Parool',
    'pw_generate' => 'Genereeri',
    'pw_is_expired_-_update_it' => 'See kirje on aegunud! Sa pead muutma selle parooli.',
    'pw_life_duration' => 'Kasutaja parooli eluiga (päevades, määra 0 kui on lõpmatu)',
    'readme_open' => 'Ava terve readme fail',
    'read_only_account' => 'Ainult vaatamiseks',
    'restore' => 'Taasta',
    'restricted_to' => 'Piiratud kasutajatele',
    'restricted_to_roles' => 'Luba kirjete piiramine kasutajatele ja rollidele',
    'root' => 'Juurkaust',
    'secure' => 'Turvaline',
    'see_logs' => 'Vaata logisid',
    'settings_anyone_can_modify' => 'Aktiveeri valik igale kirjele, mis lubab igaühel seda muuta',
    'settings_anyone_can_modify_tip' => 'This adds a checkbox during new password item creation that can set the item to be modifiable by anyone.',
    'settings_default_language' => 'Määra vaikimisi keel',
    'settings_kb' => 'Aktiveeri teadmiste baas (beta)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Kui on aktiveeritud, saad lisada lehe, kuhu oma teadmiste baas luua.</span>',
    'settings_ldap_domain' => 'LDAP domeeni konto suffiks',
    'settings_ldap_domain_controler' => 'LDAP domeenikontrollerite nimekiri',
    'settings_ldap_domain_controler_tip' => 'Specify domain controller providing the directory services. To balance queries among multiple servers, input a comma-delimited list of each server name. Example: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'LDAP domeeni baas DN',
    'settings_ldap_mode' => 'Aktiveeri kasutajate autentimine läbi LDAP serveri',
    'settings_ldap_mode_tip' => 'Aktiveeri ainult siis, kui sul on LDAP server ja soovid läbi selle kasutajaid TeamPassi jaoks autentida.',
    'settings_ldap_ssl' => 'Kasuta LDAPi üle SSLi (LDAPS)',
    'settings_ldap_tls' => 'Kasuta LDAPi üle TLSi',
    'settings_log_accessed' => 'Aktiveeri kirjete vaatamise logimine',
    'settings_log_connections' => 'Aktiveeri kõigi kasutaja ühenduste logimine andmebaasi.',
    'settings_maintenance_mode' => 'Aktiveeri TeamPassi hooldusrežiim',
    'settings_manager_edit' => 'Haldajad saavad muuta ja kustutada kirjeid, mida nad näevad',
    'settings_printing' => 'Aktiveeri kirjete printimine PDF faili',
    'settings_printing_tip' => 'Adds an export option to the item tree menu, allowing export of entire folders to PDF or CSV. CSV passwords will be exported unencrypted, while PDF files can be password-protected.',
    'settings_restricted_to' => 'Aktiveeri kirjetel piiratud kasutaja funktsionaalsus',
    'settings_show_description' => 'Kuva kirjete nimekirjas ka kirjeldusi',
    'size' => 'Suurus',
    'tags' => 'Märksõnad',
    'timezone_selection' => 'Ajatsooni valimine',
    'time_format' => 'Ajaformaat',
    'url' => 'URL',
    'user' => 'Kasutaja',
    'users_online' => 'kasutaja(t) lehel',
    'user_alarm_no_function' => 'Kasutajal puuduvad rollid!',
    'yes' => 'Jah',
    'one_time_view_item_url_box' => 'Jaga ühekordset URL linki usaldusväärse inimesega <br /><br />#URL#<br /><br />Pea meeles, et see link on nähtav ainult ühe korra kuni #DAY#',
    'settings_api' => 'Luba juurdepääs kirjetele läbi TeamPassi API',
    'settings_api_tip' => 'API juurdepääs võimaldab kolmanda osapoolte rakendustel JSON formaadis kirjetele ligi pääseda.',
    'settings_api_keys_list' => 'Võtmete nimekiri',
    'settings_api_keys_list_tip' => 'Võtmed, millega API-le ligi pääseda. Kolmanda osapoole rakendused peavad kasutama siin juhuslikult genereeritud võtit, et käivitada JSON liidese päringuid.',
    'settings_api_key' => 'Võti',
    'settings_api_add_ip' => 'Lisa uus IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Uus alamkaust pärib õigused ülemkaustast',
    'subfolder_rights_as_parent_tip' => 'If enabled, each new sub-folder inherits the roles and permissions of the parent folder. Otherwise, the folder permission is assigned based on the role of the user who creates them.',
    'show_only_accessible_folders_tip' => 'By default, users see the complete tree of password item folders, even if some folders are inaccessible to the user. You may remove inaccessible folders from the view to simplify browsing.',
    'show_only_accessible_folders' => 'Lihtsusta kaustapuud, eemaldades kaustad, millele juurdepääs puudub',
    'comment' => 'Kommentaar',
    'suggestion_menu' => 'Soovitused',
    'settings_suggestion' => 'Luba kirjete soovitamist kasutajatele vaataja õigustes',
    'settings_suggestion_tip' => 'The suggestion feature adds a new menu and page, allowing users to create suggestions for new password items. This is useful when only managers are allowed to create password items.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP Bind DN',
    'settings_ldap_bind_passwd' => 'LDAP Bind parool',
    'settings_ldap_search_base' => 'LDAP otsingu juurasukoht',
    'settings_ldap_bind_dn_tip' => 'Kasutaja DN, millel on õigus LDAP puust otsida',
    'settings_ldap_bind_passwd_tip' => 'Parool kasutaja DN jaoks, millega LDAP puust otsinguid teostatakse',
    'settings_ldap_search_base_tip' => 'Otsingu juur DN',
    'admin_email_server_url' => 'Serveri URL e-mailides olevate linkide jaoks',
    'enable_email_notification_on_user_pw_change' => 'Saada kasutajale e-mail, kui tema parool muutub',
    'settings_otv_expiration_period' => 'Jagatud ühekordse kirje vaatamise loa aegumine (päevades)',
    'write' => 'Kirjuta',
    'read' => 'Loe',
    'no_access' => 'Juurdepääs puudub',
    'right_types_label' => 'Määra valitud kasutajagrupile antud kausta juurdepääsu tüüp',
    'duplicate_item_in_folder' => 'Luba sarnase sildiga kirjeid ühes kaustas',
    'settings_roles_allowed_to_print' => 'Määra rollid, kellel on lubatud kirjeid printida',
    'settings_roles_allowed_to_print_tip' => 'Valitud rollidel lubatakse failist kirjete printimist.',
    'admin_email_security' => 'SMTP turvalisus',
    'alert_page_will_reload' => 'Antud leht laetakse uuesti',
    'file_protection_password' => 'Määra faili parool',
    'expand' => 'Laienda',
    'collapse' => 'Sulge',
    'settings_ldap_user_attribute' => 'Kasutaja parameeter, mida otsida',
    'settings_ldap_user_attribute_tip' => 'LDAP parameeter, millest kasutajanime otsida',
    'log_user_initial_pwd_changed' => 'Esmakordne parool defineeritud',
    'log_user_email_changed' => 'Kasutaja e-posti aadress muudetud ',
    'log_user_created' => 'Kasutajakonto loodud',
    'log_user_locked' => 'Kasutaja lukustatud',
    'log_user_unlocked' => 'Kasutaja lukust avatud',
    'log_user_pwd_changed' => 'Kasutaja parool on muudetud',
    'settings_default_session_expiration_time' => 'Vaikimisi sessiooni aegumise pikkus',
    'settings_duo' => 'Aktiveeri DUO Security kahefaktorilise autentimise lahendusena',
    'settings_duo_tip' => 'Kasutajale pakutakse 2 astmelist autentimist DUOSecurity.com poolt. See teek garanteerib kõrge turvataseme kasutaja autentimisel.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Credentials from the Duo Security administration page for your account must be input here. Settings will be stored in the sk.php file only after pressing the save button.',
    'admin_duo_intro' => 'Palun täida järgnevad väljad küsitud infoga',
    'edit' => 'Muuda',
    'user_info_locked' => 'Kasutaja on hetkel LUKUS.',
    'user_info_unlock_question' => 'Võta konto lukust lahti?',
    'user_info_lock_question' => 'Lukusta konto?',
    'user_info_delete_question' => 'Kustuta konto?',
    'user_info_active' => 'Kasutaja on hetkel AKTIIVNE.',
    'refresh' => 'Värskenda',
    'loading' => 'Laen',
    'searching' => 'Otsin...',
    'list_items_with_tag' => 'Kuva selle märksõnaga kirjed',
    'no_item_to_display' => 'Pole kirjeid, mida kuvada',
    'opening_folder' => 'Loen kausta...',
    'suggestion_notify_subject' => '[TeamPass] On esitatud uus soovitus.',
    'suggestion_notify_body' => 'Tere!<br /><br />Tehtud on uus soovitus. See on ootel ja sa pead selle kinnitama, kui soovid, et teised kasutajad seda näeksid. <br />Soovituse kohta on järgnev info<br />- Pealkiri: #tp_label#<br />- Kaust: #tp_folder#<br />- Kasutaja: #tp_user#<br /><br />Antud kiri saadeti kõikidele haldajatele.<br /><br />Tervitades<br />TeamPass',
    'error_unknown' => 'Juhtus ootamatu viga!',
    'no_edit' => 'Saab kirjutada kuid mitte muuta',
    'role_cannot_edit_item' => 'Kirjeid ei saa muuta',
    'no_delete' => 'Saab kirjutada kuid mitte kustutada',
    'role_cannot_delete_item' => 'Kirjeid ei saa kustutada',
    'my_profile' => 'Minu profiil',
    'starting' => 'Alustan...',
    'total_number_of_items' => 'Kirjete koguarv',
    'finalizing' => 'Lõpetan',
    'treating_items' => 'Kirjete ravimine',
    'number_of_items_treated' => 'Ravitud kirjete arv',
    'error_sent_back' => 'Järgmine tekkinud viga',
    'full' => 'Täis',
    'sequential' => 'Järjestikune',
    'tree_load_strategy' => 'Puu kuvamise strateegia',
    'syslog_enable' => 'Aktiveeri syslogi saatmine',
    'syslog_host' => 'Syslogi server',
    'syslog_port' => 'Syslogi port',
    'error_bad_credentials' => 'Kasutajanimi või parool on vale!',
    'settings_ldap_usergroup' => 'LDAP otsitav grupp',
    'settings_ldap_usergroup_tip' => 'LDAP grupp mille liige peab kasutaja olema, et saaks sisse logida. Näiteks: cn=admins,ou=group,dc=et,dc=ee',
    'server_password_change_enable' => 'Luba eemalt parooli muutmine (ssh ühendusega)',
    'update_server_password' => 'Uuenda serveri parooli',
    'ssh_pwd' => 'SSH parool',
    'ssh_user' => 'SSH kasutaja',
    'ssh_password_frequency_change_info' => 'Select the interval between automatic server password updates (selecting 0 will disable automatic password changing).<br />Automatic password updates will only be performed if the system administrator has also configured the scheduled password update feature cron job.',
    'ssh_password_frequency_change' => 'Parooli vahetamise sagedus (kuudes)',
    'ssh_scheduled_change' => 'Ajastatud muudatus',
    'ssh_one_shot_change' => 'Ühekorraga muutmine',
    'server_password_change_enable_tip' => 'This setting adds an option in the password item to automatically change the user password on a server address listed in the url. This requires the remote UNIX server to allow username and password login via SSH. Automatic scheduled password changes can be performed after adding <i>/files/script.ssh.php</i> to crontab to run once a day on the password manager webserver.',
    'error_bad_credentials_more_than_3_times' => 'Kasutajanimi ja parool ei sobi!<br />Palun oota 10 sekundit enne uut katset',
    'settings_ldap_object_class' => 'LDAP otsingu objektiklass',
    'settings_ldap_object_class_tip' => 'LDAP kasutaja päringu klass, näiteks Person või posixAccount',
    'rebuild_config_file' => 'Genereeri konfiguratsioonifail uuesti',
    'rebuild_config_file_tip' => 'Konfiguratsioonifail asub kaustas ./includes/config/tp.config.php. See sisaldab muutujate väärtusi, mida oled määranud seadete lehel. Selle faili uuesti genereerimist saab teha igal hetkel.',
    'error_folder_complexity_lower_than_top_folder' => 'On nõutud, et parooli keerukus oleks võrdne või suurem ülemkausta omast',
    'new_item_email_body' => 'Tere!<br /><br />Teampassi on loodud uus kirje \'#label\'.<br />Pääsed sellele ligi vajutades <a href="#link#">SIIA</a>.<br /><br />Tervitades<br />TeamPass',
    'failed_logins' => 'Ebaõnnestunud sisselogimised',
    'error_only_numbers_in_folder_name' => 'Kausta nimi ei saa olla number. Palun sisesta nimi mis sisaldab ka tähti.',
    'encrypted_data' => 'Andmed on baasis krüpteeritud',
    'settings_ldap_port' => 'LDAP port',
    'user_profile_agses_card_id' => 'Sinu AGSES kaarti ID',
    'ga_flash_qr_and_login' => 'Skänni seda QR koodi oma telefoniga, sisesta 2Factor autentimis kood ja vajuta Enter nuppu.',
    'i_need_to_generate_new_ga_code' => 'Ma vajan uut QR kood. Palun saada mulle e-kiri ajutise tuvastuskoodiga.',
    'settings_manager_move_item' => 'Haldurid saavad liigutada igat kirjet, mida nad näevad',
    'user_folders_rights' => 'Nähtavad kaustad',
    'create_item_without_password' => 'Luba kirje loomist ilma parooli määramiseta',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Source user',
    'share_rights_destination' => 'Destination users',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Move selected Items',
    'delete_items' => 'Delete selected Items',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'suggest_password_change' => 'Suggest a password change',
    'otv_is_enabled' => 'User can propose One-Time-View links',
    'error_source_and_destination_are_equal' => 'Source and Destination cannot be the same!',
    'sending_anonymous_statistics' => 'Sending anonymous statistics',
    'favourites_option_enabled' => 'Favourites option enabled',
    'personalfolders_option_enabled' => 'Personal Folders option enabled',
    'country_statistics' => 'Worldmap usage',
    'country' => 'Country',
    'users_statistics' => 'Average number of users by instance',
    'items_all' => 'All items',
    'folders_all' => 'All folders',
    'items_shared' => 'All shared items (not including personal ones)',
    'folders_shared' => 'All shared folders (not including personal ones)',
    'items_statistics' => 'Average number of items by instance',
    'folders_statistics' => 'Average number of folders by instance',
    'administrators_number' => 'Number of Administrator users',
    'administrators_number_statistics' => 'Average number of Administrators by instance',
    'managers_number' => 'Number of Manager users',
    'managers_number_statistics' => 'Average number of Managers by instance',
    'readonly_number_statistics' => 'Average number of Read-Only users by instance',
    'readonly_number' => 'Number of Read-Only users',
    'mysql_version' => 'MySQL version',
    'php_version' => 'PHP version',
    'teampass_version' => 'Teampass version',
    'languages_used' => 'Languages used',
    'languages_statistics' => 'Most used language',
    'kb_option_enabled' => 'Knowledge Base option enabled',
    'suggestion_option_enabled' => 'Suggestion option enabled',
    'customfields_option_enabled' => 'Custom fields option enabled',
    'api_option_enabled' => 'API option enabled',
    '2fa_option_enabled' => '2FAoption enabled',
    'agses_option_enabled' => 'AGSES option enabled',
    'duo_option_enabled' => 'DUO Security option enabled',
    'ldap_option_enabled' => 'LDAP option enabled',
    'syslog_option_enabled' => 'SYSLOG option enabled',
    'stricthttps_option_enabled' => 'Strict HTTPS option enabled',
    'characteristic' => 'Characteristic',
    'current_value' => 'Current value',
    'communication_means' => 'Communication means',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'More information',
    'feature_request_canal' => 'For Feature Requests, please use',
    'bug_canal' => 'For Bugs, please use',
    'documentation_canal' => 'Complete documentation at',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'This Item has a change proposal',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revert?',
    'revert_the_database' => 'You have decided to revert the database. Please confirm?',
    'bad_psk' => 'This personal Saltkey is not correct!',
    'ldap_test_config' => 'Test current configuration',
    'ldap_test_username' => 'Username to use for testing purpose',
    'ldap_test_username_pwd' => 'Username password',
    'feature_support_canal' => 'For Support and Help, please use',
    'category' => 'Category',
    'text' => 'Text',
    'type' => 'Type',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',

);
