<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.3
 * @file      czech.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your AD credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your AD since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Standardní nezabezpečený port LDAP: 389, standardní zabezpečený port LDAP: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Vybrat všechny',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => 'Deník',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => 'Definice',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn\'t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Prosím potvrďte',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => 'Role',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Název',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Klikněte zde pro otevření domovské stránky aplikace Teampass',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => 'Vybrat soubor PNG pro avatara',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Zkopírovat složku',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => 'Uživatelé',
    'folders' => 'Složky',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objektů nalezeno',
    'auto_update_server_password_info' => 'Stisknutím tlačítka Start se automaticky provedou následující kroky:<ul><li>Spojení se serverem pomocí protokolu SSH, přihlašovacích údajů a adresy `URL`,</li><li>Změna uživatelského hesla na serveru</il><li>Uložení nového hesla v Teampassu</il><li>Ukončení spojení SSH</li></ul><br /><b>Prosím ubezpečete se předem, že uživatel má právo přihlásit se a změnit svě heslo na serveru (pokud ne, zadejte uživatele typu root jeho heslo).</b>',
    'share' => 'Oznámit tuto položku',
    'notify' => 'Notify',
    'error_no_selected_folder' => 'Musíte vybrat složku',
    'email_subject_item_updated' => 'Heslo bylo obnoveno',
    'email_body_item_updated' => 'Dobrý den,&lt;br&gt;&lt;br&gt;heslo pro \'#item_label#\' bylo obnoveno.&lt;br&gt;&lt;br&gt;Můžete jej zkontrolovat &lt;a href=\'".@$_SESSION[\'settings\'][\'cpassman_url\']."/index.php?page=items&;group=#item_category#&id=#item_id#\'&gt;ZDE&lt;/a&gt;.&lt;br&gt;&lt;br&gt;Na shledanou',
    'import_kp_finished' => 'Import dat z programu KeePass je ukončen!&lt;br&gt;Vyžadovaná úroveň komplexity pro nové složky je nastavena na `Normální`. Úroveň v případe potřeby upravte.',
    'password_is_empty' => 'Položka nemá heslo',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bugs_page' => 'Pokud objevíte chybu, nahlaste ji.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Nastavit právo "kdokoliv ve stejné roli smí měnit" pro všechny importované položky',
    'import_csv_anyone_can_modify_txt' => 'Nastavit právo "kdokoliv smí měnit" pro všechny importované položky',
    'settings_upload_imageresize_options' => 'Chcete změnit velikost obrázků',
    'user_not_exists' => 'Tento uživatel neexistuje!',
    'auto_create_folder_role' => 'Vytvořit složku a roli pro',
    'start_upload' => 'Spustit natahování souboru',
    'error_upload_runtime_not_found' => 'Nahrávání: spustitelný program nebyl nalezen.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => 'Změnit Vaše heslo',
    'admin_2factors_authentication_setting' => 'Dovolit 2-faktorovou authentifikaci (Google)',
    'admin_2factors_authentication_setting_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;2-faktorová authentifikace od Google umožňuje zvýšit stupeň bezpečnosti při authentifikaci uživatelů. Chce-li se uživatel přihlásit do TeamPassu, musí nejdřív vygenerovat QR kód. Po naskenování QR kódu obdrží uživatel jednorázové heslo.&lt;br&gt;POZOR: tato procedura vyžaduje funkční internetové připojení a čtecí zařízení (např. smartphone).&lt;/span&gt;',
    'admin_ga_website_name' => 'Jméno zobrazené aplikací Google Authenticator pro Teampass',
    'admin_ga_website_name_tip' => 'Toto jméno je užíváno v systému Google Authenticator pro účet identifikačního kódu.',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] Byla Vám oznámena nová položka',
    'email_share_item_mail' => 'Dobrý den,&lt;br&gt;&lt;br&gt;uživatel #tp_user# Vám tímto oznamuje novou položku &lt;b&gt;#tp_item#&lt;/b&gt;&lt;br&gt;Pro její zobrazení klikněte na &lt;a href="#tp_link#"&gt;ZDE&lt;/a&gt;.&lt;br&gt;&lt;br&gt;S přátelským pozdravem.',
    'index_maintenance_mode_admin' => 'Správní režim je aktivován. Uživatelé se momentálně nemohou přihlásit.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Zaslat uživateli Google Authenticator emailem',
    'error_no_email' => 'Tento uživatel nemá nastavenou emailovou adresu!',
    'error_no_user' => 'Uživatel nebyl nalezen!',
    'email_ga_subject' => 'Váš snímatelný kód Google Authenticator pro Teampass',
    'email_ga_text' => 'Dobrý den,<br><br>Prosím klikněte na tento <a href="#link#">LINK</a> and sejměte jej Vaší aplikací GoogleAuthenticator. Tím získáte Vaše jednorázové autorizační údaje pro Teampass.<br /><br />Na shledanou',
    'settings_attachments_encryption' => 'Dovolit šifrování příloh položek',
    'settings_attachments_encryption_tip' => 'TATO VOLBA MŮŽE POŠKODIT STÁVAJÍCÍ PŘÍLOHY - prosím čtěte pečlivě následující informace. Je-li tato volba aktivována, jsou přílohy položek uloženy zašifrované na serveru. Pro šifrování je užíván klíč SALT, definovaný pro Teampass. Tato procedura vyžaduje na serveru více zdrojů. POZOR: rozhodnete-li se pro toto nastavení, je třeba spustit skript pro konverzi stávajících příloh. Viz záložka \'Zvláštní akce\'.',
    'admin_action_attachments_cryption' => 'Zašifrovat nebo odšifrovat přílohy položek.',
    'admin_action_attachments_cryption_tip' => 'POZOR: tato akce smí být provedena POUZE po změně odpovídající volby v nastavení Teampassu. Prosím uložte před provedením jakékoli akce záložní kopii složky \'upload\', jen pro jistotu...',
    'encrypt' => 'Zašifrovat',
    'decrypt' => 'Odšifrovat',
    'ga_identification_code' => 'identifikační kód',
    'ga_enter_credentials' => 'Musíte zadat Vaše přihlašovací údaje',
    'ga_bad_code' => 'Identifikační kód Google Authenticator je neplatný',
    'settings_get_tp_info' => 'Automaticky stáhnout informace o Teampassu',
    'settings_get_tp_info_tip' => 'Tato volba umožní správcovské stránce stáhnout ze serveru Teampass informace jako např. aktuální verzi a knihovny užívané serverem Teampass.',
    'settings_offline_mode' => 'Aktivovat off-line modus',
    'settings_offline_mode_tip' => 'Off-line modus spočívá v exportu položek do souboru HTML. Položky v tomto souboru jsou zašifrovány klíčem, který je zadán uživatelem. ',
    'offline_mode_key_level' => 'Minimální úroveň šifrovacího klíče v off-line modusu',
    'categories' => 'Kategorie',
    'no_category_defined' => 'Ještě není definována žádná kategorie',
    'confirm_deletion' => 'Chcete skutečně odstranit?',
    'settings_item_extra_fields' => 'Povolit rozšíření položky o dodatečná pole (podle kategorií)',
    'settings_item_extra_fields_tip' => 'Tato volba umožní rozšířovat položky o dodatečná pole, která může správce definovat a třídit do kategorií. Veškerá data jsou zašifrována. Pamatujte, že tato volba vede ke zvýšení dotazů SQL (asi o 5 více na pole během aktualizace položky) a může vést - dle serveru - ke zpomalení operací.',
    'settings_ldap_type' => 'Typ serveru LDAP',
    'server_time' => 'Hodiny serveru',
    'settings_tree_counters' => 'Zobrazit více počitadel ve stromu složek.',
    'settings_tree_counters_tip' => 'Tímto budou pro každou složku zobrazena 3 počítadla: počet položek ve složce, počet položek ve všech podsložkách, počet podložek. Tato možnost vyžaduje více volání SQL a tudíž patrně i delší dobu pro zobrazení stromu.',
    'admin_action_check_pf' => 'Aktualizovat Osobní složky všech uživatelů (vytvořit je, pokud neexistují)',
    'enable_personal_folder_feature_tip' => 'Po aktivování tohoto musíte manuelně spustit skript, který vytvoří osobní složky pro stávající uživatele. Povšimněte si, že tím se vytvoří osobní složky pouze pro uživatele, kteří svou osobní složku ještě nemají. Odpovídající skript \'".$txt[\'admin_action_check_pf\']."\' je uložen v záložce \'".$txt[\'admin_actions_title\']."\'',
    'administrators_only' => 'Pouze pro Správce',
    'managers_of' => 'Správci role',
    'managed_by' => 'Spravováno uživatelem',
    'settings_enable_sts' => 'Vynutit bezpečnostní mechanismus HTTPS Strict Transport Security -- Pozor: čtěte ToolTip.',
    'settings_enable_sts_tip' => 'Tímto bude vynucen bezpečnostní mechanismus HTTPS STS. STS pomáhá zamezit útokům na SSL metodou Man-in-the-Middle. Chcete-li použít tuto možnost, MUSÍTE vlastnit platný SSL certifikát. Máte-li pouze Vámi signovaný certifikát a aktivujete-li tento mechanismus, můžete poškodit Teampass!! Vaše configuration Apache SSL musí obsahovat \'SSLOptions + ExportCertData\'.',
    'settings_anyone_can_modify_bydefault' => 'Aktivovat možnost \'&lt;b&gt;&lt;i&gt;Všichni mohou upravovat&lt;/i&gt;&lt;/b&gt;\' jako standard',
    'to' => 'do',
    'settings_upload_maxfilesize_tip' => 'Maximální povolená velikost souboru. Musí být v souladu s nastavením Vašeho serveru.',
    'settings_upload_docext_tip' => 'Formáty dokumentů. Zadejte povolené koncovky názvů a oddělte je čárkami (,).',
    'settings_upload_imagesext_tip' => 'Formáty obrázků. Zadejte povolené koncovky názvů a oddělte je čárkami (,).',
    'settings_upload_pkgext_tip' => 'Formáty balíčků. Zadejte povolené koncovky názvů a oddělte je čárkami (,).',
    'settings_upload_otherext_tip' => 'Ostatní formáty. Zadejte povolené koncovky názvů a oddělte je čárkami (,).',
    'settings_upload_imageresize_options_tip' => 'Je-li aktivována, upraví tato možnost obrázky na níže udanou velikost.',
    'settings_upload_maxfilesize' => 'Maximální velikost souboru (Mb)',
    'settings_upload_docext' => 'Povolené typy dokumentů',
    'settings_upload_imagesext' => 'Povolené typy obrázků',
    'settings_upload_pkgext' => 'Povolené typy balíčků',
    'settings_upload_otherext' => 'Jiné povolené typy souborů',
    'settings_upload_imageresize_options_w' => 'Nová šířka obrázku (v pixelech)',
    'settings_upload_imageresize_options_h' => 'Nová výška obrázku (v pixelech)',
    'settings_upload_imageresize_options_q' => 'Nová kvalita obrázku',
    'settings_importing' => 'Povolit import dat ze souborů typu CSV/KeyPass',
    'admin_proxy_ip' => 'Použitý proxy server',
    'admin_proxy_ip_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Používáte-li pro internetové připojení proxy server, zadejte zde jeho IP.&lt;br&gt;Ponechte prázdné, pokud proxy server nepoužíváte.&lt;/span&gt;',
    'admin_proxy_port' => 'Použitý port proxy serveru',
    'admin_proxy_port_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Pokud jste zadal/a IP adresu proxy serveru, zadejte zde číslo jeho PORTU (často 8080).&lt;br&gt;Ponechte prázdné, pokud proxy server nepoužíváte.&lt;/span&gt;',
    'settings_ldap_elusers' => 'Lokální uživatelé TeamPassu',
    'settings_ldap_elusers_tip' => 'Tato možnost dovolí autorizaci uživatelů přes LDAP. Deaktivujte, pokud nemáte žádný seznam LDAP.',
    'db_items_edited' => 'Momentálně upravované položky ',
    'item_edition_start_hour' => 'Upravováno od',
    'settings_delay_for_item_edition' => 'Doba (v minutách), po jejímž uplynutí se zpracování považuje za nezdařené',
    'settings_delay_for_item_edition_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Při zpracovávání je dotyčná položka zablokována pomocí softwarového zámku, takže souběžná editace položek není možná.&lt;br&gt;Toto nastavení umožňuje odstranit tento zámek po uplynutí určité doby. Je-li hodnota nastavena na 0, nebude zámek nikdy odstraněn.&lt;/span&gt;',
    'db_users_logged' => 'Momentálně přihlášení uživatelé',
    'action' => 'Akce',
    'login_time' => 'Přihlášen od',
    'lastname' => 'Příjmení',
    'user_login' => 'Přihlášení ',
    'role' => 'Role',
    'error_role_exist' => 'Tato role již existuje!',
    'error_no_edition_possible_locked' => 'Nelze editovat - položka je již momentálně editována!',
    'select' => 'Vyberte',
    'items' => 'Položky',
    'enable_personal_saltkey_cookie' => 'Povolit uložení osobního klíče SALT do cookie',
    'personal_saltkey_cookie_duration' => 'Životnost cookie osobního klíče SALT (ve dnech) před vypršením platnosti ',
    'admin_email_smtp_server' => 'Server SMTP',
    'admin_email_auth' => 'Server SMTP vyžaduje nastavení',
    'admin_email_auth_username' => 'Uživatelské jméno pro přihlášení',
    'admin_email_auth_pwd' => 'Heslo pro přihlášení',
    'admin_email_port' => 'Port serveru',
    'admin_email_from' => 'Emailová adresa odesílatele',
    'admin_email_from_name' => 'Jméno odesílatele',
    'admin_email_test_configuration_tip' => 'Tento test odešle email na zadanou adresu. Pokud jej neobdržíte, zkontrolujte Vaše přihlašovací údaje.',
    'admin_email_test_subject' => '[TeamPass] Zkušební email',
    'admin_email_test_body' => 'Dobrý den,&lt;br&gt;&lt;br&gt;email byl úspěšně odeslán.&lt;br&gt;&lt;br&gt;Na shledanou.',
    'admin_email_result_ok' => 'Email byl odeslán... Prosím zkontrolujte Vaši poštovní schránku.',
    'email_bodyalt_item_updated' => 'Heslo pro #item_label# bylo obnoveno.',
    'admin_email_send_backlog_tip' => 'Tento skript umožňuje rozeslat všechny emaily z databáze.&lt;br /&gt;Toto může trvat určitou dobu - v závislosti na počtu odesílaných emailů.',
    'please_wait' => 'Prosím čekejte!',
    'admin_path_to_files_folder' => 'Cesta ke složce Soubory',
    'admin_path_to_files_folder_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Složka Soubory se používá na ukládání souborů vytvářených aplikací TeamPass a některých nahrávaných souborů.&lt;br&gt;DŮLEŽITÉ UPOZORNĚNÍ: z bezpečnostních důvodů by tato složka neměla ležet v kořenové složce Vašeho webového serveru. Složka Soubory by měla být umístěna v chráněné oblasti, definované ve zvláštní přesměrovací instrukci ve webové konfiguraci.&lt;br&gt;DŮLEŽITÉ UPOZORNĚNÍ 2: Uvažte zřízení úlohy v systému CRON pro pravidelné vyklizení této složky.&lt;/span&gt;',
    'admin_path_to_upload_folder_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Složka Nahrávání se používá na nahrávání všech souborů, souvisejících s položkami.&lt;br&gt;DŮLEŽITÉ UPOZORNĚNÍ: z bezpečnostních důvodů by tato složka neměla ležet v kořenové složce Vašeho webového serveru. Složka Nahrávání by měla být umístěna v chráněné oblasti, definované ve zvláštní přesměrovací instrukci ve webové konfiguraci.&lt;br&gt;DŮLEŽITÉ UPOZORNĚNÍ 2: Tuto složku a její obsah nemažte! Uložené soubory jsou přiřazené k položkám.&lt;/span&gt;',
    'pdf_password_warning' => 'Musíte zadat šifrovací klíč!',
    'admin_pwd_maximum_length' => 'Maximální délka hesla',
    'admin_pwd_maximum_length_tip' => 'Standardní délka hesla je stanovena na 40 znaků. Prodloužení standardní délky se projeví snížením výkonu aplikace. Čím delší heslo, tím pomaleji bude server šifrovat, dešifrovat a zobrazovat hesla.',
    'settings_insert_manual_entry_item_history' => 'Povolit manuální vkládání údajů do Deníku historie položek',
    'settings_insert_manual_entry_item_history_tip' => 'Možná potřebujete z nějakého důvodu manuelně přidat záznam do historie položky. Po aktivaci této volby je to možné.',
    'admin_path_to_upload_folder' => 'Přístupová cesta k nahrávací složce (upload)',
    'admin_setting_enable_delete_after_consultation' => 'Dotyčná položka může být automaticky odstraněna',
    'admin_setting_enable_delete_after_consultation_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Po aktivaci obdrží autor nové položky možnost nechat tuto položku automaticky odstranit po X-krát opakovaném nahlédnutí.&lt;/span&gt;',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Při nahlédnutí položky zaslat vyrozumění po emailu ',
    'share_sent_ok' => 'Email byl odeslán',
    'see_item_title' => 'Detaily položky',
    'email_on_open_notification_subject' => '[TeamPass] Vyrozumění o otevření položky',
    'email_on_open_notification_mail' => 'Dobrý den,&lt;br&gt;&lt;br&gt;uživatel #tp_user# otevřel a nahlédnul položku  \'#tp_item#\'.&lt;br&gt;Pro její zobrazení klikněte &lt;a href="#tp_link#"&gt;ZDE&lt;/a&gt;.&lt;br&gt;&lt;br&gt;S přátelským pozdravem.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Váš nový uživatelský účet',
    'email_new_user_mail' => 'Dobrý den,&lt;br&gt;&lt;br&gt;správce zřídil Váš uživatelský účet pro TeampPass.&lt;br&gt;Pro přihlášení prosím použijte následující autorizační údaje:&lt;br&gt;- Uživatelské jméno: #tp_login#&lt;br&gt;- Heslo: #tp_pw#&lt;br&gt;&lt;br&gt;K přístupu klikněte na &lt;a href="#tp_link#"&gt;LINK&lt;/a&gt; .&lt;br&gt;&lt;br&gt;Na shledanou.',
    'error_empty_data' => 'Žádná data ke zpracování!',
    'error_not_allowed_to' => 'K provedení tohoto kroku nejste autorizován/a!',
    'request_access_ot_item' => 'Požádat o kontakt k autorovi',
    'email_request_access_subject' => '[TeamPass] Požádat o přístup k položce',
    'email_request_access_mail' => 'Dobrý den #tp_item_author#,&lt;br&gt;&lt;br&gt;uživatel #tp_user# požádal o přístup k položce #tp_item#.&lt;br&gt;&lt;br&gt;Před uvolněním přístupu k této položce ověřte, prosím, přístupová práva tohoto uživatele.&lt;br&gt;&lt;br&gt;Na shledanou.',
    'admin_action_change_salt_key' => 'Změna hlavního klíče SALT',
    'nb_items_by_query' => 'Počet položek obdržených při každém vyhledávání',
    'nb_items_by_query_tip' => '&lt;span style="font-size:11px;max-width:300px;"&gt;Zobrazení seznamu většího počtu položek vyžaduje více času.&lt;br&gt;Při nastavení \'auto\' program upraví tento počet podle velikosti uživatelovy obrazovky.&lt;br&gt;Při nastavení \'max\' bude najednou zobrazen kompletní výpis.&lt;br&gt;Zadejte číslo dle počtu položek, který chcete obdržet při každém vyhledávání.&lt;/span&gt;',
    'open_url_link' => 'Otevřít na nové stránce',
    'error_pw_too_long' => 'Heslo je příliš dlouhé! Přípustných je pouze 40 znaků.',
    'at_restriction' => 'Omezení',
    'pw_encryption_error' => 'Chyba při šifrování hesla!',
    'enable_send_email_on_user_login' => 'Zaslat správcům email při přihlášení uživatele',
    'email_subject_on_user_login' => '[TeamPass] Přihlášení uživatele ',
    'email_body_on_user_login' => 'Dobrý den,&lt;br&gt;&lt;br&gt;Uživatel #tp_user# se přihlásil do TeamPass dne #tp_date# v #tp_time#.&lt;br&gt;&lt;br&gt;Na shledanou.',
    'account_is_locked' => 'Tento účet je uzamčen.',
    'activity' => 'Aktivita',
    'add_role_tip' => 'Přidat novou roli',
    'admin' => 'Správa',
    'admin_action_db_backup' => 'Vytvořit zálohu databáze',
    'admin_action_db_clean_items' => 'Odstranit z databáze opuštěné položky',
    'admin_action_db_clean_items_tip' => 'Tímto budou z databáze odstraněny pouze položky a deníky, které nebyly odstraněny při vymazání odpovídající složky. Doporučujeme však předtím vytvořit zálohu databáze.',
    'admin_action_db_optimize' => 'Optimalizovat databázi',
    'admin_action_db_restore' => 'Zrekonstruovat databázi ze zálohy',
    'admin_action_purge_old_files' => 'Odstranit staré soubory',
    'admin_action_purge_old_files_tip' => 'Tímto budou vymazány všechny dočasné soubory starší než 7 dnů.',
    'admin_action_reload_cache_table' => 'Znovu načíst vyrovnávací paměť databáze',
    'admin_action_reload_cache_table_tip' => 'Tímto je možné znovu načíst celý obsah vyrovnávací paměti databáze. To může být v určitých situacích užitečné.',
    'admin_help' => 'Nápověda',
    'admin_ldap_configuration' => 'Konfigurace LDAP',
    'admin_main' => 'Informace',
    'admin_misc_cpassman_dir' => 'Úplná cesta k souborům TeamPass v souborovém systému',
    'admin_misc_cpassman_url' => 'Úplná adresa URL k souborům TeamPass',
    'admin_misc_custom_login_text' => 'Individuální vstupní text přihlášení',
    'admin_misc_custom_logo' => 'Úplná adresa URL k individuálnímu vstupnímu logu',
    'admin_misc_favicon' => 'Úplná adresa URL k souboru \'favicon\'',
    'admin_settings' => 'Správní nastavení',
    'admin_settings_title' => 'Nastavení aplikace TeamPass',
    'admin_setting_activate_expiration' => 'Aktivovat lhůtu platnosti hesel',
    'admin_setting_activate_expiration_tip' => 'Po aktivaci nebudou položky s uplynulou platností uživatelům zobrazovány.',
    'admin_views' => 'Náhledy',
    'alert_message_done' => 'Provedeno!',
    'all' => 'vše',
    'anyone_can_modify' => 'Povolit změnu této položky kýmkoli, kdo k ní má přístup',
    'at' => 'v',
    'at_category' => 'Složka',
    'at_copy' => 'Kopírování ukončeno',
    'at_delete' => 'Vymazáno',
    'at_description' => 'Popis',
    'at_label' => 'Název',
    'at_login' => 'Přihlášení',
    'at_moved' => 'přesunuto',
    'at_personnel' => 'Osobní',
    'at_restored' => 'Zrekonstruováno',
    'at_shown' => 'Přístup',
    'at_url' => 'Adresa URL',
    'author' => 'Autor',
    'authorized_groups' => 'Povolené složky',
    'auth_creation_without_complexity' => 'Povolit tvorbu položek bez ohledu na požadovanou komplexitu hesla',
    'auth_modification_without_complexity' => 'Povolit změnu položek bez ohledu na požadovanou komplexitu hesla',
    'cancel' => 'Zrušit',
    'can_create_root_folder' => 'Může tvořit složky na základní úrovni (root)',
    'changelog' => 'Deník změn',
    'close' => 'Zavřít',
    'complexity' => 'Komplexita',
    'complex_asked' => 'Vyžadovaná komplexita',
    'complex_level0' => 'Velmi jednoduché',
    'complex_level1' => 'Jednoduché',
    'complex_level2' => 'Normální',
    'complex_level3' => 'Zesílené',
    'complex_level4' => 'Silné',
    'complex_level5' => 'Bezpečné',
    'complex_level6' => 'Velmi bezpečné',
    'confirm' => 'Potvrdit',
    'confirm_del_from_fav' => 'Prosím potvrďte, že chcete vymazat Vaše oblíbené položky',
    'connections' => 'připojení',
    'copy' => 'Zkopírovat',
    'copy_to_clipboard_small_icons' => 'Aktivovat malé ikony pro kopírování do paměti na stránce položek',
    'copy_to_clipboard_small_icons_tip' => '&lt;span style=\'width:300px;\'&gt;Tím lze zredukovat nároky na operační paměť pro uživatele starších počítačů.&lt;br&gt; Informace o položkách pak sice nejsou načítány, nelze ale ani rychle kopírovat uživatelská jména a hesla položek.&lt;/span&gt;',
    'date' => 'Datum',
    'date_format' => 'Formát pro datum',
    'delete' => 'Vymazat',
    'deletion' => 'Vymazáno',
    'del_button' => 'Vymazat',
    'description' => 'Popis',
    'disconnect' => 'Odhlásit',
    'done' => 'Provedeno',
    'duplicate_folder' => 'Pro vytvoření více složek se stejným názvem je nutná autorizace.',
    'duplicate_item' => 'Pro vytvoření více položek se stejným názvem je nutná autorizace.',
    'email' => 'Email',
    'email_subject' => 'Byla vytvořena nová položka v aplikaci TeamPass',
    'enable_favourites' => 'Dovolit uživatelům ukládat oblíbené položky',
    'enable_personal_folder' => 'Aktivovat Osobní složku',
    'enable_personal_folder_feature' => 'Aktivovat funkci Osobní složky',
    'enable_user_can_create_folders' => 'Uživatelé smějí spravovat složky v povolených nadřazených složkách',
    'encrypt_key' => 'Šifrovací klíč',
    'errors' => 'chyby',
    'error_group_exist' => 'Tato složka již existuje!',
    'error_html_codes' => 'Text obsahuje kód HTML! To je nepřípustné.',
    'error_item_exists' => 'Tato položka již existuje!',
    'error_label' => 'Název je nutné zadat!',
    'error_must_enter_all_fields' => 'Musíte zadat všechny údaje!',
    'error_pw' => 'Heslo je nutné zadat!',
    'error_tags' => 'V záložkách nejsou přípustné žádné dělicí znaky - pouze mezery.',
    'error_user_exists' => 'Uživatel již existuje',
    'expiration_date' => 'Datum vypršení platnosti',
    'find' => 'Najít',
    'forbidden_groups' => 'Zakázané složky',
    'forgot_my_pw_email_sent' => 'Email byl odeslán.',
    'functions' => 'Role',
    'gestionnaire' => 'Manažer',
    'god' => 'Všemohoucí',
    'group' => 'Složka',
    'group_parent' => 'Nadřazená složka',
    'group_pw_duration' => 'Interval obnovení',
    'group_pw_duration_tip' => 'v měsících (pro deaktivování zadejte 0).',
    'history' => 'Historie',
    'home_personal_saltkey' => 'Váš osobní klíč SALTKEY',
    'home_personal_saltkey_label' => 'Zadejte Váš osobní klíč SALTKEY',
    'import_error_no_read_possible' => 'Soubor nelze načíst!',
    'import_error_no_read_possible_kp' => 'Soubor nelze načíst! Je vyžadován soubor typu KeePass.',
    'import_keepass_to_folder' => 'Zvolte cílovou složku',
    'index_add_one_hour' => 'Prodloužit povolenou dobu přihlášení o 1 hodinu',
    'index_change_pw_confirmation' => 'Potvrdit',
    'index_expiration_in' => 'povolená doba přihlášení vyprší za',
    'index_get_identified' => 'Prosím zadejte Vaše identifikační údaje',
    'index_last_pw_change' => 'Poslední změna hesla',
    'index_last_seen' => 'Poslední připojení',
    'index_login' => 'Uživatelský účet',
    'index_new_pw' => 'Nové heslo',
    'index_password' => 'Heslo',
    'index_pw_error_identical' => 'Hesla musí být shodná!',
    'index_pw_level_txt' => 'Komplexita',
    'index_session_duration' => 'Uplynulá doba přihlášení',
    'info' => 'Informace',
    'item_menu_copy_login' => 'Zkopírovat uživatelské jméno',
    'item_menu_copy_pw' => 'Zkopírovat heslo',
    'item_menu_del_from_fav' => 'Odebrat z oblíbených položek',
    'kbs' => 'Databáze znalostí',
    'kb_menu' => 'Databáze znalostí',
    'last_items_title' => 'Poslední nahlédnuté položky',
    'ldap_extension_not_loaded' => 'LDAP není na serveru aktivováno',
    'level' => 'Umístění/úroveň',
    'login' => 'Uživatelské jméno',
    'mask_pw' => 'Zakrýt/odkrýt heslo',
    'max_last_items' => 'Maximální množství Posledních nahlédnutých položek (standardně 10)',
    'minutes' => 'minut',
    'name' => 'Jméno',
    'nb_false_login_attempts' => 'Počet dovolených nezdařilých pokusů o přihlášení do uzamčení účtu (0 pro deaktivaci)',
    'nb_folders' => 'Pocet složek',
    'nb_items' => 'Pocet položek',
    'new_label' => 'Nové označení',
    'no' => 'Ne',
    'none' => 'Nic/žádný',
    'none_selected_text' => 'Nevybráno nic',
    'not_allowed_to_see_pw' => 'Tato položka pro Vás není viditelná!',
    'not_allowed_to_see_pw_is_expired' => 'Lhůta platnosti této položky vypršela!',
    'not_defined' => 'Není definováno',
    'number_of_used_pw' => 'Počet nových hesel, který uživatel musí zadat před znovupoužitím hesla starého.',
    'pages' => 'Stránky',
    'pdf_download' => 'Stáhnout soubor',
    'personal_salt_key' => 'Váš osobní klíč SALTKEY',
    'pw' => 'Heslo',
    'pw_generate' => 'Vytvořit',
    'pw_is_expired_-_update_it' => 'Lhůta platnosti této položky vypršela! Musíte změnit její heslo.',
    'pw_life_duration' => 'Životnost uživatelských hesel ve dnech do vypršení (zadejte 0 pro trvalá hesla)',
    'readme_open' => 'Otevřít kompletní soubor README',
    'read_only_account' => 'Pouze ke čtení',
    'restore' => 'Zrekonstruovat',
    'restricted_to' => 'Omezeno na',
    'restricted_to_roles' => 'Povolit omezení položek na Uživatele a Role',
    'root' => 'Základ/kořen',
    'secure' => 'Zabezpečeno',
    'see_logs' => 'Nahlédnout protokoly',
    'settings_anyone_can_modify' => 'Aktivovat pro každou položku možnost úpravy kýmkoliv',
    'settings_anyone_can_modify_tip' => '&lt;span style="max-width: 300px;"&gt;Po aktivaci bude do formuláře položky přidána možnost povolit autorovi změnu položky kterýmkoliv uživatelem.&lt;/span&gt;',
    'settings_default_language' => 'Vybrat standardní jazyk',
    'settings_kb' => 'Povolit databázi znalostí a zkušeností (beta)',
    'settings_kb_tip' => '&lt;span style=\'font-size:11px;max-width:300px;\'&gt;Aktivací bude přidána stránka, kde můžete vybudovat Vaší databázi znalostí a zkušeností.&lt;/span&gt;',
    'settings_ldap_domain' => 'Přípona účtu LDAP pro Vaši doménu',
    'settings_ldap_domain_controler' => 'Pole LDAP správců domény',
    'settings_ldap_domain_controler_tip' => '&lt;span style="max-width: 300px;"&gt;Zadejte více správců, pokud chcete, aby třída rozdělovala dotazy na LDAP na více serverů.&lt;br&gt;Domény musí být odděleny čárkou ( , )!&lt;br&gt;Např.: doména_1,doména_2,doména_3&lt;/span&gt;',
    'settings_ldap_domain_dn' => 'Kořenové jméno LDAP (dn) Vaší domény',
    'settings_ldap_mode' => 'Umožnit autorizaci uživatelů prostřednictvím serveru LDAP',
    'settings_ldap_mode_tip' => 'Aktivujte pouze pokud máte server LDAP a chcete jej používat k autorizaci.&lt;br&gt;&lt;span style="" 10px;="" max-width:="" 300px;\\=""&gt;Konfiguraci LDAP je třeba provést manuelně. Musíte upravit soubor &lt;b&gt;adLDAP.php&lt;/b&gt; umístěný v &lt;i&gt;/includes/libraries/adLDAP&lt;/i&gt;. Pozměňte všechny chráněné parametry mezi řádky 68 až 128 tak, aby odpovídaly konfiguraci Vašeho serveru LDAP.&lt;/span&gt;',
    'settings_ldap_ssl' => 'Používat LDAP přes SSL (LDAPS)',
    'settings_ldap_tls' => 'Používat LDAP přes TLS',
    'settings_log_accessed' => 'Aktivovat protokolování přístupu uživatelů k položkám',
    'settings_log_connections' => 'Aktivovat zápis všech uživatelských spojení do deníku',
    'settings_maintenance_mode' => 'Přepnout TeamPass do správního režimu',
    'settings_manager_edit' => 'Manažeři mohou upravovat a odstraňovat položky, které jsou pro ně viditelné',
    'settings_printing' => 'Povolit zápis položek do souboru PDF',
    'settings_printing_tip' => 'Po aktivaci bude na domovskou stránku uživatele přidáno tlačítko, které mu umožní zapsat seznam položek do čitelného souboru PDF. Pozor: hesla budou do tohoto souboru zapsána nezašifrovaná.',
    'settings_restricted_to' => 'Povolit pro položky funkci "Omezeno na"',
    'settings_show_description' => 'Zobrazit popis v seznamu položek',
    'size' => 'Délka',
    'tags' => 'Záložky',
    'timezone_selection' => 'Volba časové zóny',
    'time_format' => 'Formát časových údajů',
    'url' => 'Adresa URL',
    'user' => 'Uživatel',
    'users_online' => 'uživatelé/ů online',
    'user_alarm_no_function' => 'Tento uživatel nemá žádné role!',
    'yes' => 'Ano',
    'one_time_view_item_url_box' => 'Sdělte tuto jednorázovou adresu URL důvěryhodné osobě. <br><br>#URL#<br><br>Nezapomeňte, že tento link je viditelný pouze jednou do #DAY#',
    'settings_api' => 'Povolit přístup k položkám Teampassu pomocí API',
    'settings_api_tip' => 'Přístup pomocí API umožní externím aplikacím ve formátu JSON přístup k položkám.',
    'settings_api_keys_list' => 'Seznam klíčů',
    'settings_api_keys_list_tip' => 'Toto jsou klíče, které mají povolený přístup k Teampassu. Bez platného není přístup možný. Tyto klíče byste měl/a rozdělovat s rozvahou.',
    'settings_api_key' => 'Klíč',
    'settings_api_add_ip' => 'Přidat novou adresu IP',
    'settings_api_ip' => 'Adresa IP',
    'subfolder_rights_as_parent' => 'Nová podsložka dědí přístupová práva od složky nadřazené',
    'subfolder_rights_as_parent_tip' => 'Je-li tato funkce deaktivována, zdědí každá nová podsložka přístupová práva od přiřazené role jejího tvůrce. Je-li tato funkce aktivována, zdědí každá nová podsložka přístupová práva od složky nadřazené.',
    'show_only_accessible_folders_tip' => 'Standardně vidí uživatel celý strom všech složek, i když ke všem nemá přístupová práva. Náhled můžete zjednodušit vyjmutím těch složek z náhledu, k nimž uživatel nemá přístupová práva.',
    'show_only_accessible_folders' => 'Zjednodušit strom položek vyjmutím složek, k nimž uživatel nemá přístupová práva.',
    'comment' => 'Komentář',
    'suggestion_menu' => 'Návrhy',
    'settings_suggestion' => 'Povolit návrh položek pro uživatele s výhradním právem ke čtení (Read-Only)',
    'settings_suggestion_tip' => 'Toto umožní uživatelům s výhradním právem čtení (Read-Only) navrhovat nové položky nebo upravovat stávající. Tyto návrhy budou prověřovány Správcem nebo Manažerem.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'Heslo pro LDAP bind',
    'settings_ldap_search_base' => 'Základna hledání pro LDAP',
    'settings_ldap_bind_dn_tip' => 'Bind DN, které může spojovat a hledat uživatele ve stromu.',
    'settings_ldap_bind_passwd_tip' => 'Heslo pro Bind DN, které může spojovat a hledat uživatele ve stromu.',
    'settings_ldap_search_base_tip' => 'Kořen (root) DN pro vyhledávání ve stromu',
    'admin_email_server_url' => 'Adresa URL používaná jako odkazy v emailech',
    'enable_email_notification_on_user_pw_change' => 'Zaslat uživateli email, pokud bylo změněno jeho heslo',
    'settings_otv_expiration_period' => 'Prodleva ',
    'write' => 'přepsat',
    'read' => 'číst',
    'no_access' => 'bez přístupu',
    'right_types_label' => 'Zvolte druh přístupu k této složce pro zvolenou skupinu uživatelů',
    'duplicate_item_in_folder' => 'Povolit položky s identickým názvem v běžné složce',
    'settings_roles_allowed_to_print' => 'Vybrat uživatelské role s právem exportovat položky',
    'settings_roles_allowed_to_print_tip' => 'Vybrané uživatelské role budou oprávněny exportovat položky do souboru',
    'admin_email_security' => 'Zabezpečení SMTP',
    'alert_page_will_reload' => 'Stránka bude nyní znova natažena',
    'file_protection_password' => 'Zadat heslo souboru',
    'expand' => 'Vyklapnout',
    'collapse' => 'Sklapnout',
    'settings_ldap_user_attribute' => 'Prohledat uživatelský atribut',
    'settings_ldap_user_attribute_tip' => 'Atribut LDAP k prohledání na jméno uživatele',
    'log_user_initial_pwd_changed' => 'Počáteční heslo zadáno',
    'log_user_email_changed' => 'Uživatelův email změněn na ',
    'log_user_created' => 'Uživatelský účet vytvořen',
    'log_user_locked' => 'Uživatel je zablokován',
    'log_user_unlocked' => 'Uživatel je odblokován',
    'log_user_pwd_changed' => 'Uživatelské heslo bylo změněno',
    'settings_default_session_expiration_time' => 'Standardní doba uplynutí uživatelského sezení',
    'settings_duo' => 'Povolit DUOSecurity pro 2-složkovou autentizaci uživatelů',
    'settings_duo_tip' => '2-složková autentizace uživatelů může být prováděna prostřednictvím DUOSecurity.com. Tato knihovna zaručuje vysokou úroveň bezpečnosti při autentizaci uživatelů.',
    'admin_duo_akey' => 'Klíč AKEY',
    'admin_duo_ikey' => 'Klíč IKEY',
    'admin_duo_skey' => 'Klíč SKEY',
    'admin_duo_host' => 'Host',
    'settings_duo_explanation' => 'Tyto přihlašovací údaje byly vydány webovou aplikací, které jste pro Teampass vytvořil/a na správcovské stránce DuoSecurity.<br /> Stisknutím tlačítka Uložit budou tyto údaje uloženy do souboru sk.php.',
    'admin_duo_intro' => 'Vyplňte potřebné údaje do následujících políček',
    'edit' => 'Změnit',
    'user_info_locked' => 'Uživatel je právě zablokován',
    'user_info_unlock_question' => 'Odblokovat uživatele?',
    'user_info_lock_question' => 'Zablokovat uživatelský účet?',
    'user_info_delete_question' => 'Vymazat uživatelský účet?',
    'user_info_active' => 'Uživatel je právě odblokován',
    'refresh' => 'Obnovit',
    'loading' => 'Nahrává se',
    'searching' => 'Vyhledává se ....',
    'list_items_with_tag' => 'Vytvožit seznam položek s touto značkou ',
    'no_item_to_display' => 'Žádné položky na zobrazení',
    'opening_folder' => 'Načítá se složka ...',
    'suggestion_notify_subject' => '[Teampass] Nový návrh byl proveden.',
    'suggestion_notify_body' => 'Dobrý den,<br><br>Byl proveden nový návrh. Tento návrh musíte schválit než může být používán ostatními uživateli, <br>Několik informací k návrhu:<br>- Název: #tp_label#<br>- Složka: #tp_folder#<br>- Uživatel: #tp_user#<br><br>Notice that this email has been sent to all Managers.<br><br>Best regards. ',
    'error_unknown' => 'Došlo k neočekávané chybě!',
    'no_edit' => 'Může zapisovat, ale nesmí měnit položky',
    'role_cannot_edit_item' => 'Nesmí měnit položky',
    'no_delete' => 'Může zapisovat, ale nesmí mazat položky',
    'role_cannot_delete_item' => 'Nesmí mazat položky',
    'my_profile' => 'Můj profil',
    'starting' => 'Startuje se....',
    'total_number_of_items' => 'Celkový počet položek',
    'finalizing' => 'Dokončuje se',
    'treating_items' => 'Zpracovávají se položky',
    'number_of_items_treated' => 'Počet zpracovaných položek',
    'error_sent_back' => 'Další zaznamenaná chyba',
    'full' => 'Plný',
    'sequential' => 'Posloupný',
    'tree_load_strategy' => 'Způsob načítání stromu',
    'syslog_enable' => 'Protokolovat chyby na serveru <i>syslog</i>',
    'syslog_host' => 'Jméno nebo adresa IP protokolovacího serveru syslog',
    'syslog_port' => 'Číslo portu pro syslog (standard 514)',
    'error_bad_credentials' => 'Přihlašovací údaje nesouhlasí!',
    'settings_ldap_usergroup' => 'Prohledat skupinu v adresáři LDAP',
    'settings_ldap_usergroup_tip' => 'Zadejte skupinu v adresáři LDAP, kde jsou uloženy přihlašovací údaje povolených uživatelů. Např.: cn=sysadmins,ou=groups,dc=example,dc=com ',
    'server_password_change_enable' => 'Povolit změnu hesla na vzdáleném serveru (prostřednictvím SSH spojení)',
    'update_server_password' => 'Obnovit přístupové heslo serveru',
    'ssh_pwd' => 'Heslo SSH',
    'ssh_user' => 'Uživatelské jméno SSH',
    'ssh_password_frequency_change_info' => 'Zvolte interval pro automatickou obnovu hesla na serveru (zvolením hodnoty 0 se automatická obnova hesla deaktivuje).<br />Automatická obnova hesla  bude prováděna pouze pokud správce systému rovněž nakonfiguroval plánovanou změnu v systému cronjob. ',
    'ssh_password_frequency_change' => 'Četnost změny hesla (v měsících)',
    'ssh_scheduled_change' => 'Plánovaná změna',
    'ssh_one_shot_change' => 'Jednorázová změna',
    'server_password_change_enable_tip' => 'Toto nastavení přidá k položce hesla možnost automaticky změnit uživatelské heslo na serveru udaném adresou URL. Zadaný vzdálený server musí umožnit přihlášení do systému přes SSH pomocí uživatelského jména a hesla. Automaticky naplánované změny hesla budou prováděny až po začlenění <i>/files/script.ssh.php</i> do systému crontab na webovém serveru Teampassu (provedení jednou denně).',
    'error_bad_credentials_more_than_3_times' => 'Přihlašovací údaje jsou chybné!<br>Prosím před dalším pokusem vyčkejte 10 sekund ',
    'settings_ldap_object_class' => 'Prohledat třídu',
    'settings_ldap_object_class_tip' => 'Třída adresáře LDAP k prohledání (např. uživatelský účet nebo účet POSIX)',
    'rebuild_config_file' => 'Nově vygenerovat konfigurační soubor',
    'rebuild_config_file_tip' => 'Konfigurační soubor obsahuje systémové proměnné, které jsou třeba ještě před připojením k databance. Vygenerováním konfiguračního souboru jsou do něj tyto  proměnné zapsány (lze povést kdykoliv). Soubor je sice standardně uložen pod /includes/config/tp.config.php, ale z bezpečnostních důvodů by měl být umístěn mimo složku www.',
    'error_folder_complexity_lower_than_top_folder' => 'Dceřinné složky musí mít heslo o síle stejné nebo vyšší než složka nadřazená',
    'new_item_email_body' => 'Dobrý den, <br /><br />V Teampassu byla vytvořena nová položka \'#label\'.<br />Položku můžete otevřít kliknutím tohoto odkazu <a href="#link#"></a>.<br/><br />Na shledanou. ',
    'failed_logins' => 'Chybná přihlášení',
    'error_only_numbers_in_folder_name' => 'Název složky nesmí obsahovat pouze číslice. Prosím zvolte název, který obsahuje i písmena.',
    'encrypted_data' => 'Data jsou v databázi zašifrována',
    'settings_ldap_port' => 'Port LDAP',
    'user_profile_agses_card_id' => 'Vaše ID karty AGSES',
    'ga_flash_qr_and_login' => 'Sejměte tento QR kód Vaším mobilním přístrojem, zadejte kód pro 2-faktorovou authentifikaci a stiskněte tlačítko \'Zadat\'',
    'i_need_to_generate_new_ga_code' => 'Potřebuji nový QR kód. Prosím zašlete mi emailem časově omezený Identifikační kód.',
    'settings_manager_move_item' => 'Správci mohou přesouvat všechny viditelné položky.',
    'user_folders_rights' => 'Viditelné složky',
    'create_item_without_password' => 'Povolit tvorbu položek bez definovaného hesla',
    'share_rights_info' => 'Toto dialogové políčko Vám umožňuje předat práva jednoho uživatele jiným vybraným uživatelům.<br>Uvědomte si, že stávající práva zvolených uživatelů budou vymazána a nahrazena identickou kopií práv zdrojového uživatele.',
    'share_rights_source' => 'Zdrojový uživatel',
    'share_rights_destination' => 'Cílový uživatelé',
    'ga_reset_by_user' => 'Uživatel smí resetovat svůj 2FA kód',
    'ga_reset_by_user_tip' => 'Je-li tato volba aktivována, pak uživatel smí resetovat svůj kód 2FA pomocí linku na přihlašovací stránce. To může být užitečné např. v případě výměny mobilního přístroje. Je-li tato volba deaktivována, pak musí uživatel požádat o vytvoření nového kódu Správce.',
    'enable_massive_move_delete' => 'Povolit uživateli hromadně přesouvat a mazat data ',
    'enable_massive_move_delete_tip' => 'Je-li tato volba aktivována, pak uživatel smí provádět operace hromadného přesouvání a/nebo mazání. Uživatel smí toto prévádět pouze na položkách, které jsou pro něj povoleny.',
    'mass_operation' => 'Hromadná operace na položkách',
    'move_items' => 'Přesunout vybrané položky',
    'delete_items' => 'Vymazat vybrané položky',
    'you_decided_to_move_items' => 'Hodláte přesunout položky',
    'you_decided_to_delete_items' => 'Hodláte vymazat položky',
    'suggest_password_change' => 'Navrhnout změnu hesla',
    'otv_is_enabled' => 'Uživatel smí vytvářet linky pro jednorázové nahlížení ',
    'error_source_and_destination_are_equal' => 'Zdrojová a cílová složka nesmí být shodné!',
    'sending_anonymous_statistics' => 'Zasílání anonymní statistiky.',
    'favourites_option_enabled' => 'Volba oblíbených položek aktivní',
    'personalfolders_option_enabled' => 'Volba osobních složek aktivní',
    'country_statistics' => 'Použít mapu světa',
    'country' => 'Země',
    'users_statistics' => 'Průměrný počet uživatelů na instanci',
    'items_all' => 'Všechny položky',
    'folders_all' => 'Všechny složky',
    'items_shared' => 'Všechny sdílené položky (kromě osobních)',
    'folders_shared' => 'Všechny sdílené složky (kromě osobních)',
    'items_statistics' => 'Průměrný počet položek na instanci',
    'folders_statistics' => 'Průměrný počet složek na instanci',
    'administrators_number' => 'Počet Správců',
    'administrators_number_statistics' => 'Průměrný počet Správců na instanci',
    'managers_number' => 'Počet Manažerů',
    'managers_number_statistics' => 'Průměrný počet Manažerů na instanci',
    'readonly_number_statistics' => 'Průměrný počet uživatelů s právem nahlížení na instanci',
    'readonly_number' => 'Počet uživatelů s právem nahlížení',
    'mysql_version' => 'Verze MySQL',
    'php_version' => 'Verze PHP',
    'teampass_version' => 'Verze aplikace TeamPass',
    'languages_used' => 'Používané jazyky',
    'languages_statistics' => 'Nejčastěji používaný jazyk',
    'kb_option_enabled' => 'Aktivována možnost znalostní databáze',
    'suggestion_option_enabled' => 'Aktivována možnost návrhů',
    'customfields_option_enabled' => 'Aktivována možnost zvláštních polí',
    'api_option_enabled' => 'Aktivována možnost API',
    '2fa_option_enabled' => 'Aktivována možnost 2FA',
    'agses_option_enabled' => 'Volba AGSES je povolena',
    'duo_option_enabled' => 'Aktivována možnost DUO Security',
    'ldap_option_enabled' => 'Volba LDAP aktivní',
    'syslog_option_enabled' => 'Volba SYSLOG aktivní',
    'stricthttps_option_enabled' => 'Volba Strict HTTPS aktivní',
    'characteristic' => 'Vlastnost',
    'current_value' => 'Aktuální hodnota',
    'communication_means' => 'Prostředky komunikace',
    'consider_a_donation' => 'Prosím zvažte peněžní dar',
    'more_information' => 'Více informací',
    'feature_request_canal' => 'Pro žádost o novou funkcionalitu použijte prosím',
    'bug_canal' => 'Pro oznámení chyby použijte prosím',
    'documentation_canal' => 'Dokumentace',
    'sending_anonymous_statistics_details' => 'Statistiky jsou nutné pro vývoj aplikace Teampass neboť informují o populaci uživatelů a způsobu užívání aplikace. Data, která dáte k dispozici, budou užívána výhradně interně pro datové vyhodnocení a nebudou v žádném případě předávána či prodávána třetím stranám.',
    'item_has_change_proposal' => 'Pro tuto položku existuje návrh na změnu',
    'check_data_after_reencryption' => 'Prosím zkontrolujte data. Během této operace byla vytvořena nová tabulka <b>Backup</b> (Záloha), která umožňuje vrátit se k předchozím datům.',
    'revert' => 'Vrátit se?',
    'revert_the_database' => 'Hodláte vrátit se k předchozí databázi. Prosím potvrďte.',
    'bad_psk' => 'Tento osobní klíč Saltkey je chybný!',
    'ldap_test_config' => 'Přezkoušet aktuální konfiguraci',
    'ldap_test_username' => 'Uživatelské jméno pro účely přezkoušení',
    'ldap_test_username_pwd' => 'Uživatelské heslo',
    'feature_support_canal' => 'Pro podporu a pomoc prosím použijte',
    'category' => 'Kategorie',
    'text' => 'Text',
    'type' => 'Typ',
    'data_is_masked' => 'Data jsou skrytá (Hidden)',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',

);
