<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.2
 * @file      italian.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Mostra codice di crittografia utente',
    'email_body_new_user' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>Un amministratore ha creato per te un account utente su Teampass. La prossima volta che ti connetterai a Teampass, utilizza le seguenti credenziali:<ul><li>login: #login#</li><li>Password: #password#</li><li>Codice di crittografia: #code#</li></ul><br><br><br>Saluti',
    'user_password' => 'Password utente',
    'user_temporary_encryption_code' => 'Codice di crittografia utente',
    'no_email_set' => 'Nessuna email è stata registrata',
    'send_user_password_by_email' => 'Decidi se la password di accesso dell’utente deve essere inviata via email.<br>In caso affermativo, premi il pulsante Invia.<br><br>Altrimenti usa il pulsante Copia negli appunti per inviarlo all’utente con un altro mezzo.<br>Diventa responsabilità dell’amministratore fornire all’utente la password in modo sicuro.',
    'admin_change_user_encryption_code_info' => 'Questa operazione ripristinerà il codice di crittografia per questo utente.',
    'send_by_email' => 'Inviare per email',
    'filters' => 'Filtri',
    'show_user_password' => 'Mostra password utente',
    'open_website' => 'Apri sito web',
    'mfa_for_roles' => 'MFA è richiesto per gli utenti nei ruoli',
    'mfa_for_roles_tip' => 'Per impostazione predefinita, una volta selezionato un metodo MFA, è abilitato per tutti gli utenti. Tuttavia, puoi selezionare i ruoli per i quali è previsto.<br>NON ANCORA IMPLEMENTATO',
    'at_least_one_administrator_is_requested' => 'È richiesto almeno un amministratore',
    'bad_code' => 'Codice errato',
    'generating_keys' => 'Generazione chiavi',
    'this_may_take_time' => 'L’operazione potrebbe richiedere un paio di minuti',
    'disable_enable' => 'Disabilita / Abilita',
    'user_disable_status' => 'Spunta la casella per disabilitare o lascia vuota per abilitare',
    'help_for_launching_items_encryption' => 'Dobbiamo generare il database delle chiavi per il tuo account. Fornisci il tuo codice di crittografia.',
    'managed_through_ad' => 'Gestito tramite AD',
    'new_ldap_user_info' => 'Si prega di completare la definizione per l’utente',
    'email_body_user_added_from_ldap_encryption_code' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>Ora hai un account in Teampass. Puoi utilizzare le tue credenziali AD per accedere.<br><br>Al primo accesso, ti verrà richiesto un codice di crittografia, utilizza:<br><br><b>#enc_code#</b><br><br><br>Saluti',
    'settings_ldap_user_object_filter' => 'Filtro oggetto utente',
    'settings_ldap_user_object_filter_tip' => 'Il filtro da utilizzare durante la ricerca di oggetti utente. Esempio: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Questo valore viene utilizzato in aggiunta al DN di base durante la ricerca e il caricamento degli utenti. Se non viene fornito alcun valore, la ricerca del sottoalbero inizierà dal DN di base. Esempi: ou=Utenti ; cn=utenti',
    'settings_ldap_additional_user_dn' => 'DN Utente Aggiuntivo',
    'ldap_user_has_changed_his_password' => 'La tua password di autenticazione è stata modificata nel tuo AD dall’ultima volta che hai effettuato l’accesso a Teampass. Dobbiamo adattare la tua chiave di crittografia. Fornisci la tua password precedente e quella attuale.',
    'provide_your_previous_password' => 'La tua password precedente',
    'admin_change_user_password_info' => 'Questa operazione ripristinerà la password corrente dell’utente selezionato.',
    'sending_email_message' => 'Ora invio email all’utente, attendi',
    'change_your_password_info_message' => 'Inserisci la tua nuova password di autenticazione e confermala.',
    'user_has_to_change_password_info' => 'La password attualmente utilizzata è stata generata. Ci si aspetta che tu lo cambi per motivi di sicurezza.',
    'ready_to_go' => 'Pronto ad andare',
    'passwords_not_the_same' => 'Le password fornite non sono le stesse',
    'inititialization' => 'Inizializzazione',
    'bad_password' => 'Password errata',
    'perform_checks' => 'Esegui controlli',
    'email_body_temporary_encryption_code' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>Al tuo account sono state apportate alcune modifiche che richiedono una nuova crittografia degli elementi per la sicurezza dei dati. La prossima volta che ti connetterai a Teampass, utilizza il codice successivo:<br><br><b>#enc_code#</b><br><br><br>Saluti',
    'temporary_encryption_code' => 'Il tuo codice di crittografia temporaneo',
    'renecyption_expected' => 'Dobbiamo ricrittografare le tue chiavi per adattarle ai privilegi corrispondenti al tuo account e ai tuoi diritti.',
    'error_no_user_in_ad' => 'Utente non trovato in AD!',
    'error_ad_user_expired' => 'L’utente è scaduto!',
    'error' => 'Errore rilevato',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'L’opzione hosts è un array di indirizzi IP o nomi host situati sulla tua rete che servono una directory LDAP (separati da una virgola). Inserisci tutti i server che vuoi a seconda della tua forest (con il minimo di uno ovviamente).',
    'base_distiguished_name' => 'DN di Base',
    'settings_ldap_bdn_tip' => 'Il nome distinto (DN) radice da utilizzare durante l’esecuzione di query sul server di directory. Esempi: o=esempio,c=com ; cn=utenti,dc=annuncio,dc=esempio,dc=com',
    'username' => 'Nome utente',
    'settings_ldap_username_tip' => 'Il nome distinto dell’utente che l’applicazione utilizzerà durante la connessione al server di directory. Esempi: cn=amministratore,cn=utenti,dc=annuncio,dc=esempio,dc=com ; cn=utente,dc=dominio,dc=nome',
    'settings_ldap_password_tip' => 'La password dell’utente sopra specificato.',
    'settings_ldap_port_tip' => 'Porta LDAP non sicura predefinita: 389, porta LDAP sicura predefinita: 636',
    'undefined' => 'Non definito',
    'error_cannot_open_file' => 'Impossibile aprire il file',
    'provide_current_psk_and_click_launch' => 'Quando sei pronto, fai clic sul pulsante Avvia',
    'start' => 'Inizio',
    'data_inconsistency' => 'Rilevata incoerenza dei dati. Ricarica la pagina!',
    'one_time_code_expected' => 'Previsto codice monouso',
    'data_are_missing' => 'Dati previsti mancanti',
    'one_time_code' => 'Codice monouso',
    'provide_personal_one_time_code' => 'Si prega di fornire il codice monouso ricevuto via e-mail',
    'change_authentification_type_to_ldap' => 'Modifica il tipo di autenticazione in LDAP',
    'change_authentification_type_to_local' => 'Cambia il tipo di autenticazione nel database locale di Teampass',
    'ldap_user_password_is_used_for_authentication' => 'La password utente in LDAP viene utilizzata per l’autenticazione',
    'local_user_password_is_used_for_authentication' => 'La password utente in Teampass viene utilizzata per l’autenticazione',
    'provide_your_current_password' => 'Fornisci la tua password attuale',
    'current_password' => 'Password attuale',
    'password_is_not_correct' => 'Questa password non è corretta',
    'ldap_password_change_warning' => 'La tua password di accesso è cambiata dall’ultima connessione. Viene richiesto di crittografare nuovamente tutte le chiavi utilizzando questa nuova password. Per questa operazione, compila il campo successivo con la tua precedente password ldap. L’operazione può richiedere diversi minuti.',
    'personal_items' => 'Oggetti personali',
    'logout_on_going' => 'Ora sarai disconnesso. Usa la tua nuova password per essere connesso da ora.',
    'fill_in_fields_and_hit_launch' => 'Fornisci i dati previsti e premi il pulsante Avvia',
    'please_select_a_folder' => 'Seleziona una cartella',
    'user_must_have_login_and_email' => 'L’utente deve disporre di un login e di un’e-mail',
    'user_has_this_role_in_teampass' => 'L’utente ha questo ruolo in Teampass',
    'select_role_to_create' => 'Seleziona il ruolo da creare',
    'adding_ldap_role_to_teampass' => 'Puoi decidere di creare un ruolo in Teampass proveniente dalla tua Active Directory. Ciò consentirà di associare l’utente a questo ruolo in Teampass.',
    'add_user_to_role' => 'Aggiungi questo ruolo all’utente in Teampass',
    'add_user_in_teampass' => 'Aggiungi utente in Teampass',
    'synchronized' => 'Sincronizzato',
    'output' => 'Produzione',
    'remove_install_folder' => 'La cartella di installazione deve essere rimossa',
    'list_users' => 'Elenco utenti',
    'ldap_synchronization' => 'Sincronizzazione LDAP',
    'in_progress' => 'In corso',
    'clipboard_password_life_duration' => 'Ritardo prima che gli appunti vengano cancellati (in secondi)',
    'clipboard_password_life_duration_tip' => 'Permette di definire un ritardo in secondi prima del quale la password copiata negli appunti verrà cancellata dagli appunti del browser. Imposta su 0 per disabilitare.',
    'clipboard_will_be_cleared' => 'La password è ora negli appunti. Presto sarà cancellato...',
    'file_folder_not_accessible' => 'La cartella File non è accessibile',
    'error_missing_id' => 'Si è verificato un errore. ID mancante... ?',
    'error_folder_not_allowed' => 'La cartella selezionata non è consentita',
    'all_fields_mandatory' => 'Tutti i campi sono obbligatori',
    'history_insert_entry' => 'Inserisci nella cronologia',
    'clear_form' => 'Pulisci form',
    'info_about_history_insertion' => 'Attenzione - Questa funzione permette di inserire manualmente un evento nello storico dell’elemento. Una volta aggiunto non sarà possibile rimuoverlo. Nota anche che l’ID del tuo account sarà associato a questa nuova voce.',
    'select_all' => 'Seleziona tutto',
    'unselect_all' => 'Deseleziona tutto',
    'no_data_to_display' => 'Nessun dato da visualizzare! O non esiste già alcuna cartella o non hai accesso a nessuna di esse.',
    'server' => 'Server',
    'data_refreshed' => 'Dati aggiornati',
    'loading_image' => 'Caricamento immagine',
    'compare_with_another_role' => 'Confronta con un altro ruolo',
    'only_display_folders_to_depth' => 'Visualizza solo le cartelle in profondità',
    'propagate_rights_to_descendants' => 'Propaga i diritti ai discendenti',
    'loading_data' => 'Caricamento dati',
    'password_overview_delay' => 'Ritardo per la panoramica della password',
    'password_overview_delay_tip' => 'Questa impostazione consente di definire per quanti secondi l’utente visualizzerà la password in chiaro.',
    'select_date_showing_items_expiration' => 'Elenca gli elementi scaduti alla data',
    'renewal_page_info' => 'Questa pagina permette di identificare gli elementi attualmente scaduti o in scadenza nel prossimo periodo.',
    'filename' => 'Nome del file',
    'exported_to_file' => 'Esportato nel file',
    'operation_progress' => 'Operazione in corso',
    'exporting_items' => 'Esportazione elementi',
    'select_folders_to_export' => 'Seleziona le cartelle da esportare',
    'export_format_type' => 'Seleziona il tipo di formato di esportazione',
    'export_items' => 'Esporta elementi',
    'loading_item' => 'Caricamento elemento',
    'otv_message' => 'Puoi condividere questo elemento con qualcuno senza un account Teampass. Visualizzazione Una Tantum consente al tuo ospite di accedere ai campi di base di questo elemento solo una volta senza essere autenticato in Teampass. Tieni presente che questo collegamento è valido per un periodo di ##otv_expiration_period## giorni. Copia e condividi il link sottostante.',
    'no_sharekey_found' => 'Nessuna chiave trovata per questo file e il tuo account',
    'otv_link' => 'Link di visualizzazione una tantum',
    'one_time_view' => 'Visualizzazione una tantum',
    'move_right_columns_separator' => 'Sposta il separatore di colonne a destra',
    'move_left_columns_separator' => 'Sposta il separatore di colonne a sinistra',
    'form_presents_inconsistencies' => 'Il form presenta alcune incongruenze. Si prega di controllare i campi con i bordi rossi.',
    'download' => 'Scarica',
    'see' => 'Vedere',
    'at_anyoneconmodify' => 'Chiunque può modificare',
    'disabled' => 'Disabilitato',
    'enabled' => 'Abilitato',
    'confirmation_seems_wrong' => 'La conferma sembra errata, correggere',
    'i_cannot_remember' => 'Non posso ricordare',
    'i_cannot_remember_info' => 'Questa azione è senza rollback. Cancellerà le password memorizzate all’interno dei tuoi oggetti personali. Gli elementi non verranno eliminati ma solo le loro password. Se non riesci a ricordare il tuo chiave SALT personale, allora è l’unica opzione.',
    'user_has_psk_info' => 'Abbiamo scoperto che hai alcuni oggetti personali codificati con una vecchia chiave SALT personale. Lo scopo di questo passaggio consiste nel crittografarli nuovamente con la tua nuova chiave privata. Forniscici la tua chiave SALT personale.',
    'files' => 'File',
    'logs' => 'Registri',
    'suggestions' => 'Suggerimenti',
    'encryption_keys' => 'Chiavi di crittografia',
    'clearing_old_sharekeys' => 'Cancellazione di vecchie chiavi condivise',
    'hit_launch_to_start' => 'Fai clic sul pulsante Avvia per iniziare',
    'password_changed' => 'Password aggiornata',
    'password_already_used' => 'Password già utilizzata',
    'change_login_password' => 'Cambia password di accesso',
    'current_password_mandatory' => 'La password attuale è obbligatoria',
    'objects_encryption_explanation' => 'Teampass è stato aggiornato a una nuova versione che include un nuovo protocollo di crittografia. Si aspetta da te di crittografare nuovamente i tuoi oggetti personali. Per questo, è necessario fornire la tua attuale Personal Salt Key (PSK). Una volta terminato, fai clic sul pulsante Avvia e attendi che il processo raggiunga il passaggio finale. Questa operazione potrebbe richiedere diversi minuti a seconda del numero di oggetti.',
    'description_has_changed' => 'La descrizione è cambiata',
    'number_of_folders_imported' => 'Numero di cartelle importate',
    'number_of_items_imported' => 'Numero di elementi importati',
    'propagate' => 'Propagare',
    'propagate_user_rights' => 'Propaga diritti utente',
    'register_new_yubiko_key' => 'Registra una nuova chiave Yubiko',
    'part_of_groups' => 'Parte di gruppi',
    'previous_value' => 'Valore precedente',
    'no_previous_value' => 'Nessun valore precedente',
    'no_data_selected' => 'Nessun dato selezionato',
    'selected_items_to_be_imported' => 'Elementi selezionati da importare',
    'cannot_open_file' => 'Impossibile aprire il file',
    'no_item_found' => 'Nessun elemento trovato',
    'reading_file' => 'Lettura file',
    'where_shall_items_be_created' => 'Dove devono essere creati gli elementi',
    'target_folder' => 'Cartella di destinazione',
    'select_file' => 'Seleziona il file',
    'data_type_for_import' => 'Inizia selezionando il tipo di origine dei dati da importare',
    'get_tips_about_importation' => 'Ottieni suggerimenti sull’importazione',
    'import_new_items' => 'Importa nuovi elementi',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'per',
    'request_access' => 'Richiedi accesso all’Elemento',
    'request_access_message' => 'Quando si richiede l’accesso a un elemento, viene inviata un’e-mail all’autore. L’autore accetterà o rifiuterà la richiesta aggiungendoti all’elenco delle restrizioni sugli elementi. Conferma per inviare la tua richiesta via e-mail all’autore.',
    'request_access_reason' => 'Fornisci all’autore il motivo della tua richiesta',
    'error_provide_reason' => 'Indica il motivo per cui desideri accedere a questo elemento',
    'need_access' => 'Hai bisogno di accedere?',
    'item_with_restricted_access' => 'Elemento con accesso limitato',
    'remaining_emails_to_send' => 'Email rimanenti da inviare',
    'mfa_flash' => 'Flash con il tuo dispositivo mobile',
    'import' => 'Importa',
    'export' => 'Esporta',
    'offline' => 'Disconnesso',
    'login_attempts_identified_since_last_connection' => 'È richiesta la tua attenzione. È stato identificato almeno un tentativo di accesso con il tuo account dall’ultima connessione riuscita. Controlla e segnala al tuo amministratore locale se non sei l’autore.',
    'last_login_attempts' => 'Ultimi tentativi di accesso',
    'see_detail' => 'Vedi dettaglio',
    'role_definition' => 'Definizione del ruolo',
    'not_yet_implemented' => 'Non ancora implementato',
    '2factors_expected_for_admin' => 'L’amministratore richiede l’autenticazione MFA per accedere',
    '2factors_expected_for_admin_tip' => 'Per impostazione predefinita, un amministratore deve utilizzare un metodo MFA per essere registrato. Se non abilitato, l’amministratore non ne richiederà l’accesso anche se MFA è abilitato per qualsiasi altro utente.',
    'restore_done_now_logout' => 'Il ripristino del database è stato eseguito. Ora devi disconnetterti per aggiornare le variabili di sessione.',
    'backup_and_restore' => 'Backup e Ripristino',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Esegui backup',
    'perform_restore' => 'Esegui ripristino',
    'backup_select' => 'File di backup',
    'choose_file' => 'Scegli il file',
    'on_the_fly' => 'Al volo',
    'scheduled' => 'Programmato',
    'caution_on_field_encryption_change' => 'Attenzione: tenere presente che la modifica del tipo di crittografia richiederà l’analisi di tutti i dati esistenti per modificare la crittografia nel database.',
    'caution_while_deleting_field' => 'Attenzione: l’eliminazione di questo campo eliminerà anche i dati correlati negli elementi.',
    'error_could_not_update_the_field' => 'Errore: non è stato possibile aggiornare il campo. Riprova dopo aver ricaricato la pagina.',
    'caution_while_deleting_category' => 'Attenzione: l’eliminazione di questa cartella eliminerà tutti i suoi campi di appartenenza e anche tutti i dati relativi ai campi.',
    'your_attention_please' => 'La tua attenzione per favore',
    'all_fields_are_required' => 'Tutti i campi sono obbligatori',
    'position' => 'Posizione',
    'before' => 'Prima',
    'top' => 'Superiore',
    'bottom' => 'Inferiore',
    'field' => 'Campo',
    'configuration' => 'Configurazione',
    'definition' => 'Definizione',
    'number_of_modified_attachments' => 'Numero di allegati modificati',
    'files_not_encrypted' => 'I file non sono attualmente crittografati. Dovresti eseguire questa modifica per motivi di sicurezza.',
    'files_already_encrypted' => 'I file sono già crittografati. Non dovresti cambiarlo per motivi di sicurezza.',
    'action_to_be_performed' => 'Azione da eseguire',
    'last_execution' => 'Ultima esecuzione',
    'never_performed' => 'Mai eseguito',
    'launch' => 'Avvia',
    'set_of_actions' => 'Insieme di azioni',
    'uploads' => 'Caricamenti',
    'uploads_configuration' => 'Carica la configurazione',
    'email_configuration' => 'Configurazione e-mail',
    'email_configuration_test' => 'Test configurazione email',
    'send_a_test_email' => 'Invia un’e-mail di prova',
    'manage_emails_not_sent' => 'Gestisci email non inviate',
    'email_send_backlog' => '#nb_emails# email non inviate',
    'send_waiting_emails' => 'Invia email in attesa',
    'ip' => 'IP',
    'no_data_defined' => 'Nessun dato è stato definito',
    'adding_new_api_ip' => 'Aggiunta di un nuovo IP alla whitelist',
    'adding_new_api_key' => 'Aggiunta di una nuova chiave API',
    'api_configuration' => 'Configurazione dell’API',
    'mfa_configuration' => 'Configurazione MFA',
    'yubico_authentication_tip' => 'Si prega di visitare www.yubico.com per maggiori dettagli.',
    'complexity_level_not_reached' => 'Livello di complessità non raggiunto',
    'expected_complexity_level' => 'Livello di complessità previsto',
    'your_attention_is_required' => 'È richiesta la tua attenzione',
    'favorite' => 'Preferito',
    'unfavorite' => 'Non preferito',
    'you_need_to_select_at_least_one_folder' => 'Devi selezionare almeno una cartella',
    'no_value_defined_please_fix' => 'Nessun valore definito! Si prega di correggere.',
    'apply' => 'Applica',
    'from' => 'Da',
    'please_confirm_by_clicking_checkbox' => 'Conferma facendo clic sulla casella di controllo',
    'date_range' => 'Intervallo di date',
    'purge' => 'Rimuovi',
    'belong_of_deleted_folder' => 'Appartiene alla cartella eliminata',
    'highlight_selected' => 'Evidenzia selezionato',
    'number_of_selected_objects' => 'Numero di oggetti selezionati',
    'confirm_selection_restore' => 'Conferma il ripristino degli elementi selezionati.',
    'confirm_selection_delete' => 'Conferma l’eliminazione degli elementi selezionati.',
    'refreshing' => 'Aggiornamento',
    'empty_list' => 'Elenco vuoto',
    'deleted_folders' => 'Cartelle eliminate',
    'deleted_items' => 'Elementi eliminati',
    'recycled_bin' => 'Cestino riciclato',
    'database' => 'Database',
    'renewal' => 'Rinnovo',
    'renewal_delay' => 'Ritardo rinnovo',
    'please_confirm_deletion' => 'Conferma l’eliminazione',
    'caution' => 'Attenzione',
    'role_not_exist' => 'Questo ruolo non esiste!',
    'role_can_edit_any_visible_item' => 'Il ruolo può modificare qualsiasi elemento visibile',
    'role_can_edit_any_visible_item_tip' => 'L’impostazione normale è lasciare deselezionata questa casella di controllo. Infatti, se selezionato, consentirà a un utente che fa parte di questo ruolo di modificare qualsiasi elemento che l’utente può aprire, il che porta a uno stato non protetto. Dovrebbe essere controllato solo per un determinato periodo di tempo e necessità.',
    'edit_allowed' => 'Modifica consentita',
    'delete_allowed' => 'Eliminazione consentita',
    'add_allowed' => 'Aggiungi permesso',
    'edit_not_allowed' => 'Modifica non consentita',
    'delete_not_allowed' => 'Eliminazione non consentita',
    'select_a_role' => 'Seleziona un ruolo',
    'access_rights_for_user' => 'Diritti di accesso per l’utente',
    'logs_for_user' => 'Registro per utente',
    'please_confirm' => 'Conferma',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Facendo clic su questa casella di controllo, si conferma l’eliminazione di questo utente.',
    'fields_with_mandatory_information_are_missing' => 'Mancano campi con informazioni obbligatorie',
    'enable_personal_folder_for_this_user' => 'Abilita la funzione Cartella personale per questo utente',
    'special' => 'Speciale',
    'administrator' => 'Amministratore',
    'super_manager' => 'Gestione Teampass',
    'manager' => 'Gestore',
    'read_only' => 'Sola lettura',
    'privileges' => 'Privilegi',
    'roles' => 'Ruoli',
    'user_definition' => 'Definizione utente',
    'no_selection_done' => 'Nessuna selezione effettuata',
    'tick_confirmation_box' => 'Spunta la casella di controllo per confermare',
    'next_list_to_be_deleted' => 'L’elenco successivo verrà eliminato',
    'delete_folders' => 'Elimina cartelle',
    'submit' => 'Invia',
    'label' => 'Etichetta',
    'parent' => 'Genitore',
    'password_minimal_complexity_target' => 'Obiettivo di complessità minima della password',
    'access_right_for_roles' => 'Diritti di accesso per ruoli',
    'create_without_password_minimal_complexity_target' => 'Consenti la creazione di nuovi elementi senza l’obiettivo di complessità minima della password',
    'edit_without_password_minimal_complexity_target' => 'Consenti l’edizione dell’elemento senza obiettivo di complessità minima della password',
    'add_new_folder' => 'Aggiungi una nuova cartella',
    'new' => 'Nuovo',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Autenticazione a più fattori',
    'google_2fa' => 'Verifica in due passaggi di Google',
    'duo_security' => 'Sicurezza doppia',
    'yubico' => 'Autenticatore Yubico',
    'website_canal' => 'Fai clic per aprire il sito web di Teampass',
    '2fa_credential_not_correct' => 'La credenziale 2FA non è corretta',
    'no_change_performed' => 'Nessuna modifica è stata eseguita.',
    'password_strength' => 'Sicurezza della password',
    'new_password_required' => 'È richiesta una nuova password',
    'limited_search' => 'Ricerca limitata',
    'empty_psk' => 'Manca chiave SALT',
    'currently_no_favorites' => 'Attualmente non hai preferiti',
    'favorites' => 'Preferiti',
    'confirm_item_move' => 'Hai selezionato "Spostamento"... sei sicuro?',
    'copy_to_clipboard' => 'Copia negli appunti',
    'please_wait_while_loading' => 'Attendi il caricamento dei dati',
    'defect_report' => 'Riportare un bug',
    'actions' => 'Azioni',
    'no_user' => 'Utente sbagliato',
    'generate_api_token' => 'Genera nuovo token API',
    'upload_feature' => 'Carica funzione',
    'profile' => 'Profilo',
    'language' => 'Lingua',
    'upload_new_avatar' => 'Seleziona il file dell’immagine del profilo',
    'settings' => 'Impostazioni',
    'created_items' => 'Elementi creati',
    'modification_performed' => 'Modifica eseguita',
    'items_opened' => 'Elementi aperti',
    'passwords_seen' => 'Password viste',
    'nothing_to_save' => 'Niente da salvare',
    'notification_engaged' => 'Stai ricevendo notifiche sulla modifica dell’elemento',
    'notification_not_engaged' => 'Non ricevi notifiche sulla modifica dell’elemento',
    'viewed_number' => 'Numero di Visualizzazioni',
    'automatic_deletion_engaged' => 'Eliminazione automatica',
    'auto_update_enabled' => 'Cambio automatico password utente abilitato. Prossima modifica pianificata',
    'copy_folder' => 'Copia cartella',
    'select_source_folder' => 'Seleziona la cartella da copiare',
    'select_destination_folder' => 'Seleziona la cartella di destinazione',
    'delete_folder' => 'Elimina cartella',
    'select_folder_to_delete' => 'Seleziona la cartella da eliminare',
    'folder_delete_confirm' => 'La cartella selezionata e i suoi elementi verranno eliminati. Seleziona la casella di controllo per confermare l’eliminazione.',
    'json_error_format' => 'Formato JSON errato',
    'password_cannot_be_empty' => 'La password non può essere vuota',
    'password_too_long' => 'La password è troppo lunga',
    'error_no_action_identified' => 'Nessuna azione è stata identificata',
    'ldap' => 'LDAP',
    'emails' => 'E-mail',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Aggiungi nuova cartella',
    'select_folder_parent' => 'Seleziona cartella principale',
    'add' => 'Aggiungi',
    'key_is_not_correct' => 'La chiave di sessione fornita non è corretta',
    'suggestion_information' => 'Puoi suggerire qualsiasi modifica su questo elemento all’autore. Utilizza il modulo sopra per presentare le tue proposte di modifica e fai clic sul pulsante Esegui per informare l’autore.',
    'email_address' => 'Indirizzo e-mail',
    'enter_email' => 'Inserisci l’email',
    'notification' => 'Notifica',
    'notify_on_change' => 'Avvisami sulle modifiche',
    'notification_message' => 'Puoi utilizzare questa impostazione per ricevere o meno una notifica sulle modifiche apportate a questo elemento.',
    'share_item' => 'Condividi elemento',
    'share_item_message' => 'Puoi condividere questo elemento con qualcuno. Fornisci un indirizzo email valido e fai clic sul pulsante Esegui.',
    'delete_item_message' => 'Hai deciso di eliminare questo elemento selezionato. Devi confermare la tua scelta facendo clic sul pulsante Esegui.',
    'warning' => 'Avvertimento',
    'information' => 'Informazione',
    'perform' => 'Esegui',
    'delete_item' => 'Cancella elemento',
    'copy_item' => 'Copia elemento',
    'new_item' => 'Nuovo elemento',
    'error_not_allowed_to_edit_item' => 'Non sei autorizzato a modificare questo elemento',
    'error_not_allowed_to_access_this_folder' => 'Non sei autorizzato ad accedere a questa cartella',
    'error_personal_saltkey_is_not_set' => 'Il tuo chiave SALT personale non è fornito.',
    'provide_your_personal_saltkey' => 'Per favore, fornisci il tuo chiave SALT personale',
    'no_fields' => 'Nessun campo è correlato a questo elemento.',
    'uploaded' => 'Caricato',
    'changes_ongoing' => 'Alcune modifiche non sono state salvate. Confermi di uscire senza salvare?',
    'no_file_to_upload' => 'Nessun file da caricare',
    'add_files_and_click_start' => 'Aggiungi i file alla coda di caricamento e fai clic sul pulsante di avvio.',
    'select_files' => 'Seleziona i file',
    'attached_files' => 'Files allegati',
    'visible_by' => 'Visibile da',
    'anounce_item_by_email' => 'Annuncia questo elemento agli utenti',
    'select_users_if_needed' => 'Seleziona gli utenti se necessario',
    'allow_item_to_be_deleted' => 'Consenti l’eliminazione di questo elemento alla condizione successiva',
    'item_deleted_after_being_viewed_x_times' => 'L’elemento verrà eliminato dopo essere stato visualizzato X volte',
    'item_deleted_after_date' => 'L’elemento verrà eliminato dopo la data definita',
    'password' => 'Password',
    'save' => 'Salva',
    'folder' => 'Cartella',
    'main' => 'Principale',
    'fields' => 'Campi',
    'details' => 'Dettagli',
    'no_special_restriction' => 'Nessuna restrizione speciale',
    'generate_otv_link' => 'Genera collegamento di visualizzazione una tantum',
    'no_custom_fields' => 'Nessun campo personalizzato',
    'no_attachment' => 'Nessun allegato',
    'logout_confirm' => 'Disconnettersi? Si prega di confermare.',
    'saved' => 'Salvato',
    'attachments' => 'Allegati',
    'success' => 'Successo',
    'server_answer_error' => 'Viene visualizzato un errore. La risposta dal server non può essere analizzata!',
    'server_returned_data' => 'Dati restituiti',
    'version_alone' => 'versione',
    'statistics' => 'Statistiche',
    'options' => 'Opzioni',
    'users' => 'Utenti',
    'folders' => 'cartella',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% oggetti trovati',
    'auto_update_server_password_info' => 'Fare clic su Start eseguirà automaticamente questi passaggi:<ul><li>Connettiti tramite SSH al server utilizzando le credenziali di accesso e il campo `URL`,</li><li>Cambia la password utente sul server</il><li>Salva il nuova password in Teampass</il><li>Chiudi connessione SSH</li></ul><br><b>Assicurati che l’utente disponga dei diritti per accedere e modificare la password sul server (in caso contrario, indicare il login e password root) prima di iniziare.</b>',
    'share' => 'Condividi elemento',
    'notify' => 'Notifica',
    'error_no_selected_folder' => 'Devi selezionare una cartella',
    'email_subject_item_updated' => 'Password aggiornata',
    'email_body_item_updated' => 'La password per ’#item_label#’ è stata aggiornata.<br><br>Puoi controllarla cliccando <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">QUI</a>.<br><br>',
    'import_kp_finished' => 'L’importazione da KeePass è completata.<br>Il livello di complessità per le nuove cartelle è stato impostato di default a Medio.',
    'password_is_empty' => 'L’elemento non ha password',
    'bug_report_to_github' => 'Completa il contenuto del rapporto, quindi copialo negli appunti e incollalo nella pagina del nuovo problema di Github',
    'open_bug_report_in_github' => 'Apri rapporto problema in Github',
    'bugs_page' => 'Se scopri un bug, segnalalo.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Imposta il permesso "chiunque nello stesso ruolo può modificare" su tutti gli elementi importati.',
    'import_csv_anyone_can_modify_txt' => 'Imposta il permesso "chiunque può modificare" su tutti gli elementi importati.',
    'settings_upload_imageresize_options' => 'Le immagini vanno ridimensionate',
    'user_not_exists' => 'Questo utente non esiste!',
    'auto_create_folder_role' => 'Crea cartella e ruolo per ',
    'start_upload' => 'Inizia caricamento dei file',
    'error_upload_runtime_not_found' => 'Funzione di caricamento: nessun runtime trovato.',
    'user_profile_api_key' => 'La tua chiave API',
    'index_change_pw' => 'Modifica la tua password',
    'admin_2factors_authentication_setting' => 'Abilita la verifica in due passaggi di Google',
    'admin_2factors_authentication_setting_tip' => '<span style="font-size:11px;max-width:300px;">La verifica in 2 passaggi di Google permette di aggiungere all’autenticazione dell’utente un ulteriore livello di sicurezza. Quando l’utente vuole entrare in TeamPass, viene generato un QR code. Tale codice deve essere scandito dall’utente per ottenere una password monouso.<br>ATTENZIONE: Questa funzione richiede una connessione ad internet e una periferica capace di effettuare scansioni come, per esempio, uno smartphone.</span>',
    'admin_ga_website_name' => 'Nome mostrato su Google Authenticator per Teampass',
    'admin_ga_website_name_tip' => 'Questo nominativo è utilizzato per identificare l’account con Google Authenticato',
    'api_whitelist_ips' => 'Lista bianca IP API',
    'api_whitelist_ips_tip' => 'Se nessun indirizzo IP del client API è esplicitamente elencato qui, qualsiasi indirizzo IP è autorizzato.',
    'email_share_item_subject' => '[TeamPass] Un elemento è stato condiviso con te',
    'email_share_item_mail' => 'Salve,<br><br><u>#tp_user#</u> ha condiviso con te l’elemento <b>#tp_item#</b><br>Clicca <a href="#tp_link#">qui</a> per accedere.<br><br>Cordiali Saluti.',
    'index_maintenance_mode_admin' => 'La modalità Manutenzione è stata attivata. Gli utenti non possono accedere a TeamPass.',
    '2fa_authentication_selector' => 'Seleziona un metodo di autenticazione a 2 fattori',
    'upload_empty_file' => 'Carica file vuoto',
    'upload_any_extension_file' => 'Carica qualsiasi file di estensione',
    'upload_any_extension_file_tip' => 'Se abilitata, questa opzione consentirà agli utenti di caricare qualsiasi tipo di file.',
    'log_in' => 'Accesso',
    'create_item_based_upon_template' => 'Utilizzo del modello per l’elemento',
    'create_item_based_upon_template_tip' => 'Se abilitata, questa funzione consente all’autore di selezionare un modello composto da campi personalizzati. Tieni presente che questa funzione richiede che siano abilitati anche i campi personalizzati.',
    'main_template' => 'Utilizza come modello',
    'is_mandatory' => 'È obbligatorio',
    'error_field_is_mandatory' => 'Almeno un campo obbligatorio è vuoto',
    'restrict_visibility_to' => 'Limita visibilità a',
    'every_roles' => 'Tutti i ruoli',
    'masked_text' => 'Testo mascherato',
    'textarea' => 'Area di testo',
    'admin_yubico_authentication_setting' => 'Abilita autenticazione Yubico',
    'yubico_user_id' => 'Identificativo cliente',
    'yubico_user_key' => 'Chiave segreta',
    'yubico_bad_code' => 'Informazioni Yubico errate',
    'press_your_yubico_key' => 'Premi il tasto Yubico',
    'human_resources' => 'Supermanager',
    'settings_secure_display_image' => 'Abilita la visualizzazione sicura delle immagini',
    'settings_secure_display_image_tip' => 'La visualizzazione sicura dell’immagine consente di leggere l’immagine tramite PHP quando un utente visualizza in anteprima un’immagine allegata a un elemento. Pro: l’allegato è archiviato all’esterno della cartella del sito e non è accessibile da un hacker. Contro: è leggermente più lento dell’anteprima direttamente da un URL.',
    'user_ga_code' => 'Invia all’utente per mail il link GoogleAuthenticator',
    'error_no_email' => 'Questo utente non ha un indirizzo email!',
    'error_no_user' => 'Nessun utente trovato!',
    'email_ga_subject' => 'Il tuo codice flash per Teampass con Google Authenticator',
    'email_ga_text' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>Il tuo amministratore si aspetta che tu utilizzi l’autenticazione TwoFactor per connetterti a Teampass.<br>Per la tua prima connessione a Teampass con TwoFactor, utilizza il codice che trovi di seguito nel campo Codice identificativo":<br><br>----------------------<br># 2FACode#<br>----------------------<br><br>Avrai quindi l’opportunità di impostare le tue credenziali monouso per la password Teampass manager.<br><br>Saluti',
    'settings_attachments_encryption' => 'Abilita codifica (crittografia) degli elementi allegati',
    'settings_attachments_encryption_tip' => 'Se abilitato, gli allegati degli elementi vengono crittografati sul server con la chiave SALT di sistema. La crittografia richiede più risorse del server. -- Avvertimento! -- La modifica di questa opzione potrebbe interrompere gli allegati di file esistenti! Dopo aver modificato questa impostazione, è necessario eseguire l’attività per crittografare o decrittografare i file allegati esistenti.',
    'admin_action_attachments_cryption' => 'Codica (cifra) o Decodifica (decifra) gli elementi allegati',
    'admin_action_attachments_cryption_tip' => 'Avviso: crittografare o decrittografare i file solo dopo aver modificato le impostazioni di crittografia degli allegati in modo che corrispondano. Seleziona se crittografare o decrittografare, quindi premi start. Effettua un backup della cartella di caricamento prima di eseguire questa funzione.',
    'encrypt' => 'Codifica',
    'decrypt' => 'Decodifica',
    'ga_identification_code' => 'codice identificativo',
    'ga_enter_credentials' => 'Devi inserire le tue credenziali di login',
    'ga_bad_code' => 'Il codice di Google Authenticator è errato',
    'settings_get_tp_info' => 'Mostra notizie e informazioni sul software agli amministratori',
    'settings_get_tp_info_tip' => 'Questa opzione permette nella pagina di amministrazione di caricare informazioni come versione e librerie utilizzate dal server Teampass.',
    'settings_offline_mode' => 'Attiva modalità offline',
    'settings_offline_mode_tip' => 'La modalità offline crea una pagina Web HTML autonoma che può essere scaricata su un computer. Gli elementi nella pagina offline vengono crittografati con una password specificata dall’utente al momento della creazione.',
    'offline_mode_key_level' => 'Livello minimo per la chiave di cifratura off-line',
    'categories' => 'Categorie',
    'no_category_defined' => 'Nessuna categoria è stata ancora definita',
    'confirm_deletion' => 'Stai per rimuovere, vuoi continuare?',
    'settings_item_extra_fields' => 'Campi elemento personalizzati abilitati',
    'settings_item_extra_fields_tip' => 'Abilita un’altra scheda durante la creazione di elementi password, che contiene campi personalizzati per altri tipi di dati. Un amministratore deve prima creare le categorie e le etichette dei campi personalizzati da visualizzare in tali categorie. Questa funzione consuma più risorse del server.',
    'settings_ldap_type' => 'Tipo di server LDAP',
    'server_time' => 'Ora sul server',
    'settings_tree_counters' => 'Mostra i contatori nell’albero delle cartelle',
    'settings_tree_counters_tip' => 'L’abilitazione mostra tre numeri accanto a ciascuna cartella: numero di elementi nella cartella di base; numero di elementi comprese le sottocartelle; numero di sottocartelle. L’abilitazione di questa funzione potrebbe rallentare il caricamento del riquadro dell’albero delle cartelle.',
    'admin_action_check_pf' => 'Associa una cartella personale ad ogni utente (viene creata se non esiste)',
    'enable_personal_folder_feature_tip' => 'Le cartelle personali sono una posizione privata per le password dei singoli utenti. Gli elementi della password sono crittografati dalla chiave SALT di un utente (più sicura) o dalla sua password (più semplice). L’abilitazione di questa funzione non crea le cartelle effettive per gli utenti esistenti: devi anche eseguire l’attività di creazione delle cartelle personali.',
    'administrators_only' => 'Solo amministratori',
    'managers_of' => 'Gestori del ruolo',
    'managed_by' => 'Gestito da',
    'settings_enable_sts' => 'Attiva HTTPS Strict Transport Security --ATTENZIONE: leggi attentamente il ToolTip.',
    'settings_enable_sts_tip' => 'Questa opzione abilita HTTPS STS. STS aiuta a prevenire gli attacchi SSL Man-in-the-middle, ma DEVI avere un certificato SSL valido per usare questa opzione. Se abiliti questa opzione e il tuo certificato è autofirmato TeamPass si romperà!!! Inoltre nella configurazione di SSL per Apache devi aver inserito ’SSLOptions +ExportCertData’.',
    'settings_anyone_can_modify_bydefault' => 'Abilita l’opzione ’<b><i>Modificabile da tutti</b></i>’ come scelta predefinita',
    'to' => 'a',
    'settings_upload_maxfilesize_tip' => 'Dimensione massima dei file. Dovrebbe essere coerente con le indicazioni del server.',
    'settings_upload_docext_tip' => 'Tipi di documento. Elenca le estensioni dei file ammesse separate da virgole (,)',
    'settings_upload_imagesext_tip' => 'Tipi di immagine. Elenca le estensioni dei file ammesse separate da virgole (,)',
    'settings_upload_pkgext_tip' => 'Tipi di archivio. Elenca le estensioni dei file ammesse separate da virgole (,)',
    'settings_upload_otherext_tip' => 'Altri tipi di file. Elenca le estensioni dei file ammesse separate da virgole (,)',
    'settings_upload_imageresize_options_tip' => 'Questa opzione, se attivata, ridimensiona le immagini secondo il formato indicato più sotto.',
    'settings_upload_maxfilesize' => 'Dimensione massima (in Mb)',
    'settings_upload_docext' => 'Estensioni ammesse per i documenti',
    'settings_upload_imagesext' => 'Estensioni ammesse per le immagini',
    'settings_upload_pkgext' => 'Estensioni ammesse per gli archivi',
    'settings_upload_otherext' => 'Estensioni ammesse per altri file',
    'settings_upload_imageresize_options_w' => 'Larghezza immagini ridimensionate (in pixel)',
    'settings_upload_imageresize_options_h' => 'Altezza immagini ridimensionate (in pixel)',
    'settings_upload_imageresize_options_q' => 'Qualità immagini ridimensionate',
    'settings_importing' => 'Abilita l’importazione di dati da file CVS/KeyPass',
    'admin_proxy_ip' => 'IP Proxy in uso',
    'admin_proxy_ip_tip' => '<span style="font-size:11px;max-width:300px;">Se la tua connessione a internet utilizza un proxy, indica qui il tuo IP.<br>Lascia il campo vuoto se non usi proxy.</span>',
    'admin_proxy_port' => 'Porta Proxy in uso',
    'admin_proxy_port_tip' => '<span style="font-size:11px;max-width:300px;">Se hai impostato un IP per il proxy, indica la Porta. Potrebbe essere 8080.<br>Lascia il campo vuoto se non usi proxy.</span>',
    'settings_ldap_elusers' => 'Solo utenti locali di Teampass',
    'settings_ldap_elusers_tip' => 'Questa opzione permette agli utenti di collegarsi utilizzando un account LDAP. Se desideri navigare nelle directory LDAP dovrai disabilitare questa opzione.',
    'db_items_edited' => 'Elementi attualmente in fase di modifica',
    'item_edition_start_hour' => 'Tempo di modifica',
    'settings_delay_for_item_edition' => 'Quantità di tempo dopo la quale la modifica di un elemento è considerata fallita (in minuti)',
    'settings_delay_for_item_edition_tip' => '<span style="font-size:11px;max-width:300px;">Gli elementi vengono bloccati durante la modifica, per evitare che avvengano errori dovuti alla modifica contemporanea da parte di più utenti. Per ottenere questa funzionalità viene utilizzato una sorta di segnaposto.<br> Questa impostazione consente di definire la cancellazione del segnaposto. Nel caso il valore venga impostato su 0 il segnaposto non verrà mai cancellato (tranne che da un Admin)</span>',
    'db_users_logged' => 'Utenti con sessioni attive',
    'action' => 'Azione',
    'login_time' => 'Durata della sessione',
    'lastname' => 'Cognome',
    'user_login' => 'Login',
    'role' => 'Rolo',
    'error_role_exist' => 'Questo ruolo esiste già.',
    'error_no_edition_possible_locked' => 'Impossibile modificare. L’elemento è già in fase di modifica.',
    'select' => 'Seleziona',
    'items' => 'Elementi',
    'enable_personal_saltkey_cookie' => 'Abilita la memorizzazione della chiave SALT nei cookie',
    'personal_saltkey_cookie_duration' => 'Giorni rimanenti prima della scadenza del cookie chiave SALT personale',
    'admin_email_smtp_server' => 'Server SMTP',
    'admin_email_auth' => 'Il server SMTP richiede l’autenticazione',
    'admin_email_auth_username' => 'Nome utente per l’autenticazione',
    'admin_email_auth_pwd' => 'Password di autenticazione',
    'admin_email_port' => 'Porta sul server',
    'admin_email_from' => 'Mittente (indirizzo email)',
    'admin_email_from_name' => 'Mittente (nome)',
    'admin_email_test_configuration_tip' => 'Invia un’e-mail di prova all’utente che ha effettuato l’accesso. Devi prima impostare il tuo indirizzo email facendo clic sull’icona del profilo utente.',
    'admin_email_test_subject' => '[TeamPass] Email di prova',
    'admin_email_test_body' => 'Bene,<br><br> l’email è stata inviata con successo.<br><br>',
    'admin_email_result_ok' => 'Email inviata a #email# ... controlla nella posta in arrivo.',
    'email_bodyalt_item_updated' => 'La password per #item_label# è stata aggiornata.',
    'admin_email_send_backlog_tip' => 'Questo script forza l’invio delle password ancora non inviate presenti nel database.<br>Ciò potrebbe richiedere diverso tempo, in base a quante email ci sono nel backlog.',
    'please_wait' => 'Attendere prego...',
    'admin_path_to_files_folder' => 'Percorso della cartella Files',
    'admin_path_to_files_folder_tip' => '<span style="font-size:11px;max-width:300px;">La cartella Files viene utilizzata per contenere tutti i file generati da TeamPass e alcuni file caricati.<br>NOTA BENE : Per ragioni di sicurezza questa cartella non deve essere contenuta nella cartella WWW del tuo sito. Dovrebbe essere posizionata in un’area protetta da apposite regole impostate sul server.<br>NOTA BENE 2: Potrebbe essere una buona idea dedicare un CRON job alla ripulitura periodica di tale cartella.</span>',
    'admin_path_to_upload_folder_tip' => '<span style="font-size:11px;max-width:300px;">La cartella Upload viene usata per archiviare tutti i file associati agli elementi e caricati sul sistema.<br>NOTA BENE: Per ragioni di sicurezza questa cartella non deve essere contenuta nella cartella WWW del tuo sito. Dovrebbe essere posizionata in un’area protetta da apposite regole impostate sul server</span>',
    'pdf_password_warning' => 'Devi fornire una chiave crittografica',
    'admin_pwd_maximum_length' => 'Lunghezza massima delle password',
    'admin_pwd_maximum_length_tip' => 'Il valore predefinito per la lunghezza delle password è 40. È importante notare che un valore molto alto avrà un impatto negativo sulle prestazioni del sistema. Più tale valore è alto, più tempo impiegherà il server a crittare, decrittare e visualizzare le password.',
    'settings_insert_manual_entry_item_history' => 'Permetti aggiunti manuali nel History log degli elementi',
    'settings_insert_manual_entry_item_history_tip' => 'Normalmente vorresti lasciar perdere. Se abilitata, la cronologia di un elemento password può essere modificata o alterata.',
    'admin_path_to_upload_folder' => 'Percorso cartella di upload',
    'admin_setting_enable_delete_after_consultation' => 'L’elemento consultato può essere rimosso automaticamente',
    'admin_setting_enable_delete_after_consultation_tip' => '<span style="font-size:11px;max-width:300px;">Se abilitato, il creatore dell’elemento può decidere che questo venga automaticamente rimosso dopo essere stato visualizzato X volte.</ span>',
    'at_email' => 'e-mail',
    'enable_email_notification_on_item_shown' => 'Invia notifica via email quando l’elemento viene visualizzato',
    'share_sent_ok' => 'L’email è stata inviata',
    'see_item_title' => 'Dettaglio elemento',
    'email_on_open_notification_subject' => '[TeamPass] Notifica di visualizzazione elemento',
    'email_on_open_notification_mail' => 'Salve,<br><br>#tp_user# ha visualizzato l’elemento ’#tp_item#’.<br>Clicca <a href="#tp_link#">qui</a> per accedere.<br><br>Cordiali Saluti.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Il tuo nuovo account',
    'email_new_user_mail' => 'Salve,<br><br>Un amministratore ha creato il tuo account per TeamPass.<br>Puoi usare le seguenti indicazioni per fare il login:<br>- Login: #tp_login#<br>- Password: #tp_pw#<br><br>Clicca <a href="#tp_link#">QUI</a> per accedere.<br><br>Cordiali Saluti.',
    'error_empty_data' => 'Nessun dato per procedere.',
    'error_not_allowed_to' => 'Non sei autorizzato.',
    'request_access_ot_item' => 'Richiedi accesso all’elemento',
    'email_request_access_subject' => '[TeamPass] Richiesta di accesso ad un elemento',
    'email_request_access_mail' => 'Salve #tp_item_author#,<br><br>l’utente #tp_user# ha richiesto di accedere a ’#tp_item#’.<br><br>Fai attenzione ai permessi di questo utente prima di modificare le restrizioni sull’elemento.<br><br>Cordiali Saluti.',
    'admin_action_change_salt_key' => 'Modifica la chiave SALT primaria',
    'nb_items_by_query' => 'Numero di elementi ottenuti ad ogni iterazione',
    'nb_items_by_query_tip' => '<span style="font-size:11px;max-width:300px;">Più elementi significa più tempo per visualizzare la lista.<br>Imposta ad ’auto’ per consentire a TeamPass di adattare questo numero allo schermo utilizzato dall’utente.<br>Imposta a ’max’ per forzare la visualizzazione della lista in una volta.<br>Imposta un numero per ottenere una lista con quel numero di elementi ad ogni iterazione.</span>',
    'open_url_link' => 'Apri in una nuova pagina',
    'error_pw_too_long' => 'La password è troppo lunga. Il numero massimo di caratteri è 40.',
    'at_restriction' => 'Restrizioni',
    'pw_encryption_error' => 'Errore nel criptaggio della password.',
    'enable_send_email_on_user_login' => 'Invia una email agli amministratori ad ogni login utente',
    'email_subject_on_user_login' => '[TeamPass] Un utente si è connesso',
    'email_body_on_user_login' => 'Salve,<br><br>l’utente #tp_user# si è connesso a TeamPass il giorno #tp_date# alle #tp_time#.<br><br>Cordiali Saluti.',
    'account_is_locked' => 'Questo account è bloccato',
    'activity' => 'Attività',
    'add_role_tip' => 'Aggiungi un ruolo',
    'admin' => 'Amministrazione',
    'admin_action_db_backup' => 'Crea un backup del database',
    'admin_action_db_clean_items' => 'Rimuovi elementi orfani dal database',
    'admin_action_db_clean_items_tip' => 'Questo rimuoverà gli elementi e i log associati che non sono stati rimossi alla rimozione della cartella associata. Si consiglia di creare un backup prima di procedere.',
    'admin_action_db_optimize' => 'Ottimizza il database',
    'admin_action_db_restore' => 'Ripristina il database',
    'admin_action_purge_old_files' => 'Rimuovi vecchi file',
    'admin_action_purge_old_files_tip' => 'Questo rimuoverà tutti i file temporanei più vecchi di 7 giorni.',
    'admin_action_reload_cache_table' => 'Ricarica la tabella Cache',
    'admin_action_reload_cache_table_tip' => 'Questo permette di ricaricare il contenuto della tabella Cache. Può essere utile farlo qualche volta.',
    'admin_help' => 'Aiuto',
    'admin_ldap_configuration' => 'Configurazione LDAP',
    'admin_main' => 'Informazioni',
    'admin_misc_cpassman_dir' => 'Percorso completo di TeamPass',
    'admin_misc_cpassman_url' => 'URL completo di TeamPass',
    'admin_misc_custom_login_text' => 'Testo di login personalizzato',
    'admin_misc_custom_logo' => 'URL completo del logo di login personalizzato',
    'admin_misc_favicon' => 'URL completo al file favicon',
    'admin_settings' => 'Impostazioni',
    'admin_settings_title' => 'Impostazioni TeamPass',
    'admin_setting_activate_expiration' => 'Abilita scadenza password',
    'admin_setting_activate_expiration_tip' => 'Quando abilitato, gli elementi con password scadute non verranno mostrati agli utenti.',
    'admin_views' => 'Viste',
    'alert_message_done' => 'Fatto.',
    'all' => 'tutti',
    'anyone_can_modify' => 'Consente la modifica di questo elemento a chiunque può accedervi',
    'at' => 'a',
    'at_category' => 'cartella',
    'at_copy' => 'Copia eseguita',
    'at_delete' => 'Rimozione',
    'at_description' => 'Descrizione',
    'at_label' => 'Etichetta',
    'at_login' => 'Login',
    'at_moved' => 'Spostato',
    'at_personnel' => 'Personale',
    'at_restored' => 'Ripristinato',
    'at_shown' => 'Visualizzato',
    'at_url' => 'URL',
    'author' => 'Autore',
    'authorized_groups' => 'Cartelle consentite',
    'auth_creation_without_complexity' => 'Consenti la creazione di elementi senza rispettare la complessità richiesta per la password',
    'auth_modification_without_complexity' => 'Consenti la modifica di elementi senza rispettare la complessità richiesta per la password',
    'cancel' => 'Annulla',
    'can_create_root_folder' => 'Può creare cartelle a livello radice',
    'changelog' => 'Ultime novità',
    'close' => 'Chiudi',
    'complexity' => 'Complessità',
    'complex_asked' => 'Complessità richiesta',
    'complex_level0' => 'Molto debole',
    'complex_level1' => 'Debole',
    'complex_level2' => 'Media',
    'complex_level3' => 'Forte',
    'complex_level4' => 'Molto forte',
    'complex_level5' => 'Pesante',
    'complex_level6' => 'Molto pesante',
    'confirm' => 'Conferma',
    'confirm_del_from_fav' => 'Per favore conferma la rimozione dai Preferiti',
    'connections' => 'connessioni',
    'copy' => 'Copia',
    'copy_to_clipboard_small_icons' => 'Abilita la copia negli appunti delle icone nella pagina degli elementi',
    'copy_to_clipboard_small_icons_tip' => '<span style="font-size:11px;max-width:300px;">Questo può prevenire un uso di memoria elevato se gli utenti hanno computer poco recenti.<br> Tuttavia, gli appunti non vengono popolati con le informazioni degli elementi, quindi non è più possibile rilevare le credenziali.</span>',
    'date' => 'Data',
    'date_format' => 'Formato data',
    'delete' => 'Rimuovi',
    'deletion' => 'Rimozioni',
    'del_button' => 'Rimuovi',
    'description' => 'Descrizione',
    'disconnect' => 'Disconnessione',
    'done' => 'Fatto',
    'duplicate_folder' => 'Consenti di avere più cartelle con lo stesso nome.',
    'duplicate_item' => 'Consenti di avere più elementi con lo stesso nome.',
    'email' => 'E-mail',
    'email_subject' => 'Creazione di un nuovo elemento nel Password Manager',
    'enable_favourites' => 'Abilita i Preferiti per gli utenti',
    'enable_personal_folder' => 'Abilita la cartella personale',
    'enable_personal_folder_feature' => 'Abilita la funzione cartella personale',
    'enable_user_can_create_folders' => 'Gli utenti sono abilitati a gestire le cartelle nelle cartelle genitore consentite',
    'encrypt_key' => 'Chiave di criptaggio',
    'errors' => 'Errori',
    'error_group_exist' => 'La cartella è già esistente.',
    'error_html_codes' => 'Il testo contiene codici HTML, questo non è consentito.',
    'error_item_exists' => 'L’elemento è già esistente.',
    'error_label' => 'L’etichetta è obbligatoria.',
    'error_must_enter_all_fields' => 'Devi riempire tutti i campi.',
    'error_pw' => 'La password è obbligatoria.',
    'error_tags' => 'La punteggiatura non è consetita nei TAGS, solo spazi.',
    'error_user_exists' => 'L’utente è già esistente',
    'expiration_date' => 'Data scadenza',
    'find' => 'Trova',
    'forbidden_groups' => 'Cartelle proibite',
    'forgot_my_pw_email_sent' => 'Una email è stata inviata',
    'functions' => 'Funzioni',
    'gestionnaire' => 'Gestore',
    'god' => 'DIO',
    'group' => 'Cartella',
    'group_parent' => 'Cartella genitore',
    'group_pw_duration' => 'Durata password',
    'group_pw_duration_tip' => 'In mesi. Usa 0 per disabilitare.',
    'history' => 'Storico',
    'home_personal_saltkey' => 'La tua chiave SALT personale',
    'home_personal_saltkey_label' => 'Inserisci la tua chiave SALT',
    'import_error_no_read_possible' => 'Impossibile leggere il file.',
    'import_error_no_read_possible_kp' => 'Impossibile leggere il file, deve essere un file KeePass.',
    'import_keepass_to_folder' => 'Seleziona la cartella di destinazione',
    'index_add_one_hour' => 'Estendi la sessione di 1 ora',
    'index_change_pw_confirmation' => 'Conferma',
    'index_expiration_in' => 'La sessione scade tra',
    'index_get_identified' => 'Acdi',
    'index_last_pw_change' => 'Password modificata il giorno',
    'index_last_seen' => 'Ultima connessione, il giorno',
    'index_login' => 'Account',
    'index_new_pw' => 'Nuova password',
    'index_password' => 'Password',
    'index_pw_error_identical' => 'Le password devono essere identiche.',
    'index_pw_level_txt' => 'Complessità',
    'index_session_duration' => 'Durata sessione',
    'info' => 'Informazioni',
    'item_menu_copy_login' => 'Copia login',
    'item_menu_copy_pw' => 'Copia password',
    'item_menu_del_from_fav' => 'Rimuovi dai Preferiti',
    'kbs' => 'KBs',
    'kb_menu' => 'Knowledge Base',
    'last_items_title' => 'Ultimi elementi visti',
    'ldap_extension_not_loaded' => 'L’estensione LDAP non è attiva sul server.',
    'level' => 'Livello',
    'login' => 'Login',
    'mask_pw' => 'Mostra/nascondi password',
    'max_last_items' => 'Numero massimo di elementi visti di recente dall’utente (default è 10)',
    'minutes' => 'minuti',
    'name' => 'Nome',
    'nb_false_login_attempts' => 'Numero di tentativi falliti di login prima che l’account sia disabilitato (0 per disabilitare)',
    'nb_folders' => 'Numero di cartelle',
    'nb_items' => 'Numero di elementi',
    'new_label' => 'Nuova etichetta',
    'no' => 'No',
    'none' => 'Nessuno',
    'none_selected_text' => 'Nessuno selezionato',
    'not_allowed_to_see_pw' => 'Non sei autorizzato a visualizzare questo elemento.',
    'not_allowed_to_see_pw_is_expired' => 'Questo elemento è scaduto.',
    'not_defined' => 'Non definito',
    'number_of_used_pw' => 'Numero di password che un utente deve inserire prima di poter riutilizzare una vecchia password.',
    'pages' => 'Pagine',
    'pdf_download' => 'Scarica file',
    'personal_salt_key' => 'La tua chiave SAL personale',
    'pw' => 'Parola d’ordine',
    'pw_generate' => 'Genera',
    'pw_is_expired_-_update_it' => 'Questo elemento è scaduto, devi modificare la password.',
    'pw_life_duration' => 'Durata della password utente (in giorni, 0 per disabilitare)',
    'readme_open' => 'Apri il file LEGGIMI',
    'read_only_account' => 'Sola lettura',
    'restore' => 'Ripristina',
    'restricted_to' => 'Riservato a',
    'restricted_to_roles' => 'Consenti di riservare elementi a utenti e ruoli',
    'root' => 'Radice',
    'secure' => 'Sicuro',
    'see_logs' => 'Visualizza registro',
    'settings_anyone_can_modify' => 'Attiva un’opzione per ciascun elemento che consente a chiunque di modificarlo',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">Se attivato, verrà aggiunto un checkbox nella configurazione dell’elemento che consente al creatore di abilitare la modifica da parte di tutti.</span>',
    'settings_default_language' => 'Definisci la lingua di default',
    'settings_kb' => 'Abilita Knowledge Base (beta)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">Se attivo, verrà aggiunta una pagina dove puoi costruire la knowledge base.</span>',
    'settings_ldap_domain' => 'Suffisso LDAP per gli account del dominio',
    'settings_ldap_domain_controler' => 'Elenco di DC LDAP',
    'settings_ldap_domain_controler_tip' => '<span style="font-size:11px;max-width:300px;">Specifica più DC se vuoi che le query LDAP vengano bilanciate su più server.<br>Devi separare i DC con una virgola ( , ).<br>Per esempio: dominio_1,dominio_2,dominio_3</span>',
    'settings_ldap_domain_dn' => 'LDAP Base DN per il dominio',
    'settings_ldap_mode' => 'Abilita autenticazione utente tramite server LDAP',
    'settings_ldap_mode_tip' => 'Abilitalo solo se hai un server LDAP e vuoi usarlo per autenticare gli utenti di TeamPass.',
    'settings_ldap_ssl' => 'Usa LDAP SSL (LDAPS)',
    'settings_ldap_tls' => 'Usa LDAP TLS',
    'settings_log_accessed' => 'Abilita log degli accessi agli elementi',
    'settings_log_connections' => 'Abilita log di tutte le connessioni utente al database.',
    'settings_maintenance_mode' => 'Imposta TeamPass in modalità Manutenzione',
    'settings_manager_edit' => 'I Manager possono modificare e rimuovere gli elementi che possono visualizzare',
    'settings_printing' => 'Abilita stampa degli elementi nel file PDF',
    'settings_printing_tip' => 'Se attivo, verrà aggiunta un’opzione nella homepage utente che gli consentirà di generare un file PDF con la lista degli elementi a cui ha accesso. Nota che le password non saranno criptate.',
    'settings_restricted_to' => 'Abilita la funzionalità ’Riservato a’ sugli elementi',
    'settings_show_description' => 'Mostra descrizione nella lista degli elementi',
    'size' => 'Dimensioni',
    'tags' => 'Tag',
    'timezone_selection' => 'Selezione fuso orario',
    'time_format' => 'Formato ora',
    'url' => 'URL',
    'user' => 'Utente',
    'users_online' => 'Utenti online',
    'user_alarm_no_function' => 'Questo utente non ha ruoli associati!',
    'yes' => 'Sì',
    'one_time_view_item_url_box' => 'Condivi URL One-Time con una persona di Fiducia<br><br>#URL#<br><br>Ricorda che questo link permette soltanto di mostrare le informazioni fino al giorno #DAY# ',
    'settings_api' => 'Abilita l’accesso agli elementi di Teampass tramite API',
    'settings_api_tip' => 'L’accesso API consente di accedere alle informazioni da una applicazione di terze parti in formato JSON.',
    'settings_api_keys_list' => 'Lista delle chiavi',
    'settings_api_keys_list_tip' => 'Chiavi per accedere all’API. Il software di terze parti deve utilizzare una chiave casuale creata qui per accedere all’interfaccia JSON.',
    'settings_api_key' => 'Chiave',
    'settings_api_add_ip' => 'Aggiungi nuovo IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Le nuove sottocartelle ereditano i diritti dalla cartella padre',
    'subfolder_rights_as_parent_tip' => 'Se abilitata, ogni nuova sottocartella eredita i ruoli e le autorizzazioni della cartella principale. In caso contrario, l’autorizzazione per le cartelle viene assegnata in base al ruolo dell’utente che le crea.',
    'show_only_accessible_folders_tip' => 'Per impostazione predefinita, gli utenti visualizzano l’albero completo delle cartelle degli elementi password, anche se alcune cartelle sono inaccessibili all’utente. Puoi rimuovere le cartelle inaccessibili dalla visualizzazione per semplificare la navigazione.',
    'show_only_accessible_folders' => 'Nascondi cartelle password inaccessibili',
    'comment' => 'Commento',
    'suggestion_menu' => 'Suggerimenti',
    'settings_suggestion' => 'Funzione suggerimento password abilitata',
    'settings_suggestion_tip' => 'La funzione di suggerimento aggiunge un nuovo menu e una nuova pagina, consentendo agli utenti di creare suggerimenti per nuovi elementi di password. Ciò è utile quando solo i gestori possono creare elementi di password.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'Ldap Bind Dn',
    'settings_ldap_bind_passwd' => 'Ldap Bind Password',
    'settings_ldap_search_base' => 'Base di ricerca Ldap',
    'settings_ldap_bind_dn_tip' => 'Inserisci un bind DN che può accedere agli utenti e cercare nell’albero. Un bind DN è una credenziale che autentica il tuo accesso alla directory.',
    'settings_ldap_bind_passwd_tip' => 'Password per il DN bind specificato sopra.',
    'settings_ldap_search_base_tip' => 'Posizione DN radice per le ricerche nell’albero',
    'admin_email_server_url' => 'URL del server per i collegamenti presenti nelle email',
    'enable_email_notification_on_user_pw_change' => 'Invia una email all’utente quando la sua password viene cambiata',
    'settings_otv_expiration_period' => 'I link OTV (Visualizzazione una tantum) scadono dopo XX giorni',
    'write' => 'Scrivere',
    'read' => 'Leggere',
    'no_access' => 'Nessun accesso',
    'right_types_label' => 'Seleziona il tipo di accesso a questa cartella per il gruppo di utenti selezionato',
    'duplicate_item_in_folder' => 'Gli elementi nella stessa cartella potrebbero avere nomi simili',
    'settings_roles_allowed_to_print' => 'Esportazione consentita da questi ruoli (selezione multipla)',
    'settings_roles_allowed_to_print_tip' => 'Seleziona più ruoli tenendo premuto CTRL durante la selezione. I membri di questi ruoli potranno esportare le cartelle in formato CSV o PDF se l’esportazione è abilitata anche a livello globale.',
    'admin_email_security' => 'Tipo di sicurezza SMTP',
    'alert_page_will_reload' => 'La pagina verrà ora ricaricata',
    'file_protection_password' => 'Definisci password file',
    'expand' => 'Espandere',
    'collapse' => 'Riduci',
    'settings_ldap_user_attribute' => 'Attributo utente da cercare',
    'settings_ldap_user_attribute_tip' => 'Attributo LDAP in cui cercare il nome utente',
    'log_user_initial_pwd_changed' => 'Password iniziale definita',
    'log_user_email_changed' => 'Email utente modificata in ',
    'log_user_created' => 'Account utente creato',
    'log_user_locked' => 'L’utente è stato bloccato',
    'log_user_unlocked' => 'L’utente è stato sbloccato',
    'log_user_pwd_changed' => 'La password utente è stata modificata',
    'settings_default_session_expiration_time' => 'Durata di default per la sessione di scadenza',
    'settings_duo' => 'Abilita l’autenticazione a due fattori di DUO Security',
    'settings_duo_tip' => 'Autenticazione a due fattori basata su cloud Duo Security da duo.com. Passcode di accesso monouso tramite SMS, chiamata vocale o app mobile. Per utilizzare questa funzione è necessario un account con Duo. Una volta attivato, sarà richiesto l’accesso a due fattori tramite Duo per tutti gli utenti non amministratori.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Le credenziali della pagina di amministrazione di Duo Security per il tuo account devono essere inserite qui. Le impostazioni verranno memorizzate nel file sk.php solo dopo aver premuto il pulsante Salva.',
    'admin_duo_intro' => 'Inserisci o genera segreto Duo Security',
    'edit' => 'Modifica',
    'user_info_locked' => 'L’utente è attualmente bloccato.',
    'user_info_unlock_question' => 'Sbloccare l’account?',
    'user_info_lock_question' => 'Bloccare l’account?',
    'user_info_delete_question' => 'Eliminare l’account?',
    'user_info_active' => 'L’utente è attualmente abilitato.',
    'refresh' => 'Ricarica',
    'loading' => 'Caricamento in corso',
    'searching' => 'Ricerca ...',
    'list_items_with_tag' => 'Elenca elementi con questo tag',
    'no_item_to_display' => 'Nessun elemento da visualizzare',
    'opening_folder' => 'Lettura cartella...',
    'suggestion_notify_subject' => 'È stato inviato un nuovo suggerimento per l’elemento della password',
    'suggestion_notify_body' => 'Un utente ha inviato un suggerimento per l’elemento della password al gestore delle password. Devi accettare l’invio prima che possa essere utilizzato da altri utenti.<br>Informazioni:<br>- Etichetta: #tp_label#<br>- Cartella: #tp_folder#<br>- Utente: #tp_user#<br> <br>Questa email è stata inviata a tutti i gestori.',
    'error_unknown' => 'Si è verificato un errore imprevisto!',
    'no_edit' => 'Scrivi ma non modifica',
    'role_cannot_edit_item' => 'Impossibile modificare elementi',
    'no_delete' => 'Scrivi ma non elimina',
    'role_cannot_delete_item' => 'Impossibile eliminare elementi',
    'my_profile' => 'Il mio profilo',
    'starting' => 'Partenza...',
    'total_number_of_items' => 'Numero totale di elementi',
    'finalizing' => 'Finalizzare',
    'treating_items' => 'Elementi in elaborazione',
    'number_of_items_treated' => 'Numero di elementi elaborati',
    'error_sent_back' => 'Si è verificato un errore successivo',
    'full' => 'Completo',
    'sequential' => 'Sequenziale',
    'tree_load_strategy' => 'Strategia di carico dell’albero',
    'syslog_enable' => 'Registra errori nel server <i>syslog</i>',
    'syslog_host' => 'Nome o indirizzo IP del server Syslog',
    'syslog_port' => 'Porta Syslog (514 predefinita)',
    'error_bad_credentials' => 'Le credenziali di accesso non corrispondono!',
    'settings_ldap_usergroup' => 'Gruppo LDAP da cercare',
    'settings_ldap_usergroup_tip' => 'Inserisci il gruppo LDAP nella directory in cui sono memorizzati gli accessi utente consentiti. Esempio: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Abilita la modifica della password su un server distante (utilizzando la connessione ssh)',
    'update_server_password' => 'Aggiorna password del server',
    'ssh_pwd' => 'Password SSH',
    'ssh_user' => 'Utente SSH',
    'ssh_password_frequency_change_info' => 'Selezionare l’intervallo tra gli aggiornamenti automatici della password del server (selezionando 0 si disabiliterà la modifica automatica della password).<br>Gli aggiornamenti automatici della password verranno eseguiti solo se l’amministratore di sistema ha configurato anche la funzione di aggiornamento pianificato della password cron job.',
    'ssh_password_frequency_change' => 'Frequenza di modifica della password (in mesi)',
    'ssh_scheduled_change' => 'Modifica pianificata',
    'ssh_one_shot_change' => 'Cambio una tantum',
    'server_password_change_enable_tip' => 'Questa impostazione aggiunge un’opzione nella voce password per cambiare automaticamente la password utente su un indirizzo server elencato nell’url. Ciò richiede che il server UNIX remoto consenta l’accesso con nome utente e password tramite SSH. Le modifiche programmate automatiche della password possono essere eseguite dopo aver aggiunto <i>/files/script.ssh.php</i> a crontab in modo che venga eseguito una volta al giorno sul server web del gestore delle password.',
    'error_bad_credentials_more_than_3_times' => 'Credenziali di accesso errate!<br>Attendi 10 secondi prima del prossimo tentativo',
    'settings_ldap_object_class' => 'Classe da cercare',
    'settings_ldap_object_class_tip' => 'Classe LDAP da cercare, ad esempio account utente o account POSIX',
    'rebuild_config_file' => 'Ricostruisci il file di configurazione',
    'rebuild_config_file_tip' => 'Il file di configurazione contiene variabili di sistema e viene utilizzato quando queste impostazioni sono necessarie prima che sia stata stabilita la connessione al database. La ricostruzione del file di configurazione salva i valori del database nel file e può essere eseguita in qualsiasi momento. Il percorso predefinito è ./includes/config/tp.config.php, ma il file dovrebbe trovarsi all’esterno della directory www per motivi di sicurezza.',
    'error_folder_complexity_lower_than_top_folder' => 'Le sottocartelle devono avere un livello di sicurezza della password uguale o superiore a quello della cartella principale',
    'new_item_email_body' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>È stato creato un nuovo elemento ’#label’ in Teampass.<br>Puoi accedervi facendo clic su questo <a href="#link#">LINK</a>.<br/><br>Saluti.',
    'failed_logins' => 'Accessi non riusciti',
    'error_only_numbers_in_folder_name' => 'L’etichetta della cartella non può essere solo un numero. Assegna alla tua cartella un nome che includa lettere.',
    'encrypted_data' => 'I dati sono crittografati nel database',
    'settings_ldap_port' => 'Porta LDAP',
    'user_profile_agses_card_id' => 'ID della tua carta Agses',
    'ga_flash_qr_and_login' => 'Scansiona questo codice QR con il tuo dispositivo mobile, inserisci il codice di 2Factor Authentication e fai clic sul pulsante `Invio`.',
    'i_need_to_generate_new_ga_code' => 'Ho bisogno di un nuovo codice QR. Inviami via e-mail un codice di identificazione temporaneo.',
    'settings_manager_move_item' => 'I gestori possono spostare tutti gli elementi che possono visualizzare',
    'user_folders_rights' => 'Cartelle visibili',
    'create_item_without_password' => 'Consenti la creazione dell’elemento senza alcuna password definita',
    'share_rights_info' => 'Questa finestra di dialogo consente di condividere i diritti di un utente con una selezione di utenti.<br>Si noti che gli utenti selezionati avranno i loro diritti esistenti reimpostati e sostituiti con esattamente gli stessi diritti dell’utente di origine.',
    'share_rights_source' => 'Utente sorgente',
    'share_rights_destination' => 'Utenti di destinazione',
    'ga_reset_by_user' => 'L’utente può reimpostare il proprio codice 2FA',
    'ga_reset_by_user_tip' => 'Se abilitato, l’utente avrà la possibilità di reimpostare il proprio codice 2FA utilizzando il collegamento nella pagina di accesso. Questo potrebbe essere utile nel caso in cui, ad esempio, abbia cambiato dispositivo mobile. Se non abilitato, l’utente dovrà chiedere all’amministratore di generare un nuovo codice.',
    'enable_massive_move_delete' => 'Consenti all’utente di eseguire enormi operazioni di spostamento ed eliminazione',
    'enable_massive_move_delete_tip' => 'Se abilitata, questa opzione consente a un utente di eseguire un’operazione di spostamento e/o eliminazione massiccia in una sola volta. L’utente sarà in grado di eseguire questa operazione solo sugli elementi per i quali è autorizzato a farlo.',
    'mass_operation' => 'Operazione di massa sugli elementi',
    'move_items' => 'Sposta elementi selezionati',
    'delete_items' => 'Eliminare elementi selezionati',
    'you_decided_to_move_items' => 'Hai deciso di spostare gli elementi',
    'you_decided_to_delete_items' => 'Hai deciso di eliminare elementi',
    'suggest_password_change' => 'Suggerisci una modifica della password',
    'otv_is_enabled' => 'L’utente può proporre link Visualizzazione una tantum',
    'error_source_and_destination_are_equal' => 'Origine e destinazione non possono essere uguali!',
    'sending_anonymous_statistics' => 'Invio di statistiche anonime',
    'favourites_option_enabled' => 'Opzione Preferiti abilitata',
    'personalfolders_option_enabled' => 'Opzione Cartelle personali abilitata',
    'country_statistics' => 'Utilizzo della mappa del mondo',
    'country' => 'Paese',
    'users_statistics' => 'Numero medio di utenti per istanza',
    'items_all' => 'Tutti gli elementi',
    'folders_all' => 'Tutte le cartelle',
    'items_shared' => 'Tutti gli elementi condivisi (esclusi quelli personali)',
    'folders_shared' => 'Tutte le cartelle condivise (escluse quelle personali)',
    'items_statistics' => 'Numero medio di elementi per istanza',
    'folders_statistics' => 'Numero medio di cartelle per istanza',
    'administrators_number' => 'Numero di utenti amministratori',
    'administrators_number_statistics' => 'Numero medio di amministratori per istanza',
    'managers_number' => 'Numero di utenti Manager',
    'managers_number_statistics' => 'Numero medio di gestori per istanza',
    'readonly_number_statistics' => 'Numero medio di utenti di sola lettura per istanza',
    'readonly_number' => 'Numero di utenti di sola lettura',
    'mysql_version' => 'Versione MySQL',
    'php_version' => 'Versione PHP',
    'teampass_version' => 'Versione Teampass',
    'languages_used' => 'Lingue utilizzate',
    'languages_statistics' => 'Lingua più utilizzata',
    'kb_option_enabled' => 'Opzione Knowledge Base abilitata',
    'suggestion_option_enabled' => 'Opzione suggerimento abilitata',
    'customfields_option_enabled' => 'Opzione campi personalizzati abilitata',
    'api_option_enabled' => 'Opzione API abilitata',
    '2fa_option_enabled' => 'Opzione 2FA abilitata',
    'agses_option_enabled' => 'Opzione AGSES abilitata',
    'duo_option_enabled' => 'Opzione di DUO Security abilitata',
    'ldap_option_enabled' => 'Opzione LDAP abilitata',
    'syslog_option_enabled' => 'Opzione SYSLOG abilitata',
    'stricthttps_option_enabled' => 'Opzione HTTPS rigorosa abilitata',
    'characteristic' => 'Caratteristica',
    'current_value' => 'Valore corrente',
    'communication_means' => 'Mezzi di comunicazione',
    'consider_a_donation' => 'Puoi prendere in considerazione una donazione',
    'more_information' => 'Maggiori informazioni',
    'feature_request_canal' => 'Per richieste di funzionalità, utilizzare',
    'bug_canal' => 'Per i bug, utilizzare',
    'documentation_canal' => 'Documentazione completa a',
    'sending_anonymous_statistics_details' => 'Le statistiche sono necessarie per migliorare Teampass conoscendo la popolazione e l’utilizzo degli utenti. I dati che fornirai saranno utilizzati solo internamente per il datamining e non saranno assolutamente distribuiti o venduti a terzi.',
    'item_has_change_proposal' => 'Questo elemento ha una proposta di modifica',
    'check_data_after_reencryption' => 'Si prega di controllare i dati. Durante questa operazione è stata creata una nuova tabella <b>Backup</b> che consente il ripristino.',
    'revert' => 'Ripristinare?',
    'revert_the_database' => 'Hai deciso di ripristinare il database. Conferma?',
    'bad_psk' => 'Questa chiave SALT personale non è corretto!',
    'ldap_test_config' => 'Verifica la configurazione corrente',
    'ldap_test_username' => 'Nome utente da utilizzare a scopo di test',
    'ldap_test_username_pwd' => 'Nome utente password',
    'feature_support_canal' => 'Per supporto e aiuto, utilizzare',
    'category' => 'Categoria',
    'text' => 'Testo',
    'type' => 'Tipo',
    'data_is_masked' => 'I dati sono nascosti',
    'at_export' => 'Esporta',
    'settings_ldap_allowed_usergroup' => 'Gruppo utenti consentito LDAP',
    'settings_ldap_allowed_usergroup_tip' => 'Indica il gruppo autorizzato a connettersi a Teampass. Lasciarlo vuoto non è prevista alcuna restrizione per quanto riguarda l’appartenenza al gruppo.',
    'error_security_level_not_reached' => 'Livello di sicurezza previsto non raggiunto!',
    'personal_saltkey_security_level' => 'Livello minimo di sicurezza personale chiave SALT',
    'settings_disable_forgot_password_link' => 'Nascondi collegamento password dimenticata nella Home page',
    'newly_created_user_is_administrated_by' => 'L’utente appena creato è amministrato da',
    'settings_ldap_and_local_authentication' => 'Utenti locali e LDAP',
    'settings_ldap_and_local_authentication_tip' => 'Abilita questa opzione per consentire a entrambi gli utenti di autenticarsi nella libreria LDAP o nell’elenco utenti Teampass locale.',
    'enable_http_request_login' => 'Accesso automatico utilizzando le credenziali dell’intestazione http',
    'duration_login_attempt' => 'Secondi fino all’accesso automatico:',
    'newly_created_user_role' => 'L’utente appena creato ha un ruolo',
    'email_debug_level' => 'Seleziona un livello di debug',
    'email_debug_client' => 'Comandi client',
    'email_debug_server' => 'Comandi del client e risposte del server',
    'email_debug_connection' => 'Comandi del client, risposte del server e stato della connessione',
    'email_debug_low_level' => 'Output dati di basso livello, tutti i messaggi',
    'email_debug_level_usage' => 'Questa impostazione dovrebbe essere impostata su Nessuno. Da utilizzare solo per il debug della posta elettronica durante il test. Se abilitato, consentirà di mostrare un output dei comandi email.',
    'email_body_temporary_login_password' => 'Ciao,<br><br>Questa è un’e-mail generata dal gestore delle password di Teampass.<br><br>Un amministratore ha cambiato la tua password di accesso per Teampass. La prossima volta che ti connetterai a Teampass, utilizza il seguente:<br><br><b>#enc_code#</b><br><br><br>Saluti',
    'your_new_password' => 'La tua nuova password',
    'user_specific_right' => 'Diritto specifico dell’utente',
    'icon' => 'Icona',
    'icon_on_selection' => 'Icona sulla selezione',
    'fontawesome_icon_tip' => 'Puoi specificare un codice icona Font Awesome selezionato in <a href="https://fontawesome.com/v5.15/icons?d=gallery&p=2&s=solid&m=free" target="_blank">Icone libere e solide</a>. Lascia vuoto per l’icona predefinita.',
    'settings_api_token_duration' => 'Ritardo scadenza token JWT (in secondi)',
    'settings_api_token_duration_tip' => 'Ritardo durante il quale il token JWT generato è valido. Dopo questo ritardo, viene richiesto di inviare una richiesta di autorizzazione all’API.',
    'show_encryption_code_to_admin' => 'Questo è il codice cifrato di cui l’utente avrà bisogno per questo accesso. Hai chiesto di vederlo, copialo e condividilo in modo sicuro. Il codice è',
    'previous_password' => 'Password precedente utilizzata per connettersi a Teampass',
    'generate_new_otp' => 'Genera nuova OTP',
    'generate_new_otp_informations' => 'Questa operazione consiste nel generare ex novo tutte le chiavi per l’utente selezionato. Di conseguenza, l’utente dovrà fornire la nuova OTP generata al prossimo accesso.',
    'html' => 'html',
    'execution_time' => 'Tempo di esecuzione',
    'maximum_number_of_items_to_treat' => 'Numero massimo di elementi da trattare durante un ciclo',
    'maximum_number_of_items_to_treat_tip' => 'Per garantire il completamento dello script senza timeout, è possibile definire un valore personale.',
    'maximum_time_script_allowed_to_run' => 'Durata in secondi consentita per l’esecuzione dello script in background',
    'maximum_time_script_allowed_to_run_tip' => 'Per impostazione predefinita, lo script PHP non può essere eseguito più della durata definita dal parametro max_execution_time nel file php.ini. L’obiettivo qui è definire un valore più alto per garantire che lo script funzioni completamente.',
    'refresh_data_every_on_screen' => 'Periodo di aggiornamento dello schermo (in secondi)',
    'refresh_data_every_on_screen_tip' => 'Quando navighi nella vista delle attività, questo permette di avere un elenco aggiornato basato.',
    'refreshed' => 'Aggiornato',
    'process_details' => 'Dettagli di processo',
    'created_at' => 'Creato in',
    'updated_at' => 'Aggiornato alle',
    'finished_at' => 'Finito alle',
    'tasks_manager' => 'Gestione attività',
    'tasks' => 'Compiti',
    'task_in_progress_user_not_active' => 'Attività in corso - Utente non attivo',
    'enable_tasks_manager' => 'Abilita l’esecuzione di attività pesanti da parte di cron manager',
    'enable_tasks_manager_tip' => 'Questa opzione dovrebbe essere abilitata se hai notato che alcune attività richiedono molto tempo. Ciò consente di abilitare la gestione di tali attività utilizzando un lavoro in background eseguito dal server cron manager. Consulta la documentazione per maggiori dettagli.',
    'sync_new_ldap_password' => 'Sincronizza nuova password',
    'error_new_ldap_password_detected' => 'Sembra che la tua password sia cambiata e Teampass la richiede per crittografare la tua chiave privata principale.',
    'settings_ldap_tls_certifacte_check' => 'Verifica certificato per LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifica la strategia di controllo del certificato. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">Ulteriori informazioni</a>.',
    'user_keys_management' => 'Gestione chiavi utente',
    'sending_emails' => 'Inviando email',
    'task_frequency' => 'Frequenza (in minuti)',
    'tasks_information' => 'L’attività si basa su un cron job dedicato. Per questo, è richiesto di aggiungere una nuova voce al tuo crontab per eseguire lo scheduler Teampass ogni minuto.<br>Prossima voce da aggiungere:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php 1>> /dev/null 2>&1</code><br><br>Nota: si prega di adattare il percorso a php bin (nella maggior parte dei casi, può essere sostituito da <code>php</ codice>).',
    'bad_duo_mfa' => 'Codice DUO errato',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',

);
