<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.2
 * @file      chinese.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Show user encryption code',
    'email_body_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created for you a user account on Teampass. Next time you will connect to Teampass, please use next credentials:<ul><li>login: #login#</li><li>Password: #password#</li><li>Encryption code: #code#</li></ul><br><br><br>Cheers',
    'user_password' => 'User password',
    'user_temporary_encryption_code' => 'User encryption code',
    'no_email_set' => 'No email has been registered',
    'send_user_password_by_email' => 'Decide if the user login password should be sent by email.<br>If yes then press button Send.<br><br>Otherwize use the button Copy to clipboard to send it to the user by another mean.<br>It becomes your responsibility as an Administrator to provide the user the password in a secure way.',
    'admin_change_user_encryption_code_info' => 'This operation will reset the encryption code for this user.',
    'send_by_email' => 'Send by email',
    'filters' => 'Filters',
    'show_user_password' => 'Show user password',
    'open_website' => 'Open website',
    'mfa_for_roles' => 'MFA is requested for users in Roles',
    'mfa_for_roles_tip' => 'By default, once an MFA method is selected, it is enabled for all users. Nevertheless, you might select the roles for which it is expected.<br>NOT YET IMPLEMENTED',
    'at_least_one_administrator_is_requested' => 'At least one administrator is requested',
    'bad_code' => 'Bad code',
    'generating_keys' => 'Generating keys',
    'this_may_take_time' => 'This may take a couple of minutes',
    'disable_enable' => 'Disable / Enable',
    'user_disable_status' => 'Tick the box to disable or leave empty to enable',
    'help_for_launching_items_encryption' => 'We need to generate the keys database for your account. Please provide your encryption code.',
    'managed_through_ad' => 'Managed through AD',
    'new_ldap_user_info' => 'Please complete the definition for user',
    'email_body_user_added_from_ldap_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>You now have an account in Teampass. You can use your AD credentials to get logged.<br><br>On first login, an encryption code will be expected from you, please use:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'settings_ldap_user_object_filter' => 'User Object Filter',
    'settings_ldap_user_object_filter_tip' => 'The filter to use when searching user objects. Example: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'This value is used in addition to the base DN when searching and loading users. If no value is supplied, the subtree search will start from the base DN. Examples: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Additional User DN',
    'ldap_user_has_changed_his_password' => 'Your authentication password has been changed in your AD since you last get logged in in Teampass. We need to adapt your encryption key. Please provide your previous password and the current one.',
    'provide_your_previous_password' => 'Your previous password',
    'admin_change_user_password_info' => 'This operation will reset the selected user current password.',
    'sending_email_message' => 'Now sending email to user, please wait',
    'change_your_password_info_message' => 'Please provide your new authentication password and confirm it.',
    'user_has_to_change_password_info' => 'The current used password has been generated. It is expected from you to change it for security purpose.',
    'ready_to_go' => 'Ready to go',
    'passwords_not_the_same' => 'Provided passwords are not the same',
    'inititialization' => 'Initialization',
    'bad_password' => 'Bad password',
    'perform_checks' => 'Perform checks',
    'email_body_temporary_encryption_code' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Some changes were performed on your account that require a new encryption of items for data security. Next time you will connect to Teampass, please use the next code:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'temporary_encryption_code' => 'Your temporary encryption code',
    'renecyption_expected' => 'We need to renecrypt your keys to fit the privileges corresponding to your account and rights.',
    'error_no_user_in_ad' => 'User not found in AD!',
    'error_ad_user_expired' => 'User is expired!',
    'error' => 'Error caught',
    'hosts' => 'Hosts',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Base DN',
    'settings_ldap_bdn_tip' => 'The root distinguished name (DN) to use when running queries against the directory server. Examples: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Username',
    'settings_ldap_username_tip' => 'The distinguished name of the user that the application will use when connecting to the directory server. Examples: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'The password of the user specified above.',
    'settings_ldap_port_tip' => 'Default non secure LDAP port: 389, default secure LDAP port: 636',
    'undefined' => 'Undefined',
    'error_cannot_open_file' => 'File cannot be opened',
    'provide_current_psk_and_click_launch' => 'When ready, click button Launch',
    'start' => 'Start',
    'data_inconsistency' => 'Data inconsistency found. Please reload the page!',
    'one_time_code_expected' => 'One-Time-Code expected',
    'data_are_missing' => 'Expected data are missing',
    'one_time_code' => 'One-Time-Code',
    'provide_personal_one_time_code' => 'Please provide the One-Time-Code you received by email',
    'change_authentification_type_to_ldap' => 'Change authentication type to LDAP',
    'change_authentification_type_to_local' => 'Change authentication type to Teampass local database',
    'ldap_user_password_is_used_for_authentication' => 'User password in LDAP is used for authentication',
    'local_user_password_is_used_for_authentication' => 'User password in Teampass is used for authentication',
    'provide_your_current_password' => 'Provide your current password',
    'current_password' => 'Current password',
    'password_is_not_correct' => 'This password is not correct',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Personal items',
    'logout_on_going' => 'You will now be logout. Use your new password for being connected from now.',
    'fill_in_fields_and_hit_launch' => 'Provide expected data and hit Launch button',
    'please_select_a_folder' => 'Please select a folder',
    'user_must_have_login_and_email' => 'User must have a login and an email',
    'user_has_this_role_in_teampass' => 'User has this role in Teampass',
    'select_role_to_create' => 'Select role to create',
    'adding_ldap_role_to_teampass' => 'You can decide to create a role in Teampass coming from your Active Directory. This will permit to associate user to this role in Teampass.',
    'add_user_to_role' => 'Add this role to the user in Teampass',
    'add_user_in_teampass' => 'Add user in Teampass',
    'synchronized' => 'Synchronized',
    'output' => 'Output',
    'remove_install_folder' => 'Install folder has to be removed',
    'list_users' => 'List users',
    'ldap_synchronization' => 'LDAP synchronization',
    'in_progress' => 'In progress',
    'clipboard_password_life_duration' => 'Delay before the clipboard is cleared (in seconds)',
    'clipboard_password_life_duration_tip' => 'Permits to define a delay in seconds before which the password copied in clipboard will be cleared from the browser clipboard. Set to 0 to disable.',
    'clipboard_will_be_cleared' => 'Password is now in clipboard. It will soon be cleared...',
    'file_folder_not_accessible' => 'Files folder is not accessible',
    'error_missing_id' => 'An error occurred. Missing ID ... ?',
    'error_folder_not_allowed' => 'Selected folder is not allowed',
    'all_fields_mandatory' => 'All fields are mandatory',
    'history_insert_entry' => 'Insert in History',
    'clear_form' => 'Clear form',
    'info_about_history_insertion' => 'Caution - This feature permits you to insert manually an event in the item history log. Once added it will not be possible to remove it. Also notice that your account id will be associated to this new entry.',
    'select_all' => 'Select all',
    'unselect_all' => 'Unselect all',
    'no_data_to_display' => 'No data to display! Either no folder already exists, either you have access to none of them.',
    'server' => 'Server',
    'data_refreshed' => 'Data refreshed',
    'loading_image' => 'Loading image',
    'compare_with_another_role' => 'Compare with another role',
    'only_display_folders_to_depth' => 'Only display folders to depth',
    'propagate_rights_to_descendants' => 'Propagate rights to descendants',
    'loading_data' => 'Loading data',
    'password_overview_delay' => 'Delay for password overview',
    'password_overview_delay_tip' => 'This setting permits to define the number of seconds the clear password will be displayed to the user.',
    'select_date_showing_items_expiration' => 'List the expired items at date',
    'renewal_page_info' => 'This page permits to identify the items currently expired or expiring in next period.',
    'filename' => 'Filename',
    'exported_to_file' => 'Exported to file',
    'operation_progress' => 'Operation is in progress',
    'exporting_items' => 'Exporting items',
    'select_folders_to_export' => 'Select folders to export',
    'export_format_type' => 'Select the export format type',
    'export_items' => 'Export items',
    'loading_item' => 'Loading item',
    'otv_message' => 'You can share this item with someone without a Teampass account. One-Time-View permits your guest to access basic fields of this item only once without being authenticated in Teampass. Please notice that this link is valid for a period of ##otv_expiration_period##  days. Copy and share the link below.',
    'no_sharekey_found' => 'No key found for this file and your account',
    'otv_link' => 'One-time-view link',
    'one_time_view' => 'One-time-view',
    'move_right_columns_separator' => 'Move columns separator Right',
    'move_left_columns_separator' => 'Move columns separator Left',
    'form_presents_inconsistencies' => 'The form presents some inconsistencies. Please check fields with red borders.',
    'download' => 'Download',
    'see' => 'See',
    'at_anyoneconmodify' => 'Anyone can modify',
    'disabled' => 'Disabled',
    'enabled' => 'Enabled',
    'confirmation_seems_wrong' => 'Confirmation seems wrong, please correct',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'This action is without rollback. It will clear the passwords stored inside your personal items. Items will not be deleted but only their passwords. If you cannot remember your personal saltkey then it is the only option.',
    'user_has_psk_info' => 'We have identified that you have some personal items encoded with an old personal saltkey. This step aim consists in re-encrypting them with your new private key. Please provide us your personal saltkey.',
    'files' => 'Files',
    'logs' => '日志',
    'suggestions' => 'Suggestions',
    'encryption_keys' => 'Encrypting keys',
    'clearing_old_sharekeys' => 'Clearing old sharekeys',
    'hit_launch_to_start' => 'Please click Launch button to start',
    'password_changed' => 'Password updated',
    'password_already_used' => 'Password already used',
    'change_login_password' => 'Change login password',
    'current_password_mandatory' => 'Current password is mandatory',
    'objects_encryption_explanation' => 'Teampass has been upgraded to a new version which includes a new encryption protocol. It expects from you to re-encrypt your personal items. For this, you need to provide your current Personal Salt Key (PSK). Once odne, please click on button Launch and wait until the process reached the final step. This could take several minutes depending on the number of objects.',
    'description_has_changed' => 'Description has changed',
    'number_of_folders_imported' => 'Number of Folders imported',
    'number_of_items_imported' => 'Number of Items imported',
    'propagate' => 'Propagate',
    'propagate_user_rights' => 'Propagate user rights',
    'register_new_yubiko_key' => 'Register a new Yubiko key',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Previous value',
    'no_previous_value' => 'No previous value',
    'no_data_selected' => 'No data selected',
    'selected_items_to_be_imported' => 'Selected items to be imported',
    'cannot_open_file' => 'File cannot be opened',
    'no_item_found' => 'No Item found',
    'reading_file' => 'Reading file',
    'where_shall_items_be_created' => 'Where shall the Items be created',
    'target_folder' => 'Target folder',
    'select_file' => 'Select file',
    'data_type_for_import' => 'Start by selecting the source type of data to import',
    'get_tips_about_importation' => 'Get tips about importation',
    'import_new_items' => 'Import new items',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'for',
    'request_access' => 'Request access to Item',
    'request_access_message' => 'When requesting an access to an item, an email is sent to the author. The author will accept or reject the request by adding you to the Item restriction list. Please confirm to send your request by email to the author.',
    'request_access_reason' => 'Provide the author the reason of your request',
    'error_provide_reason' => 'Please provide the reason why you want to access this item',
    'need_access' => 'Need access?',
    'item_with_restricted_access' => 'Item with restricted access',
    'remaining_emails_to_send' => 'Remaining emails to send',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Import',
    'export' => 'Export',
    'offline' => 'Offline',
    'login_attempts_identified_since_last_connection' => 'Your attention is required. At least one login attempt with your account has been identified since last successful connection. Please check and report to your local administrator if you are not the author.',
    'last_login_attempts' => 'Last login attempts',
    'see_detail' => 'See detail',
    'role_definition' => 'Role definition',
    'not_yet_implemented' => 'Not yet implemented',
    '2factors_expected_for_admin' => 'Administrator requires MFA to get logged',
    '2factors_expected_for_admin_tip' => 'By default, an Administrator has to use a MFA method to get logged. If not enabled, Administrator will not require it to get logged even if MFA is enabled for any other user.',
    'restore_done_now_logout' => 'Database restore has been done. You now need to disconnect to refresh the session variables.',
    'backup_and_restore' => 'Backup and Restore',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Perform backup',
    'perform_restore' => 'Perform restore',
    'backup_select' => 'Backup file',
    'choose_file' => 'Choose file',
    'on_the_fly' => 'On the fly',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Caution - Be aware that changing the type of encryption will require to parse all existing data in order to change the encryption in the database.',
    'caution_while_deleting_field' => 'Caution - Deleting this field will also delete related data in items.',
    'error_could_not_update_the_field' => 'Error - The field could not be updated. Please retry after reloading the page.',
    'caution_while_deleting_category' => 'Caution - Deleting this folder will delete all its belonging fields and also all fields related data.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'All fields are required',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Field',
    'configuration' => 'Configuration',
    'definition' => '定义',
    'number_of_modified_attachments' => 'Number of modified attachments',
    'files_not_encrypted' => 'Files are currently not encrypted. You should perform this change for security reasons.',
    'files_already_encrypted' => 'Files are already encrypted. You should not change this for security reasons.',
    'action_to_be_performed' => 'Action to be performed',
    'last_execution' => 'Last execution',
    'never_performed' => 'Never performed',
    'launch' => 'Launch',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Uploads',
    'uploads_configuration' => 'Uploads configuration',
    'email_configuration' => 'Email configuration',
    'email_configuration_test' => 'Email configuration test',
    'send_a_test_email' => 'Send a test email',
    'manage_emails_not_sent' => 'Manage not sent emails',
    'email_send_backlog' => '#nb_emails# unsent emails',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Adding a new IP to whitelist',
    'adding_new_api_key' => 'Adding a new API key',
    'api_configuration' => 'API configuration',
    'mfa_configuration' => 'MFA configuration',
    'yubico_authentication_tip' => 'Please visit www.yubico.com for more details.',
    'complexity_level_not_reached' => 'Complexity level is not reached',
    'expected_complexity_level' => 'Expected complexity level',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Favorite',
    'unfavorite' => 'Unfavorite',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Apply',
    'from' => 'From',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Purge',
    'belong_of_deleted_folder' => 'Belong to deleted folder',
    'highlight_selected' => 'Highlight selected',
    'number_of_selected_objects' => 'Number of selected objects',
    'confirm_selection_restore' => 'Please confirm the restoration of selected items.',
    'confirm_selection_delete' => 'Please confirm the deletion of selected items.',
    'refreshing' => 'Refreshing',
    'empty_list' => 'Empty list',
    'deleted_folders' => 'Deleted folders',
    'deleted_items' => 'Deleted items',
    'recycled_bin' => 'Recycled bin',
    'database' => 'Database',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Please confirm deletion',
    'caution' => 'Caution',
    'role_not_exist' => 'This role doesn\'t exist!',
    'role_can_edit_any_visible_item' => 'Role can edit any visible item',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Delete allowed',
    'add_allowed' => 'Add allowed',
    'edit_not_allowed' => 'Edit not allowed',
    'delete_not_allowed' => 'Delete not allowed',
    'select_a_role' => 'Select a role',
    'access_rights_for_user' => 'Access rights for user',
    'logs_for_user' => 'Logs for user',
    'please_confirm' => 'Please confirm',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'By clicking this checkbox, it confirms the deletion of this user.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Enable Personal Folder feature for this user',
    'special' => 'Special',
    'administrator' => 'Administrator',
    'super_manager' => 'Teampass manager',
    'manager' => 'Manager',
    'read_only' => 'Read only',
    'privileges' => 'Privileges',
    'roles' => '角色',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Please tick the checkbox to confirm',
    'next_list_to_be_deleted' => 'Next list will be deleted',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => '标签',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Minimal password complexity target',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Allow new item creation without password minimal complexity target',
    'edit_without_password_minimal_complexity_target' => 'Allow item edition without password minimal complexity target',
    'add_new_folder' => 'Add a new folder',
    'new' => 'New',
    'id' => 'ID',
    'mfa_short' => 'MFA',
    'mfa' => 'Multi-Factor Authentication',
    'google_2fa' => 'Google 2-Step Verification',
    'duo_security' => 'Duo Security',
    'yubico' => 'Yubico Authenticator',
    'website_canal' => 'Click to open Teampass website',
    '2fa_credential_not_correct' => '2FA credential is not correct',
    'no_change_performed' => 'No change was performed.',
    'password_strength' => 'Password strength',
    'new_password_required' => 'A new password is required',
    'limited_search' => 'Limited search',
    'empty_psk' => 'Saltkey is missing',
    'currently_no_favorites' => 'You currently have no favorites',
    'favorites' => 'Favorites',
    'confirm_item_move' => 'You have selected "Moving"... are you sure?',
    'copy_to_clipboard' => 'Copy to clipboard',
    'please_wait_while_loading' => 'Please wait while data is loading',
    'defect_report' => 'Bug report',
    'actions' => 'Actions',
    'no_user' => 'Wrong user',
    'generate_api_token' => 'Generate new API token',
    'upload_feature' => 'Upload feature',
    'profile' => 'Profile',
    'language' => 'Language',
    'upload_new_avatar' => '选择头像 PNG 文件',
    'settings' => 'Settings',
    'created_items' => 'Created items',
    'modification_performed' => 'Modification performed',
    'items_opened' => 'Opened items',
    'passwords_seen' => 'Seen passwords',
    'nothing_to_save' => 'Nothing to save',
    'notification_engaged' => 'You are receiving notifications on Item change',
    'notification_not_engaged' => 'You are not receiving notifications on Item change',
    'viewed_number' => 'Number of Views',
    'automatic_deletion_engaged' => 'Automatic deletion',
    'auto_update_enabled' => 'Automatic user password change enabled. Next change planned',
    'copy_folder' => 'Copy folder',
    'select_source_folder' => 'Select folder to copy',
    'select_destination_folder' => 'Select destination folder',
    'delete_folder' => 'Folder delete',
    'select_folder_to_delete' => 'Select folder to delete',
    'folder_delete_confirm' => 'The seleted folder and its items will be deleted. Please tick the checkbox to confirm this deletion.',
    'json_error_format' => 'Bad JSON format',
    'password_cannot_be_empty' => 'Password cannot be empty',
    'password_too_long' => 'Password is too long',
    'error_no_action_identified' => 'No action has been identified',
    'ldap' => 'LDAP',
    'emails' => 'Emails',
    'backups' => 'Backups',
    'api' => 'API',
    'add_folder' => 'Add new folder',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Provided session key is not correct',
    'suggestion_information' => 'You can suggest any change on this item to the author. Use the above form to make your change proposals and click the Perform button to inform the author.',
    'email_address' => 'Email address',
    'enter_email' => 'Enter email',
    'notification' => 'Notification',
    'notify_on_change' => 'Notify me on changes',
    'notification_message' => 'You can use this setting to get notified or not on changes performed on this item.',
    'share_item' => 'Share item',
    'share_item_message' => 'You can share this item with someone. Please provide a valid email and click Perform button.',
    'delete_item_message' => 'You have decided to delete this selected item. You need to confirm your choice by clicking Perform button.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'You are not allowed to edit this item',
    'error_not_allowed_to_access_this_folder' => 'You are not allowed to access this folder',
    'error_personal_saltkey_is_not_set' => 'Your personal saltkey is not provided.',
    'provide_your_personal_saltkey' => 'Please provide your personal saltkey',
    'no_fields' => 'No field is related to this item.',
    'uploaded' => 'uploaded',
    'changes_ongoing' => 'Some changes were not saved. Do you confirm to quit without saving?',
    'no_file_to_upload' => 'No file to upload',
    'add_files_and_click_start' => 'Add files to the upload queue and click the start button.',
    'select_files' => 'Select files',
    'attached_files' => 'Attached files',
    'visible_by' => 'Visible by',
    'anounce_item_by_email' => 'Anounce this item to users',
    'select_users_if_needed' => 'Select users if needed',
    'allow_item_to_be_deleted' => 'Allow this item to be deleted on next condition',
    'item_deleted_after_being_viewed_x_times' => 'Item will be deleted after being viewed X times',
    'item_deleted_after_date' => 'Item will be deleted after defined date',
    'password' => 'Password',
    'save' => 'Save',
    'folder' => 'Folder',
    'main' => 'Main',
    'fields' => 'Fields',
    'details' => 'Details',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Generate One-Time-View link',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'No attachment',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Attachments',
    'success' => 'Success',
    'server_answer_error' => 'An error appears. Answer from Server cannot be parsed!',
    'server_returned_data' => 'Returned data',
    'version_alone' => 'version',
    'statistics' => 'Statistics',
    'options' => 'Options',
    'users' => '用户',
    'folders' => '文件夹',
    'find_message' => '<i class="fa fa-info-circle"></i> 找到了 %X% 个对象',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'share' => '分享此项',
    'notify' => 'Notify',
    'error_no_selected_folder' => '您需要选择一个文件夹',
    'email_subject_item_updated' => '密码已更新',
    'email_body_item_updated' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Password for \'#item_label#\' has been updated.<br /><br />You can check it <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">HERE</a><br /><br />Cheers',
    'import_kp_finished' => '从 KeePass 导入已完成！<br />默认情况下，新文件夹的复杂性级别被设置为“中等”。您可以根据需要更改它。',
    'password_is_empty' => 'Item has no password',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bugs_page' => 'If you discover a bug, please report it.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Set <i>anyone in the same role can modify</i> right on all imported items.',
    'import_csv_anyone_can_modify_txt' => '对所有已导入的项目设置“任何人都能修改”权限。',
    'settings_upload_imageresize_options' => '图像应该调整大小为',
    'user_not_exists' => 'This user does not exist!',
    'auto_create_folder_role' => 'Create folder and role for ',
    'start_upload' => '开始上传文件',
    'error_upload_runtime_not_found' => 'Upload feature: No runtime found.',
    'user_profile_api_key' => 'Your API key',
    'index_change_pw' => '更改您的密码',
    'admin_2factors_authentication_setting' => '启用 Google 两步验证',
    'admin_2factors_authentication_setting_tip' => 'Google two-factor authentication enhances logon security. When logging in, a QR code is displayed, which must be scanned into the user\'s Google Authentication app to receive a one-time password. Requires all users to have Google authentication app on an Internet-connected mobile device.',
    'admin_ga_website_name' => '显示在 Google 身份验证器中的名称',
    'admin_ga_website_name_tip' => '此名称用于在 Google 身份验证器中显示帐户验证码时的名称',
    'api_whitelist_ips' => 'API IPs Whitelist',
    'api_whitelist_ips_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'email_share_item_subject' => '[TeamPass] 一项已与您共享',
    'email_share_item_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has shared with you the password item #tp_item# <a href="#tp_link#">Click this link</a> to access the item.',
    'index_maintenance_mode_admin' => 'Maintenance mode is activated. Users currently can not log in.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => '发送 Google 身份验证器至用户，通过电子邮件',
    'error_no_email' => '此用户未设置电子邮件地址！',
    'error_no_user' => '未找到用户！',
    'email_ga_subject' => '您的用于 Teampass 的 Google 身份验证器条码',
    'email_ga_text' => '你好，<br><br>请点击此<a href="#link#">链接</a>刷新 Google 身份验证器应用以获取您用于 Teampass 的一次性凭据。<br /><br />Cheers ',
    'settings_attachments_encryption' => '启用项目附件加密',
    'settings_attachments_encryption_tip' => '此选项可能损坏现有的附件，请仔细阅读下面的内容。项目附件被加密存储在该服务器上。加密是使用为 Teampass 定义的 SALT。这需要更多服务器资源。警告：一旦您更改了策略，它将强制性的运行脚本以适配现有的附件。参见“特殊操作”选项卡。',
    'admin_action_attachments_cryption' => '加密或解密项目附件',
    'admin_action_attachments_cryption_tip' => '警告：此操作只应在更改 Teampass 中的相关选项后进行。在执行任何操作前，为了以防万一，请“上传”一份文件夹的副本。',
    'encrypt' => '加密',
    'decrypt' => '解密',
    'ga_identification_code' => '验证码',
    'ga_enter_credentials' => '您需要输入您的登录凭据',
    'ga_bad_code' => 'Google 身份验证器的验证码不正确',
    'settings_get_tp_info' => '自动加载有关 Teampass 的信息',
    'settings_get_tp_info_tip' => '此选项允许管理页面加载来自 Teampass 服务器的版本和库使用等信息。',
    'settings_offline_mode' => '激活离线模式',
    'settings_offline_mode_tip' => '离线模式包括导出项目到一个 HTML 文件。此页面的项目已使用用户指定的一个密码进行加密。',
    'offline_mode_key_level' => '离线加密密钥最低级别',
    'categories' => '分类',
    'no_category_defined' => '尚未定义分类',
    'confirm_deletion' => '您即将删除...您确定吗？',
    'settings_item_extra_fields' => 'Custom item fields enabled',
    'settings_item_extra_fields_tip' => 'Enables another tab when creating password items, which contains custom fields for other types of data. An administrator must first create categories and the custom field labels to be displayed in those categories. This feature consumes more server resources.',
    'settings_ldap_type' => 'LDAP 服务器类型',
    'server_time' => '服务器时间',
    'settings_tree_counters' => '在文件夹树中显示更多计数器',
    'settings_tree_counters_tip' => 'Enabling shows three numbers next to each folder: number of items in base folder; number of items including subfolders; number of subfolders. Enabling this feature may slow loading of the folder tree pane.',
    'admin_action_check_pf' => 'Create personal folders for all users without one',
    'enable_personal_folder_feature_tip' => 'Personal folders are a private location for individual user passwords. Password items are encrypted by a user\'s salt key (more secure) or by their password (easier). Enabling this feature does not create the actual folders for existing users - you must also run the create personal folders task.',
    'administrators_only' => '仅管理员',
    'managers_of' => '规则管理',
    'managed_by' => '管理者',
    'settings_enable_sts' => '强制实行 HTTPS 严格安全传输协议 - 警告：请阅读工具提示。',
    'settings_enable_sts_tip' => 'Warning! This will enforce the HTTPS strict transport security (STS) policy. STS helps prevent man-in-the-middle attacks. You must have a SSL certificate issued from a certificate authority (CA) installed before enabling this option!  A self-signed certificate will not work! Any future web connections will require HTTPS. You must have \'SSLOptions +ExportCertData\' in the Apache SSL configuration.',
    'settings_anyone_can_modify_bydefault' => '默认激活“<b><i>任何人都能修改</b></i>”选项',
    'to' => '至',
    'settings_upload_maxfilesize_tip' => 'Maximum file size allowed when uploading an attachment or other file (in megabytes, default setting 10 MB). You also may need to change your php.ini settings upload_max_filesize and post_max_size, the default is often just 2 MB.',
    'settings_upload_docext_tip' => 'List the file extensions for text and word processor files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_imagesext_tip' => '图像类型。用半角逗号（,）分隔的允许的扩展名',
    'settings_upload_pkgext_tip' => '包类型。用半角逗号（,）分隔的允许的扩展名',
    'settings_upload_otherext_tip' => '其他类型。用半角逗号（,）分隔的允许的扩展名',
    'settings_upload_imageresize_options_tip' => 'Resize large uploaded pictures (set maximum dimensions in pixels). Images larger than 1000 pixels wide may not display well in the web browser.',
    'settings_upload_maxfilesize' => '最大文件大小（MB）',
    'settings_upload_docext' => '允许的文档扩展名',
    'settings_upload_imagesext' => '允许的图像扩展名',
    'settings_upload_pkgext' => '允许的包扩展名',
    'settings_upload_otherext' => '允许的其他扩展名',
    'settings_upload_imageresize_options_w' => '重新调整图像宽度（像素）',
    'settings_upload_imageresize_options_h' => '重新调整图像高度（像素）',
    'settings_upload_imageresize_options_q' => '重新调整图像质量',
    'settings_importing' => '启用从 CVS/KeyPass 文件导入数据',
    'admin_proxy_ip' => '使用的代理 IP',
    'admin_proxy_ip_tip' => '<span style="font-size:11px;max-width:300px;">如果您通过一个代理访问互联网，请指出它的 IP。<br />如果不使用代理，留空此项。</span> ',
    'admin_proxy_port' => '使用的代理端口',
    'admin_proxy_port_tip' => 'If you require a proxy server to connect to the Internet, set the port number here.',
    'settings_ldap_elusers' => ' 仅 Teampass 本地用户',
    'settings_ldap_elusers_tip' => 'This feature allows users in the database to authenticate via LDAP. Disable this if you want to browse any LDAP directory.',
    'db_items_edited' => 'Item currently being edited',
    'item_edition_start_hour' => 'Editing started',
    'settings_delay_for_item_edition' => '一个项目编辑经过多长时间后被判定为失败（单位：分钟）',
    'settings_delay_for_item_edition_tip' => 'When editing an item, the item is locked so that no other user can modify it. This setting deletes the lock token after a certain number of minutes. If the value is set to 0, an item will never be automatically unlocked after someone has started editing.',
    'db_users_logged' => '用户已登录',
    'action' => '操作',
    'login_time' => '登录时间',
    'lastname' => '名',
    'user_login' => '登录',
    'role' => '角色',
    'error_role_exist' => '此角色已经存在。',
    'error_no_edition_possible_locked' => 'Editing disabled - item locked by another user',
    'select' => '选择',
    'items' => '项目',
    'enable_personal_saltkey_cookie' => '启用将个人 SALTKey 存储在 Cookie 中',
    'personal_saltkey_cookie_duration' => '个人 SALTKey 的 Cookie 生存周期',
    'admin_email_smtp_server' => 'SMTP 服务器',
    'admin_email_auth' => 'SMTP 服务器需要身份验证',
    'admin_email_auth_username' => '身份验证用户名',
    'admin_email_auth_pwd' => '身份验证密码',
    'admin_email_port' => '服务器端口',
    'admin_email_from' => '发送者邮件地址',
    'admin_email_from_name' => '发送者名称',
    'admin_email_test_configuration_tip' => '此测试将发送一封邮件到该地址。如果您未收到它，请检查您的身份凭据。',
    'admin_email_test_subject' => '[TeamPass] 测试邮件',
    'admin_email_test_body' => '你好，<br><br>电子邮件发送成功。<br><br>干杯。',
    'admin_email_result_ok' => '电子邮件已发往 #email# ...请检查您的收件箱。',
    'email_bodyalt_item_updated' => '#item_label# 的密码已更新。',
    'admin_email_send_backlog_tip' => 'Re-send any queued backlog of outgoing emails waiting in the database.',
    'please_wait' => '请稍候。',
    'admin_path_to_files_folder' => 'Files folder (full path)',
    'admin_path_to_files_folder_tip' => 'The files folder is used to store both system files and some uploaded files. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'admin_path_to_upload_folder_tip' => 'File attachments are stored in the upload folder with randomized names.  Contents of this folder should never be manually deleted. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'pdf_password_warning' => '您必须提供一个加密密钥！',
    'admin_pwd_maximum_length' => '密码最大长度',
    'admin_pwd_maximum_length_tip' => 'The default maximum password length is 40 characters. Increasing the size of allowed passwords will take more time when encrypting, decrypting, and displaying passwords.',
    'settings_insert_manual_entry_item_history' => '启用允许手动在项目历史中插入记录',
    'settings_insert_manual_entry_item_history_tip' => 'You would normally want to leave this off. When enabled, the history of a password item can be edited or altered.',
    'admin_path_to_upload_folder' => '上传文件夹路径',
    'admin_setting_enable_delete_after_consultation' => 'Passwords may expire after limited views',
    'admin_setting_enable_delete_after_consultation_tip' => 'When enabled, item creators can decide whether a password item will be automatically deleted after a limited number of views.',
    'at_email' => '电子邮件',
    'enable_email_notification_on_item_shown' => '项目已显示时发送邮件通知',
    'share_sent_ok' => '电子邮件已发送',
    'see_item_title' => '项目细节',
    'email_on_open_notification_subject' => '[TeamPass] 项目打开通知',
    'email_on_open_notification_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has opened and viewed the password item \'#tp_item#\'. <a href="#tp_link#">Click this link</a> to access the item.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] 您的账号已创建',
    'email_new_user_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created an account for you on the password manager. Secure passwords for your organization are just a click away! <br><br>Use these credentials for your first login:<br>- Login: #tp_login#<br>- Password: #tp_pw#<br><br><a href="#tp_link#">Click this link</a> to log in and reset your password.',
    'error_empty_data' => '没有要处理的数据！',
    'error_not_allowed_to' => '您无权进行此操作！',
    'request_access_ot_item' => '向作者请求访问权',
    'email_request_access_subject' => '[TeamPass] 请求访问一个项目',
    'email_request_access_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>User #tp_user# has requested access to password item "#tp_item#".<br><br>The request comes with the next justification:<br><i>"#tp_reason#"</i><br><br>Please review this request  and confirm that you will authorize access.<br><br>Greetings.',
    'admin_action_change_salt_key' => '更改主 SALT 密钥',
    'nb_items_by_query' => 'Number of items to retrieve per query',
    'nb_items_by_query_tip' => 'Input the number of items to retrieve per server request. Multiple smaller requests may perform better than fewer, larger requests. Other options: \'auto\' - tuned to user display window size. \'max\' - to load all at once.',
    'open_url_link' => '在新页面打开',
    'error_pw_too_long' => '密码太长了！最多允许40个字符。',
    'at_restriction' => '限制',
    'pw_encryption_error' => '密码加密出错！',
    'enable_send_email_on_user_login' => '用户登录时发送一封邮件给管理员',
    'email_subject_on_user_login' => '[TeamPass] 一名用户已连接',
    'email_body_on_user_login' => '你好，<br><br>用户 #tp_user# 已连接到 TeamPass，时间：#tp_date# #tp_time#.<br><br>诚挚问候。',
    'account_is_locked' => '此账号已锁定',
    'activity' => '活动',
    'add_role_tip' => '添加新角色。',
    'admin' => '管理',
    'admin_action_db_backup' => '创建数据库备份',
    'admin_action_db_clean_items' => '移除数据库中的孤立项目',
    'admin_action_db_clean_items_tip' => 'Removes any items or other entries left behind after a folder is deleted. Please backup before performing this task.',
    'admin_action_db_optimize' => '优化数据库',
    'admin_action_db_restore' => '恢复数据库',
    'admin_action_purge_old_files' => '刷新旧文件',
    'admin_action_purge_old_files_tip' => '这将删除所有超过7天的临时文件。',
    'admin_action_reload_cache_table' => '重新载入缓存表',
    'admin_action_reload_cache_table_tip' => 'Recreates the item cache. May correct problems in displaying or saving password items.',
    'admin_help' => '帮助',
    'admin_ldap_configuration' => 'LDAP配置',
    'admin_main' => '信息',
    'admin_misc_cpassman_dir' => 'TeamPass 的完整路径',
    'admin_misc_cpassman_url' => 'TeamPass 的完整 URL',
    'admin_misc_custom_login_text' => '自定义登录文本',
    'admin_misc_custom_logo' => '自定义登录 Logo 的完整 URL',
    'admin_misc_favicon' => '网站小图标（Favicon）文件的完整 URL',
    'admin_settings' => '设置',
    'admin_settings_title' => 'TeamPass 设置',
    'admin_setting_activate_expiration' => '启用密码过期',
    'admin_setting_activate_expiration_tip' => '如果启用，已过期项目将不会显示给用户。',
    'admin_views' => '查看',
    'alert_message_done' => '完成！',
    'all' => '所有',
    'anyone_can_modify' => '允许项目被可访问的人修改',
    'at' => 'at',
    'at_category' => '文件夹',
    'at_copy' => '复制完成',
    'at_delete' => '删除',
    'at_description' => '描述。',
    'at_label' => '标签',
    'at_login' => '登录',
    'at_moved' => '移动',
    'at_personnel' => '个人',
    'at_restored' => '已恢复。',
    'at_shown' => '相关',
    'at_url' => 'URL',
    'author' => '作者',
    'authorized_groups' => '允许的文件夹',
    'auth_creation_without_complexity' => '允许绕过必需的密码复杂性要求创建一个项目',
    'auth_modification_without_complexity' => '允许绕过必需的密码复杂性要求修改一个项目',
    'cancel' => '取消',
    'can_create_root_folder' => '可以在根目录创建文件夹',
    'changelog' => '最新消息',
    'close' => '关闭',
    'complexity' => '复杂性',
    'complex_asked' => '需要复杂性',
    'complex_level0' => '很弱',
    'complex_level1' => '较弱',
    'complex_level2' => '中等',
    'complex_level3' => '较强',
    'complex_level4' => '很强',
    'complex_level5' => '超强',
    'complex_level6' => '极强',
    'confirm' => '确认',
    'confirm_del_from_fav' => '请确认从收藏中删除',
    'connections' => '连接',
    'copy' => '复制',
    'copy_to_clipboard_small_icons' => '启用项目页面中的复制到剪贴板小图标',
    'copy_to_clipboard_small_icons_tip' => 'Adds a small icon to the password item listing on the top panel which copies the password to the clipboard. A password can be copied without needing to select and load the whole item contents.',
    'date' => '日期',
    'date_format' => '日期格式',
    'delete' => '删除',
    'deletion' => '删除',
    'del_button' => '删除',
    'description' => '描述',
    'disconnect' => '登出',
    'done' => '完成',
    'duplicate_folder' => 'Folders may have duplicate names',
    'duplicate_item' => 'Items may have duplicate name',
    'email' => 'Email',
    'email_subject' => 'New password item created in password manager',
    'enable_favourites' => 'Favorites bookmark feature enabled',
    'enable_personal_folder' => '启用个人文件夹',
    'enable_personal_folder_feature' => '启用个人文件夹功能',
    'enable_user_can_create_folders' => 'Sub-folders managed by anyone who can manage parent',
    'encrypt_key' => '加密密钥',
    'errors' => '错误',
    'error_group_exist' => '此文件夹已经存在！',
    'error_html_codes' => '部分文本包含 HTML 代码！这不允许。',
    'error_item_exists' => '此项已存在！',
    'error_label' => '标签必填！',
    'error_must_enter_all_fields' => '您必须填写每个字段！',
    'error_pw' => '密码必填！',
    'error_tags' => 'Only spaces are allowed in tags',
    'error_user_exists' => '用户已存在',
    'expiration_date' => '过期时间',
    'find' => '查找',
    'forbidden_groups' => 'Denied Folders',
    'forgot_my_pw_email_sent' => '电子邮件已发送',
    'functions' => '角色',
    'gestionnaire' => '管理器',
    'god' => '管理员',
    'group' => '文件夹',
    'group_parent' => '父文件夹',
    'group_pw_duration' => 'Renewal period',
    'group_pw_duration_tip' => 'In months. Use 0 to disable.',
    'history' => '历史记录',
    'home_personal_saltkey' => '你的个人SALTKey',
    'home_personal_saltkey_label' => '输入你的个人SALTKey',
    'import_error_no_read_possible' => '无法读取该文件！',
    'import_error_no_read_possible_kp' => '无法读取该文件！它必须是一个 KeePass 文件。',
    'import_keepass_to_folder' => '选择目标文件夹',
    'index_add_one_hour' => '延长会话一小时',
    'index_change_pw_confirmation' => '确认',
    'index_expiration_in' => '会话将过期于',
    'index_get_identified' => 'Please identify yourself',
    'index_last_pw_change' => '密码更改于',
    'index_last_seen' => '上次连接于',
    'index_login' => '账号',
    'index_new_pw' => '新密码',
    'index_password' => '密码',
    'index_pw_error_identical' => '密码必须完全相同！',
    'index_pw_level_txt' => '复杂性',
    'index_session_duration' => '会话持续时间',
    'info' => '信息',
    'item_menu_copy_login' => '复制登录名',
    'item_menu_copy_pw' => '复制密码',
    'item_menu_del_from_fav' => '从收藏中删除',
    'kbs' => '知识库',
    'kb_menu' => '知识库',
    'last_items_title' => '上次见到项目',
    'ldap_extension_not_loaded' => 'The LDAP PHP extension is not loaded on the server.',
    'level' => '级别',
    'login' => '登录名（如果需要）',
    'mask_pw' => '掩码/显示密码',
    'max_last_items' => 'Recently viewed password item list size (default is 10)',
    'minutes' => '分钟',
    'name' => '名称',
    'nb_false_login_attempts' => 'Maximum login attempts before account lockout (0 to disable lockout)',
    'nb_folders' => '文件夹数量',
    'nb_items' => '项目数量',
    'new_label' => '新标签',
    'no' => '否',
    'none' => '无',
    'none_selected_text' => '未选择',
    'not_allowed_to_see_pw' => '您无权查看该项目！',
    'not_allowed_to_see_pw_is_expired' => '此项已过期！',
    'not_defined' => '未定义',
    'number_of_used_pw' => 'Number of old passwords remembered to prevent reuse (0 to disable)',
    'pages' => '页面',
    'pdf_download' => '下载文件',
    'personal_salt_key' => '您的个人加盐密钥',
    'pw' => '密码',
    'pw_generate' => '生成',
    'pw_is_expired_-_update_it' => '此项目已过期！您需要更改它的密码。',
    'pw_life_duration' => '用户密码在过期前的生命周期（单位：天，0表示禁用）',
    'readme_open' => '打开完整的自述文件',
    'read_only_account' => '只读',
    'restore' => '恢复',
    'restricted_to' => 'Restricted to',
    'restricted_to_roles' => '允许限制项目至用户和角色',
    'root' => 'Root',
    'secure' => '安全',
    'see_logs' => '参见日志',
    'settings_anyone_can_modify' => '为每个人都可以修改项目启用一个选项',
    'settings_anyone_can_modify_tip' => '<span style="font-size:11px;max-width:300px;">启用后，项目表单将添加一个复选框，使建立者可以允许任何人修改这个项目</span>',
    'settings_default_language' => '定义默认语言',
    'settings_kb' => '启用知识库 (测试版)',
    'settings_kb_tip' => '<span style="font-size:11px;max-width:300px;">在被激活时，这将添加一个您可以用来建立自己的知识库的页面。</span>',
    'settings_ldap_domain' => '域名的LDAP账户前缀',
    'settings_ldap_domain_controler' => '域控制器的 LDAP 数组',
    'settings_ldap_domain_controler_tip' => 'Specify domain controller providing the directory services. To balance queries among multiple servers, input a comma-delimited list of each server name. Example: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => '您的域的 LDAP 基点数据库',
    'settings_ldap_mode' => '启用通过 LDAP 服务器的用户验证',
    'settings_ldap_mode_tip' => '只在您有一个 LDAP 服务器并且您想使用它来进行 TeamPass 用户验证时启用它。',
    'settings_ldap_ssl' => '使用通过 SSL 的 LDAP（即 LDAPS）',
    'settings_ldap_tls' => '使用通过 TLS 的 LDAP',
    'settings_log_accessed' => '启用用户访问项目的日志',
    'settings_log_connections' => '启用用户连接数据库的日志',
    'settings_maintenance_mode' => '设置 TeamPass 至维护模式',
    'settings_manager_edit' => 'Managers may edit or delete any items they can view',
    'settings_printing' => '启用打印项目到 PDF 文件',
    'settings_printing_tip' => 'Adds an export option to the item tree menu, allowing export of entire folders to PDF or CSV. CSV passwords will be exported unencrypted, while PDF files can be password-protected.',
    'settings_restricted_to' => '启用项目上的受限制功能',
    'settings_show_description' => '在项目列表中显示描述',
    'size' => '大小',
    'tags' => '标签',
    'timezone_selection' => '选择时区',
    'time_format' => '时间格式',
    'url' => 'URL',
    'user' => '用户',
    'users_online' => '在线用户',
    'user_alarm_no_function' => '此用户无角色。',
    'yes' => '是',
    'one_time_view_item_url_box' => 'Share a one-time-view URL with a person you trust to see the password <br><br>#URL#<br><br>This link will only be visible one time, and expires #DAY#',
    'settings_api' => '启用通过 API 访问 TeamPass 的权限',
    'settings_api_tip' => 'The Application Programming Interface allows software developers to access password items in JSON format over the network.',
    'settings_api_keys_list' => '密钥列表',
    'settings_api_keys_list_tip' => 'Keys to access API. Third-party software must use a random key created here to access the JSON interface.',
    'settings_api_key' => '密钥',
    'settings_api_add_ip' => '添加新 IP',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'New sub-folders inherit permissions from parent folder',
    'subfolder_rights_as_parent_tip' => 'If enabled, each new sub-folder inherits the roles and permissions of the parent folder. Otherwise, the folder permission is assigned based on the role of the user who creates them.',
    'show_only_accessible_folders_tip' => 'By default, users see the complete tree of password item folders, even if some folders are inaccessible to the user. You may remove inaccessible folders from the view to simplify browsing.',
    'show_only_accessible_folders' => 'Hide inaccessible password folders',
    'comment' => 'Comment',
    'suggestion_menu' => 'Suggestions',
    'settings_suggestion' => '启用对只读用户的项目建议',
    'settings_suggestion_tip' => 'The suggestion feature adds a new menu and page, allowing users to create suggestions for new password items. This is useful when only managers are allowed to create password items.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP 绑定数据库',
    'settings_ldap_bind_passwd' => 'LDAP 绑定密码',
    'settings_ldap_search_base' => 'LDAP 搜索基点',
    'settings_ldap_bind_dn_tip' => 'Enter a bind DN which can access users and search in the tree. A bind DN is a credential that authenticates your access to the directory.',
    'settings_ldap_bind_passwd_tip' => 'Password for the bind DN specified above.',
    'settings_ldap_search_base_tip' => 'Root DN location for searches on the tree',
    'admin_email_server_url' => 'Customize URL for links',
    'enable_email_notification_on_user_pw_change' => 'Email user when user password is changed',
    'settings_otv_expiration_period' => 'One-time-view (OTV) links expire after XX days',
    'write' => '写入',
    'read' => '读取',
    'no_access' => '无访问权',
    'right_types_label' => 'Select the type of access on this folder for the selected group of users',
    'duplicate_item_in_folder' => 'Items in same folder may have similar names',
    'settings_roles_allowed_to_print' => '定义允许打印项目的角色',
    'settings_roles_allowed_to_print_tip' => 'Select multiple roles by holding CTRL while selecting. Members of these roles will be able to export folders to CSV or PDF if export is also enabled globally.',
    'admin_email_security' => 'SMTP 安全',
    'alert_page_will_reload' => '本页面现在将重新载入',
    'file_protection_password' => '定义文件密码',
    'expand' => '展开',
    'collapse' => '收起',
    'settings_ldap_user_attribute' => '要搜索的用户属性',
    'settings_ldap_user_attribute_tip' => 'LDAP attribute to search within for username',
    'log_user_initial_pwd_changed' => 'Initial password defined',
    'log_user_email_changed' => 'User email changed to ',
    'log_user_created' => 'User account created',
    'log_user_locked' => 'User has been locked',
    'log_user_unlocked' => 'User has been unlocked',
    'log_user_pwd_changed' => 'User password has been changed',
    'settings_default_session_expiration_time' => 'Default session expiration time',
    'settings_duo' => 'Enable DUO Security two-factor authentication',
    'settings_duo_tip' => 'Duo Security cloud-based two-factor authentication from duo.com. One-time use login passcodes via SMS, voice call, or mobile app. An account with Duo is required to use this feature. Two-factor login via Duo will be required for all non-admin users when activated.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Credentials from the Duo Security administration page for your account must be input here. Settings will be stored in the sk.php file only after pressing the save button.',
    'admin_duo_intro' => 'Input or generate Duo Security secret',
    'edit' => 'Edit',
    'user_info_locked' => 'User is currently locked.',
    'user_info_unlock_question' => 'Unlock account?',
    'user_info_lock_question' => 'Lock account?',
    'user_info_delete_question' => 'Delete account?',
    'user_info_active' => 'User is currently enabled.',
    'refresh' => 'Refresh',
    'loading' => 'Loading',
    'searching' => 'Searching ...',
    'list_items_with_tag' => 'List items with this tag',
    'no_item_to_display' => 'No items to display',
    'opening_folder' => 'Reading folder ...',
    'suggestion_notify_subject' => 'A new password item suggestion was submitted',
    'suggestion_notify_body' => 'A user has submitted a password item suggestion to the password manager. You need to accept the submission before it can be used by other users.<br>Info:<br>- Label: #tp_label#<br>- Folder: #tp_folder#<br>- User: #tp_user#<br><br>This email has been sent to all managers.',
    'error_unknown' => 'An unexpected error occurred!',
    'no_edit' => 'Write but no edit',
    'role_cannot_edit_item' => 'Cannot edit items',
    'no_delete' => 'Write but no delete',
    'role_cannot_delete_item' => 'Cannot delete items',
    'my_profile' => 'My profile',
    'starting' => 'Starting...',
    'total_number_of_items' => 'Total number of items',
    'finalizing' => 'Finalizing',
    'treating_items' => 'Processing items',
    'number_of_items_treated' => 'Number of items processed',
    'error_sent_back' => 'Next error occured',
    'full' => 'Full',
    'sequential' => 'Sequential',
    'tree_load_strategy' => 'Tree load strategy',
    'syslog_enable' => 'Log errors to <i>syslog</i> server',
    'syslog_host' => 'Syslog server name or IP address',
    'syslog_port' => 'Syslog port (default 514)',
    'error_bad_credentials' => 'Login credentials do not correspond!',
    'settings_ldap_usergroup' => 'LDAP group to search',
    'settings_ldap_usergroup_tip' => 'Enter the LDAP group in the directory where allowed user logins are stored. Example: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Enable changing password on distant server (using ssh connection)',
    'update_server_password' => 'Update server password',
    'ssh_pwd' => 'SSH password',
    'ssh_user' => 'SSH user',
    'ssh_password_frequency_change_info' => 'Select the interval between automatic server password updates (selecting 0 will disable automatic password changing).<br />Automatic password updates will only be performed if the system administrator has also configured the scheduled password update feature cron job.',
    'ssh_password_frequency_change' => 'Password change frequency (in months)',
    'ssh_scheduled_change' => 'Scheduled change',
    'ssh_one_shot_change' => 'One-time change',
    'server_password_change_enable_tip' => 'This setting adds an option in the password item to automatically change the user password on a server address listed in the url. This requires the remote UNIX server to allow username and password login via SSH. Automatic scheduled password changes can be performed after adding <i>/files/script.ssh.php</i> to crontab to run once a day on the password manager webserver.',
    'error_bad_credentials_more_than_3_times' => 'Login credentials incorrect!<br>Please wait 10 seconds before next attempt',
    'settings_ldap_object_class' => 'Class to search',
    'settings_ldap_object_class_tip' => 'LDAP class to search, such as user account or POSIX account',
    'rebuild_config_file' => 'Rebuild the configuration file',
    'rebuild_config_file_tip' => 'The configuration file contains system variables, and is used when these settings are needed before the database connection has been established. Rebuilding the configuration file saves the database values to the file, and can be done any time. The default location is ./includes/config/tp.config.php, but the file should be located outside the www directory for security.',
    'error_folder_complexity_lower_than_top_folder' => 'Subfolders must have password strength set the same or higher than parent folder',
    'new_item_email_body' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>New item \'#label\' has been created in Teampass.<br />You may access it clicking on this <a href="#link#">LINK</a>.<br/><br />Greetings.',
    'failed_logins' => 'Failed Logins',
    'error_only_numbers_in_folder_name' => 'Folder label can not be just a number. Please give your folder a name which includes letters.',
    'encrypted_data' => 'Data is encrypted in database',
    'settings_ldap_port' => 'LDAP port',
    'user_profile_agses_card_id' => 'Your Agses card id',
    'ga_flash_qr_and_login' => 'Flash this QR code with your mobile device, enter the 2Factor Authentication code and click `Enter` button.',
    'i_need_to_generate_new_ga_code' => 'I need a new QR code. Please send me by email a temporary Identication Code.',
    'settings_manager_move_item' => 'Managers can move any items they can view',
    'user_folders_rights' => 'Visible folders',
    'create_item_without_password' => 'Allow item to be created without any password defined',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Source user',
    'share_rights_destination' => 'Destination users',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Move selected Items',
    'delete_items' => 'Delete selected Items',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'suggest_password_change' => 'Suggest a password change',
    'otv_is_enabled' => 'User can propose One-Time-View links',
    'error_source_and_destination_are_equal' => 'Source and Destination cannot be the same!',
    'sending_anonymous_statistics' => 'Sending anonymous statistics',
    'favourites_option_enabled' => 'Favourites option enabled',
    'personalfolders_option_enabled' => 'Personal Folders option enabled',
    'country_statistics' => 'Worldmap usage',
    'country' => 'Country',
    'users_statistics' => 'Average number of users by instance',
    'items_all' => 'All items',
    'folders_all' => 'All folders',
    'items_shared' => 'All shared items (not including personal ones)',
    'folders_shared' => 'All shared folders (not including personal ones)',
    'items_statistics' => 'Average number of items by instance',
    'folders_statistics' => 'Average number of folders by instance',
    'administrators_number' => 'Number of Administrator users',
    'administrators_number_statistics' => 'Average number of Administrators by instance',
    'managers_number' => 'Number of Manager users',
    'managers_number_statistics' => 'Average number of Managers by instance',
    'readonly_number_statistics' => 'Average number of Read-Only users by instance',
    'readonly_number' => 'Number of Read-Only users',
    'mysql_version' => 'MySQL version',
    'php_version' => 'PHP version',
    'teampass_version' => 'Teampass version',
    'languages_used' => 'Languages used',
    'languages_statistics' => 'Most used language',
    'kb_option_enabled' => 'Knowledge Base option enabled',
    'suggestion_option_enabled' => 'Suggestion option enabled',
    'customfields_option_enabled' => 'Custom fields option enabled',
    'api_option_enabled' => 'API option enabled',
    '2fa_option_enabled' => '2FAoption enabled',
    'agses_option_enabled' => 'AGSES option enabled',
    'duo_option_enabled' => 'DUO Security option enabled',
    'ldap_option_enabled' => 'LDAP option enabled',
    'syslog_option_enabled' => 'SYSLOG option enabled',
    'stricthttps_option_enabled' => 'Strict HTTPS option enabled',
    'characteristic' => 'Characteristic',
    'current_value' => 'Current value',
    'communication_means' => 'Communication means',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'More information',
    'feature_request_canal' => 'For Feature Requests, please use',
    'bug_canal' => 'For Bugs, please use',
    'documentation_canal' => 'Complete documentation at',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'This Item has a change proposal',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revert?',
    'revert_the_database' => 'You have decided to revert the database. Please confirm?',
    'bad_psk' => 'This personal Saltkey is not correct!',
    'ldap_test_config' => 'Test current configuration',
    'ldap_test_username' => 'Username to use for testing purpose',
    'ldap_test_username_pwd' => 'Username password',
    'feature_support_canal' => 'For Support and Help, please use',
    'category' => 'Category',
    'text' => 'Text',
    'type' => 'Type',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Export',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'user_specific_right' => 'User specific right',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php 1>> /dev/null 2>&1</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',

);
