<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.1
 * @file      russian.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
return array(
    'show_user_temporary_encryption_code' => 'Отобразить код шифрования пользователя',
    'email_body_new_user' => 'Добрый день,<br><br>Данное сообщение является сгенерированным письмом от менеджера паролей Teampass.<br><br>Администратор создал для Вас учетную запись пользователя в Teampass. В следующий раз при подключении к Teampass используйте следующие учётные данные:<ul><li>Логин: #login#</li><li>Пароль: #password#</li><li>Код шифрования: #code#</li></ul><br><br><br>Удачного дня
',
    'user_password' => 'Пароль пользователя',
    'user_temporary_encryption_code' => 'Код шифрования пользователя',
    'no_email_set' => 'Электронная почта не зарегистрирована',
    'send_user_password_by_email' => 'Определите, следует ли отправлять пароль пользователя по электронной почте.<br>Если да - нажмите кнопку Отправить.<br><br>В противном случае используйте кнопку Копировать в буфер обмена, чтобы отправить его пользователю иным способом.<br>Именно Вы, будучи Администратором, несёте ответственность за надлежащий и безопасный способ передачи пароля пользователю.

',
    'admin_change_user_encryption_code_info' => 'Данная операция сбросит код шифрования этого пользователя.',
    'send_by_email' => 'Отправить письмом',
    'filters' => 'Фильтры',
    'show_user_password' => 'Отобразить пароль пользователя',
    'open_website' => 'Открыть интернет-страницу',
    'mfa_for_roles' => 'Мультифакторная авторизация требуется в Ролях',
    'mfa_for_roles_tip' => 'По умолчанию после выбора мультифакторной авторизации она включается для всех пользователей. Однако, Вы можете выбрать соответствующие роли, для которых это необходимо.<br>ЕЩЁ НЕ РЕАЛИЗОВАНО',
    'at_least_one_administrator_is_requested' => 'Требуется как минимум один администратор',
    'bad_code' => 'Неверный код',
    'generating_keys' => 'Генерация ключей',
    'this_may_take_time' => 'Это может занять пару минут',
    'disable_enable' => 'Отключить / Включить',
    'user_disable_status' => 'Установите флажок, чтобы отключить или оставьте пустым, чтобы включить',
    'help_for_launching_items_encryption' => 'Нам нужно сгенерировать базу данных ключей для Вашей учетной записи. Пожалуйста, укажите Ваш код шифрования.',
    'managed_through_ad' => 'Управляется через AD',
    'new_ldap_user_info' => 'Пожалуйста, завершите создание пользователя',
    'email_body_user_added_from_ldap_encryption_code' => 'Добрый день,<br><br>Данное сообщение является сгенерированным письмом от менеджера паролей Teampass.<br><br>Теперь у Вас есть учётная запись в Teampass. Для входа в систему Вы можете использовать свои доменные учётные данные.<br><br>При первом входе в систему от Вас потребуется ввод кода шифрования:<br><br><b>#enc_code#</b><br><br><br>Удачного дня!
',
    'settings_ldap_user_object_filter' => 'Фильтр пользовательских объектов',
    'settings_ldap_user_object_filter_tip' => 'Фильтр при выполнении поиска объектов пользовательских объектов. Примеры: (objectCategory=Person)(sAMAccountName=*)',
    'settings_ldap_additional_user_dn_tip' => 'Данное значение используется в дополнение к базовому DN при осуществлении поиска и загрузки пользователей. Если значение не указано, поиск по каталогу начнётся с базового DN. Пример: ou=Users ; cn=users',
    'settings_ldap_additional_user_dn' => 'Дополнительное имя пользователя (DN)',
    'ldap_user_has_changed_his_password' => 'Ваш доменный пароль авторизации был изменён после последнего входа в систему Teampass. Необходима адаптация персонального ключа шифрования. Пожалуйста, введите Ваш прежний и текущий пароли.',
    'provide_your_previous_password' => 'Ваш прежний пароль',
    'admin_change_user_password_info' => 'Эта операция сбросит текущий пароль выбранного пользователя.',
    'sending_email_message' => 'Отправка электронной почты пользователю, пожалуйста, ожидайте',
    'change_your_password_info_message' => 'Укажите Ваш новый пароль для аутентификации и подтвердите его.',
    'user_has_to_change_password_info' => 'Текущий используемый пароль был сгенерирован автоматически. Пожалуйста, смените его при первой же возможности в целях безопасности.',
    'ready_to_go' => 'Готов',
    'passwords_not_the_same' => 'Введённые пароли отличаются',
    'inititialization' => 'Инициализация',
    'bad_password' => 'Неверный пароль',
    'perform_checks' => 'Производится проверка',
    'email_body_temporary_encryption_code' => 'Добрый день,<br><br>Данное сообщение является сгенерированных письмом от менеджера паролей Teampass.<br><br>В вашей учетной записи были внесены некоторые изменения, которые требуют нового шифрования элементов для безопасности хранения данных. При следующем входе в систему используйте следующий код:<br><br><b>#enc_code#</b><br><br><br>Удачного дня',
    'temporary_encryption_code' => 'Ваш временный код шифрования',
    'renecyption_expected' => 'Необходимо повторное шифрование Ваших ключей для соответствия Ваших привилегий, учётной записи и прав доступа.',
    'error_no_user_in_ad' => 'Пользователь не найден в домене!',
    'error_ad_user_expired' => 'Срок действия пользователя истек!',
    'error' => 'Обнаружена ошибка',
    'hosts' => 'Хосты',
    'settings_ldap_hosts_tip' => 'The hosts option is an array of IP addresses or host names located on your network that serve an LDAP directory (seprated by a comma). You insert as many servers or as little as you would like depending on your forest (with the minimum of one of course).',
    'base_distiguished_name' => 'Базовое DN',
    'settings_ldap_bdn_tip' => 'Корневое DN, которое будет использоваться при выполнении запросов к доменному серверу. Примеры: o=example,c=com ; cn=users,dc=ad,dc=example,dc=com',
    'username' => 'Имя пользователя',
    'settings_ldap_username_tip' => 'DN пользователя, которое будет использоваться при подключении к доменному серверу. Примеры: cn=administrator,cn=users,dc=ad,dc=example,dc=com ; cn=user,dc=domain,dc=name',
    'settings_ldap_password_tip' => 'Пароль указанного выше пользователя.',
    'settings_ldap_port_tip' => 'Порт по умолчанию для LDAP без шифрования: 389, Порт по умолчанию для LDAP с шифрованием (LDAPS): 636',
    'undefined' => 'Не определено',
    'error_cannot_open_file' => 'Файл не может быть открыт',
    'provide_current_psk_and_click_launch' => 'При готовности, нажмите кнопку Запуск',
    'start' => 'Начать',
    'data_inconsistency' => 'Обнаружено несоответствие данных. Пожалуйста, перезагрузите страницу!',
    'one_time_code_expected' => 'Ожидается одноразовый код',
    'data_are_missing' => 'Ожидаемые данные отсутствуют',
    'one_time_code' => 'Одноразовый код',
    'provide_personal_one_time_code' => 'Пожалуйста, введите Одноразовый код, полученный в электронном письме',
    'change_authentification_type_to_ldap' => 'Изменить тип аутентификации на LDAP',
    'change_authentification_type_to_local' => 'Изменить тип аутентификации на локальную базу данных Teampass',
    'ldap_user_password_is_used_for_authentication' => 'Для аутентификации используется пароль пользователя в LDAP',
    'local_user_password_is_used_for_authentication' => 'Пароль пользователя в LDAP используется для аутентификации в Teampass',
    'provide_your_current_password' => 'Укажите свой текущий пароль',
    'current_password' => 'Текущий пароль',
    'password_is_not_correct' => 'Этот пароль неверен',
    'ldap_password_change_warning' => 'Your login password has changed since last connection. It is requested to re-encrypt all the keys using this new password. For this operation, please fill in the next field with your previous ldap password. The operation can take several minutes.',
    'personal_items' => 'Личные элементы',
    'logout_on_going' => 'Сеанс завершён. Воспользуйтесь новым паролем для подключения.',
    'fill_in_fields_and_hit_launch' => 'Введите необходимые данные и нажмите кнопку Запуск',
    'please_select_a_folder' => 'Пожалуйста, выберите папку',
    'user_must_have_login_and_email' => 'Пользователь должен иметь логин и почту',
    'user_has_this_role_in_teampass' => 'У пользователя есть эта роль в Teampass',
    'select_role_to_create' => 'Выберите роль для создания',
    'adding_ldap_role_to_teampass' => 'Вы можете создать роль в Teampass на основе объектов в AD. Это позволит связать пользователя с ролью в Teampass.',
    'add_user_to_role' => 'Добавьте эту роль пользователю в Teampass',
    'add_user_in_teampass' => 'Добавить пользователя в Teampass',
    'synchronized' => 'Синхронизировано',
    'output' => 'Вывод',
    'remove_install_folder' => 'Папка установки должна быть удалена',
    'list_users' => 'Список пользователей',
    'ldap_synchronization' => 'Синхронизация LDAP',
    'in_progress' => 'Выполняется',
    'clipboard_password_life_duration' => 'Задержка перед очисткой буфера обмена (в секундах)',
    'clipboard_password_life_duration_tip' => 'Позволяет определить задержку в секундах, по истечении которой пароль, скопированный в буфер обмена, будет удален из буфера браузера. Установите 0, чтобы отключить.',
    'clipboard_will_be_cleared' => 'Пароль помещён в буфер обмена. В скором времени он будет очищен...',
    'file_folder_not_accessible' => 'Папка с файлами недоступна',
    'error_missing_id' => 'Произошла ошибка. Возможно, отсутствует идентификатор.',
    'error_folder_not_allowed' => 'Выбранная папка не разрешена',
    'all_fields_mandatory' => 'Все поля обязательны для заполнения',
    'history_insert_entry' => 'Вставить в историю',
    'clear_form' => 'Очистить форму',
    'info_about_history_insertion' => 'Внимание! Эта функция позволяет вручную вставить событие в журнал истории элемента. После добавления удалить его будет невозможно. Учтите, что идентификатор вашей учетной записи будет связан с этой записью.',
    'select_all' => 'Выбрать все',
    'unselect_all' => 'Снять всё',
    'no_data_to_display' => 'Отсутствуют данные для отображения! Либо папки уже не существует, либо у Вас нет доступа к ней.',
    'server' => 'Сервер',
    'data_refreshed' => 'Данные обновлены',
    'loading_image' => 'Загрузка изображения',
    'compare_with_another_role' => 'Сравнить с другой ролью',
    'only_display_folders_to_depth' => 'Отображать папки только до глубины',
    'propagate_rights_to_descendants' => 'Передать права потомкам',
    'loading_data' => 'Загрузка данных',
    'password_overview_delay' => 'Задержка просмотра пароля',
    'password_overview_delay_tip' => 'Этот параметр позволяет определить количество секунд, в течение которых пароль будет отображаться в явном виде.',
    'select_date_showing_items_expiration' => 'Список просроченный элементов на дату',
    'renewal_page_info' => 'Данная страница позволяет определить уже истёкшие либо истекающие в ближайшее время элементы.',
    'filename' => 'Название файла',
    'exported_to_file' => 'Экспортировано в файл',
    'operation_progress' => 'Операция выполняется',
    'exporting_items' => 'Экспорт элементов',
    'select_folders_to_export' => 'Выберите папки для экспорта',
    'export_format_type' => 'Выберите формат экспорта',
    'export_items' => 'Экспорт элементов',
    'loading_item' => 'Загрузка элемента',
    'otv_message' => 'Вы можете поделиться этим элементом с другими людьми, не имеющими аккаунта в Teampass. Одноразовый просмотр позволяет Вашему гостю получить доступ к базовым полям данного элемента однократно и без аутентификации. Помните, что данная ссылка действительна в течение ##otv_expiration_period## дней. Скопируйте и передайте ссылку.',
    'no_sharekey_found' => 'Не найден ключ для этого файла и Вашей учетной записи',
    'otv_link' => 'Ссылка для одноразового просмотра',
    'one_time_view' => 'Одноразовый просмотр',
    'move_right_columns_separator' => 'Переместить разделитель столбцов вправо',
    'move_left_columns_separator' => 'Переместить разделитель столбцов влево',
    'form_presents_inconsistencies' => 'Форма содержит некоторые несоответствия. Пожалуйста, проверьте выделенные красным поля.',
    'download' => 'Скачать',
    'see' => 'See',
    'at_anyoneconmodify' => 'Модификация доступна всем',
    'disabled' => 'Выключено',
    'enabled' => 'Включено',
    'confirmation_seems_wrong' => 'Подтверждение выглядит неверным, пожалуйста, откорректируйте',
    'i_cannot_remember' => 'I cannot remember',
    'i_cannot_remember_info' => 'Данное действие невозможно откатить. Оно удалит пароли, хранящиеся в Ваших персональных элементах. Удалены будут только сами пароли. Если Вы не помните вашего персонального солевого ключа,то единственная возможность.',
    'user_has_psk_info' => 'Мы обнаружили, что у Вас имеются несколько персональных элементов, закодированных с помощью старого ключа. Этот шаг позволить повторно зашифровать данные новым ключом. Пожалуйста, введите Ваш персональный сольный ключ.',
    'files' => 'Файлы',
    'logs' => 'Журнал',
    'suggestions' => 'Предложения',
    'encryption_keys' => 'Ключи шифрования',
    'clearing_old_sharekeys' => 'Очистка старых общих ключей',
    'hit_launch_to_start' => 'Пожалуйста, нажмите кнопку Запуск для выполнения',
    'password_changed' => 'Пароль обновлён',
    'password_already_used' => 'Пароль уже использован',
    'change_login_password' => 'Изменить пароль для входа',
    'current_password_mandatory' => 'Текущий пароль обязателен',
    'objects_encryption_explanation' => 'Teampass был обновлён до новой версии, которая включает в себя новый протокол шифрования. От Вас требуется перешифрование ваших персональных элементов. Для этого необходимо ввести ваш персональный солевой ключ (PSK). После ввода нажмите кнопку Запуск и ожидайте завершения операции. Это может занять несколько минут в зависимости от количества объектов.',
    'description_has_changed' => 'Описание изменено',
    'number_of_folders_imported' => 'Количество импортированных папок',
    'number_of_items_imported' => 'Количество импортированных элементов',
    'propagate' => 'Пропагация',
    'propagate_user_rights' => 'Пропагация пользовательских прав',
    'register_new_yubiko_key' => 'Зарегистрировать новый ключ Yubico',
    'part_of_groups' => 'Part of Groups',
    'previous_value' => 'Предыдущее значение',
    'no_previous_value' => 'Нет предыдущего значения',
    'no_data_selected' => 'Данные не выбраны',
    'selected_items_to_be_imported' => 'Выбранные элементы для импорта',
    'cannot_open_file' => 'Файл не может быть открыт',
    'no_item_found' => 'Элемент не найден',
    'reading_file' => 'Чтение файла',
    'where_shall_items_be_created' => 'Где должны быть созданы предметы',
    'target_folder' => 'Целевая папка',
    'select_file' => 'Выбрать файл',
    'data_type_for_import' => 'Начните с выбора исходного типа данных для импорта.',
    'get_tips_about_importation' => 'Получить советы по процессу импорта',
    'import_new_items' => 'Импорт новых элементов',
    'csv' => 'CSV',
    'keepass' => 'Keepass',
    'for' => 'для',
    'request_access' => 'Запросить доступ к Элементу',
    'request_access_message' => 'При запросе доступа к элементу автору отправляется электронное уведомление. Автор примет или отклонит запрос, добавив вас в список ограничений для предметов. Пожалуйста, подтвердите отправку запроса по электронной почте автору.',
    'request_access_reason' => 'Укажите автору причину Вашего запроса',
    'error_provide_reason' => 'Укажите причину, по которой Вы хотите получить доступ к этому элементу',
    'need_access' => 'Нужен доступ?',
    'item_with_restricted_access' => 'Элемент с ограниченным доступом',
    'remaining_emails_to_send' => 'Оставшиеся письма для отправки',
    'mfa_flash' => 'Flash with your mobile device',
    'import' => 'Импорт',
    'export' => 'Экспорт',
    'offline' => 'Оффлайн',
    'login_attempts_identified_since_last_connection' => 'Необходимо Ваше участие. С момента последнего успешного подключения была обнаружена как минимум одна попытка входа в систему с использованием вашей учётной записи. Пожалуйста, проверьте сведения и сообщите администратору, если это были не Вы.',
    'last_login_attempts' => 'Последняя попытка входа',
    'see_detail' => 'See detail',
    'role_definition' => 'Определение роли',
    'not_yet_implemented' => 'Ещё не реализовано',
    '2factors_expected_for_admin' => 'Администратор наложил требования использования MFA для входа в систему',
    '2factors_expected_for_admin_tip' => 'По умолчанию администратор должен использовать MFA для входа в систему. Если этот параметр не включён, MFA не будет задействована, несмотря на персональные настройки любого иного пользователя.',
    'restore_done_now_logout' => 'Восстановление базы данных закончено. Необходимо переподключиться для обновления переменных сеанса.',
    'backup_and_restore' => 'Резервное копирование и восстановление',
    'explanation_for_oneshot_backup' => '',
    'explanation_for_oneshot_restore' => '',
    'perform_backup' => 'Выполнить резервное копирование',
    'perform_restore' => 'Выполнить восстановление',
    'backup_select' => 'Резервный файл',
    'choose_file' => 'Выбрать файл',
    'on_the_fly' => 'На лету',
    'scheduled' => 'Scheduled',
    'caution_on_field_encryption_change' => 'Внимание! Учитывайте, что для изменения типа шифрования потребуется парсинг всех существующих данных, чтобы изменить шифрование непосредственно в базе данных.',
    'caution_while_deleting_field' => 'Внимание! Удаление этого поля также приведет к удалению связанных данных в элементах.',
    'error_could_not_update_the_field' => 'Ошибка! Поле не может быть модифицировано. Пожалуйста, повторите после обновления страницы.',
    'caution_while_deleting_category' => 'Внимание! При удалении этой папки будут удалены все принадлежащие ей поля, а также все данные, связанные с полями.',
    'your_attention_please' => 'Your attention please',
    'all_fields_are_required' => 'Все поля обязательны',
    'position' => 'Position',
    'before' => 'Before',
    'top' => 'Top',
    'bottom' => 'Bottom',
    'field' => 'Поле',
    'configuration' => 'Конфигурация',
    'definition' => 'Описание',
    'number_of_modified_attachments' => 'Количество измененных вложений',
    'files_not_encrypted' => 'На данный момент файлы не зашифрованы. Из соображений безопасности необходимо выполнить это изменение.',
    'files_already_encrypted' => 'Файлы уже зашифрованы. Из соображений безопасности не изменяйте эти настройки.',
    'action_to_be_performed' => 'Действие, которое необходимо выполнить',
    'last_execution' => 'Последнее исполнение',
    'never_performed' => 'Никогда не было запущено',
    'launch' => 'Запуск',
    'set_of_actions' => 'Set of actions',
    'uploads' => 'Загрузки',
    'uploads_configuration' => 'Конфигурация загрузок',
    'email_configuration' => 'Конфигурация электронной почты',
    'email_configuration_test' => 'Тест конфигурации электронной почты',
    'send_a_test_email' => 'Отправить тестовое сообщение',
    'manage_emails_not_sent' => 'Управление неотправленными электронными письмами',
    'email_send_backlog' => '#nb_emails# неотправленных сообщений',
    'send_waiting_emails' => 'Send waiting emails',
    'ip' => 'IP',
    'no_data_defined' => 'No data has been defined',
    'adding_new_api_ip' => 'Добавление нового IP в белый список',
    'adding_new_api_key' => 'Добавление нового ключа API',
    'api_configuration' => 'Настройки API',
    'mfa_configuration' => 'Конфигурация MFA',
    'yubico_authentication_tip' => 'Для получения подробной информации посетите www.yubico.com.',
    'complexity_level_not_reached' => 'Уровень сложности не достигнут',
    'expected_complexity_level' => 'Ожидаемый уровень сложности',
    'your_attention_is_required' => 'Your attention is required',
    'favorite' => 'Добавить в избранное',
    'unfavorite' => 'Удалить из избранного',
    'you_need_to_select_at_least_one_folder' => 'You need to select at least a folder',
    'no_value_defined_please_fix' => 'No value defined! Please fix.',
    'apply' => 'Принять',
    'from' => 'От',
    'please_confirm_by_clicking_checkbox' => 'Please confirm by clicking the checkbox',
    'date_range' => 'Date range',
    'purge' => 'Очистка',
    'belong_of_deleted_folder' => 'Принадлежит удаленной папке',
    'highlight_selected' => 'Выделить выбранное',
    'number_of_selected_objects' => 'Количество выбранных объектов',
    'confirm_selection_restore' => 'Пожалуйста, подтвердите восстановление выбранных предметов.',
    'confirm_selection_delete' => 'Пожалуйста, подтвердите удаление выбранных элементов.',
    'refreshing' => 'Обновление',
    'empty_list' => 'Пустой список',
    'deleted_folders' => 'Удаленные папки',
    'deleted_items' => 'Удалённые элементы',
    'recycled_bin' => 'Корзина',
    'database' => 'База данных',
    'renewal' => 'Renewal',
    'renewal_delay' => 'Renewal delay',
    'please_confirm_deletion' => 'Пожалуйста, подтвердите удаление',
    'caution' => 'Внимание',
    'role_not_exist' => 'Данная роль не существует!',
    'role_can_edit_any_visible_item' => 'Роль может модифицировать все видимые элементы',
    'role_can_edit_any_visible_item_tip' => 'The normal setting is to let this checkbox unchecked. Indeed when checked, it will allow a user part of this role to edit any item the user can open which leads to an unsecure status. It should be only checked for a specific period of time and need.',
    'edit_allowed' => 'Edit allowed',
    'delete_allowed' => 'Удаление разрешено',
    'add_allowed' => 'Добавление разрешено',
    'edit_not_allowed' => 'Редактировать запрещено',
    'delete_not_allowed' => 'Удаление запрещено',
    'select_a_role' => 'Выберите роль',
    'access_rights_for_user' => 'Права доступа для пользователя',
    'logs_for_user' => 'Журналы для пользователя',
    'please_confirm' => 'Пожалуйста, подтвердите',
    'by_clicking_this_checkbox_confirm_user_deletion' => 'Установка этой галочки подтверждает удаление пользователя.',
    'fields_with_mandatory_information_are_missing' => 'Fields with mandatory information are missing',
    'enable_personal_folder_for_this_user' => 'Включить функцию Личной Папки для данного пользователя',
    'special' => 'Special',
    'administrator' => 'Администратор',
    'super_manager' => 'Менеджер Teampass',
    'manager' => 'Менеджер',
    'read_only' => 'Только чтение',
    'privileges' => 'Privileges',
    'roles' => 'Роли',
    'user_definition' => 'User definition',
    'no_selection_done' => 'No selection done',
    'tick_confirmation_box' => 'Поставьте галочку для подтверждения',
    'next_list_to_be_deleted' => 'Следующий список будет удален',
    'delete_folders' => 'Delete Folders',
    'submit' => 'Submit',
    'label' => 'Метка',
    'parent' => 'Parent',
    'password_minimal_complexity_target' => 'Минимальная сложность пароля',
    'access_right_for_roles' => 'Access rights for Roles',
    'create_without_password_minimal_complexity_target' => 'Разрешить добавление нового элемента без учёта сложности пароля',
    'edit_without_password_minimal_complexity_target' => 'Разрешить изменение элемента без учёта сложности пароля',
    'add_new_folder' => 'Добавить новую папку',
    'new' => 'New',
    'id' => 'Id',
    'mfa_short' => 'MFA',
    'mfa' => 'Мультифакторная авторизация',
    'google_2fa' => 'Двухэтапная аутентификация Google',
    'duo_security' => 'Duo Security',
    'yubico' => 'Аутентификатор Yubico',
    'website_canal' => 'Нажмите чтобы перейти на сайт TeamPass',
    '2fa_credential_not_correct' => 'Учетные данные 2FA неверны',
    'no_change_performed' => 'Изменения не произведены.',
    'password_strength' => 'Сложность пароля',
    'new_password_required' => 'Требуется новый пароль',
    'limited_search' => 'Ограниченный поиск',
    'empty_psk' => 'Не найден солевой ключ',
    'currently_no_favorites' => 'У Вас нет избранных элементов',
    'favorites' => 'Избранное',
    'confirm_item_move' => 'Вы выбрали "Перенести". Вы уверены?',
    'copy_to_clipboard' => 'Копировать в буфер обмена',
    'please_wait_while_loading' => 'Пожалуйста, подождите, идет загрузка данных',
    'defect_report' => 'Сообщить об ошибке',
    'actions' => 'Действия',
    'no_user' => 'Неверный пользователь',
    'generate_api_token' => 'Создать новый токен API',
    'upload_feature' => 'Функция загрузки',
    'profile' => 'Профиль',
    'language' => 'Язык',
    'upload_new_avatar' => 'Загрузить аватар (.png)',
    'settings' => 'Настройки',
    'created_items' => 'Созданные элементы',
    'modification_performed' => 'Произведённые изменения',
    'items_opened' => 'Открытые элементы',
    'passwords_seen' => 'Просмотренные пароли',
    'nothing_to_save' => 'Нечего сохранять',
    'notification_engaged' => 'Вы получаете уведомления об изменении элемента',
    'notification_not_engaged' => 'Вы не получаете уведомления об изменении элемента',
    'viewed_number' => 'Количество просмотров',
    'automatic_deletion_engaged' => 'Автоматическое удаление',
    'auto_update_enabled' => 'Включена функция автоматической смены пароля. Следующее изменение запланировано',
    'copy_folder' => 'Копировать папку',
    'select_source_folder' => 'Выберите папку для копирования',
    'select_destination_folder' => 'Выберите целевую папку',
    'delete_folder' => 'Удаление папки',
    'select_folder_to_delete' => 'Выберите папку для удаления',
    'folder_delete_confirm' => 'Выбранная папка и её элементы будут удалены. Отметьте галочку, чтобы подтвердить действие.',
    'json_error_format' => 'Неверный формат JSON',
    'password_cannot_be_empty' => 'Пароль не может быть пустым',
    'password_too_long' => 'Пароль слишком длинный',
    'error_no_action_identified' => 'Действия не определены',
    'ldap' => 'LDAP',
    'emails' => 'Электронные адреса',
    'backups' => 'Резервные копии',
    'api' => 'API',
    'add_folder' => 'Добавить новую папку',
    'select_folder_parent' => 'Select parent folder',
    'add' => 'Add',
    'key_is_not_correct' => 'Предоставленный ключ сеанса неверен',
    'suggestion_information' => 'Вы можете предложить автору любые изменения по этому элементу. Используйте приведенную выше форму, чтобы внести свои предложения и нажмите кнопку Выполнить, чтобы сообщить об этом автору.',
    'email_address' => 'Адрес электронной почты',
    'enter_email' => 'Введите адрес электронной почты',
    'notification' => 'Notification',
    'notify_on_change' => 'Уведомлять об изменениях',
    'notification_message' => 'Вы можете использовать этот параметр для настройки уведомлений об изменениях, касающихся этого элемента.',
    'share_item' => 'Поделиться элементом',
    'share_item_message' => 'Вы можете поделиться этим элементом. Укажите действительный адрес электронной почты и нажмите кнопку Выполнить.',
    'delete_item_message' => 'Вы решили удалить этот выбранный элемент. Необходимо подтвердить свой выбор, нажав кнопку Выполнить.',
    'warning' => 'Warning',
    'information' => 'Information',
    'perform' => 'Perform',
    'delete_item' => 'Delete item',
    'copy_item' => 'Copy item',
    'new_item' => 'New item',
    'error_not_allowed_to_edit_item' => 'У Вас нет прав для редактирования этого элемента',
    'error_not_allowed_to_access_this_folder' => 'У Вас нет доступа к данной папке',
    'error_personal_saltkey_is_not_set' => 'Ваш персональный солевой ключ не введён.',
    'provide_your_personal_saltkey' => 'Пожалуйста, введите Ваш персональный солевой ключ',
    'no_fields' => 'Ни одно поле не связано с этим элементом.',
    'uploaded' => 'загружено',
    'changes_ongoing' => 'Некоторые изменения не были сохранены. Вы подтверждаете выход без сохранения?',
    'no_file_to_upload' => 'Нет файла для загрузки',
    'add_files_and_click_start' => 'Добавьте файлы в очередь загрузки и нажмите кнопку запуска.',
    'select_files' => 'Выбрать файлы',
    'attached_files' => 'Прикрепленные файлы',
    'visible_by' => 'Виден для',
    'anounce_item_by_email' => 'Сообщите об этом элементе пользователям',
    'select_users_if_needed' => 'Выберите пользователей, если необходимо',
    'allow_item_to_be_deleted' => 'Разрешить удаление этого элемента при следующем условии',
    'item_deleted_after_being_viewed_x_times' => 'Элемент будет удален после X просмотров',
    'item_deleted_after_date' => 'Элемент будет удален после определенной даты',
    'password' => 'Пароль',
    'save' => 'Сохранить',
    'folder' => 'Папка',
    'main' => 'Main',
    'fields' => 'Поля',
    'details' => 'Подробности',
    'no_special_restriction' => 'No special restriction',
    'generate_otv_link' => 'Сгенерировать ссылку для одноразового просмотра',
    'no_custom_fields' => 'No custom fields',
    'no_attachment' => 'Нет вложений',
    'logout_confirm' => 'Logout? Please confirm.',
    'saved' => 'Saved',
    'attachments' => 'Вложения',
    'success' => 'Успех',
    'server_answer_error' => 'Произошла ошибка. Ответ сервера не может быть проанализирован!',
    'server_returned_data' => 'Возвращаемые данные',
    'version_alone' => 'версия',
    'statistics' => 'Статистики',
    'options' => 'Опции',
    'users' => 'Пользователи',
    'folders' => 'Папки',
    'find_message' => '%X% объектов найдено',
    'auto_update_server_password_info' => 'После нажатия кнопки \'Начать\' автоматически выполнятся следующие шаги:<ul><li>Подключение через SSH к серверу Linux с помощью учётных данных и поля \'URL\', </li><li>Смена пароля пользователя на Linux сервере</il><li>Сохранение нового пароля в TeamPass</il><li>Закрытие SSH соединения</li></ul><br /><b>Пожалуйста, убедитесь, что пользователь имеет привилегии суперпользователя на сервере (если нет, укажите логин и пароль суперпользователя) перед началом работы.</b>',
    'share' => 'Поделиться элементом',
    'notify' => 'Уведомления',
    'error_no_selected_folder' => 'Вы должны выбрать папку',
    'email_subject_item_updated' => '[Teampass] Отслеживаемый элемент был изменён',
    'email_body_item_updated' => 'Здравствуйте,<br /><br />Пароль для \'#item_label#\' был изменен.<br /><br />Можете проверить его <a href="#url#/index.php?page=items&group=#item_category#&id=#item_id#">по ссылке</a>',
    'import_kp_finished' => 'Импорт из файла KeePass завершен! По умолчанию, уровень сложности для новых папок установлен в \'Средний\'. Измените его на требуемый в случае необходимости.',
    'password_is_empty' => 'В элементе нет пароля',
    'bug_report_to_github' => 'Заполните содержимое отчета, затем скопируйте его в буфер обмена и вставьте его в новы отчет об ошибках на Github',
    'open_bug_report_in_github' => 'Открыть отчет об ошибке в Github',
    'bugs_page' => 'Если вы обнаружили ошибку, пожалуйста, сообщите о ней.',
    'import_csv_anyone_can_modify_in_role_txt' => 'Разрешить редактирование импортируемых элементов для всех с той же ролью.',
    'import_csv_anyone_can_modify_txt' => 'Включать "Разрешить редактирование для всех" для импортируемых элементов.',
    'settings_upload_imageresize_options' => 'Конвертировать изображения',
    'user_not_exists' => 'Пользователь не существует!',
    'auto_create_folder_role' => 'Создать папку и роль с именем',
    'start_upload' => 'Начать загрузку файлов',
    'error_upload_runtime_not_found' => 'Загрузка файлов на сервер: не найден runtime.',
    'user_profile_api_key' => 'Ваш ключ API',
    'index_change_pw' => 'Измените свой пароль',
    'admin_2factors_authentication_setting' => 'Включить двухфакторную аутентификацию Google',
    'admin_2factors_authentication_setting_tip' => 'Двухфакторная аутентификация Google добавляет еще один уровень безопасности. Когда пользователь пытается войти в TeamPass, создается QR код, который пользователь должен отсканировать, чтобы получить одноразовый пароль. Внимание: для использования этой функции необходим доступ в интернет и сканер QR кодов.',
    'admin_ga_website_name' => 'Имя для Google Authenticator',
    'admin_ga_website_name_tip' => 'Это имя используется для идентификационного кода учетной записи в Google Authenticator.',
    'api_whitelist_ips' => 'Белый список IP-адресов API',
    'api_whitelist_ips_tip' => 'Если IP-адреса клиентов API явно не указаны здесь, авторизуется любой IP-адрес.',
    'email_share_item_subject' => '[TeamPass] С вами поделились элементом',
    'email_share_item_mail' => 'Здравствуйте, #tp_user# поделился с вами элементом #tp_item# Нажмите на <a href="#tp_link#">ссылку</a>, чтобы получить доступ.',
    'index_maintenance_mode_admin' => 'Включен режим обслуживания. Пользователи не могут войти в TeamPass.',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'press_your_yubico_key' => 'Press your Yubico key',
    'human_resources' => 'Super manager',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Отправить приложение Google Authenticator на email пользователю',
    'error_no_email' => 'У пользователя не задан email!',
    'error_no_user' => 'Пользователь не найден!',
    'email_ga_subject' => 'Ваш одноразовый код Google Authenticator для TeamPass',
    'email_ga_text' => 'Здравствуйте,<br /><br />Это письмо от менеджера паролей Teampass.<br /> <br/>Администратор полагает что вы используете двухфакторную аутентификацию для подключения к Teampass.<br />Для первого подключения с двухфакторной аутентификацией, пожалуйста, используйте код, который вы найдете ниже:<br /><br />----------------------<br />#2FACode#<br />----------------------<br /><br />Затем у вас будет возможность настроить доступ с одноразовыми учетными данными для доступа к Teampass.<br /><br />Удачного дня!',
    'settings_attachments_encryption' => 'Включить шифрование файловых вложений в элементах',
    'settings_attachments_encryption_tip' => 'ЭТА НАСТРОЙКА МОЖЕТ ПОВРЕДИТЬ СУЩЕСТВУЮЩИЕ ВЛОЖЕНИЯ. Если включено, приложения к элементам хранятся на сервере зашифрованными с использованием соли заданной в TeamPass. Шифрование требует больше ресурсов сервера. ВНИМАНИЕ: после изменения настройки необходимо запустить скрипт конвертирования для уже созданных вложений. См. вкладку \'Скрипты\'.',
    'admin_action_attachments_cryption' => 'Зашифровать или расшифровать имеющиеся вложения в элементах',
    'admin_action_attachments_cryption_tip' => 'ВНИМАНИЕ: это действие можно выполнять ТОЛЬКО после изменения соответствующей настройки. На всякий случай заранее сделайте копию папки \'upload\' перед какими-либо действиями.',
    'encrypt' => 'Зашифровать',
    'decrypt' => 'Расшифровать',
    'ga_identification_code' => 'Идентификационный код',
    'ga_enter_credentials' => 'Необходимо ввести учетные данные',
    'ga_bad_code' => 'Неверный код Google Authenticator',
    'settings_get_tp_info' => 'Показывать администраторам новости и информацию о TeamPass на главной странице',
    'settings_get_tp_info_tip' => 'Когда включено, на главной странице администратора отображается информация о последних версиях, исправлениях ошибок и новостях.',
    'settings_offline_mode' => 'Разрешить автономный режим',
    'settings_offline_mode_tip' => 'Автономный режим позволяет экспортировать элементы в HTML файл, чтобы получать к ним доступ там, где нет связи с сервером TeamPass. Пароли шифруются ключом, который вводит пользователь.',
    'offline_mode_key_level' => 'Минимальная сложность ключа шифрования для автономного режима',
    'categories' => 'Категории',
    'no_category_defined' => 'Категории еще не созданы',
    'confirm_deletion' => 'Вы уверены, что хотите удалить?',
    'settings_item_extra_fields' => 'Разрешить добавлять к элементам дополнительные поля (см. Категории)',
    'settings_item_extra_fields_tip' => 'Эта функция позволяет улучшить описание элементов путем добавления дополнительных полей, которыми можно управлять в Категориях. Все данные шифруются. На каждое поле требуется выполнить дополнительно примерно 5 SQL запросов при обновлении элемента.',
    'settings_ldap_type' => 'Тип LDAP сервера',
    'server_time' => 'Время на сервере',
    'settings_tree_counters' => 'Показывать больше счетчиков в дереве папок',
    'settings_tree_counters_tip' => 'Показывает для каждой папки: число элементов в папке, число элементов во вложенных папках, число вложенных папок. Генерирует больше SQL запросов.',
    'admin_action_check_pf' => 'Обновить личные папки для всех пользователей (создает, если их не существует)',
    'enable_personal_folder_feature_tip' => 'Личные папки используются для хранения персональных паролей. Элементы в этих папках шифруются с применением личной соли (более безопасно) или паролем пользователя (менее безопасно). Включение опции не создает папки, для их создания нужно вручную запустить соответствующую задачу.',
    'administrators_only' => 'Только администраторы',
    'managers_of' => 'Менеджеры роли',
    'managed_by' => 'Управляется',
    'settings_enable_sts' => 'Включить HTTPS Strict-Transport-Security (HSTS). Внимание! См. примечание.',
    'settings_enable_sts_tip' => 'HSTS помогает предотвратить атаки SSL Man-in-the-Middle. Для использования этой опции вам нужен действительный SSL сертификат. Если у вас самоподписанный сертификат и вы включите эту опцию, то TeamPass перестанет работать! В конфигурационном файле Apache SSL необходимо добавить строку \'SSLOptions +ExportCertData\'.',
    'settings_anyone_can_modify_bydefault' => 'Включить по умолчанию <i>Разрешить редактирование для всех</i>',
    'to' => 'по',
    'settings_upload_maxfilesize_tip' => 'Максимальный разрешенный размер файла (по умолчанию 10 МБайт). Должен выбираться с учетом настроек сервера (в php.ini опции upload_max_filesize и post_max_size, значение по умолчанию зависит от версии PHP).',
    'settings_upload_docext_tip' => 'Типы документов, разрешенных для вложения. Перечислите допустимые файловые расширения через запятую (,)',
    'settings_upload_imagesext_tip' => 'Типы изображений. Перечислите допустимые файловые расширения через запятую (,)',
    'settings_upload_pkgext_tip' => 'Типы архивов. Перечислите допустимые файловые расширения через запятую (,)',
    'settings_upload_otherext_tip' => 'Другие типы. Перечислите допустимые файловые расширения через запятую (,)',
    'settings_upload_imageresize_options_tip' => 'При включении этой опции, все изображения будут конвертироваться согласно настройкам ниже.',
    'settings_upload_maxfilesize' => 'Максимальный размер файла (МБайт)',
    'settings_upload_docext' => 'Допустимые расширения документов',
    'settings_upload_imagesext' => 'Допустимые расширения изображений',
    'settings_upload_pkgext' => 'Допустимые расширения архивов',
    'settings_upload_otherext' => 'Другие допустимые расширения',
    'settings_upload_imageresize_options_w' => 'Ширина (пикселей)',
    'settings_upload_imageresize_options_h' => 'Высота (пикселей)',
    'settings_upload_imageresize_options_q' => 'Качество',
    'settings_importing' => 'Разрешить импорт из KeyPass или CVS файлов',
    'admin_proxy_ip' => 'IP адрес прокси сервера',
    'admin_proxy_ip_tip' => 'Если вы выходите в интернет через прокси сервер, то здесь нужно указать его IP адрес. Если прокси сервер не используется - оставьте пустым.',
    'admin_proxy_port' => 'Порт прокси сервера',
    'admin_proxy_port_tip' => 'Если задан IP адрес прокси сервера, укажите и его порт (напр. 8080). Если прокси сервер не используется - оставьте пустым.',
    'settings_ldap_elusers' => 'Только локальные пользователи TeamPass',
    'settings_ldap_elusers_tip' => 'Эта функция позволяет пользователям из базы осуществлять аутентификацию через LDAP. Выключите, если хотите просмотреть каталог LDAP.',
    'db_items_edited' => 'Сейчас редактируется элементов',
    'item_edition_start_hour' => 'Редактирование начато в',
    'settings_delay_for_item_edition' => 'Время, по истечении которого редактирование будет считаться неуспешным (мин.)',
    'settings_delay_for_item_edition_tip' => 'На время редактирования элемента он блокируется, чтобы не производилось параллельных правок. Это делается путем создания токена. Эта настройка позволяет удалять токен. 0 - токен никогда не будет удален (только Администратором).',
    'db_users_logged' => 'Пользователи, осуществившие вход',
    'action' => 'Действие',
    'login_time' => 'Вход осуществлен',
    'lastname' => 'Фамилия',
    'user_login' => 'Логин',
    'role' => 'Роль',
    'error_role_exist' => 'Роль уже существует!',
    'error_no_edition_possible_locked' => 'Невозможно изменить. Этот элемент уже редактируется!',
    'select' => 'Выбрать файл',
    'items' => 'Элементы',
    'enable_personal_saltkey_cookie' => 'Хранить личную соль в cookie',
    'personal_saltkey_cookie_duration' => 'Время жизни cookie личной соли (дней)',
    'admin_email_smtp_server' => 'SMTP сервер',
    'admin_email_auth' => 'SMTP сервер требует аутентификации',
    'admin_email_auth_username' => 'Имя пользователя',
    'admin_email_auth_pwd' => 'Пароль',
    'admin_email_port' => 'Порт сервера',
    'admin_email_from' => 'Email отправителя (поле from)',
    'admin_email_from_name' => 'Имя отправителя (поле from Name)',
    'admin_email_test_configuration_tip' => 'Этот тест отправляет письмо на указанный адрес. Если вы его не получили - проверьте настройки.',
    'admin_email_test_subject' => '[TeamPass] Тестовое письмо',
    'admin_email_test_body' => 'Здравствуйте, Письмо успешно отправлено.',
    'admin_email_result_ok' => 'Письмо отправлено на адрес #email# ... проверьте входящие сообщения.',
    'email_bodyalt_item_updated' => 'Пароль для #item_label# обновлен.',
    'admin_email_send_backlog_tip' => 'Этот скрипт принудительно совершает рассылку писем, скопившихся в БД. Операция может занять время в зависимости от количества скопившихся писем.',
    'please_wait' => 'Пожалуйста, подождите!',
    'admin_path_to_files_folder' => 'Путь к папке Files',
    'admin_path_to_files_folder_tip' => 'Папка для создаваемых TeamPass и загружаемых файлов. ВАЖНО: из соображений безопасности эта папка не должна находиться внутри WWW папки сайта. Её необходимо расположить в защищенном месте и настроить правила перенаправления. Рекомендуется настроить расписание (cron) по очистке этой папки.',
    'admin_path_to_upload_folder_tip' => 'Папка для хранения файлов, связанных с элементами. ВАЖНО: из соображений безопасности эта папка не должна находиться внутри WWW папки сайта. Её необходимо расположить в защищенном месте и настроить правила перенаправления. Эту папку нельзя очищать! файлы в ней связаны с элементами.',
    'pdf_password_warning' => 'Необходимо ввести ключ шифрования!',
    'admin_pwd_maximum_length' => 'Максимальная длина пароля',
    'admin_pwd_maximum_length_tip' => 'Длина пароля по умолчанию - 40 символов. Слишком большое значение может оказывать негативное влияние на производительность.',
    'settings_insert_manual_entry_item_history' => 'Разрешить ручную вставку в журнал истории элементов',
    'settings_insert_manual_entry_item_history_tip' => 'По некоторым причинам вам может понадобиться вручную добавлять записи в историю элемента. Включите эту настройку, для того чтобы это было возможно.',
    'admin_path_to_upload_folder' => 'Путь к папке Upload',
    'admin_setting_enable_delete_after_consultation' => 'Включить возможность автоматического удаления элементов по количеству просмотров',
    'admin_setting_enable_delete_after_consultation_tip' => 'Когда включено, пользователи могут задавать количество просмотров элемента, после чего он будет автоматически удален.',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Отправлять уведомление по почте при открытии элемента',
    'share_sent_ok' => 'Письмо отправлено',
    'see_item_title' => 'Подробности об элементе',
    'email_on_open_notification_subject' => '[TeamPass] Уведомление об открытии элемента',
    'email_on_open_notification_mail' => 'Здравствуйте,<br /><br />#tp_user# открыл и посмотрел элемент "#tp_item#\'".<br />Нажмите на <a href="#tp_link#">ссылку</a>, чтобы получить доступ.',
    'pdf' => 'PDF',
    'email_subject_new_user' => '[TeamPass] Создание вашей учетной записи',
    'email_new_user_mail' => 'Здравствуйте,<br /><br />Администратор создал вашу учетную запись Teampass.<br />Используйте следующие учетные данные для входа:<br />- Имя пользователя: #tp_login#<br />- Пароль: #tp_pw#<br />Нажмите на <a href="#tp_link#">ссылку</a>, чтобы получить доступ.',
    'error_empty_data' => 'Недостаточно данных для продолжения!',
    'error_not_allowed_to' => 'У вас недостаточно прав для совершения этого действия!',
    'request_access_ot_item' => 'Отправить запрос создателю элемента',
    'email_request_access_subject' => '[TeamPass] Запрос доступа к элементу',
    'email_request_access_mail' => 'Здравствуйте, #tp_item_author#,<br /><br />Пользователь #tp_user# запросил доступ к элементу \'#tp_item#\'.<br /><br />Убедитесь, что пользователь имеет право на доступ к этому элементу.',
    'admin_action_change_salt_key' => 'Сменить основную соль',
    'nb_items_by_query' => 'Количество элементов, получаемых за один запрос',
    'nb_items_by_query_tip' => 'Слишком большое количество затрудняет процесс отображения списка. Значение \'auto\' позволяет автоматически подстраиваться под размер экрана пользователя. Значение \'max\' принудительно заставляет показывать весь список сразу. Также можно задать конкретное количество элементов, загружаемых за один запрос.',
    'open_url_link' => 'Открыть на новой странице',
    'error_pw_too_long' => 'Пароль слишком большой! Максимальная длина - 40.',
    'at_restriction' => 'Ограничение',
    'pw_encryption_error' => 'Ошибка шифрования пароля!',
    'enable_send_email_on_user_login' => 'Отправлять письмо администратору, когда пользователь осуществляет вход',
    'email_subject_on_user_login' => '[TeamPass] Пользователь совершил вход',
    'email_body_on_user_login' => 'Здравствуйте,<br /><br />Пользователь #tp_user# вошел в TeamPass #tp_date# в #tp_time#.',
    'account_is_locked' => 'Учетная запись заблокирована',
    'activity' => 'Активность',
    'add_role_tip' => 'Создать роль',
    'admin' => 'Администрирование',
    'admin_action_db_backup' => 'Создать резервную копию БД',
    'admin_action_db_clean_items' => 'Удалить элементы \'сироты\' из базы данных',
    'admin_action_db_clean_items_tip' => 'Это действие удаляет элементы, которые не быди удалены после удаления своих папок. Настоятельно рекомендуется перед этим создать резервную копию.',
    'admin_action_db_optimize' => 'Оптимизировать БД',
    'admin_action_db_restore' => 'Восстановить БД',
    'admin_action_purge_old_files' => 'Очистить старые файлы',
    'admin_action_purge_old_files_tip' => 'Это удалит все временные файлы старше 7 дней.',
    'admin_action_reload_cache_table' => 'Перезагрузить Cache таблицу',
    'admin_action_reload_cache_table_tip' => 'Сбрасывает содержимое Cache таблицы. Рекомендуется запускать время от времени.',
    'admin_help' => 'Справка',
    'admin_ldap_configuration' => 'LDAP',
    'admin_main' => 'Информация',
    'admin_misc_cpassman_dir' => 'Полный путь к TeamPass',
    'admin_misc_cpassman_url' => 'Полный URL к TeamPass',
    'admin_misc_custom_login_text' => 'Собственный текст входа',
    'admin_misc_custom_logo' => 'Полный URL к собственному логотипу входа',
    'admin_misc_favicon' => 'Полный URL к файлу favicon',
    'admin_settings' => 'Настройки',
    'admin_settings_title' => 'Настройки',
    'admin_setting_activate_expiration' => 'Включить устаревание паролей',
    'admin_setting_activate_expiration_tip' => 'Когда включено, устаревшие объекты не будут показываться пользователям.',
    'admin_views' => 'Инструменты',
    'alert_message_done' => 'Готово!',
    'all' => 'все',
    'anyone_can_modify' => 'Разрешить измененение этого элемента любому, кто имеет к нему доступ',
    'at' => 'в',
    'at_category' => 'Папка',
    'at_copy' => 'Скопированные',
    'at_delete' => 'Удаление',
    'at_description' => 'Описание',
    'at_label' => 'Метка',
    'at_login' => 'Имя входа',
    'at_moved' => 'Перемещен',
    'at_personnel' => 'Личный',
    'at_restored' => 'Восстановлен',
    'at_shown' => 'Просмотренные',
    'at_url' => 'URL',
    'author' => 'Автор',
    'authorized_groups' => 'Разрешенные папки',
    'auth_creation_without_complexity' => 'Разрешить создание элементов без учета требований сложности',
    'auth_modification_without_complexity' => 'Разрешить редактирование элементов без учета требований сложности',
    'cancel' => 'Отмена',
    'can_create_root_folder' => 'Может создавать папки верхнего уровня',
    'changelog' => 'Последние новости',
    'close' => 'Закрыть',
    'complexity' => 'Минимальная сложность',
    'complex_asked' => 'Требуемая сложность',
    'complex_level0' => 'Очень слабый',
    'complex_level1' => 'Слабый',
    'complex_level2' => 'Средний',
    'complex_level3' => 'Стойкий',
    'complex_level4' => 'Очень стойкий',
    'complex_level5' => 'Тяжелый',
    'complex_level6' => 'Очень тяжелый',
    'confirm' => 'Подтвердить',
    'confirm_del_from_fav' => 'Пожалуйста, подтвердите удаление из Избранного',
    'connections' => 'Соединения',
    'copy' => 'Копировать',
    'copy_to_clipboard_small_icons' => 'Отображать значки копирования в буфер обмена для каждого элемента',
    'copy_to_clipboard_small_icons_tip' => 'Отображает для каждого элемента значки копирования имени пользователя и пароля в буфер обмена. Отключите для уменьшения нагрузки на старые компьютеры.',
    'date' => 'Дата',
    'date_format' => 'Формат даты',
    'delete' => 'Удалить',
    'deletion' => 'Корзина',
    'del_button' => 'Удалить',
    'description' => 'Описание',
    'disconnect' => 'Выход',
    'done' => 'Сделано',
    'duplicate_folder' => 'Разрешить использовать папки с одинаковыми именами',
    'duplicate_item' => 'Разрешить использовать элементы с одинаковыми именами',
    'email' => 'Email',
    'email_subject' => 'Создание нового элемента в Менеджере паролей',
    'enable_favourites' => 'Включить Избранное (создание закладок)',
    'enable_personal_folder' => 'Разрешить Личную папку',
    'enable_personal_folder_feature' => 'Включить Личные папки',
    'enable_user_can_create_folders' => 'Пользователь может управлять подпапками в разрешенных папках',
    'encrypt_key' => 'Ключ шифрования',
    'errors' => 'Ошибки',
    'error_group_exist' => 'Такая папка уже существует!',
    'error_html_codes' => 'В тексте присутствуют HTML теги! Это недопустимо.',
    'error_item_exists' => 'Такой элемент уже существует!',
    'error_label' => 'Поле \'Метка\' обязательно к заполнению!',
    'error_must_enter_all_fields' => 'Необходимо заполнить все поля!',
    'error_pw' => 'Поле \'Пароль\' обязательно к заполнению!',
    'error_tags' => 'Не допускается использовать знаки пунтуации в тегах! Только пробелы.',
    'error_user_exists' => 'Такой пользователь уже существует',
    'expiration_date' => 'Дата окончания срока',
    'find' => 'Поиск',
    'forbidden_groups' => 'Запрещенные папки',
    'forgot_my_pw_email_sent' => 'Письмо отправлено',
    'functions' => 'Роли',
    'gestionnaire' => 'Менеджер',
    'god' => 'Администратор',
    'group' => 'Папка',
    'group_parent' => 'Родительская папка',
    'group_pw_duration' => 'Период обновления',
    'group_pw_duration_tip' => 'Период обновления пароля, в месяцах (0 - бесконечно).',
    'history' => 'История',
    'home_personal_saltkey' => 'Ваша личная соль',
    'home_personal_saltkey_label' => 'Введите личную соль',
    'import_error_no_read_possible' => 'Не удалось прочесть файл!',
    'import_error_no_read_possible_kp' => 'Не удалось прочесть файл! Вероятно, это не KeePass файл.',
    'import_keepass_to_folder' => 'Выберите папку',
    'index_add_one_hour' => 'Продлить сеанс на 1 час',
    'index_change_pw_confirmation' => 'Подтверждение',
    'index_expiration_in' => 'Сеанс закончится через',
    'index_get_identified' => 'Пожалуйста, представьтесь',
    'index_last_pw_change' => 'Пароль был изменен',
    'index_last_seen' => 'Последнее подключение было',
    'index_login' => ' ',
    'index_new_pw' => 'Новый пароль',
    'index_password' => 'Пароли',
    'index_pw_error_identical' => 'Пароли должны совпадать!',
    'index_pw_level_txt' => 'Сложность',
    'index_session_duration' => 'Продолжительность сессии',
    'info' => 'Информация',
    'item_menu_copy_login' => 'Копировать логин',
    'item_menu_copy_pw' => 'Копировать пароль',
    'item_menu_del_from_fav' => 'Удалить из Избранного',
    'kbs' => 'Базы знаний',
    'kb_menu' => 'База знаний',
    'last_items_title' => 'Последние просмотренные элементы',
    'ldap_extension_not_loaded' => 'На сервере не активировано расширение LDAP.',
    'level' => 'Уровень',
    'login' => 'Логин',
    'mask_pw' => 'Скрыть/показать пароль',
    'max_last_items' => 'Размер списка последних просмотренных элементов (по умолчанию - 10)',
    'minutes' => 'мин.',
    'name' => 'Имя',
    'nb_false_login_attempts' => 'Количество неудачных попыток входа для блокировки учетной записи (0 - бесконечно)',
    'nb_folders' => 'Число папок',
    'nb_items' => 'Число элементов',
    'new_label' => 'Новая метка',
    'no' => 'Нет',
    'none' => 'Нет',
    'none_selected_text' => 'Ничего не выбрано',
    'not_allowed_to_see_pw' => 'У вас нет прав для просмотра этого элемента!',
    'not_allowed_to_see_pw_is_expired' => 'Этот элемент устарел!',
    'not_defined' => 'Не определено',
    'number_of_used_pw' => 'Количество последних паролей, на совпадение с которыми проверять новый пароль',
    'pages' => 'Страниц',
    'pdf_download' => 'Скачать файл',
    'personal_salt_key' => 'Ваша личная соль',
    'pw' => 'Пароль',
    'pw_generate' => 'Создать',
    'pw_is_expired_-_update_it' => 'Этот элемент устарел! Вы должны сменить его пароль.',
    'pw_life_duration' => 'Время жизни пароля пользователя, дней (0 - бесконечно)',
    'readme_open' => 'Смотреть файл полностью',
    'read_only_account' => 'Только чтение',
    'restore' => 'Восстановление',
    'restricted_to' => 'Ограничено для',
    'restricted_to_roles' => 'Разрешить назначать ограничения для ролей',
    'root' => 'root',
    'secure' => 'Спецсимволы',
    'see_logs' => 'Открыть журнал',
    'settings_anyone_can_modify' => 'Включить возможность установки флага <i>Разрешить редактирование для всех</i>',
    'settings_anyone_can_modify_tip' => 'Когда опция активна, становится доступен флаг в окне редактирования элемента, который позволяет создателю элемента разрешить любому пользователю изменение данного элемента.',
    'settings_default_language' => 'Язык по умолчанию',
    'settings_kb' => 'Включить Базу знаний (бета)',
    'settings_kb_tip' => 'Добавляет страницу, где вы можете создать базу знаний.',
    'settings_ldap_domain' => 'LDAP суффикс учетных записей вашего домена',
    'settings_ldap_domain_controler' => 'Список контроллеров домена LDAP',
    'settings_ldap_domain_controler_tip' => 'Укажите несколько контроллеров, если хотите, чтобы производилась балансировка LDAP запросов. Разделитель - запятая(,) Например: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'Базовое DN (Base DN) LDAP вашего домена',
    'settings_ldap_mode' => 'Включить аутентификацию через LDAP сервер',
    'settings_ldap_mode_tip' => 'Включите, чтобы осуществлять аутентификацию посредством LDAP сервера вместо внутреннего механизма аутентификации.',
    'settings_ldap_ssl' => 'Использовать LDAP через SSL (LDAPS)',
    'settings_ldap_tls' => 'Использовать LDAP через TLS',
    'settings_log_accessed' => 'Включить протоколирование просмотра элементов',
    'settings_log_connections' => 'Включить протоколирование всех подключений пользователей к базе данных',
    'settings_maintenance_mode' => 'Перевести TeamPass в режим обслуживания',
    'settings_manager_edit' => 'Менеджеры могут редактировать и удалять Элементы, разрешенные им к просмотру',
    'settings_printing' => 'Разрешить экспорт в PDF или CSV файл',
    'settings_printing_tip' => 'Когда включено, на домашней странице пользователей появится кнопка, которая позволить экспортировать в PDF файл элементы, которые он может видеть. Обратите внимание, что пароли будут сохранены в незашифрованном виде!',
    'settings_restricted_to' => 'Включить функцию ограничения доступа на уровне элементов',
    'settings_show_description' => 'Отображать описание элементов в общем списке',
    'size' => 'Размер',
    'tags' => 'Теги',
    'timezone_selection' => 'Часовой пояс',
    'time_format' => 'Формат времени',
    'url' => 'URL',
    'user' => 'Пользователь',
    'users_online' => 'пользователей в сети',
    'user_alarm_no_function' => 'У этого пользователя нет ролей!',
    'yes' => 'Да',
    'one_time_view_item_url_box' => 'Поделиться одноразовой ссылкой с человеком, которому вы доверяете:<br /><br />#URL#<br /><br />Помните, что эта ссылка будет доступна только один раз до #DAY#',
    'settings_api' => 'Разрешить доступ к элементам через API TeamPass',
    'settings_api_tip' => 'API позволяет обращаться к элементам из сторонних приложений в формате JSON.',
    'settings_api_keys_list' => 'Список ключей',
    'settings_api_keys_list_tip' => 'Ключи, с которыми разрешен доступ к TeamPass. Без действующего ключа доступ к TeamPass невозможен. Будьте очень осторожны при публикации этих ключей!',
    'settings_api_key' => 'Ключ',
    'settings_api_add_ip' => 'Добавить IP адрес',
    'settings_api_ip' => 'IP',
    'subfolder_rights_as_parent' => 'Новые подпапки наследуют права доступа родительской папки',
    'subfolder_rights_as_parent_tip' => 'Если включено, новые вложенные папки наследуют роли и разрешения от родительской. Если выключено, наследуют согласно роли создателя.',
    'show_only_accessible_folders_tip' => 'По умолчанию пользователь видит полное дерево папок, даже если он имеет доступ не ко всем папкам. Эта опция позволяет отключить показ папок, к которым пользователь не имеет доступа.',
    'show_only_accessible_folders' => 'Показывать в дереве папок только те папки, к которым пользователь имеет доступ',
    'comment' => 'Комментарий',
    'suggestion_menu' => 'Предложения',
    'settings_suggestion' => 'Разрешить пользователям с правами только чтение вносить предложения',
    'settings_suggestion_tip' => 'Предложения позволяют пользователям имеющим права "только чтение" отправлять заявки на создание или изменение элементов. Предложения утверждаются Администраторами или Менеджерами.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'DN для подключения',
    'settings_ldap_bind_passwd' => 'LDAP пароль для подключения',
    'settings_ldap_search_base' => 'LDAP область поиска',
    'settings_ldap_bind_dn_tip' => 'Укажите DN пользователя, который может подключаться к базе и осуществлять поиск.',
    'settings_ldap_bind_passwd_tip' => 'Укажите пароль DN пользователя, который может подключаться к базе и осуществлять поиск.',
    'settings_ldap_search_base_tip' => 'Ветка, от которой начинается поиск.',
    'admin_email_server_url' => 'URL сервера для ссылок в письмах',
    'enable_email_notification_on_user_pw_change' => 'Отправлять письмо пользователю при изменении его пароля',
    'settings_otv_expiration_period' => 'Время устаревания одноразовых элементов (дней)',
    'write' => 'Запись',
    'read' => 'Чтение',
    'no_access' => 'Нет доступа',
    'right_types_label' => 'Назначьте выбранной группе пользователей тип доступа для этой папки',
    'duplicate_item_in_folder' => 'Разрешить элементы с одинаковыми метками в общей папке',
    'settings_roles_allowed_to_print' => 'Определить роли которым разрешено выгружать элементы',
    'settings_roles_allowed_to_print_tip' => 'Выбранным ролям будет разрешено экспортировать элементы в файл если экспорт разрешен глобально (удерживайте CTRL для выбора нескольких ролей).',
    'admin_email_security' => 'SMTP безопасность',
    'alert_page_will_reload' => 'Сейчас страница будет перезагружена',
    'file_protection_password' => 'Указать файл паролей',
    'expand' => 'Развернуть',
    'collapse' => 'Свернуть',
    'settings_ldap_user_attribute' => 'Атрибут пользователя для поиска',
    'settings_ldap_user_attribute_tip' => 'Атрибут LDAP для поиска имени пользователя.',
    'log_user_initial_pwd_changed' => 'Первоначальный пароль задан',
    'log_user_email_changed' => 'Email пользователя изменен на ',
    'log_user_created' => 'Учетная запись пользователя создана',
    'log_user_locked' => 'Пользователь заблокирован',
    'log_user_unlocked' => 'Пользователь разблокирован',
    'log_user_pwd_changed' => 'Пароль пользователя изменен',
    'settings_default_session_expiration_time' => 'По умолчанию задержка до окончания сессии (мин.)',
    'settings_duo' => 'Использовать DUO Security для двухфакторной аутентификации пользователей',
    'settings_duo_tip' => 'Двухфакторная аутентификация пользователей может быть обеспечена с помощью DUOSecurity.com. Эта библиотека обеспечивает высокий уровень безопасности, связанной с аутентификацией пользователя.',
    'admin_duo_akey' => 'AKEY',
    'admin_duo_ikey' => 'IKEY',
    'admin_duo_skey' => 'SKEY',
    'admin_duo_host' => 'HOST',
    'settings_duo_explanation' => 'Эти учетные данные выдаются в веб приложении, которое вы создаете для TeamPass со страницы администрирования DUO Security. При нажатии на кнопку \'Сохранить\' они будут сохранены в файле sk.php.',
    'admin_duo_intro' => 'Заполнить следующие поля ожидаемыми данными',
    'edit' => 'Редактировать',
    'user_info_locked' => 'Пользователь заблокирован.',
    'user_info_unlock_question' => 'Разблокировать учетную запись?',
    'user_info_lock_question' => 'Заблокировать учетную запись?',
    'user_info_delete_question' => 'Удалить учетную запись?',
    'user_info_active' => 'Пользователь разблокирован.',
    'refresh' => 'Обновить',
    'loading' => 'Загрузка',
    'searching' => 'Поиск...',
    'list_items_with_tag' => 'Список элементов с этим тегом',
    'no_item_to_display' => 'Нет элементов для отображения',
    'opening_folder' => 'Чтение папки...',
    'suggestion_notify_subject' => '[TeamPass] Поступило новое предложение.',
    'suggestion_notify_body' => 'Здравствуйте,<br /><br />Поступило новое предложение. Вам необходимо его проверить, прежде чем другие пользователи смогут его использовать.<br />Информация о предложении:<br />- Метка: #tp_label#<br />- Папка: #tp_folder#<br />- Пользователь: #tp_user#<br /><br />Данное сообщение было отправлено всем менеджерам.',
    'error_unknown' => 'Произошла непредвиденная ошибка!',
    'no_edit' => 'Запись, но не редактирование',
    'role_cannot_edit_item' => 'Нельзя редактировать элементы',
    'no_delete' => 'Запись, но не удаление',
    'role_cannot_delete_item' => 'Нельзя удалять элементы',
    'my_profile' => 'Мой профиль',
    'starting' => 'Начинаем...',
    'total_number_of_items' => 'Всего элементов',
    'finalizing' => 'Заканчиваем',
    'treating_items' => 'Обработка элементов',
    'number_of_items_treated' => 'Количество обработанных элементов',
    'error_sent_back' => 'Произошла следующая ошибка',
    'full' => 'Полностью',
    'sequential' => 'Последовательный',
    'tree_load_strategy' => 'Стратегия загрузки дерева',
    'syslog_enable' => 'Включить журналирование ошибок на Syslog сервер',
    'syslog_host' => 'Syslog сервер',
    'syslog_port' => 'Порт syslog (по умолчанию - 514)',
    'error_bad_credentials' => 'Учетные данные не совпадают!',
    'settings_ldap_usergroup' => 'LDAP группа для поиска',
    'settings_ldap_usergroup_tip' => 'LDAP группа, в которой должен находится пользователь чтобы войти. Например: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Включить смену пароля на удалённом сервере (используя SSH соединение)',
    'update_server_password' => 'Обновить пароль сервера',
    'ssh_pwd' => 'SSH пароль',
    'ssh_user' => 'SSH пользователь',
    'ssh_password_frequency_change_info' => 'Возможно вы захотите чтобы это выполнялось автоматически с определенным интервалом. Для этого вам необходимо выбрать интервал с которым пользовательские пароли на сервере должны быть изменены (выберите 0 для отключения задачи). Обратите внимание, это будет работать только если администратор включил задачу в расписании сервиса cron.',
    'ssh_password_frequency_change' => 'Интервал изменения пароля (в месяцах)',
    'ssh_scheduled_change' => 'Запланированное изменение',
    'ssh_one_shot_change' => 'Однократное изменение',
    'server_password_change_enable_tip' => 'Данная опция разрешает пользователям автоматически изменять пароль пользователя на сервере, расположенном в поле URL с помощью соединения SSH. Обратите внимание, автоматическое изменение с определенным интервалом может производится если файл <i>/files/script.ssh.php</i> добавлен в crontab этого сервера. Рекомендуется запускать его один раз в день.',
    'error_bad_credentials_more_than_3_times' => 'Неверные учетные данные! Пожалуйста, подождите 10 секунд прежде чем попробовать снова.',
    'settings_ldap_object_class' => 'Класс для поиска',
    'settings_ldap_object_class_tip' => 'LDAP класс для поиска, например Имя человека или posixAccount',
    'rebuild_config_file' => 'Перестроить конфигурационный файл',
    'rebuild_config_file_tip' => 'Конфигурационный файл содержит настройки, которые необходимы для подключения к БД. Процедура перестройки выполняет запись конфигурационных переменных, хранящихся в БД, в конфигурационный файл и может быть выполнена в любой момент. По умолчанию файл конфигурации находится по адресу ./includes/config/tp.config.php, но в целях безопасности рекомендуется, чтобы он находился вне папки www.',
    'error_folder_complexity_lower_than_top_folder' => 'Необходимо задать сложность пароля равной или большей, чем у родительской папки',
    'new_item_email_body' => 'Здравствуйте,<br /><br />В Teampass был создан новый элемент \'#label\'.<br />Вы можете получить к нему доступ, перейдя по <a href="#link#">ссылке</a>.<br/><br />Удачного дня!',
    'failed_logins' => 'Неудачных попыток входа',
    'error_only_numbers_in_folder_name' => 'Имя папки не может состоять только из цифр. Пожалуйста, придумайте имя содержащее буквы.',
    'encrypted_data' => 'Данные в БД зашифрованы',
    'settings_ldap_port' => 'Порт LDAP',
    'user_profile_agses_card_id' => 'ID вашей AGSES карты',
    'ga_flash_qr_and_login' => 'Отсканируйте этот QR код вашим мобильным устройством, введите секретный код двухфакторной аутентификации и нажмите кнопку \'Войти\'.',
    'i_need_to_generate_new_ga_code' => 'Мне нужен новый QR код. Пожалуйста, отправьте мне на email временный идентификационный код.',
    'settings_manager_move_item' => 'Менеджеры могут перемещать любые элементы, которые они видят',
    'user_folders_rights' => 'Видимые папки',
    'create_item_without_password' => 'Разрешить создание элемента без пароля',
    'share_rights_info' => 'Это диалоговое окно позволяет вам делиться правами пользователя донора с выбранными пользователями получателями. Обратите внимание на то, что у выбранных пользователей будут сброшены существующие права и заменены на права пользователя донора.',
    'share_rights_source' => 'Пользователь донор',
    'share_rights_destination' => 'Пользователи получатели',
    'ga_reset_by_user' => 'Пользователь может сбросить свой код двухфакторной аутентификации',
    'ga_reset_by_user_tip' => 'Если включено, пользователь может сбросить свой код двухфакторной аутентификации используя ссылку на странице входа в систему. Это может быть полезно в случае, когда он поменял мобильное устройство. Если выключено, пользователь должен будет обратиться к администратору, чтобы сгенерировать новый код.',
    'enable_massive_move_delete' => 'Разрешить пользователю операции массового перемещения и удаления',
    'enable_massive_move_delete_tip' => 'Когда включено, пользователю разрешены операции массового перемещения и/или удаления. Пользователь сможет выполнять их над элементами, для которых ему выданы разрешения.',
    'mass_operation' => 'Массовая операция над объектами',
    'move_items' => 'Переместить выбранные элементы',
    'delete_items' => 'Удалить выбранные объекты',
    'you_decided_to_move_items' => 'Вы решили переместить объекты',
    'you_decided_to_delete_items' => 'Вы решили удалить объекты',
    'suggest_password_change' => 'Предложить изменение пароля',
    'otv_is_enabled' => 'Пользователь может делиться одноразовыми ссылками',
    'error_source_and_destination_are_equal' => 'Исходная папка и папка назначения не могут быть одинаковыми',
    'sending_anonymous_statistics' => 'Отправка анонимной статистики',
    'favourites_option_enabled' => 'Избранное включено',
    'personalfolders_option_enabled' => 'Личные папки включены',
    'country_statistics' => 'Мировая карта пользователей',
    'country' => 'Страна',
    'users_statistics' => 'Среднее количество пользователей на инсталляцию',
    'items_all' => 'Всего элементов',
    'folders_all' => 'Всего папок',
    'items_shared' => 'Элементов, к которым предоставлен доступ (не включая личные)',
    'folders_shared' => 'Папок, к которым предоставлен доступ (не включая личные)',
    'items_statistics' => 'Среднее количество элементов на инсталляцию',
    'folders_statistics' => 'Среднее количество папок на инсталляцию',
    'administrators_number' => 'Количество администраторов',
    'administrators_number_statistics' => 'Среднее количество администраторов на инсталляцию',
    'managers_number' => 'Количество менеджеров',
    'managers_number_statistics' => 'Среднее количество менеджеров на инсталляцию',
    'readonly_number_statistics' => 'Среднее количество пользователей с правами только на чтение на инсталляцию',
    'readonly_number' => 'Количество пользователей с правами только на чтение',
    'mysql_version' => 'Версия MySQL',
    'php_version' => 'Версия PHP',
    'teampass_version' => 'Версия TeamPass',
    'languages_used' => 'Используемые языки',
    'languages_statistics' => 'Наиболее часто используемый язык',
    'kb_option_enabled' => 'База знаний включена',
    'suggestion_option_enabled' => 'Предложения включены',
    'customfields_option_enabled' => 'Дополнительные поля включены',
    'api_option_enabled' => 'Доступ к элементам через API включен',
    '2fa_option_enabled' => 'Двухфакторная аутентификация включена',
    'agses_option_enabled' => 'AGSES аутентификация включена',
    'duo_option_enabled' => 'DUO Security аутентификация включена',
    'ldap_option_enabled' => 'LDAP аутентификация включена',
    'syslog_option_enabled' => 'Журналирование на syslog сервер включено',
    'stricthttps_option_enabled' => 'HTTP Strict-Transport-Security включено',
    'characteristic' => 'Характеристика',
    'current_value' => 'Текущее значение',
    'communication_means' => 'Контакты и обратная связь',
    'consider_a_donation' => 'Вы можете сделать пожертвование',
    'more_information' => 'Больше информации',
    'feature_request_canal' => 'Для запроса новых функций, пожалуйста, используйте',
    'bug_canal' => 'Для сообщений об ошибках, пожалуйста, используйте',
    'documentation_canal' => 'Полная документация на',
    'sending_anonymous_statistics_details' => 'Статистика необходима, чтобы улучшить Teampass, с помощью информации об использовании и количестве пользователей. Данные, которые вы предоставите, будут использоваться только для внутреннего анализа данных и не будут распространяться или продаваться третьим лицам.',
    'item_has_change_proposal' => 'Для этого элемента есть предложения по изменению',
    'check_data_after_reencryption' => 'Пожалуйста, проверьте данные. Во время этой операции была создана новая таблица <b>Backup</ b>, позволяющая произвести восстановление.',
    'revert' => 'Восстановить?',
    'revert_the_database' => 'Вы решили восстановить базу данных. Подтверждаете?',
    'bad_psk' => 'Личная соль введена некорректно!',
    'ldap_test_config' => 'Протестировать текущую конфигурацию',
    'ldap_test_username' => 'Имя пользователя для тестирования',
    'ldap_test_username_pwd' => 'Пароль пользователя',
    'feature_support_canal' => 'Для получения поддержки и справки, пожалуйста, используйте',
    'category' => 'Категория',
    'text' => 'Текст',
    'type' => 'Тип',
    'data_is_masked' => 'Данные скрыты',
    'at_export' => 'Экспорт',
    'settings_ldap_allowed_usergroup' => 'допустимая группа пользователей LDAP',
    'settings_ldap_allowed_usergroup_tip' => 'Укажите, что группе LDAP разрешено подключаться к Teampass. Оставьте его пустым, никаких ограничений в отношении членства в группе не ожидается.',
    'error_security_level_not_reached' => 'Требуемый уровень безопасности не достигнут!',
    'personal_saltkey_security_level' => 'Минимальный уровень безопасности персональной соли',
    'settings_disable_forgot_password_link' => 'Скрыть ссылку на забытый пароль на главной странице',
    'newly_created_user_is_administrated_by' => 'На давно созданный пользователь администрируется',
    'settings_ldap_and_local_authentication' => 'Локальные и LDAP пользователи',
    'settings_ldap_and_local_authentication_tip' => 'Включите эту опцию, чтобы разрешить пользователям, прошедшим проверку подлинности, в LDAP или в локальном списке пользователей Teampass.',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Секунд до автоматического входа:',
    'newly_created_user_role' => 'Созданный пользователь имеет роль',
    'email_debug_level' => 'Выберите уровень отладки',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Команды клиента и ответы сервера',
    'email_debug_connection' => 'Команды клиента, ответы сервера и состояние соединения',
    'email_debug_low_level' => 'Вывод данных низкого уровня, все сообщения',
    'email_debug_level_usage' => 'Этот параметр должен быть выключен. Используйте данную настройку только при необходимости отладки электронной почты в процессе тестирования. При включении будут выводиться команды отправки писем.',
    'email_body_temporary_login_password' => 'Добрый день,<br><br>Данное сообщение является сгенерированных письмом от менеджера паролей Teampass.<br><br>Администратор изменил ваш пароль для входа в Teampass. При следующем входе в систему используйте следующий пароль:<br><br><b>#enc_code#</b><br><br><br>Удачного дня',
    'your_new_password' => 'Ваш новый пароль',
    'user_specific_right' => 'Специальное право пользователя',
    'icon' => 'Иконка',
    'icon_on_selection' => 'Иконка при выборе',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in Free and Solid icons. Leave empty for default icon.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Предыдущий используемый для авторизации в Teampass пароль',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable background tasks with cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS',
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php 1>> /dev/null 2>&1</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'bad_duo_mfa' => 'Bad DUO code',
    'creation_date' => 'Creation date',
    'never' => 'Never',
    'loading_main_page' => 'Please wait, loading main page ...',
    'alert_session_not_consistent' => 'Current session is not consistent and needs to be refreshed. The page will reload.',
    'link' => 'Link',
    'error_not_allowed_to_authenticate' => 'You are not allowed to authenticate',
    'enable_tasks_log' => 'Enable cron job log',
    'enable_tasks_log_tip' => 'Permits to log all tasks performed by the cron job inside table <i>processes_log</i>. Could be useful for checking events.',
    'items_and_folders_statistics' => 'Items and folders statistics',
    'item_copying' => 'Item is being copied',
    'upgrade_requested' => 'Teampass database is not up to date.',
    'upgrade_requested_more' => 'Some inconsistencies have been identified between files and configuration, Your administrator should perform upgrade process before you continue.',
    'settings_ldap_group_object_filter' => 'LDAP group object filter',
    'settings_ldap_group_object_filter_tip' => 'LDAP filter to use to find the group object. For example: (objectClass=group1)(objectClass=group2)',
    'settings_ad_users_with_ad_groups' => 'AD user roles mapped with their AD groups',
    'settings_ad_users_with_ad_groups_tip' => 'Permits to map AD user roles with their AD groups. Those roles will be added to the one defined in their profile.',
    'settings_ad_user_auto_creation' => 'AD user to get created automatically',
    'settings_ad_user_auto_creation_tip' => 'Permits an AD user to get automatically created in Teampass when he logs in for the first time. Notice that if option AD user roles mapped with their AD groups enabled then he will get the roles mapped with his AD groups.',
    'settings_ldap_guid_attibute' => 'LDAP GUID attribute',
    'settings_ldap_guid_attibute_tip' => 'LDAP attribute to use to identify the GUID of an object. For example: objectGUID, objectSid, GUID, gidNumber, ...',
    'ad_group' => 'AD group',
    'mapped_with_role' => 'Mapped with role',
    'ad_groupe_and_roles_mapping' => 'AD group and roles mapping',
    'select_adgroup_mapping' => 'Select the role to map with current AD group',
    'enable_backlog_mail' => 'Enable sending backlog emails',
    'provide_label' => 'Provide a label',
    'uploading' => 'Uploading...',
    'keys_encryption_not_ready' => 'Be informed that your password keys are currently in process of being created. Please wait a few minutes more.',
    'account_not_ready' => 'Account in construction',
    'add_new_job' => 'Add new job',
    'tasks_cron_not_running' => 'Cron job is not set. Please edit crontab with your server user (usually www-data) with command <code>crontab -u www-data -e</code>.<br>Or press the button to try its creation automatically.',
    'tasks_cron_running' => 'Cron job is correctly set',
    'currently_using_version' => 'Current version loaded',
    'git_commit_value' => 'Git commit value',

);
