<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @version   3.0.1
 * @file      arabic.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009 - 2022 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */
global $LANG;
$LANG = array(
    'user_keys_management' => 'User keys management',
    'sending_emails' => 'Sending emails',
    'task_frequency' => 'Frequency (in minutes)',
    'tasks_information' => 'Task relies on a dedicated cron job. For this, it is requested to add a new entry to your crontab to run Teampass scheduler every minute.<br>Next entry to be added:<br><code>* * * * * path/to/phpbin #teampass_path#/sources/scheduler.php 1>> /dev/null 2>&1</code><br><br>Note: please adapt the path to php bin (in most cases, it can be replaced by <code>php</code>).',
    'sync_new_ldap_password' => 'Synchronize new password',
    'error_new_ldap_password_detected' => 'It seems your password has changed and Teampass requires it to encrypt your master private key.',
    'settings_ldap_tls_certifacte_check' => 'Certificate check for LDAP TLS', 
    'settings_ldap_tls_certifacte_check_tip' => 'Specifies the certificate checking strategy. <a href="https://gist.github.com/heiglandreas/8a299a6f47a13ba463c3f2da41c679f7" target="_blank">More information</a>.',
    'generate_new_otp' => 'Generate new OTP',
    'generate_new_otp_informations' => 'This operation consists in generating from scratch all keys for the selected user. As a consequence, the user will have to provide the new generated OTP at next login.',
    'html' => 'html',
    'execution_time' => 'Execution time',
    'maximum_number_of_items_to_treat' => 'Maximum number of items to treat during one cycle',
    'maximum_number_of_items_to_treat_tip' => 'In order to ensure the completion of the script without timeout, it is possible to define a personnal value.',
    'maximum_time_script_allowed_to_run' => 'Duration in seconds allowed for the script to run in background',
    'maximum_time_script_allowed_to_run_tip' => 'By default, the PHP script cannot run more than the duration defined by max_execution_time parameter in php.ini file. The goal here is to define a more higher value to ensure that the script is performing completely.',
    'refresh_data_every_on_screen' => 'Screen refreshing period (in seconds)',
    'refresh_data_every_on_screen_tip' => 'When browsing the tasks view, this permits to have an updated list based.',
    'refreshed' => 'Refreshed',
    'process_details' => 'Process details',
    'created_at' => 'Created at',
    'updated_at' => 'Updated at',
    'finished_at' => 'Finished at',
    'tasks_manager' => 'Tasks manager',
    'tasks' => 'Tasks',
    'task_in_progress_user_not_active' => 'Tasks in progress - User not active',
    'enable_tasks_manager' => 'Enable heavy tasks to be performed by cron manager',
    'enable_tasks_manager_tip' => 'This option should be enabled if you noticed that some tasks take long time. This permits to enable to handle those tasks using a background job performed by server cron manager. See documentation for more details.',
    'settings_api_token_duration' => 'JWT token expiration delay (in seconds)',
    'settings_api_token_duration_tip' => 'Delay during wich the generated JWT token is valid. After this delay, it is requested to post an authorize request to the API.',
    'show_encryption_code_to_admin' => 'This is the encrypted code the user will need on this logon. You have asked to see it, please copy it and share in a secure way. Code is',
    'previous_password' => 'Previous password used to connect to Teampass',
    'icon' => 'Icon',
    'icon_on_selection' => 'Icon on selection',
    'fontawesome_icon_tip' => 'You can specify a Font Awesome icon code selected in <a href="https://fontawesome.com/v5.15/icons?d=gallery&p=2&s=solid&m=free" target="_blank">Free and Solid icons</a>. Leave empty for default icon.',
    'user_specific_right' => 'User specific right',
    'email_debug_level' => 'Select a debug level',
    'email_debug_client' => 'Client commands',
    'email_debug_server' => 'Client commands and server responses',
    'email_debug_connection' => 'Client commands, server responses and connection status',
    'email_debug_low_level' => 'Low-level data output, all messages',
    'email_debug_level_usage' => 'This setting should be set to None. Only to be used for email debuging during testing purpose. When enabled, it will permit to show an output of the email commands.',
    'email_body_temporary_login_password' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has changed your login password for Teampass. Next time you will connect to Teampass, please use the next one:<br><br><b>#enc_code#</b><br><br><br>Cheers',
    'your_new_password' => 'Your new password',
    'filter' => 'Filter',
    'upload_empty_file' => 'Upload empty file',
    'upload_any_extension_file' => 'Upload any extension file',
    'upload_any_extension_file_tip' => 'When enabled, this option will allow users to upload any kind of files.',
    'log_in' => 'Log In',
    '2fa_authentication_selector' => 'Select a 2 factor authenticator method',
    'create_item_based_upon_template' => 'Use of template for Item',
    'create_item_based_upon_template_tip' => 'When enabled, this feature permits the author to select a template made of Custom Fields. Notice that this feature requires Custom Fields to be enabled too.',
    'main_template' => 'Use as template',
    'is_mandatory' => 'Is mandatory',
    'error_field_is_mandatory' => 'At least one mandatory field is empty',
    'position_in_list' => 'Position in list',
    'visible_by' => 'Visible by',
    'restrict_visibility_to' => 'Restrict visibility to',
    'every_roles' => 'Every roles',
    'masked_textarea' => 'Masked textarea',
    'position_in_list' => 'Position in list',
    'masked_text' => 'Masked text',
    'textarea' => 'Textarea',
    'data_is_textarea' => 'Data is Textarea',
    'provide_yubico_identifiers' => 'Please provide your Yubico identifiers',
    'admin_yubico_authentication_setting' => 'Enable Yubico authentication',
    'yubico_user_id' => 'Client ID',
    'press_your_yubico_key' => 'Press your Yubico key',
    'yubico_user_key' => 'Secret KEY',
    'yubico_bad_code' => 'Wrong Yubico information',
    'show_yubico_info_form' => 'Show Yubico user information form',
    'human_resources' => 'Super manager',
    'login_attempts' => 'Login attempts since last successful connection',
    'settings_secure_display_image' => 'Enable secure image display',
    'settings_secure_display_image_tip' => 'Secure image display permits to read the image through PHP when a user previews an image attached to an item. Pro: the attachment is stored outside the site folder and is not accessible by a hacker. Con: it is slightly slower than previewing directly from an url.',
    'user_ga_code' => 'Email Google Authentication to user',
    'send_ga_code' => 'Set and email Google Authentication code',
    'error_no_email' => 'This user has no email address set!',
    'error_no_user' => 'User not found!',
    'email_ga_subject' => 'Your Google Authenticator one-time code for TeamPass',
    'email_ga_text' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your administrator is expecting you to use TwoFactor authentication to get connected to Teampass.<br>For your first connection to Teampass with TwoFactor, please use the code you will find below in the "Identication code" field:<br><br>----------------------<br>#2FACode#<br>----------------------<br><br>You will then have the opportunity to set up your one-time credentials for Teampass password manager.<br><br>Greetings',
    'settings_attachments_encryption' => 'Encrypt file attachments',
    'settings_attachments_encryption_tip' => 'If enabled, items attachments are encrypted on the server with the system salt key. Encryption requires more server resources. -- Warning! -- Changing this option could break existing file attachments! After changing this setting, you must run the task to encrypt or decrypt existing file attachments.',
    'admin_action_attachments_cryption' => 'Encrypt or decrypt all file attachments',
    'admin_action_attachments_cryption_tip' => 'Warning: Only encrypt or decrypt files after changing attachment encryption settings to match. Select whether to encrypt or decrypt, then press start. Make a backup of the upload folder before running this function.',
    'encrypt' => 'Encrypt',
    'decrypt' => 'Decrypt',
    'admin_ga_website_name' => 'Name displayed in Google Authenticator for Teampass',
    'admin_ga_website_name_tip' => 'This name is used for the identification code account in Google Authenticator.',
    'admin_action_pw_prefix_correct' => 'Repair password prefix',
    'admin_action_pw_prefix_correct_tip' => 'Please backup the database before performing this task. This script will perform an update of password prefix in database. Only run this to fix incorrectly displayed passwords after upgrading from older versions.',
    'items_changed' => 'have been changed.',
    'ga_not_yet_synchronized' => 'Get identified with Google Authenticator',
    'ga_scan_url' => 'Please scan this QR code with your mobile Google Authentication app. Use the identification code to log in.',
    'ga_identification_code' => 'Identification code',
    'ga_enter_credentials' => 'You need to enter your login credentials',
    'ga_bad_code' => 'The Google Authenticator code is wrong',
    'settings_get_tp_info' => 'Show software news and information to admins',
    'settings_get_tp_info_tip' => 'When enabled, information such as current software versions, bug fixes, and release news is displayed on the administrator info page from remote servers.',
    'at_field' => 'Field',
    'category_in_folders_title' => 'Shown in folders',
    'category_in_folders' => 'Select folders which will use this custom field category',
    'select_folders_for_category' => 'Select the folders to associate to this category of fields',
    'offline_mode_warning' => 'Offline mode allows you to export an HTML file with password items, so you may access them when not connected to Teampass server. The passwords are encrypted by a key you supply.',
    'offline_menu_title' => 'Offline mode',
    'settings_offline_mode' => 'Offline mode HTML export enabled',
    'settings_offline_mode_tip' => 'Offline mode creates a standalone HTML web page that can be downloaded to a computer. The items in the offline page are encrypted with a user-specified password when created.',
    'offline_mode_key_level' => 'Offline minimum encryption security',
    'categories' => 'Custom Fields',
    'new_category_label' => 'New category name',
    'no_category_defined' => 'No categories have been created.',
    'confirm_deletion' => 'You have selected delete... are you sure?',
    'confirm_rename' => 'Confirm rename?',
    'new_field_title' => 'Enter the title of the new field',
    'confirm_creation' => 'Confirm creation?',
    'confirm_moveto' => 'Confirm moving field?',
    'for_selected_items' => 'Edit category or label (select item above)',
    'move' => 'Move to',
    'field_add_in_category' => 'Add new custom field label',
    'rename' => 'Rename',
    'settings_item_extra_fields' => 'Custom item fields enabled',
    'settings_item_extra_fields_tip' => 'Enables another tab when creating password items, which contains custom fields for other types of data. An administrator must first create categories and the custom field labels to be displayed in those categories. This feature consumes more server resources.',
    'html' => 'html',
    'more' => 'More',
    'save_categories_position' => 'Save category order',
    'reload_table' => 'Reload table',
    'settings_ldap_type' => 'LDAP server type',
    'use_md5_password_as_salt' => 'Use login password as personal salt key (easier, less secure)',
    'server_time' => 'Server time',
    'settings_tree_counters' => 'Show more counters in folder tree',
    'settings_tree_counters_tip' => 'Enabling shows three numbers next to each folder: number of items in base folder; number of items including subfolders; number of subfolders. Enabling this feature may slow loading of the folder tree pane.',
    'settings_encryptClientServer' => 'Client-server exchanges are encrypted',
    'settings_encryptClientServer_tip' => 'AES-256 encryption to the web server is enabled by default. This secures communication even if HTTPS with an SSL certificate is not set up. If you are using exclusively https or are on a private network, disabling might be safe and increase performance.',
    'error_group_noparent' => 'No parent has been selected!',
    'channel_encryption_no_iconv' => 'Extension ICONV is not loaded! Encryption can\'t be initiated!',
    'channel_encryption_no_bcmath' => 'Extension BCMATH is not loaded! Encryption can\'t be initiated!',
    'admin_action_check_pf' => 'Create personal folders for all users without one',
    'admin_actions_title' => 'Tasks',
    'enable_personal_folder_feature_tip' => 'Personal folders are a private location for individual user passwords. Password items are encrypted by a user\'s salt key (more secure) or by their password (easier). Enabling this feature does not create the actual folders for existing users - you must also run the create personal folders task.',
    'is_administrated_by_role' => 'User is administrated by',
    'administrators_only' => 'Administrators only',
    'managers_of' => 'Managers of role',
    'managed_by' => 'Managed by',
    'admin_small' => 'Admin',
    'setting_can_create_root_folder' => 'Root-level folder creation by users enabled',
    'settings_enable_sts' => 'HTTPS Strict Transport Security (HSTS) <strong>Warning</strong>: read tooltip!',
    'settings_enable_sts_tip' => 'Warning! This will enforce the HTTPS strict transport security (STS) policy. STS helps prevent man-in-the-middle attacks. You must have a SSL certificate issued from a certificate authority (CA) installed before enabling this option!  A self-signed certificate will not work! Any future web connections will require HTTPS. You must have \'SSLOptions +ExportCertData\' in the Apache SSL configuration.',
    'channel_encryption_no_gmp' => 'Extension GMP is not loaded! Encryption can\'t be initiated!',
    'channel_encryption_no_openssl' => 'Extension OPENSSL is not loaded! Encryption can\'t be initiated!',
    'channel_encryption_no_file' => 'No encryption key file was found! Please use upgrade script.',
    'admin_action_generate_encrypt_keys' => 'Generate new encryption keys used for secure communication',
    'admin_action_generate_encrypt_keys_tip' => 'Occasionally creating a new key pair may enhance security',
    'settings_anyone_can_modify_bydefault' => '<i>Anyone can modify</i> option selected by default',
    'channel_encryption_in_progress' => 'Encrypting channel ...',
    'channel_encryption_failed' => 'Authentication failed!',
    'purge_log' => 'Purge logs from',
    'to' => 'to',
    'purge_now' => 'Purge Now!',
    'purge_done' => 'Purge done! Number of elements deleted: ',
    'settings_upload_maxfilesize_tip' => 'Maximum file size allowed when uploading an attachment or other file (in megabytes, default setting 10 MB). You also may need to change your php.ini settings upload_max_filesize and post_max_size, the default is often just 2 MB.',
    'settings_upload_docext_tip' => 'List the file extensions for text and word processor files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_imagesext_tip' => 'List the file extensions for image files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_pkgext_tip' => 'List the file extensions for compressed archive files you will allow as attachment uploads. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_otherext_tip' => 'List any other file extensions you will permit to be uploaded as attachments. Indicate the file extensions allowed separated with a comma (,)',
    'settings_upload_imageresize_options_tip' => 'Resize large uploaded pictures (set maximum dimensions in pixels). Images larger than 1000 pixels wide may not display well in the web browser.',
    'settings_upload_maxfilesize' => 'Maximum attachment size',
    'settings_upload_docext' => 'Document extensions allowed',
    'settings_upload_imagesext' => 'Image extensions allowed',
    'settings_upload_pkgext' => 'Archive extensions allowed',
    'settings_upload_otherext' => 'Other extensions allowed',
    'settings_upload_imageresize_options' => 'Resize uploaded images',
    'settings_upload_imageresize_options_w' => 'Maximum image width',
    'settings_upload_imageresize_options_h' => 'Maximum image height',
    'settings_upload_imageresize_options_q' => 'JPEG image quality',
    'admin_upload_title' => 'Uploads',
    'settings_importing' => 'Import from KeePass or CSV files enabled',
    'admin_proxy_ip' => 'Proxy server IP address',
    'admin_proxy_ip_tip' => 'If you require a proxy server to connect to the Internet, set the IP address here. Otherwise, leave blank.',
    'admin_proxy_port' => 'Proxy server port',
    'admin_proxy_port_tip' => 'If you require a proxy server to connect to the Internet, set the port number here.',
    'settings_ldap_elusers' => 'Teampass local users only',
    'settings_ldap_elusers_tip' => 'This feature allows users in the database to authenticate via LDAP. Disable this if you want to browse any LDAP directory.',
    'error_role_complex_not_set' => 'You must set the required passwords strength!',
    'item_updated_text' => 'This item has been edited. You need to update before you can change it.',
    'database_menu' => 'Database',
    'db_items_edited' => 'Item currently being edited',
    'item_edition_start_hour' => 'Editing started',
    'settings_delay_for_item_edition' => 'Exclusive editing lock expires after XX minutes',
    'settings_delay_for_item_edition_tip' => 'When editing an item, the item is locked so that no other user can modify it. This setting deletes the lock token after a certain number of minutes. If the value is set to 0, an item will never be automatically unlocked after someone has started editing.',
    'db_users_logged' => 'Users logged in',
    'action' => 'Action',
    'login_time' => 'Logged since',
    'lastname' => 'Last name',
    'user_login' => 'Login',
    'at_user_new_lastname' => 'User #user_login# lastname changed',
    'at_user_new_name' => 'User #user_login# name changed',
    'info_list_of_connected_users_approximation' => 'Note: This list may show more users connected than are currently logged in.',
    'disconnect_all_users' => 'Disconnect all users (except administrators)',
    'role' => 'Role',
    'admin_2factors_authentication_setting' => 'Enable Google two-factor authentication',
    'admin_2factors_authentication_setting_tip' => 'Google two-factor authentication enhances logon security. When logging in, a QR code is displayed, which must be scanned into the user\'s Google Authentication app to receive a one-time password. Requires all users to have Google authentication app on an Internet-connected mobile device.',
    '2factors_tile' => 'Two-factor authentication',
    '2factors_image_text' => 'Scan the QR code',
    '2factors_confirm_text' => 'One-time password',
    'bad_onetime_password' => 'Wrong One-time password!',
    'error_string_not_utf8' => 'Error: string not in UTF8 format!',
    'error_role_exist' => 'This role already exists!',
    'error_no_edition_possible_locked' => 'Editing disabled - item locked by another user',
    'error_mcrypt_not_loaded' => 'Required PHP extension mcrypt is not loaded. Please inform your administrator if you see this message.',
    'at_user_added' => 'User #user_login# added',
    'at_user_deleted' => 'User #user_login# deleted',
    'at_user_locked' => 'User #user_login# locked',
    'at_user_unlocked' => 'User #user_login# unlocked',
    'at_user_email_changed' => 'User #user_login# email changed',
    'at_user_pwd_changed' => 'User #user_login# password changed',
    'at_user_initial_pwd_changed' => 'User #user_login# initial password change',
    'user_mngt' => 'Manage Users',
    'select' => 'select',
    'user_activity' => 'User Activity',
    'items' => 'Items',
    'enable_personal_saltkey_cookie' => 'Store personal salt key in a browser cookie',
    'personal_saltkey_cookie_duration' => 'User salt keys expire after XX days',
    'admin_emails' => 'Email',
    'admin_emails_configuration' => 'Email server configuration',
    'admin_emails_configuration_testing' => 'Email tasks',
    'admin_email_smtp_server' => 'SMTP server address',
    'admin_email_auth' => 'Server requires authentication',
    'admin_email_auth_username' => 'Mail server username',
    'admin_email_auth_pwd' => 'Mail server password',
    'admin_email_port' => 'SMTP server port',
    'admin_email_from' => 'From: Email address',
    'admin_email_from_name' => 'From: Display name',
    'admin_email_test_configuration' => 'Send yourself a test email',
    'admin_email_test_configuration_tip' => 'Send a test email to the logged-in user. You must first set your email address by clicking the user profile icon.',
    'admin_email_test_subject' => 'Test email from administrator',
    'admin_email_test_body' => 'This is a test email sent to verify email server configuration. If you are reading this, congratulations!',
    'admin_email_result_ok' => 'Email sent to #email# ... check your inbox.',
    'admin_email_result_nok' => 'Email test unsuccessful. Verify your settings (did you set your user account email address?) ',
    'email_subject_item_updated' => 'Password has been updated',
    'email_body_item_updated' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Password for \'#item_label#\' has been updated.<br /><br />You can check it <a href=\'#url#/index.php?page=items&group=#item_category#&id=#item_id#\'>HERE</a><br /><br />Cheers',
    'email_bodyalt_item_updated' => 'Password for #item_label# has been updated.',
    'admin_email_send_backlog' => '#nb_emails# unsent emails - send now',
    'admin_email_send_backlog_tip' => 'Re-send any queued backlog of outgoing emails waiting in the database.',
    'please_wait' => 'Please wait!',
    'admin_url_to_files_folder' => 'Files folder (URL)',
    'admin_path_to_files_folder' => 'Files folder (full path)',
    'admin_path_to_files_folder_tip' => 'The files folder is used to store both system files and some uploaded files. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'admin_path_to_upload_folder_tip' => 'File attachments are stored in the upload folder with randomized names.  Contents of this folder should never be manually deleted. For highest security, it should not be located in your site\'s www folder - It should be created in a folder outside your website directory, and accessed via a rewrite or redirection rule.</span>',
    'pdf_export' => 'PDF export',
    'pdf_password' => 'PDF encryption key',
    'pdf_password_warning' => 'You must provide an encryption key!',
    'admin_pwd_maximum_length' => 'Maximum password length',
    'admin_pwd_maximum_length_tip' => 'The default maximum password length is 40 characters. Increasing the size of allowed passwords will take more time when encrypting, decrypting, and displaying passwords.',
    'settings_insert_manual_entry_item_history' => 'Manual insertions in item history log allowed',
    'settings_insert_manual_entry_item_history_tip' => 'You would normally want to leave this off. When enabled, the history of a password item can be edited or altered.',
    'add_history_entry' => 'Add entry to history log',
    'at_manual' => 'Manual action',
    'at_manual_add' => 'Added manually',
    'admin_path_to_upload_folder' => 'Upload folder (full path)',
    'admin_url_to_upload_folder' => 'Upload folder (URL)',
    'automatic_del_after_date_text' => 'or after date',
    'at_automatically_deleted' => 'Automatically deleted',
    'admin_setting_enable_delete_after_consultation' => 'Passwords may expire after limited views',
    'admin_setting_enable_delete_after_consultation_tip' => 'When enabled, item creators can decide whether a password item will be automatically deleted after a limited number of views.',
    'enable_delete_after_consultation' => 'Item will be automatically deleted after being seen',
    'times' => 'times.',
    'automatic_deletion_activated' => 'Automatic deletion enabled',
    'at_automatic_del' => 'automatic deletion',
    'error_times_before_deletion' => 'Number of views before deletion needs to be more than 0!',
    'enable_notify' => 'Enable notify',
    'disable_notify' => 'Disable notify',
    'notify_activated' => 'Notification enabled',
    'at_email' => 'email',
    'enable_email_notification_on_item_shown' => 'Email administrators when password item is viewed',
    'bad_email_format' => 'Email address doesn\'t have the expected format!',
    'item_share_text' => 'In order to share this item by mail, enter the email address and press the SEND button.',
    'share' => 'Share this item',
    'share_sent_ok' => 'Email has been sent',
    'email_share_item_subject' => 'A password item was shared with you',
    'email_share_item_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has shared with you the password item #tp_item# <a href=\'#tp_link#\'>Click this link</a> to access the item.',
    'see_item_title' => 'Item details',
    'email_on_open_notification_subject' => 'Notification on password item view',
    'email_on_open_notification_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>#tp_user# has opened and viewed the password item \'#tp_item#\'. <a href=\'#tp_link#\'>Click this link</a> to access the item.',
    'pdf' => 'PDF',
    'csv' => 'CSV',
    'user_admin_migrate_pw' => 'Migrate personal items to a user account',
    'migrate_pf_select_to' => 'Migrate personal items to user',
    'migrate_pf_user_salt' => 'Enter the salt key for selected user',
    'migrate_pf_no_sk' => 'You must enter a salt key',
    'migrate_pf_no_sk_user' => 'You must enter a salt key',
    'migrate_pf_no_user_id' => 'You must select the user',
    'email_subject_new_user' => 'Password management account created for you',
    'email_new_user_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>An administrator has created an account for you on the password manager. Secure passwords for your organization are just a click away! <br><br>Use these credentials for your first login:<br>- Login: #tp_login#<br>- Password: #tp_pw#<br><br><a href=\'#tp_link#\'>Click this link</a> to log in and reset your password.',
    'error_empty_data' => 'No data to proceed!',
    'error_not_allowed_to' => 'You are not allowed to do that!',
    'personal_saltkey_lost' => 'Reset my personal salt key',
    'new_saltkey_warning_lost' => 'Input a new user salt key without re-encrypting any existing items. If you change your salt key here, all previous personal item passwords will be lost! If you know your old salt key, use the change key feature instead.',
    'previous_pw' => 'Previous passwords used:',
    'no_previous_pw' => 'No previous password',
    'request_access_ot_item' => 'Request access to modify',
    'email_request_access_subject' => 'You have a request to enable access to your password item',
    'email_request_access_mail' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>User #tp_user# has requested access to password item \\\'#tp_item#\\\'.<br><br>The request comes with the next justification:<br><i>\\\'#tp_reason#\\\'</i><br><br>Please review this request  and confirm that you will authorize access.<br><br>Greetings.',
    'admin_action_change_salt_key' => 'Change the main salt key used for encryption',
    'admin_action_change_salt_key_tip' => 'Before changing the salt key, please enable maintenance mode and perform a full backup of both the database and attachments in the upload folder.',
    'block_admin_info' => 'Administrator\'s Info',
    'admin_new1' => 'This profile is now an administrator account. An administrator account cannot view items or their passwords, only manage global settings.',
    'nb_items_by_query' => 'Number of items to retrieve per query',
    'nb_items_by_query_tip' => 'Input the number of items to retrieve per server request. Multiple smaller requests may perform better than fewer, larger requests. Other options: \'auto\' - tuned to user display window size. \'max\' - to load all at once.',
    'error_no_selected_folder' => 'You must select a folder',
    'open_url_link' => 'Open in a new window',
    'error_pw_too_long' => 'Password longer than system maximum (default 40 characters).',
    'at_restriction' => 'Restriction',
    'pw_encryption_error' => 'Error encrypting password!',
    'enable_send_email_on_user_login' => 'Email administrators upon any user login',
    'email_subject_on_user_login' => 'Info: user login to password manager',
    'email_body_on_user_login' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>User #tp_user# logged in to the password manager on #tp_date# at #tp_time#. <br><br>This is a normal message when option <i>Email administrators upon any user login</i> is set.',
    'account_is_locked' => 'This account is locked',
    'activity' => 'Activity',
    'add_button' => 'Add',
    'add_new_group' => 'Add New Folder',
    'add_role_tip' => 'Add New Role',
    'admin' => 'Administration',
    'admin_action' => 'Confirm changes',
    'admin_action_db_backup' => 'Backup the database',
    'admin_action_db_backup_key_tip' => 'Please enter a password to encrypt the backup file. The password will be required to restore the backup (blank for no encryption)',
    'admin_action_db_backup_start_tip' => 'Start',
    'admin_action_db_backup_tip' => 'It is good practice to backup your database regularly to protect against potential data loss.',
    'admin_action_db_clean_items' => 'Remove orphan items from database',
    'admin_action_db_clean_items_result' => 'items have been deleted.',
    'admin_action_db_clean_items_tip' => 'Removes any items or other entries left behind after a folder is deleted. Please backup before performing this task.',
    'admin_action_db_optimize' => 'Optimize the database',
    'admin_action_db_restore' => 'Restore the database',
    'admin_action_db_restore_key' => 'Enter encryption key for the backup.',
    'admin_action_db_restore_tip' => 'Restore from database backups created by using the built-in backup feature.',
    'admin_action_purge_old_files' => 'Clean up temporary files',
    'admin_action_purge_old_files_result' => 'files have been deleted.',
    'admin_action_purge_old_files_tip' => 'Deletes all temporary files older than 7 days.',
    'admin_action_reload_cache_table' => 'Reload cache table',
    'admin_action_reload_cache_table_tip' => 'Recreates the item cache. May correct problems in displaying or saving password items.',
    'admin_backups' => 'Backup',
    'admin_error_no_complexity' => '(<a href=\'index.php?page=manage_groups\'>Define?</a>)',
    'admin_error_no_visibility' => 'No one can see this item. (<a href=\'index.php?page=manage_roles\'>Customize roles</a>)',
    'admin_functions' => 'Manage Roles',
    'admin_groups' => 'Manage Folders',
    'admin_help' => 'Help',
    'admin_info' => 'Information about this software',
    'admin_info_loading' => 'Loading data ... please wait',
    'admin_ldap_configuration' => 'LDAP configuration',
    'admin_ldap_menu' => 'LDAP',
    'admin_main' => 'Information',
    'admin_misc_cpassman_dir' => 'TeamPass location (full path)',
    'admin_misc_cpassman_url' => 'TeamPass location (URL)',
    'admin_misc_custom_login_text' => 'Custom login message',
    'admin_misc_custom_logo' => 'Custom login logo (URL)',
    'admin_misc_favicon' => 'Favicon (full URL)',
    'admin_misc_title' => 'Options',
    'admin_one_shot_backup' => 'Manual database backup and restore',
    'admin_script_backups' => 'Settings for optional backup script',
    'admin_script_backups_tip' => 'Automatic backup of the database is recommended. To perform this task, a script is located in the backups folder, named script.backup.php. Create an operating system scheduled CRON job to run this script, daily or weekly as desired.',
    'admin_script_backup_decrypt' => 'Decrypt a backup file now',
    'admin_script_backup_decrypt_tip' => 'To decrypt an existing backup file in the backup folder, input the name with no extension and no path.',
    'admin_script_backup_encryption' => 'Encryption key (optional)',
    'admin_script_backup_encryption_tip' => 'If set, this key will be used to encrypt backup files on the server.',
    'admin_script_backup_filename' => 'Backup file name used by script',
    'admin_script_backup_filename_tip' => 'File name to assign to the script-generated backup file',
    'admin_script_backup_path' => 'Backup folder (full path)',
    'admin_script_backup_path_tip' => 'The folder in which the scheduled scripted backup files will be stored',
    'admin_settings' => 'Settings',
    'admin_settings_title' => 'Settings',
    'admin_setting_activate_expiration' => 'Enable password expiration',
    'admin_setting_activate_expiration_tip' => 'When enabled, password items will not be shown after they have expired. Set the password expiration time in days elsewhere before enabling this feature.',
    'admin_users' => 'Manage Users',
    'admin_views' => 'Utilities',
    'alert_message_done' => 'Done!',
    'alert_message_personal_sk_missing' => 'You must enter your personal salt key!',
    'all' => 'all',
    'anyone_can_modify' => 'Allow this item to be modified by anyone that can access it',
    'associated_role' => 'Role to associate with this folder:',
    'associate_kb_to_items' => 'Select the password items to associate with this listing',
    'assoc_authorized_groups' => 'Allowed associated folders',
    'assoc_forbidden_groups' => 'Denied associated folders',
    'at' => 'at',
    'at_add_file' => 'File added',
    'at_category' => 'Folder',
    'at_copy' => 'Copy done',
    'at_creation' => 'Creation',
    'at_delete' => 'Deletion',
    'at_del_file' => 'File deleted',
    'at_description' => 'Description',
    'at_file' => 'File',
    'at_import' => 'Import',
    'at_label' => 'Label',
    'at_login' => 'Login',
    'at_modification' => 'Modification',
    'at_moved' => 'Moved',
    'at_personnel' => 'Personal',
    'at_pw' => 'Password changed',
    'at_restored' => 'Restored',
    'at_shown' => 'Accessed',
    'at_url' => 'URL',
    'auteur' => 'Author',
    'author' => 'Author',
    'authorized_groups' => 'Allowed Folders',
    'auth_creation_without_complexity' => 'Allow item creation without required password strength',
    'auth_modification_without_complexity' => 'Allow item modification without required password strength',
    'auto_create_folder_role' => 'Create folder and role for ',
    'block_last_created' => 'Last created',
    'bugs_page' => 'If you discover a bug, please report it.',
    'by' => 'by',
    'cancel' => 'Cancel',
    'cancel_button' => 'Cancel',
    'can_create_root_folder' => 'Can create a folder at root level',
    'changelog' => 'Recent software updates',
    'change_authorized_groups' => 'Change authorized folders',
    'change_forbidden_groups' => 'Change denied folders',
    'change_function' => 'Change roles',
    'change_group_autgroups_info' => 'Select folders this role is allowed',
    'change_group_autgroups_title' => 'Customize the authorized folders',
    'change_group_forgroups_info' => 'Select folders this role is denied access',
    'change_group_forgroups_title' => 'Customize denied folders',
    'change_user_autgroups_info' => 'Select folders this user account can access',
    'change_user_autgroups_title' => 'Customize the authorized folders',
    'change_user_forgroups_info' => 'Select folders this user account is denied',
    'change_user_forgroups_title' => 'Customize denied folders',
    'change_user_functions_info' => 'Select the rights allowed for this account',
    'change_user_functions_title' => 'Customize associated rights',
    'check_all_text' => 'Check all',
    'close' => 'Close',
    'complexity' => 'Minimum Password Strength',
    'complex_asked' => 'Required Password Strength',
    'complex_level0' => 'Very weak',
    'complex_level1' => 'Weak',
    'complex_level2' => 'Medium',
    'complex_level3' => 'Strong',
    'complex_level4' => 'Very strong',
    'complex_level5' => 'Heavy',
    'complex_level6' => 'Very heavy',
    'confirm' => 'Confirm',
    'confirm_delete_group' => 'You have chosen to delete this folder and all included items ... are you sure?',
    'confirm_del_account' => 'You have chosen to delete this account. Are you sure?',
    'confirm_del_from_fav' => 'Please confirm deletion from favorites',
    'confirm_del_role' => 'Please confirm deletion of the role:',
    'confirm_edit_role' => 'Please enter a new name for the role',
    'confirm_lock_account' => 'You have decided to lock this account. Are you sure?',
    'connection' => 'Connection',
    'connections' => 'connections',
    'copy' => 'Copy',
    'copy_to_clipboard_small_icons' => 'Enable <i>copy password</i> icon on item list',
    'copy_to_clipboard_small_icons_tip' => 'Adds a small icon to the password item listing on the top panel which copies the password to the clipboard. A password can be copied without needing to select and load the whole item contents.',
    'creation_date' => 'Creation date',
    'csv_import_button_text' => 'Browse CSV file',
    'date' => 'Date',
    'date_format' => 'Date format',
    'days' => 'days',
    'definition' => 'Details',
    'delete' => 'Delete',
    'deletion' => 'Deletions',
    'deletion_title' => 'List of password items removed by users',
    'del_button' => 'Delete',
    'del_function' => 'Delete Roles',
    'del_group' => 'Delete Folder',
    'description' => 'Description',
    'disconnect' => 'Logout',
    'disconnection' => 'Logout',
    'div_dialog_message_title' => 'Information',
    'done' => 'Done',
    'drag_drop_helper' => 'Drag and drop item',
    'duplicate_folder' => 'Folders may have duplicate names',
    'duplicate_item' => 'Items may have duplicate name',
    'email' => 'Email',
    'email_altbody_1' => 'Item',
    'email_altbody_2' => 'has been created.',
    'email_announce' => 'Email a link to all users',
    'email_change' => 'Change the account\'s email',
    'email_changed' => 'Email changed!',
    'email_select' => 'Select users to inform',
    'email_subject' => 'New password item created in password manager',
    'email_text_new_user' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your account has been created in TeamPass.<br />You can now access $TeamPass_url using these credentials:<br />',
    'enable_favourites' => 'Favorites bookmark feature enabled',
    'enable_personal_folder' => 'Personal folders with private password storage',
    'enable_personal_folder_feature' => 'Personal folders with private password storage',
    'enable_user_can_create_folders' => 'Sub-folders managed by anyone who can manage parent',
    'encrypt_key' => 'Encryption key',
    'errors' => 'errors',
    'error_complex_not_enought' => 'Insufficient password strength!',
    'error_confirm' => 'Re-entered password does not match!',
    'error_cpassman_dir' => 'No path for TeamPass is set. Please configure under the administration <i>Settings</i> tab.',
    'error_cpassman_url' => 'No URL for TeamPass is set. Please configure under the administration <i>Settings</i> tab.',
    'error_fields_2' => 'These fields are required!',
    'error_group' => 'A folder is required!',
    'error_group_complex' => 'Minimum password strength level must be set!',
    'error_group_exist' => 'This folder already exists!',
    'error_group_label' => 'A folder name is required!',
    'error_html_codes' => 'Some text contains HTML codes! This is not allowed.',
    'error_item_exists' => 'This item already exists!',
    'error_label' => 'A label is mandatory!',
    'error_must_enter_all_fields' => 'You must fill in each field!',
    'error_mysql' => 'SQL database error!',
    'error_not_authorized' => 'You are not allowed to see this page.',
    'error_not_exists' => 'This page does not exist.',
    'error_no_folders' => 'You should start by creating some folders.',
    'error_no_password' => 'You need to enter your password!',
    'error_no_roles' => 'No roles defined - create some and associate them with folders.',
    'error_password_confirmation' => 'Passwords should be the same',
    'error_pw' => 'A password on the password tab is required.',
    'error_renawal_period_not_integer' => 'Renewal period must be number of months!',
    'error_salt' => 'The salt key is too long! An administrator must fix the system salt key stored in the settings php file.',
    'error_tags' => 'Only spaces are allowed in tags',
    'error_user_exists' => 'User already exists',
    'expiration_date' => 'Expiration date',
    'expir_one_month' => '1 month',
    'expir_one_year' => '1 year',
    'expir_six_months' => '6 months',
    'expir_today' => 'today',
    'files_&_images' => 'Files &amp; Images',
    'find' => 'Search',
    'find_text' => 'Your search',
    'folders' => 'Folders',
    'forbidden_groups' => 'Denied Folders',
    'forgot_my_pw' => 'Forgot your password?',
    'forgot_my_pw_email_sent' => 'Email has been sent',
    'forgot_my_pw_error_email_not_exist' => 'This email doesn\'t exist!',
    'forgot_my_pw_text' => 'Your password will be sent to the email associated with your account.',
    'forgot_pw_email_altbody_1' => 'Hi, Your identification credentials for TeamPass are:',
    'forgot_pw_email_body' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your new password for TeamPass is :',
    'forgot_pw_email_body_1' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>Your identification credentials for TeamPass are:<br /><br />',
    'forgot_pw_email_subject' => 'TeamPass - Your password',
    'forgot_pw_email_subject_confirm' => '[TeamPass] Your password step 2',
    'functions' => 'Roles',
    'function_alarm_no_group' => 'This role is not associated with any folder!',
    'generate_pdf' => 'Generate a PDF file',
    'generation_options' => 'Generation options',
    'gestionnaire' => 'Manager',
    'give_function_tip' => 'Add New Role',
    'give_function_title' => 'Add New Role',
    'give_new_email' => 'Please enter new email for',
    'give_new_login' => 'Please select the account',
    'give_new_pw' => 'Please indicate the new password for',
    'god' => 'Administrator',
    'group' => 'Folder',
    'group_parent' => 'Parent Folder',
    'group_pw_duration' => 'Renewal period',
    'group_pw_duration_tip' => 'In months. Use 0 to disable.',
    'group_select' => 'Select folder',
    'group_title' => 'Folder label',
    'history' => 'History',
    'home' => 'Home',
    'home_personal_menu' => 'Personal Actions',
    'home_personal_saltkey' => 'Your personal salt key',
    'home_personal_saltkey_button' => 'Set the salt key',
    'home_personal_saltkey_info' => 'You must create a personal salt key to use the personal folder feature.',
    'home_personal_saltkey_label' => 'Enter your personal salt key',
    'importing_details' => 'List of details',
    'importing_folders' => 'Importing folders',
    'importing_items' => 'Importing items',
    'import_button' => 'Import',
    'import_csv_anyone_can_modify_in_role_txt' => 'Set <i>anyone in the same role can modify</i> right on all imported items.',
    'import_csv_anyone_can_modify_txt' => 'Set "anyone can modify" right on all imported items.',
    'import_csv_dialog_info' => 'Import must be done using a CSV file, typically a file exported from KeePass has the expected structure.<br />If you use a file generated by another tool, please check that CSV structure is as follows: `Account`,`Login Name`,`Password`,`Web Site`,`Comments`.',
    'import_csv_menu_title' => 'Import Items',
    'import_error_no_file' => 'You must select a file!',
    'import_error_no_read_possible' => 'Can\'t read the file!',
    'import_error_no_read_possible_kp' => 'Can\'t read the file! It must be a KeePass file.',
    'import_keepass_dialog_info' => 'Please select an XML file generated by KeePass export function. Will only work with KeePass file! This function will not import any folders or items that already exist at the same level in the current tree structure.',
    'import_keepass_to_folder' => 'Select the destination folder',
    'import_kp_finished' => 'Import from KeePass is now finished ! The required password strength for new folders has been set to Medium. You may wish to modify the password strength requirement.',
    'import_to_folder' => 'Select the items you wish to import to folder:',
    'index_add_one_hour' => 'Extend session 1 hour',
    'index_alarm' => 'ALARM!!!',
    'index_bas_pw' => 'Bad password for this account!',
    'index_change_pw' => 'Change my password',
    'index_change_pw_button' => 'Change',
    'index_change_pw_confirmation' => 'Confirm',
    'index_expiration_in' => 'session expiration in',
    'index_get_identified' => 'Please identify yourself',
    'index_identify_button' => 'Enter',
    'index_identify_you' => 'Please identify yourself',
    'index_last_pw_change' => 'Password changed',
    'index_last_seen' => 'Last connection ',
    'index_login' => 'Account',
    'index_maintenance_mode' => 'Maintenance mode has been activated. Only administrators can log in.',
    'index_maintenance_mode_admin' => 'Maintenance mode is activated. Users currently can not log in.',
    'index_new_pw' => 'New password',
    'index_password' => 'Password',
    'index_pw_error_identical' => 'The passwords have to be identical!',
    'index_pw_expiration' => 'Actual password expiration in',
    'index_pw_level_txt' => 'Password Strength',
    'index_refresh_page' => 'Refresh page',
    'index_session_duration' => 'Session duration',
    'index_session_ending' => 'Your session will end in less than 1 minute.',
    'index_session_expired' => 'Your session has expired or you are not correctly identified!',
    'index_welcome' => 'Welcome',
    'info' => 'Information',
    'info_click_to_edit' => 'Click on a box to edit its value',
    'is_admin' => 'Is Admin',
    'is_manager' => 'Is Manager',
    'is_read_only' => 'Is Read-Only',
    'items_browser_title' => 'Folders',
    'item_copy_to_folder' => 'Please select a folder in which to copy the item.',
    'item_menu_add_elem' => 'Add item',
    'item_menu_add_rep' => 'Add folder',
    'item_menu_add_to_fav' => 'Add to favorites',
    'item_menu_collab_disable' => 'Editing is not allowed',
    'item_menu_collab_enable' => 'Editing is allowed',
    'item_menu_copy_elem' => 'Copy item',
    'item_menu_copy_login' => 'Copy login',
    'item_menu_copy_pw' => 'Copy password',
    'item_menu_del_elem' => 'Delete item',
    'item_menu_del_from_fav' => 'Delete from favorites',
    'item_menu_del_rep' => 'Delete folder',
    'item_menu_edi_elem' => 'Edit item',
    'item_menu_edi_rep' => 'Edit folder',
    'item_menu_find' => 'Search',
    'item_menu_mask_pw' => 'Mask password',
    'item_menu_refresh' => 'Refresh page',
    'kbs' => 'KBs',
    'kb_menu' => 'Knowledge Base',
    'keepass_import_button_text' => 'Browse XML file and import entries',
    'label' => 'Label',
    'last_items_icon_title' => 'Show/hide Last items seen',
    'last_items_title' => 'Last items seen',
    'ldap_extension_not_loaded' => 'The LDAP PHP extension is not loaded on the server.',
    'level' => 'Level',
    'link_copy' => 'Get a link to this item',
    'link_is_copied' => 'A link to this item has been copied to clipboard.',
    'login' => 'Login',
    'login_attempts_on' => 'Number of login attempts',
    'login_copied_clipboard' => 'Login copied in clipboard',
    'login_copy' => 'Copy account to clipboard',
    'logs' => 'Logs',
    'logs_1' => 'Generate log file of password renewals done',
    'logs_passwords' => 'Generate password log',
    'maj' => 'Uppercase letters',
    'mask_pw' => 'Mask/display password',
    'max_last_items' => 'Recently viewed password item list size (default is 10)',
    'menu_title_new_personal_saltkey' => 'Change my personal salt key',
    'minutes' => 'minutes',
    'modify_button' => 'Modify',
    'my_favourites' => 'My favorites',
    'name' => 'Name',
    'nb_false_login_attempts' => 'Maximum login attempts before account lockout (0 to disable lockout)',
    'nb_folders' => 'Number of Folders',
    'nb_items' => 'Number of Items',
    'nb_items_by_page' => 'Number of items by page',
    'new_label' => 'New label',
    'new_role_title' => 'New role title',
    'new_saltkey' => 'New salt key',
    'new_saltkey_warning' => 'The original salt key must be displayed or input correctly, otherwise personal item passwords will be lost! Before pressing change, verify the accuracy of the salt key! Record your new salt key somewhere safe.',
    'new_user_title' => 'Add New User',
    'no' => 'No',
    'nom' => 'Name',
    'none' => 'None',
    'none_selected_text' => 'None selected',
    'not_allowed_to_see_pw' => 'Access to password item denied!',
    'not_allowed_to_see_pw_is_expired' => 'This item has expired!',
    'not_defined' => 'Not defined',
    'no_last_items' => 'No items seen',
    'no_restriction' => 'No restriction',
    'numbers' => 'Numbers',
    'number_of_used_pw' => 'Number of old passwords remembered to prevent reuse (0 to disable)',
    'ok' => 'OK',
    'pages' => 'Pages',
    'pdf_del_date' => 'PDF generated the',
    'pdf_del_title' => 'Password renewal follow-up',
    'pdf_download' => 'Download file',
    'personal_folder' => 'Personal folder',
    'personal_saltkey_change_button' => 'Change!',
    'personal_salt_key' => 'Your personal salt key',
    'personal_salt_key_empty' => 'Personal salt key has not been entered!',
    'personal_salt_key_info' => 'This salt key will be used to encrypt and decrypt your passwords. You are the only person who knows it and it is the only way to access your personal password items - so don\'t lose it!',
    'please_update' => 'Please update the software and database!',
    'print' => 'Print',
    'print_out_menu_title' => 'Export items',
    'print_out_pdf_title' => 'List of exported password items',
    'print_out_warning' => 'You are saving a file containing unencrypted items and passwords. You must prevent unauthorized access to this file! Your PDF export will be logged.',
    'pw' => 'Password',
    'pw_change' => 'Change account password',
    'pw_changed' => 'Password changed!',
    'pw_copied_clipboard' => 'Password copied to clipboard',
    'pw_copy_clipboard' => 'Copy password to clipboard',
    'pw_generate' => 'Generate',
    'pw_is_expired_-_update_it' => 'This item has expired! You need to change its password.',
    'pw_life_duration' => 'Logon passwords expire after xx days (0 to disable)',
    'pw_recovery_asked' => 'You have requested password recovery',
    'pw_recovery_button' => 'Send me my new password',
    'pw_recovery_info' => 'By clicking the next button, you will receive an email that contains the new password for your account.',
    'pw_used' => 'This password has already been used!',
    'readme_open' => 'Open full readme file',
    'read_only_account' => 'Read Only',
    'refresh_matrix' => 'Reload Role Grid',
    'renewal_menu' => 'Renewal follow-up',
    'renewal_needed_pdf_title' => 'List of items that need to be renewed',
    'renewal_selection_text' => 'List all items that will expire:',
    'restore' => 'Restore',
    'restricted_to' => 'Restricted to',
    'restricted_to_roles' => 'Allow restricting items to users and roles',
    'rights_matrix' => 'Users rights matrix',
    'roles' => 'Roles',
    'role_cannot_modify_all_seen_items' => 'Role not allowed to modify accessible items (normal setting)',
    'role_can_modify_all_seen_items' => 'Role allowed to modify all accessible items (insecure setting)',
    'root' => 'Root',
    'save_button' => 'Save',
    'secure' => 'Secure',
    'see_logs' => 'See Logs',
    'select_folders' => 'Select folders',
    'select_language' => 'Select your language',
    'send' => 'Send',
    'settings_anyone_can_modify' => '<i>Anyone can modify</i> feature enabled',
    'settings_anyone_can_modify_tip' => 'This adds a checkbox during new password item creation that can set the item to be modifiable by anyone.',
    'settings_default_language' => 'Default user interface language',
    'settings_kb' => 'Knowledge base feature',
    'settings_kb_tip' => 'Adds a menu item to access the knowledge base feature. The knowledge base is a searchable FAQ, allowing you create help and notes, and attach them to password items.',
    'settings_ldap_domain' => 'LDAP account suffix for your domain',
    'settings_ldap_domain_controler' => 'LDAP domain controller(s)',
    'settings_ldap_domain_controler_tip' => 'Specify domain controller providing the directory services. To balance queries among multiple servers, input a comma-delimited list of each server name. Example: domain_1,domain_2,domain_3',
    'settings_ldap_domain_dn' => 'LDAP base DN for your domain',
    'settings_ldap_mode' => 'Enable users authentication through LDAP server',
    'settings_ldap_mode_tip' => 'Enable if you wish to authenticate user logins with an LDAP directory server instead of using the internal user database.',
    'settings_ldap_ssl' => 'Use LDAP through SSL (LDAPS)',
    'settings_ldap_tls' => 'Use LDAP through TLS',
    'settings_log_accessed' => 'Log password item views by users',
    'settings_log_connections' => 'Log all user account logins',
    'settings_maintenance_mode' => 'Enable maintenance mode (disable user login)',
    'settings_maintenance_mode_tip' => 'In maintenance mode, only administrators are permitted to log in. Enable maintenance mode before making significant site changes, such as changing the salt key.',
    'settings_manager_edit' => 'Managers may edit or delete any items they can view',
    'settings_printing' => 'Export to PDF or CSV enabled',
    'settings_printing_tip' => 'Adds an export option to the item tree menu, allowing export of entire folders to PDF or CSV. CSV passwords will be exported unencrypted, while PDF files can be password-protected.',
    'settings_restricted_to' => 'Enable <i>restricted-to</i> function on items',
    'settings_richtext' => 'Enable richtext for item description',
    'settings_richtext_tip' => 'This will activate the rich text editor for the item description field.',
    'settings_send_stats' => 'Feedback: Send usage statistics monthly to TeamPass creator',
    'settings_send_stats_tip' => 'These statistics are entirely anonymous! Just the following info is transmitted: number of items, folders, and users; software version, personal folder setting, ldap setting. Enabling feedback lets us know you use the software and allows further planning and development of features.</span>',
    'settings_show_description' => 'Show item description field in item listings',
    'show' => 'Show',
    'show_help' => 'Show Help',
    'show_last_items' => 'Show last items block on main page',
    'size' => 'Size',
    'start_upload' => 'Start file upload',
    'sub_group_of' => 'Dependent on',
    'support_page' => 'For support, please visit TeamPass website.',
    'symbols' => 'Symbols',
    'tags' => 'Tags',
    'thku' => 'Thank you for using TeamPass!',
    'timezone_selection' => 'Time zone',
    'time_format' => 'Time format',
    'uncheck_all_text' => 'Uncheck all',
    'unlock_user' => 'User is locked. Do you want to unlock this account?',
    'update_needed_mode_admin' => 'Database upgrade is recommended. Click <a href=\'install/upgrade.php\'>HERE</a> to upgrade.',
    'uploaded_files' => 'Existing Files',
    'upload_button_text' => 'Browse',
    'upload_files' => 'Upload New Files',
    'url' => 'URL',
    'url_copied' => 'URL has been copied!',
    'used_pw' => 'Password',
    'user' => 'User',
    'users' => 'Users',
    'users_online' => 'users online',
    'user_action' => 'Action on a user',
    'user_alarm_no_function' => 'This user has no roles assigned!',
    'user_del' => 'Delete account',
    'user_lock' => 'Lock user',
    'version' => 'Current version',
    'views_confirm_items_deletion' => 'Do you really want to delete the selected items from database?',
    'views_confirm_restoration' => 'Please confirm password item restoration',
    'visibility' => 'Visibility',
    'warning_screen_height' => 'Warning: web browser screen height insufficient to display password item list.',
    'yes' => 'Yes',
    'your_version' => 'Your version',
    'disconnect_all_users_sure' => 'Are you sure you\'d like to disconnect all users?',
    'Test the Email configuration' => 'Test email configuration',
    'url_copied_clipboard' => 'URL copied to clipboard',
    'url_copy' => 'Copy URL to clipboard',
    'one_time_item_view' => 'One time view link',
    'one_time_view_item_url_box' => 'Share a one-time-view URL with a person you trust to see the password <br><br>#URL#<br><br>This link will only be visible one time, and expires #DAY#',
    'admin_api' => 'API',
    'settings_api' => 'API access enabled',
    'settings_api_tip' => 'The Application Programming Interface allows software developers to access password items in JSON format over the network.',
    'settings_api_keys_list' => 'API key list',
    'settings_api_keys_list_tip' => 'Keys to access API. Third-party software must use a random key created here to access the JSON interface.',
    'settings_api_generate_key' => 'Generate a key',
    'settings_api_delete_key' => 'Delete key',
    'settings_api_add_key' => 'New key',
    'settings_api_key' => 'Key',
    'settings_api_key_label' => 'Label',
    'settings_api_ip_whitelist' => 'API IP Addresses allowed',
    'settings_api_ip_whitelist_tip' => 'If no API client IP addresses are explicitly listed here, then any IP address is authorized.',
    'settings_api_add_ip' => 'New IP',
    'settings_api_db_intro' => 'Give a label to the new key (recommended)',
    'error_too_long' => 'Error - input is too long!',
    'settings_api_ip' => 'IP',
    'settings_api_db_intro_ip' => 'Give a label for this new IP',
    'settings_api_world_open' => 'No addresses defined. API access is possible from any IP address.',
    'subfolder_rights_as_parent' => 'New sub-folders inherit permissions from parent folder',
    'subfolder_rights_as_parent_tip' => 'If enabled, each new sub-folder inherits the roles and permissions of the parent folder. Otherwise, the folder permission is assigned based on the role of the user who creates them.',
    'show_only_accessible_folders_tip' => 'By default, users see the complete tree of password item folders, even if some folders are inaccessible to the user. You may remove inaccessible folders from the view to simplify browsing.',
    'show_only_accessible_folders' => 'Hide inaccessible password folders',
    'suggestion' => 'Item suggestion',
    'suggestion_add' => 'Add item suggestion',
    'comment' => 'Comment',
    'suggestion_error_duplicate' => 'A similar suggestion already exists!',
    'suggestion_delete_confirm' => 'Please confirm suggestion deletion',
    'suggestion_validate_confirm' => 'Please confirm suggestion validation',
    'suggestion_validate' => 'You have decided to add this suggestion to the password item list ... please confirm.',
    'suggestion_error_cannot_add' => 'ERROR - The suggestion could not be added!',
    'suggestion_is_duplicate' => 'CAUTION: A password item with similar name already exists. If you add the suggestion, the existing item will be modified with data from this suggestion!',
    'suggestion_menu' => 'Suggestions',
    'settings_suggestion' => 'Password suggestion feature enabled',
    'settings_suggestion_tip' => 'The suggestion feature adds a new menu and page, allowing users to create suggestions for new password items. This is useful when only managers are allowed to create password items.',
    'imported_via_api' => 'API',
    'settings_ldap_bind_dn' => 'LDAP bind DN',
    'settings_ldap_bind_passwd' => 'LDAP bind password',
    'settings_ldap_search_base' => 'LDAP search base',
    'settings_ldap_bind_dn_tip' => 'Enter a bind DN which can access users and search in the tree. A bind DN is a credential that authenticates your access to the directory.',
    'settings_ldap_bind_passwd_tip' => 'Password for the bind DN specified above.',
    'settings_ldap_search_base_tip' => 'Root DN location for searches on the tree',
    'old_saltkey' => 'Old salt key',
    'define_old_saltkey' => 'Specify the original salt key (optional)',
    'admin_email_server_url_tip' => 'Links back to the password manager site are inserted into some emails. You can change the URL (web address) that is used. Leave blank to use the URL automatically derived from your site settings.',
    'admin_email_server_url' => 'Customize URL for links',
    'generated_pw' => 'Generated password',
    'enable_email_notification_on_user_pw_change' => 'Email user when user password is changed',
    'settings_otv_expiration_period' => 'One-time-view (OTV) links expire after XX days',
    'change_right_access' => 'Define the access rights',
    'write' => 'Write',
    'read' => 'Read',
    'no_access' => 'No Access',
    'right_types_label' => 'Select the type of access on this folder for the selected group of users',
    'groups' => 'Folders',
    'duplicate' => 'Duplicate',
    'duplicate_title_in_same_folder' => 'A similar item name exists in this folder! Change your item name and try again.',
    'duplicate_item_in_folder' => 'Items in same folder may have similar names',
    'find_message' => '<i class="fa fa-info-circle"></i> %X% objects found',
    'settings_roles_allowed_to_print' => 'Export allowed by these roles (multi-select)',
    'settings_roles_allowed_to_print_tip' => 'Select multiple roles by holding CTRL while selecting. Members of these roles will be able to export folders to CSV or PDF if export is also enabled globally.',
    'user_profile_dialogbox_menu' => 'Your personal information',
    'admin_email_security' => 'SMTP security type',
    'alert_page_will_reload' => 'The page will now be reloaded',
    'csv_import_items_selection' => 'Select the items to import',
    'csv_import_options' => 'Select import options',
    'file_protection_password' => 'Define file password',
    'button_export_file' => 'Export items',
    'error_export_format_not_selected' => 'A format for export file is required',
    'select_file_format' => 'Select file format',
    'button_offline_generate' => 'Generate offline mode file',
    'upload_new_avatar' => 'Select profile image file',
    'expand' => 'Expand',
    'collapse' => 'Collapse',
    'error_file_is_missing' => 'Error: The file is missing!',
    'click_to_change' => 'Click to change',
    'settings_ldap_user_attribute' => 'User attribute to search',
    'settings_ldap_user_attribute_tip' => 'LDAP attribute to search within for username',
    'user_ga_code_sent_by_email' => 'A new Google Authentication code was sent to your email address.',
    'log_user_initial_pwd_changed' => 'Initial password defined',
    'log_user_email_changed' => 'User email changed to ',
    'log_user_created' => 'User account created',
    'log_user_locked' => 'User has been locked',
    'log_user_unlocked' => 'User has been unlocked',
    'log_user_pwd_changed' => 'User password has been changed',
    'edit_user' => 'Edit user',
    'pf_change_encryption' => 'The encryption algorithm has changed and your personal passwords have to be re-encoded. You need to run this process to use your passwords. This process may take several minutes depending on the number of items you have.',
    'operation_encryption_done' => 'Re-encryption has been performed. You can close this dialog box.',
    'show_password' => 'Click and hold to show password',
    'change_password' => 'Change password',
    'pf_sk_set' => 'Your personal salt key is set correctly. Click <i>start</i> to proceed',
    'pf_sk_not_set' => 'Your personal salt key is not set! Please enter it first.',
    'upgrade_needed' => 'Upgrade needed',
    'item_menu_mov_rep' => 'Move folder',
    'settings_default_session_expiration_time' => 'Default session expiration time',
    'duo_message' => 'DUO Security checks are now done. Sending your credentials to Teampass.<br />Please wait ... the page will be reloaded once authentication process will be done.',
    'duo_loading_iframe' => 'DUO Security authentication is loading ... Please wait.',
    'settings_duo' => 'Enable DUO Security two-factor authentication',
    'settings_duo_tip' => 'Duo Security cloud-based two-factor authentication from duo.com. One-time use login passcodes via SMS, voice call, or mobile app. An account with Duo is required to use this feature. Two-factor login via Duo will be required for all non-admin users when activated.<br/>Create or convert the teampass application to the Universal Prompt from the Duo administration page.',
    'admin_duo_ikey' => 'Client ID (duo_ikey)',
    'admin_duo_skey' => 'Client secret (duo_skey)',
    'admin_duo_host' => 'API hostname (HOST)',
    'settings_duo_explanation' => 'Application credentials from the account Duo security administration page must be input here.',
    'admin_duo_intro' => 'Input your Duo application credentials',
    'select_valid_2fa_credentials' => 'Please make sure to select a valid 2FA method',
    'duo_config_error' => '= Duo config error =<br/> Check your Duo config <br/>',
    'duo_error_failopen' => 'Could not connect to Duo, 2FA cannot be performed but config is configured to continue.',
    'duo_error_secure' => 'Duo is currently unavailable. <br/>Login cannot proceed, contact your administrator if the issue persist.',
    'duo_error_check_config' => '<br/><br/>Administrator, please confirm your Duo config is correct.<br/>',
    'duo_error_auth' => 'Error while trying to complet Duo Authentication. <br /> ',
    'duo_redirect_uri' => 'Redirecting to Duo Prompt',
    'duo_no_data' => 'Missing data or no saved Duo state were found, please login again.',
    'duo_no_state_received' => 'No state received from Duo. Try again or contact your administrator.',
    'duo_error_state' => 'Duo state mismatch. Please login again',
    'duo_error_decoding' => 'Error decoding the Duo result. Contact your administrator if the issue persist.',
    'duo_login_mismatch' => 'Error login mismatch between Duo and Teampass. Confirm your information are correct.',
    'duo-run-config-check' => 'Check Duo Config',
    'duo-config-check-success' => 'Duo config correct and Teampass server able to talk to the Duo API',
    'duo_login_mismatch' => 'Username from the original Duo request does not match the login submitted.',
    'duo_error_url' => 'Error while creating the DUO Universal Prompt URL',
    'duo_error_decrypt' => 'Error while completing Duo authentication, please login again.',
    'generate_random_key' => 'Generate random key',
    'duo_save_sk_file' => 'Save data in sk.php file',
    'settings_duo_explanation' => 'Credentials from the Duo Security administration page for your account must be input here. Settings will be stored in the sk.php file only after pressing the save button.',
    'admin_duo_intro' => 'Input or generate Duo Security secret',
    'admin_duo_stored' => 'Credentials stored successfully!',
    'user_not_exists' => 'This user does not exist!',
    'dialog_admin_user_edit_title' => 'Edit User Account',
    'user_info_delete' => 'Please re-click to confirm account deletion.',
    'user_info_delete_warning' => 'By clicking save, you will irretrievably delete this account!',
    'edit' => 'Edit',
    'user_info_locked' => 'User is currently locked.',
    'user_info_unlock_question' => 'Unlock account?',
    'user_info_lock_question' => 'Lock account?',
    'user_info_delete_question' => 'Delete account?',
    'user_info_active' => 'User is currently enabled.',
    'settings_ldap_domain_posix' => 'LDAP account suffix for your domain',
    'refresh' => 'Refresh',
    'loading' => 'Loading',
    'at_password_shown' => 'Password shown',
    'at_password_copied' => 'Password copied',
    'search_results' => 'Search results',
    'searching' => 'Searching ...',
    'search_tag_results' => 'Search results for tag',
    'searching_tag' => 'Searching for tag',
    'list_items_with_tag' => 'List items with this tag',
    'no_item_to_display' => 'No items to display',
    'opening_folder' => 'Reading folder ...',
    'please_confirm' => 'Please confirm',
    'suggestion_notify_subject' => 'A new password item suggestion was submitted',
    'suggestion_notify_body' => 'A user has submitted a password item suggestion to the password manager. You need to accept the submission before it can be used by other users.<br>Info:<br>- Label: #tp_label#<br>- Folder: #tp_folder#<br>- User: #tp_user#<br><br>This email has been sent to all managers.',
    'error_unknown' => 'An unexpected error occurred!',
    'no_edit_no_delete' => 'Write but no edit or delete',
    'no_edit' => 'Write but no edit',
    'role_cannot_edit_item' => 'Cannot edit items',
    'no_delete' => 'Write but no delete',
    'role_cannot_delete_item' => 'Cannot delete items',
    'text_without_symbols' => 'Only numbers, letters and symbols # & % * $ @ ( ) are allowed. Other characters are not possible.',
    'my_profile' => 'My profile',
    'at_suggestion' => 'Suggestion accepted',
    'character_not_allowed' => 'Character is not allowed!',
    'error_saltkey_length' => 'Salt key must be a 16 characters string!',
    'starting' => 'Starting...',
    'total_number_of_items' => 'Total number of items',
    'finalizing' => 'Finalizing',
    'treating_items' => 'Processing items',
    'number_of_items_treated' => 'Number of items processed',
    'error_sent_back' => 'Next error occured',
    'full' => 'Full',
    'sequential' => 'Sequential',
    'tree_load_strategy' => 'Tree load strategy',
    'syslog_enable' => 'Log errors to <i>syslog</i> server',
    'syslog_host' => 'Syslog server name or IP address',
    'syslog_port' => 'Syslog port (default 514)',
    'error_bad_credentials' => 'Login credentials do not correspond!',
    'reload_page_after_user_account_creation' => 'Your account has been created. This page will be automatically reloaded in 3 seconds ...',
    'settings_ldap_usergroup' => 'LDAP group to search',
    'settings_ldap_usergroup_tip' => 'Enter the LDAP group in the directory where allowed user logins are stored. Example: cn=sysadmins,ou=groups,dc=example,dc=com',
    'server_password_change_enable' => 'Enable changing password on distant server (using ssh connection)',
    'error_login_missing' => 'Login is missing!',
    'error_pwd_missing' => 'Password is missing!',
    'error_url_missing' => 'URL is missing!',
    'error_ssh_credentials_missing' => 'SSH credentials are missing!',
    'error_url_must_be_ssh' => 'URL must start with SSH protocol!',
    'auto_update_server_password_info' => 'Clicking start will automatically perform these steps:<ul><li>Connect through SSH to server using login credentials and field `URL`,</li><li>Change user password on server</il><li>Save the new password in Teampass</il><li>Close SSH connection</li></ul><br /><b>Please ensure that user has rights to log in and change password on the server (if not, indicate the root login and password) before starting.</b>',
    'update_server_password' => 'Update server password',
    'error_personal_sk_expected' => 'You must first enter your personal salt key!',
    'click_to_generate' => 'Click to generate',
    'error_new_pwd_missing' => 'New password is missing!',
    'ssh_pwd' => 'SSH password',
    'ssh_user' => 'SSH user',
    'ssh_action_performed_with_error' => 'The server replied with an error. Check the error response and try again.',
    'ssh_action_performed' => 'Password updated for this item.<br /><br />You can now close this window.',
    'ssh_answer_from_server' => 'Server reply',
    'ssh_password_frequency_change_info' => 'Select the interval between automatic server password updates (selecting 0 will disable automatic password changing).<br />Automatic password updates will only be performed if the system administrator has also configured the scheduled password update feature cron job.',
    'ssh_password_frequency_change' => 'Password change frequency (in months)',
    'ssh_scheduled_change' => 'Scheduled change',
    'ssh_one_shot_change' => 'One-time change',
    'month' => 'month',
    'server_auto_update_password_enabled_tip' => 'Automatic user password change enabled',
    'server_password_change_enable_tip' => 'This setting adds an option in the password item to automatically change the user password on a server address listed in the url. This requires the remote UNIX server to allow username and password login via SSH. Automatic scheduled password changes can be performed after adding <i>/files/script.ssh.php</i> to crontab to run once a day on the password manager webserver.',
    'can_manage_all_users' => 'Human Resources - User can manage all other users (except administrators) regardless of group membership. HR user will also have manager rights added to their account.',
    'error_bad_credentials_more_than_3_times' => 'Login credentials incorrect!<br>Please wait 10 seconds before next attempt',
    'settings_ldap_object_class' => 'Class to search',
    'settings_ldap_object_class_tip' => 'LDAP class to search, such as user account or POSIX account',
    'rebuild_config_file' => 'Rebuild the configuration file',
    'rebuild_config_file_tip' => 'The configuration file contains system variables, and is used when these settings are needed before the database connection has been established. Rebuilding the configuration file saves the database values to the file, and can be done any time. The default location is ./includes/config/tp.config.php, but the file should be located outside the www directory for security.',
    'error_folder_complexity_lower_than_top_folder' => 'Subfolders must have password strength set the same or higher than parent folder',
    'rebuild_config_file' => 'Rebuild configuration file',
    'csv_import_information' => 'The CSV file needs to follow these rules:<ul><li>The first line must be a header,</li><li>The header must contain 5 columns,</li><li>The separator character is a comma `,`,</li><li>The encalupsation character is a double quotes `"`,</li><li>Expected columns are: `Label` , `Login` , `Password` , `URL` , `Comments`.</li></ul>',
    'new_item_email_body' => 'Hello,<br><br>This is a generated email from Teampass passwords manager.<br><br>New item \'#label\' has been created in Teampass.<br />You may access it clicking on this <a href=\'#link#\'>LINK</a>.<br/><br />Greetings.',
    'failed_logins' => 'Failed Logins',
    'admin_2factor_authentication_tab' => '2FA Options',
    'error_only_numbers_in_folder_name' => 'Folder label can not be just a number. Please give your folder a name which includes letters.',
    'folder_will_be_moved_below' => 'The folder <b><span id=\\\'move_folder_title\\\'></span></b> will be moved below folder:',
    'error_upload_runtime_not_found' => 'Upload feature: No runtime found.',
    'runtime_upload' => 'Upload feature: runtime',
    'encrypted_data' => 'Data is encrypted in database',
    'not_encrypted_data' => 'Data is not encrypted in database',
    'error_custom_fields_not_similar_in_source_and_target_folders' => 'Moving the folder is not possible as Custom Fields are not similar.',
    'is_super_manager' => 'Is Super Manager',
    'settings_ldap_port' => 'LDAP port',
    'settings_ldap_port_tip' => 'Default non secure LDAP port: 389, default secure LDAP port: 636',
    'user_language' => 'Your language',
    'admin_agses_hosted' => 'AGSES hosted service',
    'admin_agses_hosted_tip' => 'AGSES hosted service',
    'user_profile_agses_enable' => 'Enable Agses authentication',
    'user_profile_agses_card_id' => 'Your Agses card id',
    'admin_agses_authentication_setting' => 'Enable Agses two-factor authentication',
    'admin_agses_authentication_setting_tip' => 'Enable Agses two-factor authentication',
    'index_agses_key' => 'Agses code',
    'admin_agses_hosted_url' => 'Url',
    'admin_agses_hosted_id' => 'Id',
    'admin_agses_hosted_apikey' => 'API key',
    'admin_agses_save' => 'Save AGSES settings',
    'admin_agses_wait' => 'Please wait ... contacting AGSES server.',
    'agses_error_missing_api_data' => 'AGSES configuration data is missing',
    'agses_error_missing_user_card_id' => 'No AGSES Card ID provided',
    'ga_temporary_bad_code' => 'The temporary code you have entered is wrong. Please check your email, paste the code and try again.',
    'ga_flash_qr_and_login' => 'Flash this QR code with your mobile device, enter the 2Factor Authentication code and click `Enter` button.',
    'i_need_to_generate_new_ga_code' => 'I need a new QR code. Please send me by email a temporary Identication Code.',
    'settings_manager_move_item' => 'Managers can move any items they can view',
    'user_folders_rights' => 'Visible folders',
    'user_s_rights_on_folders' => 'Rights on folders for User',
    'folders_not_visible_are_not_displayed' => 'Folders not displayed in this list are not seen by the user',
    'create_item_without_password' => 'Allow item to be created without any password defined',
    'share_user_rights' => 'Share user rights',
    'share_rights_info' => 'This dialogbox permits you to share the rights of one user with a selection of users.<br>Notice that the selected users will have their existing rights reseted and replaced with exactely the same rights as the source user.',
    'share_rights_source' => 'Source user',
    'share_rights_destination' => 'Destination users',
    'password_is_empty' => 'Item has no password',
    '2FA_new_code_by_user_not_allowed' => 'This has been disabled. Please request new code to your Administrator.',
    'ga_reset_by_user' => 'User can reset his 2FA code',
    'ga_reset_by_user_tip' => 'If enabled, the user will have the possibility to reset his 2FA code using the link in the login page. This could be useful in case he has changed mobile device for example. If not enabled, the user will have to ask the Administrator to generate a new code.',
    'error_cannot_delete_subfolders_exist' => 'This folder cannot be deleted as at least one subfolder exists.',
    'enable_massive_move_delete' => 'Allow user to perform massive move and delete operations',
    'enable_massive_move_delete_tip' => 'When enabled, this option permits a user to perform a massive move and/or delete operation in one time. The user will only be able to perform this on Items on which he is allowed to.',
    'mass_operation' => 'Mass operation on Items',
    'move_items' => 'Move selected Items',
    'must_select_items' => 'You must select items!',
    'delete_items' => 'Delete selected Items',
    'you_decided_to_move_items' => 'You decided to move items',
    'you_decided_to_delete_items' => 'You decided to delete items',
    'show_suggestions' => 'New suggestions',
    'show_changes' => 'Change proposals',
    'suggest_password_change' => 'Suggest a password change',
    'suggest_password_change_intro' => 'Make your change proposals using the next fields.',
    'suggestion_done' => 'Suggestion has been stored.',
    'suggest_change_password_blank' => 'Leave this field empty if you DON\\\'T want to suggest a password change',
    'item_id' => 'Item ID',
    'approve' => 'Approve',
    'reject' => 'Reject',
    'click_to_edit' => 'Click to edit',
    'otv_is_enabled' => 'User can propose One-Time-View links',
    'notify_me_on_change' => 'Notify me on change',
    'copy_folder' => 'Copy folder',
    'copy_folder_info' => 'This feature permits to copy the content of a folder including sub-folders and items. All of those will be duplicated with exactely same names and rights.',
    'copy_folder_source' => 'Folder to be copied',
    'new_folder_name' => 'New folder name',
    'copy_folder_destination' => 'Destination folder',
    'error_source_and_destination_are_equal' => 'Source and Destination cannot be the same!',
    'sending_anonymous_statistics' => 'Sending anonymous statistics',
    'considering_sending_anonymous_statistics' => 'Please consider sending anonymous statistics',
    'anonymous_statistics_definition' => 'Use the next form to define the data you may share (please consider keeping all choice ticked)',
    'favourites_option_enabled' => 'Favourites option enabled',
    'personalfolders_option_enabled' => 'Personal Folders option enabled',
    'country_statistics' => 'Worldmap usage',
    'country' => 'Country',
    'users_statistics' => 'Average number of users by instance',
    '﻿users_statistics' => 'Average number of users by instance',
    'items_all' => 'All items',
    'folders_all' => 'All folders',
    'items_shared' => 'All shared items (not including personal ones)',
    'folders_shared' => 'All shared folders (not including personal ones)',
    'items_statistics' => 'Average number of items by instance',
    'folders_statistics' => 'Average number of folders by instance',
    'administrators_number' => 'Number of Administrator users',
    'administrators_number_statistics' => 'Average number of Administrators by instance',
    'managers_number' => 'Number of Manager users',
    'managers_number_statistics' => 'Average number of Managers by instance',
    'readonly_number_statistics' => 'Average number of Read-Only users by instance',
    'readonly_number' => 'Number of Read-Only users',
    'mysql_version' => 'MySQL version',
    'php_version' => 'PHP version',
    'teampass_version' => 'Teampass version',
    'languages_used' => 'Languages used',
    'languages_statistics' => 'Most used language',
    'kb_option_enabled' => 'Knowledge Base option enabled',
    'suggestion_option_enabled' => 'Suggestion option enabled',
    'customfields_option_enabled' => 'Custom fields option enabled',
    'api_option_enabled' => 'API option enabled',
    '2fa_option_enabled' => '2FAoption enabled',
    'agses_option_enabled' => 'AGSES option enabled',
    'duo_option_enabled' => 'DUO Security option enabled',
    'ldap_option_enabled' => 'LDAP option enabled',
    'syslog_option_enabled' => 'SYSLOG option enabled',
    'stricthttps_option_enabled' => 'Strict HTTPS option enabled',
    'characteristic' => 'Characteristic',
    'usage_example' => 'Usage example',
    'current_value' => 'Current value',
    'save_statistics_choice' => 'Save your settings',
    'communication_means' => 'Communication means',
    'email_format_is_not_correct' => 'Email format is not correct',
    'url_format_is_not_correct' => 'URL format is not correct',
    'Dont_update_with_this_data' => 'Don\'t update item with this data',
    'consider_a_donation' => 'You may consider a donation',
    'more_information' => 'More information',
    'feature_request_canal' => 'For Feature Requests, please use',
    'bug_canal' => 'For Bugs, please use',
    'documentation_canal' => 'Complete documentation at',
    'website_canal' => 'Click to open Teampass website',
    'sending_anonymous_statistics_details' => 'Statistics are needed to improve Teampass by knowing the users population and usage. The data you will provide will only be used internally for datamining and will absolutely not be distributed or sold to any third party.',
    'item_has_change_proposal' => 'This Item has a change proposal',
    'select_all' => 'Select all',
    'add_category' => 'Add Category',
    'what_action_to_perform' => 'Select the action to perform',
    'confirm_database_reencryption' => 'This will reencrypt the database with new saltkey. Please confirm?',
    'previous_backup_exists' => 'A previous backup exists.<br>Do you want to revert to previous data?',
    'previous_backup_exists_delete' => 'Do you want to wipe out this old data?',
    'check_data_after_reencryption' => 'Please check the data. A new table <b>Backup</b> was created during this operation permitting to revert.',
    'revert' => 'Revert?',
    'revert_the_database' => 'You have decided to revert the database. Please confirm?',
    'wipe_backup_data' => 'You have decided to wipe the backup data. This should be done after data verification. Please confirm?',
    'bad_psk' => 'This personal Saltkey is not correct!',
    'bad_psk_confirmation' => 'The personal saltkey confirmation is not correct!',
    'psk_required' => 'The personal saltkey is required!',
    'ldap_test_config' => 'Test current configuration',
    'ldap_test_username' => 'Username to use for testing purpose',
    'ldap_test_username_pwd' => 'Username password',
    'no_username_needed' => 'No username needed',
    'feature_support_canal' => 'For Support and Help, please use',
    'file_is_now_ready' => 'File is now ready.',
    'category' => 'Category',
    'knowledge_base' => 'Knowledge Base',
    'anyone_can_modify_it' => 'Anyone can modify it',
    'manage_entries_in_kb' => 'Manage entries in KB',
    'add_new_kb' => 'Add a new KB',
    'nothing_to_do' => 'Nothing to do.',
    'continue' => 'Continue',
    'please_confirm_operation' => 'Please confirm the operation',
    'setting_disabled_by_admin' => 'This setting is disabled by Administrator',
    'text' => 'Text',
    'masked' => 'Masked',
    'type' => 'Type',
    'select_type_of_field' => 'Select type of field',
    'define_new_field' => 'Define new field',
    'data_is_text' => 'Data is Text',
    'data_is_masked' => 'Data is Hidden',
    'at_export' => 'Export',
    'setting_disabled_by_admin' => 'This setting is disabled by Administrator',
    'confirm_change_field_type' => 'Confirm changing the field type',
    'admin_script_backup_secret' => 'Passkey for backup execution',
    'admin_script_backup_secret_tip' => 'The backup passkey needs to be provided to start the backup. It has to be added as key parameter to script.backup.php. Example:scripts.backup.php?key=your_passkey',
    'access_level_for_roles' => 'Associated access for Roles',
    'settings_ldap_allowed_usergroup' => 'LDAP allowed user group',
    'settings_ldap_allowed_usergroup_tip' => 'Indicate the group allowed to connect to Teampass. Leave it empty is no restriction is expected regarding the group membership.',
    'error_security_level_not_reached' => 'Expected level of security not reached!',
    'error_psk_should_be_changed' => 'Due to policy change, you may need change your personal saltkey.',
    'personal_saltkey_security_level' => 'Minimum Personal Saltkey security level',
    'settings_disable_forgot_password_link' => 'Hide forgot password link on Home page',
    'newly_created_user_is_administrated_by' => 'Newly created user is administrated by',
    'open_bug_report_in_github' => 'Open issue report in Github',
    'bug_report_to_github' => 'Complete the content of the report, then copy it to clipboard and paste it in the Github new issue page',
    'create_github_bug_report' => 'Create new bug report',
    'deselect_all' => 'Deselect all',
    'request_access_to_item' => 'Request access for this item',
    'request_access_to_item_info' => 'Provide the reason why you want to access this item',
    'send_request' => 'Send request',
    'error_no_reason_of_access' => 'Please provide a reason for accessing this item.',
    'settings_ldap_and_local_authentication' => 'Local and LDAP users',
    'settings_ldap_and_local_authentication_tip' => 'Enable this option to permit both users authenticated in LDAP library or in local Teampass users list.',
    'user_profile_api_key' => 'Your API key',
    'report_a_bug' => 'Report a bug',
    'enable_http_request_login' => 'Automatic login using http header credentials',
    'duration_login_attempt' => 'Seconds till auto login:',
    'newly_created_user_role' => 'Newly created user has role',
    'at_user_updated' => 'User #user_login# was updated',
    '' => ''
);